# toasttab
## Authentication API

The authentication API returns an authentication token that you can present
when your integration client software uses other Toast APIs. For more
information about authentication, see [the Toast Developer
Guide](https://doc.toasttab.com/doc/devguide/authentication.html).

## Menus API

Returns information about a restaurant's menus.

_Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.

## Orders API

The orders API includes operations that create, update, and retrieve information about restaurant
guest orders.

Information on orders includes the checks, items ordered,
prices, payments, discounts, and customer data.

You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.

You can add items to an existing check.

The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order.
You cannot update an existing payment, but you can update the tip amount.

For delivery orders, you can update the delivery information.

You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.

The orders API supports email addresses that: 
  - Are up to 53 characters long. 
  - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @. 
  - Use the following supported characters:
    - a-z
    - A-Z
    - 0-9
    - _ (underscore)
    - International characters are not supported

## Labor API

Toast labor API is a set of REST web services that you can use to 
manage the employees, jobs, and shifts for your restaurant. The 
labor API is intended for software engineers, managers, and 
technical staff who are responsible for integrating third-party 
systems with the Toast platform.
## Restaurants API

Returns information about the configuration of restaurant.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.43
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import toastapi
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import toastapi
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import toastapi
from toastapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://ws-sandbox-api.eng.toasttab.com
# See configuration.py for a list of all supported configuration parameters.
configuration = toastapi.Configuration(
    host = "https://ws-sandbox-api.eng.toasttab.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
async with toastapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = toastapi.AlternatePaymentTypesApi(api_client)
    toast_restaurant_external_id = 'toast_restaurant_external_id_example' # str | The Toast POS GUID of the restaurant that the alternate payment type is configured for. 
    guid = 'guid_example' # str | The Toast POS GUID of the alternative form of payment.

    try:
        # Get an alternative payment type 
        api_response = await api_instance.get_alternate_payment_type_by_id(toast_restaurant_external_id, guid)
        print("The response of AlternatePaymentTypesApi->get_alternate_payment_type_by_id:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AlternatePaymentTypesApi->get_alternate_payment_type_by_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://ws-sandbox-api.eng.toasttab.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlternatePaymentTypesApi* | [**get_alternate_payment_type_by_id**](docs/AlternatePaymentTypesApi.md#get_alternate_payment_type_by_id) | **GET** /config/v2/alternatePaymentTypes/{guid} | Get an alternative payment type 
*AlternatePaymentTypesApi* | [**list_alternate_payment_types**](docs/AlternatePaymentTypesApi.md#list_alternate_payment_types) | **GET** /config/v2/alternatePaymentTypes | Get alternative payment types 
*AnalyticsApi* | [**create_guest_reporting_data_request**](docs/AnalyticsApi.md#create_guest_reporting_data_request) | **POST** /era/v1/guest/payments/{timeRange} | Post a guest reporting data request organized by payment for a specific time range
*AnalyticsApi* | [**get_guest_reporting_data**](docs/AnalyticsApi.md#get_guest_reporting_data) | **GET** /era/v1/guest/payments/{reportRequestGuid} | Get the guest reporting data organized by payment
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /authentication/v1/authentication/login | Get an authentication token
*BreakTypesApi* | [**get_break_type_by_id**](docs/BreakTypesApi.md#get_break_type_by_id) | **GET** /config/v2/breakTypes/{guid} | Get a break type 
*BreakTypesApi* | [**list_break_types**](docs/BreakTypesApi.md#list_break_types) | **GET** /config/v2/breakTypes | Get break types 
*CashDrawersApi* | [**get_cash_drawer_by_id**](docs/CashDrawersApi.md#get_cash_drawer_by_id) | **GET** /config/v2/cashDrawers/{guid} | Get a cash drawer 
*CashDrawersApi* | [**list_cash_drawers**](docs/CashDrawersApi.md#list_cash_drawers) | **GET** /config/v2/cashDrawers | Get cash drawers 
*DiningOptionsApi* | [**get_dining_option_by_id**](docs/DiningOptionsApi.md#get_dining_option_by_id) | **GET** /config/v2/diningOptions/{guid} | Get a dining option 
*DiningOptionsApi* | [**list_dining_options**](docs/DiningOptionsApi.md#list_dining_options) | **GET** /config/v2/diningOptions | Get dining options 
*DiscountsApi* | [**add_check_level_discounts**](docs/DiscountsApi.md#add_check_level_discounts) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/appliedDiscounts | Add check-level discounts
*DiscountsApi* | [**add_item_level_discounts**](docs/DiscountsApi.md#add_item_level_discounts) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/selections/{selectionGuid}/appliedDiscounts | Add item-level discounts
*DiscountsApi* | [**get_applicable_discounts**](docs/DiscountsApi.md#get_applicable_discounts) | **POST** /orders/v2/applicableDiscounts | Get applicable discounts
*DiscountsApi* | [**get_discount_by_id**](docs/DiscountsApi.md#get_discount_by_id) | **GET** /config/v2/discounts/{guid} | Get a discount
*DiscountsApi* | [**list_discounts**](docs/DiscountsApi.md#list_discounts) | **GET** /config/v2/discounts | Get discounts
*EmployeesApi* | [**add_external_identifier_to_employee**](docs/EmployeesApi.md#add_external_identifier_to_employee) | **POST** /labor/v1/employees/{employeeId}/externalId | Add an external identifier
*EmployeesApi* | [**add_or_replace_external_identifier_to_employee**](docs/EmployeesApi.md#add_or_replace_external_identifier_to_employee) | **PUT** /labor/v1/employees/{employeeId}/externalId | Add or replace an external identifier
*EmployeesApi* | [**create_employee**](docs/EmployeesApi.md#create_employee) | **POST** /labor/v1/employees | Add an employee
*EmployeesApi* | [**delete_employee**](docs/EmployeesApi.md#delete_employee) | **DELETE** /labor/v1/employees/{employeeId} | Delete an employee
*EmployeesApi* | [**get_employee_by_id**](docs/EmployeesApi.md#get_employee_by_id) | **GET** /labor/v1/employees/{employeeId} | Get information about one employee
*EmployeesApi* | [**list_employees**](docs/EmployeesApi.md#list_employees) | **GET** /labor/v1/employees | Get employees
*EmployeesApi* | [**replace_jobs_list**](docs/EmployeesApi.md#replace_jobs_list) | **PUT** /labor/v1/employees/{employeeId}/jobs | Replace a jobs list
*EmployeesApi* | [**replace_wage_overrides**](docs/EmployeesApi.md#replace_wage_overrides) | **PUT** /labor/v1/employees/{employeeId}/wageOverrides | Replace wage overrides
*EmployeesApi* | [**unarchive_employee**](docs/EmployeesApi.md#unarchive_employee) | **PUT** /labor/v1/employees/{employeeId}/unarchive | Unarchive an employee
*EmployeesApi* | [**update_employee**](docs/EmployeesApi.md#update_employee) | **PATCH** /labor/v1/employees/{employeeId} | Update employee information
*JobsApi* | [**add_external_identifier_to_job**](docs/JobsApi.md#add_external_identifier_to_job) | **POST** /labor/v1/jobs/{jobId}/externalId | Add an external identifier
*JobsApi* | [**add_or_replace_external_identifier_to_job**](docs/JobsApi.md#add_or_replace_external_identifier_to_job) | **PUT** /labor/v1/jobs/{jobId}/externalId | Add or replace an external identifier
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /labor/v1/jobs/{jobId} | Get one job
*JobsApi* | [**list_jobs**](docs/JobsApi.md#list_jobs) | **GET** /labor/v1/jobs | Get jobs
*MenuGroupsApi* | [**get_menu_group_by_id**](docs/MenuGroupsApi.md#get_menu_group_by_id) | **GET** /config/v2/menuGroups/{guid} | Get a menu group 
*MenuGroupsApi* | [**list_menu_groups**](docs/MenuGroupsApi.md#list_menu_groups) | **GET** /config/v2/menuGroups | Get menu groups 
*MenuItemsApi* | [**get_menu_item_by_id**](docs/MenuItemsApi.md#get_menu_item_by_id) | **GET** /config/v2/menuItems/{guid} | Get a menu item 
*MenuItemsApi* | [**list_menu_items**](docs/MenuItemsApi.md#list_menu_items) | **GET** /config/v2/menuItems | Get menu items 
*MenusV2Api* | [**get_menus_metadata**](docs/MenusV2Api.md#get_menus_metadata) | **GET** /menus/v2/metadata | Get menu last modified timestamp (V2)
*MenusV2Api* | [**list_menus**](docs/MenusV2Api.md#list_menus) | **GET** /menus/v2/menus | Get menus (V2)
*MenusV3Api* | [**get_menus_metadata_v3**](docs/MenusV3Api.md#get_menus_metadata_v3) | **GET** /menus/v3/metadata | Get menu last modified timestamp 
*MenusV3Api* | [**list_menus_v3**](docs/MenusV3Api.md#list_menus_v3) | **GET** /menus/v3/menus | Get menus
*NoSaleReasonsApi* | [**get_no_sale_reason_by_id**](docs/NoSaleReasonsApi.md#get_no_sale_reason_by_id) | **GET** /config/v2/noSaleReasons/{guid} | Get a no sale reason
*NoSaleReasonsApi* | [**list_no_sale_reasons**](docs/NoSaleReasonsApi.md#list_no_sale_reasons) | **GET** /config/v2/noSaleReasons | Get no sale reasons
*OrdersApi* | [**add_items_to_check**](docs/OrdersApi.md#add_items_to_check) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/selections | Add items to a check
*OrdersApi* | [**calculate_order_prices**](docs/OrdersApi.md#calculate_order_prices) | **POST** /orders/v2/prices | Get order prices
*OrdersApi* | [**create_order**](docs/OrdersApi.md#create_order) | **POST** /orders/v2/orders | Post an order
*OrdersApi* | [**get_multiple_orders**](docs/OrdersApi.md#get_multiple_orders) | **GET** /orders/v2/ordersBulk | Get multiple orders
*OrdersApi* | [**get_order_by_guid**](docs/OrdersApi.md#get_order_by_guid) | **GET** /orders/v2/orders/{guid} | Get an order
*OrdersApi* | [**list_order_identifiers**](docs/OrdersApi.md#list_order_identifiers) | **GET** /orders/v2/orders | Get order identifiers (deprecated)
*OrdersApi* | [**update_delivery_info**](docs/OrdersApi.md#update_delivery_info) | **PATCH** /orders/v2/orders/{orderGuid}/deliveryInfo | Update delivery information
*OrdersApi* | [**void_order**](docs/OrdersApi.md#void_order) | **POST** /orders/v2/orders/{orderGuid}/void | Void an order
*PaymentsApi* | [**add_payments_to_check**](docs/PaymentsApi.md#add_payments_to_check) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments | Post payments
*PaymentsApi* | [**get_payment_by_guid**](docs/PaymentsApi.md#get_payment_by_guid) | **GET** /orders/v2/payments/{guid} | Get a payment
*PaymentsApi* | [**list_payments**](docs/PaymentsApi.md#list_payments) | **GET** /orders/v2/payments | Get payment identifiers
*PaymentsApi* | [**update_tip_amount**](docs/PaymentsApi.md#update_tip_amount) | **PATCH** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments/{paymentGuid} | Update a tip amount
*PayoutReasonsApi* | [**get_payout_reason_by_id**](docs/PayoutReasonsApi.md#get_payout_reason_by_id) | **GET** /config/v2/payoutReasons/{guid} | Get payout reason by GUID
*PayoutReasonsApi* | [**list_payout_reasons**](docs/PayoutReasonsApi.md#list_payout_reasons) | **GET** /config/v2/payoutReasons | Get payout reasons
*PreModifierGroupsApi* | [**get_pre_modifier_group_by_id**](docs/PreModifierGroupsApi.md#get_pre_modifier_group_by_id) | **GET** /config/v2/preModifierGroups/{guid} | Get a pre-modifier group
*PreModifierGroupsApi* | [**list_pre_modifier_groups**](docs/PreModifierGroupsApi.md#list_pre_modifier_groups) | **GET** /config/v2/preModifierGroups | Get pre modifier groups
*PreModifiersApi* | [**list_pre_modifiers**](docs/PreModifiersApi.md#list_pre_modifiers) | **GET** /config/v2/preModifiers | Get pre-modifiers
*PriceGroupsApi* | [**get_price_group_by_id**](docs/PriceGroupsApi.md#get_price_group_by_id) | **GET** /config/v2/priceGroups/{guid} | Get price group by GUID
*PriceGroupsApi* | [**list_price_groups**](docs/PriceGroupsApi.md#list_price_groups) | **GET** /config/v2/priceGroups | Get price groups
*PrintersApi* | [**get_printer_by_id**](docs/PrintersApi.md#get_printer_by_id) | **GET** /config/v2/printers/{guid} | Get a printer 
*PrintersApi* | [**list_printers**](docs/PrintersApi.md#list_printers) | **GET** /config/v2/printers | Get printers 
*RestaurantServicesApi* | [**get_restaurant_service_by_id**](docs/RestaurantServicesApi.md#get_restaurant_service_by_id) | **GET** /config/v2/restaurantServices/{guid} | Get restaurant service by GUID
*RestaurantServicesApi* | [**list_restaurant_services**](docs/RestaurantServicesApi.md#list_restaurant_services) | **GET** /config/v2/restaurantServices | Get restaurant services
*RestaurantsApi* | [**get_restaurant_by_id**](docs/RestaurantsApi.md#get_restaurant_by_id) | **GET** /restaurants/v1/restaurants/{restaurantGUID} | Get restaurant configuration information
*RestaurantsApi* | [**list_restaurants_in_management_group**](docs/RestaurantsApi.md#list_restaurants_in_management_group) | **GET** /restaurants/v1/groups/{managementGroupGUID}/restaurants | Get restaurants in a management group
*RevenueCentersApi* | [**get_revenue_center_by_id**](docs/RevenueCentersApi.md#get_revenue_center_by_id) | **GET** /config/v2/revenueCenters/{guid} | Get revenue center by GUID
*RevenueCentersApi* | [**list_revenue_centers**](docs/RevenueCentersApi.md#list_revenue_centers) | **GET** /config/v2/revenueCenters | Get revenue centers
*ServiceAreasApi* | [**get_service_area_by_id**](docs/ServiceAreasApi.md#get_service_area_by_id) | **GET** /config/v2/serviceAreas/{guid} | Get service area by GUID
*ServiceAreasApi* | [**list_service_areas**](docs/ServiceAreasApi.md#list_service_areas) | **GET** /config/v2/serviceAreas | Get service areas
*ServiceChargesApi* | [**get_service_charge_by_id**](docs/ServiceChargesApi.md#get_service_charge_by_id) | **GET** /config/v2/serviceCharges/{guid} | Get service charge by GUID
*ServiceChargesApi* | [**list_service_charges**](docs/ServiceChargesApi.md#list_service_charges) | **GET** /config/v2/serviceCharges | Get service charges
*ShiftsApi* | [**create_shift**](docs/ShiftsApi.md#create_shift) | **POST** /labor/v1/shifts | Create a shift
*ShiftsApi* | [**delete_shift**](docs/ShiftsApi.md#delete_shift) | **DELETE** /labor/v1/shifts/{shiftId} | Delete a shift
*ShiftsApi* | [**get_shift_by_id**](docs/ShiftsApi.md#get_shift_by_id) | **GET** /labor/v1/shifts/{shiftId} | Get a shift
*ShiftsApi* | [**list_shifts**](docs/ShiftsApi.md#list_shifts) | **GET** /labor/v1/shifts | Get shifts
*ShiftsApi* | [**update_shift**](docs/ShiftsApi.md#update_shift) | **PUT** /labor/v1/shifts/{shiftId} | Update a shift
*TablesApi* | [**get_table_by_id**](docs/TablesApi.md#get_table_by_id) | **GET** /config/v2/tables/{guid} | Get a table 
*TablesApi* | [**list_tables**](docs/TablesApi.md#list_tables) | **GET** /config/v2/tables | Get tables 
*TaxRatesApi* | [**get_tax_rate_by_id**](docs/TaxRatesApi.md#get_tax_rate_by_id) | **GET** /config/v2/taxRates/{guid} | Get tax rate by GUID
*TaxRatesApi* | [**list_tax_rates**](docs/TaxRatesApi.md#list_tax_rates) | **GET** /config/v2/taxRates | Get tax rates
*TimeEntriesApi* | [**get_time_entry_by_id**](docs/TimeEntriesApi.md#get_time_entry_by_id) | **GET** /labor/v1/timeEntries/{timeEntryId} | Get one time entry
*TimeEntriesApi* | [**list_time_entries**](docs/TimeEntriesApi.md#list_time_entries) | **GET** /labor/v1/timeEntries | Get time entries
*TipWithholdingApi* | [**get_tip_withholding**](docs/TipWithholdingApi.md#get_tip_withholding) | **GET** /config/v2/tipWithholding | Get tip withholding configuration
*VoidReasonsApi* | [**get_void_reason_by_id**](docs/VoidReasonsApi.md#get_void_reason_by_id) | **GET** /config/v2/voidReasons/{guid} | Get void reason by GUID
*VoidReasonsApi* | [**list_void_reasons**](docs/VoidReasonsApi.md#list_void_reasons) | **GET** /config/v2/voidReasons | Get void reasons


## Documentation For Models

 - [Alcohol](docs/Alcohol.md)
 - [AlternatePaymentType](docs/AlternatePaymentType.md)
 - [ApplicableDiscount](docs/ApplicableDiscount.md)
 - [ApplicableDiscountsRequest](docs/ApplicableDiscountsRequest.md)
 - [AppliedDiscount](docs/AppliedDiscount.md)
 - [AppliedDiscountReason](docs/AppliedDiscountReason.md)
 - [AppliedDiscountTrigger](docs/AppliedDiscountTrigger.md)
 - [AppliedLoyaltyInfo](docs/AppliedLoyaltyInfo.md)
 - [AppliedPackagingInfo](docs/AppliedPackagingInfo.md)
 - [AppliedPackagingItem](docs/AppliedPackagingItem.md)
 - [AppliedServiceCharge](docs/AppliedServiceCharge.md)
 - [AppliedTaxRate](docs/AppliedTaxRate.md)
 - [AuthenticationRequest](docs/AuthenticationRequest.md)
 - [AuthenticationResponse](docs/AuthenticationResponse.md)
 - [AuthenticationToken](docs/AuthenticationToken.md)
 - [Availability](docs/Availability.md)
 - [BreakType](docs/BreakType.md)
 - [CashDrawer](docs/CashDrawer.md)
 - [Check](docs/Check.md)
 - [ConfigReference](docs/ConfigReference.md)
 - [ContentAdvisories](docs/ContentAdvisories.md)
 - [CurbsidePickupInfo](docs/CurbsidePickupInfo.md)
 - [Customer](docs/Customer.md)
 - [DaySchedule](docs/DaySchedule.md)
 - [Delivery](docs/Delivery.md)
 - [DeliveryInfo](docs/DeliveryInfo.md)
 - [DeliveryPaymentOptions](docs/DeliveryPaymentOptions.md)
 - [DeliveryServiceInfo](docs/DeliveryServiceInfo.md)
 - [Device](docs/Device.md)
 - [DimensionUnitOfMeasure](docs/DimensionUnitOfMeasure.md)
 - [DiningOption](docs/DiningOption.md)
 - [Discount](docs/Discount.md)
 - [Employee](docs/Employee.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [ExternalReference](docs/ExternalReference.md)
 - [General](docs/General.md)
 - [GiftCardInfo](docs/GiftCardInfo.md)
 - [GuestReportingDataInProgress](docs/GuestReportingDataInProgress.md)
 - [GuestReportingDataRequest](docs/GuestReportingDataRequest.md)
 - [GuestReportingDataResponse](docs/GuestReportingDataResponse.md)
 - [Hours](docs/Hours.md)
 - [ItemTag](docs/ItemTag.md)
 - [Job](docs/Job.md)
 - [JobWageOverride](docs/JobWageOverride.md)
 - [Location](docs/Location.md)
 - [LoyaltyDetails](docs/LoyaltyDetails.md)
 - [MarketplaceFacilitatorTaxInfo](docs/MarketplaceFacilitatorTaxInfo.md)
 - [Menu](docs/Menu.md)
 - [MenuGroup](docs/MenuGroup.md)
 - [MenuItem](docs/MenuItem.md)
 - [Metadata](docs/Metadata.md)
 - [ModifierGroup](docs/ModifierGroup.md)
 - [ModifierOption](docs/ModifierOption.md)
 - [ModifierOptionTaxInfo](docs/ModifierOptionTaxInfo.md)
 - [NoSaleReason](docs/NoSaleReason.md)
 - [OnlineOrdering](docs/OnlineOrdering.md)
 - [Order](docs/Order.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [Payment](docs/Payment.md)
 - [PaymentOptions](docs/PaymentOptions.md)
 - [PayoutReason](docs/PayoutReason.md)
 - [Portion](docs/Portion.md)
 - [PreModifier](docs/PreModifier.md)
 - [PreModifierGroup](docs/PreModifierGroup.md)
 - [PrepTimes](docs/PrepTimes.md)
 - [PriceGroup](docs/PriceGroup.md)
 - [PricingRules](docs/PricingRules.md)
 - [Printer](docs/Printer.md)
 - [Refund](docs/Refund.md)
 - [RefundDetails](docs/RefundDetails.md)
 - [Restaurant](docs/Restaurant.md)
 - [RestaurantBasic](docs/RestaurantBasic.md)
 - [RestaurantInfo](docs/RestaurantInfo.md)
 - [RestaurantService](docs/RestaurantService.md)
 - [RevenueCenter](docs/RevenueCenter.md)
 - [SalesCategory](docs/SalesCategory.md)
 - [Schedule](docs/Schedule.md)
 - [Schedules](docs/Schedules.md)
 - [Selection](docs/Selection.md)
 - [SequencePrice](docs/SequencePrice.md)
 - [Service](docs/Service.md)
 - [ServiceArea](docs/ServiceArea.md)
 - [ServiceCharge](docs/ServiceCharge.md)
 - [ServiceChargeCriteria](docs/ServiceChargeCriteria.md)
 - [Shift](docs/Shift.md)
 - [SizeSequencePricingRule](docs/SizeSequencePricingRule.md)
 - [Table](docs/Table.md)
 - [TakeoutPaymentOptions](docs/TakeoutPaymentOptions.md)
 - [TaxRate](docs/TaxRate.md)
 - [TimeEntry](docs/TimeEntry.md)
 - [TimeEntryBreak](docs/TimeEntryBreak.md)
 - [TimeRange](docs/TimeRange.md)
 - [TimeSpecificPrice](docs/TimeSpecificPrice.md)
 - [TipWithholding](docs/TipWithholding.md)
 - [ToastReference](docs/ToastReference.md)
 - [URLs](docs/URLs.md)
 - [UpdateDeliveryInfoRequest](docs/UpdateDeliveryInfoRequest.md)
 - [UpdatePaymentRequest](docs/UpdatePaymentRequest.md)
 - [VoidInformation](docs/VoidInformation.md)
 - [VoidOrderRequest](docs/VoidOrderRequest.md)
 - [VoidOrderRequestSelections](docs/VoidOrderRequestSelections.md)
 - [VoidReason](docs/VoidReason.md)
 - [WeekSchedule](docs/WeekSchedule.md)
 - [WeightUnitOfMeasure](docs/WeightUnitOfMeasure.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth2"></a>
### oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **restaurants:read**: Allows reading from the restaurants API.
 - **labor:read**: Allows reading from the labor API.
 - **orders:read**: Allows reading from the orders API.
 - **orders:write**: Allows writing to the orders API.
 - **payments:read**: Allows reading from the payments API.
 - **payments:write**: Allows writing to the payments API.
 - **discounts:read**: Allows reading from the discounts API.
 - **discounts:write**: Allows writing to the discounts API.
 - **menus.channel:read**: Allows reading from the menus API.
 - **menus:read**: Allows reading from menus API V2.
 - **config:read**: Allows reading from the configuration API.


## Author




