# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.job import Job

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class JobsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def add_external_identifier_to_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Add an external identifier

        Adds an external identifier for an existing job. Include the  string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request. The Toast platform uses this external  identifier as one of the unique, persistent identifiers for a  job record. 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_external_identifier_to_job_with_http_info(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Add an external identifier

        Adds an external identifier for an existing job. Include the  string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request. The Toast platform uses this external  identifier as one of the unique, persistent identifiers for a  job record. 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_external_identifier_to_job_without_preload_content(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add an external identifier

        Adds an external identifier for an existing job. Include the  string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request. The Toast platform uses this external  identifier as one of the unique, persistent identifiers for a  job record. 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_external_identifier_to_job_serialize(
        self,
        job_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['jobId'] = job_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/labor/v1/jobs/{jobId}/externalId',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_or_replace_external_identifier_to_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing job.  Include the string value of the new external identifier in the  message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for a job record. _Changing the  external identifier for an existing job might affect reporting  and other Toast platform functions that select jobs using the  `externalId` value._ 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_or_replace_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_or_replace_external_identifier_to_job_with_http_info(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing job.  Include the string value of the new external identifier in the  message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for a job record. _Changing the  external identifier for an existing job might affect reporting  and other Toast platform functions that select jobs using the  `externalId` value._ 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_or_replace_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_or_replace_external_identifier_to_job_without_preload_content(
        self,
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier of the job  record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing job.  Include the string value of the new external identifier in the  message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for a job record. _Changing the  external identifier for an existing job might affect reporting  and other Toast platform functions that select jobs using the  `externalId` value._ 

        :param job_id: The Toast platform GUID or external identifier of the job  record.  (required)
        :type job_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the job  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_or_replace_external_identifier_to_job_serialize(
            job_id=job_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_or_replace_external_identifier_to_job_serialize(
        self,
        job_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['jobId'] = job_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/labor/v1/jobs/{jobId}/externalId',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_job_by_id(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  job. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Get one job

        Returns a `Job` object containing information about one  employee job at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_id: The Toast platform GUID or an external identifier for the  job.  (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_job_by_id_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  job. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Get one job

        Returns a `Job` object containing information about one  employee job at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_id: The Toast platform GUID or an external identifier for the  job.  (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_job_by_id_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  job. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get one job

        Returns a `Job` object containing information about one  employee job at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_id: The Toast platform GUID or an external identifier for the  job.  (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_job_by_id_serialize(
        self,
        toast_restaurant_external_id,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['jobId'] = job_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/jobs/{jobId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_jobs(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_ids: Annotated[Optional[List[StrictStr]], Field(description="An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Job]:
        """Get jobs

        Returns an array of `Job` objects containing information about  the employee jobs configured at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_ids: An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. 
        :type job_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_jobs_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_ids=job_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Job]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_jobs_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_ids: Annotated[Optional[List[StrictStr]], Field(description="An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Job]]:
        """Get jobs

        Returns an array of `Job` objects containing information about  the employee jobs configured at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_ids: An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. 
        :type job_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_jobs_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_ids=job_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Job]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_jobs_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        job_ids: Annotated[Optional[List[StrictStr]], Field(description="An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get jobs

        Returns an array of `Job` objects containing information about  the employee jobs configured at a restaurant. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param job_ids: An optional array of one or more job identifiers, either  the Toast platform GUID or an external identifier assigned  by the client. 100 max. If not provided, all jobs known to  the Toast platform for this restaurant will be returned. 
        :type job_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_jobs_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            job_ids=job_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Job]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_jobs_serialize(
        self,
        toast_restaurant_external_id,
        job_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'jobIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if job_ids is not None:
            
            _query_params.append(('jobIds', job_ids))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


