# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from toastapi.models.external_reference import ExternalReference
from toastapi.models.toast_reference import ToastReference
from typing import Optional, Set
from typing_extensions import Self

class ApplicableDiscount(BaseModel):
    """
    A wrapper object that contains information about a discount that you can apply to an order, and which checks or menu item selections you can apply it to. 
    """ # noqa: E501
    discount: ToastReference
    applicable_checks: Optional[List[ExternalReference]] = Field(default=None, description="If the discount is applicable to a check, this value holds an array of `ExternalReference` objects containing the identifiers of the checks. ", alias="applicableChecks")
    applicable_selections: Optional[List[ExternalReference]] = Field(default=None, description="If the discount is applicable to a menu item selection, this value holds an array of `ExternalReference` objects containing the identifiers of the menu items. ", alias="applicableSelections")
    __properties: ClassVar[List[str]] = ["discount", "applicableChecks", "applicableSelections"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicableDiscount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_checks (list)
        _items = []
        if self.applicable_checks:
            for _item_applicable_checks in self.applicable_checks:
                if _item_applicable_checks:
                    _items.append(_item_applicable_checks.to_dict())
            _dict['applicableChecks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_selections (list)
        _items = []
        if self.applicable_selections:
            for _item_applicable_selections in self.applicable_selections:
                if _item_applicable_selections:
                    _items.append(_item_applicable_selections.to_dict())
            _dict['applicableSelections'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicableDiscount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "discount": ToastReference.from_dict(obj["discount"]) if obj.get("discount") is not None else None,
            "applicableChecks": [ExternalReference.from_dict(_item) for _item in obj["applicableChecks"]] if obj.get("applicableChecks") is not None else None,
            "applicableSelections": [ExternalReference.from_dict(_item) for _item in obj["applicableSelections"]] if obj.get("applicableSelections") is not None else None
        })
        return _obj


