# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from toastapi.models.applied_discount import AppliedDiscount
from toastapi.models.applied_loyalty_info import AppliedLoyaltyInfo
from toastapi.models.applied_service_charge import AppliedServiceCharge
from toastapi.models.customer import Customer
from toastapi.models.device import Device
from toastapi.models.external_reference import ExternalReference
from toastapi.models.payment import Payment
from toastapi.models.selection import Selection
from typing import Optional, Set
from typing_extensions import Self

class Check(BaseModel):
    """
    Represents a single check within an order.
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    created_date: Optional[datetime] = Field(default=None, description="The date and time that the Toast platform received the check.", alias="createdDate")
    opened_date: Optional[datetime] = Field(default=None, description="The date on which this check was opened. If not specified, it is set to the current system time.", alias="openedDate")
    closed_date: Optional[datetime] = Field(default=None, description="The most recent date on which this check's payment status was set to `CLOSED`.", alias="closedDate")
    modified_date: Optional[datetime] = Field(default=None, description="The most recent date on which this check was modified.", alias="modifiedDate")
    deleted_date: Optional[datetime] = Field(default=None, description="The date on which this check was deleted.  `deletedDate` is only applicable when `deleted` is true.  If `deleted` is false, then `deletedDate` is set to the UNIX epoch, `1970-01-01T00:00:00.000+0000`. ", alias="deletedDate")
    deleted: Optional[StrictBool] = Field(default=None, description="Set to `true` if this check was deleted.")
    selections: List[Selection]
    customer: Optional[Customer] = None
    applied_loyalty_info: Optional[AppliedLoyaltyInfo] = Field(default=None, alias="appliedLoyaltyInfo")
    tax_exempt: Optional[StrictBool] = Field(default=False, description="Set to `true` if this check is tax exempt.", alias="taxExempt")
    display_number: Optional[StrictStr] = Field(default=None, description="Generally starts at one each day and counts up. The Toast platform fills this in if it is not specified when the order is POSTed. Not guaranteed to be unique.", alias="displayNumber")
    applied_service_charges: Optional[List[AppliedServiceCharge]] = Field(default=None, description="Any restaurant-configured service charges that applied to this check.", alias="appliedServiceCharges")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total calculated price of the check including discounts and service charges. The `amount` does not include gratuity or taxes. Response only.")
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The calculated tax amount. Includes service charge and item level taxes. Response only.", alias="taxAmount")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total calculated price of this check including discounts and taxes. Not affected by refunds.", alias="totalAmount")
    payments: Optional[Annotated[List[Payment], Field(min_length=0)]] = Field(default=None, description="Payments made on this check.")
    tab_name: Optional[StrictStr] = Field(default=None, description="The name of the tab on this check. This displays on the KDS (Kitchen Display System) for pending orders.  The `tabName` value can contain up to 255 characters. ", alias="tabName")
    payment_status: Optional[StrictStr] = Field(default=None, description="The payment status of this check.  Valid values:  * `OPEN` - There is an outstanding balance.  * `PAID` - A credit card payment was applied, but the tip has not been adjusted.  * `CLOSED`  - There is no remaining amount due on this check. For credit card payments, the payment has been adjusted to reflect the tip. Toast does not prevent a `CLOSED` check from transitioning back to `OPEN` or `PAID`.  Response only. ", alias="paymentStatus")
    applied_discounts: Optional[Annotated[List[AppliedDiscount], Field(min_length=0)]] = Field(default=None, description="The discounts applied to this check. In a `POST` request, only one `appliedDiscount` is allowed per check.", alias="appliedDiscounts")
    voided: Optional[StrictBool] = Field(default=None, description="True if this check is voided. Response only.")
    void_date: Optional[datetime] = Field(default=None, description="The date when this check was voided. Response only.", alias="voidDate")
    void_business_date: Optional[StrictInt] = Field(default=None, description="The business date (yyyyMMdd) on which this check was voided. Response only.", alias="voidBusinessDate")
    paid_date: Optional[datetime] = Field(default=None, description="The most recent date when this check received payment. If not specified when `POST`ing, it is set to the current system time.", alias="paidDate")
    created_device: Optional[Device] = Field(default=None, alias="createdDevice")
    last_modified_device: Optional[Device] = Field(default=None, alias="lastModifiedDevice")
    duration: Optional[StrictInt] = Field(default=None, description="The number of seconds between creation and payment. Response only.")
    opened_by: Optional[ExternalReference] = Field(default=None, alias="openedBy")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "createdDate", "openedDate", "closedDate", "modifiedDate", "deletedDate", "deleted", "selections", "customer", "appliedLoyaltyInfo", "taxExempt", "displayNumber", "appliedServiceCharges", "amount", "taxAmount", "totalAmount", "payments", "tabName", "paymentStatus", "appliedDiscounts", "voided", "voidDate", "voidBusinessDate", "paidDate", "createdDevice", "lastModifiedDevice", "duration", "openedBy"]

    @field_validator('payment_status')
    def payment_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OPEN', 'PAID', 'CLOSED']):
            raise ValueError("must be one of enum values ('OPEN', 'PAID', 'CLOSED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Check from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selections (list)
        _items = []
        if self.selections:
            for _item_selections in self.selections:
                if _item_selections:
                    _items.append(_item_selections.to_dict())
            _dict['selections'] = _items
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of applied_loyalty_info
        if self.applied_loyalty_info:
            _dict['appliedLoyaltyInfo'] = self.applied_loyalty_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in applied_service_charges (list)
        _items = []
        if self.applied_service_charges:
            for _item_applied_service_charges in self.applied_service_charges:
                if _item_applied_service_charges:
                    _items.append(_item_applied_service_charges.to_dict())
            _dict['appliedServiceCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applied_discounts (list)
        _items = []
        if self.applied_discounts:
            for _item_applied_discounts in self.applied_discounts:
                if _item_applied_discounts:
                    _items.append(_item_applied_discounts.to_dict())
            _dict['appliedDiscounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of created_device
        if self.created_device:
            _dict['createdDevice'] = self.created_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_device
        if self.last_modified_device:
            _dict['lastModifiedDevice'] = self.last_modified_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of opened_by
        if self.opened_by:
            _dict['openedBy'] = self.opened_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Check from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "createdDate": obj.get("createdDate"),
            "openedDate": obj.get("openedDate"),
            "closedDate": obj.get("closedDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "deletedDate": obj.get("deletedDate"),
            "deleted": obj.get("deleted"),
            "selections": [Selection.from_dict(_item) for _item in obj["selections"]] if obj.get("selections") is not None else None,
            "customer": Customer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "appliedLoyaltyInfo": AppliedLoyaltyInfo.from_dict(obj["appliedLoyaltyInfo"]) if obj.get("appliedLoyaltyInfo") is not None else None,
            "taxExempt": obj.get("taxExempt") if obj.get("taxExempt") is not None else False,
            "displayNumber": obj.get("displayNumber"),
            "appliedServiceCharges": [AppliedServiceCharge.from_dict(_item) for _item in obj["appliedServiceCharges"]] if obj.get("appliedServiceCharges") is not None else None,
            "amount": obj.get("amount"),
            "taxAmount": obj.get("taxAmount"),
            "totalAmount": obj.get("totalAmount"),
            "payments": [Payment.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "tabName": obj.get("tabName"),
            "paymentStatus": obj.get("paymentStatus"),
            "appliedDiscounts": [AppliedDiscount.from_dict(_item) for _item in obj["appliedDiscounts"]] if obj.get("appliedDiscounts") is not None else None,
            "voided": obj.get("voided"),
            "voidDate": obj.get("voidDate"),
            "voidBusinessDate": obj.get("voidBusinessDate"),
            "paidDate": obj.get("paidDate"),
            "createdDevice": Device.from_dict(obj["createdDevice"]) if obj.get("createdDevice") is not None else None,
            "lastModifiedDevice": Device.from_dict(obj["lastModifiedDevice"]) if obj.get("lastModifiedDevice") is not None else None,
            "duration": obj.get("duration"),
            "openedBy": ExternalReference.from_dict(obj["openedBy"]) if obj.get("openedBy") is not None else None
        })
        return _obj


