# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PreModifier(BaseModel):
    """
    Information about a pre-modifier configured for this restaurant. 
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A descriptive name for this pre-modifier, for example, \"NO\" or \"EXTRA\". ")
    guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this pre-modifier group, assigned by the Toast POS system. ")
    multi_location_id: Optional[StrictStr] = Field(default=None, description="An identifier that is used to identify and consolidate menu entities that are versions of each other.  `multiLocationId` replaces `masterId`. `multiLocationId` and `masterId` always have the same value.  Menu entities can be versioned. Those versions can be assigned to specific restaurant locations, or groups of locations, in a management group. For example, you could have two versions of a burger, one for a Boston location and another for a New York City location. Versioned menu entities share the majority of, but not all of, their data. For example, the Boston version is called the Minuteman Burger and has pickles, while the New York City version is called the Empire Burger and does not.  You use the `multiLocationId` to identify menu entities that are versions of each other. To continue the example above, the Minuteman Burger in the JSON returned for the Boston location has the same `multilocationId` as the Empire Burger in the JSON returned for the New York City location. These matching `multlocationId` values indicate that the two items are related versions of the same item. In Toast reports, this allows a restaurant to track sales of the burger across both locations. ", alias="multiLocationId")
    fixed_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="An optional fixed price for this pre-modifier. The fixed price is added to the cost of the modifier option that the pre-modifier is applied to.  A PreModifier object has two optional values, `fixedPrice` and `multiplicationFactor`, that both alter the price of a modifier option when the pre-modifier is applied to it. However, these values cannot be used at the same time. If you specify a `fixedPrice` value for a premodifier, then `multiplicationFactor` is null. If you specify a `multiplicationFactor` for a pre-modifier, then `fixedPrice` is null. If you choose not to assign either a fixed price or a multiplication factor to a pre-modifier, then the `fixedPrice` value is 0 and the `multiplicationFactor` is null. ", alias="fixedPrice")
    multiplication_factor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="An optional number that specifies how much the cost of a modifier option is multiplied by when this pre-modifier is applied to it. For example, an EXTRA pre-modifier option could specify a `multiplicationFactor` of 1.5 to indicate that adding extra cheese to a menu item costs one and a half times the regular price of the cheese modifier option.  A PreModifier object has two optional values, `fixedPrice` and `multiplicationFactor`, that both alter the price of a modifier option when the pre-modifier is applied to it. However, these values cannot be used at the same time. If you specify a `fixedPrice` value for a premodifier, then `multiplicationFactor` is null. If you specify a `multiplicationFactor` for a premodifier, then `fixedPrice` is null. If you choose not to assign either a fixed price or a multiplication factor to a pre-modifier, then the `fixedPrice` value is 0 and the `multiplicationFactor` is null. ", alias="multiplicationFactor")
    display_mode: Optional[StrictStr] = Field(default=None, description="The display mode for this pre-modifier option. ", alias="displayMode")
    __properties: ClassVar[List[str]] = ["name", "guid", "multiLocationId", "fixedPrice", "multiplicationFactor", "displayMode"]

    @field_validator('display_mode')
    def display_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PREFIX', 'SUFFIX']):
            raise ValueError("must be one of enum values ('PREFIX', 'SUFFIX')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PreModifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if fixed_price (nullable) is None
        # and model_fields_set contains the field
        if self.fixed_price is None and "fixed_price" in self.model_fields_set:
            _dict['fixedPrice'] = None

        # set to None if multiplication_factor (nullable) is None
        # and model_fields_set contains the field
        if self.multiplication_factor is None and "multiplication_factor" in self.model_fields_set:
            _dict['multiplicationFactor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PreModifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "guid": obj.get("guid"),
            "multiLocationId": obj.get("multiLocationId"),
            "fixedPrice": obj.get("fixedPrice"),
            "multiplicationFactor": obj.get("multiplicationFactor"),
            "displayMode": obj.get("displayMode")
        })
        return _obj


