# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
import time

from Tea.exceptions import TeaException, UnretryableException
from Tea.request import TeaRequest
from Tea.core import TeaCore
from antchain_alipay_util.antchain_utils import AntchainUtils
from typing import Dict

from antchain_sdk_blockchain import models as blockchain_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_tea_util import models as util_models
from alibabacloud_rpc_util.client import Client as RPCUtilClient


class Client:
    _endpoint: str = None
    _region_id: str = None
    _access_key_id: str = None
    _access_key_secret: str = None
    _protocol: str = None
    _user_agent: str = None
    _read_timeout: int = None
    _connect_timeout: int = None
    _http_proxy: str = None
    _https_proxy: str = None
    _socks_5proxy: str = None
    _socks_5net_work: str = None
    _no_proxy: str = None
    _max_idle_conns: int = None
    _security_token: str = None
    _max_idle_time_millis: int = None
    _keep_alive_duration_millis: int = None
    _max_requests: int = None
    _max_requests_per_host: int = None

    def __init__(
        self, 
        config: blockchain_models.Config,
    ):
        """
        Init client with Config
        @param config: config contains the necessary information to create a client
        """
        if UtilClient.is_unset(config):
            raise TeaException({
                'code': 'ParameterMissing',
                'message': "'config' can not be unset"
            })
        self._access_key_id = config.access_key_id
        self._access_key_secret = config.access_key_secret
        self._security_token = config.security_token
        self._endpoint = config.endpoint
        self._protocol = config.protocol
        self._user_agent = config.user_agent
        self._read_timeout = UtilClient.default_number(config.read_timeout, 20000)
        self._connect_timeout = UtilClient.default_number(config.connect_timeout, 20000)
        self._http_proxy = config.http_proxy
        self._https_proxy = config.https_proxy
        self._no_proxy = config.no_proxy
        self._socks_5proxy = config.socks_5proxy
        self._socks_5net_work = config.socks_5net_work
        self._max_idle_conns = UtilClient.default_number(config.max_idle_conns, 60000)
        self._max_idle_time_millis = UtilClient.default_number(config.max_idle_time_millis, 5)
        self._keep_alive_duration_millis = UtilClient.default_number(config.keep_alive_duration_millis, 5000)
        self._max_requests = UtilClient.default_number(config.max_requests, 100)
        self._max_requests_per_host = UtilClient.default_number(config.max_requests_per_host, 100)

    def do_request(
        self,
        version: str,
        action: str,
        protocol: str,
        method: str,
        pathname: str,
        request: dict,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> dict:
        """
        Encapsulate the request and invoke the network
        @param action: api name
        @param protocol: http or https
        @param method: e.g. GET
        @param pathname: pathname of every api
        @param request: which contains request params
        @param runtime: which controls some details of call api, such as retry times
        @return: the response
        """
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': UtilClient.default_number(runtime.read_timeout, self._read_timeout),
            'connectTimeout': UtilClient.default_number(runtime.connect_timeout, self._connect_timeout),
            'httpProxy': UtilClient.default_string(runtime.http_proxy, self._http_proxy),
            'httpsProxy': UtilClient.default_string(runtime.https_proxy, self._https_proxy),
            'noProxy': UtilClient.default_string(runtime.no_proxy, self._no_proxy),
            'maxIdleConns': UtilClient.default_number(runtime.max_idle_conns, self._max_idle_conns),
            'maxIdleTimeMillis': self._max_idle_time_millis,
            'keepAliveDuration': self._keep_alive_duration_millis,
            'maxRequests': self._max_requests,
            'maxRequestsPerHost': self._max_requests_per_host,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl,
            # 数据授权服务审批流程节点结构体
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                _request.protocol = UtilClient.default_string(self._protocol, protocol)
                _request.method = method
                _request.pathname = pathname
                _request.query = {
                    'method': action,
                    'version': version,
                    'sign_type': 'HmacSHA1',
                    'req_time': AntchainUtils.get_timestamp(),
                    'req_msg_id': AntchainUtils.get_nonce(),
                    'access_key': self._access_key_id,
                    'base_sdk_version': 'TeaSDK-2.0',
                    'sdk_version': '1.28.54',
                    '_prod_code': 'BLOCKCHAIN',
                    '_prod_channel': 'undefined'
                }
                if not UtilClient.empty(self._security_token):
                    _request.query['security_token'] = self._security_token
                _request.headers = TeaCore.merge({
                    'host': UtilClient.default_string(self._endpoint, 'openapi.antchain.antgroup.com'),
                    'user-agent': UtilClient.get_user_agent(self._user_agent)
                }, headers)
                tmp = UtilClient.anyify_map_value(RPCUtilClient.query(request))
                _request.body = UtilClient.to_form_string(tmp)
                _request.headers['content-type'] = 'application/x-www-form-urlencoded'
                signed_param = TeaCore.merge(_request.query,
                    RPCUtilClient.query(request))
                _request.query['sign'] = AntchainUtils.get_signature(signed_param, self._access_key_secret)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                raw = UtilClient.read_as_string(_response.body)
                obj = UtilClient.parse_json(raw)
                res = UtilClient.assert_as_map(obj)
                resp = UtilClient.assert_as_map(res.get('response'))
                if AntchainUtils.has_error(raw, self._access_key_secret):
                    raise TeaException({
                        'message': resp.get('result_msg'),
                        'data': resp,
                        'code': resp.get('result_code')
                    })
                return resp
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def do_request_async(
        self,
        version: str,
        action: str,
        protocol: str,
        method: str,
        pathname: str,
        request: dict,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> dict:
        """
        Encapsulate the request and invoke the network
        @param action: api name
        @param protocol: http or https
        @param method: e.g. GET
        @param pathname: pathname of every api
        @param request: which contains request params
        @param runtime: which controls some details of call api, such as retry times
        @return: the response
        """
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': UtilClient.default_number(runtime.read_timeout, self._read_timeout),
            'connectTimeout': UtilClient.default_number(runtime.connect_timeout, self._connect_timeout),
            'httpProxy': UtilClient.default_string(runtime.http_proxy, self._http_proxy),
            'httpsProxy': UtilClient.default_string(runtime.https_proxy, self._https_proxy),
            'noProxy': UtilClient.default_string(runtime.no_proxy, self._no_proxy),
            'maxIdleConns': UtilClient.default_number(runtime.max_idle_conns, self._max_idle_conns),
            'maxIdleTimeMillis': self._max_idle_time_millis,
            'keepAliveDuration': self._keep_alive_duration_millis,
            'maxRequests': self._max_requests,
            'maxRequestsPerHost': self._max_requests_per_host,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl,
            # 数据授权服务审批流程节点结构体
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                _request.protocol = UtilClient.default_string(self._protocol, protocol)
                _request.method = method
                _request.pathname = pathname
                _request.query = {
                    'method': action,
                    'version': version,
                    'sign_type': 'HmacSHA1',
                    'req_time': AntchainUtils.get_timestamp(),
                    'req_msg_id': AntchainUtils.get_nonce(),
                    'access_key': self._access_key_id,
                    'base_sdk_version': 'TeaSDK-2.0',
                    'sdk_version': '1.28.54',
                    '_prod_code': 'BLOCKCHAIN',
                    '_prod_channel': 'undefined'
                }
                if not UtilClient.empty(self._security_token):
                    _request.query['security_token'] = self._security_token
                _request.headers = TeaCore.merge({
                    'host': UtilClient.default_string(self._endpoint, 'openapi.antchain.antgroup.com'),
                    'user-agent': UtilClient.get_user_agent(self._user_agent)
                }, headers)
                tmp = UtilClient.anyify_map_value(RPCUtilClient.query(request))
                _request.body = UtilClient.to_form_string(tmp)
                _request.headers['content-type'] = 'application/x-www-form-urlencoded'
                signed_param = TeaCore.merge(_request.query,
                    RPCUtilClient.query(request))
                _request.query['sign'] = AntchainUtils.get_signature(signed_param, self._access_key_secret)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                raw = await UtilClient.read_as_string_async(_response.body)
                obj = UtilClient.parse_json(raw)
                res = UtilClient.assert_as_map(obj)
                resp = UtilClient.assert_as_map(res.get('response'))
                if AntchainUtils.has_error(raw, self._access_key_secret):
                    raise TeaException({
                        'message': resp.get('result_msg'),
                        'data': resp,
                        'code': resp.get('result_code')
                    })
                return resp
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def start_account_mapping(
        self,
        request: blockchain_models.StartAccountMappingRequest,
    ) -> blockchain_models.StartAccountMappingResponse:
        """
        Description: 将用户自有账户导入到链上
        Summary: 自有账户映射到链上
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_account_mapping_ex(request, headers, runtime)

    async def start_account_mapping_async(
        self,
        request: blockchain_models.StartAccountMappingRequest,
    ) -> blockchain_models.StartAccountMappingResponse:
        """
        Description: 将用户自有账户导入到链上
        Summary: 自有账户映射到链上
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_account_mapping_ex_async(request, headers, runtime)

    def start_account_mapping_ex(
        self,
        request: blockchain_models.StartAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAccountMappingResponse:
        """
        Description: 将用户自有账户导入到链上
        Summary: 自有账户映射到链上
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAccountMappingResponse(),
            self.do_request('1.0', 'baas.account.mapping.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_account_mapping_ex_async(
        self,
        request: blockchain_models.StartAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAccountMappingResponse:
        """
        Description: 将用户自有账户导入到链上
        Summary: 自有账户映射到链上
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAccountMappingResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_account_mapping(
        self,
        request: blockchain_models.BatchcreateAccountMappingRequest,
    ) -> blockchain_models.BatchcreateAccountMappingResponse:
        """
        Description: 自有账户到链上账户的批量映射接口
        Summary: 自有账户到链上账户的批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_account_mapping_ex(request, headers, runtime)

    async def batchcreate_account_mapping_async(
        self,
        request: blockchain_models.BatchcreateAccountMappingRequest,
    ) -> blockchain_models.BatchcreateAccountMappingResponse:
        """
        Description: 自有账户到链上账户的批量映射接口
        Summary: 自有账户到链上账户的批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_account_mapping_ex_async(request, headers, runtime)

    def batchcreate_account_mapping_ex(
        self,
        request: blockchain_models.BatchcreateAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAccountMappingResponse:
        """
        Description: 自有账户到链上账户的批量映射接口
        Summary: 自有账户到链上账户的批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAccountMappingResponse(),
            self.do_request('1.0', 'baas.account.mapping.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_account_mapping_ex_async(
        self,
        request: blockchain_models.BatchcreateAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAccountMappingResponse:
        """
        Description: 自有账户到链上账户的批量映射接口
        Summary: 自有账户到链上账户的批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAccountMappingResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_account_signature(
        self,
        request: blockchain_models.StartAccountSignatureRequest,
    ) -> blockchain_models.StartAccountSignatureResponse:
        """
        Description: 为用户生成签名的接口
        Summary: 为用户生成签名
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_account_signature_ex(request, headers, runtime)

    async def start_account_signature_async(
        self,
        request: blockchain_models.StartAccountSignatureRequest,
    ) -> blockchain_models.StartAccountSignatureResponse:
        """
        Description: 为用户生成签名的接口
        Summary: 为用户生成签名
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_account_signature_ex_async(request, headers, runtime)

    def start_account_signature_ex(
        self,
        request: blockchain_models.StartAccountSignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAccountSignatureResponse:
        """
        Description: 为用户生成签名的接口
        Summary: 为用户生成签名
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAccountSignatureResponse(),
            self.do_request('1.0', 'baas.account.signature.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_account_signature_ex_async(
        self,
        request: blockchain_models.StartAccountSignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAccountSignatureResponse:
        """
        Description: 为用户生成签名的接口
        Summary: 为用户生成签名
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAccountSignatureResponse(),
            await self.do_request_async('1.0', 'baas.account.signature.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_account_mappingresult(
        self,
        request: blockchain_models.QueryAccountMappingresultRequest,
    ) -> blockchain_models.QueryAccountMappingresultResponse:
        """
        Description: 查询批量映射结果的接口
        Summary: 查询批量映射的结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_account_mappingresult_ex(request, headers, runtime)

    async def query_account_mappingresult_async(
        self,
        request: blockchain_models.QueryAccountMappingresultRequest,
    ) -> blockchain_models.QueryAccountMappingresultResponse:
        """
        Description: 查询批量映射结果的接口
        Summary: 查询批量映射的结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_account_mappingresult_ex_async(request, headers, runtime)

    def query_account_mappingresult_ex(
        self,
        request: blockchain_models.QueryAccountMappingresultRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAccountMappingresultResponse:
        """
        Description: 查询批量映射结果的接口
        Summary: 查询批量映射的结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAccountMappingresultResponse(),
            self.do_request('1.0', 'baas.account.mappingresult.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_account_mappingresult_ex_async(
        self,
        request: blockchain_models.QueryAccountMappingresultRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAccountMappingresultResponse:
        """
        Description: 查询批量映射结果的接口
        Summary: 查询批量映射的结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAccountMappingresultResponse(),
            await self.do_request_async('1.0', 'baas.account.mappingresult.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_account_mapping(
        self,
        request: blockchain_models.QueryAccountMappingRequest,
    ) -> blockchain_models.QueryAccountMappingResponse:
        """
        Description: 查询商户下账户在链上账号映射情况
        Summary: 单个查询用户映射情况信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_account_mapping_ex(request, headers, runtime)

    async def query_account_mapping_async(
        self,
        request: blockchain_models.QueryAccountMappingRequest,
    ) -> blockchain_models.QueryAccountMappingResponse:
        """
        Description: 查询商户下账户在链上账号映射情况
        Summary: 单个查询用户映射情况信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_account_mapping_ex_async(request, headers, runtime)

    def query_account_mapping_ex(
        self,
        request: blockchain_models.QueryAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAccountMappingResponse:
        """
        Description: 查询商户下账户在链上账号映射情况
        Summary: 单个查询用户映射情况信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAccountMappingResponse(),
            self.do_request('1.0', 'baas.account.mapping.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_account_mapping_ex_async(
        self,
        request: blockchain_models.QueryAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAccountMappingResponse:
        """
        Description: 查询商户下账户在链上账号映射情况
        Summary: 单个查询用户映射情况信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAccountMappingResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchquery_account_mapping(
        self,
        request: blockchain_models.BatchqueryAccountMappingRequest,
    ) -> blockchain_models.BatchqueryAccountMappingResponse:
        """
        Description: 批量查询商户下已映射的账户信息
        Summary: 批量查询商户下已映射的账户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchquery_account_mapping_ex(request, headers, runtime)

    async def batchquery_account_mapping_async(
        self,
        request: blockchain_models.BatchqueryAccountMappingRequest,
    ) -> blockchain_models.BatchqueryAccountMappingResponse:
        """
        Description: 批量查询商户下已映射的账户信息
        Summary: 批量查询商户下已映射的账户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchquery_account_mapping_ex_async(request, headers, runtime)

    def batchquery_account_mapping_ex(
        self,
        request: blockchain_models.BatchqueryAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryAccountMappingResponse:
        """
        Description: 批量查询商户下已映射的账户信息
        Summary: 批量查询商户下已映射的账户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryAccountMappingResponse(),
            self.do_request('1.0', 'baas.account.mapping.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchquery_account_mapping_ex_async(
        self,
        request: blockchain_models.BatchqueryAccountMappingRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryAccountMappingResponse:
        """
        Description: 批量查询商户下已映射的账户信息
        Summary: 批量查询商户下已映射的账户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryAccountMappingResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_account_mapping_info(
        self,
        request: blockchain_models.CreateAccountMappingInfoRequest,
    ) -> blockchain_models.CreateAccountMappingInfoResponse:
        """
        Description: 用户信息存储
        Summary: 用户信息存储
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_account_mapping_info_ex(request, headers, runtime)

    async def create_account_mapping_info_async(
        self,
        request: blockchain_models.CreateAccountMappingInfoRequest,
    ) -> blockchain_models.CreateAccountMappingInfoResponse:
        """
        Description: 用户信息存储
        Summary: 用户信息存储
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_account_mapping_info_ex_async(request, headers, runtime)

    def create_account_mapping_info_ex(
        self,
        request: blockchain_models.CreateAccountMappingInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAccountMappingInfoResponse:
        """
        Description: 用户信息存储
        Summary: 用户信息存储
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAccountMappingInfoResponse(),
            self.do_request('1.0', 'baas.account.mapping.info.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_account_mapping_info_ex_async(
        self,
        request: blockchain_models.CreateAccountMappingInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAccountMappingInfoResponse:
        """
        Description: 用户信息存储
        Summary: 用户信息存储
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAccountMappingInfoResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.info.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_account_mapping_info(
        self,
        request: blockchain_models.BatchcreateAccountMappingInfoRequest,
    ) -> blockchain_models.BatchcreateAccountMappingInfoResponse:
        """
        Description: 批量创建用户信息
        Summary: 批量创建用户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_account_mapping_info_ex(request, headers, runtime)

    async def batchcreate_account_mapping_info_async(
        self,
        request: blockchain_models.BatchcreateAccountMappingInfoRequest,
    ) -> blockchain_models.BatchcreateAccountMappingInfoResponse:
        """
        Description: 批量创建用户信息
        Summary: 批量创建用户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_account_mapping_info_ex_async(request, headers, runtime)

    def batchcreate_account_mapping_info_ex(
        self,
        request: blockchain_models.BatchcreateAccountMappingInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAccountMappingInfoResponse:
        """
        Description: 批量创建用户信息
        Summary: 批量创建用户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAccountMappingInfoResponse(),
            self.do_request('1.0', 'baas.account.mapping.info.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_account_mapping_info_ex_async(
        self,
        request: blockchain_models.BatchcreateAccountMappingInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAccountMappingInfoResponse:
        """
        Description: 批量创建用户信息
        Summary: 批量创建用户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAccountMappingInfoResponse(),
            await self.do_request_async('1.0', 'baas.account.mapping.info.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_akdf_userbizkey(
        self,
        request: blockchain_models.GetAkdfUserbizkeyRequest,
    ) -> blockchain_models.GetAkdfUserbizkeyResponse:
        """
        Description: 获取用户的密钥对。
        公钥为明文公钥
        私钥为密文，需要用户在本地再做一次解密才能得到真正的私钥
        Summary: 获取用户biz key
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_akdf_userbizkey_ex(request, headers, runtime)

    async def get_akdf_userbizkey_async(
        self,
        request: blockchain_models.GetAkdfUserbizkeyRequest,
    ) -> blockchain_models.GetAkdfUserbizkeyResponse:
        """
        Description: 获取用户的密钥对。
        公钥为明文公钥
        私钥为密文，需要用户在本地再做一次解密才能得到真正的私钥
        Summary: 获取用户biz key
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_akdf_userbizkey_ex_async(request, headers, runtime)

    def get_akdf_userbizkey_ex(
        self,
        request: blockchain_models.GetAkdfUserbizkeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAkdfUserbizkeyResponse:
        """
        Description: 获取用户的密钥对。
        公钥为明文公钥
        私钥为密文，需要用户在本地再做一次解密才能得到真正的私钥
        Summary: 获取用户biz key
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAkdfUserbizkeyResponse(),
            self.do_request('1.0', 'baas.akdf.userbizkey.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_akdf_userbizkey_ex_async(
        self,
        request: blockchain_models.GetAkdfUserbizkeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAkdfUserbizkeyResponse:
        """
        Description: 获取用户的密钥对。
        公钥为明文公钥
        私钥为密文，需要用户在本地再做一次解密才能得到真正的私钥
        Summary: 获取用户biz key
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAkdfUserbizkeyResponse(),
            await self.do_request_async('1.0', 'baas.akdf.userbizkey.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_akdf_userbizkey(
        self,
        request: blockchain_models.ListAkdfUserbizkeyRequest,
    ) -> blockchain_models.ListAkdfUserbizkeyResponse:
        """
        Description: 列出用户在某条链上所有的密钥
        Summary: 列出密钥
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_akdf_userbizkey_ex(request, headers, runtime)

    async def list_akdf_userbizkey_async(
        self,
        request: blockchain_models.ListAkdfUserbizkeyRequest,
    ) -> blockchain_models.ListAkdfUserbizkeyResponse:
        """
        Description: 列出用户在某条链上所有的密钥
        Summary: 列出密钥
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_akdf_userbizkey_ex_async(request, headers, runtime)

    def list_akdf_userbizkey_ex(
        self,
        request: blockchain_models.ListAkdfUserbizkeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListAkdfUserbizkeyResponse:
        """
        Description: 列出用户在某条链上所有的密钥
        Summary: 列出密钥
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListAkdfUserbizkeyResponse(),
            self.do_request('1.0', 'baas.akdf.userbizkey.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_akdf_userbizkey_ex_async(
        self,
        request: blockchain_models.ListAkdfUserbizkeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListAkdfUserbizkeyResponse:
        """
        Description: 列出用户在某条链上所有的密钥
        Summary: 列出密钥
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListAkdfUserbizkeyResponse(),
            await self.do_request_async('1.0', 'baas.akdf.userbizkey.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_blockchain_order(
        self,
        request: blockchain_models.CheckBlockchainOrderRequest,
    ) -> blockchain_models.CheckBlockchainOrderResponse:
        """
        Description: 根据用户选择的规则和订单类型，生成instanceId给commondriver
        Summary: 下单
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_blockchain_order_ex(request, headers, runtime)

    async def check_blockchain_order_async(
        self,
        request: blockchain_models.CheckBlockchainOrderRequest,
    ) -> blockchain_models.CheckBlockchainOrderResponse:
        """
        Description: 根据用户选择的规则和订单类型，生成instanceId给commondriver
        Summary: 下单
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_blockchain_order_ex_async(request, headers, runtime)

    def check_blockchain_order_ex(
        self,
        request: blockchain_models.CheckBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckBlockchainOrderResponse:
        """
        Description: 根据用户选择的规则和订单类型，生成instanceId给commondriver
        Summary: 下单
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_blockchain_order_ex_async(
        self,
        request: blockchain_models.CheckBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckBlockchainOrderResponse:
        """
        Description: 根据用户选择的规则和订单类型，生成instanceId给commondriver
        Summary: 下单
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def verify_blockchain_order(
        self,
        request: blockchain_models.VerifyBlockchainOrderRequest,
    ) -> blockchain_models.VerifyBlockchainOrderResponse:
        """
        Description: 下单前校验
        Summary: 下单前校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.verify_blockchain_order_ex(request, headers, runtime)

    async def verify_blockchain_order_async(
        self,
        request: blockchain_models.VerifyBlockchainOrderRequest,
    ) -> blockchain_models.VerifyBlockchainOrderResponse:
        """
        Description: 下单前校验
        Summary: 下单前校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.verify_blockchain_order_ex_async(request, headers, runtime)

    def verify_blockchain_order_ex(
        self,
        request: blockchain_models.VerifyBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyBlockchainOrderResponse:
        """
        Description: 下单前校验
        Summary: 下单前校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def verify_blockchain_order_ex_async(
        self,
        request: blockchain_models.VerifyBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyBlockchainOrderResponse:
        """
        Description: 下单前校验
        Summary: 下单前校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def invalidate_blockchain_order(
        self,
        request: blockchain_models.InvalidateBlockchainOrderRequest,
    ) -> blockchain_models.InvalidateBlockchainOrderResponse:
        """
        Description: 退款
        Summary: 退款
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.invalidate_blockchain_order_ex(request, headers, runtime)

    async def invalidate_blockchain_order_async(
        self,
        request: blockchain_models.InvalidateBlockchainOrderRequest,
    ) -> blockchain_models.InvalidateBlockchainOrderResponse:
        """
        Description: 退款
        Summary: 退款
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.invalidate_blockchain_order_ex_async(request, headers, runtime)

    def invalidate_blockchain_order_ex(
        self,
        request: blockchain_models.InvalidateBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InvalidateBlockchainOrderResponse:
        """
        Description: 退款
        Summary: 退款
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InvalidateBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.invalidate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def invalidate_blockchain_order_ex_async(
        self,
        request: blockchain_models.InvalidateBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InvalidateBlockchainOrderResponse:
        """
        Description: 退款
        Summary: 退款
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InvalidateBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.invalidate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def release_blockchain_order_physical(
        self,
        request: blockchain_models.ReleaseBlockchainOrderPhysicalRequest,
    ) -> blockchain_models.ReleaseBlockchainOrderPhysicalResponse:
        """
        Description: 删除物理资源
        Summary: 删除物理资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.release_blockchain_order_physical_ex(request, headers, runtime)

    async def release_blockchain_order_physical_async(
        self,
        request: blockchain_models.ReleaseBlockchainOrderPhysicalRequest,
    ) -> blockchain_models.ReleaseBlockchainOrderPhysicalResponse:
        """
        Description: 删除物理资源
        Summary: 删除物理资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.release_blockchain_order_physical_ex_async(request, headers, runtime)

    def release_blockchain_order_physical_ex(
        self,
        request: blockchain_models.ReleaseBlockchainOrderPhysicalRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReleaseBlockchainOrderPhysicalResponse:
        """
        Description: 删除物理资源
        Summary: 删除物理资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReleaseBlockchainOrderPhysicalResponse(),
            self.do_request('1.0', 'baas.blockchain.order.physical.release', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def release_blockchain_order_physical_ex_async(
        self,
        request: blockchain_models.ReleaseBlockchainOrderPhysicalRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReleaseBlockchainOrderPhysicalResponse:
        """
        Description: 删除物理资源
        Summary: 删除物理资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReleaseBlockchainOrderPhysicalResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.physical.release', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def release_blockchain_order_logical(
        self,
        request: blockchain_models.ReleaseBlockchainOrderLogicalRequest,
    ) -> blockchain_models.ReleaseBlockchainOrderLogicalResponse:
        """
        Description: 逻辑资源删除
        Summary: 逻辑资源删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.release_blockchain_order_logical_ex(request, headers, runtime)

    async def release_blockchain_order_logical_async(
        self,
        request: blockchain_models.ReleaseBlockchainOrderLogicalRequest,
    ) -> blockchain_models.ReleaseBlockchainOrderLogicalResponse:
        """
        Description: 逻辑资源删除
        Summary: 逻辑资源删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.release_blockchain_order_logical_ex_async(request, headers, runtime)

    def release_blockchain_order_logical_ex(
        self,
        request: blockchain_models.ReleaseBlockchainOrderLogicalRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReleaseBlockchainOrderLogicalResponse:
        """
        Description: 逻辑资源删除
        Summary: 逻辑资源删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReleaseBlockchainOrderLogicalResponse(),
            self.do_request('1.0', 'baas.blockchain.order.logical.release', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def release_blockchain_order_logical_ex_async(
        self,
        request: blockchain_models.ReleaseBlockchainOrderLogicalRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReleaseBlockchainOrderLogicalResponse:
        """
        Description: 逻辑资源删除
        Summary: 逻辑资源删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReleaseBlockchainOrderLogicalResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.logical.release', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_blockchain_resource(
        self,
        request: blockchain_models.CheckBlockchainResourceRequest,
    ) -> blockchain_models.CheckBlockchainResourceResponse:
        """
        Description: 资源检查
        Summary: 资源检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_blockchain_resource_ex(request, headers, runtime)

    async def check_blockchain_resource_async(
        self,
        request: blockchain_models.CheckBlockchainResourceRequest,
    ) -> blockchain_models.CheckBlockchainResourceResponse:
        """
        Description: 资源检查
        Summary: 资源检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_blockchain_resource_ex_async(request, headers, runtime)

    def check_blockchain_resource_ex(
        self,
        request: blockchain_models.CheckBlockchainResourceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckBlockchainResourceResponse:
        """
        Description: 资源检查
        Summary: 资源检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckBlockchainResourceResponse(),
            self.do_request('1.0', 'baas.blockchain.resource.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_blockchain_resource_ex_async(
        self,
        request: blockchain_models.CheckBlockchainResourceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckBlockchainResourceResponse:
        """
        Description: 资源检查
        Summary: 资源检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckBlockchainResourceResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.resource.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def confirm_blockchain_order(
        self,
        request: blockchain_models.ConfirmBlockchainOrderRequest,
    ) -> blockchain_models.ConfirmBlockchainOrderResponse:
        """
        Description: 补齐商品信息
        Summary: 补齐商品信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.confirm_blockchain_order_ex(request, headers, runtime)

    async def confirm_blockchain_order_async(
        self,
        request: blockchain_models.ConfirmBlockchainOrderRequest,
    ) -> blockchain_models.ConfirmBlockchainOrderResponse:
        """
        Description: 补齐商品信息
        Summary: 补齐商品信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.confirm_blockchain_order_ex_async(request, headers, runtime)

    def confirm_blockchain_order_ex(
        self,
        request: blockchain_models.ConfirmBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConfirmBlockchainOrderResponse:
        """
        Description: 补齐商品信息
        Summary: 补齐商品信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConfirmBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.confirm', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def confirm_blockchain_order_ex_async(
        self,
        request: blockchain_models.ConfirmBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConfirmBlockchainOrderResponse:
        """
        Description: 补齐商品信息
        Summary: 补齐商品信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConfirmBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.confirm', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def connect_blockchain_order(
        self,
        request: blockchain_models.ConnectBlockchainOrderRequest,
    ) -> blockchain_models.ConnectBlockchainOrderResponse:
        """
        Description: 检查
        Summary: 检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.connect_blockchain_order_ex(request, headers, runtime)

    async def connect_blockchain_order_async(
        self,
        request: blockchain_models.ConnectBlockchainOrderRequest,
    ) -> blockchain_models.ConnectBlockchainOrderResponse:
        """
        Description: 检查
        Summary: 检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.connect_blockchain_order_ex_async(request, headers, runtime)

    def connect_blockchain_order_ex(
        self,
        request: blockchain_models.ConnectBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConnectBlockchainOrderResponse:
        """
        Description: 检查
        Summary: 检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConnectBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.connect', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def connect_blockchain_order_ex_async(
        self,
        request: blockchain_models.ConnectBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConnectBlockchainOrderResponse:
        """
        Description: 检查
        Summary: 检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConnectBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.connect', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_blockchain_order(
        self,
        request: blockchain_models.ExecBlockchainOrderRequest,
    ) -> blockchain_models.ExecBlockchainOrderResponse:
        """
        Description: 阿里云区块链订单创建接口
        Summary: 阿里云区块链订单创建接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_blockchain_order_ex(request, headers, runtime)

    async def exec_blockchain_order_async(
        self,
        request: blockchain_models.ExecBlockchainOrderRequest,
    ) -> blockchain_models.ExecBlockchainOrderResponse:
        """
        Description: 阿里云区块链订单创建接口
        Summary: 阿里云区块链订单创建接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_blockchain_order_ex_async(request, headers, runtime)

    def exec_blockchain_order_ex(
        self,
        request: blockchain_models.ExecBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecBlockchainOrderResponse:
        """
        Description: 阿里云区块链订单创建接口
        Summary: 阿里云区块链订单创建接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecBlockchainOrderResponse(),
            self.do_request('1.0', 'baas.blockchain.order.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_blockchain_order_ex_async(
        self,
        request: blockchain_models.ExecBlockchainOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecBlockchainOrderResponse:
        """
        Description: 阿里云区块链订单创建接口
        Summary: 阿里云区块链订单创建接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecBlockchainOrderResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.order.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_union_union(
        self,
        request: blockchain_models.CreateUnionUnionRequest,
    ) -> blockchain_models.CreateUnionUnionResponse:
        """
        Description: 创建联盟
        Summary: 创建联盟
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_union_union_ex(request, headers, runtime)

    async def create_union_union_async(
        self,
        request: blockchain_models.CreateUnionUnionRequest,
    ) -> blockchain_models.CreateUnionUnionResponse:
        """
        Description: 创建联盟
        Summary: 创建联盟
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_union_union_ex_async(request, headers, runtime)

    def create_union_union_ex(
        self,
        request: blockchain_models.CreateUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateUnionUnionResponse:
        """
        Description: 创建联盟
        Summary: 创建联盟
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateUnionUnionResponse(),
            self.do_request('1.0', 'baas.union.union.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_union_union_ex_async(
        self,
        request: blockchain_models.CreateUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateUnionUnionResponse:
        """
        Description: 创建联盟
        Summary: 创建联盟
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateUnionUnionResponse(),
            await self.do_request_async('1.0', 'baas.union.union.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_union_union(
        self,
        request: blockchain_models.DeleteUnionUnionRequest,
    ) -> blockchain_models.DeleteUnionUnionResponse:
        """
        Description: 删除联盟
        Summary: 删除联盟
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_union_union_ex(request, headers, runtime)

    async def delete_union_union_async(
        self,
        request: blockchain_models.DeleteUnionUnionRequest,
    ) -> blockchain_models.DeleteUnionUnionResponse:
        """
        Description: 删除联盟
        Summary: 删除联盟
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_union_union_ex_async(request, headers, runtime)

    def delete_union_union_ex(
        self,
        request: blockchain_models.DeleteUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteUnionUnionResponse:
        """
        Description: 删除联盟
        Summary: 删除联盟
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteUnionUnionResponse(),
            self.do_request('1.0', 'baas.union.union.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_union_union_ex_async(
        self,
        request: blockchain_models.DeleteUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteUnionUnionResponse:
        """
        Description: 删除联盟
        Summary: 删除联盟
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteUnionUnionResponse(),
            await self.do_request_async('1.0', 'baas.union.union.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_union_union(
        self,
        request: blockchain_models.UpdateUnionUnionRequest,
    ) -> blockchain_models.UpdateUnionUnionResponse:
        """
        Description: 联盟更新
        Summary: 联盟更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_union_union_ex(request, headers, runtime)

    async def update_union_union_async(
        self,
        request: blockchain_models.UpdateUnionUnionRequest,
    ) -> blockchain_models.UpdateUnionUnionResponse:
        """
        Description: 联盟更新
        Summary: 联盟更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_union_union_ex_async(request, headers, runtime)

    def update_union_union_ex(
        self,
        request: blockchain_models.UpdateUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateUnionUnionResponse:
        """
        Description: 联盟更新
        Summary: 联盟更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateUnionUnionResponse(),
            self.do_request('1.0', 'baas.union.union.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_union_union_ex_async(
        self,
        request: blockchain_models.UpdateUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateUnionUnionResponse:
        """
        Description: 联盟更新
        Summary: 联盟更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateUnionUnionResponse(),
            await self.do_request_async('1.0', 'baas.union.union.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_union_union(
        self,
        request: blockchain_models.QueryUnionUnionRequest,
    ) -> blockchain_models.QueryUnionUnionResponse:
        """
        Description: 联盟查询
        Summary: 联盟查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_union_union_ex(request, headers, runtime)

    async def query_union_union_async(
        self,
        request: blockchain_models.QueryUnionUnionRequest,
    ) -> blockchain_models.QueryUnionUnionResponse:
        """
        Description: 联盟查询
        Summary: 联盟查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_union_union_ex_async(request, headers, runtime)

    def query_union_union_ex(
        self,
        request: blockchain_models.QueryUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionUnionResponse:
        """
        Description: 联盟查询
        Summary: 联盟查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionUnionResponse(),
            self.do_request('1.0', 'baas.union.union.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_union_union_ex_async(
        self,
        request: blockchain_models.QueryUnionUnionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionUnionResponse:
        """
        Description: 联盟查询
        Summary: 联盟查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionUnionResponse(),
            await self.do_request_async('1.0', 'baas.union.union.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_union_member(
        self,
        request: blockchain_models.ApplyUnionMemberRequest,
    ) -> blockchain_models.ApplyUnionMemberResponse:
        """
        Description: 联盟邀请用户
        Summary: 联盟邀请用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_union_member_ex(request, headers, runtime)

    async def apply_union_member_async(
        self,
        request: blockchain_models.ApplyUnionMemberRequest,
    ) -> blockchain_models.ApplyUnionMemberResponse:
        """
        Description: 联盟邀请用户
        Summary: 联盟邀请用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_union_member_ex_async(request, headers, runtime)

    def apply_union_member_ex(
        self,
        request: blockchain_models.ApplyUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyUnionMemberResponse:
        """
        Description: 联盟邀请用户
        Summary: 联盟邀请用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyUnionMemberResponse(),
            self.do_request('1.0', 'baas.union.member.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_union_member_ex_async(
        self,
        request: blockchain_models.ApplyUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyUnionMemberResponse:
        """
        Description: 联盟邀请用户
        Summary: 联盟邀请用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyUnionMemberResponse(),
            await self.do_request_async('1.0', 'baas.union.member.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def confirm_union_member(
        self,
        request: blockchain_models.ConfirmUnionMemberRequest,
    ) -> blockchain_models.ConfirmUnionMemberResponse:
        """
        Description: 阿里云联盟成员加入
        Summary: 阿里云联盟成员加入
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.confirm_union_member_ex(request, headers, runtime)

    async def confirm_union_member_async(
        self,
        request: blockchain_models.ConfirmUnionMemberRequest,
    ) -> blockchain_models.ConfirmUnionMemberResponse:
        """
        Description: 阿里云联盟成员加入
        Summary: 阿里云联盟成员加入
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.confirm_union_member_ex_async(request, headers, runtime)

    def confirm_union_member_ex(
        self,
        request: blockchain_models.ConfirmUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConfirmUnionMemberResponse:
        """
        Description: 阿里云联盟成员加入
        Summary: 阿里云联盟成员加入
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConfirmUnionMemberResponse(),
            self.do_request('1.0', 'baas.union.member.confirm', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def confirm_union_member_ex_async(
        self,
        request: blockchain_models.ConfirmUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ConfirmUnionMemberResponse:
        """
        Description: 阿里云联盟成员加入
        Summary: 阿里云联盟成员加入
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ConfirmUnionMemberResponse(),
            await self.do_request_async('1.0', 'baas.union.member.confirm', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_union_chain(
        self,
        request: blockchain_models.QueryUnionChainRequest,
    ) -> blockchain_models.QueryUnionChainResponse:
        """
        Description: 获取联盟内的蚂蚁区块链列表
        Summary: 获取联盟内的蚂蚁区块链列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_union_chain_ex(request, headers, runtime)

    async def query_union_chain_async(
        self,
        request: blockchain_models.QueryUnionChainRequest,
    ) -> blockchain_models.QueryUnionChainResponse:
        """
        Description: 获取联盟内的蚂蚁区块链列表
        Summary: 获取联盟内的蚂蚁区块链列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_union_chain_ex_async(request, headers, runtime)

    def query_union_chain_ex(
        self,
        request: blockchain_models.QueryUnionChainRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionChainResponse:
        """
        Description: 获取联盟内的蚂蚁区块链列表
        Summary: 获取联盟内的蚂蚁区块链列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionChainResponse(),
            self.do_request('1.0', 'baas.union.chain.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_union_chain_ex_async(
        self,
        request: blockchain_models.QueryUnionChainRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionChainResponse:
        """
        Description: 获取联盟内的蚂蚁区块链列表
        Summary: 获取联盟内的蚂蚁区块链列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionChainResponse(),
            await self.do_request_async('1.0', 'baas.union.chain.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_union_member(
        self,
        request: blockchain_models.QueryUnionMemberRequest,
    ) -> blockchain_models.QueryUnionMemberResponse:
        """
        Description: 获取联盟成员列表
        Summary: 获取联盟成员列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_union_member_ex(request, headers, runtime)

    async def query_union_member_async(
        self,
        request: blockchain_models.QueryUnionMemberRequest,
    ) -> blockchain_models.QueryUnionMemberResponse:
        """
        Description: 获取联盟成员列表
        Summary: 获取联盟成员列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_union_member_ex_async(request, headers, runtime)

    def query_union_member_ex(
        self,
        request: blockchain_models.QueryUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionMemberResponse:
        """
        Description: 获取联盟成员列表
        Summary: 获取联盟成员列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionMemberResponse(),
            self.do_request('1.0', 'baas.union.member.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_union_member_ex_async(
        self,
        request: blockchain_models.QueryUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionMemberResponse:
        """
        Description: 获取联盟成员列表
        Summary: 获取联盟成员列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionMemberResponse(),
            await self.do_request_async('1.0', 'baas.union.member.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_union_member(
        self,
        request: blockchain_models.UpdateUnionMemberRequest,
    ) -> blockchain_models.UpdateUnionMemberResponse:
        """
        Description: 更新联盟成员属性
        Summary: 更新联盟成员属性
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_union_member_ex(request, headers, runtime)

    async def update_union_member_async(
        self,
        request: blockchain_models.UpdateUnionMemberRequest,
    ) -> blockchain_models.UpdateUnionMemberResponse:
        """
        Description: 更新联盟成员属性
        Summary: 更新联盟成员属性
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_union_member_ex_async(request, headers, runtime)

    def update_union_member_ex(
        self,
        request: blockchain_models.UpdateUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateUnionMemberResponse:
        """
        Description: 更新联盟成员属性
        Summary: 更新联盟成员属性
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateUnionMemberResponse(),
            self.do_request('1.0', 'baas.union.member.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_union_member_ex_async(
        self,
        request: blockchain_models.UpdateUnionMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateUnionMemberResponse:
        """
        Description: 更新联盟成员属性
        Summary: 更新联盟成员属性
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateUnionMemberResponse(),
            await self.do_request_async('1.0', 'baas.union.member.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_name_ant(
        self,
        request: blockchain_models.UpdateChainNameAntRequest,
    ) -> blockchain_models.UpdateChainNameAntResponse:
        """
        Description: 更新区块链的名称
        Summary: 更新区块链的名称
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_name_ant_ex(request, headers, runtime)

    async def update_chain_name_ant_async(
        self,
        request: blockchain_models.UpdateChainNameAntRequest,
    ) -> blockchain_models.UpdateChainNameAntResponse:
        """
        Description: 更新区块链的名称
        Summary: 更新区块链的名称
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_name_ant_ex_async(request, headers, runtime)

    def update_chain_name_ant_ex(
        self,
        request: blockchain_models.UpdateChainNameAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainNameAntResponse:
        """
        Description: 更新区块链的名称
        Summary: 更新区块链的名称
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainNameAntResponse(),
            self.do_request('1.0', 'baas.chain.name.ant.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_name_ant_ex_async(
        self,
        request: blockchain_models.UpdateChainNameAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainNameAntResponse:
        """
        Description: 更新区块链的名称
        Summary: 更新区块链的名称
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainNameAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.name.ant.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_cert_ant(
        self,
        request: blockchain_models.CreateChainCertAntRequest,
    ) -> blockchain_models.CreateChainCertAntResponse:
        """
        Description: 手工创建区块链证书
        Summary: 手工创建区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_cert_ant_ex(request, headers, runtime)

    async def create_chain_cert_ant_async(
        self,
        request: blockchain_models.CreateChainCertAntRequest,
    ) -> blockchain_models.CreateChainCertAntResponse:
        """
        Description: 手工创建区块链证书
        Summary: 手工创建区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_cert_ant_ex_async(request, headers, runtime)

    def create_chain_cert_ant_ex(
        self,
        request: blockchain_models.CreateChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainCertAntResponse:
        """
        Description: 手工创建区块链证书
        Summary: 手工创建区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainCertAntResponse(),
            self.do_request('1.0', 'baas.chain.cert.ant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_cert_ant_ex_async(
        self,
        request: blockchain_models.CreateChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainCertAntResponse:
        """
        Description: 手工创建区块链证书
        Summary: 手工创建区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainCertAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.cert.ant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_cert_ant(
        self,
        request: blockchain_models.ApplyChainCertAntRequest,
    ) -> blockchain_models.ApplyChainCertAntResponse:
        """
        Description: 自动申请区块链证书
        Summary: 自动申请区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_cert_ant_ex(request, headers, runtime)

    async def apply_chain_cert_ant_async(
        self,
        request: blockchain_models.ApplyChainCertAntRequest,
    ) -> blockchain_models.ApplyChainCertAntResponse:
        """
        Description: 自动申请区块链证书
        Summary: 自动申请区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_cert_ant_ex_async(request, headers, runtime)

    def apply_chain_cert_ant_ex(
        self,
        request: blockchain_models.ApplyChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainCertAntResponse:
        """
        Description: 自动申请区块链证书
        Summary: 自动申请区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainCertAntResponse(),
            self.do_request('1.0', 'baas.chain.cert.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_cert_ant_ex_async(
        self,
        request: blockchain_models.ApplyChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainCertAntResponse:
        """
        Description: 自动申请区块链证书
        Summary: 自动申请区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainCertAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.cert.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_public_cert(
        self,
        request: blockchain_models.CreateChainPublicCertRequest,
    ) -> blockchain_models.CreateChainPublicCertResponse:
        """
        Description: 人工申请区块链证书
        Summary: 人工申请区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_public_cert_ex(request, headers, runtime)

    async def create_chain_public_cert_async(
        self,
        request: blockchain_models.CreateChainPublicCertRequest,
    ) -> blockchain_models.CreateChainPublicCertResponse:
        """
        Description: 人工申请区块链证书
        Summary: 人工申请区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_public_cert_ex_async(request, headers, runtime)

    def create_chain_public_cert_ex(
        self,
        request: blockchain_models.CreateChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainPublicCertResponse:
        """
        Description: 人工申请区块链证书
        Summary: 人工申请区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainPublicCertResponse(),
            self.do_request('1.0', 'baas.chain.public.cert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_public_cert_ex_async(
        self,
        request: blockchain_models.CreateChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainPublicCertResponse:
        """
        Description: 人工申请区块链证书
        Summary: 人工申请区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainPublicCertResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.cert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_public_cert(
        self,
        request: blockchain_models.ApplyChainPublicCertRequest,
    ) -> blockchain_models.ApplyChainPublicCertResponse:
        """
        Description: 自动创建区块链证书
        Summary: 自动创建区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_public_cert_ex(request, headers, runtime)

    async def apply_chain_public_cert_async(
        self,
        request: blockchain_models.ApplyChainPublicCertRequest,
    ) -> blockchain_models.ApplyChainPublicCertResponse:
        """
        Description: 自动创建区块链证书
        Summary: 自动创建区块链证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_public_cert_ex_async(request, headers, runtime)

    def apply_chain_public_cert_ex(
        self,
        request: blockchain_models.ApplyChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicCertResponse:
        """
        Description: 自动创建区块链证书
        Summary: 自动创建区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicCertResponse(),
            self.do_request('1.0', 'baas.chain.public.cert.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_public_cert_ex_async(
        self,
        request: blockchain_models.ApplyChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicCertResponse:
        """
        Description: 自动创建区块链证书
        Summary: 自动创建区块链证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicCertResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.cert.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reinit_chain_public_cert(
        self,
        request: blockchain_models.ReinitChainPublicCertRequest,
    ) -> blockchain_models.ReinitChainPublicCertResponse:
        """
        Description: 免费体验链重置证书
        Summary: 免费体验链重置证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reinit_chain_public_cert_ex(request, headers, runtime)

    async def reinit_chain_public_cert_async(
        self,
        request: blockchain_models.ReinitChainPublicCertRequest,
    ) -> blockchain_models.ReinitChainPublicCertResponse:
        """
        Description: 免费体验链重置证书
        Summary: 免费体验链重置证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reinit_chain_public_cert_ex_async(request, headers, runtime)

    def reinit_chain_public_cert_ex(
        self,
        request: blockchain_models.ReinitChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainPublicCertResponse:
        """
        Description: 免费体验链重置证书
        Summary: 免费体验链重置证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainPublicCertResponse(),
            self.do_request('1.0', 'baas.chain.public.cert.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reinit_chain_public_cert_ex_async(
        self,
        request: blockchain_models.ReinitChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainPublicCertResponse:
        """
        Description: 免费体验链重置证书
        Summary: 免费体验链重置证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainPublicCertResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.cert.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_public_account(
        self,
        request: blockchain_models.CreateChainPublicAccountRequest,
    ) -> blockchain_models.CreateChainPublicAccountResponse:
        """
        Description: 免费体验链创建账户
        Summary: 免费体验链创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_public_account_ex(request, headers, runtime)

    async def create_chain_public_account_async(
        self,
        request: blockchain_models.CreateChainPublicAccountRequest,
    ) -> blockchain_models.CreateChainPublicAccountResponse:
        """
        Description: 免费体验链创建账户
        Summary: 免费体验链创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_public_account_ex_async(request, headers, runtime)

    def create_chain_public_account_ex(
        self,
        request: blockchain_models.CreateChainPublicAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainPublicAccountResponse:
        """
        Description: 免费体验链创建账户
        Summary: 免费体验链创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainPublicAccountResponse(),
            self.do_request('1.0', 'baas.chain.public.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_public_account_ex_async(
        self,
        request: blockchain_models.CreateChainPublicAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainPublicAccountResponse:
        """
        Description: 免费体验链创建账户
        Summary: 免费体验链创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainPublicAccountResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_public_account(
        self,
        request: blockchain_models.ApplyChainPublicAccountRequest,
    ) -> blockchain_models.ApplyChainPublicAccountResponse:
        """
        Description: 自动创建链上账户
        Summary: 自动创建链上账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_public_account_ex(request, headers, runtime)

    async def apply_chain_public_account_async(
        self,
        request: blockchain_models.ApplyChainPublicAccountRequest,
    ) -> blockchain_models.ApplyChainPublicAccountResponse:
        """
        Description: 自动创建链上账户
        Summary: 自动创建链上账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_public_account_ex_async(request, headers, runtime)

    def apply_chain_public_account_ex(
        self,
        request: blockchain_models.ApplyChainPublicAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicAccountResponse:
        """
        Description: 自动创建链上账户
        Summary: 自动创建链上账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicAccountResponse(),
            self.do_request('1.0', 'baas.chain.public.account.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_public_account_ex_async(
        self,
        request: blockchain_models.ApplyChainPublicAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicAccountResponse:
        """
        Description: 自动创建链上账户
        Summary: 自动创建链上账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicAccountResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.account.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_public(
        self,
        request: blockchain_models.QueryChainPublicRequest,
    ) -> blockchain_models.QueryChainPublicResponse:
        """
        Description: 免费体验链查询
        Summary: 免费体验链查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_public_ex(request, headers, runtime)

    async def query_chain_public_async(
        self,
        request: blockchain_models.QueryChainPublicRequest,
    ) -> blockchain_models.QueryChainPublicResponse:
        """
        Description: 免费体验链查询
        Summary: 免费体验链查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_public_ex_async(request, headers, runtime)

    def query_chain_public_ex(
        self,
        request: blockchain_models.QueryChainPublicRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicResponse:
        """
        Description: 免费体验链查询
        Summary: 免费体验链查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicResponse(),
            self.do_request('1.0', 'baas.chain.public.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_public_ex_async(
        self,
        request: blockchain_models.QueryChainPublicRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicResponse:
        """
        Description: 免费体验链查询
        Summary: 免费体验链查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def download_chain_public_cert(
        self,
        request: blockchain_models.DownloadChainPublicCertRequest,
    ) -> blockchain_models.DownloadChainPublicCertResponse:
        """
        Description: 免费体验链证书下载
        Summary: 免费体验链证书下载
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.download_chain_public_cert_ex(request, headers, runtime)

    async def download_chain_public_cert_async(
        self,
        request: blockchain_models.DownloadChainPublicCertRequest,
    ) -> blockchain_models.DownloadChainPublicCertResponse:
        """
        Description: 免费体验链证书下载
        Summary: 免费体验链证书下载
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.download_chain_public_cert_ex_async(request, headers, runtime)

    def download_chain_public_cert_ex(
        self,
        request: blockchain_models.DownloadChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DownloadChainPublicCertResponse:
        """
        Description: 免费体验链证书下载
        Summary: 免费体验链证书下载
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DownloadChainPublicCertResponse(),
            self.do_request('1.0', 'baas.chain.public.cert.download', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def download_chain_public_cert_ex_async(
        self,
        request: blockchain_models.DownloadChainPublicCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DownloadChainPublicCertResponse:
        """
        Description: 免费体验链证书下载
        Summary: 免费体验链证书下载
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DownloadChainPublicCertResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.cert.download', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_account_ant(
        self,
        request: blockchain_models.CreateChainAccountAntRequest,
    ) -> blockchain_models.CreateChainAccountAntResponse:
        """
        Description: 手工创建账户
        Summary: 手工创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_account_ant_ex(request, headers, runtime)

    async def create_chain_account_ant_async(
        self,
        request: blockchain_models.CreateChainAccountAntRequest,
    ) -> blockchain_models.CreateChainAccountAntResponse:
        """
        Description: 手工创建账户
        Summary: 手工创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_account_ant_ex_async(request, headers, runtime)

    def create_chain_account_ant_ex(
        self,
        request: blockchain_models.CreateChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainAccountAntResponse:
        """
        Description: 手工创建账户
        Summary: 手工创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainAccountAntResponse(),
            self.do_request('1.0', 'baas.chain.account.ant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_account_ant_ex_async(
        self,
        request: blockchain_models.CreateChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainAccountAntResponse:
        """
        Description: 手工创建账户
        Summary: 手工创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainAccountAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.ant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_account_ant(
        self,
        request: blockchain_models.ApplyChainAccountAntRequest,
    ) -> blockchain_models.ApplyChainAccountAntResponse:
        """
        Description: 自动创建账户
        Summary: 自动创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_account_ant_ex(request, headers, runtime)

    async def apply_chain_account_ant_async(
        self,
        request: blockchain_models.ApplyChainAccountAntRequest,
    ) -> blockchain_models.ApplyChainAccountAntResponse:
        """
        Description: 自动创建账户
        Summary: 自动创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_account_ant_ex_async(request, headers, runtime)

    def apply_chain_account_ant_ex(
        self,
        request: blockchain_models.ApplyChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainAccountAntResponse:
        """
        Description: 自动创建账户
        Summary: 自动创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainAccountAntResponse(),
            self.do_request('1.0', 'baas.chain.account.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_account_ant_ex_async(
        self,
        request: blockchain_models.ApplyChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainAccountAntResponse:
        """
        Description: 自动创建账户
        Summary: 自动创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainAccountAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_account_ant(
        self,
        request: blockchain_models.QueryChainAccountAntRequest,
    ) -> blockchain_models.QueryChainAccountAntResponse:
        """
        Description: 查询链上账户列表
        Summary: 查询链上账户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_account_ant_ex(request, headers, runtime)

    async def query_chain_account_ant_async(
        self,
        request: blockchain_models.QueryChainAccountAntRequest,
    ) -> blockchain_models.QueryChainAccountAntResponse:
        """
        Description: 查询链上账户列表
        Summary: 查询链上账户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_account_ant_ex_async(request, headers, runtime)

    def query_chain_account_ant_ex(
        self,
        request: blockchain_models.QueryChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainAccountAntResponse:
        """
        Description: 查询链上账户列表
        Summary: 查询链上账户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainAccountAntResponse(),
            self.do_request('1.0', 'baas.chain.account.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_account_ant_ex_async(
        self,
        request: blockchain_models.QueryChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainAccountAntResponse:
        """
        Description: 查询链上账户列表
        Summary: 查询链上账户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainAccountAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def download_chain_cert_ant(
        self,
        request: blockchain_models.DownloadChainCertAntRequest,
    ) -> blockchain_models.DownloadChainCertAntResponse:
        """
        Description: 区块链证书下载
        Summary: 区块链证书下载
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.download_chain_cert_ant_ex(request, headers, runtime)

    async def download_chain_cert_ant_async(
        self,
        request: blockchain_models.DownloadChainCertAntRequest,
    ) -> blockchain_models.DownloadChainCertAntResponse:
        """
        Description: 区块链证书下载
        Summary: 区块链证书下载
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.download_chain_cert_ant_ex_async(request, headers, runtime)

    def download_chain_cert_ant_ex(
        self,
        request: blockchain_models.DownloadChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DownloadChainCertAntResponse:
        """
        Description: 区块链证书下载
        Summary: 区块链证书下载
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DownloadChainCertAntResponse(),
            self.do_request('1.0', 'baas.chain.cert.ant.download', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def download_chain_cert_ant_ex_async(
        self,
        request: blockchain_models.DownloadChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DownloadChainCertAntResponse:
        """
        Description: 区块链证书下载
        Summary: 区块链证书下载
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DownloadChainCertAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.cert.ant.download', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_node_ant(
        self,
        request: blockchain_models.QueryChainNodeAntRequest,
    ) -> blockchain_models.QueryChainNodeAntResponse:
        """
        Description: 阿里云链节点查询
        Summary: 阿里云链节点查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_node_ant_ex(request, headers, runtime)

    async def query_chain_node_ant_async(
        self,
        request: blockchain_models.QueryChainNodeAntRequest,
    ) -> blockchain_models.QueryChainNodeAntResponse:
        """
        Description: 阿里云链节点查询
        Summary: 阿里云链节点查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_node_ant_ex_async(request, headers, runtime)

    def query_chain_node_ant_ex(
        self,
        request: blockchain_models.QueryChainNodeAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainNodeAntResponse:
        """
        Description: 阿里云链节点查询
        Summary: 阿里云链节点查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainNodeAntResponse(),
            self.do_request('1.0', 'baas.chain.node.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_node_ant_ex_async(
        self,
        request: blockchain_models.QueryChainNodeAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainNodeAntResponse:
        """
        Description: 阿里云链节点查询
        Summary: 阿里云链节点查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainNodeAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.node.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def freeze_chain_account_ant(
        self,
        request: blockchain_models.FreezeChainAccountAntRequest,
    ) -> blockchain_models.FreezeChainAccountAntResponse:
        """
        Description: 区块链链上账户冻结
        Summary: 区块链链上账户冻结
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.freeze_chain_account_ant_ex(request, headers, runtime)

    async def freeze_chain_account_ant_async(
        self,
        request: blockchain_models.FreezeChainAccountAntRequest,
    ) -> blockchain_models.FreezeChainAccountAntResponse:
        """
        Description: 区块链链上账户冻结
        Summary: 区块链链上账户冻结
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.freeze_chain_account_ant_ex_async(request, headers, runtime)

    def freeze_chain_account_ant_ex(
        self,
        request: blockchain_models.FreezeChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FreezeChainAccountAntResponse:
        """
        Description: 区块链链上账户冻结
        Summary: 区块链链上账户冻结
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FreezeChainAccountAntResponse(),
            self.do_request('1.0', 'baas.chain.account.ant.freeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def freeze_chain_account_ant_ex_async(
        self,
        request: blockchain_models.FreezeChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FreezeChainAccountAntResponse:
        """
        Description: 区块链链上账户冻结
        Summary: 区块链链上账户冻结
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FreezeChainAccountAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.ant.freeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def unfreeze_chain_account_ant(
        self,
        request: blockchain_models.UnfreezeChainAccountAntRequest,
    ) -> blockchain_models.UnfreezeChainAccountAntResponse:
        """
        Description: 蚂蚁区块链账户解冻
        Summary: 蚂蚁区块链账户解冻
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.unfreeze_chain_account_ant_ex(request, headers, runtime)

    async def unfreeze_chain_account_ant_async(
        self,
        request: blockchain_models.UnfreezeChainAccountAntRequest,
    ) -> blockchain_models.UnfreezeChainAccountAntResponse:
        """
        Description: 蚂蚁区块链账户解冻
        Summary: 蚂蚁区块链账户解冻
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.unfreeze_chain_account_ant_ex_async(request, headers, runtime)

    def unfreeze_chain_account_ant_ex(
        self,
        request: blockchain_models.UnfreezeChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnfreezeChainAccountAntResponse:
        """
        Description: 蚂蚁区块链账户解冻
        Summary: 蚂蚁区块链账户解冻
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnfreezeChainAccountAntResponse(),
            self.do_request('1.0', 'baas.chain.account.ant.unfreeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def unfreeze_chain_account_ant_ex_async(
        self,
        request: blockchain_models.UnfreezeChainAccountAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnfreezeChainAccountAntResponse:
        """
        Description: 蚂蚁区块链账户解冻
        Summary: 蚂蚁区块链账户解冻
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnfreezeChainAccountAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.ant.unfreeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reinit_chain_cert_ant(
        self,
        request: blockchain_models.ReinitChainCertAntRequest,
    ) -> blockchain_models.ReinitChainCertAntResponse:
        """
        Description: 区块链证书重置
        Summary: 区块链证书重置
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reinit_chain_cert_ant_ex(request, headers, runtime)

    async def reinit_chain_cert_ant_async(
        self,
        request: blockchain_models.ReinitChainCertAntRequest,
    ) -> blockchain_models.ReinitChainCertAntResponse:
        """
        Description: 区块链证书重置
        Summary: 区块链证书重置
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reinit_chain_cert_ant_ex_async(request, headers, runtime)

    def reinit_chain_cert_ant_ex(
        self,
        request: blockchain_models.ReinitChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainCertAntResponse:
        """
        Description: 区块链证书重置
        Summary: 区块链证书重置
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainCertAntResponse(),
            self.do_request('1.0', 'baas.chain.cert.ant.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reinit_chain_cert_ant_ex_async(
        self,
        request: blockchain_models.ReinitChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainCertAntResponse:
        """
        Description: 区块链证书重置
        Summary: 区块链证书重置
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainCertAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.cert.ant.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_cert_ant(
        self,
        request: blockchain_models.QueryChainCertAntRequest,
    ) -> blockchain_models.QueryChainCertAntResponse:
        """
        Description: 区块链证书查询
        Summary: 区块链证书查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_cert_ant_ex(request, headers, runtime)

    async def query_chain_cert_ant_async(
        self,
        request: blockchain_models.QueryChainCertAntRequest,
    ) -> blockchain_models.QueryChainCertAntResponse:
        """
        Description: 区块链证书查询
        Summary: 区块链证书查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_cert_ant_ex_async(request, headers, runtime)

    def query_chain_cert_ant_ex(
        self,
        request: blockchain_models.QueryChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainCertAntResponse:
        """
        Description: 区块链证书查询
        Summary: 区块链证书查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainCertAntResponse(),
            self.do_request('1.0', 'baas.chain.cert.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_cert_ant_ex_async(
        self,
        request: blockchain_models.QueryChainCertAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainCertAntResponse:
        """
        Description: 区块链证书查询
        Summary: 区块链证书查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainCertAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.cert.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_info(
        self,
        request: blockchain_models.QueryChainBrowserInfoRequest,
    ) -> blockchain_models.QueryChainBrowserInfoResponse:
        """
        Description: 阿里云浏览器信息查询
        Summary: 阿里云浏览器信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_info_ex(request, headers, runtime)

    async def query_chain_browser_info_async(
        self,
        request: blockchain_models.QueryChainBrowserInfoRequest,
    ) -> blockchain_models.QueryChainBrowserInfoResponse:
        """
        Description: 阿里云浏览器信息查询
        Summary: 阿里云浏览器信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_info_ex_async(request, headers, runtime)

    def query_chain_browser_info_ex(
        self,
        request: blockchain_models.QueryChainBrowserInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserInfoResponse:
        """
        Description: 阿里云浏览器信息查询
        Summary: 阿里云浏览器信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserInfoResponse(),
            self.do_request('1.0', 'baas.chain.browser.info.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_info_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserInfoResponse:
        """
        Description: 阿里云浏览器信息查询
        Summary: 阿里云浏览器信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserInfoResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.info.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_blocks(
        self,
        request: blockchain_models.QueryChainBrowserBlocksRequest,
    ) -> blockchain_models.QueryChainBrowserBlocksResponse:
        """
        Description: 阿里云最新区块链信息查询
        Summary: 阿里云最新区块链信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_blocks_ex(request, headers, runtime)

    async def query_chain_browser_blocks_async(
        self,
        request: blockchain_models.QueryChainBrowserBlocksRequest,
    ) -> blockchain_models.QueryChainBrowserBlocksResponse:
        """
        Description: 阿里云最新区块链信息查询
        Summary: 阿里云最新区块链信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_blocks_ex_async(request, headers, runtime)

    def query_chain_browser_blocks_ex(
        self,
        request: blockchain_models.QueryChainBrowserBlocksRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserBlocksResponse:
        """
        Description: 阿里云最新区块链信息查询
        Summary: 阿里云最新区块链信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserBlocksResponse(),
            self.do_request('1.0', 'baas.chain.browser.blocks.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_blocks_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserBlocksRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserBlocksResponse:
        """
        Description: 阿里云最新区块链信息查询
        Summary: 阿里云最新区块链信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserBlocksResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.blocks.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_transactions(
        self,
        request: blockchain_models.QueryChainBrowserTransactionsRequest,
    ) -> blockchain_models.QueryChainBrowserTransactionsResponse:
        """
        Description: 阿里云最新交易查询
        Summary: 阿里云最新交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_transactions_ex(request, headers, runtime)

    async def query_chain_browser_transactions_async(
        self,
        request: blockchain_models.QueryChainBrowserTransactionsRequest,
    ) -> blockchain_models.QueryChainBrowserTransactionsResponse:
        """
        Description: 阿里云最新交易查询
        Summary: 阿里云最新交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_transactions_ex_async(request, headers, runtime)

    def query_chain_browser_transactions_ex(
        self,
        request: blockchain_models.QueryChainBrowserTransactionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserTransactionsResponse:
        """
        Description: 阿里云最新交易查询
        Summary: 阿里云最新交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserTransactionsResponse(),
            self.do_request('1.0', 'baas.chain.browser.transactions.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_transactions_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserTransactionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserTransactionsResponse:
        """
        Description: 阿里云最新交易查询
        Summary: 阿里云最新交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserTransactionsResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.transactions.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchquery_chain_browser_transaction(
        self,
        request: blockchain_models.BatchqueryChainBrowserTransactionRequest,
    ) -> blockchain_models.BatchqueryChainBrowserTransactionResponse:
        """
        Description: 阿里云最新区块交易信息查询
        Summary: 阿里云最新区块交易信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchquery_chain_browser_transaction_ex(request, headers, runtime)

    async def batchquery_chain_browser_transaction_async(
        self,
        request: blockchain_models.BatchqueryChainBrowserTransactionRequest,
    ) -> blockchain_models.BatchqueryChainBrowserTransactionResponse:
        """
        Description: 阿里云最新区块交易信息查询
        Summary: 阿里云最新区块交易信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchquery_chain_browser_transaction_ex_async(request, headers, runtime)

    def batchquery_chain_browser_transaction_ex(
        self,
        request: blockchain_models.BatchqueryChainBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryChainBrowserTransactionResponse:
        """
        Description: 阿里云最新区块交易信息查询
        Summary: 阿里云最新区块交易信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryChainBrowserTransactionResponse(),
            self.do_request('1.0', 'baas.chain.browser.transaction.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchquery_chain_browser_transaction_ex_async(
        self,
        request: blockchain_models.BatchqueryChainBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryChainBrowserTransactionResponse:
        """
        Description: 阿里云最新区块交易信息查询
        Summary: 阿里云最新区块交易信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryChainBrowserTransactionResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.transaction.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_receipt(
        self,
        request: blockchain_models.QueryChainBrowserReceiptRequest,
    ) -> blockchain_models.QueryChainBrowserReceiptResponse:
        """
        Description: 阿里云区块链交易收据查询
        Summary: 阿里云区块链交易收据查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_receipt_ex(request, headers, runtime)

    async def query_chain_browser_receipt_async(
        self,
        request: blockchain_models.QueryChainBrowserReceiptRequest,
    ) -> blockchain_models.QueryChainBrowserReceiptResponse:
        """
        Description: 阿里云区块链交易收据查询
        Summary: 阿里云区块链交易收据查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_receipt_ex_async(request, headers, runtime)

    def query_chain_browser_receipt_ex(
        self,
        request: blockchain_models.QueryChainBrowserReceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserReceiptResponse:
        """
        Description: 阿里云区块链交易收据查询
        Summary: 阿里云区块链交易收据查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserReceiptResponse(),
            self.do_request('1.0', 'baas.chain.browser.receipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_receipt_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserReceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserReceiptResponse:
        """
        Description: 阿里云区块链交易收据查询
        Summary: 阿里云区块链交易收据查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserReceiptResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.receipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_transaction(
        self,
        request: blockchain_models.QueryChainBrowserTransactionRequest,
    ) -> blockchain_models.QueryChainBrowserTransactionResponse:
        """
        Description: 阿里云区块链交易查询
        Summary: 阿里云区块链交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_transaction_ex(request, headers, runtime)

    async def query_chain_browser_transaction_async(
        self,
        request: blockchain_models.QueryChainBrowserTransactionRequest,
    ) -> blockchain_models.QueryChainBrowserTransactionResponse:
        """
        Description: 阿里云区块链交易查询
        Summary: 阿里云区块链交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_transaction_ex_async(request, headers, runtime)

    def query_chain_browser_transaction_ex(
        self,
        request: blockchain_models.QueryChainBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserTransactionResponse:
        """
        Description: 阿里云区块链交易查询
        Summary: 阿里云区块链交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserTransactionResponse(),
            self.do_request('1.0', 'baas.chain.browser.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_transaction_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserTransactionResponse:
        """
        Description: 阿里云区块链交易查询
        Summary: 阿里云区块链交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserTransactionResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_block(
        self,
        request: blockchain_models.QueryChainBrowserBlockRequest,
    ) -> blockchain_models.QueryChainBrowserBlockResponse:
        """
        Description: 阿里云区块链的区块信息
        Summary: 阿里云区块链的区块信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_block_ex(request, headers, runtime)

    async def query_chain_browser_block_async(
        self,
        request: blockchain_models.QueryChainBrowserBlockRequest,
    ) -> blockchain_models.QueryChainBrowserBlockResponse:
        """
        Description: 阿里云区块链的区块信息
        Summary: 阿里云区块链的区块信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_block_ex_async(request, headers, runtime)

    def query_chain_browser_block_ex(
        self,
        request: blockchain_models.QueryChainBrowserBlockRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserBlockResponse:
        """
        Description: 阿里云区块链的区块信息
        Summary: 阿里云区块链的区块信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserBlockResponse(),
            self.do_request('1.0', 'baas.chain.browser.block.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_block_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserBlockRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserBlockResponse:
        """
        Description: 阿里云区块链的区块信息
        Summary: 阿里云区块链的区块信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserBlockResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.block.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_resouce_region(
        self,
        request: blockchain_models.QueryChainResouceRegionRequest,
    ) -> blockchain_models.QueryChainResouceRegionResponse:
        """
        Description: 阿里云售卖区信息查询
        Summary: 阿里云售卖区信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_resouce_region_ex(request, headers, runtime)

    async def query_chain_resouce_region_async(
        self,
        request: blockchain_models.QueryChainResouceRegionRequest,
    ) -> blockchain_models.QueryChainResouceRegionResponse:
        """
        Description: 阿里云售卖区信息查询
        Summary: 阿里云售卖区信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_resouce_region_ex_async(request, headers, runtime)

    def query_chain_resouce_region_ex(
        self,
        request: blockchain_models.QueryChainResouceRegionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResouceRegionResponse:
        """
        Description: 阿里云售卖区信息查询
        Summary: 阿里云售卖区信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResouceRegionResponse(),
            self.do_request('1.0', 'baas.chain.resouce.region.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_resouce_region_ex_async(
        self,
        request: blockchain_models.QueryChainResouceRegionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResouceRegionResponse:
        """
        Description: 阿里云售卖区信息查询
        Summary: 阿里云售卖区信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResouceRegionResponse(),
            await self.do_request_async('1.0', 'baas.chain.resouce.region.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_resource_type(
        self,
        request: blockchain_models.QueryChainResourceTypeRequest,
    ) -> blockchain_models.QueryChainResourceTypeResponse:
        """
        Description: 阿里云资源类型查询
        Summary: 阿里云资源类型查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_resource_type_ex(request, headers, runtime)

    async def query_chain_resource_type_async(
        self,
        request: blockchain_models.QueryChainResourceTypeRequest,
    ) -> blockchain_models.QueryChainResourceTypeResponse:
        """
        Description: 阿里云资源类型查询
        Summary: 阿里云资源类型查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_resource_type_ex_async(request, headers, runtime)

    def query_chain_resource_type_ex(
        self,
        request: blockchain_models.QueryChainResourceTypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResourceTypeResponse:
        """
        Description: 阿里云资源类型查询
        Summary: 阿里云资源类型查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResourceTypeResponse(),
            self.do_request('1.0', 'baas.chain.resource.type.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_resource_type_ex_async(
        self,
        request: blockchain_models.QueryChainResourceTypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResourceTypeResponse:
        """
        Description: 阿里云资源类型查询
        Summary: 阿里云资源类型查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResourceTypeResponse(),
            await self.do_request_async('1.0', 'baas.chain.resource.type.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_resouce_sale(
        self,
        request: blockchain_models.QueryChainResouceSaleRequest,
    ) -> blockchain_models.QueryChainResouceSaleResponse:
        """
        Description: 阿里云区块链售卖资源查询
        Summary: 阿里云区块链售卖资源查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_resouce_sale_ex(request, headers, runtime)

    async def query_chain_resouce_sale_async(
        self,
        request: blockchain_models.QueryChainResouceSaleRequest,
    ) -> blockchain_models.QueryChainResouceSaleResponse:
        """
        Description: 阿里云区块链售卖资源查询
        Summary: 阿里云区块链售卖资源查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_resouce_sale_ex_async(request, headers, runtime)

    def query_chain_resouce_sale_ex(
        self,
        request: blockchain_models.QueryChainResouceSaleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResouceSaleResponse:
        """
        Description: 阿里云区块链售卖资源查询
        Summary: 阿里云区块链售卖资源查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResouceSaleResponse(),
            self.do_request('1.0', 'baas.chain.resouce.sale.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_resouce_sale_ex_async(
        self,
        request: blockchain_models.QueryChainResouceSaleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResouceSaleResponse:
        """
        Description: 阿里云区块链售卖资源查询
        Summary: 阿里云区块链售卖资源查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResouceSaleResponse(),
            await self.do_request_async('1.0', 'baas.chain.resouce.sale.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_resource_config(
        self,
        request: blockchain_models.QueryChainResourceConfigRequest,
    ) -> blockchain_models.QueryChainResourceConfigResponse:
        """
        Description: 阿里云区块链配置信息查询
        Summary: 阿里云区块链配置信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_resource_config_ex(request, headers, runtime)

    async def query_chain_resource_config_async(
        self,
        request: blockchain_models.QueryChainResourceConfigRequest,
    ) -> blockchain_models.QueryChainResourceConfigResponse:
        """
        Description: 阿里云区块链配置信息查询
        Summary: 阿里云区块链配置信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_resource_config_ex_async(request, headers, runtime)

    def query_chain_resource_config_ex(
        self,
        request: blockchain_models.QueryChainResourceConfigRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResourceConfigResponse:
        """
        Description: 阿里云区块链配置信息查询
        Summary: 阿里云区块链配置信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResourceConfigResponse(),
            self.do_request('1.0', 'baas.chain.resource.config.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_resource_config_ex_async(
        self,
        request: blockchain_models.QueryChainResourceConfigRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainResourceConfigResponse:
        """
        Description: 阿里云区块链配置信息查询
        Summary: 阿里云区块链配置信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainResourceConfigResponse(),
            await self.do_request_async('1.0', 'baas.chain.resource.config.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_browser_statistics(
        self,
        request: blockchain_models.QueryChainBrowserStatisticsRequest,
    ) -> blockchain_models.QueryChainBrowserStatisticsResponse:
        """
        Description: 阿里云区块链交易统计信息
        Summary: 阿里云区块链交易统计信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_browser_statistics_ex(request, headers, runtime)

    async def query_chain_browser_statistics_async(
        self,
        request: blockchain_models.QueryChainBrowserStatisticsRequest,
    ) -> blockchain_models.QueryChainBrowserStatisticsResponse:
        """
        Description: 阿里云区块链交易统计信息
        Summary: 阿里云区块链交易统计信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_browser_statistics_ex_async(request, headers, runtime)

    def query_chain_browser_statistics_ex(
        self,
        request: blockchain_models.QueryChainBrowserStatisticsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserStatisticsResponse:
        """
        Description: 阿里云区块链交易统计信息
        Summary: 阿里云区块链交易统计信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserStatisticsResponse(),
            self.do_request('1.0', 'baas.chain.browser.statistics.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_browser_statistics_ex_async(
        self,
        request: blockchain_models.QueryChainBrowserStatisticsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainBrowserStatisticsResponse:
        """
        Description: 阿里云区块链交易统计信息
        Summary: 阿里云区块链交易统计信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainBrowserStatisticsResponse(),
            await self.do_request_async('1.0', 'baas.chain.browser.statistics.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_chain_public_contract(
        self,
        request: blockchain_models.ExecChainPublicContractRequest,
    ) -> blockchain_models.ExecChainPublicContractResponse:
        """
        Description: 阿里云区块链交易执行交易
        Summary: 阿里云区块链交易执行交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_chain_public_contract_ex(request, headers, runtime)

    async def exec_chain_public_contract_async(
        self,
        request: blockchain_models.ExecChainPublicContractRequest,
    ) -> blockchain_models.ExecChainPublicContractResponse:
        """
        Description: 阿里云区块链交易执行交易
        Summary: 阿里云区块链交易执行交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_chain_public_contract_ex_async(request, headers, runtime)

    def exec_chain_public_contract_ex(
        self,
        request: blockchain_models.ExecChainPublicContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainPublicContractResponse:
        """
        Description: 阿里云区块链交易执行交易
        Summary: 阿里云区块链交易执行交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainPublicContractResponse(),
            self.do_request('1.0', 'baas.chain.public.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_chain_public_contract_ex_async(
        self,
        request: blockchain_models.ExecChainPublicContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainPublicContractResponse:
        """
        Description: 阿里云区块链交易执行交易
        Summary: 阿里云区块链交易执行交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainPublicContractResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_public_ide(
        self,
        request: blockchain_models.QueryChainPublicIdeRequest,
    ) -> blockchain_models.QueryChainPublicIdeResponse:
        """
        Description: 阿里云免费体验链的cloudIde查询
        Summary: 阿里云免费体验链的cloudIde查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_public_ide_ex(request, headers, runtime)

    async def query_chain_public_ide_async(
        self,
        request: blockchain_models.QueryChainPublicIdeRequest,
    ) -> blockchain_models.QueryChainPublicIdeResponse:
        """
        Description: 阿里云免费体验链的cloudIde查询
        Summary: 阿里云免费体验链的cloudIde查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_public_ide_ex_async(request, headers, runtime)

    def query_chain_public_ide_ex(
        self,
        request: blockchain_models.QueryChainPublicIdeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicIdeResponse:
        """
        Description: 阿里云免费体验链的cloudIde查询
        Summary: 阿里云免费体验链的cloudIde查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicIdeResponse(),
            self.do_request('1.0', 'baas.chain.public.ide.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_public_ide_ex_async(
        self,
        request: blockchain_models.QueryChainPublicIdeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicIdeResponse:
        """
        Description: 阿里云免费体验链的cloudIde查询
        Summary: 阿里云免费体验链的cloudIde查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicIdeResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.ide.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_public_content(
        self,
        request: blockchain_models.QueryChainPublicContentRequest,
    ) -> blockchain_models.QueryChainPublicContentResponse:
        """
        Description: 阿里云免费体验链合约文件和内容查询
        Summary: 阿里云免费体验链合约文件和内容查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_public_content_ex(request, headers, runtime)

    async def query_chain_public_content_async(
        self,
        request: blockchain_models.QueryChainPublicContentRequest,
    ) -> blockchain_models.QueryChainPublicContentResponse:
        """
        Description: 阿里云免费体验链合约文件和内容查询
        Summary: 阿里云免费体验链合约文件和内容查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_public_content_ex_async(request, headers, runtime)

    def query_chain_public_content_ex(
        self,
        request: blockchain_models.QueryChainPublicContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicContentResponse:
        """
        Description: 阿里云免费体验链合约文件和内容查询
        Summary: 阿里云免费体验链合约文件和内容查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicContentResponse(),
            self.do_request('1.0', 'baas.chain.public.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_public_content_ex_async(
        self,
        request: blockchain_models.QueryChainPublicContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicContentResponse:
        """
        Description: 阿里云免费体验链合约文件和内容查询
        Summary: 阿里云免费体验链合约文件和内容查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicContentResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_contract_project(
        self,
        request: blockchain_models.CreateChainContractProjectRequest,
    ) -> blockchain_models.CreateChainContractProjectResponse:
        """
        Description: 阿里云合约工程创建
        Summary: 阿里云合约工程创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_contract_project_ex(request, headers, runtime)

    async def create_chain_contract_project_async(
        self,
        request: blockchain_models.CreateChainContractProjectRequest,
    ) -> blockchain_models.CreateChainContractProjectResponse:
        """
        Description: 阿里云合约工程创建
        Summary: 阿里云合约工程创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_contract_project_ex_async(request, headers, runtime)

    def create_chain_contract_project_ex(
        self,
        request: blockchain_models.CreateChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainContractProjectResponse:
        """
        Description: 阿里云合约工程创建
        Summary: 阿里云合约工程创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_contract_project_ex_async(
        self,
        request: blockchain_models.CreateChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainContractProjectResponse:
        """
        Description: 阿里云合约工程创建
        Summary: 阿里云合约工程创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_chain_contract_project(
        self,
        request: blockchain_models.DeleteChainContractProjectRequest,
    ) -> blockchain_models.DeleteChainContractProjectResponse:
        """
        Description: 阿里云合约工程删除
        Summary: 阿里云合约工程删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_chain_contract_project_ex(request, headers, runtime)

    async def delete_chain_contract_project_async(
        self,
        request: blockchain_models.DeleteChainContractProjectRequest,
    ) -> blockchain_models.DeleteChainContractProjectResponse:
        """
        Description: 阿里云合约工程删除
        Summary: 阿里云合约工程删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_chain_contract_project_ex_async(request, headers, runtime)

    def delete_chain_contract_project_ex(
        self,
        request: blockchain_models.DeleteChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainContractProjectResponse:
        """
        Description: 阿里云合约工程删除
        Summary: 阿里云合约工程删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_chain_contract_project_ex_async(
        self,
        request: blockchain_models.DeleteChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainContractProjectResponse:
        """
        Description: 阿里云合约工程删除
        Summary: 阿里云合约工程删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def clone_chain_contract_project(
        self,
        request: blockchain_models.CloneChainContractProjectRequest,
    ) -> blockchain_models.CloneChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.clone_chain_contract_project_ex(request, headers, runtime)

    async def clone_chain_contract_project_async(
        self,
        request: blockchain_models.CloneChainContractProjectRequest,
    ) -> blockchain_models.CloneChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.clone_chain_contract_project_ex_async(request, headers, runtime)

    def clone_chain_contract_project_ex(
        self,
        request: blockchain_models.CloneChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloneChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloneChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.clone', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def clone_chain_contract_project_ex_async(
        self,
        request: blockchain_models.CloneChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloneChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloneChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.clone', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_contract_project(
        self,
        request: blockchain_models.QueryChainContractProjectRequest,
    ) -> blockchain_models.QueryChainContractProjectResponse:
        """
        Description: 阿里云合约工程信息查询
        Summary: 阿里云合约工程信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_contract_project_ex(request, headers, runtime)

    async def query_chain_contract_project_async(
        self,
        request: blockchain_models.QueryChainContractProjectRequest,
    ) -> blockchain_models.QueryChainContractProjectResponse:
        """
        Description: 阿里云合约工程信息查询
        Summary: 阿里云合约工程信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_contract_project_ex_async(request, headers, runtime)

    def query_chain_contract_project_ex(
        self,
        request: blockchain_models.QueryChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainContractProjectResponse:
        """
        Description: 阿里云合约工程信息查询
        Summary: 阿里云合约工程信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_contract_project_ex_async(
        self,
        request: blockchain_models.QueryChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainContractProjectResponse:
        """
        Description: 阿里云合约工程信息查询
        Summary: 阿里云合约工程信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def retry_chain_contract_project(
        self,
        request: blockchain_models.RetryChainContractProjectRequest,
    ) -> blockchain_models.RetryChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.retry_chain_contract_project_ex(request, headers, runtime)

    async def retry_chain_contract_project_async(
        self,
        request: blockchain_models.RetryChainContractProjectRequest,
    ) -> blockchain_models.RetryChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.retry_chain_contract_project_ex_async(request, headers, runtime)

    def retry_chain_contract_project_ex(
        self,
        request: blockchain_models.RetryChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RetryChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RetryChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.retry', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def retry_chain_contract_project_ex_async(
        self,
        request: blockchain_models.RetryChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RetryChainContractProjectResponse:
        """
        Description: 复制阿里云合约工程
        Summary: 复制阿里云合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RetryChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.retry', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_contract_project(
        self,
        request: blockchain_models.UpdateChainContractProjectRequest,
    ) -> blockchain_models.UpdateChainContractProjectResponse:
        """
        Description: 更新阿里云区块链的合约工程
        Summary: 更新阿里云区块链的合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_contract_project_ex(request, headers, runtime)

    async def update_chain_contract_project_async(
        self,
        request: blockchain_models.UpdateChainContractProjectRequest,
    ) -> blockchain_models.UpdateChainContractProjectResponse:
        """
        Description: 更新阿里云区块链的合约工程
        Summary: 更新阿里云区块链的合约工程
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_contract_project_ex_async(request, headers, runtime)

    def update_chain_contract_project_ex(
        self,
        request: blockchain_models.UpdateChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainContractProjectResponse:
        """
        Description: 更新阿里云区块链的合约工程
        Summary: 更新阿里云区块链的合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainContractProjectResponse(),
            self.do_request('1.0', 'baas.chain.contract.project.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_contract_project_ex_async(
        self,
        request: blockchain_models.UpdateChainContractProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainContractProjectResponse:
        """
        Description: 更新阿里云区块链的合约工程
        Summary: 更新阿里云区块链的合约工程
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainContractProjectResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.project.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_contract_content(
        self,
        request: blockchain_models.CreateChainContractContentRequest,
    ) -> blockchain_models.CreateChainContractContentResponse:
        """
        Description: 创建合约文件内容
        Summary: 创建合约文件内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_contract_content_ex(request, headers, runtime)

    async def create_chain_contract_content_async(
        self,
        request: blockchain_models.CreateChainContractContentRequest,
    ) -> blockchain_models.CreateChainContractContentResponse:
        """
        Description: 创建合约文件内容
        Summary: 创建合约文件内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_contract_content_ex_async(request, headers, runtime)

    def create_chain_contract_content_ex(
        self,
        request: blockchain_models.CreateChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainContractContentResponse:
        """
        Description: 创建合约文件内容
        Summary: 创建合约文件内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainContractContentResponse(),
            self.do_request('1.0', 'baas.chain.contract.content.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_contract_content_ex_async(
        self,
        request: blockchain_models.CreateChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainContractContentResponse:
        """
        Description: 创建合约文件内容
        Summary: 创建合约文件内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainContractContentResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.content.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_contract_content(
        self,
        request: blockchain_models.UpdateChainContractContentRequest,
    ) -> blockchain_models.UpdateChainContractContentResponse:
        """
        Description: 更新阿里云合约文件内容
        Summary: 更新阿里云合约文件内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_contract_content_ex(request, headers, runtime)

    async def update_chain_contract_content_async(
        self,
        request: blockchain_models.UpdateChainContractContentRequest,
    ) -> blockchain_models.UpdateChainContractContentResponse:
        """
        Description: 更新阿里云合约文件内容
        Summary: 更新阿里云合约文件内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_contract_content_ex_async(request, headers, runtime)

    def update_chain_contract_content_ex(
        self,
        request: blockchain_models.UpdateChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainContractContentResponse:
        """
        Description: 更新阿里云合约文件内容
        Summary: 更新阿里云合约文件内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainContractContentResponse(),
            self.do_request('1.0', 'baas.chain.contract.content.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_contract_content_ex_async(
        self,
        request: blockchain_models.UpdateChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainContractContentResponse:
        """
        Description: 更新阿里云合约文件内容
        Summary: 更新阿里云合约文件内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainContractContentResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.content.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_contract_content(
        self,
        request: blockchain_models.QueryChainContractContentRequest,
    ) -> blockchain_models.QueryChainContractContentResponse:
        """
        Description: 阿里云合约文件信息查询
        Summary: 阿里云合约文件信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_contract_content_ex(request, headers, runtime)

    async def query_chain_contract_content_async(
        self,
        request: blockchain_models.QueryChainContractContentRequest,
    ) -> blockchain_models.QueryChainContractContentResponse:
        """
        Description: 阿里云合约文件信息查询
        Summary: 阿里云合约文件信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_contract_content_ex_async(request, headers, runtime)

    def query_chain_contract_content_ex(
        self,
        request: blockchain_models.QueryChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainContractContentResponse:
        """
        Description: 阿里云合约文件信息查询
        Summary: 阿里云合约文件信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainContractContentResponse(),
            self.do_request('1.0', 'baas.chain.contract.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_contract_content_ex_async(
        self,
        request: blockchain_models.QueryChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainContractContentResponse:
        """
        Description: 阿里云合约文件信息查询
        Summary: 阿里云合约文件信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainContractContentResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_chain_contract(
        self,
        request: blockchain_models.ExecChainContractRequest,
    ) -> blockchain_models.ExecChainContractResponse:
        """
        Description: 阿里云区块链合约执行接口
        Summary: 阿里云区块链合约执行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_chain_contract_ex(request, headers, runtime)

    async def exec_chain_contract_async(
        self,
        request: blockchain_models.ExecChainContractRequest,
    ) -> blockchain_models.ExecChainContractResponse:
        """
        Description: 阿里云区块链合约执行接口
        Summary: 阿里云区块链合约执行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_chain_contract_ex_async(request, headers, runtime)

    def exec_chain_contract_ex(
        self,
        request: blockchain_models.ExecChainContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainContractResponse:
        """
        Description: 阿里云区块链合约执行接口
        Summary: 阿里云区块链合约执行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainContractResponse(),
            self.do_request('1.0', 'baas.chain.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_chain_contract_ex_async(
        self,
        request: blockchain_models.ExecChainContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainContractResponse:
        """
        Description: 阿里云区块链合约执行接口
        Summary: 阿里云区块链合约执行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainContractResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_ide(
        self,
        request: blockchain_models.QueryChainIdeRequest,
    ) -> blockchain_models.QueryChainIdeResponse:
        """
        Description: 阿里云区块链CloudIde配置查询
        Summary: 阿里云区块链CloudIde配置查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_ide_ex(request, headers, runtime)

    async def query_chain_ide_async(
        self,
        request: blockchain_models.QueryChainIdeRequest,
    ) -> blockchain_models.QueryChainIdeResponse:
        """
        Description: 阿里云区块链CloudIde配置查询
        Summary: 阿里云区块链CloudIde配置查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_ide_ex_async(request, headers, runtime)

    def query_chain_ide_ex(
        self,
        request: blockchain_models.QueryChainIdeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainIdeResponse:
        """
        Description: 阿里云区块链CloudIde配置查询
        Summary: 阿里云区块链CloudIde配置查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainIdeResponse(),
            self.do_request('1.0', 'baas.chain.ide.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_ide_ex_async(
        self,
        request: blockchain_models.QueryChainIdeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainIdeResponse:
        """
        Description: 阿里云区块链CloudIde配置查询
        Summary: 阿里云区块链CloudIde配置查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainIdeResponse(),
            await self.do_request_async('1.0', 'baas.chain.ide.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_chain_contract_content(
        self,
        request: blockchain_models.DeleteChainContractContentRequest,
    ) -> blockchain_models.DeleteChainContractContentResponse:
        """
        Description: 阿里云区块链合约文件删除
        Summary: 阿里云区块链合约文件删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_chain_contract_content_ex(request, headers, runtime)

    async def delete_chain_contract_content_async(
        self,
        request: blockchain_models.DeleteChainContractContentRequest,
    ) -> blockchain_models.DeleteChainContractContentResponse:
        """
        Description: 阿里云区块链合约文件删除
        Summary: 阿里云区块链合约文件删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_chain_contract_content_ex_async(request, headers, runtime)

    def delete_chain_contract_content_ex(
        self,
        request: blockchain_models.DeleteChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainContractContentResponse:
        """
        Description: 阿里云区块链合约文件删除
        Summary: 阿里云区块链合约文件删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainContractContentResponse(),
            self.do_request('1.0', 'baas.chain.contract.content.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_chain_contract_content_ex_async(
        self,
        request: blockchain_models.DeleteChainContractContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainContractContentResponse:
        """
        Description: 阿里云区块链合约文件删除
        Summary: 阿里云区块链合约文件删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainContractContentResponse(),
            await self.do_request_async('1.0', 'baas.chain.contract.content.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_chain_miniapp_user(
        self,
        request: blockchain_models.BatchcreateChainMiniappUserRequest,
    ) -> blockchain_models.BatchcreateChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限添加
        Summary: 阿里云区块链小程序用户权限添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_chain_miniapp_user_ex(request, headers, runtime)

    async def batchcreate_chain_miniapp_user_async(
        self,
        request: blockchain_models.BatchcreateChainMiniappUserRequest,
    ) -> blockchain_models.BatchcreateChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限添加
        Summary: 阿里云区块链小程序用户权限添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_chain_miniapp_user_ex_async(request, headers, runtime)

    def batchcreate_chain_miniapp_user_ex(
        self,
        request: blockchain_models.BatchcreateChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限添加
        Summary: 阿里云区块链小程序用户权限添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateChainMiniappUserResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.user.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_chain_miniapp_user_ex_async(
        self,
        request: blockchain_models.BatchcreateChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限添加
        Summary: 阿里云区块链小程序用户权限添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateChainMiniappUserResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.user.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_chain_miniapp_user(
        self,
        request: blockchain_models.DeleteChainMiniappUserRequest,
    ) -> blockchain_models.DeleteChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限删除
        Summary: 阿里云区块链小程序用户权限删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_chain_miniapp_user_ex(request, headers, runtime)

    async def delete_chain_miniapp_user_async(
        self,
        request: blockchain_models.DeleteChainMiniappUserRequest,
    ) -> blockchain_models.DeleteChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限删除
        Summary: 阿里云区块链小程序用户权限删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_chain_miniapp_user_ex_async(request, headers, runtime)

    def delete_chain_miniapp_user_ex(
        self,
        request: blockchain_models.DeleteChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限删除
        Summary: 阿里云区块链小程序用户权限删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainMiniappUserResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.user.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_chain_miniapp_user_ex_async(
        self,
        request: blockchain_models.DeleteChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainMiniappUserResponse:
        """
        Description: 阿里云区块链小程序用户权限删除
        Summary: 阿里云区块链小程序用户权限删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainMiniappUserResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.user.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchquery_chain_miniapp_user(
        self,
        request: blockchain_models.BatchqueryChainMiniappUserRequest,
    ) -> blockchain_models.BatchqueryChainMiniappUserResponse:
        """
        Description: 阿里云区块链所有用户权限查询
        Summary: 阿里云区块链所有用户权限查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchquery_chain_miniapp_user_ex(request, headers, runtime)

    async def batchquery_chain_miniapp_user_async(
        self,
        request: blockchain_models.BatchqueryChainMiniappUserRequest,
    ) -> blockchain_models.BatchqueryChainMiniappUserResponse:
        """
        Description: 阿里云区块链所有用户权限查询
        Summary: 阿里云区块链所有用户权限查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchquery_chain_miniapp_user_ex_async(request, headers, runtime)

    def batchquery_chain_miniapp_user_ex(
        self,
        request: blockchain_models.BatchqueryChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryChainMiniappUserResponse:
        """
        Description: 阿里云区块链所有用户权限查询
        Summary: 阿里云区块链所有用户权限查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryChainMiniappUserResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.user.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchquery_chain_miniapp_user_ex_async(
        self,
        request: blockchain_models.BatchqueryChainMiniappUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchqueryChainMiniappUserResponse:
        """
        Description: 阿里云区块链所有用户权限查询
        Summary: 阿里云区块链所有用户权限查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchqueryChainMiniappUserResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.user.batchquery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_miniapp_authorization(
        self,
        request: blockchain_models.QueryChainMiniappAuthorizationRequest,
    ) -> blockchain_models.QueryChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制查询
        Summary: 阿里云区块链小程序权限控制查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_miniapp_authorization_ex(request, headers, runtime)

    async def query_chain_miniapp_authorization_async(
        self,
        request: blockchain_models.QueryChainMiniappAuthorizationRequest,
    ) -> blockchain_models.QueryChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制查询
        Summary: 阿里云区块链小程序权限控制查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_miniapp_authorization_ex_async(request, headers, runtime)

    def query_chain_miniapp_authorization_ex(
        self,
        request: blockchain_models.QueryChainMiniappAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制查询
        Summary: 阿里云区块链小程序权限控制查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappAuthorizationResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.authorization.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_miniapp_authorization_ex_async(
        self,
        request: blockchain_models.QueryChainMiniappAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制查询
        Summary: 阿里云区块链小程序权限控制查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.authorization.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_miniapp_authorization(
        self,
        request: blockchain_models.UpdateChainMiniappAuthorizationRequest,
    ) -> blockchain_models.UpdateChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制变更
        Summary: 阿里云区块链小程序权限控制变更
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_miniapp_authorization_ex(request, headers, runtime)

    async def update_chain_miniapp_authorization_async(
        self,
        request: blockchain_models.UpdateChainMiniappAuthorizationRequest,
    ) -> blockchain_models.UpdateChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制变更
        Summary: 阿里云区块链小程序权限控制变更
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_miniapp_authorization_ex_async(request, headers, runtime)

    def update_chain_miniapp_authorization_ex(
        self,
        request: blockchain_models.UpdateChainMiniappAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制变更
        Summary: 阿里云区块链小程序权限控制变更
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainMiniappAuthorizationResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.authorization.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_miniapp_authorization_ex_async(
        self,
        request: blockchain_models.UpdateChainMiniappAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainMiniappAuthorizationResponse:
        """
        Description: 阿里云区块链小程序权限控制变更
        Summary: 阿里云区块链小程序权限控制变更
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainMiniappAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.authorization.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_miniapp_transaction(
        self,
        request: blockchain_models.QueryChainMiniappTransactionRequest,
    ) -> blockchain_models.QueryChainMiniappTransactionResponse:
        """
        Description: 阿里云区块链小程序交易查询
        Summary: 阿里云区块链小程序交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_miniapp_transaction_ex(request, headers, runtime)

    async def query_chain_miniapp_transaction_async(
        self,
        request: blockchain_models.QueryChainMiniappTransactionRequest,
    ) -> blockchain_models.QueryChainMiniappTransactionResponse:
        """
        Description: 阿里云区块链小程序交易查询
        Summary: 阿里云区块链小程序交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_miniapp_transaction_ex_async(request, headers, runtime)

    def query_chain_miniapp_transaction_ex(
        self,
        request: blockchain_models.QueryChainMiniappTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappTransactionResponse:
        """
        Description: 阿里云区块链小程序交易查询
        Summary: 阿里云区块链小程序交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappTransactionResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_miniapp_transaction_ex_async(
        self,
        request: blockchain_models.QueryChainMiniappTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappTransactionResponse:
        """
        Description: 阿里云区块链小程序交易查询
        Summary: 阿里云区块链小程序交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappTransactionResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_miniapp_log(
        self,
        request: blockchain_models.QueryChainMiniappLogRequest,
    ) -> blockchain_models.QueryChainMiniappLogResponse:
        """
        Description: 阿里云区块链小程序交易查询的记录
        Summary: 阿里云区块链小程序交易查询的记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_miniapp_log_ex(request, headers, runtime)

    async def query_chain_miniapp_log_async(
        self,
        request: blockchain_models.QueryChainMiniappLogRequest,
    ) -> blockchain_models.QueryChainMiniappLogResponse:
        """
        Description: 阿里云区块链小程序交易查询的记录
        Summary: 阿里云区块链小程序交易查询的记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_miniapp_log_ex_async(request, headers, runtime)

    def query_chain_miniapp_log_ex(
        self,
        request: blockchain_models.QueryChainMiniappLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappLogResponse:
        """
        Description: 阿里云区块链小程序交易查询的记录
        Summary: 阿里云区块链小程序交易查询的记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappLogResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.log.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_miniapp_log_ex_async(
        self,
        request: blockchain_models.QueryChainMiniappLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMiniappLogResponse:
        """
        Description: 阿里云区块链小程序交易查询的记录
        Summary: 阿里云区块链小程序交易查询的记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMiniappLogResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.log.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_miniapp_code(
        self,
        request: blockchain_models.CreateChainMiniappCodeRequest,
    ) -> blockchain_models.CreateChainMiniappCodeResponse:
        """
        Description: 阿里云生成小程序二维码
        Summary: 阿里云生成小程序二维码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_miniapp_code_ex(request, headers, runtime)

    async def create_chain_miniapp_code_async(
        self,
        request: blockchain_models.CreateChainMiniappCodeRequest,
    ) -> blockchain_models.CreateChainMiniappCodeResponse:
        """
        Description: 阿里云生成小程序二维码
        Summary: 阿里云生成小程序二维码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_miniapp_code_ex_async(request, headers, runtime)

    def create_chain_miniapp_code_ex(
        self,
        request: blockchain_models.CreateChainMiniappCodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainMiniappCodeResponse:
        """
        Description: 阿里云生成小程序二维码
        Summary: 阿里云生成小程序二维码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainMiniappCodeResponse(),
            self.do_request('1.0', 'baas.chain.miniapp.code.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_miniapp_code_ex_async(
        self,
        request: blockchain_models.CreateChainMiniappCodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainMiniappCodeResponse:
        """
        Description: 阿里云生成小程序二维码
        Summary: 阿里云生成小程序二维码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainMiniappCodeResponse(),
            await self.do_request_async('1.0', 'baas.chain.miniapp.code.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_union_buy(
        self,
        request: blockchain_models.QueryUnionBuyRequest,
    ) -> blockchain_models.QueryUnionBuyResponse:
        """
        Description: 阿里云售卖页联盟信息查询
        Summary: 阿里云售卖页联盟信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_union_buy_ex(request, headers, runtime)

    async def query_union_buy_async(
        self,
        request: blockchain_models.QueryUnionBuyRequest,
    ) -> blockchain_models.QueryUnionBuyResponse:
        """
        Description: 阿里云售卖页联盟信息查询
        Summary: 阿里云售卖页联盟信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_union_buy_ex_async(request, headers, runtime)

    def query_union_buy_ex(
        self,
        request: blockchain_models.QueryUnionBuyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionBuyResponse:
        """
        Description: 阿里云售卖页联盟信息查询
        Summary: 阿里云售卖页联盟信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionBuyResponse(),
            self.do_request('1.0', 'baas.union.buy.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_union_buy_ex_async(
        self,
        request: blockchain_models.QueryUnionBuyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryUnionBuyResponse:
        """
        Description: 阿里云售卖页联盟信息查询
        Summary: 阿里云售卖页联盟信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryUnionBuyResponse(),
            await self.do_request_async('1.0', 'baas.union.buy.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_public_rest(
        self,
        request: blockchain_models.QueryChainPublicRestRequest,
    ) -> blockchain_models.QueryChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链Rest查询
        Summary: 阿里云国内站免费体验链Rest查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_public_rest_ex(request, headers, runtime)

    async def query_chain_public_rest_async(
        self,
        request: blockchain_models.QueryChainPublicRestRequest,
    ) -> blockchain_models.QueryChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链Rest查询
        Summary: 阿里云国内站免费体验链Rest查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_public_rest_ex_async(request, headers, runtime)

    def query_chain_public_rest_ex(
        self,
        request: blockchain_models.QueryChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链Rest查询
        Summary: 阿里云国内站免费体验链Rest查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicRestResponse(),
            self.do_request('1.0', 'baas.chain.public.rest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_public_rest_ex_async(
        self,
        request: blockchain_models.QueryChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链Rest查询
        Summary: 阿里云国内站免费体验链Rest查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainPublicRestResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.rest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_public_rest(
        self,
        request: blockchain_models.ApplyChainPublicRestRequest,
    ) -> blockchain_models.ApplyChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链申请Rest
        Summary: 阿里云国内站免费体验链申请Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_public_rest_ex(request, headers, runtime)

    async def apply_chain_public_rest_async(
        self,
        request: blockchain_models.ApplyChainPublicRestRequest,
    ) -> blockchain_models.ApplyChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链申请Rest
        Summary: 阿里云国内站免费体验链申请Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_public_rest_ex_async(request, headers, runtime)

    def apply_chain_public_rest_ex(
        self,
        request: blockchain_models.ApplyChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链申请Rest
        Summary: 阿里云国内站免费体验链申请Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicRestResponse(),
            self.do_request('1.0', 'baas.chain.public.rest.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_public_rest_ex_async(
        self,
        request: blockchain_models.ApplyChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainPublicRestResponse:
        """
        Description: 阿里云国内站免费体验链申请Rest
        Summary: 阿里云国内站免费体验链申请Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainPublicRestResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.rest.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reinit_chain_public_rest(
        self,
        request: blockchain_models.ReinitChainPublicRestRequest,
    ) -> blockchain_models.ReinitChainPublicRestResponse:
        """
        Description: 阿里云国内站重置Rest
        Summary: 阿里云国内站重置Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reinit_chain_public_rest_ex(request, headers, runtime)

    async def reinit_chain_public_rest_async(
        self,
        request: blockchain_models.ReinitChainPublicRestRequest,
    ) -> blockchain_models.ReinitChainPublicRestResponse:
        """
        Description: 阿里云国内站重置Rest
        Summary: 阿里云国内站重置Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reinit_chain_public_rest_ex_async(request, headers, runtime)

    def reinit_chain_public_rest_ex(
        self,
        request: blockchain_models.ReinitChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainPublicRestResponse:
        """
        Description: 阿里云国内站重置Rest
        Summary: 阿里云国内站重置Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainPublicRestResponse(),
            self.do_request('1.0', 'baas.chain.public.rest.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reinit_chain_public_rest_ex_async(
        self,
        request: blockchain_models.ReinitChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainPublicRestResponse:
        """
        Description: 阿里云国内站重置Rest
        Summary: 阿里云国内站重置Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainPublicRestResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.rest.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_rest_ant(
        self,
        request: blockchain_models.QueryChainRestAntRequest,
    ) -> blockchain_models.QueryChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest查询
        Summary: 阿里云国内站区块链rest查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_rest_ant_ex(request, headers, runtime)

    async def query_chain_rest_ant_async(
        self,
        request: blockchain_models.QueryChainRestAntRequest,
    ) -> blockchain_models.QueryChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest查询
        Summary: 阿里云国内站区块链rest查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_rest_ant_ex_async(request, headers, runtime)

    def query_chain_rest_ant_ex(
        self,
        request: blockchain_models.QueryChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest查询
        Summary: 阿里云国内站区块链rest查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainRestAntResponse(),
            self.do_request('1.0', 'baas.chain.rest.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_rest_ant_ex_async(
        self,
        request: blockchain_models.QueryChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest查询
        Summary: 阿里云国内站区块链rest查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainRestAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.rest.ant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_rest_ant(
        self,
        request: blockchain_models.ApplyChainRestAntRequest,
    ) -> blockchain_models.ApplyChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest申请
        Summary: 阿里云国内站区块链rest申请
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_rest_ant_ex(request, headers, runtime)

    async def apply_chain_rest_ant_async(
        self,
        request: blockchain_models.ApplyChainRestAntRequest,
    ) -> blockchain_models.ApplyChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest申请
        Summary: 阿里云国内站区块链rest申请
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_rest_ant_ex_async(request, headers, runtime)

    def apply_chain_rest_ant_ex(
        self,
        request: blockchain_models.ApplyChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest申请
        Summary: 阿里云国内站区块链rest申请
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainRestAntResponse(),
            self.do_request('1.0', 'baas.chain.rest.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_rest_ant_ex_async(
        self,
        request: blockchain_models.ApplyChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainRestAntResponse:
        """
        Description: 阿里云国内站区块链rest申请
        Summary: 阿里云国内站区块链rest申请
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainRestAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.rest.ant.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reinit_chain_rest_ant(
        self,
        request: blockchain_models.ReinitChainRestAntRequest,
    ) -> blockchain_models.ReinitChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置Rest
        Summary: 阿里云国内站区块链重置Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reinit_chain_rest_ant_ex(request, headers, runtime)

    async def reinit_chain_rest_ant_async(
        self,
        request: blockchain_models.ReinitChainRestAntRequest,
    ) -> blockchain_models.ReinitChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置Rest
        Summary: 阿里云国内站区块链重置Rest
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reinit_chain_rest_ant_ex_async(request, headers, runtime)

    def reinit_chain_rest_ant_ex(
        self,
        request: blockchain_models.ReinitChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置Rest
        Summary: 阿里云国内站区块链重置Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainRestAntResponse(),
            self.do_request('1.0', 'baas.chain.rest.ant.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reinit_chain_rest_ant_ex_async(
        self,
        request: blockchain_models.ReinitChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReinitChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置Rest
        Summary: 阿里云国内站区块链重置Rest
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReinitChainRestAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.rest.ant.reinit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def send_chain_public_rest(
        self,
        request: blockchain_models.SendChainPublicRestRequest,
    ) -> blockchain_models.SendChainPublicRestResponse:
        """
        Description: 阿里云国内站公共链重置rest发送验证码
        Summary: 阿里云国内站公共链重置rest发送验证码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.send_chain_public_rest_ex(request, headers, runtime)

    async def send_chain_public_rest_async(
        self,
        request: blockchain_models.SendChainPublicRestRequest,
    ) -> blockchain_models.SendChainPublicRestResponse:
        """
        Description: 阿里云国内站公共链重置rest发送验证码
        Summary: 阿里云国内站公共链重置rest发送验证码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.send_chain_public_rest_ex_async(request, headers, runtime)

    def send_chain_public_rest_ex(
        self,
        request: blockchain_models.SendChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendChainPublicRestResponse:
        """
        Description: 阿里云国内站公共链重置rest发送验证码
        Summary: 阿里云国内站公共链重置rest发送验证码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendChainPublicRestResponse(),
            self.do_request('1.0', 'baas.chain.public.rest.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def send_chain_public_rest_ex_async(
        self,
        request: blockchain_models.SendChainPublicRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendChainPublicRestResponse:
        """
        Description: 阿里云国内站公共链重置rest发送验证码
        Summary: 阿里云国内站公共链重置rest发送验证码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendChainPublicRestResponse(),
            await self.do_request_async('1.0', 'baas.chain.public.rest.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def send_chain_rest_ant(
        self,
        request: blockchain_models.SendChainRestAntRequest,
    ) -> blockchain_models.SendChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置rest发送验证码
        Summary: 阿里云国内站区块链重置rest发送验证码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.send_chain_rest_ant_ex(request, headers, runtime)

    async def send_chain_rest_ant_async(
        self,
        request: blockchain_models.SendChainRestAntRequest,
    ) -> blockchain_models.SendChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置rest发送验证码
        Summary: 阿里云国内站区块链重置rest发送验证码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.send_chain_rest_ant_ex_async(request, headers, runtime)

    def send_chain_rest_ant_ex(
        self,
        request: blockchain_models.SendChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置rest发送验证码
        Summary: 阿里云国内站区块链重置rest发送验证码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendChainRestAntResponse(),
            self.do_request('1.0', 'baas.chain.rest.ant.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def send_chain_rest_ant_ex_async(
        self,
        request: blockchain_models.SendChainRestAntRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendChainRestAntResponse:
        """
        Description: 阿里云国内站区块链重置rest发送验证码
        Summary: 阿里云国内站区块链重置rest发送验证码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendChainRestAntResponse(),
            await self.do_request_async('1.0', 'baas.chain.rest.ant.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_subnet(
        self,
        request: blockchain_models.QueryChainSubnetRequest,
    ) -> blockchain_models.QueryChainSubnetResponse:
        """
        Description: 阿里云子链列表查询
        Summary: 阿里云子链列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_subnet_ex(request, headers, runtime)

    async def query_chain_subnet_async(
        self,
        request: blockchain_models.QueryChainSubnetRequest,
    ) -> blockchain_models.QueryChainSubnetResponse:
        """
        Description: 阿里云子链列表查询
        Summary: 阿里云子链列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_subnet_ex_async(request, headers, runtime)

    def query_chain_subnet_ex(
        self,
        request: blockchain_models.QueryChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetResponse:
        """
        Description: 阿里云子链列表查询
        Summary: 阿里云子链列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetResponse(),
            self.do_request('1.0', 'baas.chain.subnet.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_subnet_ex_async(
        self,
        request: blockchain_models.QueryChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetResponse:
        """
        Description: 阿里云子链列表查询
        Summary: 阿里云子链列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_chain_subnet_create(
        self,
        request: blockchain_models.CheckChainSubnetCreateRequest,
    ) -> blockchain_models.CheckChainSubnetCreateResponse:
        """
        Description: 阿里云子链创建的前置检查
        Summary: 阿里云子链创建的前置检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_chain_subnet_create_ex(request, headers, runtime)

    async def check_chain_subnet_create_async(
        self,
        request: blockchain_models.CheckChainSubnetCreateRequest,
    ) -> blockchain_models.CheckChainSubnetCreateResponse:
        """
        Description: 阿里云子链创建的前置检查
        Summary: 阿里云子链创建的前置检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_chain_subnet_create_ex_async(request, headers, runtime)

    def check_chain_subnet_create_ex(
        self,
        request: blockchain_models.CheckChainSubnetCreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetCreateResponse:
        """
        Description: 阿里云子链创建的前置检查
        Summary: 阿里云子链创建的前置检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetCreateResponse(),
            self.do_request('1.0', 'baas.chain.subnet.create.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_chain_subnet_create_ex_async(
        self,
        request: blockchain_models.CheckChainSubnetCreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetCreateResponse:
        """
        Description: 阿里云子链创建的前置检查
        Summary: 阿里云子链创建的前置检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetCreateResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.create.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_subnet(
        self,
        request: blockchain_models.CreateChainSubnetRequest,
    ) -> blockchain_models.CreateChainSubnetResponse:
        """
        Description: 阿里云子链创建
        Summary: 阿里云子链创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_subnet_ex(request, headers, runtime)

    async def create_chain_subnet_async(
        self,
        request: blockchain_models.CreateChainSubnetRequest,
    ) -> blockchain_models.CreateChainSubnetResponse:
        """
        Description: 阿里云子链创建
        Summary: 阿里云子链创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_subnet_ex_async(request, headers, runtime)

    def create_chain_subnet_ex(
        self,
        request: blockchain_models.CreateChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainSubnetResponse:
        """
        Description: 阿里云子链创建
        Summary: 阿里云子链创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainSubnetResponse(),
            self.do_request('1.0', 'baas.chain.subnet.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_subnet_ex_async(
        self,
        request: blockchain_models.CreateChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainSubnetResponse:
        """
        Description: 阿里云子链创建
        Summary: 阿里云子链创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainSubnetResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_chain_subnet(
        self,
        request: blockchain_models.ExecChainSubnetRequest,
    ) -> blockchain_models.ExecChainSubnetResponse:
        """
        Description: 阿里云子链的启动
        Summary: 阿里云子链的启动
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_chain_subnet_ex(request, headers, runtime)

    async def exec_chain_subnet_async(
        self,
        request: blockchain_models.ExecChainSubnetRequest,
    ) -> blockchain_models.ExecChainSubnetResponse:
        """
        Description: 阿里云子链的启动
        Summary: 阿里云子链的启动
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_chain_subnet_ex_async(request, headers, runtime)

    def exec_chain_subnet_ex(
        self,
        request: blockchain_models.ExecChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainSubnetResponse:
        """
        Description: 阿里云子链的启动
        Summary: 阿里云子链的启动
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainSubnetResponse(),
            self.do_request('1.0', 'baas.chain.subnet.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_chain_subnet_ex_async(
        self,
        request: blockchain_models.ExecChainSubnetRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecChainSubnetResponse:
        """
        Description: 阿里云子链的启动
        Summary: 阿里云子链的启动
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecChainSubnetResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_subnet_name(
        self,
        request: blockchain_models.UpdateChainSubnetNameRequest,
    ) -> blockchain_models.UpdateChainSubnetNameResponse:
        """
        Description: 阿里云子链名称修改
        Summary: 阿里云子链名称修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_subnet_name_ex(request, headers, runtime)

    async def update_chain_subnet_name_async(
        self,
        request: blockchain_models.UpdateChainSubnetNameRequest,
    ) -> blockchain_models.UpdateChainSubnetNameResponse:
        """
        Description: 阿里云子链名称修改
        Summary: 阿里云子链名称修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_subnet_name_ex_async(request, headers, runtime)

    def update_chain_subnet_name_ex(
        self,
        request: blockchain_models.UpdateChainSubnetNameRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainSubnetNameResponse:
        """
        Description: 阿里云子链名称修改
        Summary: 阿里云子链名称修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainSubnetNameResponse(),
            self.do_request('1.0', 'baas.chain.subnet.name.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_subnet_name_ex_async(
        self,
        request: blockchain_models.UpdateChainSubnetNameRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainSubnetNameResponse:
        """
        Description: 阿里云子链名称修改
        Summary: 阿里云子链名称修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainSubnetNameResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.name.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_subnet_node(
        self,
        request: blockchain_models.QueryChainSubnetNodeRequest,
    ) -> blockchain_models.QueryChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点信息查询
        Summary: 阿里云子链节点信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_subnet_node_ex(request, headers, runtime)

    async def query_chain_subnet_node_async(
        self,
        request: blockchain_models.QueryChainSubnetNodeRequest,
    ) -> blockchain_models.QueryChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点信息查询
        Summary: 阿里云子链节点信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_subnet_node_ex_async(request, headers, runtime)

    def query_chain_subnet_node_ex(
        self,
        request: blockchain_models.QueryChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点信息查询
        Summary: 阿里云子链节点信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetNodeResponse(),
            self.do_request('1.0', 'baas.chain.subnet.node.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_subnet_node_ex_async(
        self,
        request: blockchain_models.QueryChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点信息查询
        Summary: 阿里云子链节点信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetNodeResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.node.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_chain_subnet_node(
        self,
        request: blockchain_models.DeleteChainSubnetNodeRequest,
    ) -> blockchain_models.DeleteChainSubnetNodeResponse:
        """
        Description: 阿里云子链的节点删除
        Summary: 阿里云子链的节点删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_chain_subnet_node_ex(request, headers, runtime)

    async def delete_chain_subnet_node_async(
        self,
        request: blockchain_models.DeleteChainSubnetNodeRequest,
    ) -> blockchain_models.DeleteChainSubnetNodeResponse:
        """
        Description: 阿里云子链的节点删除
        Summary: 阿里云子链的节点删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_chain_subnet_node_ex_async(request, headers, runtime)

    def delete_chain_subnet_node_ex(
        self,
        request: blockchain_models.DeleteChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainSubnetNodeResponse:
        """
        Description: 阿里云子链的节点删除
        Summary: 阿里云子链的节点删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainSubnetNodeResponse(),
            self.do_request('1.0', 'baas.chain.subnet.node.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_chain_subnet_node_ex_async(
        self,
        request: blockchain_models.DeleteChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainSubnetNodeResponse:
        """
        Description: 阿里云子链的节点删除
        Summary: 阿里云子链的节点删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainSubnetNodeResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.node.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_chain_subnet_node(
        self,
        request: blockchain_models.CheckChainSubnetNodeRequest,
    ) -> blockchain_models.CheckChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加的前置检查
        Summary: 阿里云子链节点添加的前置检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_chain_subnet_node_ex(request, headers, runtime)

    async def check_chain_subnet_node_async(
        self,
        request: blockchain_models.CheckChainSubnetNodeRequest,
    ) -> blockchain_models.CheckChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加的前置检查
        Summary: 阿里云子链节点添加的前置检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_chain_subnet_node_ex_async(request, headers, runtime)

    def check_chain_subnet_node_ex(
        self,
        request: blockchain_models.CheckChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加的前置检查
        Summary: 阿里云子链节点添加的前置检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetNodeResponse(),
            self.do_request('1.0', 'baas.chain.subnet.node.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_chain_subnet_node_ex_async(
        self,
        request: blockchain_models.CheckChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加的前置检查
        Summary: 阿里云子链节点添加的前置检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetNodeResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.node.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def add_chain_subnet_node(
        self,
        request: blockchain_models.AddChainSubnetNodeRequest,
    ) -> blockchain_models.AddChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加
        Summary: 阿里云子链节点添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_chain_subnet_node_ex(request, headers, runtime)

    async def add_chain_subnet_node_async(
        self,
        request: blockchain_models.AddChainSubnetNodeRequest,
    ) -> blockchain_models.AddChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加
        Summary: 阿里云子链节点添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_chain_subnet_node_ex_async(request, headers, runtime)

    def add_chain_subnet_node_ex(
        self,
        request: blockchain_models.AddChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加
        Summary: 阿里云子链节点添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddChainSubnetNodeResponse(),
            self.do_request('1.0', 'baas.chain.subnet.node.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def add_chain_subnet_node_ex_async(
        self,
        request: blockchain_models.AddChainSubnetNodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddChainSubnetNodeResponse:
        """
        Description: 阿里云子链节点添加
        Summary: 阿里云子链节点添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddChainSubnetNodeResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.node.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_subnet_member(
        self,
        request: blockchain_models.QueryChainSubnetMemberRequest,
    ) -> blockchain_models.QueryChainSubnetMemberResponse:
        """
        Description: 阿里云子链机构列表查询
        Summary: 阿里云子链机构列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_subnet_member_ex(request, headers, runtime)

    async def query_chain_subnet_member_async(
        self,
        request: blockchain_models.QueryChainSubnetMemberRequest,
    ) -> blockchain_models.QueryChainSubnetMemberResponse:
        """
        Description: 阿里云子链机构列表查询
        Summary: 阿里云子链机构列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_subnet_member_ex_async(request, headers, runtime)

    def query_chain_subnet_member_ex(
        self,
        request: blockchain_models.QueryChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetMemberResponse:
        """
        Description: 阿里云子链机构列表查询
        Summary: 阿里云子链机构列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetMemberResponse(),
            self.do_request('1.0', 'baas.chain.subnet.member.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_subnet_member_ex_async(
        self,
        request: blockchain_models.QueryChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainSubnetMemberResponse:
        """
        Description: 阿里云子链机构列表查询
        Summary: 阿里云子链机构列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainSubnetMemberResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.member.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_chain_subnet_member(
        self,
        request: blockchain_models.DeleteChainSubnetMemberRequest,
    ) -> blockchain_models.DeleteChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员删除
        Summary: 阿里云子链成员删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_chain_subnet_member_ex(request, headers, runtime)

    async def delete_chain_subnet_member_async(
        self,
        request: blockchain_models.DeleteChainSubnetMemberRequest,
    ) -> blockchain_models.DeleteChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员删除
        Summary: 阿里云子链成员删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_chain_subnet_member_ex_async(request, headers, runtime)

    def delete_chain_subnet_member_ex(
        self,
        request: blockchain_models.DeleteChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员删除
        Summary: 阿里云子链成员删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainSubnetMemberResponse(),
            self.do_request('1.0', 'baas.chain.subnet.member.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_chain_subnet_member_ex_async(
        self,
        request: blockchain_models.DeleteChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员删除
        Summary: 阿里云子链成员删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteChainSubnetMemberResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.member.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_chain_subnet_member(
        self,
        request: blockchain_models.CheckChainSubnetMemberRequest,
    ) -> blockchain_models.CheckChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加前校验
        Summary: 阿里云子链成员添加前校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_chain_subnet_member_ex(request, headers, runtime)

    async def check_chain_subnet_member_async(
        self,
        request: blockchain_models.CheckChainSubnetMemberRequest,
    ) -> blockchain_models.CheckChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加前校验
        Summary: 阿里云子链成员添加前校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_chain_subnet_member_ex_async(request, headers, runtime)

    def check_chain_subnet_member_ex(
        self,
        request: blockchain_models.CheckChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加前校验
        Summary: 阿里云子链成员添加前校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetMemberResponse(),
            self.do_request('1.0', 'baas.chain.subnet.member.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_chain_subnet_member_ex_async(
        self,
        request: blockchain_models.CheckChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加前校验
        Summary: 阿里云子链成员添加前校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSubnetMemberResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.member.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def add_chain_subnet_member(
        self,
        request: blockchain_models.AddChainSubnetMemberRequest,
    ) -> blockchain_models.AddChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加
        Summary: 阿里云子链成员添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_chain_subnet_member_ex(request, headers, runtime)

    async def add_chain_subnet_member_async(
        self,
        request: blockchain_models.AddChainSubnetMemberRequest,
    ) -> blockchain_models.AddChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加
        Summary: 阿里云子链成员添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_chain_subnet_member_ex_async(request, headers, runtime)

    def add_chain_subnet_member_ex(
        self,
        request: blockchain_models.AddChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加
        Summary: 阿里云子链成员添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddChainSubnetMemberResponse(),
            self.do_request('1.0', 'baas.chain.subnet.member.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def add_chain_subnet_member_ex_async(
        self,
        request: blockchain_models.AddChainSubnetMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddChainSubnetMemberResponse:
        """
        Description: 阿里云子链成员添加
        Summary: 阿里云子链成员添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddChainSubnetMemberResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.member.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_subnet_rest(
        self,
        request: blockchain_models.ApplyChainSubnetRestRequest,
    ) -> blockchain_models.ApplyChainSubnetRestResponse:
        """
        Description: 阿里云子链REST开通
        Summary: 阿里云子链REST开通
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_subnet_rest_ex(request, headers, runtime)

    async def apply_chain_subnet_rest_async(
        self,
        request: blockchain_models.ApplyChainSubnetRestRequest,
    ) -> blockchain_models.ApplyChainSubnetRestResponse:
        """
        Description: 阿里云子链REST开通
        Summary: 阿里云子链REST开通
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_subnet_rest_ex_async(request, headers, runtime)

    def apply_chain_subnet_rest_ex(
        self,
        request: blockchain_models.ApplyChainSubnetRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainSubnetRestResponse:
        """
        Description: 阿里云子链REST开通
        Summary: 阿里云子链REST开通
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainSubnetRestResponse(),
            self.do_request('1.0', 'baas.chain.subnet.rest.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_subnet_rest_ex_async(
        self,
        request: blockchain_models.ApplyChainSubnetRestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainSubnetRestResponse:
        """
        Description: 阿里云子链REST开通
        Summary: 阿里云子链REST开通
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainSubnetRestResponse(),
            await self.do_request_async('1.0', 'baas.chain.subnet.rest.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_dataexport_task(
        self,
        request: blockchain_models.QueryChainDataexportTaskRequest,
    ) -> blockchain_models.QueryChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出任务查询
        Summary: 阿里云数据导出任务查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_dataexport_task_ex(request, headers, runtime)

    async def query_chain_dataexport_task_async(
        self,
        request: blockchain_models.QueryChainDataexportTaskRequest,
    ) -> blockchain_models.QueryChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出任务查询
        Summary: 阿里云数据导出任务查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_dataexport_task_ex_async(request, headers, runtime)

    def query_chain_dataexport_task_ex(
        self,
        request: blockchain_models.QueryChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出任务查询
        Summary: 阿里云数据导出任务查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataexportTaskResponse(),
            self.do_request('1.0', 'baas.chain.dataexport.task.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_dataexport_task_ex_async(
        self,
        request: blockchain_models.QueryChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出任务查询
        Summary: 阿里云数据导出任务查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataexportTaskResponse(),
            await self.do_request_async('1.0', 'baas.chain.dataexport.task.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_data_export(
        self,
        request: blockchain_models.QueryChainDataExportRequest,
    ) -> blockchain_models.QueryChainDataExportResponse:
        """
        Description: 阿里云数据导出服务，列出所有导出任务功能接口
        Summary: 列出所有导出任务接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_data_export_ex(request, headers, runtime)

    async def query_chain_data_export_async(
        self,
        request: blockchain_models.QueryChainDataExportRequest,
    ) -> blockchain_models.QueryChainDataExportResponse:
        """
        Description: 阿里云数据导出服务，列出所有导出任务功能接口
        Summary: 列出所有导出任务接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_data_export_ex_async(request, headers, runtime)

    def query_chain_data_export_ex(
        self,
        request: blockchain_models.QueryChainDataExportRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataExportResponse:
        """
        Description: 阿里云数据导出服务，列出所有导出任务功能接口
        Summary: 列出所有导出任务接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataExportResponse(),
            self.do_request('1.0', 'baas.chain.data.export.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_data_export_ex_async(
        self,
        request: blockchain_models.QueryChainDataExportRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataExportResponse:
        """
        Description: 阿里云数据导出服务，列出所有导出任务功能接口
        Summary: 列出所有导出任务接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataExportResponse(),
            await self.do_request_async('1.0', 'baas.chain.data.export.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_dataexport_task(
        self,
        request: blockchain_models.CreateChainDataexportTaskRequest,
    ) -> blockchain_models.CreateChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出需求创建数据导出任务
        Summary: 创建数据导出任务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_dataexport_task_ex(request, headers, runtime)

    async def create_chain_dataexport_task_async(
        self,
        request: blockchain_models.CreateChainDataexportTaskRequest,
    ) -> blockchain_models.CreateChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出需求创建数据导出任务
        Summary: 创建数据导出任务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_dataexport_task_ex_async(request, headers, runtime)

    def create_chain_dataexport_task_ex(
        self,
        request: blockchain_models.CreateChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出需求创建数据导出任务
        Summary: 创建数据导出任务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainDataexportTaskResponse(),
            self.do_request('1.0', 'baas.chain.dataexport.task.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_dataexport_task_ex_async(
        self,
        request: blockchain_models.CreateChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainDataexportTaskResponse:
        """
        Description: 阿里云数据导出需求创建数据导出任务
        Summary: 创建数据导出任务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainDataexportTaskResponse(),
            await self.do_request_async('1.0', 'baas.chain.dataexport.task.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_task_id(
        self,
        request: blockchain_models.CreateChainTaskIdRequest,
    ) -> blockchain_models.CreateChainTaskIdResponse:
        """
        Description: 获取预览数据（第一步：生成任务ID）
        Summary: 获取预览数据（第一步：生成任务ID）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_task_id_ex(request, headers, runtime)

    async def create_chain_task_id_async(
        self,
        request: blockchain_models.CreateChainTaskIdRequest,
    ) -> blockchain_models.CreateChainTaskIdResponse:
        """
        Description: 获取预览数据（第一步：生成任务ID）
        Summary: 获取预览数据（第一步：生成任务ID）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_task_id_ex_async(request, headers, runtime)

    def create_chain_task_id_ex(
        self,
        request: blockchain_models.CreateChainTaskIdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainTaskIdResponse:
        """
        Description: 获取预览数据（第一步：生成任务ID）
        Summary: 获取预览数据（第一步：生成任务ID）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainTaskIdResponse(),
            self.do_request('1.0', 'baas.chain.task.id.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_task_id_ex_async(
        self,
        request: blockchain_models.CreateChainTaskIdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainTaskIdResponse:
        """
        Description: 获取预览数据（第一步：生成任务ID）
        Summary: 获取预览数据（第一步：生成任务ID）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainTaskIdResponse(),
            await self.do_request_async('1.0', 'baas.chain.task.id.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_data_preview(
        self,
        request: blockchain_models.QueryChainDataPreviewRequest,
    ) -> blockchain_models.QueryChainDataPreviewResponse:
        """
        Description: 获取预览数据（第二步：根据任务ID获取预览数据结果）
        Summary: 根据任务ID获取预览数据结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_data_preview_ex(request, headers, runtime)

    async def query_chain_data_preview_async(
        self,
        request: blockchain_models.QueryChainDataPreviewRequest,
    ) -> blockchain_models.QueryChainDataPreviewResponse:
        """
        Description: 获取预览数据（第二步：根据任务ID获取预览数据结果）
        Summary: 根据任务ID获取预览数据结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_data_preview_ex_async(request, headers, runtime)

    def query_chain_data_preview_ex(
        self,
        request: blockchain_models.QueryChainDataPreviewRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataPreviewResponse:
        """
        Description: 获取预览数据（第二步：根据任务ID获取预览数据结果）
        Summary: 根据任务ID获取预览数据结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataPreviewResponse(),
            self.do_request('1.0', 'baas.chain.data.preview.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_data_preview_ex_async(
        self,
        request: blockchain_models.QueryChainDataPreviewRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainDataPreviewResponse:
        """
        Description: 获取预览数据（第二步：根据任务ID获取预览数据结果）
        Summary: 根据任务ID获取预览数据结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainDataPreviewResponse(),
            await self.do_request_async('1.0', 'baas.chain.data.preview.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_mapping_relationship(
        self,
        request: blockchain_models.QueryChainMappingRelationshipRequest,
    ) -> blockchain_models.QueryChainMappingRelationshipResponse:
        """
        Description: 根据预览数据获取默认映射关系
        Summary: 根据预览数据获取默认映射关系
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_mapping_relationship_ex(request, headers, runtime)

    async def query_chain_mapping_relationship_async(
        self,
        request: blockchain_models.QueryChainMappingRelationshipRequest,
    ) -> blockchain_models.QueryChainMappingRelationshipResponse:
        """
        Description: 根据预览数据获取默认映射关系
        Summary: 根据预览数据获取默认映射关系
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_mapping_relationship_ex_async(request, headers, runtime)

    def query_chain_mapping_relationship_ex(
        self,
        request: blockchain_models.QueryChainMappingRelationshipRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMappingRelationshipResponse:
        """
        Description: 根据预览数据获取默认映射关系
        Summary: 根据预览数据获取默认映射关系
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMappingRelationshipResponse(),
            self.do_request('1.0', 'baas.chain.mapping.relationship.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_mapping_relationship_ex_async(
        self,
        request: blockchain_models.QueryChainMappingRelationshipRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainMappingRelationshipResponse:
        """
        Description: 根据预览数据获取默认映射关系
        Summary: 根据预览数据获取默认映射关系
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainMappingRelationshipResponse(),
            await self.do_request_async('1.0', 'baas.chain.mapping.relationship.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_table_sql(
        self,
        request: blockchain_models.CreateChainTableSqlRequest,
    ) -> blockchain_models.CreateChainTableSqlResponse:
        """
        Description: 创建导出MySQL任务失败，获取 Create Table 语句
        Summary: 获取 Create Table 语句
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_table_sql_ex(request, headers, runtime)

    async def create_chain_table_sql_async(
        self,
        request: blockchain_models.CreateChainTableSqlRequest,
    ) -> blockchain_models.CreateChainTableSqlResponse:
        """
        Description: 创建导出MySQL任务失败，获取 Create Table 语句
        Summary: 获取 Create Table 语句
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_table_sql_ex_async(request, headers, runtime)

    def create_chain_table_sql_ex(
        self,
        request: blockchain_models.CreateChainTableSqlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainTableSqlResponse:
        """
        Description: 创建导出MySQL任务失败，获取 Create Table 语句
        Summary: 获取 Create Table 语句
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainTableSqlResponse(),
            self.do_request('1.0', 'baas.chain.table.sql.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_table_sql_ex_async(
        self,
        request: blockchain_models.CreateChainTableSqlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainTableSqlResponse:
        """
        Description: 创建导出MySQL任务失败，获取 Create Table 语句
        Summary: 获取 Create Table 语句
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainTableSqlResponse(),
            await self.do_request_async('1.0', 'baas.chain.table.sql.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_dataexport_status(
        self,
        request: blockchain_models.UpdateChainDataexportStatusRequest,
    ) -> blockchain_models.UpdateChainDataexportStatusResponse:
        """
        Description: 修改导出任务状态（启动、暂停、删除）
        Summary: 修改导出任务状态（启动、暂停、删除）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_dataexport_status_ex(request, headers, runtime)

    async def update_chain_dataexport_status_async(
        self,
        request: blockchain_models.UpdateChainDataexportStatusRequest,
    ) -> blockchain_models.UpdateChainDataexportStatusResponse:
        """
        Description: 修改导出任务状态（启动、暂停、删除）
        Summary: 修改导出任务状态（启动、暂停、删除）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_dataexport_status_ex_async(request, headers, runtime)

    def update_chain_dataexport_status_ex(
        self,
        request: blockchain_models.UpdateChainDataexportStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainDataexportStatusResponse:
        """
        Description: 修改导出任务状态（启动、暂停、删除）
        Summary: 修改导出任务状态（启动、暂停、删除）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainDataexportStatusResponse(),
            self.do_request('1.0', 'baas.chain.dataexport.status.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_dataexport_status_ex_async(
        self,
        request: blockchain_models.UpdateChainDataexportStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainDataexportStatusResponse:
        """
        Description: 修改导出任务状态（启动、暂停、删除）
        Summary: 修改导出任务状态（启动、暂停、删除）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainDataexportStatusResponse(),
            await self.do_request_async('1.0', 'baas.chain.dataexport.status.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_dataexport_task(
        self,
        request: blockchain_models.UpdateChainDataexportTaskRequest,
    ) -> blockchain_models.UpdateChainDataexportTaskResponse:
        """
        Description: 修改导出任务（名称、描述、告警地址）
        Summary: 修改导出任务（名称、描述、告警地址）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_dataexport_task_ex(request, headers, runtime)

    async def update_chain_dataexport_task_async(
        self,
        request: blockchain_models.UpdateChainDataexportTaskRequest,
    ) -> blockchain_models.UpdateChainDataexportTaskResponse:
        """
        Description: 修改导出任务（名称、描述、告警地址）
        Summary: 修改导出任务（名称、描述、告警地址）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_dataexport_task_ex_async(request, headers, runtime)

    def update_chain_dataexport_task_ex(
        self,
        request: blockchain_models.UpdateChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainDataexportTaskResponse:
        """
        Description: 修改导出任务（名称、描述、告警地址）
        Summary: 修改导出任务（名称、描述、告警地址）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainDataexportTaskResponse(),
            self.do_request('1.0', 'baas.chain.dataexport.task.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_dataexport_task_ex_async(
        self,
        request: blockchain_models.UpdateChainDataexportTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainDataexportTaskResponse:
        """
        Description: 修改导出任务（名称、描述、告警地址）
        Summary: 修改导出任务（名称、描述、告警地址）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainDataexportTaskResponse(),
            await self.do_request_async('1.0', 'baas.chain.dataexport.task.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_failure_log(
        self,
        request: blockchain_models.QueryChainFailureLogRequest,
    ) -> blockchain_models.QueryChainFailureLogResponse:
        """
        Description: 分页失败的展示日志（过滤器：待处理、成功、已忽略）
        Summary: 分页失败的展示日志
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_failure_log_ex(request, headers, runtime)

    async def query_chain_failure_log_async(
        self,
        request: blockchain_models.QueryChainFailureLogRequest,
    ) -> blockchain_models.QueryChainFailureLogResponse:
        """
        Description: 分页失败的展示日志（过滤器：待处理、成功、已忽略）
        Summary: 分页失败的展示日志
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_failure_log_ex_async(request, headers, runtime)

    def query_chain_failure_log_ex(
        self,
        request: blockchain_models.QueryChainFailureLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainFailureLogResponse:
        """
        Description: 分页失败的展示日志（过滤器：待处理、成功、已忽略）
        Summary: 分页失败的展示日志
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainFailureLogResponse(),
            self.do_request('1.0', 'baas.chain.failure.log.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_failure_log_ex_async(
        self,
        request: blockchain_models.QueryChainFailureLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainFailureLogResponse:
        """
        Description: 分页失败的展示日志（过滤器：待处理、成功、已忽略）
        Summary: 分页失败的展示日志
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainFailureLogResponse(),
            await self.do_request_async('1.0', 'baas.chain.failure.log.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_chain_failure_log(
        self,
        request: blockchain_models.UpdateChainFailureLogRequest,
    ) -> blockchain_models.UpdateChainFailureLogResponse:
        """
        Description: 批量处理失败日志（重试/忽略）
        Summary: 批量处理失败日志（重试/忽略）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_chain_failure_log_ex(request, headers, runtime)

    async def update_chain_failure_log_async(
        self,
        request: blockchain_models.UpdateChainFailureLogRequest,
    ) -> blockchain_models.UpdateChainFailureLogResponse:
        """
        Description: 批量处理失败日志（重试/忽略）
        Summary: 批量处理失败日志（重试/忽略）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_chain_failure_log_ex_async(request, headers, runtime)

    def update_chain_failure_log_ex(
        self,
        request: blockchain_models.UpdateChainFailureLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainFailureLogResponse:
        """
        Description: 批量处理失败日志（重试/忽略）
        Summary: 批量处理失败日志（重试/忽略）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainFailureLogResponse(),
            self.do_request('1.0', 'baas.chain.failure.log.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_chain_failure_log_ex_async(
        self,
        request: blockchain_models.UpdateChainFailureLogRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateChainFailureLogResponse:
        """
        Description: 批量处理失败日志（重试/忽略）
        Summary: 批量处理失败日志（重试/忽略）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateChainFailureLogResponse(),
            await self.do_request_async('1.0', 'baas.chain.failure.log.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_managed_mq(
        self,
        request: blockchain_models.QueryChainManagedMqRequest,
    ) -> blockchain_models.QueryChainManagedMqResponse:
        """
        Description: 列出当前用户的托管MQ实例
        Summary: 列出当前用户的托管MQ实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_managed_mq_ex(request, headers, runtime)

    async def query_chain_managed_mq_async(
        self,
        request: blockchain_models.QueryChainManagedMqRequest,
    ) -> blockchain_models.QueryChainManagedMqResponse:
        """
        Description: 列出当前用户的托管MQ实例
        Summary: 列出当前用户的托管MQ实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_managed_mq_ex_async(request, headers, runtime)

    def query_chain_managed_mq_ex(
        self,
        request: blockchain_models.QueryChainManagedMqRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainManagedMqResponse:
        """
        Description: 列出当前用户的托管MQ实例
        Summary: 列出当前用户的托管MQ实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainManagedMqResponse(),
            self.do_request('1.0', 'baas.chain.managed.mq.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_managed_mq_ex_async(
        self,
        request: blockchain_models.QueryChainManagedMqRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainManagedMqResponse:
        """
        Description: 列出当前用户的托管MQ实例
        Summary: 列出当前用户的托管MQ实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainManagedMqResponse(),
            await self.do_request_async('1.0', 'baas.chain.managed.mq.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def init_chain_managed_mq(
        self,
        request: blockchain_models.InitChainManagedMqRequest,
    ) -> blockchain_models.InitChainManagedMqResponse:
        """
        Description: 初始化托管 MQ 实例
        Summary: 初始化托管 MQ 实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.init_chain_managed_mq_ex(request, headers, runtime)

    async def init_chain_managed_mq_async(
        self,
        request: blockchain_models.InitChainManagedMqRequest,
    ) -> blockchain_models.InitChainManagedMqResponse:
        """
        Description: 初始化托管 MQ 实例
        Summary: 初始化托管 MQ 实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.init_chain_managed_mq_ex_async(request, headers, runtime)

    def init_chain_managed_mq_ex(
        self,
        request: blockchain_models.InitChainManagedMqRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitChainManagedMqResponse:
        """
        Description: 初始化托管 MQ 实例
        Summary: 初始化托管 MQ 实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitChainManagedMqResponse(),
            self.do_request('1.0', 'baas.chain.managed.mq.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def init_chain_managed_mq_ex_async(
        self,
        request: blockchain_models.InitChainManagedMqRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitChainManagedMqResponse:
        """
        Description: 初始化托管 MQ 实例
        Summary: 初始化托管 MQ 实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitChainManagedMqResponse(),
            await self.do_request_async('1.0', 'baas.chain.managed.mq.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_use_declaration(
        self,
        request: blockchain_models.QueryChainUseDeclarationRequest,
    ) -> blockchain_models.QueryChainUseDeclarationResponse:
        """
        Description: 查询蚂蚁链用途列表接口
        Summary: 查询蚂蚁链用途列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_use_declaration_ex(request, headers, runtime)

    async def query_chain_use_declaration_async(
        self,
        request: blockchain_models.QueryChainUseDeclarationRequest,
    ) -> blockchain_models.QueryChainUseDeclarationResponse:
        """
        Description: 查询蚂蚁链用途列表接口
        Summary: 查询蚂蚁链用途列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_use_declaration_ex_async(request, headers, runtime)

    def query_chain_use_declaration_ex(
        self,
        request: blockchain_models.QueryChainUseDeclarationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainUseDeclarationResponse:
        """
        Description: 查询蚂蚁链用途列表接口
        Summary: 查询蚂蚁链用途列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainUseDeclarationResponse(),
            self.do_request('1.0', 'baas.chain.use.declaration.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_use_declaration_ex_async(
        self,
        request: blockchain_models.QueryChainUseDeclarationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainUseDeclarationResponse:
        """
        Description: 查询蚂蚁链用途列表接口
        Summary: 查询蚂蚁链用途列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainUseDeclarationResponse(),
            await self.do_request_async('1.0', 'baas.chain.use.declaration.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_chain_use_declaration(
        self,
        request: blockchain_models.ApplyChainUseDeclarationRequest,
    ) -> blockchain_models.ApplyChainUseDeclarationResponse:
        """
        Description: 选择蚂蚁链用途列表中的某项，进行提交申报接口
        Summary: 选择蚂蚁链用途列表中的某项，进行提交申报
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_chain_use_declaration_ex(request, headers, runtime)

    async def apply_chain_use_declaration_async(
        self,
        request: blockchain_models.ApplyChainUseDeclarationRequest,
    ) -> blockchain_models.ApplyChainUseDeclarationResponse:
        """
        Description: 选择蚂蚁链用途列表中的某项，进行提交申报接口
        Summary: 选择蚂蚁链用途列表中的某项，进行提交申报
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_chain_use_declaration_ex_async(request, headers, runtime)

    def apply_chain_use_declaration_ex(
        self,
        request: blockchain_models.ApplyChainUseDeclarationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainUseDeclarationResponse:
        """
        Description: 选择蚂蚁链用途列表中的某项，进行提交申报接口
        Summary: 选择蚂蚁链用途列表中的某项，进行提交申报
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainUseDeclarationResponse(),
            self.do_request('1.0', 'baas.chain.use.declaration.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_chain_use_declaration_ex_async(
        self,
        request: blockchain_models.ApplyChainUseDeclarationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyChainUseDeclarationResponse:
        """
        Description: 选择蚂蚁链用途列表中的某项，进行提交申报接口
        Summary: 选择蚂蚁链用途列表中的某项，进行提交申报
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyChainUseDeclarationResponse(),
            await self.do_request_async('1.0', 'baas.chain.use.declaration.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_chain_use_list(
        self,
        request: blockchain_models.QueryChainUseListRequest,
    ) -> blockchain_models.QueryChainUseListResponse:
        """
        Description: 展示用户添加申报的记录接口
        Summary: 展示用户添加申报的记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_chain_use_list_ex(request, headers, runtime)

    async def query_chain_use_list_async(
        self,
        request: blockchain_models.QueryChainUseListRequest,
    ) -> blockchain_models.QueryChainUseListResponse:
        """
        Description: 展示用户添加申报的记录接口
        Summary: 展示用户添加申报的记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_chain_use_list_ex_async(request, headers, runtime)

    def query_chain_use_list_ex(
        self,
        request: blockchain_models.QueryChainUseListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainUseListResponse:
        """
        Description: 展示用户添加申报的记录接口
        Summary: 展示用户添加申报的记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainUseListResponse(),
            self.do_request('1.0', 'baas.chain.use.list.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_chain_use_list_ex_async(
        self,
        request: blockchain_models.QueryChainUseListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryChainUseListResponse:
        """
        Description: 展示用户添加申报的记录接口
        Summary: 展示用户添加申报的记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryChainUseListResponse(),
            await self.do_request_async('1.0', 'baas.chain.use.list.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_chain_sensitive_words(
        self,
        request: blockchain_models.CheckChainSensitiveWordsRequest,
    ) -> blockchain_models.CheckChainSensitiveWordsResponse:
        """
        Description: BaaS用途申报敏感词检查接口
        Summary: BaaS用途申报敏感词检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_chain_sensitive_words_ex(request, headers, runtime)

    async def check_chain_sensitive_words_async(
        self,
        request: blockchain_models.CheckChainSensitiveWordsRequest,
    ) -> blockchain_models.CheckChainSensitiveWordsResponse:
        """
        Description: BaaS用途申报敏感词检查接口
        Summary: BaaS用途申报敏感词检查
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_chain_sensitive_words_ex_async(request, headers, runtime)

    def check_chain_sensitive_words_ex(
        self,
        request: blockchain_models.CheckChainSensitiveWordsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSensitiveWordsResponse:
        """
        Description: BaaS用途申报敏感词检查接口
        Summary: BaaS用途申报敏感词检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSensitiveWordsResponse(),
            self.do_request('1.0', 'baas.chain.sensitive.words.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_chain_sensitive_words_ex_async(
        self,
        request: blockchain_models.CheckChainSensitiveWordsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainSensitiveWordsResponse:
        """
        Description: BaaS用途申报敏感词检查接口
        Summary: BaaS用途申报敏感词检查
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainSensitiveWordsResponse(),
            await self.do_request_async('1.0', 'baas.chain.sensitive.words.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_chain_account_antkms(
        self,
        request: blockchain_models.CreateChainAccountAntkmsRequest,
    ) -> blockchain_models.CreateChainAccountAntkmsResponse:
        """
        Description: 阿里云MyChain创建托管账户
        Summary: 阿里云MyChain创建托管账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_chain_account_antkms_ex(request, headers, runtime)

    async def create_chain_account_antkms_async(
        self,
        request: blockchain_models.CreateChainAccountAntkmsRequest,
    ) -> blockchain_models.CreateChainAccountAntkmsResponse:
        """
        Description: 阿里云MyChain创建托管账户
        Summary: 阿里云MyChain创建托管账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_chain_account_antkms_ex_async(request, headers, runtime)

    def create_chain_account_antkms_ex(
        self,
        request: blockchain_models.CreateChainAccountAntkmsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainAccountAntkmsResponse:
        """
        Description: 阿里云MyChain创建托管账户
        Summary: 阿里云MyChain创建托管账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainAccountAntkmsResponse(),
            self.do_request('1.0', 'baas.chain.account.antkms.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_chain_account_antkms_ex_async(
        self,
        request: blockchain_models.CreateChainAccountAntkmsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateChainAccountAntkmsResponse:
        """
        Description: 阿里云MyChain创建托管账户
        Summary: 阿里云MyChain创建托管账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateChainAccountAntkmsResponse(),
            await self.do_request_async('1.0', 'baas.chain.account.antkms.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def open_chain_service(
        self,
        request: blockchain_models.OpenChainServiceRequest,
    ) -> blockchain_models.OpenChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现计量计费
        Summary: 阿里云渠道链相关商业化服务开通
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.open_chain_service_ex(request, headers, runtime)

    async def open_chain_service_async(
        self,
        request: blockchain_models.OpenChainServiceRequest,
    ) -> blockchain_models.OpenChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现计量计费
        Summary: 阿里云渠道链相关商业化服务开通
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.open_chain_service_ex_async(request, headers, runtime)

    def open_chain_service_ex(
        self,
        request: blockchain_models.OpenChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现计量计费
        Summary: 阿里云渠道链相关商业化服务开通
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenChainServiceResponse(),
            self.do_request('1.0', 'baas.chain.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def open_chain_service_ex_async(
        self,
        request: blockchain_models.OpenChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现计量计费
        Summary: 阿里云渠道链相关商业化服务开通
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenChainServiceResponse(),
            await self.do_request_async('1.0', 'baas.chain.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_chain_service(
        self,
        request: blockchain_models.CheckChainServiceRequest,
    ) -> blockchain_models.CheckChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通结果查询
        Summary: 阿里云渠道链相关商业化服务开通结果查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_chain_service_ex(request, headers, runtime)

    async def check_chain_service_async(
        self,
        request: blockchain_models.CheckChainServiceRequest,
    ) -> blockchain_models.CheckChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通结果查询
        Summary: 阿里云渠道链相关商业化服务开通结果查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_chain_service_ex_async(request, headers, runtime)

    def check_chain_service_ex(
        self,
        request: blockchain_models.CheckChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通结果查询
        Summary: 阿里云渠道链相关商业化服务开通结果查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainServiceResponse(),
            self.do_request('1.0', 'baas.chain.service.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_chain_service_ex_async(
        self,
        request: blockchain_models.CheckChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通结果查询
        Summary: 阿里云渠道链相关商业化服务开通结果查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckChainServiceResponse(),
            await self.do_request_async('1.0', 'baas.chain.service.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def close_chain_service(
        self,
        request: blockchain_models.CloseChainServiceRequest,
    ) -> blockchain_models.CloseChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现服务关闭
        Summary: 阿里云渠道链相关商业化服务关闭
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.close_chain_service_ex(request, headers, runtime)

    async def close_chain_service_async(
        self,
        request: blockchain_models.CloseChainServiceRequest,
    ) -> blockchain_models.CloseChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现服务关闭
        Summary: 阿里云渠道链相关商业化服务关闭
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.close_chain_service_ex_async(request, headers, runtime)

    def close_chain_service_ex(
        self,
        request: blockchain_models.CloseChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现服务关闭
        Summary: 阿里云渠道链相关商业化服务关闭
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseChainServiceResponse(),
            self.do_request('1.0', 'baas.chain.service.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def close_chain_service_ex_async(
        self,
        request: blockchain_models.CloseChainServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseChainServiceResponse:
        """
        Description: 阿里云渠道链相关商业化服务开通，后台经由ocp转发，实现服务关闭
        Summary: 阿里云渠道链相关商业化服务关闭
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseChainServiceResponse(),
            await self.do_request_async('1.0', 'baas.chain.service.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_aml_corporation_joinprepare(
        self,
        request: blockchain_models.StartAmlCorporationJoinprepareRequest,
    ) -> blockchain_models.StartAmlCorporationJoinprepareResponse:
        """
        Description: 企业通过调用该接口准备接入反洗钱信息共享平台
        Summary: 反洗钱信息共享平台入驻接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_aml_corporation_joinprepare_ex(request, headers, runtime)

    async def start_aml_corporation_joinprepare_async(
        self,
        request: blockchain_models.StartAmlCorporationJoinprepareRequest,
    ) -> blockchain_models.StartAmlCorporationJoinprepareResponse:
        """
        Description: 企业通过调用该接口准备接入反洗钱信息共享平台
        Summary: 反洗钱信息共享平台入驻接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_aml_corporation_joinprepare_ex_async(request, headers, runtime)

    def start_aml_corporation_joinprepare_ex(
        self,
        request: blockchain_models.StartAmlCorporationJoinprepareRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlCorporationJoinprepareResponse:
        """
        Description: 企业通过调用该接口准备接入反洗钱信息共享平台
        Summary: 反洗钱信息共享平台入驻接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlCorporationJoinprepareResponse(),
            self.do_request('1.0', 'baas.aml.corporation.joinprepare.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_aml_corporation_joinprepare_ex_async(
        self,
        request: blockchain_models.StartAmlCorporationJoinprepareRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlCorporationJoinprepareResponse:
        """
        Description: 企业通过调用该接口准备接入反洗钱信息共享平台
        Summary: 反洗钱信息共享平台入驻接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlCorporationJoinprepareResponse(),
            await self.do_request_async('1.0', 'baas.aml.corporation.joinprepare.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_aml_corporation_joincommit(
        self,
        request: blockchain_models.StartAmlCorporationJoincommitRequest,
    ) -> blockchain_models.StartAmlCorporationJoincommitResponse:
        """
        Description: 反洗钱信息共享平台确认加盟接口，用户在准备阶段确认了平台安全性之后可以确认入驻
        Summary: 反洗钱信息共享平台确认加盟接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_aml_corporation_joincommit_ex(request, headers, runtime)

    async def start_aml_corporation_joincommit_async(
        self,
        request: blockchain_models.StartAmlCorporationJoincommitRequest,
    ) -> blockchain_models.StartAmlCorporationJoincommitResponse:
        """
        Description: 反洗钱信息共享平台确认加盟接口，用户在准备阶段确认了平台安全性之后可以确认入驻
        Summary: 反洗钱信息共享平台确认加盟接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_aml_corporation_joincommit_ex_async(request, headers, runtime)

    def start_aml_corporation_joincommit_ex(
        self,
        request: blockchain_models.StartAmlCorporationJoincommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlCorporationJoincommitResponse:
        """
        Description: 反洗钱信息共享平台确认加盟接口，用户在准备阶段确认了平台安全性之后可以确认入驻
        Summary: 反洗钱信息共享平台确认加盟接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlCorporationJoincommitResponse(),
            self.do_request('1.0', 'baas.aml.corporation.joincommit.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_aml_corporation_joincommit_ex_async(
        self,
        request: blockchain_models.StartAmlCorporationJoincommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlCorporationJoincommitResponse:
        """
        Description: 反洗钱信息共享平台确认加盟接口，用户在准备阶段确认了平台安全性之后可以确认入驻
        Summary: 反洗钱信息共享平台确认加盟接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlCorporationJoincommitResponse(),
            await self.do_request_async('1.0', 'baas.aml.corporation.joincommit.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_aml_person_twofactor(
        self,
        request: blockchain_models.StartAmlPersonTwofactorRequest,
    ) -> blockchain_models.StartAmlPersonTwofactorResponse:
        """
        Description: 反洗钱系统二要素实名认证
        Summary: 反洗钱系统二要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_aml_person_twofactor_ex(request, headers, runtime)

    async def start_aml_person_twofactor_async(
        self,
        request: blockchain_models.StartAmlPersonTwofactorRequest,
    ) -> blockchain_models.StartAmlPersonTwofactorResponse:
        """
        Description: 反洗钱系统二要素实名认证
        Summary: 反洗钱系统二要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_aml_person_twofactor_ex_async(request, headers, runtime)

    def start_aml_person_twofactor_ex(
        self,
        request: blockchain_models.StartAmlPersonTwofactorRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlPersonTwofactorResponse:
        """
        Description: 反洗钱系统二要素实名认证
        Summary: 反洗钱系统二要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlPersonTwofactorResponse(),
            self.do_request('1.0', 'baas.aml.person.twofactor.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_aml_person_twofactor_ex_async(
        self,
        request: blockchain_models.StartAmlPersonTwofactorRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAmlPersonTwofactorResponse:
        """
        Description: 反洗钱系统二要素实名认证
        Summary: 反洗钱系统二要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAmlPersonTwofactorResponse(),
            await self.do_request_async('1.0', 'baas.aml.person.twofactor.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_business_deposit(
        self,
        request: blockchain_models.SaveBusinessDepositRequest,
    ) -> blockchain_models.SaveBusinessDepositResponse:
        """
        Description: 简单存证
        Summary: 简单存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_business_deposit_ex(request, headers, runtime)

    async def save_business_deposit_async(
        self,
        request: blockchain_models.SaveBusinessDepositRequest,
    ) -> blockchain_models.SaveBusinessDepositResponse:
        """
        Description: 简单存证
        Summary: 简单存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_business_deposit_ex_async(request, headers, runtime)

    def save_business_deposit_ex(
        self,
        request: blockchain_models.SaveBusinessDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositResponse:
        """
        Description: 简单存证
        Summary: 简单存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositResponse(),
            self.do_request('1.0', 'baas.business.deposit.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_business_deposit_ex_async(
        self,
        request: blockchain_models.SaveBusinessDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositResponse:
        """
        Description: 简单存证
        Summary: 简单存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_business_deposit_metadata(
        self,
        request: blockchain_models.SaveBusinessDepositMetadataRequest,
    ) -> blockchain_models.SaveBusinessDepositMetadataResponse:
        """
        Description: 存储带有描述性的数据
        Summary: 存储带有描述性的数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_business_deposit_metadata_ex(request, headers, runtime)

    async def save_business_deposit_metadata_async(
        self,
        request: blockchain_models.SaveBusinessDepositMetadataRequest,
    ) -> blockchain_models.SaveBusinessDepositMetadataResponse:
        """
        Description: 存储带有描述性的数据
        Summary: 存储带有描述性的数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_business_deposit_metadata_ex_async(request, headers, runtime)

    def save_business_deposit_metadata_ex(
        self,
        request: blockchain_models.SaveBusinessDepositMetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositMetadataResponse:
        """
        Description: 存储带有描述性的数据
        Summary: 存储带有描述性的数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositMetadataResponse(),
            self.do_request('1.0', 'baas.business.deposit.metadata.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_business_deposit_metadata_ex_async(
        self,
        request: blockchain_models.SaveBusinessDepositMetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositMetadataResponse:
        """
        Description: 存储带有描述性的数据
        Summary: 存储带有描述性的数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositMetadataResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.metadata.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_business_deposit_encrypt(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptRequest,
    ) -> blockchain_models.SaveBusinessDepositEncryptResponse:
        """
        Description: 将存证的数据在链上加密
        Summary: 将存证的数据在链上加密
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_business_deposit_encrypt_ex(request, headers, runtime)

    async def save_business_deposit_encrypt_async(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptRequest,
    ) -> blockchain_models.SaveBusinessDepositEncryptResponse:
        """
        Description: 将存证的数据在链上加密
        Summary: 将存证的数据在链上加密
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_business_deposit_encrypt_ex_async(request, headers, runtime)

    def save_business_deposit_encrypt_ex(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositEncryptResponse:
        """
        Description: 将存证的数据在链上加密
        Summary: 将存证的数据在链上加密
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositEncryptResponse(),
            self.do_request('1.0', 'baas.business.deposit.encrypt.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_business_deposit_encrypt_ex_async(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositEncryptResponse:
        """
        Description: 将存证的数据在链上加密
        Summary: 将存证的数据在链上加密
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositEncryptResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.encrypt.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_business_deposit_encryptmetadata(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptmetadataRequest,
    ) -> blockchain_models.SaveBusinessDepositEncryptmetadataResponse:
        """
        Description: 存证带有描述性的数据并加密
        Summary: 存证带有描述性的数据并加密
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_business_deposit_encryptmetadata_ex(request, headers, runtime)

    async def save_business_deposit_encryptmetadata_async(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptmetadataRequest,
    ) -> blockchain_models.SaveBusinessDepositEncryptmetadataResponse:
        """
        Description: 存证带有描述性的数据并加密
        Summary: 存证带有描述性的数据并加密
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_business_deposit_encryptmetadata_ex_async(request, headers, runtime)

    def save_business_deposit_encryptmetadata_ex(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptmetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositEncryptmetadataResponse:
        """
        Description: 存证带有描述性的数据并加密
        Summary: 存证带有描述性的数据并加密
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositEncryptmetadataResponse(),
            self.do_request('1.0', 'baas.business.deposit.encryptmetadata.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_business_deposit_encryptmetadata_ex_async(
        self,
        request: blockchain_models.SaveBusinessDepositEncryptmetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBusinessDepositEncryptmetadataResponse:
        """
        Description: 存证带有描述性的数据并加密
        Summary: 存证带有描述性的数据并加密
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBusinessDepositEncryptmetadataResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.encryptmetadata.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_did(
        self,
        request: blockchain_models.CreateBusinessDidRequest,
    ) -> blockchain_models.CreateBusinessDidResponse:
        """
        Description: 通过授权宝创建did
        Summary: 创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_did_ex(request, headers, runtime)

    async def create_business_did_async(
        self,
        request: blockchain_models.CreateBusinessDidRequest,
    ) -> blockchain_models.CreateBusinessDidResponse:
        """
        Description: 通过授权宝创建did
        Summary: 创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_did_ex_async(request, headers, runtime)

    def create_business_did_ex(
        self,
        request: blockchain_models.CreateBusinessDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessDidResponse:
        """
        Description: 通过授权宝创建did
        Summary: 创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessDidResponse(),
            self.do_request('1.0', 'baas.business.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_did_ex_async(
        self,
        request: blockchain_models.CreateBusinessDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessDidResponse:
        """
        Description: 通过授权宝创建did
        Summary: 创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessDidResponse(),
            await self.do_request_async('1.0', 'baas.business.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_bizaccount(
        self,
        request: blockchain_models.CreateBusinessBizaccountRequest,
    ) -> blockchain_models.CreateBusinessBizaccountResponse:
        """
        Description: 根据did创建链上账户
        Summary: 根据did创建链上账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_bizaccount_ex(request, headers, runtime)

    async def create_business_bizaccount_async(
        self,
        request: blockchain_models.CreateBusinessBizaccountRequest,
    ) -> blockchain_models.CreateBusinessBizaccountResponse:
        """
        Description: 根据did创建链上账户
        Summary: 根据did创建链上账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_bizaccount_ex_async(request, headers, runtime)

    def create_business_bizaccount_ex(
        self,
        request: blockchain_models.CreateBusinessBizaccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessBizaccountResponse:
        """
        Description: 根据did创建链上账户
        Summary: 根据did创建链上账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessBizaccountResponse(),
            self.do_request('1.0', 'baas.business.bizaccount.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_bizaccount_ex_async(
        self,
        request: blockchain_models.CreateBusinessBizaccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessBizaccountResponse:
        """
        Description: 根据did创建链上账户
        Summary: 根据did创建链上账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessBizaccountResponse(),
            await self.do_request_async('1.0', 'baas.business.bizaccount.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_deposit(
        self,
        request: blockchain_models.QueryBusinessDepositRequest,
    ) -> blockchain_models.QueryBusinessDepositResponse:
        """
        Description: 查询存证数据
        Summary: 查询存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_deposit_ex(request, headers, runtime)

    async def query_business_deposit_async(
        self,
        request: blockchain_models.QueryBusinessDepositRequest,
    ) -> blockchain_models.QueryBusinessDepositResponse:
        """
        Description: 查询存证数据
        Summary: 查询存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_deposit_ex_async(request, headers, runtime)

    def query_business_deposit_ex(
        self,
        request: blockchain_models.QueryBusinessDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessDepositResponse:
        """
        Description: 查询存证数据
        Summary: 查询存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessDepositResponse(),
            self.do_request('1.0', 'baas.business.deposit.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_deposit_ex_async(
        self,
        request: blockchain_models.QueryBusinessDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessDepositResponse:
        """
        Description: 查询存证数据
        Summary: 查询存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessDepositResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def auth_business_depositdata(
        self,
        request: blockchain_models.AuthBusinessDepositdataRequest,
    ) -> blockchain_models.AuthBusinessDepositdataResponse:
        """
        Description: 授权存证数据
        Summary: 授权存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.auth_business_depositdata_ex(request, headers, runtime)

    async def auth_business_depositdata_async(
        self,
        request: blockchain_models.AuthBusinessDepositdataRequest,
    ) -> blockchain_models.AuthBusinessDepositdataResponse:
        """
        Description: 授权存证数据
        Summary: 授权存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.auth_business_depositdata_ex_async(request, headers, runtime)

    def auth_business_depositdata_ex(
        self,
        request: blockchain_models.AuthBusinessDepositdataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthBusinessDepositdataResponse:
        """
        Description: 授权存证数据
        Summary: 授权存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthBusinessDepositdataResponse(),
            self.do_request('1.0', 'baas.business.depositdata.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def auth_business_depositdata_ex_async(
        self,
        request: blockchain_models.AuthBusinessDepositdataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthBusinessDepositdataResponse:
        """
        Description: 授权存证数据
        Summary: 授权存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthBusinessDepositdataResponse(),
            await self.do_request_async('1.0', 'baas.business.depositdata.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_contract_deploy(
        self,
        request: blockchain_models.CreateBusinessContractDeployRequest,
    ) -> blockchain_models.CreateBusinessContractDeployResponse:
        """
        Description: 创建部署合约
        Summary: 创建部署合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_contract_deploy_ex(request, headers, runtime)

    async def create_business_contract_deploy_async(
        self,
        request: blockchain_models.CreateBusinessContractDeployRequest,
    ) -> blockchain_models.CreateBusinessContractDeployResponse:
        """
        Description: 创建部署合约
        Summary: 创建部署合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_contract_deploy_ex_async(request, headers, runtime)

    def create_business_contract_deploy_ex(
        self,
        request: blockchain_models.CreateBusinessContractDeployRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractDeployResponse:
        """
        Description: 创建部署合约
        Summary: 创建部署合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractDeployResponse(),
            self.do_request('1.0', 'baas.business.contract.deploy.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_contract_deploy_ex_async(
        self,
        request: blockchain_models.CreateBusinessContractDeployRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractDeployResponse:
        """
        Description: 创建部署合约
        Summary: 创建部署合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractDeployResponse(),
            await self.do_request_async('1.0', 'baas.business.contract.deploy.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_contractnormalcall(
        self,
        request: blockchain_models.CreateBusinessContractnormalcallRequest,
    ) -> blockchain_models.CreateBusinessContractnormalcallResponse:
        """
        Description: 普通合约接口调用
        Summary: 普通合约接口调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_contractnormalcall_ex(request, headers, runtime)

    async def create_business_contractnormalcall_async(
        self,
        request: blockchain_models.CreateBusinessContractnormalcallRequest,
    ) -> blockchain_models.CreateBusinessContractnormalcallResponse:
        """
        Description: 普通合约接口调用
        Summary: 普通合约接口调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_contractnormalcall_ex_async(request, headers, runtime)

    def create_business_contractnormalcall_ex(
        self,
        request: blockchain_models.CreateBusinessContractnormalcallRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractnormalcallResponse:
        """
        Description: 普通合约接口调用
        Summary: 普通合约接口调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractnormalcallResponse(),
            self.do_request('1.0', 'baas.business.contractnormalcall.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_contractnormalcall_ex_async(
        self,
        request: blockchain_models.CreateBusinessContractnormalcallRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractnormalcallResponse:
        """
        Description: 普通合约接口调用
        Summary: 普通合约接口调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractnormalcallResponse(),
            await self.do_request_async('1.0', 'baas.business.contractnormalcall.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_contractencryptcall(
        self,
        request: blockchain_models.CreateBusinessContractencryptcallRequest,
    ) -> blockchain_models.CreateBusinessContractencryptcallResponse:
        """
        Description: 调用加密合约接口
        Summary: 调用加密合约接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_contractencryptcall_ex(request, headers, runtime)

    async def create_business_contractencryptcall_async(
        self,
        request: blockchain_models.CreateBusinessContractencryptcallRequest,
    ) -> blockchain_models.CreateBusinessContractencryptcallResponse:
        """
        Description: 调用加密合约接口
        Summary: 调用加密合约接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_contractencryptcall_ex_async(request, headers, runtime)

    def create_business_contractencryptcall_ex(
        self,
        request: blockchain_models.CreateBusinessContractencryptcallRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractencryptcallResponse:
        """
        Description: 调用加密合约接口
        Summary: 调用加密合约接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractencryptcallResponse(),
            self.do_request('1.0', 'baas.business.contractencryptcall.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_contractencryptcall_ex_async(
        self,
        request: blockchain_models.CreateBusinessContractencryptcallRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractencryptcallResponse:
        """
        Description: 调用加密合约接口
        Summary: 调用加密合约接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractencryptcallResponse(),
            await self.do_request_async('1.0', 'baas.business.contractencryptcall.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_contractreceipt(
        self,
        request: blockchain_models.QueryBusinessContractreceiptRequest,
    ) -> blockchain_models.QueryBusinessContractreceiptResponse:
        """
        Description: 查询交易receipt
        Summary: 查询交易receipt
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_contractreceipt_ex(request, headers, runtime)

    async def query_business_contractreceipt_async(
        self,
        request: blockchain_models.QueryBusinessContractreceiptRequest,
    ) -> blockchain_models.QueryBusinessContractreceiptResponse:
        """
        Description: 查询交易receipt
        Summary: 查询交易receipt
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_contractreceipt_ex_async(request, headers, runtime)

    def query_business_contractreceipt_ex(
        self,
        request: blockchain_models.QueryBusinessContractreceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractreceiptResponse:
        """
        Description: 查询交易receipt
        Summary: 查询交易receipt
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractreceiptResponse(),
            self.do_request('1.0', 'baas.business.contractreceipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_contractreceipt_ex_async(
        self,
        request: blockchain_models.QueryBusinessContractreceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractreceiptResponse:
        """
        Description: 查询交易receipt
        Summary: 查询交易receipt
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractreceiptResponse(),
            await self.do_request_async('1.0', 'baas.business.contractreceipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_contractencryptreceipt(
        self,
        request: blockchain_models.QueryBusinessContractencryptreceiptRequest,
    ) -> blockchain_models.QueryBusinessContractencryptreceiptResponse:
        """
        Description: 查询加密的receipt
        Summary: 查询加密的receipt
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_contractencryptreceipt_ex(request, headers, runtime)

    async def query_business_contractencryptreceipt_async(
        self,
        request: blockchain_models.QueryBusinessContractencryptreceiptRequest,
    ) -> blockchain_models.QueryBusinessContractencryptreceiptResponse:
        """
        Description: 查询加密的receipt
        Summary: 查询加密的receipt
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_contractencryptreceipt_ex_async(request, headers, runtime)

    def query_business_contractencryptreceipt_ex(
        self,
        request: blockchain_models.QueryBusinessContractencryptreceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractencryptreceiptResponse:
        """
        Description: 查询加密的receipt
        Summary: 查询加密的receipt
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractencryptreceiptResponse(),
            self.do_request('1.0', 'baas.business.contractencryptreceipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_contractencryptreceipt_ex_async(
        self,
        request: blockchain_models.QueryBusinessContractencryptreceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractencryptreceiptResponse:
        """
        Description: 查询加密的receipt
        Summary: 查询加密的receipt
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractencryptreceiptResponse(),
            await self.do_request_async('1.0', 'baas.business.contractencryptreceipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_contractencryptmethod(
        self,
        request: blockchain_models.QueryBusinessContractencryptmethodRequest,
    ) -> blockchain_models.QueryBusinessContractencryptmethodResponse:
        """
        Description: 查询合约加密内容的方法
        Summary: 查询合约加密内容的方法
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_contractencryptmethod_ex(request, headers, runtime)

    async def query_business_contractencryptmethod_async(
        self,
        request: blockchain_models.QueryBusinessContractencryptmethodRequest,
    ) -> blockchain_models.QueryBusinessContractencryptmethodResponse:
        """
        Description: 查询合约加密内容的方法
        Summary: 查询合约加密内容的方法
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_contractencryptmethod_ex_async(request, headers, runtime)

    def query_business_contractencryptmethod_ex(
        self,
        request: blockchain_models.QueryBusinessContractencryptmethodRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractencryptmethodResponse:
        """
        Description: 查询合约加密内容的方法
        Summary: 查询合约加密内容的方法
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractencryptmethodResponse(),
            self.do_request('1.0', 'baas.business.contractencryptmethod.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_contractencryptmethod_ex_async(
        self,
        request: blockchain_models.QueryBusinessContractencryptmethodRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessContractencryptmethodResponse:
        """
        Description: 查询合约加密内容的方法
        Summary: 查询合约加密内容的方法
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessContractencryptmethodResponse(),
            await self.do_request_async('1.0', 'baas.business.contractencryptmethod.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def deploy_business_agreement(
        self,
        request: blockchain_models.DeployBusinessAgreementRequest,
    ) -> blockchain_models.DeployBusinessAgreementResponse:
        """
        Description: 部署业务共识合约
        Summary: 部署业务共识合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.deploy_business_agreement_ex(request, headers, runtime)

    async def deploy_business_agreement_async(
        self,
        request: blockchain_models.DeployBusinessAgreementRequest,
    ) -> blockchain_models.DeployBusinessAgreementResponse:
        """
        Description: 部署业务共识合约
        Summary: 部署业务共识合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.deploy_business_agreement_ex_async(request, headers, runtime)

    def deploy_business_agreement_ex(
        self,
        request: blockchain_models.DeployBusinessAgreementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeployBusinessAgreementResponse:
        """
        Description: 部署业务共识合约
        Summary: 部署业务共识合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeployBusinessAgreementResponse(),
            self.do_request('1.0', 'baas.business.agreement.deploy', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def deploy_business_agreement_ex_async(
        self,
        request: blockchain_models.DeployBusinessAgreementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeployBusinessAgreementResponse:
        """
        Description: 部署业务共识合约
        Summary: 部署业务共识合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeployBusinessAgreementResponse(),
            await self.do_request_async('1.0', 'baas.business.agreement.deploy', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_agreement_registertemplate(
        self,
        request: blockchain_models.CreateBusinessAgreementRegistertemplateRequest,
    ) -> blockchain_models.CreateBusinessAgreementRegistertemplateResponse:
        """
        Description: 创建业务共识模板
        Summary: 创建业务共识模板
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_agreement_registertemplate_ex(request, headers, runtime)

    async def create_business_agreement_registertemplate_async(
        self,
        request: blockchain_models.CreateBusinessAgreementRegistertemplateRequest,
    ) -> blockchain_models.CreateBusinessAgreementRegistertemplateResponse:
        """
        Description: 创建业务共识模板
        Summary: 创建业务共识模板
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_agreement_registertemplate_ex_async(request, headers, runtime)

    def create_business_agreement_registertemplate_ex(
        self,
        request: blockchain_models.CreateBusinessAgreementRegistertemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementRegistertemplateResponse:
        """
        Description: 创建业务共识模板
        Summary: 创建业务共识模板
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementRegistertemplateResponse(),
            self.do_request('1.0', 'baas.business.agreement.registertemplate.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_agreement_registertemplate_ex_async(
        self,
        request: blockchain_models.CreateBusinessAgreementRegistertemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementRegistertemplateResponse:
        """
        Description: 创建业务共识模板
        Summary: 创建业务共识模板
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementRegistertemplateResponse(),
            await self.do_request_async('1.0', 'baas.business.agreement.registertemplate.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_agreement_register(
        self,
        request: blockchain_models.CreateBusinessAgreementRegisterRequest,
    ) -> blockchain_models.CreateBusinessAgreementRegisterResponse:
        """
        Description: 注册业务共识实例
        Summary: 注册业务共识实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_agreement_register_ex(request, headers, runtime)

    async def create_business_agreement_register_async(
        self,
        request: blockchain_models.CreateBusinessAgreementRegisterRequest,
    ) -> blockchain_models.CreateBusinessAgreementRegisterResponse:
        """
        Description: 注册业务共识实例
        Summary: 注册业务共识实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_agreement_register_ex_async(request, headers, runtime)

    def create_business_agreement_register_ex(
        self,
        request: blockchain_models.CreateBusinessAgreementRegisterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementRegisterResponse:
        """
        Description: 注册业务共识实例
        Summary: 注册业务共识实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementRegisterResponse(),
            self.do_request('1.0', 'baas.business.agreement.register.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_agreement_register_ex_async(
        self,
        request: blockchain_models.CreateBusinessAgreementRegisterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementRegisterResponse:
        """
        Description: 注册业务共识实例
        Summary: 注册业务共识实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementRegisterResponse(),
            await self.do_request_async('1.0', 'baas.business.agreement.register.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_agreement_sign(
        self,
        request: blockchain_models.CreateBusinessAgreementSignRequest,
    ) -> blockchain_models.CreateBusinessAgreementSignResponse:
        """
        Description: 对业务共识key进行签名认可
        Summary: 对业务共识key进行签名认可
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_agreement_sign_ex(request, headers, runtime)

    async def create_business_agreement_sign_async(
        self,
        request: blockchain_models.CreateBusinessAgreementSignRequest,
    ) -> blockchain_models.CreateBusinessAgreementSignResponse:
        """
        Description: 对业务共识key进行签名认可
        Summary: 对业务共识key进行签名认可
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_agreement_sign_ex_async(request, headers, runtime)

    def create_business_agreement_sign_ex(
        self,
        request: blockchain_models.CreateBusinessAgreementSignRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementSignResponse:
        """
        Description: 对业务共识key进行签名认可
        Summary: 对业务共识key进行签名认可
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementSignResponse(),
            self.do_request('1.0', 'baas.business.agreement.sign.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_agreement_sign_ex_async(
        self,
        request: blockchain_models.CreateBusinessAgreementSignRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessAgreementSignResponse:
        """
        Description: 对业务共识key进行签名认可
        Summary: 对业务共识key进行签名认可
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessAgreementSignResponse(),
            await self.do_request_async('1.0', 'baas.business.agreement.sign.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_agreement(
        self,
        request: blockchain_models.QueryBusinessAgreementRequest,
    ) -> blockchain_models.QueryBusinessAgreementResponse:
        """
        Description: 查询业务共识当前状态
        Summary: 查询业务共识当前状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_agreement_ex(request, headers, runtime)

    async def query_business_agreement_async(
        self,
        request: blockchain_models.QueryBusinessAgreementRequest,
    ) -> blockchain_models.QueryBusinessAgreementResponse:
        """
        Description: 查询业务共识当前状态
        Summary: 查询业务共识当前状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_agreement_ex_async(request, headers, runtime)

    def query_business_agreement_ex(
        self,
        request: blockchain_models.QueryBusinessAgreementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessAgreementResponse:
        """
        Description: 查询业务共识当前状态
        Summary: 查询业务共识当前状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessAgreementResponse(),
            self.do_request('1.0', 'baas.business.agreement.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_agreement_ex_async(
        self,
        request: blockchain_models.QueryBusinessAgreementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessAgreementResponse:
        """
        Description: 查询业务共识当前状态
        Summary: 查询业务共识当前状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessAgreementResponse(),
            await self.do_request_async('1.0', 'baas.business.agreement.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_contract_grantdid(
        self,
        request: blockchain_models.CreateBusinessContractGrantdidRequest,
    ) -> blockchain_models.CreateBusinessContractGrantdidResponse:
        """
        Description: 对合约隐私key授权
        Summary: 对合约隐私key授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_contract_grantdid_ex(request, headers, runtime)

    async def create_business_contract_grantdid_async(
        self,
        request: blockchain_models.CreateBusinessContractGrantdidRequest,
    ) -> blockchain_models.CreateBusinessContractGrantdidResponse:
        """
        Description: 对合约隐私key授权
        Summary: 对合约隐私key授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_contract_grantdid_ex_async(request, headers, runtime)

    def create_business_contract_grantdid_ex(
        self,
        request: blockchain_models.CreateBusinessContractGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractGrantdidResponse:
        """
        Description: 对合约隐私key授权
        Summary: 对合约隐私key授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractGrantdidResponse(),
            self.do_request('1.0', 'baas.business.contract.grantdid.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_contract_grantdid_ex_async(
        self,
        request: blockchain_models.CreateBusinessContractGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractGrantdidResponse:
        """
        Description: 对合约隐私key授权
        Summary: 对合约隐私key授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractGrantdidResponse(),
            await self.do_request_async('1.0', 'baas.business.contract.grantdid.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_business_deposit_encryptedmetadata(
        self,
        request: blockchain_models.QueryBusinessDepositEncryptedmetadataRequest,
    ) -> blockchain_models.QueryBusinessDepositEncryptedmetadataResponse:
        """
        Description: 查询被加密的存证数据
        Summary: 查询被加密的存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_business_deposit_encryptedmetadata_ex(request, headers, runtime)

    async def query_business_deposit_encryptedmetadata_async(
        self,
        request: blockchain_models.QueryBusinessDepositEncryptedmetadataRequest,
    ) -> blockchain_models.QueryBusinessDepositEncryptedmetadataResponse:
        """
        Description: 查询被加密的存证数据
        Summary: 查询被加密的存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_business_deposit_encryptedmetadata_ex_async(request, headers, runtime)

    def query_business_deposit_encryptedmetadata_ex(
        self,
        request: blockchain_models.QueryBusinessDepositEncryptedmetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessDepositEncryptedmetadataResponse:
        """
        Description: 查询被加密的存证数据
        Summary: 查询被加密的存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessDepositEncryptedmetadataResponse(),
            self.do_request('1.0', 'baas.business.deposit.encryptedmetadata.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_business_deposit_encryptedmetadata_ex_async(
        self,
        request: blockchain_models.QueryBusinessDepositEncryptedmetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBusinessDepositEncryptedmetadataResponse:
        """
        Description: 查询被加密的存证数据
        Summary: 查询被加密的存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBusinessDepositEncryptedmetadataResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.encryptedmetadata.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def auth_business_depositdata_corp(
        self,
        request: blockchain_models.AuthBusinessDepositdataCorpRequest,
    ) -> blockchain_models.AuthBusinessDepositdataCorpResponse:
        """
        Description: 授权存证数据给对应的组织机构，该组织下所有的人员都可以查询该存证数据的原内容
        Summary: 授权存证数据给对应的组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.auth_business_depositdata_corp_ex(request, headers, runtime)

    async def auth_business_depositdata_corp_async(
        self,
        request: blockchain_models.AuthBusinessDepositdataCorpRequest,
    ) -> blockchain_models.AuthBusinessDepositdataCorpResponse:
        """
        Description: 授权存证数据给对应的组织机构，该组织下所有的人员都可以查询该存证数据的原内容
        Summary: 授权存证数据给对应的组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.auth_business_depositdata_corp_ex_async(request, headers, runtime)

    def auth_business_depositdata_corp_ex(
        self,
        request: blockchain_models.AuthBusinessDepositdataCorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthBusinessDepositdataCorpResponse:
        """
        Description: 授权存证数据给对应的组织机构，该组织下所有的人员都可以查询该存证数据的原内容
        Summary: 授权存证数据给对应的组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthBusinessDepositdataCorpResponse(),
            self.do_request('1.0', 'baas.business.depositdata.corp.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def auth_business_depositdata_corp_ex_async(
        self,
        request: blockchain_models.AuthBusinessDepositdataCorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthBusinessDepositdataCorpResponse:
        """
        Description: 授权存证数据给对应的组织机构，该组织下所有的人员都可以查询该存证数据的原内容
        Summary: 授权存证数据给对应的组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthBusinessDepositdataCorpResponse(),
            await self.do_request_async('1.0', 'baas.business.depositdata.corp.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def cancel_business_deposit_grantdid(
        self,
        request: blockchain_models.CancelBusinessDepositGrantdidRequest,
    ) -> blockchain_models.CancelBusinessDepositGrantdidResponse:
        """
        Description: 取消存证数据授权给账户
        Summary: 取消存证数据授权给账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_business_deposit_grantdid_ex(request, headers, runtime)

    async def cancel_business_deposit_grantdid_async(
        self,
        request: blockchain_models.CancelBusinessDepositGrantdidRequest,
    ) -> blockchain_models.CancelBusinessDepositGrantdidResponse:
        """
        Description: 取消存证数据授权给账户
        Summary: 取消存证数据授权给账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_business_deposit_grantdid_ex_async(request, headers, runtime)

    def cancel_business_deposit_grantdid_ex(
        self,
        request: blockchain_models.CancelBusinessDepositGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessDepositGrantdidResponse:
        """
        Description: 取消存证数据授权给账户
        Summary: 取消存证数据授权给账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessDepositGrantdidResponse(),
            self.do_request('1.0', 'baas.business.deposit.grantdid.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def cancel_business_deposit_grantdid_ex_async(
        self,
        request: blockchain_models.CancelBusinessDepositGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessDepositGrantdidResponse:
        """
        Description: 取消存证数据授权给账户
        Summary: 取消存证数据授权给账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessDepositGrantdidResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.grantdid.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def cancel_business_deposit_grantcorp(
        self,
        request: blockchain_models.CancelBusinessDepositGrantcorpRequest,
    ) -> blockchain_models.CancelBusinessDepositGrantcorpResponse:
        """
        Description: 取消存证授权给组织机构
        Summary: 取消存证授权给组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_business_deposit_grantcorp_ex(request, headers, runtime)

    async def cancel_business_deposit_grantcorp_async(
        self,
        request: blockchain_models.CancelBusinessDepositGrantcorpRequest,
    ) -> blockchain_models.CancelBusinessDepositGrantcorpResponse:
        """
        Description: 取消存证授权给组织机构
        Summary: 取消存证授权给组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_business_deposit_grantcorp_ex_async(request, headers, runtime)

    def cancel_business_deposit_grantcorp_ex(
        self,
        request: blockchain_models.CancelBusinessDepositGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessDepositGrantcorpResponse:
        """
        Description: 取消存证授权给组织机构
        Summary: 取消存证授权给组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessDepositGrantcorpResponse(),
            self.do_request('1.0', 'baas.business.deposit.grantcorp.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def cancel_business_deposit_grantcorp_ex_async(
        self,
        request: blockchain_models.CancelBusinessDepositGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessDepositGrantcorpResponse:
        """
        Description: 取消存证授权给组织机构
        Summary: 取消存证授权给组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessDepositGrantcorpResponse(),
            await self.do_request_async('1.0', 'baas.business.deposit.grantcorp.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_business_contract_grantcorp(
        self,
        request: blockchain_models.CreateBusinessContractGrantcorpRequest,
    ) -> blockchain_models.CreateBusinessContractGrantcorpResponse:
        """
        Description: 授权合约内加密字段给机构，机构下的所有人都有权限访问该数据
        Summary: 授权合约内加密字段给机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_business_contract_grantcorp_ex(request, headers, runtime)

    async def create_business_contract_grantcorp_async(
        self,
        request: blockchain_models.CreateBusinessContractGrantcorpRequest,
    ) -> blockchain_models.CreateBusinessContractGrantcorpResponse:
        """
        Description: 授权合约内加密字段给机构，机构下的所有人都有权限访问该数据
        Summary: 授权合约内加密字段给机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_business_contract_grantcorp_ex_async(request, headers, runtime)

    def create_business_contract_grantcorp_ex(
        self,
        request: blockchain_models.CreateBusinessContractGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractGrantcorpResponse:
        """
        Description: 授权合约内加密字段给机构，机构下的所有人都有权限访问该数据
        Summary: 授权合约内加密字段给机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractGrantcorpResponse(),
            self.do_request('1.0', 'baas.business.contract.grantcorp.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_business_contract_grantcorp_ex_async(
        self,
        request: blockchain_models.CreateBusinessContractGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBusinessContractGrantcorpResponse:
        """
        Description: 授权合约内加密字段给机构，机构下的所有人都有权限访问该数据
        Summary: 授权合约内加密字段给机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBusinessContractGrantcorpResponse(),
            await self.do_request_async('1.0', 'baas.business.contract.grantcorp.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def cancel_business_contract_grantdid(
        self,
        request: blockchain_models.CancelBusinessContractGrantdidRequest,
    ) -> blockchain_models.CancelBusinessContractGrantdidResponse:
        """
        Description: 取消授权did查询加密数据
        Summary: 取消授权did查询加密数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_business_contract_grantdid_ex(request, headers, runtime)

    async def cancel_business_contract_grantdid_async(
        self,
        request: blockchain_models.CancelBusinessContractGrantdidRequest,
    ) -> blockchain_models.CancelBusinessContractGrantdidResponse:
        """
        Description: 取消授权did查询加密数据
        Summary: 取消授权did查询加密数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_business_contract_grantdid_ex_async(request, headers, runtime)

    def cancel_business_contract_grantdid_ex(
        self,
        request: blockchain_models.CancelBusinessContractGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessContractGrantdidResponse:
        """
        Description: 取消授权did查询加密数据
        Summary: 取消授权did查询加密数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessContractGrantdidResponse(),
            self.do_request('1.0', 'baas.business.contract.grantdid.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def cancel_business_contract_grantdid_ex_async(
        self,
        request: blockchain_models.CancelBusinessContractGrantdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessContractGrantdidResponse:
        """
        Description: 取消授权did查询加密数据
        Summary: 取消授权did查询加密数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessContractGrantdidResponse(),
            await self.do_request_async('1.0', 'baas.business.contract.grantdid.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def cancel_business_contract_grantcorp(
        self,
        request: blockchain_models.CancelBusinessContractGrantcorpRequest,
    ) -> blockchain_models.CancelBusinessContractGrantcorpResponse:
        """
        Description: 取消授权给组织机构
        Summary: 取消授权给组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_business_contract_grantcorp_ex(request, headers, runtime)

    async def cancel_business_contract_grantcorp_async(
        self,
        request: blockchain_models.CancelBusinessContractGrantcorpRequest,
    ) -> blockchain_models.CancelBusinessContractGrantcorpResponse:
        """
        Description: 取消授权给组织机构
        Summary: 取消授权给组织机构
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_business_contract_grantcorp_ex_async(request, headers, runtime)

    def cancel_business_contract_grantcorp_ex(
        self,
        request: blockchain_models.CancelBusinessContractGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessContractGrantcorpResponse:
        """
        Description: 取消授权给组织机构
        Summary: 取消授权给组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessContractGrantcorpResponse(),
            self.do_request('1.0', 'baas.business.contract.grantcorp.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def cancel_business_contract_grantcorp_ex_async(
        self,
        request: blockchain_models.CancelBusinessContractGrantcorpRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelBusinessContractGrantcorpResponse:
        """
        Description: 取消授权给组织机构
        Summary: 取消授权给组织机构
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelBusinessContractGrantcorpResponse(),
            await self.do_request_async('1.0', 'baas.business.contract.grantcorp.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def import_platform_testregion_testfunc(
        self,
        request: blockchain_models.ImportPlatformTestregionTestfuncRequest,
    ) -> blockchain_models.ImportPlatformTestregionTestfuncResponse:
        """
        Description: 业务中台测试接口
        Summary: 业务中台测试接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.import_platform_testregion_testfunc_ex(request, headers, runtime)

    async def import_platform_testregion_testfunc_async(
        self,
        request: blockchain_models.ImportPlatformTestregionTestfuncRequest,
    ) -> blockchain_models.ImportPlatformTestregionTestfuncResponse:
        """
        Description: 业务中台测试接口
        Summary: 业务中台测试接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.import_platform_testregion_testfunc_ex_async(request, headers, runtime)

    def import_platform_testregion_testfunc_ex(
        self,
        request: blockchain_models.ImportPlatformTestregionTestfuncRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ImportPlatformTestregionTestfuncResponse:
        """
        Description: 业务中台测试接口
        Summary: 业务中台测试接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ImportPlatformTestregionTestfuncResponse(),
            self.do_request('1.0', 'baas.platform.testregion.testfunc.import', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def import_platform_testregion_testfunc_ex_async(
        self,
        request: blockchain_models.ImportPlatformTestregionTestfuncRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ImportPlatformTestregionTestfuncResponse:
        """
        Description: 业务中台测试接口
        Summary: 业务中台测试接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ImportPlatformTestregionTestfuncResponse(),
            await self.do_request_async('1.0', 'baas.platform.testregion.testfunc.import', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_platform_deposit_account(
        self,
        request: blockchain_models.CreatePlatformDepositAccountRequest,
    ) -> blockchain_models.CreatePlatformDepositAccountResponse:
        """
        Description: 存证创建账户
        Summary: 存证创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_platform_deposit_account_ex(request, headers, runtime)

    async def create_platform_deposit_account_async(
        self,
        request: blockchain_models.CreatePlatformDepositAccountRequest,
    ) -> blockchain_models.CreatePlatformDepositAccountResponse:
        """
        Description: 存证创建账户
        Summary: 存证创建账户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_platform_deposit_account_ex_async(request, headers, runtime)

    def create_platform_deposit_account_ex(
        self,
        request: blockchain_models.CreatePlatformDepositAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositAccountResponse:
        """
        Description: 存证创建账户
        Summary: 存证创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositAccountResponse(),
            self.do_request('1.0', 'baas.platform.deposit.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_platform_deposit_account_ex_async(
        self,
        request: blockchain_models.CreatePlatformDepositAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositAccountResponse:
        """
        Description: 存证创建账户
        Summary: 存证创建账户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositAccountResponse(),
            await self.do_request_async('1.0', 'baas.platform.deposit.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_platform_deposit_did(
        self,
        request: blockchain_models.CreatePlatformDepositDidRequest,
    ) -> blockchain_models.CreatePlatformDepositDidResponse:
        """
        Description: 存证创建did
        Summary: 存证创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_platform_deposit_did_ex(request, headers, runtime)

    async def create_platform_deposit_did_async(
        self,
        request: blockchain_models.CreatePlatformDepositDidRequest,
    ) -> blockchain_models.CreatePlatformDepositDidResponse:
        """
        Description: 存证创建did
        Summary: 存证创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_platform_deposit_did_ex_async(request, headers, runtime)

    def create_platform_deposit_did_ex(
        self,
        request: blockchain_models.CreatePlatformDepositDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositDidResponse:
        """
        Description: 存证创建did
        Summary: 存证创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositDidResponse(),
            self.do_request('1.0', 'baas.platform.deposit.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_platform_deposit_did_ex_async(
        self,
        request: blockchain_models.CreatePlatformDepositDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositDidResponse:
        """
        Description: 存证创建did
        Summary: 存证创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositDidResponse(),
            await self.do_request_async('1.0', 'baas.platform.deposit.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_platform_deposit_deposit(
        self,
        request: blockchain_models.SavePlatformDepositDepositRequest,
    ) -> blockchain_models.SavePlatformDepositDepositResponse:
        """
        Description: 普通数据存证
        Summary: 普通数据存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_platform_deposit_deposit_ex(request, headers, runtime)

    async def save_platform_deposit_deposit_async(
        self,
        request: blockchain_models.SavePlatformDepositDepositRequest,
    ) -> blockchain_models.SavePlatformDepositDepositResponse:
        """
        Description: 普通数据存证
        Summary: 普通数据存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_platform_deposit_deposit_ex_async(request, headers, runtime)

    def save_platform_deposit_deposit_ex(
        self,
        request: blockchain_models.SavePlatformDepositDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SavePlatformDepositDepositResponse:
        """
        Description: 普通数据存证
        Summary: 普通数据存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SavePlatformDepositDepositResponse(),
            self.do_request('1.0', 'baas.platform.deposit.deposit.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_platform_deposit_deposit_ex_async(
        self,
        request: blockchain_models.SavePlatformDepositDepositRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SavePlatformDepositDepositResponse:
        """
        Description: 普通数据存证
        Summary: 普通数据存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SavePlatformDepositDepositResponse(),
            await self.do_request_async('1.0', 'baas.platform.deposit.deposit.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_platform_deposit_corpdid(
        self,
        request: blockchain_models.CreatePlatformDepositCorpdidRequest,
    ) -> blockchain_models.CreatePlatformDepositCorpdidResponse:
        """
        Description: 为企业创建did
        Summary: 为企业创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_platform_deposit_corpdid_ex(request, headers, runtime)

    async def create_platform_deposit_corpdid_async(
        self,
        request: blockchain_models.CreatePlatformDepositCorpdidRequest,
    ) -> blockchain_models.CreatePlatformDepositCorpdidResponse:
        """
        Description: 为企业创建did
        Summary: 为企业创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_platform_deposit_corpdid_ex_async(request, headers, runtime)

    def create_platform_deposit_corpdid_ex(
        self,
        request: blockchain_models.CreatePlatformDepositCorpdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositCorpdidResponse:
        """
        Description: 为企业创建did
        Summary: 为企业创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositCorpdidResponse(),
            self.do_request('1.0', 'baas.platform.deposit.corpdid.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_platform_deposit_corpdid_ex_async(
        self,
        request: blockchain_models.CreatePlatformDepositCorpdidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreatePlatformDepositCorpdidResponse:
        """
        Description: 为企业创建did
        Summary: 为企业创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreatePlatformDepositCorpdidResponse(),
            await self.do_request_async('1.0', 'baas.platform.deposit.corpdid.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_digitalassetart_account(
        self,
        request: blockchain_models.CreateDigitalassetartAccountRequest,
    ) -> blockchain_models.CreateDigitalassetartAccountResponse:
        """
        Description: 用于对用户的账户映射，输入用户名、账户、手机号等信息，返回用户的链上身份信息
        Summary: 用户账号映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_digitalassetart_account_ex(request, headers, runtime)

    async def create_digitalassetart_account_async(
        self,
        request: blockchain_models.CreateDigitalassetartAccountRequest,
    ) -> blockchain_models.CreateDigitalassetartAccountResponse:
        """
        Description: 用于对用户的账户映射，输入用户名、账户、手机号等信息，返回用户的链上身份信息
        Summary: 用户账号映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_digitalassetart_account_ex_async(request, headers, runtime)

    def create_digitalassetart_account_ex(
        self,
        request: blockchain_models.CreateDigitalassetartAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetartAccountResponse:
        """
        Description: 用于对用户的账户映射，输入用户名、账户、手机号等信息，返回用户的链上身份信息
        Summary: 用户账号映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetartAccountResponse(),
            self.do_request('1.0', 'baas.digitalassetart.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_digitalassetart_account_ex_async(
        self,
        request: blockchain_models.CreateDigitalassetartAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetartAccountResponse:
        """
        Description: 用于对用户的账户映射，输入用户名、账户、手机号等信息，返回用户的链上身份信息
        Summary: 用户账号映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetartAccountResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_digitalassetart_account(
        self,
        request: blockchain_models.BatchcreateDigitalassetartAccountRequest,
    ) -> blockchain_models.BatchcreateDigitalassetartAccountResponse:
        """
        Description: 批量账户映射
        Summary: 批量账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_digitalassetart_account_ex(request, headers, runtime)

    async def batchcreate_digitalassetart_account_async(
        self,
        request: blockchain_models.BatchcreateDigitalassetartAccountRequest,
    ) -> blockchain_models.BatchcreateDigitalassetartAccountResponse:
        """
        Description: 批量账户映射
        Summary: 批量账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_digitalassetart_account_ex_async(request, headers, runtime)

    def batchcreate_digitalassetart_account_ex(
        self,
        request: blockchain_models.BatchcreateDigitalassetartAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateDigitalassetartAccountResponse:
        """
        Description: 批量账户映射
        Summary: 批量账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateDigitalassetartAccountResponse(),
            self.do_request('1.0', 'baas.digitalassetart.account.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_digitalassetart_account_ex_async(
        self,
        request: blockchain_models.BatchcreateDigitalassetartAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateDigitalassetartAccountResponse:
        """
        Description: 批量账户映射
        Summary: 批量账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateDigitalassetartAccountResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.account.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_digitalassetart_art_create(
        self,
        request: blockchain_models.CreateDigitalassetartArtCreateRequest,
    ) -> blockchain_models.CreateDigitalassetartArtCreateResponse:
        """
        Description: 创建艺术品
        Summary: 创建艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_digitalassetart_art_create_ex(request, headers, runtime)

    async def create_digitalassetart_art_create_async(
        self,
        request: blockchain_models.CreateDigitalassetartArtCreateRequest,
    ) -> blockchain_models.CreateDigitalassetartArtCreateResponse:
        """
        Description: 创建艺术品
        Summary: 创建艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_digitalassetart_art_create_ex_async(request, headers, runtime)

    def create_digitalassetart_art_create_ex(
        self,
        request: blockchain_models.CreateDigitalassetartArtCreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetartArtCreateResponse:
        """
        Description: 创建艺术品
        Summary: 创建艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetartArtCreateResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.create.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_digitalassetart_art_create_ex_async(
        self,
        request: blockchain_models.CreateDigitalassetartArtCreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetartArtCreateResponse:
        """
        Description: 创建艺术品
        Summary: 创建艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetartArtCreateResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.create.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def set_digitalassetart_art_issue(
        self,
        request: blockchain_models.SetDigitalassetartArtIssueRequest,
    ) -> blockchain_models.SetDigitalassetartArtIssueResponse:
        """
        Description: 将艺术品从创建状态改为发行状态，只有在发行状态的艺术品才能进行各种交易
        Summary: 发行艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.set_digitalassetart_art_issue_ex(request, headers, runtime)

    async def set_digitalassetart_art_issue_async(
        self,
        request: blockchain_models.SetDigitalassetartArtIssueRequest,
    ) -> blockchain_models.SetDigitalassetartArtIssueResponse:
        """
        Description: 将艺术品从创建状态改为发行状态，只有在发行状态的艺术品才能进行各种交易
        Summary: 发行艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.set_digitalassetart_art_issue_ex_async(request, headers, runtime)

    def set_digitalassetart_art_issue_ex(
        self,
        request: blockchain_models.SetDigitalassetartArtIssueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtIssueResponse:
        """
        Description: 将艺术品从创建状态改为发行状态，只有在发行状态的艺术品才能进行各种交易
        Summary: 发行艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtIssueResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.issue.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def set_digitalassetart_art_issue_ex_async(
        self,
        request: blockchain_models.SetDigitalassetartArtIssueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtIssueResponse:
        """
        Description: 将艺术品从创建状态改为发行状态，只有在发行状态的艺术品才能进行各种交易
        Summary: 发行艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtIssueResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.issue.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def set_digitalassetart_art_issuetoexchange(
        self,
        request: blockchain_models.SetDigitalassetartArtIssuetoexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse:
        """
        Description: 将该艺术品发布到交易所
        Summary: 将该艺术品发布到交易所
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.set_digitalassetart_art_issuetoexchange_ex(request, headers, runtime)

    async def set_digitalassetart_art_issuetoexchange_async(
        self,
        request: blockchain_models.SetDigitalassetartArtIssuetoexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse:
        """
        Description: 将该艺术品发布到交易所
        Summary: 将该艺术品发布到交易所
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.set_digitalassetart_art_issuetoexchange_ex_async(request, headers, runtime)

    def set_digitalassetart_art_issuetoexchange_ex(
        self,
        request: blockchain_models.SetDigitalassetartArtIssuetoexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse:
        """
        Description: 将该艺术品发布到交易所
        Summary: 将该艺术品发布到交易所
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.issuetoexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def set_digitalassetart_art_issuetoexchange_ex_async(
        self,
        request: blockchain_models.SetDigitalassetartArtIssuetoexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse:
        """
        Description: 将该艺术品发布到交易所
        Summary: 将该艺术品发布到交易所
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtIssuetoexchangeResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.issuetoexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def set_digitalassetart_art_trade(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeRequest,
    ) -> blockchain_models.SetDigitalassetartArtTradeResponse:
        """
        Description: 艺术品本链交易
        Summary: 艺术品本链交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.set_digitalassetart_art_trade_ex(request, headers, runtime)

    async def set_digitalassetart_art_trade_async(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeRequest,
    ) -> blockchain_models.SetDigitalassetartArtTradeResponse:
        """
        Description: 艺术品本链交易
        Summary: 艺术品本链交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.set_digitalassetart_art_trade_ex_async(request, headers, runtime)

    def set_digitalassetart_art_trade_ex(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtTradeResponse:
        """
        Description: 艺术品本链交易
        Summary: 艺术品本链交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtTradeResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.trade.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def set_digitalassetart_art_trade_ex_async(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtTradeResponse:
        """
        Description: 艺术品本链交易
        Summary: 艺术品本链交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtTradeResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.trade.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def set_digitalassetart_art_tradeonexchange(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeonexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtTradeonexchangeResponse:
        """
        Description: 在交易所交易艺术品
        Summary: 在交易所交易艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.set_digitalassetart_art_tradeonexchange_ex(request, headers, runtime)

    async def set_digitalassetart_art_tradeonexchange_async(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeonexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtTradeonexchangeResponse:
        """
        Description: 在交易所交易艺术品
        Summary: 在交易所交易艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.set_digitalassetart_art_tradeonexchange_ex_async(request, headers, runtime)

    def set_digitalassetart_art_tradeonexchange_ex(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeonexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtTradeonexchangeResponse:
        """
        Description: 在交易所交易艺术品
        Summary: 在交易所交易艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtTradeonexchangeResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.tradeonexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def set_digitalassetart_art_tradeonexchange_ex_async(
        self,
        request: blockchain_models.SetDigitalassetartArtTradeonexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtTradeonexchangeResponse:
        """
        Description: 在交易所交易艺术品
        Summary: 在交易所交易艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtTradeonexchangeResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.tradeonexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def freeze_digitalassetart_art_account(
        self,
        request: blockchain_models.FreezeDigitalassetartArtAccountRequest,
    ) -> blockchain_models.FreezeDigitalassetartArtAccountResponse:
        """
        Description: 冻结艺术品
        Summary: 冻结艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.freeze_digitalassetart_art_account_ex(request, headers, runtime)

    async def freeze_digitalassetart_art_account_async(
        self,
        request: blockchain_models.FreezeDigitalassetartArtAccountRequest,
    ) -> blockchain_models.FreezeDigitalassetartArtAccountResponse:
        """
        Description: 冻结艺术品
        Summary: 冻结艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.freeze_digitalassetart_art_account_ex_async(request, headers, runtime)

    def freeze_digitalassetart_art_account_ex(
        self,
        request: blockchain_models.FreezeDigitalassetartArtAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FreezeDigitalassetartArtAccountResponse:
        """
        Description: 冻结艺术品
        Summary: 冻结艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FreezeDigitalassetartArtAccountResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.account.freeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def freeze_digitalassetart_art_account_ex_async(
        self,
        request: blockchain_models.FreezeDigitalassetartArtAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FreezeDigitalassetartArtAccountResponse:
        """
        Description: 冻结艺术品
        Summary: 冻结艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FreezeDigitalassetartArtAccountResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.account.freeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def unfreeze_digitalassetart_art_account(
        self,
        request: blockchain_models.UnfreezeDigitalassetartArtAccountRequest,
    ) -> blockchain_models.UnfreezeDigitalassetartArtAccountResponse:
        """
        Description: 艺术品解冻
        Summary: 艺术品解冻
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.unfreeze_digitalassetart_art_account_ex(request, headers, runtime)

    async def unfreeze_digitalassetart_art_account_async(
        self,
        request: blockchain_models.UnfreezeDigitalassetartArtAccountRequest,
    ) -> blockchain_models.UnfreezeDigitalassetartArtAccountResponse:
        """
        Description: 艺术品解冻
        Summary: 艺术品解冻
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.unfreeze_digitalassetart_art_account_ex_async(request, headers, runtime)

    def unfreeze_digitalassetart_art_account_ex(
        self,
        request: blockchain_models.UnfreezeDigitalassetartArtAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnfreezeDigitalassetartArtAccountResponse:
        """
        Description: 艺术品解冻
        Summary: 艺术品解冻
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnfreezeDigitalassetartArtAccountResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.account.unfreeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def unfreeze_digitalassetart_art_account_ex_async(
        self,
        request: blockchain_models.UnfreezeDigitalassetartArtAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnfreezeDigitalassetartArtAccountResponse:
        """
        Description: 艺术品解冻
        Summary: 艺术品解冻
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnfreezeDigitalassetartArtAccountResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.account.unfreeze', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def set_digitalassetart_art_unissuetoexchange(
        self,
        request: blockchain_models.SetDigitalassetartArtUnissuetoexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse:
        """
        Description: 取消在交易所发布艺术品
        Summary: 取消在交易所发布艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.set_digitalassetart_art_unissuetoexchange_ex(request, headers, runtime)

    async def set_digitalassetart_art_unissuetoexchange_async(
        self,
        request: blockchain_models.SetDigitalassetartArtUnissuetoexchangeRequest,
    ) -> blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse:
        """
        Description: 取消在交易所发布艺术品
        Summary: 取消在交易所发布艺术品
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.set_digitalassetart_art_unissuetoexchange_ex_async(request, headers, runtime)

    def set_digitalassetart_art_unissuetoexchange_ex(
        self,
        request: blockchain_models.SetDigitalassetartArtUnissuetoexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse:
        """
        Description: 取消在交易所发布艺术品
        Summary: 取消在交易所发布艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.unissuetoexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def set_digitalassetart_art_unissuetoexchange_ex_async(
        self,
        request: blockchain_models.SetDigitalassetartArtUnissuetoexchangeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse:
        """
        Description: 取消在交易所发布艺术品
        Summary: 取消在交易所发布艺术品
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SetDigitalassetartArtUnissuetoexchangeResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.unissuetoexchange.set', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_digitalassetart_art(
        self,
        request: blockchain_models.QueryDigitalassetartArtRequest,
    ) -> blockchain_models.QueryDigitalassetartArtResponse:
        """
        Description: 查询艺术品信息
        Summary: 查询艺术品信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_digitalassetart_art_ex(request, headers, runtime)

    async def query_digitalassetart_art_async(
        self,
        request: blockchain_models.QueryDigitalassetartArtRequest,
    ) -> blockchain_models.QueryDigitalassetartArtResponse:
        """
        Description: 查询艺术品信息
        Summary: 查询艺术品信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_digitalassetart_art_ex_async(request, headers, runtime)

    def query_digitalassetart_art_ex(
        self,
        request: blockchain_models.QueryDigitalassetartArtRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetartArtResponse:
        """
        Description: 查询艺术品信息
        Summary: 查询艺术品信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetartArtResponse(),
            self.do_request('1.0', 'baas.digitalassetart.art.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_digitalassetart_art_ex_async(
        self,
        request: blockchain_models.QueryDigitalassetartArtRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetartArtResponse:
        """
        Description: 查询艺术品信息
        Summary: 查询艺术品信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetartArtResponse(),
            await self.do_request_async('1.0', 'baas.digitalassetart.art.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_digitalasset_exchange_accountmap(
        self,
        request: blockchain_models.CreateDigitalassetExchangeAccountmapRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台业务方账户映射接口
        Summary: 数字资产管理平台业务方账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_digitalasset_exchange_accountmap_ex(request, headers, runtime)

    async def create_digitalasset_exchange_accountmap_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeAccountmapRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台业务方账户映射接口
        Summary: 数字资产管理平台业务方账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_digitalasset_exchange_accountmap_ex_async(request, headers, runtime)

    def create_digitalasset_exchange_accountmap_ex(
        self,
        request: blockchain_models.CreateDigitalassetExchangeAccountmapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台业务方账户映射接口
        Summary: 数字资产管理平台业务方账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeAccountmapResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.accountmap.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_digitalasset_exchange_accountmap_ex_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeAccountmapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台业务方账户映射接口
        Summary: 数字资产管理平台业务方账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeAccountmapResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.accountmap.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_digitalasset_exchange_accountmap(
        self,
        request: blockchain_models.BatchcreateDigitalassetExchangeAccountmapRequest,
    ) -> blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台用户账户批量映射接口
        Summary: 数字资产管理平台用户账户批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_digitalasset_exchange_accountmap_ex(request, headers, runtime)

    async def batchcreate_digitalasset_exchange_accountmap_async(
        self,
        request: blockchain_models.BatchcreateDigitalassetExchangeAccountmapRequest,
    ) -> blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台用户账户批量映射接口
        Summary: 数字资产管理平台用户账户批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_digitalasset_exchange_accountmap_ex_async(request, headers, runtime)

    def batchcreate_digitalasset_exchange_accountmap_ex(
        self,
        request: blockchain_models.BatchcreateDigitalassetExchangeAccountmapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台用户账户批量映射接口
        Summary: 数字资产管理平台用户账户批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.accountmap.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_digitalasset_exchange_accountmap_ex_async(
        self,
        request: blockchain_models.BatchcreateDigitalassetExchangeAccountmapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse:
        """
        Description: 数字资产管理平台用户账户批量映射接口
        Summary: 数字资产管理平台用户账户批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateDigitalassetExchangeAccountmapResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.accountmap.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_digitalasset_exchange_unfreeze(
        self,
        request: blockchain_models.StartDigitalassetExchangeUnfreezeRequest,
    ) -> blockchain_models.StartDigitalassetExchangeUnfreezeResponse:
        """
        Description: 数字资产管理平台版通解限接口
        Summary: 数字资产管理平台版通解限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_digitalasset_exchange_unfreeze_ex(request, headers, runtime)

    async def start_digitalasset_exchange_unfreeze_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeUnfreezeRequest,
    ) -> blockchain_models.StartDigitalassetExchangeUnfreezeResponse:
        """
        Description: 数字资产管理平台版通解限接口
        Summary: 数字资产管理平台版通解限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_digitalasset_exchange_unfreeze_ex_async(request, headers, runtime)

    def start_digitalasset_exchange_unfreeze_ex(
        self,
        request: blockchain_models.StartDigitalassetExchangeUnfreezeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeUnfreezeResponse:
        """
        Description: 数字资产管理平台版通解限接口
        Summary: 数字资产管理平台版通解限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeUnfreezeResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.unfreeze.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_digitalasset_exchange_unfreeze_ex_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeUnfreezeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeUnfreezeResponse:
        """
        Description: 数字资产管理平台版通解限接口
        Summary: 数字资产管理平台版通解限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeUnfreezeResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.unfreeze.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_digitalasset_exchange_lockposition(
        self,
        request: blockchain_models.StartDigitalassetExchangeLockpositionRequest,
    ) -> blockchain_models.StartDigitalassetExchangeLockpositionResponse:
        """
        Description: 数字资产管理平台资源管理 处理用户、版通的锁定与解锁
        1. ep_code有值，user_account为空时，对指定版通进行锁定解锁操作
        2. ep_code为空，user_account有值时，对指定账户进行锁定解锁操作
        3. ep_code，user_account均有值时，对指定账户的版通进行锁定解锁操作
        4. ep_code，user_account均为空时，对全交易所进行锁定解锁操作，需谨慎
        Summary: 数字资产管理平台资源管理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_digitalasset_exchange_lockposition_ex(request, headers, runtime)

    async def start_digitalasset_exchange_lockposition_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeLockpositionRequest,
    ) -> blockchain_models.StartDigitalassetExchangeLockpositionResponse:
        """
        Description: 数字资产管理平台资源管理 处理用户、版通的锁定与解锁
        1. ep_code有值，user_account为空时，对指定版通进行锁定解锁操作
        2. ep_code为空，user_account有值时，对指定账户进行锁定解锁操作
        3. ep_code，user_account均有值时，对指定账户的版通进行锁定解锁操作
        4. ep_code，user_account均为空时，对全交易所进行锁定解锁操作，需谨慎
        Summary: 数字资产管理平台资源管理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_digitalasset_exchange_lockposition_ex_async(request, headers, runtime)

    def start_digitalasset_exchange_lockposition_ex(
        self,
        request: blockchain_models.StartDigitalassetExchangeLockpositionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeLockpositionResponse:
        """
        Description: 数字资产管理平台资源管理 处理用户、版通的锁定与解锁
        1. ep_code有值，user_account为空时，对指定版通进行锁定解锁操作
        2. ep_code为空，user_account有值时，对指定账户进行锁定解锁操作
        3. ep_code，user_account均有值时，对指定账户的版通进行锁定解锁操作
        4. ep_code，user_account均为空时，对全交易所进行锁定解锁操作，需谨慎
        Summary: 数字资产管理平台资源管理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeLockpositionResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.lockposition.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_digitalasset_exchange_lockposition_ex_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeLockpositionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeLockpositionResponse:
        """
        Description: 数字资产管理平台资源管理 处理用户、版通的锁定与解锁
        1. ep_code有值，user_account为空时，对指定版通进行锁定解锁操作
        2. ep_code为空，user_account有值时，对指定账户进行锁定解锁操作
        3. ep_code，user_account均有值时，对指定账户的版通进行锁定解锁操作
        4. ep_code，user_account均为空时，对全交易所进行锁定解锁操作，需谨慎
        Summary: 数字资产管理平台资源管理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeLockpositionResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.lockposition.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_digitalasset_exchange_epissue(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpissueRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeEpissueResponse:
        """
        Description: 数字资产管理平台版通发行接口
        Summary: 数字资产管理平台版通发行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_digitalasset_exchange_epissue_ex(request, headers, runtime)

    async def create_digitalasset_exchange_epissue_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpissueRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeEpissueResponse:
        """
        Description: 数字资产管理平台版通发行接口
        Summary: 数字资产管理平台版通发行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_digitalasset_exchange_epissue_ex_async(request, headers, runtime)

    def create_digitalasset_exchange_epissue_ex(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpissueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeEpissueResponse:
        """
        Description: 数字资产管理平台版通发行接口
        Summary: 数字资产管理平台版通发行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeEpissueResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epissue.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_digitalasset_exchange_epissue_ex_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpissueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeEpissueResponse:
        """
        Description: 数字资产管理平台版通发行接口
        Summary: 数字资产管理平台版通发行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeEpissueResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epissue.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_digitalasset_exchange_epstockissue(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpstockissueRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeEpstockissueResponse:
        """
        Description: 数字资产管理平台版通存量发行接口
        Summary: 数字资产管理平台版通存量发行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_digitalasset_exchange_epstockissue_ex(request, headers, runtime)

    async def create_digitalasset_exchange_epstockissue_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpstockissueRequest,
    ) -> blockchain_models.CreateDigitalassetExchangeEpstockissueResponse:
        """
        Description: 数字资产管理平台版通存量发行接口
        Summary: 数字资产管理平台版通存量发行
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_digitalasset_exchange_epstockissue_ex_async(request, headers, runtime)

    def create_digitalasset_exchange_epstockissue_ex(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpstockissueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeEpstockissueResponse:
        """
        Description: 数字资产管理平台版通存量发行接口
        Summary: 数字资产管理平台版通存量发行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeEpstockissueResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epstockissue.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_digitalasset_exchange_epstockissue_ex_async(
        self,
        request: blockchain_models.CreateDigitalassetExchangeEpstockissueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDigitalassetExchangeEpstockissueResponse:
        """
        Description: 数字资产管理平台版通存量发行接口
        Summary: 数字资产管理平台版通存量发行
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDigitalassetExchangeEpstockissueResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epstockissue.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_digitalasset_exchange_epwholesale(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpwholesaleRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEpwholesaleResponse:
        """
        Description: 数字资产管理平台版通批发接口
        Summary: 数字资产管理平台版通批发
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_digitalasset_exchange_epwholesale_ex(request, headers, runtime)

    async def start_digitalasset_exchange_epwholesale_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpwholesaleRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEpwholesaleResponse:
        """
        Description: 数字资产管理平台版通批发接口
        Summary: 数字资产管理平台版通批发
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_digitalasset_exchange_epwholesale_ex_async(request, headers, runtime)

    def start_digitalasset_exchange_epwholesale_ex(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpwholesaleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEpwholesaleResponse:
        """
        Description: 数字资产管理平台版通批发接口
        Summary: 数字资产管理平台版通批发
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEpwholesaleResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epwholesale.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_digitalasset_exchange_epwholesale_ex_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpwholesaleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEpwholesaleResponse:
        """
        Description: 数字资产管理平台版通批发接口
        Summary: 数字资产管理平台版通批发
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEpwholesaleResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epwholesale.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_digitalasset_exchange_epinfo(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpinfoRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEpinfoResponse:
        """
        Description: 数字资产管理平台版通信息查询接口
        Summary: 数字资产管理平台版通信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_digitalasset_exchange_epinfo_ex(request, headers, runtime)

    async def query_digitalasset_exchange_epinfo_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpinfoRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEpinfoResponse:
        """
        Description: 数字资产管理平台版通信息查询接口
        Summary: 数字资产管理平台版通信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_digitalasset_exchange_epinfo_ex_async(request, headers, runtime)

    def query_digitalasset_exchange_epinfo_ex(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEpinfoResponse:
        """
        Description: 数字资产管理平台版通信息查询接口
        Summary: 数字资产管理平台版通信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEpinfoResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epinfo.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_digitalasset_exchange_epinfo_ex_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEpinfoResponse:
        """
        Description: 数字资产管理平台版通信息查询接口
        Summary: 数字资产管理平台版通信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEpinfoResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epinfo.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_digitalasset_exchange_eptrade(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEptradeRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易查询接口
        1. ep_code有值，user_account为空时，查询版通的交易信息
        2. ep_code为空，user_account有值时，查询账户的交易信息
        3. ep_code，user_account均有值时，查询账户下指定版通的交易信息
        Summary: 数字资产管理平台交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_digitalasset_exchange_eptrade_ex(request, headers, runtime)

    async def query_digitalasset_exchange_eptrade_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEptradeRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易查询接口
        1. ep_code有值，user_account为空时，查询版通的交易信息
        2. ep_code为空，user_account有值时，查询账户的交易信息
        3. ep_code，user_account均有值时，查询账户下指定版通的交易信息
        Summary: 数字资产管理平台交易查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_digitalasset_exchange_eptrade_ex_async(request, headers, runtime)

    def query_digitalasset_exchange_eptrade_ex(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEptradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易查询接口
        1. ep_code有值，user_account为空时，查询版通的交易信息
        2. ep_code为空，user_account有值时，查询账户的交易信息
        3. ep_code，user_account均有值时，查询账户下指定版通的交易信息
        Summary: 数字资产管理平台交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEptradeResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.eptrade.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_digitalasset_exchange_eptrade_ex_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEptradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易查询接口
        1. ep_code有值，user_account为空时，查询版通的交易信息
        2. ep_code为空，user_account有值时，查询账户的交易信息
        3. ep_code，user_account均有值时，查询账户下指定版通的交易信息
        Summary: 数字资产管理平台交易查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEptradeResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.eptrade.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_digitalasset_exchange_epaccount(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpaccountRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEpaccountResponse:
        """
        Description: 数字资产管理平台账户信息查询接口
        Summary: 数字资产管理平台账户信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_digitalasset_exchange_epaccount_ex(request, headers, runtime)

    async def query_digitalasset_exchange_epaccount_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpaccountRequest,
    ) -> blockchain_models.QueryDigitalassetExchangeEpaccountResponse:
        """
        Description: 数字资产管理平台账户信息查询接口
        Summary: 数字资产管理平台账户信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_digitalasset_exchange_epaccount_ex_async(request, headers, runtime)

    def query_digitalasset_exchange_epaccount_ex(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpaccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEpaccountResponse:
        """
        Description: 数字资产管理平台账户信息查询接口
        Summary: 数字资产管理平台账户信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEpaccountResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epaccount.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_digitalasset_exchange_epaccount_ex_async(
        self,
        request: blockchain_models.QueryDigitalassetExchangeEpaccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDigitalassetExchangeEpaccountResponse:
        """
        Description: 数字资产管理平台账户信息查询接口
        Summary: 数字资产管理平台账户信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDigitalassetExchangeEpaccountResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epaccount.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_digitalasset_exchange_eptrade(
        self,
        request: blockchain_models.StartDigitalassetExchangeEptradeRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易接口
        Summary: 数字资产管理平台交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_digitalasset_exchange_eptrade_ex(request, headers, runtime)

    async def start_digitalasset_exchange_eptrade_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEptradeRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易接口
        Summary: 数字资产管理平台交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_digitalasset_exchange_eptrade_ex_async(request, headers, runtime)

    def start_digitalasset_exchange_eptrade_ex(
        self,
        request: blockchain_models.StartDigitalassetExchangeEptradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易接口
        Summary: 数字资产管理平台交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEptradeResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.eptrade.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_digitalasset_exchange_eptrade_ex_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEptradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEptradeResponse:
        """
        Description: 数字资产管理平台交易接口
        Summary: 数字资产管理平台交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEptradeResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.eptrade.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_digitalasset_exchange_epbuyback(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpbuybackRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEpbuybackResponse:
        """
        Description: 数字资产管理平台版通回购接口
        Summary: 数字资产管理平台版通回购
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_digitalasset_exchange_epbuyback_ex(request, headers, runtime)

    async def start_digitalasset_exchange_epbuyback_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpbuybackRequest,
    ) -> blockchain_models.StartDigitalassetExchangeEpbuybackResponse:
        """
        Description: 数字资产管理平台版通回购接口
        Summary: 数字资产管理平台版通回购
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_digitalasset_exchange_epbuyback_ex_async(request, headers, runtime)

    def start_digitalasset_exchange_epbuyback_ex(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpbuybackRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEpbuybackResponse:
        """
        Description: 数字资产管理平台版通回购接口
        Summary: 数字资产管理平台版通回购
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEpbuybackResponse(),
            self.do_request('1.0', 'baas.digitalasset.exchange.epbuyback.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_digitalasset_exchange_epbuyback_ex_async(
        self,
        request: blockchain_models.StartDigitalassetExchangeEpbuybackRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDigitalassetExchangeEpbuybackResponse:
        """
        Description: 数字资产管理平台版通回购接口
        Summary: 数字资产管理平台版通回购
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDigitalassetExchangeEpbuybackResponse(),
            await self.do_request_async('1.0', 'baas.digitalasset.exchange.epbuyback.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_user(
        self,
        request: blockchain_models.CreateDistributionUserRequest,
    ) -> blockchain_models.CreateDistributionUserResponse:
        """
        Description: 创建用户接口
        Summary: 创建用户接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_user_ex(request, headers, runtime)

    async def create_distribution_user_async(
        self,
        request: blockchain_models.CreateDistributionUserRequest,
    ) -> blockchain_models.CreateDistributionUserResponse:
        """
        Description: 创建用户接口
        Summary: 创建用户接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_user_ex_async(request, headers, runtime)

    def create_distribution_user_ex(
        self,
        request: blockchain_models.CreateDistributionUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionUserResponse:
        """
        Description: 创建用户接口
        Summary: 创建用户接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionUserResponse(),
            self.do_request('1.0', 'baas.distribution.user.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_user_ex_async(
        self,
        request: blockchain_models.CreateDistributionUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionUserResponse:
        """
        Description: 创建用户接口
        Summary: 创建用户接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionUserResponse(),
            await self.do_request_async('1.0', 'baas.distribution.user.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_user_team(
        self,
        request: blockchain_models.QueryDistributionUserTeamRequest,
    ) -> blockchain_models.QueryDistributionUserTeamResponse:
        """
        Description: 用户下级分销关系查询
        Summary: 用户下级分销关系查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_user_team_ex(request, headers, runtime)

    async def query_distribution_user_team_async(
        self,
        request: blockchain_models.QueryDistributionUserTeamRequest,
    ) -> blockchain_models.QueryDistributionUserTeamResponse:
        """
        Description: 用户下级分销关系查询
        Summary: 用户下级分销关系查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_user_team_ex_async(request, headers, runtime)

    def query_distribution_user_team_ex(
        self,
        request: blockchain_models.QueryDistributionUserTeamRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionUserTeamResponse:
        """
        Description: 用户下级分销关系查询
        Summary: 用户下级分销关系查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionUserTeamResponse(),
            self.do_request('1.0', 'baas.distribution.user.team.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_user_team_ex_async(
        self,
        request: blockchain_models.QueryDistributionUserTeamRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionUserTeamResponse:
        """
        Description: 用户下级分销关系查询
        Summary: 用户下级分销关系查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionUserTeamResponse(),
            await self.do_request_async('1.0', 'baas.distribution.user.team.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_shop(
        self,
        request: blockchain_models.CreateDistributionShopRequest,
    ) -> blockchain_models.CreateDistributionShopResponse:
        """
        Description: 创建商户接口
        Summary: 创建商户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_shop_ex(request, headers, runtime)

    async def create_distribution_shop_async(
        self,
        request: blockchain_models.CreateDistributionShopRequest,
    ) -> blockchain_models.CreateDistributionShopResponse:
        """
        Description: 创建商户接口
        Summary: 创建商户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_shop_ex_async(request, headers, runtime)

    def create_distribution_shop_ex(
        self,
        request: blockchain_models.CreateDistributionShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionShopResponse:
        """
        Description: 创建商户接口
        Summary: 创建商户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionShopResponse(),
            self.do_request('1.0', 'baas.distribution.shop.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_shop_ex_async(
        self,
        request: blockchain_models.CreateDistributionShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionShopResponse:
        """
        Description: 创建商户接口
        Summary: 创建商户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionShopResponse(),
            await self.do_request_async('1.0', 'baas.distribution.shop.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_user_relation(
        self,
        request: blockchain_models.CreateDistributionUserRelationRequest,
    ) -> blockchain_models.CreateDistributionUserRelationResponse:
        """
        Description: 用户之间分销关系建立
        Summary: 用户之间分销关系建立
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_user_relation_ex(request, headers, runtime)

    async def create_distribution_user_relation_async(
        self,
        request: blockchain_models.CreateDistributionUserRelationRequest,
    ) -> blockchain_models.CreateDistributionUserRelationResponse:
        """
        Description: 用户之间分销关系建立
        Summary: 用户之间分销关系建立
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_user_relation_ex_async(request, headers, runtime)

    def create_distribution_user_relation_ex(
        self,
        request: blockchain_models.CreateDistributionUserRelationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionUserRelationResponse:
        """
        Description: 用户之间分销关系建立
        Summary: 用户之间分销关系建立
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionUserRelationResponse(),
            self.do_request('1.0', 'baas.distribution.user.relation.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_user_relation_ex_async(
        self,
        request: blockchain_models.CreateDistributionUserRelationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionUserRelationResponse:
        """
        Description: 用户之间分销关系建立
        Summary: 用户之间分销关系建立
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionUserRelationResponse(),
            await self.do_request_async('1.0', 'baas.distribution.user.relation.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def init_distribution_contract(
        self,
        request: blockchain_models.InitDistributionContractRequest,
    ) -> blockchain_models.InitDistributionContractResponse:
        """
        Description: 营销分销合约初始化
        Summary: 营销分销合约初始化
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.init_distribution_contract_ex(request, headers, runtime)

    async def init_distribution_contract_async(
        self,
        request: blockchain_models.InitDistributionContractRequest,
    ) -> blockchain_models.InitDistributionContractResponse:
        """
        Description: 营销分销合约初始化
        Summary: 营销分销合约初始化
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.init_distribution_contract_ex_async(request, headers, runtime)

    def init_distribution_contract_ex(
        self,
        request: blockchain_models.InitDistributionContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDistributionContractResponse:
        """
        Description: 营销分销合约初始化
        Summary: 营销分销合约初始化
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDistributionContractResponse(),
            self.do_request('1.0', 'baas.distribution.contract.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def init_distribution_contract_ex_async(
        self,
        request: blockchain_models.InitDistributionContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDistributionContractResponse:
        """
        Description: 营销分销合约初始化
        Summary: 营销分销合约初始化
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDistributionContractResponse(),
            await self.do_request_async('1.0', 'baas.distribution.contract.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_product_item(
        self,
        request: blockchain_models.CreateDistributionProductItemRequest,
    ) -> blockchain_models.CreateDistributionProductItemResponse:
        """
        Description: 营销分销平台商品创建
        Summary: 营销分销平台商品创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_product_item_ex(request, headers, runtime)

    async def create_distribution_product_item_async(
        self,
        request: blockchain_models.CreateDistributionProductItemRequest,
    ) -> blockchain_models.CreateDistributionProductItemResponse:
        """
        Description: 营销分销平台商品创建
        Summary: 营销分销平台商品创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_product_item_ex_async(request, headers, runtime)

    def create_distribution_product_item_ex(
        self,
        request: blockchain_models.CreateDistributionProductItemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionProductItemResponse:
        """
        Description: 营销分销平台商品创建
        Summary: 营销分销平台商品创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionProductItemResponse(),
            self.do_request('1.0', 'baas.distribution.product.item.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_product_item_ex_async(
        self,
        request: blockchain_models.CreateDistributionProductItemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionProductItemResponse:
        """
        Description: 营销分销平台商品创建
        Summary: 营销分销平台商品创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionProductItemResponse(),
            await self.do_request_async('1.0', 'baas.distribution.product.item.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_product_item(
        self,
        request: blockchain_models.QueryDistributionProductItemRequest,
    ) -> blockchain_models.QueryDistributionProductItemResponse:
        """
        Description: 营销分销平台商品查询
        Summary: 营销分销平台商品查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_product_item_ex(request, headers, runtime)

    async def query_distribution_product_item_async(
        self,
        request: blockchain_models.QueryDistributionProductItemRequest,
    ) -> blockchain_models.QueryDistributionProductItemResponse:
        """
        Description: 营销分销平台商品查询
        Summary: 营销分销平台商品查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_product_item_ex_async(request, headers, runtime)

    def query_distribution_product_item_ex(
        self,
        request: blockchain_models.QueryDistributionProductItemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionProductItemResponse:
        """
        Description: 营销分销平台商品查询
        Summary: 营销分销平台商品查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionProductItemResponse(),
            self.do_request('1.0', 'baas.distribution.product.item.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_product_item_ex_async(
        self,
        request: blockchain_models.QueryDistributionProductItemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionProductItemResponse:
        """
        Description: 营销分销平台商品查询
        Summary: 营销分销平台商品查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionProductItemResponse(),
            await self.do_request_async('1.0', 'baas.distribution.product.item.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_distribution_fund_promoter(
        self,
        request: blockchain_models.UpdateDistributionFundPromoterRequest,
    ) -> blockchain_models.UpdateDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人钱包更新
        Summary: 营销分销平台推广人钱包更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_distribution_fund_promoter_ex(request, headers, runtime)

    async def update_distribution_fund_promoter_async(
        self,
        request: blockchain_models.UpdateDistributionFundPromoterRequest,
    ) -> blockchain_models.UpdateDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人钱包更新
        Summary: 营销分销平台推广人钱包更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_distribution_fund_promoter_ex_async(request, headers, runtime)

    def update_distribution_fund_promoter_ex(
        self,
        request: blockchain_models.UpdateDistributionFundPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人钱包更新
        Summary: 营销分销平台推广人钱包更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDistributionFundPromoterResponse(),
            self.do_request('1.0', 'baas.distribution.fund.promoter.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_distribution_fund_promoter_ex_async(
        self,
        request: blockchain_models.UpdateDistributionFundPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人钱包更新
        Summary: 营销分销平台推广人钱包更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDistributionFundPromoterResponse(),
            await self.do_request_async('1.0', 'baas.distribution.fund.promoter.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_distribution_fund_shop(
        self,
        request: blockchain_models.UpdateDistributionFundShopRequest,
    ) -> blockchain_models.UpdateDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户更新
        Summary: 营销分销平台商户账户更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_distribution_fund_shop_ex(request, headers, runtime)

    async def update_distribution_fund_shop_async(
        self,
        request: blockchain_models.UpdateDistributionFundShopRequest,
    ) -> blockchain_models.UpdateDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户更新
        Summary: 营销分销平台商户账户更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_distribution_fund_shop_ex_async(request, headers, runtime)

    def update_distribution_fund_shop_ex(
        self,
        request: blockchain_models.UpdateDistributionFundShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户更新
        Summary: 营销分销平台商户账户更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDistributionFundShopResponse(),
            self.do_request('1.0', 'baas.distribution.fund.shop.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_distribution_fund_shop_ex_async(
        self,
        request: blockchain_models.UpdateDistributionFundShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户更新
        Summary: 营销分销平台商户账户更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDistributionFundShopResponse(),
            await self.do_request_async('1.0', 'baas.distribution.fund.shop.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_fund_promoter(
        self,
        request: blockchain_models.QueryDistributionFundPromoterRequest,
    ) -> blockchain_models.QueryDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人账户查询
        Summary: 营销分销平台推广人账户查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_fund_promoter_ex(request, headers, runtime)

    async def query_distribution_fund_promoter_async(
        self,
        request: blockchain_models.QueryDistributionFundPromoterRequest,
    ) -> blockchain_models.QueryDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人账户查询
        Summary: 营销分销平台推广人账户查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_fund_promoter_ex_async(request, headers, runtime)

    def query_distribution_fund_promoter_ex(
        self,
        request: blockchain_models.QueryDistributionFundPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人账户查询
        Summary: 营销分销平台推广人账户查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundPromoterResponse(),
            self.do_request('1.0', 'baas.distribution.fund.promoter.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_fund_promoter_ex_async(
        self,
        request: blockchain_models.QueryDistributionFundPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundPromoterResponse:
        """
        Description: 营销分销平台推广人账户查询
        Summary: 营销分销平台推广人账户查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundPromoterResponse(),
            await self.do_request_async('1.0', 'baas.distribution.fund.promoter.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_fund_shop(
        self,
        request: blockchain_models.QueryDistributionFundShopRequest,
    ) -> blockchain_models.QueryDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户查询
        Summary: 营销分销平台商户账户查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_fund_shop_ex(request, headers, runtime)

    async def query_distribution_fund_shop_async(
        self,
        request: blockchain_models.QueryDistributionFundShopRequest,
    ) -> blockchain_models.QueryDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户查询
        Summary: 营销分销平台商户账户查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_fund_shop_ex_async(request, headers, runtime)

    def query_distribution_fund_shop_ex(
        self,
        request: blockchain_models.QueryDistributionFundShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户查询
        Summary: 营销分销平台商户账户查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundShopResponse(),
            self.do_request('1.0', 'baas.distribution.fund.shop.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_fund_shop_ex_async(
        self,
        request: blockchain_models.QueryDistributionFundShopRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundShopResponse:
        """
        Description: 营销分销平台商户账户查询
        Summary: 营销分销平台商户账户查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundShopResponse(),
            await self.do_request_async('1.0', 'baas.distribution.fund.shop.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_fund_promoterflow(
        self,
        request: blockchain_models.QueryDistributionFundPromoterflowRequest,
    ) -> blockchain_models.QueryDistributionFundPromoterflowResponse:
        """
        Description: 营销分销平台推广人账户流水查询
        Summary: 营销分销平台推广人账户流水查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_fund_promoterflow_ex(request, headers, runtime)

    async def query_distribution_fund_promoterflow_async(
        self,
        request: blockchain_models.QueryDistributionFundPromoterflowRequest,
    ) -> blockchain_models.QueryDistributionFundPromoterflowResponse:
        """
        Description: 营销分销平台推广人账户流水查询
        Summary: 营销分销平台推广人账户流水查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_fund_promoterflow_ex_async(request, headers, runtime)

    def query_distribution_fund_promoterflow_ex(
        self,
        request: blockchain_models.QueryDistributionFundPromoterflowRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundPromoterflowResponse:
        """
        Description: 营销分销平台推广人账户流水查询
        Summary: 营销分销平台推广人账户流水查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundPromoterflowResponse(),
            self.do_request('1.0', 'baas.distribution.fund.promoterflow.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_fund_promoterflow_ex_async(
        self,
        request: blockchain_models.QueryDistributionFundPromoterflowRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionFundPromoterflowResponse:
        """
        Description: 营销分销平台推广人账户流水查询
        Summary: 营销分销平台推广人账户流水查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionFundPromoterflowResponse(),
            await self.do_request_async('1.0', 'baas.distribution.fund.promoterflow.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_order_promoter(
        self,
        request: blockchain_models.CreateDistributionOrderPromoterRequest,
    ) -> blockchain_models.CreateDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单创建
        Summary: 营销分销平台推广订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_order_promoter_ex(request, headers, runtime)

    async def create_distribution_order_promoter_async(
        self,
        request: blockchain_models.CreateDistributionOrderPromoterRequest,
    ) -> blockchain_models.CreateDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单创建
        Summary: 营销分销平台推广订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_order_promoter_ex_async(request, headers, runtime)

    def create_distribution_order_promoter_ex(
        self,
        request: blockchain_models.CreateDistributionOrderPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单创建
        Summary: 营销分销平台推广订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionOrderPromoterResponse(),
            self.do_request('1.0', 'baas.distribution.order.promoter.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_order_promoter_ex_async(
        self,
        request: blockchain_models.CreateDistributionOrderPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单创建
        Summary: 营销分销平台推广订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionOrderPromoterResponse(),
            await self.do_request_async('1.0', 'baas.distribution.order.promoter.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_distribution_order_trade(
        self,
        request: blockchain_models.CreateDistributionOrderTradeRequest,
    ) -> blockchain_models.CreateDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单创建
        Summary: 营销分销平台购买订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_distribution_order_trade_ex(request, headers, runtime)

    async def create_distribution_order_trade_async(
        self,
        request: blockchain_models.CreateDistributionOrderTradeRequest,
    ) -> blockchain_models.CreateDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单创建
        Summary: 营销分销平台购买订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_distribution_order_trade_ex_async(request, headers, runtime)

    def create_distribution_order_trade_ex(
        self,
        request: blockchain_models.CreateDistributionOrderTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单创建
        Summary: 营销分销平台购买订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionOrderTradeResponse(),
            self.do_request('1.0', 'baas.distribution.order.trade.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_distribution_order_trade_ex_async(
        self,
        request: blockchain_models.CreateDistributionOrderTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单创建
        Summary: 营销分销平台购买订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDistributionOrderTradeResponse(),
            await self.do_request_async('1.0', 'baas.distribution.order.trade.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_order_promoter(
        self,
        request: blockchain_models.QueryDistributionOrderPromoterRequest,
    ) -> blockchain_models.QueryDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单查询
        Summary: 营销分销平台推广订单查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_order_promoter_ex(request, headers, runtime)

    async def query_distribution_order_promoter_async(
        self,
        request: blockchain_models.QueryDistributionOrderPromoterRequest,
    ) -> blockchain_models.QueryDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单查询
        Summary: 营销分销平台推广订单查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_order_promoter_ex_async(request, headers, runtime)

    def query_distribution_order_promoter_ex(
        self,
        request: blockchain_models.QueryDistributionOrderPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单查询
        Summary: 营销分销平台推广订单查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderPromoterResponse(),
            self.do_request('1.0', 'baas.distribution.order.promoter.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_order_promoter_ex_async(
        self,
        request: blockchain_models.QueryDistributionOrderPromoterRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderPromoterResponse:
        """
        Description: 营销分销平台推广订单查询
        Summary: 营销分销平台推广订单查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderPromoterResponse(),
            await self.do_request_async('1.0', 'baas.distribution.order.promoter.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_order_rakeback(
        self,
        request: blockchain_models.QueryDistributionOrderRakebackRequest,
    ) -> blockchain_models.QueryDistributionOrderRakebackResponse:
        """
        Description: 营销分销平台订单返佣信息查询
        Summary: 营销分销平台订单返佣信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_order_rakeback_ex(request, headers, runtime)

    async def query_distribution_order_rakeback_async(
        self,
        request: blockchain_models.QueryDistributionOrderRakebackRequest,
    ) -> blockchain_models.QueryDistributionOrderRakebackResponse:
        """
        Description: 营销分销平台订单返佣信息查询
        Summary: 营销分销平台订单返佣信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_order_rakeback_ex_async(request, headers, runtime)

    def query_distribution_order_rakeback_ex(
        self,
        request: blockchain_models.QueryDistributionOrderRakebackRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderRakebackResponse:
        """
        Description: 营销分销平台订单返佣信息查询
        Summary: 营销分销平台订单返佣信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderRakebackResponse(),
            self.do_request('1.0', 'baas.distribution.order.rakeback.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_order_rakeback_ex_async(
        self,
        request: blockchain_models.QueryDistributionOrderRakebackRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderRakebackResponse:
        """
        Description: 营销分销平台订单返佣信息查询
        Summary: 营销分销平台订单返佣信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderRakebackResponse(),
            await self.do_request_async('1.0', 'baas.distribution.order.rakeback.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_distribution_order_trade(
        self,
        request: blockchain_models.QueryDistributionOrderTradeRequest,
    ) -> blockchain_models.QueryDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单查询
        Summary: 营销分销平台购买订单查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_distribution_order_trade_ex(request, headers, runtime)

    async def query_distribution_order_trade_async(
        self,
        request: blockchain_models.QueryDistributionOrderTradeRequest,
    ) -> blockchain_models.QueryDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单查询
        Summary: 营销分销平台购买订单查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_distribution_order_trade_ex_async(request, headers, runtime)

    def query_distribution_order_trade_ex(
        self,
        request: blockchain_models.QueryDistributionOrderTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单查询
        Summary: 营销分销平台购买订单查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderTradeResponse(),
            self.do_request('1.0', 'baas.distribution.order.trade.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_distribution_order_trade_ex_async(
        self,
        request: blockchain_models.QueryDistributionOrderTradeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDistributionOrderTradeResponse:
        """
        Description: 营销分销平台购买订单查询
        Summary: 营销分销平台购买订单查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDistributionOrderTradeResponse(),
            await self.do_request_async('1.0', 'baas.distribution.order.trade.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_dis(
        self,
        request: blockchain_models.CreateLogisticFinanceDisRequest,
    ) -> blockchain_models.CreateLogisticFinanceDisResponse:
        """
        Description: DIS 分布式数字身份申请
        Summary: DIS 分布式数字身份申请
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_dis_ex(request, headers, runtime)

    async def create_logistic_finance_dis_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDisRequest,
    ) -> blockchain_models.CreateLogisticFinanceDisResponse:
        """
        Description: DIS 分布式数字身份申请
        Summary: DIS 分布式数字身份申请
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_dis_ex_async(request, headers, runtime)

    def create_logistic_finance_dis_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceDisRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDisResponse:
        """
        Description: DIS 分布式数字身份申请
        Summary: DIS 分布式数字身份申请
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDisResponse(),
            self.do_request('1.0', 'baas.logistic.finance.dis.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_dis_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDisRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDisResponse:
        """
        Description: DIS 分布式数字身份申请
        Summary: DIS 分布式数字身份申请
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDisResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.dis.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_logistic_finance_dis(
        self,
        request: blockchain_models.ListLogisticFinanceDisRequest,
    ) -> blockchain_models.ListLogisticFinanceDisResponse:
        """
        Description: 查询 DIS 分布式数字身份列表
        Summary: 查询 DIS 分布式数字身份列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_logistic_finance_dis_ex(request, headers, runtime)

    async def list_logistic_finance_dis_async(
        self,
        request: blockchain_models.ListLogisticFinanceDisRequest,
    ) -> blockchain_models.ListLogisticFinanceDisResponse:
        """
        Description: 查询 DIS 分布式数字身份列表
        Summary: 查询 DIS 分布式数字身份列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_logistic_finance_dis_ex_async(request, headers, runtime)

    def list_logistic_finance_dis_ex(
        self,
        request: blockchain_models.ListLogisticFinanceDisRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListLogisticFinanceDisResponse:
        """
        Description: 查询 DIS 分布式数字身份列表
        Summary: 查询 DIS 分布式数字身份列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListLogisticFinanceDisResponse(),
            self.do_request('1.0', 'baas.logistic.finance.dis.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_logistic_finance_dis_ex_async(
        self,
        request: blockchain_models.ListLogisticFinanceDisRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListLogisticFinanceDisResponse:
        """
        Description: 查询 DIS 分布式数字身份列表
        Summary: 查询 DIS 分布式数字身份列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListLogisticFinanceDisResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.dis.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_disvc(
        self,
        request: blockchain_models.CreateLogisticFinanceDisvcRequest,
    ) -> blockchain_models.CreateLogisticFinanceDisvcResponse:
        """
        Description: 为成员颁发可验证声明用于允许指定成员有访问数据的权限
        Summary: 颁发可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_disvc_ex(request, headers, runtime)

    async def create_logistic_finance_disvc_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDisvcRequest,
    ) -> blockchain_models.CreateLogisticFinanceDisvcResponse:
        """
        Description: 为成员颁发可验证声明用于允许指定成员有访问数据的权限
        Summary: 颁发可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_disvc_ex_async(request, headers, runtime)

    def create_logistic_finance_disvc_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceDisvcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDisvcResponse:
        """
        Description: 为成员颁发可验证声明用于允许指定成员有访问数据的权限
        Summary: 颁发可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDisvcResponse(),
            self.do_request('1.0', 'baas.logistic.finance.disvc.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_disvc_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDisvcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDisvcResponse:
        """
        Description: 为成员颁发可验证声明用于允许指定成员有访问数据的权限
        Summary: 颁发可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDisvcResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.disvc.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_logistic_finance_disvc(
        self,
        request: blockchain_models.QueryLogisticFinanceDisvcRequest,
    ) -> blockchain_models.QueryLogisticFinanceDisvcResponse:
        """
        Description: 查询颁发的可验证声明完整声明内容
        Summary: 查询颁发的可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_logistic_finance_disvc_ex(request, headers, runtime)

    async def query_logistic_finance_disvc_async(
        self,
        request: blockchain_models.QueryLogisticFinanceDisvcRequest,
    ) -> blockchain_models.QueryLogisticFinanceDisvcResponse:
        """
        Description: 查询颁发的可验证声明完整声明内容
        Summary: 查询颁发的可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_logistic_finance_disvc_ex_async(request, headers, runtime)

    def query_logistic_finance_disvc_ex(
        self,
        request: blockchain_models.QueryLogisticFinanceDisvcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryLogisticFinanceDisvcResponse:
        """
        Description: 查询颁发的可验证声明完整声明内容
        Summary: 查询颁发的可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryLogisticFinanceDisvcResponse(),
            self.do_request('1.0', 'baas.logistic.finance.disvc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_logistic_finance_disvc_ex_async(
        self,
        request: blockchain_models.QueryLogisticFinanceDisvcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryLogisticFinanceDisvcResponse:
        """
        Description: 查询颁发的可验证声明完整声明内容
        Summary: 查询颁发的可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryLogisticFinanceDisvcResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.disvc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_account(
        self,
        request: blockchain_models.CreateLogisticFinanceAccountRequest,
    ) -> blockchain_models.CreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台用户账户映射
        Summary: 物流金融平台用户账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_account_ex(request, headers, runtime)

    async def create_logistic_finance_account_async(
        self,
        request: blockchain_models.CreateLogisticFinanceAccountRequest,
    ) -> blockchain_models.CreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台用户账户映射
        Summary: 物流金融平台用户账户映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_account_ex_async(request, headers, runtime)

    def create_logistic_finance_account_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台用户账户映射
        Summary: 物流金融平台用户账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceAccountResponse(),
            self.do_request('1.0', 'baas.logistic.finance.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_account_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台用户账户映射
        Summary: 物流金融平台用户账户映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceAccountResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.account.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_logistic_finance_account(
        self,
        request: blockchain_models.BatchcreateLogisticFinanceAccountRequest,
    ) -> blockchain_models.BatchcreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台账户批量映射
        Summary: 物流金融平台账户批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_logistic_finance_account_ex(request, headers, runtime)

    async def batchcreate_logistic_finance_account_async(
        self,
        request: blockchain_models.BatchcreateLogisticFinanceAccountRequest,
    ) -> blockchain_models.BatchcreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台账户批量映射
        Summary: 物流金融平台账户批量映射
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_logistic_finance_account_ex_async(request, headers, runtime)

    def batchcreate_logistic_finance_account_ex(
        self,
        request: blockchain_models.BatchcreateLogisticFinanceAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台账户批量映射
        Summary: 物流金融平台账户批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateLogisticFinanceAccountResponse(),
            self.do_request('1.0', 'baas.logistic.finance.account.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_logistic_finance_account_ex_async(
        self,
        request: blockchain_models.BatchcreateLogisticFinanceAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateLogisticFinanceAccountResponse:
        """
        Description: 物流金融平台账户批量映射
        Summary: 物流金融平台账户批量映射
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateLogisticFinanceAccountResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.account.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_order(
        self,
        request: blockchain_models.CreateLogisticFinanceOrderRequest,
    ) -> blockchain_models.CreateLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台物流运单创建
        Summary: 物流金融平台物流运单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_order_ex(request, headers, runtime)

    async def create_logistic_finance_order_async(
        self,
        request: blockchain_models.CreateLogisticFinanceOrderRequest,
    ) -> blockchain_models.CreateLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台物流运单创建
        Summary: 物流金融平台物流运单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_order_ex_async(request, headers, runtime)

    def create_logistic_finance_order_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台物流运单创建
        Summary: 物流金融平台物流运单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceOrderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.order.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_order_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台物流运单创建
        Summary: 物流金融平台物流运单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceOrderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.order.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def finish_logistic_finance_order(
        self,
        request: blockchain_models.FinishLogisticFinanceOrderRequest,
    ) -> blockchain_models.FinishLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台运单完成
        Summary: 物流金融平台运单完成
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.finish_logistic_finance_order_ex(request, headers, runtime)

    async def finish_logistic_finance_order_async(
        self,
        request: blockchain_models.FinishLogisticFinanceOrderRequest,
    ) -> blockchain_models.FinishLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台运单完成
        Summary: 物流金融平台运单完成
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.finish_logistic_finance_order_ex_async(request, headers, runtime)

    def finish_logistic_finance_order_ex(
        self,
        request: blockchain_models.FinishLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FinishLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台运单完成
        Summary: 物流金融平台运单完成
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FinishLogisticFinanceOrderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.order.finish', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def finish_logistic_finance_order_ex_async(
        self,
        request: blockchain_models.FinishLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FinishLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台运单完成
        Summary: 物流金融平台运单完成
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FinishLogisticFinanceOrderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.order.finish', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_payorder(
        self,
        request: blockchain_models.CreateLogisticFinancePayorderRequest,
    ) -> blockchain_models.CreateLogisticFinancePayorderResponse:
        """
        Description: 物流金融平台支付订单创建
        Summary: 物流金融平台支付订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_payorder_ex(request, headers, runtime)

    async def create_logistic_finance_payorder_async(
        self,
        request: blockchain_models.CreateLogisticFinancePayorderRequest,
    ) -> blockchain_models.CreateLogisticFinancePayorderResponse:
        """
        Description: 物流金融平台支付订单创建
        Summary: 物流金融平台支付订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_payorder_ex_async(request, headers, runtime)

    def create_logistic_finance_payorder_ex(
        self,
        request: blockchain_models.CreateLogisticFinancePayorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinancePayorderResponse:
        """
        Description: 物流金融平台支付订单创建
        Summary: 物流金融平台支付订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinancePayorderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.payorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_payorder_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinancePayorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinancePayorderResponse:
        """
        Description: 物流金融平台支付订单创建
        Summary: 物流金融平台支付订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinancePayorderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.payorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_logistic_finance_order(
        self,
        request: blockchain_models.QueryLogisticFinanceOrderRequest,
    ) -> blockchain_models.QueryLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台订单状态查询
        Summary: 物流金融平台订单状态查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_logistic_finance_order_ex(request, headers, runtime)

    async def query_logistic_finance_order_async(
        self,
        request: blockchain_models.QueryLogisticFinanceOrderRequest,
    ) -> blockchain_models.QueryLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台订单状态查询
        Summary: 物流金融平台订单状态查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_logistic_finance_order_ex_async(request, headers, runtime)

    def query_logistic_finance_order_ex(
        self,
        request: blockchain_models.QueryLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台订单状态查询
        Summary: 物流金融平台订单状态查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryLogisticFinanceOrderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.order.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_logistic_finance_order_ex_async(
        self,
        request: blockchain_models.QueryLogisticFinanceOrderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryLogisticFinanceOrderResponse:
        """
        Description: 物流金融平台订单状态查询
        Summary: 物流金融平台订单状态查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryLogisticFinanceOrderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.order.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_billorder(
        self,
        request: blockchain_models.CreateLogisticFinanceBillorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceBillorderResponse:
        """
        Description: 物流金融平台发票订单创建
        Summary: 物流金融平台发票订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_billorder_ex(request, headers, runtime)

    async def create_logistic_finance_billorder_async(
        self,
        request: blockchain_models.CreateLogisticFinanceBillorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceBillorderResponse:
        """
        Description: 物流金融平台发票订单创建
        Summary: 物流金融平台发票订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_billorder_ex_async(request, headers, runtime)

    def create_logistic_finance_billorder_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceBillorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceBillorderResponse:
        """
        Description: 物流金融平台发票订单创建
        Summary: 物流金融平台发票订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceBillorderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.billorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_billorder_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceBillorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceBillorderResponse:
        """
        Description: 物流金融平台发票订单创建
        Summary: 物流金融平台发票订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceBillorderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.billorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def import_logistic_finance_location(
        self,
        request: blockchain_models.ImportLogisticFinanceLocationRequest,
    ) -> blockchain_models.ImportLogisticFinanceLocationResponse:
        """
        Description: 物流金融平台运单轨迹信息导入
        Summary: 物流金融平台运单轨迹信息导入
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.import_logistic_finance_location_ex(request, headers, runtime)

    async def import_logistic_finance_location_async(
        self,
        request: blockchain_models.ImportLogisticFinanceLocationRequest,
    ) -> blockchain_models.ImportLogisticFinanceLocationResponse:
        """
        Description: 物流金融平台运单轨迹信息导入
        Summary: 物流金融平台运单轨迹信息导入
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.import_logistic_finance_location_ex_async(request, headers, runtime)

    def import_logistic_finance_location_ex(
        self,
        request: blockchain_models.ImportLogisticFinanceLocationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ImportLogisticFinanceLocationResponse:
        """
        Description: 物流金融平台运单轨迹信息导入
        Summary: 物流金融平台运单轨迹信息导入
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ImportLogisticFinanceLocationResponse(),
            self.do_request('1.0', 'baas.logistic.finance.location.import', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def import_logistic_finance_location_ex_async(
        self,
        request: blockchain_models.ImportLogisticFinanceLocationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ImportLogisticFinanceLocationResponse:
        """
        Description: 物流金融平台运单轨迹信息导入
        Summary: 物流金融平台运单轨迹信息导入
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ImportLogisticFinanceLocationResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.location.import', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_consignor(
        self,
        request: blockchain_models.CreateLogisticFinanceConsignorRequest,
    ) -> blockchain_models.CreateLogisticFinanceConsignorResponse:
        """
        Description: 物流金融平台创建货主DIS
        Summary: 物流金融平台创建货主DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_consignor_ex(request, headers, runtime)

    async def create_logistic_finance_consignor_async(
        self,
        request: blockchain_models.CreateLogisticFinanceConsignorRequest,
    ) -> blockchain_models.CreateLogisticFinanceConsignorResponse:
        """
        Description: 物流金融平台创建货主DIS
        Summary: 物流金融平台创建货主DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_consignor_ex_async(request, headers, runtime)

    def create_logistic_finance_consignor_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceConsignorRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceConsignorResponse:
        """
        Description: 物流金融平台创建货主DIS
        Summary: 物流金融平台创建货主DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceConsignorResponse(),
            self.do_request('1.0', 'baas.logistic.finance.consignor.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_consignor_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceConsignorRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceConsignorResponse:
        """
        Description: 物流金融平台创建货主DIS
        Summary: 物流金融平台创建货主DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceConsignorResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.consignor.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_platform(
        self,
        request: blockchain_models.CreateLogisticFinancePlatformRequest,
    ) -> blockchain_models.CreateLogisticFinancePlatformResponse:
        """
        Description: 物流金融平台创建无车承运平台DIS
        Summary: 物流金融平台创建无车承运平台DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_platform_ex(request, headers, runtime)

    async def create_logistic_finance_platform_async(
        self,
        request: blockchain_models.CreateLogisticFinancePlatformRequest,
    ) -> blockchain_models.CreateLogisticFinancePlatformResponse:
        """
        Description: 物流金融平台创建无车承运平台DIS
        Summary: 物流金融平台创建无车承运平台DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_platform_ex_async(request, headers, runtime)

    def create_logistic_finance_platform_ex(
        self,
        request: blockchain_models.CreateLogisticFinancePlatformRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinancePlatformResponse:
        """
        Description: 物流金融平台创建无车承运平台DIS
        Summary: 物流金融平台创建无车承运平台DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinancePlatformResponse(),
            self.do_request('1.0', 'baas.logistic.finance.platform.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_platform_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinancePlatformRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinancePlatformResponse:
        """
        Description: 物流金融平台创建无车承运平台DIS
        Summary: 物流金融平台创建无车承运平台DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinancePlatformResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.platform.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logist_finance_agentplatform(
        self,
        request: blockchain_models.CreateLogistFinanceAgentplatformRequest,
    ) -> blockchain_models.CreateLogistFinanceAgentplatformResponse:
        """
        Description: 物流金融平台代理创建无车承运平台DIS
        Summary: 物流金融平台代理创建无车承运平台DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logist_finance_agentplatform_ex(request, headers, runtime)

    async def create_logist_finance_agentplatform_async(
        self,
        request: blockchain_models.CreateLogistFinanceAgentplatformRequest,
    ) -> blockchain_models.CreateLogistFinanceAgentplatformResponse:
        """
        Description: 物流金融平台代理创建无车承运平台DIS
        Summary: 物流金融平台代理创建无车承运平台DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logist_finance_agentplatform_ex_async(request, headers, runtime)

    def create_logist_finance_agentplatform_ex(
        self,
        request: blockchain_models.CreateLogistFinanceAgentplatformRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogistFinanceAgentplatformResponse:
        """
        Description: 物流金融平台代理创建无车承运平台DIS
        Summary: 物流金融平台代理创建无车承运平台DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogistFinanceAgentplatformResponse(),
            self.do_request('1.0', 'baas.logist.finance.agentplatform.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logist_finance_agentplatform_ex_async(
        self,
        request: blockchain_models.CreateLogistFinanceAgentplatformRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogistFinanceAgentplatformResponse:
        """
        Description: 物流金融平台代理创建无车承运平台DIS
        Summary: 物流金融平台代理创建无车承运平台DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogistFinanceAgentplatformResponse(),
            await self.do_request_async('1.0', 'baas.logist.finance.agentplatform.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_driver(
        self,
        request: blockchain_models.CreateLogisticFinanceDriverRequest,
    ) -> blockchain_models.CreateLogisticFinanceDriverResponse:
        """
        Description: 物流金融平台创建司机DIS
        Summary: 物流金融平台创建司机DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_driver_ex(request, headers, runtime)

    async def create_logistic_finance_driver_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDriverRequest,
    ) -> blockchain_models.CreateLogisticFinanceDriverResponse:
        """
        Description: 物流金融平台创建司机DIS
        Summary: 物流金融平台创建司机DIS
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_driver_ex_async(request, headers, runtime)

    def create_logistic_finance_driver_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceDriverRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDriverResponse:
        """
        Description: 物流金融平台创建司机DIS
        Summary: 物流金融平台创建司机DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDriverResponse(),
            self.do_request('1.0', 'baas.logistic.finance.driver.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_driver_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceDriverRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceDriverResponse:
        """
        Description: 物流金融平台创建司机DIS
        Summary: 物流金融平台创建司机DIS
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceDriverResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.driver.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_cargoorder(
        self,
        request: blockchain_models.CreateLogisticFinanceCargoorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceCargoorderResponse:
        """
        Description: 物流金融平台创建货源订单
        Summary: 物流金融平台创建货源订单
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_cargoorder_ex(request, headers, runtime)

    async def create_logistic_finance_cargoorder_async(
        self,
        request: blockchain_models.CreateLogisticFinanceCargoorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceCargoorderResponse:
        """
        Description: 物流金融平台创建货源订单
        Summary: 物流金融平台创建货源订单
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_cargoorder_ex_async(request, headers, runtime)

    def create_logistic_finance_cargoorder_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceCargoorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceCargoorderResponse:
        """
        Description: 物流金融平台创建货源订单
        Summary: 物流金融平台创建货源订单
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceCargoorderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.cargoorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_cargoorder_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceCargoorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceCargoorderResponse:
        """
        Description: 物流金融平台创建货源订单
        Summary: 物流金融平台创建货源订单
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceCargoorderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.cargoorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_logistic_finance_cargopayorder(
        self,
        request: blockchain_models.CreateLogisticFinanceCargopayorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceCargopayorderResponse:
        """
        Description: 物流金融平台货源支付订单创建
        Summary: 物流金融平台货源支付订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_logistic_finance_cargopayorder_ex(request, headers, runtime)

    async def create_logistic_finance_cargopayorder_async(
        self,
        request: blockchain_models.CreateLogisticFinanceCargopayorderRequest,
    ) -> blockchain_models.CreateLogisticFinanceCargopayorderResponse:
        """
        Description: 物流金融平台货源支付订单创建
        Summary: 物流金融平台货源支付订单创建
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_logistic_finance_cargopayorder_ex_async(request, headers, runtime)

    def create_logistic_finance_cargopayorder_ex(
        self,
        request: blockchain_models.CreateLogisticFinanceCargopayorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceCargopayorderResponse:
        """
        Description: 物流金融平台货源支付订单创建
        Summary: 物流金融平台货源支付订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceCargopayorderResponse(),
            self.do_request('1.0', 'baas.logistic.finance.cargopayorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_logistic_finance_cargopayorder_ex_async(
        self,
        request: blockchain_models.CreateLogisticFinanceCargopayorderRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateLogisticFinanceCargopayorderResponse:
        """
        Description: 物流金融平台货源支付订单创建
        Summary: 物流金融平台货源支付订单创建
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateLogisticFinanceCargopayorderResponse(),
            await self.do_request_async('1.0', 'baas.logistic.finance.cargopayorder.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_ocp_product(
        self,
        request: blockchain_models.CreateOcpProductRequest,
    ) -> blockchain_models.CreateOcpProductResponse:
        """
        Description: 创建蚂蚁区块链实例
        Summary: 创建蚂蚁区块链实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_ocp_product_ex(request, headers, runtime)

    async def create_ocp_product_async(
        self,
        request: blockchain_models.CreateOcpProductRequest,
    ) -> blockchain_models.CreateOcpProductResponse:
        """
        Description: 创建蚂蚁区块链实例
        Summary: 创建蚂蚁区块链实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_ocp_product_ex_async(request, headers, runtime)

    def create_ocp_product_ex(
        self,
        request: blockchain_models.CreateOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateOcpProductResponse:
        """
        Description: 创建蚂蚁区块链实例
        Summary: 创建蚂蚁区块链实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_ocp_product_ex_async(
        self,
        request: blockchain_models.CreateOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateOcpProductResponse:
        """
        Description: 创建蚂蚁区块链实例
        Summary: 创建蚂蚁区块链实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_ocp_product(
        self,
        request: blockchain_models.UpdateOcpProductRequest,
    ) -> blockchain_models.UpdateOcpProductResponse:
        """
        Description: 变配，对已有的实例进行规格变更操作。
        Summary: 对已有的实例进行规格变更操作
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_ocp_product_ex(request, headers, runtime)

    async def update_ocp_product_async(
        self,
        request: blockchain_models.UpdateOcpProductRequest,
    ) -> blockchain_models.UpdateOcpProductResponse:
        """
        Description: 变配，对已有的实例进行规格变更操作。
        Summary: 对已有的实例进行规格变更操作
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_ocp_product_ex_async(request, headers, runtime)

    def update_ocp_product_ex(
        self,
        request: blockchain_models.UpdateOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateOcpProductResponse:
        """
        Description: 变配，对已有的实例进行规格变更操作。
        Summary: 对已有的实例进行规格变更操作
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_ocp_product_ex_async(
        self,
        request: blockchain_models.UpdateOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateOcpProductResponse:
        """
        Description: 变配，对已有的实例进行规格变更操作。
        Summary: 对已有的实例进行规格变更操作
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def close_ocp_product(
        self,
        request: blockchain_models.CloseOcpProductRequest,
    ) -> blockchain_models.CloseOcpProductResponse:
        """
        Description: 用户主动删除实例或欠费逾期平台按照约定进行强制删除。
        Summary: 释放资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.close_ocp_product_ex(request, headers, runtime)

    async def close_ocp_product_async(
        self,
        request: blockchain_models.CloseOcpProductRequest,
    ) -> blockchain_models.CloseOcpProductResponse:
        """
        Description: 用户主动删除实例或欠费逾期平台按照约定进行强制删除。
        Summary: 释放资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.close_ocp_product_ex_async(request, headers, runtime)

    def close_ocp_product_ex(
        self,
        request: blockchain_models.CloseOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseOcpProductResponse:
        """
        Description: 用户主动删除实例或欠费逾期平台按照约定进行强制删除。
        Summary: 释放资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def close_ocp_product_ex_async(
        self,
        request: blockchain_models.CloseOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseOcpProductResponse:
        """
        Description: 用户主动删除实例或欠费逾期平台按照约定进行强制删除。
        Summary: 释放资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def enable_ocp_product(
        self,
        request: blockchain_models.EnableOcpProductRequest,
    ) -> blockchain_models.EnableOcpProductResponse:
        """
        Description: 用户对欠费或者到期实例进行续费操作后，平台会通知产品解除对用户指定实例的操作限制。即恢复正常服务能力。
        Summary: 恢复资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.enable_ocp_product_ex(request, headers, runtime)

    async def enable_ocp_product_async(
        self,
        request: blockchain_models.EnableOcpProductRequest,
    ) -> blockchain_models.EnableOcpProductResponse:
        """
        Description: 用户对欠费或者到期实例进行续费操作后，平台会通知产品解除对用户指定实例的操作限制。即恢复正常服务能力。
        Summary: 恢复资源
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.enable_ocp_product_ex_async(request, headers, runtime)

    def enable_ocp_product_ex(
        self,
        request: blockchain_models.EnableOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.EnableOcpProductResponse:
        """
        Description: 用户对欠费或者到期实例进行续费操作后，平台会通知产品解除对用户指定实例的操作限制。即恢复正常服务能力。
        Summary: 恢复资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.EnableOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.enable', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def enable_ocp_product_ex_async(
        self,
        request: blockchain_models.EnableOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.EnableOcpProductResponse:
        """
        Description: 用户对欠费或者到期实例进行续费操作后，平台会通知产品解除对用户指定实例的操作限制。即恢复正常服务能力。
        Summary: 恢复资源
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.EnableOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.enable', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def stop_ocp_product(
        self,
        request: blockchain_models.StopOcpProductRequest,
    ) -> blockchain_models.StopOcpProductResponse:
        """
        Description: 用户资源到期或欠费情况下会对资源先进行停服操作，用于限制用户使用但不能删除用户数据！不同的产品可以根据自身的功能进行不同的限制。
        Summary: 停止服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.stop_ocp_product_ex(request, headers, runtime)

    async def stop_ocp_product_async(
        self,
        request: blockchain_models.StopOcpProductRequest,
    ) -> blockchain_models.StopOcpProductResponse:
        """
        Description: 用户资源到期或欠费情况下会对资源先进行停服操作，用于限制用户使用但不能删除用户数据！不同的产品可以根据自身的功能进行不同的限制。
        Summary: 停止服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.stop_ocp_product_ex_async(request, headers, runtime)

    def stop_ocp_product_ex(
        self,
        request: blockchain_models.StopOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StopOcpProductResponse:
        """
        Description: 用户资源到期或欠费情况下会对资源先进行停服操作，用于限制用户使用但不能删除用户数据！不同的产品可以根据自身的功能进行不同的限制。
        Summary: 停止服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StopOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.stop', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def stop_ocp_product_ex_async(
        self,
        request: blockchain_models.StopOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StopOcpProductResponse:
        """
        Description: 用户资源到期或欠费情况下会对资源先进行停服操作，用于限制用户使用但不能删除用户数据！不同的产品可以根据自身的功能进行不同的限制。
        Summary: 停止服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StopOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.stop', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def init_ocp_product(
        self,
        request: blockchain_models.InitOcpProductRequest,
    ) -> blockchain_models.InitOcpProductResponse:
        """
        Description: 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方
        Summary: 加载售卖页自定义参数
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.init_ocp_product_ex(request, headers, runtime)

    async def init_ocp_product_async(
        self,
        request: blockchain_models.InitOcpProductRequest,
    ) -> blockchain_models.InitOcpProductResponse:
        """
        Description: 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方
        Summary: 加载售卖页自定义参数
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.init_ocp_product_ex_async(request, headers, runtime)

    def init_ocp_product_ex(
        self,
        request: blockchain_models.InitOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitOcpProductResponse:
        """
        Description: 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方
        Summary: 加载售卖页自定义参数
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def init_ocp_product_ex_async(
        self,
        request: blockchain_models.InitOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitOcpProductResponse:
        """
        Description: 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方
        Summary: 加载售卖页自定义参数
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_ocp_product(
        self,
        request: blockchain_models.QueryOcpProductRequest,
    ) -> blockchain_models.QueryOcpProductResponse:
        """
        Description: 查询商业化产品的状态
        Summary: 查询商业化产品的状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_ocp_product_ex(request, headers, runtime)

    async def query_ocp_product_async(
        self,
        request: blockchain_models.QueryOcpProductRequest,
    ) -> blockchain_models.QueryOcpProductResponse:
        """
        Description: 查询商业化产品的状态
        Summary: 查询商业化产品的状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_ocp_product_ex_async(request, headers, runtime)

    def query_ocp_product_ex(
        self,
        request: blockchain_models.QueryOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryOcpProductResponse:
        """
        Description: 查询商业化产品的状态
        Summary: 查询商业化产品的状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_ocp_product_ex_async(
        self,
        request: blockchain_models.QueryOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryOcpProductResponse:
        """
        Description: 查询商业化产品的状态
        Summary: 查询商业化产品的状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def open_ocp_product(
        self,
        request: blockchain_models.OpenOcpProductRequest,
    ) -> blockchain_models.OpenOcpProductResponse:
        """
        Description: 开通商业化服务
        Summary: 开通商业化服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.open_ocp_product_ex(request, headers, runtime)

    async def open_ocp_product_async(
        self,
        request: blockchain_models.OpenOcpProductRequest,
    ) -> blockchain_models.OpenOcpProductResponse:
        """
        Description: 开通商业化服务
        Summary: 开通商业化服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.open_ocp_product_ex_async(request, headers, runtime)

    def open_ocp_product_ex(
        self,
        request: blockchain_models.OpenOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenOcpProductResponse:
        """
        Description: 开通商业化服务
        Summary: 开通商业化服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def open_ocp_product_ex_async(
        self,
        request: blockchain_models.OpenOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenOcpProductResponse:
        """
        Description: 开通商业化服务
        Summary: 开通商业化服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_ocp_products(
        self,
        request: blockchain_models.CreateOcpProductsRequest,
    ) -> blockchain_models.CreateOcpProductsResponse:
        """
        Description: 创建商业化产品实例
        Summary: 创建商业化产品实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_ocp_products_ex(request, headers, runtime)

    async def create_ocp_products_async(
        self,
        request: blockchain_models.CreateOcpProductsRequest,
    ) -> blockchain_models.CreateOcpProductsResponse:
        """
        Description: 创建商业化产品实例
        Summary: 创建商业化产品实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_ocp_products_ex_async(request, headers, runtime)

    def create_ocp_products_ex(
        self,
        request: blockchain_models.CreateOcpProductsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateOcpProductsResponse:
        """
        Description: 创建商业化产品实例
        Summary: 创建商业化产品实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateOcpProductsResponse(),
            self.do_request('1.0', 'baas.ocp.products.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_ocp_products_ex_async(
        self,
        request: blockchain_models.CreateOcpProductsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateOcpProductsResponse:
        """
        Description: 创建商业化产品实例
        Summary: 创建商业化产品实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateOcpProductsResponse(),
            await self.do_request_async('1.0', 'baas.ocp.products.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def callback_ocp_product(
        self,
        request: blockchain_models.CallbackOcpProductRequest,
    ) -> blockchain_models.CallbackOcpProductResponse:
        """
        Description: 回调接口，产品侧主动通知ocp，产品状态变更。
        Summary: 主动通知ocp，产品状态变更
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.callback_ocp_product_ex(request, headers, runtime)

    async def callback_ocp_product_async(
        self,
        request: blockchain_models.CallbackOcpProductRequest,
    ) -> blockchain_models.CallbackOcpProductResponse:
        """
        Description: 回调接口，产品侧主动通知ocp，产品状态变更。
        Summary: 主动通知ocp，产品状态变更
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.callback_ocp_product_ex_async(request, headers, runtime)

    def callback_ocp_product_ex(
        self,
        request: blockchain_models.CallbackOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CallbackOcpProductResponse:
        """
        Description: 回调接口，产品侧主动通知ocp，产品状态变更。
        Summary: 主动通知ocp，产品状态变更
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CallbackOcpProductResponse(),
            self.do_request('1.0', 'baas.ocp.product.callback', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def callback_ocp_product_ex_async(
        self,
        request: blockchain_models.CallbackOcpProductRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CallbackOcpProductResponse:
        """
        Description: 回调接口，产品侧主动通知ocp，产品状态变更。
        Summary: 主动通知ocp，产品状态变更
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CallbackOcpProductResponse(),
            await self.do_request_async('1.0', 'baas.ocp.product.callback', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_ocp_task(
        self,
        request: blockchain_models.CheckOcpTaskRequest,
    ) -> blockchain_models.CheckOcpTaskResponse:
        """
        Description: 检查任务状态
        Summary: 检查任务状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_ocp_task_ex(request, headers, runtime)

    async def check_ocp_task_async(
        self,
        request: blockchain_models.CheckOcpTaskRequest,
    ) -> blockchain_models.CheckOcpTaskResponse:
        """
        Description: 检查任务状态
        Summary: 检查任务状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_ocp_task_ex_async(request, headers, runtime)

    def check_ocp_task_ex(
        self,
        request: blockchain_models.CheckOcpTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckOcpTaskResponse:
        """
        Description: 检查任务状态
        Summary: 检查任务状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckOcpTaskResponse(),
            self.do_request('1.0', 'baas.ocp.task.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_ocp_task_ex_async(
        self,
        request: blockchain_models.CheckOcpTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckOcpTaskResponse:
        """
        Description: 检查任务状态
        Summary: 检查任务状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckOcpTaskResponse(),
            await self.do_request_async('1.0', 'baas.ocp.task.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_ocp_task(
        self,
        request: blockchain_models.ExecOcpTaskRequest,
    ) -> blockchain_models.ExecOcpTaskResponse:
        """
        Description: 商业化产品相关任务下发
        Summary: 任务下发
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_ocp_task_ex(request, headers, runtime)

    async def exec_ocp_task_async(
        self,
        request: blockchain_models.ExecOcpTaskRequest,
    ) -> blockchain_models.ExecOcpTaskResponse:
        """
        Description: 商业化产品相关任务下发
        Summary: 任务下发
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_ocp_task_ex_async(request, headers, runtime)

    def exec_ocp_task_ex(
        self,
        request: blockchain_models.ExecOcpTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecOcpTaskResponse:
        """
        Description: 商业化产品相关任务下发
        Summary: 任务下发
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecOcpTaskResponse(),
            self.do_request('1.0', 'baas.ocp.task.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_ocp_task_ex_async(
        self,
        request: blockchain_models.ExecOcpTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecOcpTaskResponse:
        """
        Description: 商业化产品相关任务下发
        Summary: 任务下发
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecOcpTaskResponse(),
            await self.do_request_async('1.0', 'baas.ocp.task.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_blockchain_instance_inner(
        self,
        request: blockchain_models.CreateBlockchainInstanceInnerRequest,
    ) -> blockchain_models.CreateBlockchainInstanceInnerResponse:
        """
        Description: 区块链实例创建（内部）
        Summary: 区块链创建（内部）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_blockchain_instance_inner_ex(request, headers, runtime)

    async def create_blockchain_instance_inner_async(
        self,
        request: blockchain_models.CreateBlockchainInstanceInnerRequest,
    ) -> blockchain_models.CreateBlockchainInstanceInnerResponse:
        """
        Description: 区块链实例创建（内部）
        Summary: 区块链创建（内部）
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_blockchain_instance_inner_ex_async(request, headers, runtime)

    def create_blockchain_instance_inner_ex(
        self,
        request: blockchain_models.CreateBlockchainInstanceInnerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBlockchainInstanceInnerResponse:
        """
        Description: 区块链实例创建（内部）
        Summary: 区块链创建（内部）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBlockchainInstanceInnerResponse(),
            self.do_request('1.0', 'baas.blockchain.instance.inner.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_blockchain_instance_inner_ex_async(
        self,
        request: blockchain_models.CreateBlockchainInstanceInnerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateBlockchainInstanceInnerResponse:
        """
        Description: 区块链实例创建（内部）
        Summary: 区块链创建（内部）
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateBlockchainInstanceInnerResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.instance.inner.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_blockchain_instance_bizid(
        self,
        request: blockchain_models.QueryBlockchainInstanceBizidRequest,
    ) -> blockchain_models.QueryBlockchainInstanceBizidResponse:
        """
        Description: 蚂蚁区块链通过实例查询链id
        Summary: 蚂蚁区块链通过实例查询链id
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_blockchain_instance_bizid_ex(request, headers, runtime)

    async def query_blockchain_instance_bizid_async(
        self,
        request: blockchain_models.QueryBlockchainInstanceBizidRequest,
    ) -> blockchain_models.QueryBlockchainInstanceBizidResponse:
        """
        Description: 蚂蚁区块链通过实例查询链id
        Summary: 蚂蚁区块链通过实例查询链id
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_blockchain_instance_bizid_ex_async(request, headers, runtime)

    def query_blockchain_instance_bizid_ex(
        self,
        request: blockchain_models.QueryBlockchainInstanceBizidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainInstanceBizidResponse:
        """
        Description: 蚂蚁区块链通过实例查询链id
        Summary: 蚂蚁区块链通过实例查询链id
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainInstanceBizidResponse(),
            self.do_request('1.0', 'baas.blockchain.instance.bizid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_blockchain_instance_bizid_ex_async(
        self,
        request: blockchain_models.QueryBlockchainInstanceBizidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainInstanceBizidResponse:
        """
        Description: 蚂蚁区块链通过实例查询链id
        Summary: 蚂蚁区块链通过实例查询链id
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainInstanceBizidResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.instance.bizid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_api_consortium(
        self,
        request: blockchain_models.CreateApiConsortiumRequest,
    ) -> blockchain_models.CreateApiConsortiumResponse:
        """
        Description: 创建联盟接口
        Summary: 创建联盟接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_api_consortium_ex(request, headers, runtime)

    async def create_api_consortium_async(
        self,
        request: blockchain_models.CreateApiConsortiumRequest,
    ) -> blockchain_models.CreateApiConsortiumResponse:
        """
        Description: 创建联盟接口
        Summary: 创建联盟接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_api_consortium_ex_async(request, headers, runtime)

    def create_api_consortium_ex(
        self,
        request: blockchain_models.CreateApiConsortiumRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateApiConsortiumResponse:
        """
        Description: 创建联盟接口
        Summary: 创建联盟接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateApiConsortiumResponse(),
            self.do_request('1.0', 'baas.api.consortium.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_api_consortium_ex_async(
        self,
        request: blockchain_models.CreateApiConsortiumRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateApiConsortiumResponse:
        """
        Description: 创建联盟接口
        Summary: 创建联盟接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateApiConsortiumResponse(),
            await self.do_request_async('1.0', 'baas.api.consortium.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_api_miniappbrowser_authtype(
        self,
        request: blockchain_models.QueryApiMiniappbrowserAuthtypeRequest,
    ) -> blockchain_models.QueryApiMiniappbrowserAuthtypeResponse:
        """
        Description: 查询链的小程序浏览器授权状态
        Summary: 查询链的小程序浏览器授权状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_api_miniappbrowser_authtype_ex(request, headers, runtime)

    async def query_api_miniappbrowser_authtype_async(
        self,
        request: blockchain_models.QueryApiMiniappbrowserAuthtypeRequest,
    ) -> blockchain_models.QueryApiMiniappbrowserAuthtypeResponse:
        """
        Description: 查询链的小程序浏览器授权状态
        Summary: 查询链的小程序浏览器授权状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_api_miniappbrowser_authtype_ex_async(request, headers, runtime)

    def query_api_miniappbrowser_authtype_ex(
        self,
        request: blockchain_models.QueryApiMiniappbrowserAuthtypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiMiniappbrowserAuthtypeResponse:
        """
        Description: 查询链的小程序浏览器授权状态
        Summary: 查询链的小程序浏览器授权状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiMiniappbrowserAuthtypeResponse(),
            self.do_request('1.0', 'baas.api.miniappbrowser.authtype.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_api_miniappbrowser_authtype_ex_async(
        self,
        request: blockchain_models.QueryApiMiniappbrowserAuthtypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiMiniappbrowserAuthtypeResponse:
        """
        Description: 查询链的小程序浏览器授权状态
        Summary: 查询链的小程序浏览器授权状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiMiniappbrowserAuthtypeResponse(),
            await self.do_request_async('1.0', 'baas.api.miniappbrowser.authtype.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_statistics_port_height(
        self,
        request: blockchain_models.QueryStatisticsPortHeightRequest,
    ) -> blockchain_models.QueryStatisticsPortHeightResponse:
        """
        Description: 查询某链当前块高
        Summary: 查询某链当前块高
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_statistics_port_height_ex(request, headers, runtime)

    async def query_statistics_port_height_async(
        self,
        request: blockchain_models.QueryStatisticsPortHeightRequest,
    ) -> blockchain_models.QueryStatisticsPortHeightResponse:
        """
        Description: 查询某链当前块高
        Summary: 查询某链当前块高
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_statistics_port_height_ex_async(request, headers, runtime)

    def query_statistics_port_height_ex(
        self,
        request: blockchain_models.QueryStatisticsPortHeightRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryStatisticsPortHeightResponse:
        """
        Description: 查询某链当前块高
        Summary: 查询某链当前块高
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryStatisticsPortHeightResponse(),
            self.do_request('1.0', 'baas.statistics.port.height.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_statistics_port_height_ex_async(
        self,
        request: blockchain_models.QueryStatisticsPortHeightRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryStatisticsPortHeightResponse:
        """
        Description: 查询某链当前块高
        Summary: 查询某链当前块高
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryStatisticsPortHeightResponse(),
            await self.do_request_async('1.0', 'baas.statistics.port.height.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_statistic_port_bizid(
        self,
        request: blockchain_models.QueryStatisticPortBizidRequest,
    ) -> blockchain_models.QueryStatisticPortBizidResponse:
        """
        Description: 查询授权的链id列表
        Summary: 查询授权的链id列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_statistic_port_bizid_ex(request, headers, runtime)

    async def query_statistic_port_bizid_async(
        self,
        request: blockchain_models.QueryStatisticPortBizidRequest,
    ) -> blockchain_models.QueryStatisticPortBizidResponse:
        """
        Description: 查询授权的链id列表
        Summary: 查询授权的链id列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_statistic_port_bizid_ex_async(request, headers, runtime)

    def query_statistic_port_bizid_ex(
        self,
        request: blockchain_models.QueryStatisticPortBizidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryStatisticPortBizidResponse:
        """
        Description: 查询授权的链id列表
        Summary: 查询授权的链id列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryStatisticPortBizidResponse(),
            self.do_request('1.0', 'baas.statistic.port.bizid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_statistic_port_bizid_ex_async(
        self,
        request: blockchain_models.QueryStatisticPortBizidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryStatisticPortBizidResponse:
        """
        Description: 查询授权的链id列表
        Summary: 查询授权的链id列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryStatisticPortBizidResponse(),
            await self.do_request_async('1.0', 'baas.statistic.port.bizid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def add_statistics_port_task(
        self,
        request: blockchain_models.AddStatisticsPortTaskRequest,
    ) -> blockchain_models.AddStatisticsPortTaskResponse:
        """
        Description: 添加存量采集任务
        Summary: 添加存量采集任务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_statistics_port_task_ex(request, headers, runtime)

    async def add_statistics_port_task_async(
        self,
        request: blockchain_models.AddStatisticsPortTaskRequest,
    ) -> blockchain_models.AddStatisticsPortTaskResponse:
        """
        Description: 添加存量采集任务
        Summary: 添加存量采集任务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_statistics_port_task_ex_async(request, headers, runtime)

    def add_statistics_port_task_ex(
        self,
        request: blockchain_models.AddStatisticsPortTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddStatisticsPortTaskResponse:
        """
        Description: 添加存量采集任务
        Summary: 添加存量采集任务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddStatisticsPortTaskResponse(),
            self.do_request('1.0', 'baas.statistics.port.task.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def add_statistics_port_task_ex_async(
        self,
        request: blockchain_models.AddStatisticsPortTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddStatisticsPortTaskResponse:
        """
        Description: 添加存量采集任务
        Summary: 添加存量采集任务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddStatisticsPortTaskResponse(),
            await self.do_request_async('1.0', 'baas.statistics.port.task.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_api_dwh_transaction(
        self,
        request: blockchain_models.QueryApiDwhTransactionRequest,
    ) -> blockchain_models.QueryApiDwhTransactionResponse:
        """
        Description: 查询交易列表
        Summary: 查询交易列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_api_dwh_transaction_ex(request, headers, runtime)

    async def query_api_dwh_transaction_async(
        self,
        request: blockchain_models.QueryApiDwhTransactionRequest,
    ) -> blockchain_models.QueryApiDwhTransactionResponse:
        """
        Description: 查询交易列表
        Summary: 查询交易列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_api_dwh_transaction_ex_async(request, headers, runtime)

    def query_api_dwh_transaction_ex(
        self,
        request: blockchain_models.QueryApiDwhTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhTransactionResponse:
        """
        Description: 查询交易列表
        Summary: 查询交易列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhTransactionResponse(),
            self.do_request('1.0', 'baas.api.dwh.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_api_dwh_transaction_ex_async(
        self,
        request: blockchain_models.QueryApiDwhTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhTransactionResponse:
        """
        Description: 查询交易列表
        Summary: 查询交易列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhTransactionResponse(),
            await self.do_request_async('1.0', 'baas.api.dwh.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_api_dwh_account(
        self,
        request: blockchain_models.QueryApiDwhAccountRequest,
    ) -> blockchain_models.QueryApiDwhAccountResponse:
        """
        Description: 根据自定义条件查询用户列表
        Summary: 查询账户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_api_dwh_account_ex(request, headers, runtime)

    async def query_api_dwh_account_async(
        self,
        request: blockchain_models.QueryApiDwhAccountRequest,
    ) -> blockchain_models.QueryApiDwhAccountResponse:
        """
        Description: 根据自定义条件查询用户列表
        Summary: 查询账户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_api_dwh_account_ex_async(request, headers, runtime)

    def query_api_dwh_account_ex(
        self,
        request: blockchain_models.QueryApiDwhAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhAccountResponse:
        """
        Description: 根据自定义条件查询用户列表
        Summary: 查询账户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhAccountResponse(),
            self.do_request('1.0', 'baas.api.dwh.account.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_api_dwh_account_ex_async(
        self,
        request: blockchain_models.QueryApiDwhAccountRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhAccountResponse:
        """
        Description: 根据自定义条件查询用户列表
        Summary: 查询账户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhAccountResponse(),
            await self.do_request_async('1.0', 'baas.api.dwh.account.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_api_dwh_contract(
        self,
        request: blockchain_models.QueryApiDwhContractRequest,
    ) -> blockchain_models.QueryApiDwhContractResponse:
        """
        Description: 查询合约接口
        Summary: 查询合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_api_dwh_contract_ex(request, headers, runtime)

    async def query_api_dwh_contract_async(
        self,
        request: blockchain_models.QueryApiDwhContractRequest,
    ) -> blockchain_models.QueryApiDwhContractResponse:
        """
        Description: 查询合约接口
        Summary: 查询合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_api_dwh_contract_ex_async(request, headers, runtime)

    def query_api_dwh_contract_ex(
        self,
        request: blockchain_models.QueryApiDwhContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhContractResponse:
        """
        Description: 查询合约接口
        Summary: 查询合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhContractResponse(),
            self.do_request('1.0', 'baas.api.dwh.contract.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_api_dwh_contract_ex_async(
        self,
        request: blockchain_models.QueryApiDwhContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhContractResponse:
        """
        Description: 查询合约接口
        Summary: 查询合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhContractResponse(),
            await self.do_request_async('1.0', 'baas.api.dwh.contract.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_api_dwhb_transaction(
        self,
        request: blockchain_models.QueryApiDwhbTransactionRequest,
    ) -> blockchain_models.QueryApiDwhbTransactionResponse:
        """
        Description: 单独查询交易
        Summary: 查询链上交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_api_dwhb_transaction_ex(request, headers, runtime)

    async def query_api_dwhb_transaction_async(
        self,
        request: blockchain_models.QueryApiDwhbTransactionRequest,
    ) -> blockchain_models.QueryApiDwhbTransactionResponse:
        """
        Description: 单独查询交易
        Summary: 查询链上交易
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_api_dwhb_transaction_ex_async(request, headers, runtime)

    def query_api_dwhb_transaction_ex(
        self,
        request: blockchain_models.QueryApiDwhbTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhbTransactionResponse:
        """
        Description: 单独查询交易
        Summary: 查询链上交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhbTransactionResponse(),
            self.do_request('1.0', 'baas.api.dwhb.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_api_dwhb_transaction_ex_async(
        self,
        request: blockchain_models.QueryApiDwhbTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryApiDwhbTransactionResponse:
        """
        Description: 单独查询交易
        Summary: 查询链上交易
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryApiDwhbTransactionResponse(),
            await self.do_request_async('1.0', 'baas.api.dwhb.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_caas_contract_service(
        self,
        request: blockchain_models.DeleteCaasContractServiceRequest,
    ) -> blockchain_models.DeleteCaasContractServiceResponse:
        """
        Description: 删除合约
        Summary: 删除合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_caas_contract_service_ex(request, headers, runtime)

    async def delete_caas_contract_service_async(
        self,
        request: blockchain_models.DeleteCaasContractServiceRequest,
    ) -> blockchain_models.DeleteCaasContractServiceResponse:
        """
        Description: 删除合约
        Summary: 删除合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_caas_contract_service_ex_async(request, headers, runtime)

    def delete_caas_contract_service_ex(
        self,
        request: blockchain_models.DeleteCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteCaasContractServiceResponse:
        """
        Description: 删除合约
        Summary: 删除合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_caas_contract_service_ex_async(
        self,
        request: blockchain_models.DeleteCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteCaasContractServiceResponse:
        """
        Description: 删除合约
        Summary: 删除合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_caas_contract_service(
        self,
        request: blockchain_models.CreateCaasContractServiceRequest,
    ) -> blockchain_models.CreateCaasContractServiceResponse:
        """
        Description: 新建合约服务
        Summary: 新建合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_caas_contract_service_ex(request, headers, runtime)

    async def create_caas_contract_service_async(
        self,
        request: blockchain_models.CreateCaasContractServiceRequest,
    ) -> blockchain_models.CreateCaasContractServiceResponse:
        """
        Description: 新建合约服务
        Summary: 新建合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_caas_contract_service_ex_async(request, headers, runtime)

    def create_caas_contract_service_ex(
        self,
        request: blockchain_models.CreateCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateCaasContractServiceResponse:
        """
        Description: 新建合约服务
        Summary: 新建合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_caas_contract_service_ex_async(
        self,
        request: blockchain_models.CreateCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateCaasContractServiceResponse:
        """
        Description: 新建合约服务
        Summary: 新建合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pagequery_caas_contract_service(
        self,
        request: blockchain_models.PagequeryCaasContractServiceRequest,
    ) -> blockchain_models.PagequeryCaasContractServiceResponse:
        """
        Description: 合约列表查询
        Summary: 合约列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pagequery_caas_contract_service_ex(request, headers, runtime)

    async def pagequery_caas_contract_service_async(
        self,
        request: blockchain_models.PagequeryCaasContractServiceRequest,
    ) -> blockchain_models.PagequeryCaasContractServiceResponse:
        """
        Description: 合约列表查询
        Summary: 合约列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pagequery_caas_contract_service_ex_async(request, headers, runtime)

    def pagequery_caas_contract_service_ex(
        self,
        request: blockchain_models.PagequeryCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasContractServiceResponse:
        """
        Description: 合约列表查询
        Summary: 合约列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pagequery_caas_contract_service_ex_async(
        self,
        request: blockchain_models.PagequeryCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasContractServiceResponse:
        """
        Description: 合约列表查询
        Summary: 合约列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_caas_contract_service(
        self,
        request: blockchain_models.QueryCaasContractServiceRequest,
    ) -> blockchain_models.QueryCaasContractServiceResponse:
        """
        Description: 查询创建实例进度
        Summary: 查询创建实例进度
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_caas_contract_service_ex(request, headers, runtime)

    async def query_caas_contract_service_async(
        self,
        request: blockchain_models.QueryCaasContractServiceRequest,
    ) -> blockchain_models.QueryCaasContractServiceResponse:
        """
        Description: 查询创建实例进度
        Summary: 查询创建实例进度
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_caas_contract_service_ex_async(request, headers, runtime)

    def query_caas_contract_service_ex(
        self,
        request: blockchain_models.QueryCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCaasContractServiceResponse:
        """
        Description: 查询创建实例进度
        Summary: 查询创建实例进度
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_caas_contract_service_ex_async(
        self,
        request: blockchain_models.QueryCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCaasContractServiceResponse:
        """
        Description: 查询创建实例进度
        Summary: 查询创建实例进度
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def deploy_caas_contract_service(
        self,
        request: blockchain_models.DeployCaasContractServiceRequest,
    ) -> blockchain_models.DeployCaasContractServiceResponse:
        """
        Description: 自动化部署合约服务
        Summary: 自动化部署合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.deploy_caas_contract_service_ex(request, headers, runtime)

    async def deploy_caas_contract_service_async(
        self,
        request: blockchain_models.DeployCaasContractServiceRequest,
    ) -> blockchain_models.DeployCaasContractServiceResponse:
        """
        Description: 自动化部署合约服务
        Summary: 自动化部署合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.deploy_caas_contract_service_ex_async(request, headers, runtime)

    def deploy_caas_contract_service_ex(
        self,
        request: blockchain_models.DeployCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeployCaasContractServiceResponse:
        """
        Description: 自动化部署合约服务
        Summary: 自动化部署合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeployCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.deploy', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def deploy_caas_contract_service_ex_async(
        self,
        request: blockchain_models.DeployCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeployCaasContractServiceResponse:
        """
        Description: 自动化部署合约服务
        Summary: 自动化部署合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeployCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.deploy', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_caas_contract_service(
        self,
        request: blockchain_models.ListCaasContractServiceRequest,
    ) -> blockchain_models.ListCaasContractServiceResponse:
        """
        Description: 查询合约类型列表
        Summary: 查询合约类型列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_caas_contract_service_ex(request, headers, runtime)

    async def list_caas_contract_service_async(
        self,
        request: blockchain_models.ListCaasContractServiceRequest,
    ) -> blockchain_models.ListCaasContractServiceResponse:
        """
        Description: 查询合约类型列表
        Summary: 查询合约类型列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_caas_contract_service_ex_async(request, headers, runtime)

    def list_caas_contract_service_ex(
        self,
        request: blockchain_models.ListCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListCaasContractServiceResponse:
        """
        Description: 查询合约类型列表
        Summary: 查询合约类型列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_caas_contract_service_ex_async(
        self,
        request: blockchain_models.ListCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListCaasContractServiceResponse:
        """
        Description: 查询合约类型列表
        Summary: 查询合约类型列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def detail_caas_contract_service(
        self,
        request: blockchain_models.DetailCaasContractServiceRequest,
    ) -> blockchain_models.DetailCaasContractServiceResponse:
        """
        Description: 合约详情
        Summary: 合约详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.detail_caas_contract_service_ex(request, headers, runtime)

    async def detail_caas_contract_service_async(
        self,
        request: blockchain_models.DetailCaasContractServiceRequest,
    ) -> blockchain_models.DetailCaasContractServiceResponse:
        """
        Description: 合约详情
        Summary: 合约详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.detail_caas_contract_service_ex_async(request, headers, runtime)

    def detail_caas_contract_service_ex(
        self,
        request: blockchain_models.DetailCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DetailCaasContractServiceResponse:
        """
        Description: 合约详情
        Summary: 合约详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DetailCaasContractServiceResponse(),
            self.do_request('1.0', 'baas.caas.contract.service.detail', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def detail_caas_contract_service_ex_async(
        self,
        request: blockchain_models.DetailCaasContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DetailCaasContractServiceResponse:
        """
        Description: 合约详情
        Summary: 合约详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DetailCaasContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.service.detail', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_caas_application_manage(
        self,
        request: blockchain_models.CreateCaasApplicationManageRequest,
    ) -> blockchain_models.CreateCaasApplicationManageResponse:
        """
        Description: 新建应用
        Summary: 新建应用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_caas_application_manage_ex(request, headers, runtime)

    async def create_caas_application_manage_async(
        self,
        request: blockchain_models.CreateCaasApplicationManageRequest,
    ) -> blockchain_models.CreateCaasApplicationManageResponse:
        """
        Description: 新建应用
        Summary: 新建应用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_caas_application_manage_ex_async(request, headers, runtime)

    def create_caas_application_manage_ex(
        self,
        request: blockchain_models.CreateCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateCaasApplicationManageResponse:
        """
        Description: 新建应用
        Summary: 新建应用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_caas_application_manage_ex_async(
        self,
        request: blockchain_models.CreateCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateCaasApplicationManageResponse:
        """
        Description: 新建应用
        Summary: 新建应用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pagequery_caas_application_manage(
        self,
        request: blockchain_models.PagequeryCaasApplicationManageRequest,
    ) -> blockchain_models.PagequeryCaasApplicationManageResponse:
        """
        Description: 应用列表查询
        Summary: 应用列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pagequery_caas_application_manage_ex(request, headers, runtime)

    async def pagequery_caas_application_manage_async(
        self,
        request: blockchain_models.PagequeryCaasApplicationManageRequest,
    ) -> blockchain_models.PagequeryCaasApplicationManageResponse:
        """
        Description: 应用列表查询
        Summary: 应用列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pagequery_caas_application_manage_ex_async(request, headers, runtime)

    def pagequery_caas_application_manage_ex(
        self,
        request: blockchain_models.PagequeryCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasApplicationManageResponse:
        """
        Description: 应用列表查询
        Summary: 应用列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pagequery_caas_application_manage_ex_async(
        self,
        request: blockchain_models.PagequeryCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasApplicationManageResponse:
        """
        Description: 应用列表查询
        Summary: 应用列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_caas_application_manage(
        self,
        request: blockchain_models.QueryCaasApplicationManageRequest,
    ) -> blockchain_models.QueryCaasApplicationManageResponse:
        """
        Description: 查询合约绑定关系
        Summary: 查询合约绑定关系
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_caas_application_manage_ex(request, headers, runtime)

    async def query_caas_application_manage_async(
        self,
        request: blockchain_models.QueryCaasApplicationManageRequest,
    ) -> blockchain_models.QueryCaasApplicationManageResponse:
        """
        Description: 查询合约绑定关系
        Summary: 查询合约绑定关系
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_caas_application_manage_ex_async(request, headers, runtime)

    def query_caas_application_manage_ex(
        self,
        request: blockchain_models.QueryCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCaasApplicationManageResponse:
        """
        Description: 查询合约绑定关系
        Summary: 查询合约绑定关系
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_caas_application_manage_ex_async(
        self,
        request: blockchain_models.QueryCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCaasApplicationManageResponse:
        """
        Description: 查询合约绑定关系
        Summary: 查询合约绑定关系
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def unbind_caas_application_manage(
        self,
        request: blockchain_models.UnbindCaasApplicationManageRequest,
    ) -> blockchain_models.UnbindCaasApplicationManageResponse:
        """
        Description: 解除授权
        Summary: 解除授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.unbind_caas_application_manage_ex(request, headers, runtime)

    async def unbind_caas_application_manage_async(
        self,
        request: blockchain_models.UnbindCaasApplicationManageRequest,
    ) -> blockchain_models.UnbindCaasApplicationManageResponse:
        """
        Description: 解除授权
        Summary: 解除授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.unbind_caas_application_manage_ex_async(request, headers, runtime)

    def unbind_caas_application_manage_ex(
        self,
        request: blockchain_models.UnbindCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnbindCaasApplicationManageResponse:
        """
        Description: 解除授权
        Summary: 解除授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnbindCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.unbind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def unbind_caas_application_manage_ex_async(
        self,
        request: blockchain_models.UnbindCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnbindCaasApplicationManageResponse:
        """
        Description: 解除授权
        Summary: 解除授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnbindCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.unbind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def bind_caas_application_manage(
        self,
        request: blockchain_models.BindCaasApplicationManageRequest,
    ) -> blockchain_models.BindCaasApplicationManageResponse:
        """
        Description: 绑定合约
        Summary: 绑定合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.bind_caas_application_manage_ex(request, headers, runtime)

    async def bind_caas_application_manage_async(
        self,
        request: blockchain_models.BindCaasApplicationManageRequest,
    ) -> blockchain_models.BindCaasApplicationManageResponse:
        """
        Description: 绑定合约
        Summary: 绑定合约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.bind_caas_application_manage_ex_async(request, headers, runtime)

    def bind_caas_application_manage_ex(
        self,
        request: blockchain_models.BindCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BindCaasApplicationManageResponse:
        """
        Description: 绑定合约
        Summary: 绑定合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BindCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.bind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def bind_caas_application_manage_ex_async(
        self,
        request: blockchain_models.BindCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BindCaasApplicationManageResponse:
        """
        Description: 绑定合约
        Summary: 绑定合约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BindCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.bind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_caas_application_manage(
        self,
        request: blockchain_models.GetCaasApplicationManageRequest,
    ) -> blockchain_models.GetCaasApplicationManageResponse:
        """
        Description: 查看sk
        Summary: 查看sk
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_caas_application_manage_ex(request, headers, runtime)

    async def get_caas_application_manage_async(
        self,
        request: blockchain_models.GetCaasApplicationManageRequest,
    ) -> blockchain_models.GetCaasApplicationManageResponse:
        """
        Description: 查看sk
        Summary: 查看sk
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_caas_application_manage_ex_async(request, headers, runtime)

    def get_caas_application_manage_ex(
        self,
        request: blockchain_models.GetCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetCaasApplicationManageResponse:
        """
        Description: 查看sk
        Summary: 查看sk
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetCaasApplicationManageResponse(),
            self.do_request('1.0', 'baas.caas.application.manage.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_caas_application_manage_ex_async(
        self,
        request: blockchain_models.GetCaasApplicationManageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetCaasApplicationManageResponse:
        """
        Description: 查看sk
        Summary: 查看sk
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetCaasApplicationManageResponse(),
            await self.do_request_async('1.0', 'baas.caas.application.manage.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pagequery_caas_contract_market(
        self,
        request: blockchain_models.PagequeryCaasContractMarketRequest,
    ) -> blockchain_models.PagequeryCaasContractMarketResponse:
        """
        Description: 智能合约市场列表查询
        Summary: 智能合约市场列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pagequery_caas_contract_market_ex(request, headers, runtime)

    async def pagequery_caas_contract_market_async(
        self,
        request: blockchain_models.PagequeryCaasContractMarketRequest,
    ) -> blockchain_models.PagequeryCaasContractMarketResponse:
        """
        Description: 智能合约市场列表查询
        Summary: 智能合约市场列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pagequery_caas_contract_market_ex_async(request, headers, runtime)

    def pagequery_caas_contract_market_ex(
        self,
        request: blockchain_models.PagequeryCaasContractMarketRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasContractMarketResponse:
        """
        Description: 智能合约市场列表查询
        Summary: 智能合约市场列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasContractMarketResponse(),
            self.do_request('1.0', 'baas.caas.contract.market.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pagequery_caas_contract_market_ex_async(
        self,
        request: blockchain_models.PagequeryCaasContractMarketRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PagequeryCaasContractMarketResponse:
        """
        Description: 智能合约市场列表查询
        Summary: 智能合约市场列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PagequeryCaasContractMarketResponse(),
            await self.do_request_async('1.0', 'baas.caas.contract.market.pagequery', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_contract_record(
        self,
        request: blockchain_models.CreateContractRecordRequest,
    ) -> blockchain_models.CreateContractRecordResponse:
        """
        Description: 合约部署记录
        Summary: 合约部署记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_contract_record_ex(request, headers, runtime)

    async def create_contract_record_async(
        self,
        request: blockchain_models.CreateContractRecordRequest,
    ) -> blockchain_models.CreateContractRecordResponse:
        """
        Description: 合约部署记录
        Summary: 合约部署记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_contract_record_ex_async(request, headers, runtime)

    def create_contract_record_ex(
        self,
        request: blockchain_models.CreateContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateContractRecordResponse:
        """
        Description: 合约部署记录
        Summary: 合约部署记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_contract_record_ex_async(
        self,
        request: blockchain_models.CreateContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateContractRecordResponse:
        """
        Description: 合约部署记录
        Summary: 合约部署记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_contract_record(
        self,
        request: blockchain_models.GetContractRecordRequest,
    ) -> blockchain_models.GetContractRecordResponse:
        """
        Description: 部署记录详情
        Summary: 部署记录详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_contract_record_ex(request, headers, runtime)

    async def get_contract_record_async(
        self,
        request: blockchain_models.GetContractRecordRequest,
    ) -> blockchain_models.GetContractRecordResponse:
        """
        Description: 部署记录详情
        Summary: 部署记录详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_contract_record_ex_async(request, headers, runtime)

    def get_contract_record_ex(
        self,
        request: blockchain_models.GetContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractRecordResponse:
        """
        Description: 部署记录详情
        Summary: 部署记录详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_contract_record_ex_async(
        self,
        request: blockchain_models.GetContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractRecordResponse:
        """
        Description: 部署记录详情
        Summary: 部署记录详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_contract_record(
        self,
        request: blockchain_models.UpdateContractRecordRequest,
    ) -> blockchain_models.UpdateContractRecordResponse:
        """
        Description: 合约升级更新
        Summary: 合约升级更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_contract_record_ex(request, headers, runtime)

    async def update_contract_record_async(
        self,
        request: blockchain_models.UpdateContractRecordRequest,
    ) -> blockchain_models.UpdateContractRecordResponse:
        """
        Description: 合约升级更新
        Summary: 合约升级更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_contract_record_ex_async(request, headers, runtime)

    def update_contract_record_ex(
        self,
        request: blockchain_models.UpdateContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateContractRecordResponse:
        """
        Description: 合约升级更新
        Summary: 合约升级更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_contract_record_ex_async(
        self,
        request: blockchain_models.UpdateContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateContractRecordResponse:
        """
        Description: 合约升级更新
        Summary: 合约升级更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def online_contract_record(
        self,
        request: blockchain_models.OnlineContractRecordRequest,
    ) -> blockchain_models.OnlineContractRecordResponse:
        """
        Description: 发布合约服务
        Summary: 发布合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.online_contract_record_ex(request, headers, runtime)

    async def online_contract_record_async(
        self,
        request: blockchain_models.OnlineContractRecordRequest,
    ) -> blockchain_models.OnlineContractRecordResponse:
        """
        Description: 发布合约服务
        Summary: 发布合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.online_contract_record_ex_async(request, headers, runtime)

    def online_contract_record_ex(
        self,
        request: blockchain_models.OnlineContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OnlineContractRecordResponse:
        """
        Description: 发布合约服务
        Summary: 发布合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OnlineContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.online', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def online_contract_record_ex_async(
        self,
        request: blockchain_models.OnlineContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OnlineContractRecordResponse:
        """
        Description: 发布合约服务
        Summary: 发布合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OnlineContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.online', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def offline_contract_record(
        self,
        request: blockchain_models.OfflineContractRecordRequest,
    ) -> blockchain_models.OfflineContractRecordResponse:
        """
        Description: 合约服务下线
        Summary: 合约服务下线
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.offline_contract_record_ex(request, headers, runtime)

    async def offline_contract_record_async(
        self,
        request: blockchain_models.OfflineContractRecordRequest,
    ) -> blockchain_models.OfflineContractRecordResponse:
        """
        Description: 合约服务下线
        Summary: 合约服务下线
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.offline_contract_record_ex_async(request, headers, runtime)

    def offline_contract_record_ex(
        self,
        request: blockchain_models.OfflineContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OfflineContractRecordResponse:
        """
        Description: 合约服务下线
        Summary: 合约服务下线
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OfflineContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.offline', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def offline_contract_record_ex_async(
        self,
        request: blockchain_models.OfflineContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OfflineContractRecordResponse:
        """
        Description: 合约服务下线
        Summary: 合约服务下线
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OfflineContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.offline', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_contract_record(
        self,
        request: blockchain_models.QueryContractRecordRequest,
    ) -> blockchain_models.QueryContractRecordResponse:
        """
        Description: 查询合约部署记录
        Summary: 查询合约部署记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_contract_record_ex(request, headers, runtime)

    async def query_contract_record_async(
        self,
        request: blockchain_models.QueryContractRecordRequest,
    ) -> blockchain_models.QueryContractRecordResponse:
        """
        Description: 查询合约部署记录
        Summary: 查询合约部署记录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_contract_record_ex_async(request, headers, runtime)

    def query_contract_record_ex(
        self,
        request: blockchain_models.QueryContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryContractRecordResponse:
        """
        Description: 查询合约部署记录
        Summary: 查询合约部署记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryContractRecordResponse(),
            self.do_request('1.0', 'baas.contract.record.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_contract_record_ex_async(
        self,
        request: blockchain_models.QueryContractRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryContractRecordResponse:
        """
        Description: 查询合约部署记录
        Summary: 查询合约部署记录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryContractRecordResponse(),
            await self.do_request_async('1.0', 'baas.contract.record.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_contract_delegate(
        self,
        request: blockchain_models.ExecContractDelegateRequest,
    ) -> blockchain_models.ExecContractDelegateResponse:
        """
        Description: 合约代理调用
        Summary: 合约代理调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_contract_delegate_ex(request, headers, runtime)

    async def exec_contract_delegate_async(
        self,
        request: blockchain_models.ExecContractDelegateRequest,
    ) -> blockchain_models.ExecContractDelegateResponse:
        """
        Description: 合约代理调用
        Summary: 合约代理调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_contract_delegate_ex_async(request, headers, runtime)

    def exec_contract_delegate_ex(
        self,
        request: blockchain_models.ExecContractDelegateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecContractDelegateResponse:
        """
        Description: 合约代理调用
        Summary: 合约代理调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecContractDelegateResponse(),
            self.do_request('1.0', 'baas.contract.delegate.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_contract_delegate_ex_async(
        self,
        request: blockchain_models.ExecContractDelegateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecContractDelegateResponse:
        """
        Description: 合约代理调用
        Summary: 合约代理调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecContractDelegateResponse(),
            await self.do_request_async('1.0', 'baas.contract.delegate.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_contract_service(
        self,
        request: blockchain_models.ExecContractServiceRequest,
    ) -> blockchain_models.ExecContractServiceResponse:
        """
        Description: 调用合约服务
        Summary: 调用合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_contract_service_ex(request, headers, runtime)

    async def exec_contract_service_async(
        self,
        request: blockchain_models.ExecContractServiceRequest,
    ) -> blockchain_models.ExecContractServiceResponse:
        """
        Description: 调用合约服务
        Summary: 调用合约服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_contract_service_ex_async(request, headers, runtime)

    def exec_contract_service_ex(
        self,
        request: blockchain_models.ExecContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecContractServiceResponse:
        """
        Description: 调用合约服务
        Summary: 调用合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecContractServiceResponse(),
            self.do_request('1.0', 'baas.contract.service.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_contract_service_ex_async(
        self,
        request: blockchain_models.ExecContractServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecContractServiceResponse:
        """
        Description: 调用合约服务
        Summary: 调用合约服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecContractServiceResponse(),
            await self.do_request_async('1.0', 'baas.contract.service.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_contract_config_chain(
        self,
        request: blockchain_models.GetContractConfigChainRequest,
    ) -> blockchain_models.GetContractConfigChainResponse:
        """
        Description: 获取当前租户具有访问权限的合约链配置列表，方便在client（IDE插件、SDK等）访问合约链
        Summary: 获取合约链配置
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_contract_config_chain_ex(request, headers, runtime)

    async def get_contract_config_chain_async(
        self,
        request: blockchain_models.GetContractConfigChainRequest,
    ) -> blockchain_models.GetContractConfigChainResponse:
        """
        Description: 获取当前租户具有访问权限的合约链配置列表，方便在client（IDE插件、SDK等）访问合约链
        Summary: 获取合约链配置
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_contract_config_chain_ex_async(request, headers, runtime)

    def get_contract_config_chain_ex(
        self,
        request: blockchain_models.GetContractConfigChainRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractConfigChainResponse:
        """
        Description: 获取当前租户具有访问权限的合约链配置列表，方便在client（IDE插件、SDK等）访问合约链
        Summary: 获取合约链配置
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractConfigChainResponse(),
            self.do_request('1.0', 'baas.contract.config.chain.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_contract_config_chain_ex_async(
        self,
        request: blockchain_models.GetContractConfigChainRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractConfigChainResponse:
        """
        Description: 获取当前租户具有访问权限的合约链配置列表，方便在client（IDE插件、SDK等）访问合约链
        Summary: 获取合约链配置
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractConfigChainResponse(),
            await self.do_request_async('1.0', 'baas.contract.config.chain.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_contract_abi_url(
        self,
        request: blockchain_models.GetContractAbiUrlRequest,
    ) -> blockchain_models.GetContractAbiUrlResponse:
        """
        Description: 申请获取一个可以上传文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_contract_abi_url_ex(request, headers, runtime)

    async def get_contract_abi_url_async(
        self,
        request: blockchain_models.GetContractAbiUrlRequest,
    ) -> blockchain_models.GetContractAbiUrlResponse:
        """
        Description: 申请获取一个可以上传文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_contract_abi_url_ex_async(request, headers, runtime)

    def get_contract_abi_url_ex(
        self,
        request: blockchain_models.GetContractAbiUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractAbiUrlResponse:
        """
        Description: 申请获取一个可以上传文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractAbiUrlResponse(),
            self.do_request('1.0', 'baas.contract.abi.url.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_contract_abi_url_ex_async(
        self,
        request: blockchain_models.GetContractAbiUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractAbiUrlResponse:
        """
        Description: 申请获取一个可以上传文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractAbiUrlResponse(),
            await self.do_request_async('1.0', 'baas.contract.abi.url.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_contract_bytecode_url(
        self,
        request: blockchain_models.GetContractBytecodeUrlRequest,
    ) -> blockchain_models.GetContractBytecodeUrlResponse:
        """
        Description: 申请获取一个可以上传bytecode文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_contract_bytecode_url_ex(request, headers, runtime)

    async def get_contract_bytecode_url_async(
        self,
        request: blockchain_models.GetContractBytecodeUrlRequest,
    ) -> blockchain_models.GetContractBytecodeUrlResponse:
        """
        Description: 申请获取一个可以上传bytecode文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_contract_bytecode_url_ex_async(request, headers, runtime)

    def get_contract_bytecode_url_ex(
        self,
        request: blockchain_models.GetContractBytecodeUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractBytecodeUrlResponse:
        """
        Description: 申请获取一个可以上传bytecode文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractBytecodeUrlResponse(),
            self.do_request('1.0', 'baas.contract.bytecode.url.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_contract_bytecode_url_ex_async(
        self,
        request: blockchain_models.GetContractBytecodeUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetContractBytecodeUrlResponse:
        """
        Description: 申请获取一个可以上传bytecode文件到oss的url，此url可用时间默认为30秒
        Summary: 获取oss的可用url上传文件
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetContractBytecodeUrlResponse(),
            await self.do_request_async('1.0', 'baas.contract.bytecode.url.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def upload_data_file_batchquery(
        self,
        request: blockchain_models.UploadDataFileBatchqueryRequest,
    ) -> blockchain_models.UploadDataFileBatchqueryResponse:
        """
        Description: 上传批量查询数据文件
        Summary: 上传批量查询数据文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.upload_data_file_batchquery_ex(request, headers, runtime)

    async def upload_data_file_batchquery_async(
        self,
        request: blockchain_models.UploadDataFileBatchqueryRequest,
    ) -> blockchain_models.UploadDataFileBatchqueryResponse:
        """
        Description: 上传批量查询数据文件
        Summary: 上传批量查询数据文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.upload_data_file_batchquery_ex_async(request, headers, runtime)

    def upload_data_file_batchquery_ex(
        self,
        request: blockchain_models.UploadDataFileBatchqueryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadDataFileBatchqueryResponse:
        """
        Description: 上传批量查询数据文件
        Summary: 上传批量查询数据文件
        """
        if not UtilClient.is_unset(request.file_object):
            upload_req = blockchain_models.CreateAntcloudGatewayxFileUploadRequest(
                auth_token=request.auth_token,
                api_code='baas.data.file.batchquery.upload',
                file_name=request.file_object_name
            )
            upload_resp = self.create_antcloud_gatewayx_file_upload_ex(upload_req, headers, runtime)
            if not AntchainUtils.is_success(upload_resp.result_code, 'ok'):
                upload_data_file_batchquery_response = blockchain_models.UploadDataFileBatchqueryResponse(
                    req_msg_id=upload_resp.req_msg_id,
                    result_code=upload_resp.result_code,
                    result_msg=upload_resp.result_msg
                )
                return upload_data_file_batchquery_response
            upload_headers = AntchainUtils.parse_upload_headers(upload_resp.upload_headers)
            AntchainUtils.put_object(request.file_object, upload_headers, upload_resp.upload_url)
            request.file_id = upload_resp.file_id
            request.file_object = None
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadDataFileBatchqueryResponse(),
            self.do_request('1.0', 'baas.data.file.batchquery.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def upload_data_file_batchquery_ex_async(
        self,
        request: blockchain_models.UploadDataFileBatchqueryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadDataFileBatchqueryResponse:
        """
        Description: 上传批量查询数据文件
        Summary: 上传批量查询数据文件
        """
        if not UtilClient.is_unset(request.file_object):
            upload_req = blockchain_models.CreateAntcloudGatewayxFileUploadRequest(
                auth_token=request.auth_token,
                api_code='baas.data.file.batchquery.upload',
                file_name=request.file_object_name
            )
            upload_resp = await self.create_antcloud_gatewayx_file_upload_ex_async(upload_req, headers, runtime)
            if not AntchainUtils.is_success(upload_resp.result_code, 'ok'):
                upload_data_file_batchquery_response = blockchain_models.UploadDataFileBatchqueryResponse(
                    req_msg_id=upload_resp.req_msg_id,
                    result_code=upload_resp.result_code,
                    result_msg=upload_resp.result_msg
                )
                return upload_data_file_batchquery_response
            upload_headers = AntchainUtils.parse_upload_headers(upload_resp.upload_headers)
            await AntchainUtils.put_object_async(request.file_object, upload_headers, upload_resp.upload_url)
            request.file_id = upload_resp.file_id
            request.file_object = None
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadDataFileBatchqueryResponse(),
            await self.do_request_async('1.0', 'baas.data.file.batchquery.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_data_result_batchquery(
        self,
        request: blockchain_models.QueryDataResultBatchqueryRequest,
    ) -> blockchain_models.QueryDataResultBatchqueryResponse:
        """
        Description: 获取查询数据集任务结果
        Summary: 获取查询数据集任务结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_data_result_batchquery_ex(request, headers, runtime)

    async def query_data_result_batchquery_async(
        self,
        request: blockchain_models.QueryDataResultBatchqueryRequest,
    ) -> blockchain_models.QueryDataResultBatchqueryResponse:
        """
        Description: 获取查询数据集任务结果
        Summary: 获取查询数据集任务结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_data_result_batchquery_ex_async(request, headers, runtime)

    def query_data_result_batchquery_ex(
        self,
        request: blockchain_models.QueryDataResultBatchqueryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataResultBatchqueryResponse:
        """
        Description: 获取查询数据集任务结果
        Summary: 获取查询数据集任务结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataResultBatchqueryResponse(),
            self.do_request('1.0', 'baas.data.result.batchquery.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_data_result_batchquery_ex_async(
        self,
        request: blockchain_models.QueryDataResultBatchqueryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataResultBatchqueryResponse:
        """
        Description: 获取查询数据集任务结果
        Summary: 获取查询数据集任务结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataResultBatchqueryResponse(),
            await self.do_request_async('1.0', 'baas.data.result.batchquery.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_participant(
        self,
        request: blockchain_models.CreateDataauthorizationParticipantRequest,
    ) -> blockchain_models.CreateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务创建参与方
        Summary: 数据授权服务创建参与方
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_participant_ex(request, headers, runtime)

    async def create_dataauthorization_participant_async(
        self,
        request: blockchain_models.CreateDataauthorizationParticipantRequest,
    ) -> blockchain_models.CreateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务创建参与方
        Summary: 数据授权服务创建参与方
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_participant_ex_async(request, headers, runtime)

    def create_dataauthorization_participant_ex(
        self,
        request: blockchain_models.CreateDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务创建参与方
        Summary: 数据授权服务创建参与方
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_participant_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务创建参与方
        Summary: 数据授权服务创建参与方
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_dataauthorization_participant(
        self,
        request: blockchain_models.DeleteDataauthorizationParticipantRequest,
    ) -> blockchain_models.DeleteDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务删除参与方
        Summary: 数据授权服务删除参与方
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_dataauthorization_participant_ex(request, headers, runtime)

    async def delete_dataauthorization_participant_async(
        self,
        request: blockchain_models.DeleteDataauthorizationParticipantRequest,
    ) -> blockchain_models.DeleteDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务删除参与方
        Summary: 数据授权服务删除参与方
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_dataauthorization_participant_ex_async(request, headers, runtime)

    def delete_dataauthorization_participant_ex(
        self,
        request: blockchain_models.DeleteDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务删除参与方
        Summary: 数据授权服务删除参与方
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_dataauthorization_participant_ex_async(
        self,
        request: blockchain_models.DeleteDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务删除参与方
        Summary: 数据授权服务删除参与方
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_dataauthorization_participant(
        self,
        request: blockchain_models.UpdateDataauthorizationParticipantRequest,
    ) -> blockchain_models.UpdateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务修改用户信息
        Summary: 数据授权服务修改用户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_dataauthorization_participant_ex(request, headers, runtime)

    async def update_dataauthorization_participant_async(
        self,
        request: blockchain_models.UpdateDataauthorizationParticipantRequest,
    ) -> blockchain_models.UpdateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务修改用户信息
        Summary: 数据授权服务修改用户信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_dataauthorization_participant_ex_async(request, headers, runtime)

    def update_dataauthorization_participant_ex(
        self,
        request: blockchain_models.UpdateDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务修改用户信息
        Summary: 数据授权服务修改用户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_dataauthorization_participant_ex_async(
        self,
        request: blockchain_models.UpdateDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务修改用户信息
        Summary: 数据授权服务修改用户信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_dataauthorization_participant(
        self,
        request: blockchain_models.QueryDataauthorizationParticipantRequest,
    ) -> blockchain_models.QueryDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务查询参与方信息
        Summary: 数据授权服务查询参与方信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_dataauthorization_participant_ex(request, headers, runtime)

    async def query_dataauthorization_participant_async(
        self,
        request: blockchain_models.QueryDataauthorizationParticipantRequest,
    ) -> blockchain_models.QueryDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务查询参与方信息
        Summary: 数据授权服务查询参与方信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_dataauthorization_participant_ex_async(request, headers, runtime)

    def query_dataauthorization_participant_ex(
        self,
        request: blockchain_models.QueryDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务查询参与方信息
        Summary: 数据授权服务查询参与方信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_dataauthorization_participant_ex_async(
        self,
        request: blockchain_models.QueryDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务查询参与方信息
        Summary: 数据授权服务查询参与方信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_participant(
        self,
        request: blockchain_models.ListDataauthorizationParticipantRequest,
    ) -> blockchain_models.ListDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务根据角色获取用户列表
        Summary: 数据授权服务根据角色获取用户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_participant_ex(request, headers, runtime)

    async def list_dataauthorization_participant_async(
        self,
        request: blockchain_models.ListDataauthorizationParticipantRequest,
    ) -> blockchain_models.ListDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务根据角色获取用户列表
        Summary: 数据授权服务根据角色获取用户列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_participant_ex_async(request, headers, runtime)

    def list_dataauthorization_participant_ex(
        self,
        request: blockchain_models.ListDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务根据角色获取用户列表
        Summary: 数据授权服务根据角色获取用户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_participant_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationParticipantResponse:
        """
        Description: 数据授权服务根据角色获取用户列表
        Summary: 数据授权服务根据角色获取用户列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_data_entity(
        self,
        request: blockchain_models.CreateDataauthorizationDataEntityRequest,
    ) -> blockchain_models.CreateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务创建数据目录
        Summary: 数据授权服务创建数据目录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_data_entity_ex(request, headers, runtime)

    async def create_dataauthorization_data_entity_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataEntityRequest,
    ) -> blockchain_models.CreateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务创建数据目录
        Summary: 数据授权服务创建数据目录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_data_entity_ex_async(request, headers, runtime)

    def create_dataauthorization_data_entity_ex(
        self,
        request: blockchain_models.CreateDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务创建数据目录
        Summary: 数据授权服务创建数据目录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataEntityResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.entity.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_data_entity_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务创建数据目录
        Summary: 数据授权服务创建数据目录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataEntityResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.entity.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_dataauthorization_data_entity(
        self,
        request: blockchain_models.QueryDataauthorizationDataEntityRequest,
    ) -> blockchain_models.QueryDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务查询数据目录
        Summary: 数据授权服务查询数据目录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_dataauthorization_data_entity_ex(request, headers, runtime)

    async def query_dataauthorization_data_entity_async(
        self,
        request: blockchain_models.QueryDataauthorizationDataEntityRequest,
    ) -> blockchain_models.QueryDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务查询数据目录
        Summary: 数据授权服务查询数据目录
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_dataauthorization_data_entity_ex_async(request, headers, runtime)

    def query_dataauthorization_data_entity_ex(
        self,
        request: blockchain_models.QueryDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务查询数据目录
        Summary: 数据授权服务查询数据目录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDataEntityResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.entity.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_dataauthorization_data_entity_ex_async(
        self,
        request: blockchain_models.QueryDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务查询数据目录
        Summary: 数据授权服务查询数据目录
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDataEntityResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.entity.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_dataauthorization_public_key(
        self,
        request: blockchain_models.UpdateDataauthorizationPublicKeyRequest,
    ) -> blockchain_models.UpdateDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵更新
        Summary: 数据授权服务公钥矩阵更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_dataauthorization_public_key_ex(request, headers, runtime)

    async def update_dataauthorization_public_key_async(
        self,
        request: blockchain_models.UpdateDataauthorizationPublicKeyRequest,
    ) -> blockchain_models.UpdateDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵更新
        Summary: 数据授权服务公钥矩阵更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_dataauthorization_public_key_ex_async(request, headers, runtime)

    def update_dataauthorization_public_key_ex(
        self,
        request: blockchain_models.UpdateDataauthorizationPublicKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵更新
        Summary: 数据授权服务公钥矩阵更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationPublicKeyResponse(),
            self.do_request('1.0', 'baas.dataauthorization.public.key.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_dataauthorization_public_key_ex_async(
        self,
        request: blockchain_models.UpdateDataauthorizationPublicKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵更新
        Summary: 数据授权服务公钥矩阵更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationPublicKeyResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.public.key.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_public_key(
        self,
        request: blockchain_models.ListDataauthorizationPublicKeyRequest,
    ) -> blockchain_models.ListDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵查询
        Summary: 数据授权服务公钥矩阵查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_public_key_ex(request, headers, runtime)

    async def list_dataauthorization_public_key_async(
        self,
        request: blockchain_models.ListDataauthorizationPublicKeyRequest,
    ) -> blockchain_models.ListDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵查询
        Summary: 数据授权服务公钥矩阵查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_public_key_ex_async(request, headers, runtime)

    def list_dataauthorization_public_key_ex(
        self,
        request: blockchain_models.ListDataauthorizationPublicKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵查询
        Summary: 数据授权服务公钥矩阵查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationPublicKeyResponse(),
            self.do_request('1.0', 'baas.dataauthorization.public.key.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_public_key_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationPublicKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationPublicKeyResponse:
        """
        Description: 数据授权服务公钥矩阵查询
        Summary: 数据授权服务公钥矩阵查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationPublicKeyResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.public.key.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def open_dataauthorization_authorization_service(
        self,
        request: blockchain_models.OpenDataauthorizationAuthorizationServiceRequest,
    ) -> blockchain_models.OpenDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务开通服务
        Summary: 数据授权服务开通服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.open_dataauthorization_authorization_service_ex(request, headers, runtime)

    async def open_dataauthorization_authorization_service_async(
        self,
        request: blockchain_models.OpenDataauthorizationAuthorizationServiceRequest,
    ) -> blockchain_models.OpenDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务开通服务
        Summary: 数据授权服务开通服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.open_dataauthorization_authorization_service_ex_async(request, headers, runtime)

    def open_dataauthorization_authorization_service_ex(
        self,
        request: blockchain_models.OpenDataauthorizationAuthorizationServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务开通服务
        Summary: 数据授权服务开通服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenDataauthorizationAuthorizationServiceResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def open_dataauthorization_authorization_service_ex_async(
        self,
        request: blockchain_models.OpenDataauthorizationAuthorizationServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务开通服务
        Summary: 数据授权服务开通服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenDataauthorizationAuthorizationServiceResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def close_dataauthorization_authorization_service(
        self,
        request: blockchain_models.CloseDataauthorizationAuthorizationServiceRequest,
    ) -> blockchain_models.CloseDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务关闭租户服务
        Summary: 数据授权服务关闭租户服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.close_dataauthorization_authorization_service_ex(request, headers, runtime)

    async def close_dataauthorization_authorization_service_async(
        self,
        request: blockchain_models.CloseDataauthorizationAuthorizationServiceRequest,
    ) -> blockchain_models.CloseDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务关闭租户服务
        Summary: 数据授权服务关闭租户服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.close_dataauthorization_authorization_service_ex_async(request, headers, runtime)

    def close_dataauthorization_authorization_service_ex(
        self,
        request: blockchain_models.CloseDataauthorizationAuthorizationServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务关闭租户服务
        Summary: 数据授权服务关闭租户服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseDataauthorizationAuthorizationServiceResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.service.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def close_dataauthorization_authorization_service_ex_async(
        self,
        request: blockchain_models.CloseDataauthorizationAuthorizationServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CloseDataauthorizationAuthorizationServiceResponse:
        """
        Description: 数据授权服务关闭租户服务
        Summary: 数据授权服务关闭租户服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CloseDataauthorizationAuthorizationServiceResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.service.close', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_dataauthorization_authorization(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_dataauthorization_authorization_ex(request, headers, runtime)

    async def apply_dataauthorization_authorization_async(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_dataauthorization_authorization_ex_async(request, headers, runtime)

    def apply_dataauthorization_authorization_ex(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyDataauthorizationAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_dataauthorization_authorization_ex_async(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyDataauthorizationAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_dataauthorization_process(
        self,
        request: blockchain_models.ExecDataauthorizationProcessRequest,
    ) -> blockchain_models.ExecDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_dataauthorization_process_ex(request, headers, runtime)

    async def exec_dataauthorization_process_async(
        self,
        request: blockchain_models.ExecDataauthorizationProcessRequest,
    ) -> blockchain_models.ExecDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_dataauthorization_process_ex_async(request, headers, runtime)

    def exec_dataauthorization_process_ex(
        self,
        request: blockchain_models.ExecDataauthorizationProcessRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecDataauthorizationProcessResponse(),
            self.do_request('1.0', 'baas.dataauthorization.process.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_dataauthorization_process_ex_async(
        self,
        request: blockchain_models.ExecDataauthorizationProcessRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecDataauthorizationProcessResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.process.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def cancel_dataauthorization_authorization(
        self,
        request: blockchain_models.CancelDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.CancelDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务取消授权
        Summary: 数据授权服务取消授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_dataauthorization_authorization_ex(request, headers, runtime)

    async def cancel_dataauthorization_authorization_async(
        self,
        request: blockchain_models.CancelDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.CancelDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务取消授权
        Summary: 数据授权服务取消授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_dataauthorization_authorization_ex_async(request, headers, runtime)

    def cancel_dataauthorization_authorization_ex(
        self,
        request: blockchain_models.CancelDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务取消授权
        Summary: 数据授权服务取消授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelDataauthorizationAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def cancel_dataauthorization_authorization_ex_async(
        self,
        request: blockchain_models.CancelDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CancelDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务取消授权
        Summary: 数据授权服务取消授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CancelDataauthorizationAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.cancel', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def check_dataauthorization_authorization(
        self,
        request: blockchain_models.CheckDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.CheckDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务权限校验
        Summary: 数据授权服务权限校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.check_dataauthorization_authorization_ex(request, headers, runtime)

    async def check_dataauthorization_authorization_async(
        self,
        request: blockchain_models.CheckDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.CheckDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务权限校验
        Summary: 数据授权服务权限校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.check_dataauthorization_authorization_ex_async(request, headers, runtime)

    def check_dataauthorization_authorization_ex(
        self,
        request: blockchain_models.CheckDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务权限校验
        Summary: 数据授权服务权限校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckDataauthorizationAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def check_dataauthorization_authorization_ex_async(
        self,
        request: blockchain_models.CheckDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CheckDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务权限校验
        Summary: 数据授权服务权限校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CheckDataauthorizationAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.check', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_dataauthorization_process(
        self,
        request: blockchain_models.QueryDataauthorizationProcessRequest,
    ) -> blockchain_models.QueryDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程信息查询
        Summary: 数据授权服务流程信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_dataauthorization_process_ex(request, headers, runtime)

    async def query_dataauthorization_process_async(
        self,
        request: blockchain_models.QueryDataauthorizationProcessRequest,
    ) -> blockchain_models.QueryDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程信息查询
        Summary: 数据授权服务流程信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_dataauthorization_process_ex_async(request, headers, runtime)

    def query_dataauthorization_process_ex(
        self,
        request: blockchain_models.QueryDataauthorizationProcessRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程信息查询
        Summary: 数据授权服务流程信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationProcessResponse(),
            self.do_request('1.0', 'baas.dataauthorization.process.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_dataauthorization_process_ex_async(
        self,
        request: blockchain_models.QueryDataauthorizationProcessRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationProcessResponse:
        """
        Description: 数据授权服务流程信息查询
        Summary: 数据授权服务流程信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationProcessResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.process.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def send_dataauthorization_deposit_data(
        self,
        request: blockchain_models.SendDataauthorizationDepositDataRequest,
    ) -> blockchain_models.SendDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务存证数据上链
        Summary: 数据授权服务存证数据上链
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.send_dataauthorization_deposit_data_ex(request, headers, runtime)

    async def send_dataauthorization_deposit_data_async(
        self,
        request: blockchain_models.SendDataauthorizationDepositDataRequest,
    ) -> blockchain_models.SendDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务存证数据上链
        Summary: 数据授权服务存证数据上链
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.send_dataauthorization_deposit_data_ex_async(request, headers, runtime)

    def send_dataauthorization_deposit_data_ex(
        self,
        request: blockchain_models.SendDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务存证数据上链
        Summary: 数据授权服务存证数据上链
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendDataauthorizationDepositDataResponse(),
            self.do_request('1.0', 'baas.dataauthorization.deposit.data.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def send_dataauthorization_deposit_data_ex_async(
        self,
        request: blockchain_models.SendDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SendDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务存证数据上链
        Summary: 数据授权服务存证数据上链
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SendDataauthorizationDepositDataResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.deposit.data.send', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_dataauthorization_deposit_data(
        self,
        request: blockchain_models.QueryDataauthorizationDepositDataRequest,
    ) -> blockchain_models.QueryDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务查询存证数据
        Summary: 数据授权服务查询存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_dataauthorization_deposit_data_ex(request, headers, runtime)

    async def query_dataauthorization_deposit_data_async(
        self,
        request: blockchain_models.QueryDataauthorizationDepositDataRequest,
    ) -> blockchain_models.QueryDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务查询存证数据
        Summary: 数据授权服务查询存证数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_dataauthorization_deposit_data_ex_async(request, headers, runtime)

    def query_dataauthorization_deposit_data_ex(
        self,
        request: blockchain_models.QueryDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务查询存证数据
        Summary: 数据授权服务查询存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDepositDataResponse(),
            self.do_request('1.0', 'baas.dataauthorization.deposit.data.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_dataauthorization_deposit_data_ex_async(
        self,
        request: blockchain_models.QueryDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDepositDataResponse:
        """
        Description: 数据授权服务查询存证数据
        Summary: 数据授权服务查询存证数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDepositDataResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.deposit.data.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def resume_dataauthorization_authorization(
        self,
        request: blockchain_models.ResumeDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.ResumeDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务恢复权限
        Summary: 数据授权服务恢复权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.resume_dataauthorization_authorization_ex(request, headers, runtime)

    async def resume_dataauthorization_authorization_async(
        self,
        request: blockchain_models.ResumeDataauthorizationAuthorizationRequest,
    ) -> blockchain_models.ResumeDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务恢复权限
        Summary: 数据授权服务恢复权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.resume_dataauthorization_authorization_ex_async(request, headers, runtime)

    def resume_dataauthorization_authorization_ex(
        self,
        request: blockchain_models.ResumeDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ResumeDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务恢复权限
        Summary: 数据授权服务恢复权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ResumeDataauthorizationAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.resume', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def resume_dataauthorization_authorization_ex_async(
        self,
        request: blockchain_models.ResumeDataauthorizationAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ResumeDataauthorizationAuthorizationResponse:
        """
        Description: 数据授权服务恢复权限
        Summary: 数据授权服务恢复权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ResumeDataauthorizationAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.resume', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_dataauthorization_data_entity(
        self,
        request: blockchain_models.UpdateDataauthorizationDataEntityRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务更新数据信息
        Summary: 数据授权服务更新数据信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_dataauthorization_data_entity_ex(request, headers, runtime)

    async def update_dataauthorization_data_entity_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataEntityRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务更新数据信息
        Summary: 数据授权服务更新数据信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_dataauthorization_data_entity_ex_async(request, headers, runtime)

    def update_dataauthorization_data_entity_ex(
        self,
        request: blockchain_models.UpdateDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务更新数据信息
        Summary: 数据授权服务更新数据信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataEntityResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.entity.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_dataauthorization_data_entity_ex_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务更新数据信息
        Summary: 数据授权服务更新数据信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataEntityResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.entity.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_dataauthorization_data_entity(
        self,
        request: blockchain_models.DeleteDataauthorizationDataEntityRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务删除数据对象
        Summary: 数据授权服务删除数据对象
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_dataauthorization_data_entity_ex(request, headers, runtime)

    async def delete_dataauthorization_data_entity_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataEntityRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务删除数据对象
        Summary: 数据授权服务删除数据对象
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_dataauthorization_data_entity_ex_async(request, headers, runtime)

    def delete_dataauthorization_data_entity_ex(
        self,
        request: blockchain_models.DeleteDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务删除数据对象
        Summary: 数据授权服务删除数据对象
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataEntityResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.entity.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_dataauthorization_data_entity_ex_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataEntityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataEntityResponse:
        """
        Description: 数据授权服务删除数据对象
        Summary: 数据授权服务删除数据对象
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataEntityResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.entity.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_custom_participant(
        self,
        request: blockchain_models.CreateDataauthorizationCustomParticipantRequest,
    ) -> blockchain_models.CreateDataauthorizationCustomParticipantResponse:
        """
        Description: 数据授权服务创建自定义ID用户
        Summary: 数据授权服务创建自定义ID用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_custom_participant_ex(request, headers, runtime)

    async def create_dataauthorization_custom_participant_async(
        self,
        request: blockchain_models.CreateDataauthorizationCustomParticipantRequest,
    ) -> blockchain_models.CreateDataauthorizationCustomParticipantResponse:
        """
        Description: 数据授权服务创建自定义ID用户
        Summary: 数据授权服务创建自定义ID用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_custom_participant_ex_async(request, headers, runtime)

    def create_dataauthorization_custom_participant_ex(
        self,
        request: blockchain_models.CreateDataauthorizationCustomParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationCustomParticipantResponse:
        """
        Description: 数据授权服务创建自定义ID用户
        Summary: 数据授权服务创建自定义ID用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationCustomParticipantResponse(),
            self.do_request('1.0', 'baas.dataauthorization.custom.participant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_custom_participant_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationCustomParticipantRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationCustomParticipantResponse:
        """
        Description: 数据授权服务创建自定义ID用户
        Summary: 数据授权服务创建自定义ID用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationCustomParticipantResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.custom.participant.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_custom_data(
        self,
        request: blockchain_models.CreateDataauthorizationCustomDataRequest,
    ) -> blockchain_models.CreateDataauthorizationCustomDataResponse:
        """
        Description: 数据授权服务创建自定义ID数据对象
        Summary: 数据授权服务创建自定义ID数据对象
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_custom_data_ex(request, headers, runtime)

    async def create_dataauthorization_custom_data_async(
        self,
        request: blockchain_models.CreateDataauthorizationCustomDataRequest,
    ) -> blockchain_models.CreateDataauthorizationCustomDataResponse:
        """
        Description: 数据授权服务创建自定义ID数据对象
        Summary: 数据授权服务创建自定义ID数据对象
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_custom_data_ex_async(request, headers, runtime)

    def create_dataauthorization_custom_data_ex(
        self,
        request: blockchain_models.CreateDataauthorizationCustomDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationCustomDataResponse:
        """
        Description: 数据授权服务创建自定义ID数据对象
        Summary: 数据授权服务创建自定义ID数据对象
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationCustomDataResponse(),
            self.do_request('1.0', 'baas.dataauthorization.custom.data.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_custom_data_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationCustomDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationCustomDataResponse:
        """
        Description: 数据授权服务创建自定义ID数据对象
        Summary: 数据授权服务创建自定义ID数据对象
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationCustomDataResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.custom.data.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_dataauthorization_authorization_withsignature(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureRequest,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_dataauthorization_authorization_withsignature_ex(request, headers, runtime)

    async def apply_dataauthorization_authorization_withsignature_async(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureRequest,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_dataauthorization_authorization_withsignature_ex_async(request, headers, runtime)

    def apply_dataauthorization_authorization_withsignature_ex(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.withsignature.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_dataauthorization_authorization_withsignature_ex_async(
        self,
        request: blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse:
        """
        Description: 数据授权服务申请权限
        Summary: 数据授权服务申请权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyDataauthorizationAuthorizationWithsignatureResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.withsignature.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_dataauthorization_process_withsignature(
        self,
        request: blockchain_models.ExecDataauthorizationProcessWithsignatureRequest,
    ) -> blockchain_models.ExecDataauthorizationProcessWithsignatureResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_dataauthorization_process_withsignature_ex(request, headers, runtime)

    async def exec_dataauthorization_process_withsignature_async(
        self,
        request: blockchain_models.ExecDataauthorizationProcessWithsignatureRequest,
    ) -> blockchain_models.ExecDataauthorizationProcessWithsignatureResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_dataauthorization_process_withsignature_ex_async(request, headers, runtime)

    def exec_dataauthorization_process_withsignature_ex(
        self,
        request: blockchain_models.ExecDataauthorizationProcessWithsignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecDataauthorizationProcessWithsignatureResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecDataauthorizationProcessWithsignatureResponse(),
            self.do_request('1.0', 'baas.dataauthorization.process.withsignature.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_dataauthorization_process_withsignature_ex_async(
        self,
        request: blockchain_models.ExecDataauthorizationProcessWithsignatureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecDataauthorizationProcessWithsignatureResponse:
        """
        Description: 数据授权服务流程步骤处理
        Summary: 数据授权服务流程步骤处理
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecDataauthorizationProcessWithsignatureResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.process.withsignature.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_data_model(
        self,
        request: blockchain_models.CreateDataauthorizationDataModelRequest,
    ) -> blockchain_models.CreateDataauthorizationDataModelResponse:
        """
        Description: 创建数据模型
        Summary: 创建数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_data_model_ex(request, headers, runtime)

    async def create_dataauthorization_data_model_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataModelRequest,
    ) -> blockchain_models.CreateDataauthorizationDataModelResponse:
        """
        Description: 创建数据模型
        Summary: 创建数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_data_model_ex_async(request, headers, runtime)

    def create_dataauthorization_data_model_ex(
        self,
        request: blockchain_models.CreateDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataModelResponse:
        """
        Description: 创建数据模型
        Summary: 创建数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataModelResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.model.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_data_model_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataModelResponse:
        """
        Description: 创建数据模型
        Summary: 创建数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataModelResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.model.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_dataauthorization_data_model(
        self,
        request: blockchain_models.UpdateDataauthorizationDataModelRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataModelResponse:
        """
        Description: 数据模型修改
        Summary: 数据模型修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_dataauthorization_data_model_ex(request, headers, runtime)

    async def update_dataauthorization_data_model_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataModelRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataModelResponse:
        """
        Description: 数据模型修改
        Summary: 数据模型修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_dataauthorization_data_model_ex_async(request, headers, runtime)

    def update_dataauthorization_data_model_ex(
        self,
        request: blockchain_models.UpdateDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataModelResponse:
        """
        Description: 数据模型修改
        Summary: 数据模型修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataModelResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.model.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_dataauthorization_data_model_ex_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataModelResponse:
        """
        Description: 数据模型修改
        Summary: 数据模型修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataModelResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.model.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_dataauthorization_data_model(
        self,
        request: blockchain_models.DeleteDataauthorizationDataModelRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataModelResponse:
        """
        Description: 删除数据模型
        Summary: 删除数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_dataauthorization_data_model_ex(request, headers, runtime)

    async def delete_dataauthorization_data_model_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataModelRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataModelResponse:
        """
        Description: 删除数据模型
        Summary: 删除数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_dataauthorization_data_model_ex_async(request, headers, runtime)

    def delete_dataauthorization_data_model_ex(
        self,
        request: blockchain_models.DeleteDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataModelResponse:
        """
        Description: 删除数据模型
        Summary: 删除数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataModelResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.model.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_dataauthorization_data_model_ex_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataModelResponse:
        """
        Description: 删除数据模型
        Summary: 删除数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataModelResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.model.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_participant_page(
        self,
        request: blockchain_models.ListDataauthorizationParticipantPageRequest,
    ) -> blockchain_models.ListDataauthorizationParticipantPageResponse:
        """
        Description: 分页查询参与方列表
        Summary: 分页查询参与方列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_participant_page_ex(request, headers, runtime)

    async def list_dataauthorization_participant_page_async(
        self,
        request: blockchain_models.ListDataauthorizationParticipantPageRequest,
    ) -> blockchain_models.ListDataauthorizationParticipantPageResponse:
        """
        Description: 分页查询参与方列表
        Summary: 分页查询参与方列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_participant_page_ex_async(request, headers, runtime)

    def list_dataauthorization_participant_page_ex(
        self,
        request: blockchain_models.ListDataauthorizationParticipantPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationParticipantPageResponse:
        """
        Description: 分页查询参与方列表
        Summary: 分页查询参与方列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationParticipantPageResponse(),
            self.do_request('1.0', 'baas.dataauthorization.participant.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_participant_page_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationParticipantPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationParticipantPageResponse:
        """
        Description: 分页查询参与方列表
        Summary: 分页查询参与方列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationParticipantPageResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.participant.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_dataauthorization_data_model(
        self,
        request: blockchain_models.QueryDataauthorizationDataModelRequest,
    ) -> blockchain_models.QueryDataauthorizationDataModelResponse:
        """
        Description: 查询数据模型
        Summary: 查询数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_dataauthorization_data_model_ex(request, headers, runtime)

    async def query_dataauthorization_data_model_async(
        self,
        request: blockchain_models.QueryDataauthorizationDataModelRequest,
    ) -> blockchain_models.QueryDataauthorizationDataModelResponse:
        """
        Description: 查询数据模型
        Summary: 查询数据模型
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_dataauthorization_data_model_ex_async(request, headers, runtime)

    def query_dataauthorization_data_model_ex(
        self,
        request: blockchain_models.QueryDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDataModelResponse:
        """
        Description: 查询数据模型
        Summary: 查询数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDataModelResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.model.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_dataauthorization_data_model_ex_async(
        self,
        request: blockchain_models.QueryDataauthorizationDataModelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDataauthorizationDataModelResponse:
        """
        Description: 查询数据模型
        Summary: 查询数据模型
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDataauthorizationDataModelResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.model.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_datamodel_page(
        self,
        request: blockchain_models.ListDataauthorizationDatamodelPageRequest,
    ) -> blockchain_models.ListDataauthorizationDatamodelPageResponse:
        """
        Description: 数据模型分页查询
        Summary: 数据模型分页查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_datamodel_page_ex(request, headers, runtime)

    async def list_dataauthorization_datamodel_page_async(
        self,
        request: blockchain_models.ListDataauthorizationDatamodelPageRequest,
    ) -> blockchain_models.ListDataauthorizationDatamodelPageResponse:
        """
        Description: 数据模型分页查询
        Summary: 数据模型分页查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_datamodel_page_ex_async(request, headers, runtime)

    def list_dataauthorization_datamodel_page_ex(
        self,
        request: blockchain_models.ListDataauthorizationDatamodelPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationDatamodelPageResponse:
        """
        Description: 数据模型分页查询
        Summary: 数据模型分页查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationDatamodelPageResponse(),
            self.do_request('1.0', 'baas.dataauthorization.datamodel.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_datamodel_page_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationDatamodelPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationDatamodelPageResponse:
        """
        Description: 数据模型分页查询
        Summary: 数据模型分页查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationDatamodelPageResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.datamodel.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_available_datamodel(
        self,
        request: blockchain_models.ListDataauthorizationAvailableDatamodelRequest,
    ) -> blockchain_models.ListDataauthorizationAvailableDatamodelResponse:
        """
        Description: 查询可注册的数据模型列表
        Summary: 查询可注册的数据模型列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_available_datamodel_ex(request, headers, runtime)

    async def list_dataauthorization_available_datamodel_async(
        self,
        request: blockchain_models.ListDataauthorizationAvailableDatamodelRequest,
    ) -> blockchain_models.ListDataauthorizationAvailableDatamodelResponse:
        """
        Description: 查询可注册的数据模型列表
        Summary: 查询可注册的数据模型列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_available_datamodel_ex_async(request, headers, runtime)

    def list_dataauthorization_available_datamodel_ex(
        self,
        request: blockchain_models.ListDataauthorizationAvailableDatamodelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAvailableDatamodelResponse:
        """
        Description: 查询可注册的数据模型列表
        Summary: 查询可注册的数据模型列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAvailableDatamodelResponse(),
            self.do_request('1.0', 'baas.dataauthorization.available.datamodel.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_available_datamodel_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationAvailableDatamodelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAvailableDatamodelResponse:
        """
        Description: 查询可注册的数据模型列表
        Summary: 查询可注册的数据模型列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAvailableDatamodelResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.available.datamodel.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_dataentity_page(
        self,
        request: blockchain_models.ListDataauthorizationDataentityPageRequest,
    ) -> blockchain_models.ListDataauthorizationDataentityPageResponse:
        """
        Description: 根据模型名称、授权状态分页查询。
        Summary: 数据注册情况查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_dataentity_page_ex(request, headers, runtime)

    async def list_dataauthorization_dataentity_page_async(
        self,
        request: blockchain_models.ListDataauthorizationDataentityPageRequest,
    ) -> blockchain_models.ListDataauthorizationDataentityPageResponse:
        """
        Description: 根据模型名称、授权状态分页查询。
        Summary: 数据注册情况查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_dataentity_page_ex_async(request, headers, runtime)

    def list_dataauthorization_dataentity_page_ex(
        self,
        request: blockchain_models.ListDataauthorizationDataentityPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationDataentityPageResponse:
        """
        Description: 根据模型名称、授权状态分页查询。
        Summary: 数据注册情况查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationDataentityPageResponse(),
            self.do_request('1.0', 'baas.dataauthorization.dataentity.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_dataentity_page_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationDataentityPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationDataentityPageResponse:
        """
        Description: 根据模型名称、授权状态分页查询。
        Summary: 数据注册情况查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationDataentityPageResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.dataentity.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_direct_authorization(
        self,
        request: blockchain_models.CreateDataauthorizationDirectAuthorizationRequest,
    ) -> blockchain_models.CreateDataauthorizationDirectAuthorizationResponse:
        """
        Description: 直接授权接口
        Summary: 直接授权接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_direct_authorization_ex(request, headers, runtime)

    async def create_dataauthorization_direct_authorization_async(
        self,
        request: blockchain_models.CreateDataauthorizationDirectAuthorizationRequest,
    ) -> blockchain_models.CreateDataauthorizationDirectAuthorizationResponse:
        """
        Description: 直接授权接口
        Summary: 直接授权接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_direct_authorization_ex_async(request, headers, runtime)

    def create_dataauthorization_direct_authorization_ex(
        self,
        request: blockchain_models.CreateDataauthorizationDirectAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDirectAuthorizationResponse:
        """
        Description: 直接授权接口
        Summary: 直接授权接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDirectAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.direct.authorization.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_direct_authorization_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationDirectAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDirectAuthorizationResponse:
        """
        Description: 直接授权接口
        Summary: 直接授权接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDirectAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.direct.authorization.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_authorization_page(
        self,
        request: blockchain_models.ListDataauthorizationAuthorizationPageRequest,
    ) -> blockchain_models.ListDataauthorizationAuthorizationPageResponse:
        """
        Description: 授权列表分页查询
        Summary: 授权列表分页查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_authorization_page_ex(request, headers, runtime)

    async def list_dataauthorization_authorization_page_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthorizationPageRequest,
    ) -> blockchain_models.ListDataauthorizationAuthorizationPageResponse:
        """
        Description: 授权列表分页查询
        Summary: 授权列表分页查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_authorization_page_ex_async(request, headers, runtime)

    def list_dataauthorization_authorization_page_ex(
        self,
        request: blockchain_models.ListDataauthorizationAuthorizationPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthorizationPageResponse:
        """
        Description: 授权列表分页查询
        Summary: 授权列表分页查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthorizationPageResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authorization.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_authorization_page_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthorizationPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthorizationPageResponse:
        """
        Description: 授权列表分页查询
        Summary: 授权列表分页查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthorizationPageResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authorization.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_authparticipant_page(
        self,
        request: blockchain_models.ListDataauthorizationAuthparticipantPageRequest,
    ) -> blockchain_models.ListDataauthorizationAuthparticipantPageResponse:
        """
        Description: 查询已授权的参与方列表
        Summary: 查询已授权的参与方列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_authparticipant_page_ex(request, headers, runtime)

    async def list_dataauthorization_authparticipant_page_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthparticipantPageRequest,
    ) -> blockchain_models.ListDataauthorizationAuthparticipantPageResponse:
        """
        Description: 查询已授权的参与方列表
        Summary: 查询已授权的参与方列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_authparticipant_page_ex_async(request, headers, runtime)

    def list_dataauthorization_authparticipant_page_ex(
        self,
        request: blockchain_models.ListDataauthorizationAuthparticipantPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthparticipantPageResponse:
        """
        Description: 查询已授权的参与方列表
        Summary: 查询已授权的参与方列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthparticipantPageResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authparticipant.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_authparticipant_page_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthparticipantPageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthparticipantPageResponse:
        """
        Description: 查询已授权的参与方列表
        Summary: 查询已授权的参与方列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthparticipantPageResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authparticipant.page.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_data_assert(
        self,
        request: blockchain_models.CreateDataauthorizationDataAssertRequest,
    ) -> blockchain_models.CreateDataauthorizationDataAssertResponse:
        """
        Description: 创建数据资产
        Summary: 创建数据资产
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_data_assert_ex(request, headers, runtime)

    async def create_dataauthorization_data_assert_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataAssertRequest,
    ) -> blockchain_models.CreateDataauthorizationDataAssertResponse:
        """
        Description: 创建数据资产
        Summary: 创建数据资产
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_data_assert_ex_async(request, headers, runtime)

    def create_dataauthorization_data_assert_ex(
        self,
        request: blockchain_models.CreateDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataAssertResponse:
        """
        Description: 创建数据资产
        Summary: 创建数据资产
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataAssertResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.assert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_data_assert_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationDataAssertResponse:
        """
        Description: 创建数据资产
        Summary: 创建数据资产
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationDataAssertResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.assert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_dataauthorization_data_assert(
        self,
        request: blockchain_models.UpdateDataauthorizationDataAssertRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataAssertResponse:
        """
        Description: 数据资产更新
        Summary: 数据资产更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_dataauthorization_data_assert_ex(request, headers, runtime)

    async def update_dataauthorization_data_assert_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataAssertRequest,
    ) -> blockchain_models.UpdateDataauthorizationDataAssertResponse:
        """
        Description: 数据资产更新
        Summary: 数据资产更新
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_dataauthorization_data_assert_ex_async(request, headers, runtime)

    def update_dataauthorization_data_assert_ex(
        self,
        request: blockchain_models.UpdateDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataAssertResponse:
        """
        Description: 数据资产更新
        Summary: 数据资产更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataAssertResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.assert.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_dataauthorization_data_assert_ex_async(
        self,
        request: blockchain_models.UpdateDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDataauthorizationDataAssertResponse:
        """
        Description: 数据资产更新
        Summary: 数据资产更新
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDataauthorizationDataAssertResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.assert.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_dataauthorization_data_assert(
        self,
        request: blockchain_models.DeleteDataauthorizationDataAssertRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataAssertResponse:
        """
        Description: 数据资产删除
        Summary: 数据资产删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_dataauthorization_data_assert_ex(request, headers, runtime)

    async def delete_dataauthorization_data_assert_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataAssertRequest,
    ) -> blockchain_models.DeleteDataauthorizationDataAssertResponse:
        """
        Description: 数据资产删除
        Summary: 数据资产删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_dataauthorization_data_assert_ex_async(request, headers, runtime)

    def delete_dataauthorization_data_assert_ex(
        self,
        request: blockchain_models.DeleteDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataAssertResponse:
        """
        Description: 数据资产删除
        Summary: 数据资产删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataAssertResponse(),
            self.do_request('1.0', 'baas.dataauthorization.data.assert.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_dataauthorization_data_assert_ex_async(
        self,
        request: blockchain_models.DeleteDataauthorizationDataAssertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteDataauthorizationDataAssertResponse:
        """
        Description: 数据资产删除
        Summary: 数据资产删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteDataauthorizationDataAssertResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.data.assert.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_dataauthorization_agent_authorization(
        self,
        request: blockchain_models.CreateDataauthorizationAgentAuthorizationRequest,
    ) -> blockchain_models.CreateDataauthorizationAgentAuthorizationResponse:
        """
        Description: 授权服务代理授权接口
        Summary: 代理授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_dataauthorization_agent_authorization_ex(request, headers, runtime)

    async def create_dataauthorization_agent_authorization_async(
        self,
        request: blockchain_models.CreateDataauthorizationAgentAuthorizationRequest,
    ) -> blockchain_models.CreateDataauthorizationAgentAuthorizationResponse:
        """
        Description: 授权服务代理授权接口
        Summary: 代理授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_dataauthorization_agent_authorization_ex_async(request, headers, runtime)

    def create_dataauthorization_agent_authorization_ex(
        self,
        request: blockchain_models.CreateDataauthorizationAgentAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationAgentAuthorizationResponse:
        """
        Description: 授权服务代理授权接口
        Summary: 代理授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationAgentAuthorizationResponse(),
            self.do_request('1.0', 'baas.dataauthorization.agent.authorization.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_dataauthorization_agent_authorization_ex_async(
        self,
        request: blockchain_models.CreateDataauthorizationAgentAuthorizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateDataauthorizationAgentAuthorizationResponse:
        """
        Description: 授权服务代理授权接口
        Summary: 代理授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateDataauthorizationAgentAuthorizationResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.agent.authorization.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_dataauthorization_authority_cert(
        self,
        request: blockchain_models.ListDataauthorizationAuthorityCertRequest,
    ) -> blockchain_models.ListDataauthorizationAuthorityCertResponse:
        """
        Description:  授权列表相信信息查询
        Summary:  授权列表相信信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_dataauthorization_authority_cert_ex(request, headers, runtime)

    async def list_dataauthorization_authority_cert_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthorityCertRequest,
    ) -> blockchain_models.ListDataauthorizationAuthorityCertResponse:
        """
        Description:  授权列表相信信息查询
        Summary:  授权列表相信信息查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_dataauthorization_authority_cert_ex_async(request, headers, runtime)

    def list_dataauthorization_authority_cert_ex(
        self,
        request: blockchain_models.ListDataauthorizationAuthorityCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthorityCertResponse:
        """
        Description:  授权列表相信信息查询
        Summary:  授权列表相信信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthorityCertResponse(),
            self.do_request('1.0', 'baas.dataauthorization.authority.cert.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_dataauthorization_authority_cert_ex_async(
        self,
        request: blockchain_models.ListDataauthorizationAuthorityCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListDataauthorizationAuthorityCertResponse:
        """
        Description:  授权列表相信信息查询
        Summary:  授权列表相信信息查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListDataauthorizationAuthorityCertResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.authority.cert.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_dataauthorization_deposit_data(
        self,
        request: blockchain_models.SaveDataauthorizationDepositDataRequest,
    ) -> blockchain_models.SaveDataauthorizationDepositDataResponse:
        """
        Description: 同步存证上链接口
        Summary: 同步存证上链
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_dataauthorization_deposit_data_ex(request, headers, runtime)

    async def save_dataauthorization_deposit_data_async(
        self,
        request: blockchain_models.SaveDataauthorizationDepositDataRequest,
    ) -> blockchain_models.SaveDataauthorizationDepositDataResponse:
        """
        Description: 同步存证上链接口
        Summary: 同步存证上链
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_dataauthorization_deposit_data_ex_async(request, headers, runtime)

    def save_dataauthorization_deposit_data_ex(
        self,
        request: blockchain_models.SaveDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveDataauthorizationDepositDataResponse:
        """
        Description: 同步存证上链接口
        Summary: 同步存证上链
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveDataauthorizationDepositDataResponse(),
            self.do_request('1.0', 'baas.dataauthorization.deposit.data.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_dataauthorization_deposit_data_ex_async(
        self,
        request: blockchain_models.SaveDataauthorizationDepositDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveDataauthorizationDepositDataResponse:
        """
        Description: 同步存证上链接口
        Summary: 同步存证上链
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveDataauthorizationDepositDataResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.deposit.data.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_dataauthorization_sync_data(
        self,
        request: blockchain_models.StartDataauthorizationSyncDataRequest,
    ) -> blockchain_models.StartDataauthorizationSyncDataResponse:
        """
        Description: 启动全量同步
        Summary: 启动全量同步
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_dataauthorization_sync_data_ex(request, headers, runtime)

    async def start_dataauthorization_sync_data_async(
        self,
        request: blockchain_models.StartDataauthorizationSyncDataRequest,
    ) -> blockchain_models.StartDataauthorizationSyncDataResponse:
        """
        Description: 启动全量同步
        Summary: 启动全量同步
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_dataauthorization_sync_data_ex_async(request, headers, runtime)

    def start_dataauthorization_sync_data_ex(
        self,
        request: blockchain_models.StartDataauthorizationSyncDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDataauthorizationSyncDataResponse:
        """
        Description: 启动全量同步
        Summary: 启动全量同步
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDataauthorizationSyncDataResponse(),
            self.do_request('1.0', 'baas.dataauthorization.sync.data.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_dataauthorization_sync_data_ex_async(
        self,
        request: blockchain_models.StartDataauthorizationSyncDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDataauthorizationSyncDataResponse:
        """
        Description: 启动全量同步
        Summary: 启动全量同步
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDataauthorizationSyncDataResponse(),
            await self.do_request_async('1.0', 'baas.dataauthorization.sync.data.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_traceability_tx_check(
        self,
        request: blockchain_models.QueryTraceabilityTxCheckRequest,
    ) -> blockchain_models.QueryTraceabilityTxCheckResponse:
        """
        Description: 通过额交易hash查询，返回hash对应区块链上信息。
        Summary: 溯源区块查证接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_traceability_tx_check_ex(request, headers, runtime)

    async def query_traceability_tx_check_async(
        self,
        request: blockchain_models.QueryTraceabilityTxCheckRequest,
    ) -> blockchain_models.QueryTraceabilityTxCheckResponse:
        """
        Description: 通过额交易hash查询，返回hash对应区块链上信息。
        Summary: 溯源区块查证接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_traceability_tx_check_ex_async(request, headers, runtime)

    def query_traceability_tx_check_ex(
        self,
        request: blockchain_models.QueryTraceabilityTxCheckRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryTraceabilityTxCheckResponse:
        """
        Description: 通过额交易hash查询，返回hash对应区块链上信息。
        Summary: 溯源区块查证接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryTraceabilityTxCheckResponse(),
            self.do_request('1.0', 'baas.traceability.tx.check.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_traceability_tx_check_ex_async(
        self,
        request: blockchain_models.QueryTraceabilityTxCheckRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryTraceabilityTxCheckResponse:
        """
        Description: 通过额交易hash查询，返回hash对应区块链上信息。
        Summary: 溯源区块查证接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryTraceabilityTxCheckResponse(),
            await self.do_request_async('1.0', 'baas.traceability.tx.check.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_traceability_blockchain_infos(
        self,
        request: blockchain_models.QueryTraceabilityBlockchainInfosRequest,
    ) -> blockchain_models.QueryTraceabilityBlockchainInfosResponse:
        """
        Description: 通过链id，获取链的相关信息
        Summary: 获取链信息接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_traceability_blockchain_infos_ex(request, headers, runtime)

    async def query_traceability_blockchain_infos_async(
        self,
        request: blockchain_models.QueryTraceabilityBlockchainInfosRequest,
    ) -> blockchain_models.QueryTraceabilityBlockchainInfosResponse:
        """
        Description: 通过链id，获取链的相关信息
        Summary: 获取链信息接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_traceability_blockchain_infos_ex_async(request, headers, runtime)

    def query_traceability_blockchain_infos_ex(
        self,
        request: blockchain_models.QueryTraceabilityBlockchainInfosRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryTraceabilityBlockchainInfosResponse:
        """
        Description: 通过链id，获取链的相关信息
        Summary: 获取链信息接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryTraceabilityBlockchainInfosResponse(),
            self.do_request('1.0', 'baas.traceability.blockchain.infos.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_traceability_blockchain_infos_ex_async(
        self,
        request: blockchain_models.QueryTraceabilityBlockchainInfosRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryTraceabilityBlockchainInfosResponse:
        """
        Description: 通过链id，获取链的相关信息
        Summary: 获取链信息接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryTraceabilityBlockchainInfosResponse(),
            await self.do_request_async('1.0', 'baas.traceability.blockchain.infos.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_blockchain_browser_privilege(
        self,
        request: blockchain_models.SaveBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.SaveBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器添加租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_blockchain_browser_privilege_ex(request, headers, runtime)

    async def save_blockchain_browser_privilege_async(
        self,
        request: blockchain_models.SaveBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.SaveBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器添加租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_blockchain_browser_privilege_ex_async(request, headers, runtime)

    def save_blockchain_browser_privilege_ex(
        self,
        request: blockchain_models.SaveBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器添加租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBlockchainBrowserPrivilegeResponse(),
            self.do_request('1.0', 'baas.blockchain.browser.privilege.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_blockchain_browser_privilege_ex_async(
        self,
        request: blockchain_models.SaveBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器添加租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveBlockchainBrowserPrivilegeResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.browser.privilege.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_blockchain_browser_privilege(
        self,
        request: blockchain_models.QueryBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.QueryBlockchainBrowserPrivilegeResponse:
        """
        Description: 查询租户查看某链的权限
        Summary: 查询租户查看某链的权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_blockchain_browser_privilege_ex(request, headers, runtime)

    async def query_blockchain_browser_privilege_async(
        self,
        request: blockchain_models.QueryBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.QueryBlockchainBrowserPrivilegeResponse:
        """
        Description: 查询租户查看某链的权限
        Summary: 查询租户查看某链的权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_blockchain_browser_privilege_ex_async(request, headers, runtime)

    def query_blockchain_browser_privilege_ex(
        self,
        request: blockchain_models.QueryBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainBrowserPrivilegeResponse:
        """
        Description: 查询租户查看某链的权限
        Summary: 查询租户查看某链的权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainBrowserPrivilegeResponse(),
            self.do_request('1.0', 'baas.blockchain.browser.privilege.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_blockchain_browser_privilege_ex_async(
        self,
        request: blockchain_models.QueryBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainBrowserPrivilegeResponse:
        """
        Description: 查询租户查看某链的权限
        Summary: 查询租户查看某链的权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainBrowserPrivilegeResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.browser.privilege.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_blockchain_browser_privilege(
        self,
        request: blockchain_models.DeleteBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.DeleteBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器删除租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_blockchain_browser_privilege_ex(request, headers, runtime)

    async def delete_blockchain_browser_privilege_async(
        self,
        request: blockchain_models.DeleteBlockchainBrowserPrivilegeRequest,
    ) -> blockchain_models.DeleteBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器删除租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_blockchain_browser_privilege_ex_async(request, headers, runtime)

    def delete_blockchain_browser_privilege_ex(
        self,
        request: blockchain_models.DeleteBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器删除租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteBlockchainBrowserPrivilegeResponse(),
            self.do_request('1.0', 'baas.blockchain.browser.privilege.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_blockchain_browser_privilege_ex_async(
        self,
        request: blockchain_models.DeleteBlockchainBrowserPrivilegeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteBlockchainBrowserPrivilegeResponse:
        """
        Description: BaaS区块链浏览器删除租户与链的访问权限
        Summary: BaaS区块链浏览器添加权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteBlockchainBrowserPrivilegeResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.browser.privilege.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_blockchain_miniprogram(
        self,
        request: blockchain_models.GetBlockchainMiniprogramRequest,
    ) -> blockchain_models.GetBlockchainMiniprogramResponse:
        """
        Description: 生成蚂蚁区块链的交易二维码
        Summary: 数科生成蚂蚁区块链的交易二维码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_blockchain_miniprogram_ex(request, headers, runtime)

    async def get_blockchain_miniprogram_async(
        self,
        request: blockchain_models.GetBlockchainMiniprogramRequest,
    ) -> blockchain_models.GetBlockchainMiniprogramResponse:
        """
        Description: 生成蚂蚁区块链的交易二维码
        Summary: 数科生成蚂蚁区块链的交易二维码
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_blockchain_miniprogram_ex_async(request, headers, runtime)

    def get_blockchain_miniprogram_ex(
        self,
        request: blockchain_models.GetBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetBlockchainMiniprogramResponse:
        """
        Description: 生成蚂蚁区块链的交易二维码
        Summary: 数科生成蚂蚁区块链的交易二维码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetBlockchainMiniprogramResponse(),
            self.do_request('1.0', 'baas.blockchain.miniprogram.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_blockchain_miniprogram_ex_async(
        self,
        request: blockchain_models.GetBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetBlockchainMiniprogramResponse:
        """
        Description: 生成蚂蚁区块链的交易二维码
        Summary: 数科生成蚂蚁区块链的交易二维码
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetBlockchainMiniprogramResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.miniprogram.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def add_blockchain_miniprogram(
        self,
        request: blockchain_models.AddBlockchainMiniprogramRequest,
    ) -> blockchain_models.AddBlockchainMiniprogramResponse:
        """
        Description: 蚂蚁区块链的链上交易数据查看权限批量添加
        Summary: 蚂蚁区块链的链上交易数据查看权限批量添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_blockchain_miniprogram_ex(request, headers, runtime)

    async def add_blockchain_miniprogram_async(
        self,
        request: blockchain_models.AddBlockchainMiniprogramRequest,
    ) -> blockchain_models.AddBlockchainMiniprogramResponse:
        """
        Description: 蚂蚁区块链的链上交易数据查看权限批量添加
        Summary: 蚂蚁区块链的链上交易数据查看权限批量添加
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_blockchain_miniprogram_ex_async(request, headers, runtime)

    def add_blockchain_miniprogram_ex(
        self,
        request: blockchain_models.AddBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddBlockchainMiniprogramResponse:
        """
        Description: 蚂蚁区块链的链上交易数据查看权限批量添加
        Summary: 蚂蚁区块链的链上交易数据查看权限批量添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddBlockchainMiniprogramResponse(),
            self.do_request('1.0', 'baas.blockchain.miniprogram.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def add_blockchain_miniprogram_ex_async(
        self,
        request: blockchain_models.AddBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AddBlockchainMiniprogramResponse:
        """
        Description: 蚂蚁区块链的链上交易数据查看权限批量添加
        Summary: 蚂蚁区块链的链上交易数据查看权限批量添加
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AddBlockchainMiniprogramResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.miniprogram.add', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_transaction_statistic(
        self,
        request: blockchain_models.QueryBrowserTransactionStatisticRequest,
    ) -> blockchain_models.QueryBrowserTransactionStatisticResponse:
        """
        Description: 获取金融科技BaaS浏览器交易统计信息
        Summary: 获取金融科技BaaS浏览器交易统计信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_transaction_statistic_ex(request, headers, runtime)

    async def query_browser_transaction_statistic_async(
        self,
        request: blockchain_models.QueryBrowserTransactionStatisticRequest,
    ) -> blockchain_models.QueryBrowserTransactionStatisticResponse:
        """
        Description: 获取金融科技BaaS浏览器交易统计信息
        Summary: 获取金融科技BaaS浏览器交易统计信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_transaction_statistic_ex_async(request, headers, runtime)

    def query_browser_transaction_statistic_ex(
        self,
        request: blockchain_models.QueryBrowserTransactionStatisticRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionStatisticResponse:
        """
        Description: 获取金融科技BaaS浏览器交易统计信息
        Summary: 获取金融科技BaaS浏览器交易统计信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionStatisticResponse(),
            self.do_request('1.0', 'baas.browser.transaction.statistic.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_transaction_statistic_ex_async(
        self,
        request: blockchain_models.QueryBrowserTransactionStatisticRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionStatisticResponse:
        """
        Description: 获取金融科技BaaS浏览器交易统计信息
        Summary: 获取金融科技BaaS浏览器交易统计信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionStatisticResponse(),
            await self.do_request_async('1.0', 'baas.browser.transaction.statistic.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_block_latest(
        self,
        request: blockchain_models.QueryBrowserBlockLatestRequest,
    ) -> blockchain_models.QueryBrowserBlockLatestResponse:
        """
        Description: 获取金融科技BaaS最新区块信息列表
        Summary: 获取金融科技BaaS最新区块信息列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_block_latest_ex(request, headers, runtime)

    async def query_browser_block_latest_async(
        self,
        request: blockchain_models.QueryBrowserBlockLatestRequest,
    ) -> blockchain_models.QueryBrowserBlockLatestResponse:
        """
        Description: 获取金融科技BaaS最新区块信息列表
        Summary: 获取金融科技BaaS最新区块信息列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_block_latest_ex_async(request, headers, runtime)

    def query_browser_block_latest_ex(
        self,
        request: blockchain_models.QueryBrowserBlockLatestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserBlockLatestResponse:
        """
        Description: 获取金融科技BaaS最新区块信息列表
        Summary: 获取金融科技BaaS最新区块信息列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserBlockLatestResponse(),
            self.do_request('1.0', 'baas.browser.block.latest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_block_latest_ex_async(
        self,
        request: blockchain_models.QueryBrowserBlockLatestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserBlockLatestResponse:
        """
        Description: 获取金融科技BaaS最新区块信息列表
        Summary: 获取金融科技BaaS最新区块信息列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserBlockLatestResponse(),
            await self.do_request_async('1.0', 'baas.browser.block.latest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_transaction_latest(
        self,
        request: blockchain_models.QueryBrowserTransactionLatestRequest,
    ) -> blockchain_models.QueryBrowserTransactionLatestResponse:
        """
        Description: 获取金融科技BaaS最新交易列表
        Summary: 获取金融科技BaaS最新交易列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_transaction_latest_ex(request, headers, runtime)

    async def query_browser_transaction_latest_async(
        self,
        request: blockchain_models.QueryBrowserTransactionLatestRequest,
    ) -> blockchain_models.QueryBrowserTransactionLatestResponse:
        """
        Description: 获取金融科技BaaS最新交易列表
        Summary: 获取金融科技BaaS最新交易列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_transaction_latest_ex_async(request, headers, runtime)

    def query_browser_transaction_latest_ex(
        self,
        request: blockchain_models.QueryBrowserTransactionLatestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionLatestResponse:
        """
        Description: 获取金融科技BaaS最新交易列表
        Summary: 获取金融科技BaaS最新交易列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionLatestResponse(),
            self.do_request('1.0', 'baas.browser.transaction.latest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_transaction_latest_ex_async(
        self,
        request: blockchain_models.QueryBrowserTransactionLatestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionLatestResponse:
        """
        Description: 获取金融科技BaaS最新交易列表
        Summary: 获取金融科技BaaS最新交易列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionLatestResponse(),
            await self.do_request_async('1.0', 'baas.browser.transaction.latest.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_block(
        self,
        request: blockchain_models.QueryBrowserBlockRequest,
    ) -> blockchain_models.QueryBrowserBlockResponse:
        """
        Description: 获取金融科技BaaS区块信息
        Summary: 获取金融科技BaaS区块信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_block_ex(request, headers, runtime)

    async def query_browser_block_async(
        self,
        request: blockchain_models.QueryBrowserBlockRequest,
    ) -> blockchain_models.QueryBrowserBlockResponse:
        """
        Description: 获取金融科技BaaS区块信息
        Summary: 获取金融科技BaaS区块信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_block_ex_async(request, headers, runtime)

    def query_browser_block_ex(
        self,
        request: blockchain_models.QueryBrowserBlockRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserBlockResponse:
        """
        Description: 获取金融科技BaaS区块信息
        Summary: 获取金融科技BaaS区块信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserBlockResponse(),
            self.do_request('1.0', 'baas.browser.block.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_block_ex_async(
        self,
        request: blockchain_models.QueryBrowserBlockRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserBlockResponse:
        """
        Description: 获取金融科技BaaS区块信息
        Summary: 获取金融科技BaaS区块信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserBlockResponse(),
            await self.do_request_async('1.0', 'baas.browser.block.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_transaction(
        self,
        request: blockchain_models.QueryBrowserTransactionRequest,
    ) -> blockchain_models.QueryBrowserTransactionResponse:
        """
        Description: 获取金融科技BaaS交易信息内容
        Summary: 获取金融科技BaaS交易信息内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_transaction_ex(request, headers, runtime)

    async def query_browser_transaction_async(
        self,
        request: blockchain_models.QueryBrowserTransactionRequest,
    ) -> blockchain_models.QueryBrowserTransactionResponse:
        """
        Description: 获取金融科技BaaS交易信息内容
        Summary: 获取金融科技BaaS交易信息内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_transaction_ex_async(request, headers, runtime)

    def query_browser_transaction_ex(
        self,
        request: blockchain_models.QueryBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionResponse:
        """
        Description: 获取金融科技BaaS交易信息内容
        Summary: 获取金融科技BaaS交易信息内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionResponse(),
            self.do_request('1.0', 'baas.browser.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_transaction_ex_async(
        self,
        request: blockchain_models.QueryBrowserTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionResponse:
        """
        Description: 获取金融科技BaaS交易信息内容
        Summary: 获取金融科技BaaS交易信息内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionResponse(),
            await self.do_request_async('1.0', 'baas.browser.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_transaction_receipt(
        self,
        request: blockchain_models.QueryBrowserTransactionReceiptRequest,
    ) -> blockchain_models.QueryBrowserTransactionReceiptResponse:
        """
        Description: 获取金融科技BaaS交易回执信息
        Summary: 获取金融科技BaaS交易回执信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_transaction_receipt_ex(request, headers, runtime)

    async def query_browser_transaction_receipt_async(
        self,
        request: blockchain_models.QueryBrowserTransactionReceiptRequest,
    ) -> blockchain_models.QueryBrowserTransactionReceiptResponse:
        """
        Description: 获取金融科技BaaS交易回执信息
        Summary: 获取金融科技BaaS交易回执信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_transaction_receipt_ex_async(request, headers, runtime)

    def query_browser_transaction_receipt_ex(
        self,
        request: blockchain_models.QueryBrowserTransactionReceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionReceiptResponse:
        """
        Description: 获取金融科技BaaS交易回执信息
        Summary: 获取金融科技BaaS交易回执信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionReceiptResponse(),
            self.do_request('1.0', 'baas.browser.transaction.receipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_transaction_receipt_ex_async(
        self,
        request: blockchain_models.QueryBrowserTransactionReceiptRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserTransactionReceiptResponse:
        """
        Description: 获取金融科技BaaS交易回执信息
        Summary: 获取金融科技BaaS交易回执信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserTransactionReceiptResponse(),
            await self.do_request_async('1.0', 'baas.browser.transaction.receipt.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_browser_node_owner(
        self,
        request: blockchain_models.QueryBrowserNodeOwnerRequest,
    ) -> blockchain_models.QueryBrowserNodeOwnerResponse:
        """
        Description: 蚂蚁链节点所有者查询
        Summary: 蚂蚁链节点所有者查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_browser_node_owner_ex(request, headers, runtime)

    async def query_browser_node_owner_async(
        self,
        request: blockchain_models.QueryBrowserNodeOwnerRequest,
    ) -> blockchain_models.QueryBrowserNodeOwnerResponse:
        """
        Description: 蚂蚁链节点所有者查询
        Summary: 蚂蚁链节点所有者查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_browser_node_owner_ex_async(request, headers, runtime)

    def query_browser_node_owner_ex(
        self,
        request: blockchain_models.QueryBrowserNodeOwnerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserNodeOwnerResponse:
        """
        Description: 蚂蚁链节点所有者查询
        Summary: 蚂蚁链节点所有者查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserNodeOwnerResponse(),
            self.do_request('1.0', 'baas.browser.node.owner.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_browser_node_owner_ex_async(
        self,
        request: blockchain_models.QueryBrowserNodeOwnerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBrowserNodeOwnerResponse:
        """
        Description: 蚂蚁链节点所有者查询
        Summary: 蚂蚁链节点所有者查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBrowserNodeOwnerResponse(),
            await self.do_request_async('1.0', 'baas.browser.node.owner.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def delete_blockchain_miniprogram(
        self,
        request: blockchain_models.DeleteBlockchainMiniprogramRequest,
    ) -> blockchain_models.DeleteBlockchainMiniprogramResponse:
        """
        Description: 小程序权限删除
        Summary: 小程序权限删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_blockchain_miniprogram_ex(request, headers, runtime)

    async def delete_blockchain_miniprogram_async(
        self,
        request: blockchain_models.DeleteBlockchainMiniprogramRequest,
    ) -> blockchain_models.DeleteBlockchainMiniprogramResponse:
        """
        Description: 小程序权限删除
        Summary: 小程序权限删除
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_blockchain_miniprogram_ex_async(request, headers, runtime)

    def delete_blockchain_miniprogram_ex(
        self,
        request: blockchain_models.DeleteBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteBlockchainMiniprogramResponse:
        """
        Description: 小程序权限删除
        Summary: 小程序权限删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteBlockchainMiniprogramResponse(),
            self.do_request('1.0', 'baas.blockchain.miniprogram.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def delete_blockchain_miniprogram_ex_async(
        self,
        request: blockchain_models.DeleteBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DeleteBlockchainMiniprogramResponse:
        """
        Description: 小程序权限删除
        Summary: 小程序权限删除
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DeleteBlockchainMiniprogramResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.miniprogram.delete', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_blockchain_miniprogram(
        self,
        request: blockchain_models.QueryBlockchainMiniprogramRequest,
    ) -> blockchain_models.QueryBlockchainMiniprogramResponse:
        """
        Description: 查询用户链上交易移动端查看权限
        Summary: 查询用户链上交易移动端查看权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_blockchain_miniprogram_ex(request, headers, runtime)

    async def query_blockchain_miniprogram_async(
        self,
        request: blockchain_models.QueryBlockchainMiniprogramRequest,
    ) -> blockchain_models.QueryBlockchainMiniprogramResponse:
        """
        Description: 查询用户链上交易移动端查看权限
        Summary: 查询用户链上交易移动端查看权限
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_blockchain_miniprogram_ex_async(request, headers, runtime)

    def query_blockchain_miniprogram_ex(
        self,
        request: blockchain_models.QueryBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainMiniprogramResponse:
        """
        Description: 查询用户链上交易移动端查看权限
        Summary: 查询用户链上交易移动端查看权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainMiniprogramResponse(),
            self.do_request('1.0', 'baas.blockchain.miniprogram.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_blockchain_miniprogram_ex_async(
        self,
        request: blockchain_models.QueryBlockchainMiniprogramRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryBlockchainMiniprogramResponse:
        """
        Description: 查询用户链上交易移动端查看权限
        Summary: 查询用户链上交易移动端查看权限
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryBlockchainMiniprogramResponse(),
            await self.do_request_async('1.0', 'baas.blockchain.miniprogram.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_credit_transfer_apply(
        self,
        request: blockchain_models.QueryCreditTransferApplyRequest,
    ) -> blockchain_models.QueryCreditTransferApplyResponse:
        """
        Description: 物流金融信用流转能力注册开通结果查询
        Summary: 物流金融信用流转能力注册开通结果查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_credit_transfer_apply_ex(request, headers, runtime)

    async def query_credit_transfer_apply_async(
        self,
        request: blockchain_models.QueryCreditTransferApplyRequest,
    ) -> blockchain_models.QueryCreditTransferApplyResponse:
        """
        Description: 物流金融信用流转能力注册开通结果查询
        Summary: 物流金融信用流转能力注册开通结果查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_credit_transfer_apply_ex_async(request, headers, runtime)

    def query_credit_transfer_apply_ex(
        self,
        request: blockchain_models.QueryCreditTransferApplyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferApplyResponse:
        """
        Description: 物流金融信用流转能力注册开通结果查询
        Summary: 物流金融信用流转能力注册开通结果查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferApplyResponse(),
            self.do_request('1.0', 'baas.credit.transfer.apply.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_credit_transfer_apply_ex_async(
        self,
        request: blockchain_models.QueryCreditTransferApplyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferApplyResponse:
        """
        Description: 物流金融信用流转能力注册开通结果查询
        Summary: 物流金融信用流转能力注册开通结果查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferApplyResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.apply.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_credit_transfer_balance(
        self,
        request: blockchain_models.QueryCreditTransferBalanceRequest,
    ) -> blockchain_models.QueryCreditTransferBalanceResponse:
        """
        Description: 物流金融信用流转额度查询，仅显示是否有额度，不会返回具体额度
        Summary: 物流金融信用流转额度查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_credit_transfer_balance_ex(request, headers, runtime)

    async def query_credit_transfer_balance_async(
        self,
        request: blockchain_models.QueryCreditTransferBalanceRequest,
    ) -> blockchain_models.QueryCreditTransferBalanceResponse:
        """
        Description: 物流金融信用流转额度查询，仅显示是否有额度，不会返回具体额度
        Summary: 物流金融信用流转额度查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_credit_transfer_balance_ex_async(request, headers, runtime)

    def query_credit_transfer_balance_ex(
        self,
        request: blockchain_models.QueryCreditTransferBalanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferBalanceResponse:
        """
        Description: 物流金融信用流转额度查询，仅显示是否有额度，不会返回具体额度
        Summary: 物流金融信用流转额度查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferBalanceResponse(),
            self.do_request('1.0', 'baas.credit.transfer.balance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_credit_transfer_balance_ex_async(
        self,
        request: blockchain_models.QueryCreditTransferBalanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferBalanceResponse:
        """
        Description: 物流金融信用流转额度查询，仅显示是否有额度，不会返回具体额度
        Summary: 物流金融信用流转额度查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferBalanceResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.balance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_credit_transfer_issuebyid(
        self,
        request: blockchain_models.QueryCreditTransferIssuebyidRequest,
    ) -> blockchain_models.QueryCreditTransferIssuebyidResponse:
        """
        Description: 物流金融信用流转通过id查询发行结果
        Summary: 物流金融信用流转通过id查询发行结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_credit_transfer_issuebyid_ex(request, headers, runtime)

    async def query_credit_transfer_issuebyid_async(
        self,
        request: blockchain_models.QueryCreditTransferIssuebyidRequest,
    ) -> blockchain_models.QueryCreditTransferIssuebyidResponse:
        """
        Description: 物流金融信用流转通过id查询发行结果
        Summary: 物流金融信用流转通过id查询发行结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_credit_transfer_issuebyid_ex_async(request, headers, runtime)

    def query_credit_transfer_issuebyid_ex(
        self,
        request: blockchain_models.QueryCreditTransferIssuebyidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferIssuebyidResponse:
        """
        Description: 物流金融信用流转通过id查询发行结果
        Summary: 物流金融信用流转通过id查询发行结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferIssuebyidResponse(),
            self.do_request('1.0', 'baas.credit.transfer.issuebyid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_credit_transfer_issuebyid_ex_async(
        self,
        request: blockchain_models.QueryCreditTransferIssuebyidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferIssuebyidResponse:
        """
        Description: 物流金融信用流转通过id查询发行结果
        Summary: 物流金融信用流转通过id查询发行结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferIssuebyidResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.issuebyid.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_credit_transfer_issuebytime(
        self,
        request: blockchain_models.QueryCreditTransferIssuebytimeRequest,
    ) -> blockchain_models.QueryCreditTransferIssuebytimeResponse:
        """
        Description: 物流金融根据时间查询信用凭证信息
        Summary: 物流金融根据时间查询信用流转信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_credit_transfer_issuebytime_ex(request, headers, runtime)

    async def query_credit_transfer_issuebytime_async(
        self,
        request: blockchain_models.QueryCreditTransferIssuebytimeRequest,
    ) -> blockchain_models.QueryCreditTransferIssuebytimeResponse:
        """
        Description: 物流金融根据时间查询信用凭证信息
        Summary: 物流金融根据时间查询信用流转信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_credit_transfer_issuebytime_ex_async(request, headers, runtime)

    def query_credit_transfer_issuebytime_ex(
        self,
        request: blockchain_models.QueryCreditTransferIssuebytimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferIssuebytimeResponse:
        """
        Description: 物流金融根据时间查询信用凭证信息
        Summary: 物流金融根据时间查询信用流转信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferIssuebytimeResponse(),
            self.do_request('1.0', 'baas.credit.transfer.issuebytime.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_credit_transfer_issuebytime_ex_async(
        self,
        request: blockchain_models.QueryCreditTransferIssuebytimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferIssuebytimeResponse:
        """
        Description: 物流金融根据时间查询信用凭证信息
        Summary: 物流金融根据时间查询信用流转信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferIssuebytimeResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.issuebytime.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_credit_transfer_statement(
        self,
        request: blockchain_models.QueryCreditTransferStatementRequest,
    ) -> blockchain_models.QueryCreditTransferStatementResponse:
        """
        Description: 物流金融信用流转流水查询
        Summary: 物流金融信用流转流水查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_credit_transfer_statement_ex(request, headers, runtime)

    async def query_credit_transfer_statement_async(
        self,
        request: blockchain_models.QueryCreditTransferStatementRequest,
    ) -> blockchain_models.QueryCreditTransferStatementResponse:
        """
        Description: 物流金融信用流转流水查询
        Summary: 物流金融信用流转流水查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_credit_transfer_statement_ex_async(request, headers, runtime)

    def query_credit_transfer_statement_ex(
        self,
        request: blockchain_models.QueryCreditTransferStatementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferStatementResponse:
        """
        Description: 物流金融信用流转流水查询
        Summary: 物流金融信用流转流水查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferStatementResponse(),
            self.do_request('1.0', 'baas.credit.transfer.statement.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_credit_transfer_statement_ex_async(
        self,
        request: blockchain_models.QueryCreditTransferStatementRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryCreditTransferStatementResponse:
        """
        Description: 物流金融信用流转流水查询
        Summary: 物流金融信用流转流水查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryCreditTransferStatementResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.statement.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def callback_credit_transfer(
        self,
        request: blockchain_models.CallbackCreditTransferRequest,
    ) -> blockchain_models.CallbackCreditTransferResponse:
        """
        Description: 物流金融信用流转主站系统回调
        Summary: 物流金融信用流转主站系统回调
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.callback_credit_transfer_ex(request, headers, runtime)

    async def callback_credit_transfer_async(
        self,
        request: blockchain_models.CallbackCreditTransferRequest,
    ) -> blockchain_models.CallbackCreditTransferResponse:
        """
        Description: 物流金融信用流转主站系统回调
        Summary: 物流金融信用流转主站系统回调
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.callback_credit_transfer_ex_async(request, headers, runtime)

    def callback_credit_transfer_ex(
        self,
        request: blockchain_models.CallbackCreditTransferRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CallbackCreditTransferResponse:
        """
        Description: 物流金融信用流转主站系统回调
        Summary: 物流金融信用流转主站系统回调
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CallbackCreditTransferResponse(),
            self.do_request('1.0', 'baas.credit.transfer.callback', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def callback_credit_transfer_ex_async(
        self,
        request: blockchain_models.CallbackCreditTransferRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CallbackCreditTransferResponse:
        """
        Description: 物流金融信用流转主站系统回调
        Summary: 物流金融信用流转主站系统回调
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CallbackCreditTransferResponse(),
            await self.do_request_async('1.0', 'baas.credit.transfer.callback', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def push_auth_user_vc(
        self,
        request: blockchain_models.PushAuthUserVcRequest,
    ) -> blockchain_models.PushAuthUserVcResponse:
        """
        Description: 外部业务方可以给DIS的C端小程序用户颁发声明（VC）用户特定场景
        Summary: 推送业务方给用户颁发的声明内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.push_auth_user_vc_ex(request, headers, runtime)

    async def push_auth_user_vc_async(
        self,
        request: blockchain_models.PushAuthUserVcRequest,
    ) -> blockchain_models.PushAuthUserVcResponse:
        """
        Description: 外部业务方可以给DIS的C端小程序用户颁发声明（VC）用户特定场景
        Summary: 推送业务方给用户颁发的声明内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.push_auth_user_vc_ex_async(request, headers, runtime)

    def push_auth_user_vc_ex(
        self,
        request: blockchain_models.PushAuthUserVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthUserVcResponse:
        """
        Description: 外部业务方可以给DIS的C端小程序用户颁发声明（VC）用户特定场景
        Summary: 推送业务方给用户颁发的声明内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthUserVcResponse(),
            self.do_request('1.0', 'baas.auth.user.vc.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def push_auth_user_vc_ex_async(
        self,
        request: blockchain_models.PushAuthUserVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthUserVcResponse:
        """
        Description: 外部业务方可以给DIS的C端小程序用户颁发声明（VC）用户特定场景
        Summary: 推送业务方给用户颁发的声明内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthUserVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.user.vc.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def push_auth_claim_vc(
        self,
        request: blockchain_models.PushAuthClaimVcRequest,
    ) -> blockchain_models.PushAuthClaimVcResponse:
        """
        Description: 业务方推送需要用户使用数字身份did授权确认的声明，推送后可根据自定义的业务id（biz_id）来查询状态（另提供接口），进而获取用户授权后的声明。
        Summary: 推送需要用户端授权的业务声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.push_auth_claim_vc_ex(request, headers, runtime)

    async def push_auth_claim_vc_async(
        self,
        request: blockchain_models.PushAuthClaimVcRequest,
    ) -> blockchain_models.PushAuthClaimVcResponse:
        """
        Description: 业务方推送需要用户使用数字身份did授权确认的声明，推送后可根据自定义的业务id（biz_id）来查询状态（另提供接口），进而获取用户授权后的声明。
        Summary: 推送需要用户端授权的业务声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.push_auth_claim_vc_ex_async(request, headers, runtime)

    def push_auth_claim_vc_ex(
        self,
        request: blockchain_models.PushAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthClaimVcResponse:
        """
        Description: 业务方推送需要用户使用数字身份did授权确认的声明，推送后可根据自定义的业务id（biz_id）来查询状态（另提供接口），进而获取用户授权后的声明。
        Summary: 推送需要用户端授权的业务声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthClaimVcResponse(),
            self.do_request('1.0', 'baas.auth.claim.vc.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def push_auth_claim_vc_ex_async(
        self,
        request: blockchain_models.PushAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthClaimVcResponse:
        """
        Description: 业务方推送需要用户使用数字身份did授权确认的声明，推送后可根据自定义的业务id（biz_id）来查询状态（另提供接口），进而获取用户授权后的声明。
        Summary: 推送需要用户端授权的业务声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthClaimVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.vc.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pull_auth_user_did(
        self,
        request: blockchain_models.PullAuthUserDidRequest,
    ) -> blockchain_models.PullAuthUserDidResponse:
        """
        Description: 业务方通过提供二维码的方式引导用户支付宝扫描创建did，然后业务方通过此接口可查询用户新建的did
        Summary: 通过biz_id获取用户的did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pull_auth_user_did_ex(request, headers, runtime)

    async def pull_auth_user_did_async(
        self,
        request: blockchain_models.PullAuthUserDidRequest,
    ) -> blockchain_models.PullAuthUserDidResponse:
        """
        Description: 业务方通过提供二维码的方式引导用户支付宝扫描创建did，然后业务方通过此接口可查询用户新建的did
        Summary: 通过biz_id获取用户的did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pull_auth_user_did_ex_async(request, headers, runtime)

    def pull_auth_user_did_ex(
        self,
        request: blockchain_models.PullAuthUserDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthUserDidResponse:
        """
        Description: 业务方通过提供二维码的方式引导用户支付宝扫描创建did，然后业务方通过此接口可查询用户新建的did
        Summary: 通过biz_id获取用户的did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthUserDidResponse(),
            self.do_request('1.0', 'baas.auth.user.did.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pull_auth_user_did_ex_async(
        self,
        request: blockchain_models.PullAuthUserDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthUserDidResponse:
        """
        Description: 业务方通过提供二维码的方式引导用户支付宝扫描创建did，然后业务方通过此接口可查询用户新建的did
        Summary: 通过biz_id获取用户的did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthUserDidResponse(),
            await self.do_request_async('1.0', 'baas.auth.user.did.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pull_auth_claim_vc(
        self,
        request: blockchain_models.PullAuthClaimVcRequest,
    ) -> blockchain_models.PullAuthClaimVcResponse:
        """
        Description: 业务方通过此接口可以查询，申请用户授权的声明状态，如果用户已授权即可获取到授权后的声明（vc）内容。
        Summary: 获取申请用户声明的授权结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pull_auth_claim_vc_ex(request, headers, runtime)

    async def pull_auth_claim_vc_async(
        self,
        request: blockchain_models.PullAuthClaimVcRequest,
    ) -> blockchain_models.PullAuthClaimVcResponse:
        """
        Description: 业务方通过此接口可以查询，申请用户授权的声明状态，如果用户已授权即可获取到授权后的声明（vc）内容。
        Summary: 获取申请用户声明的授权结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pull_auth_claim_vc_ex_async(request, headers, runtime)

    def pull_auth_claim_vc_ex(
        self,
        request: blockchain_models.PullAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthClaimVcResponse:
        """
        Description: 业务方通过此接口可以查询，申请用户授权的声明状态，如果用户已授权即可获取到授权后的声明（vc）内容。
        Summary: 获取申请用户声明的授权结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthClaimVcResponse(),
            self.do_request('1.0', 'baas.auth.claim.vc.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pull_auth_claim_vc_ex_async(
        self,
        request: blockchain_models.PullAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthClaimVcResponse:
        """
        Description: 业务方通过此接口可以查询，申请用户授权的声明状态，如果用户已授权即可获取到授权后的声明（vc）内容。
        Summary: 获取申请用户声明的授权结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthClaimVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.vc.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_user_did(
        self,
        request: blockchain_models.CreateAuthUserDidRequest,
    ) -> blockchain_models.CreateAuthUserDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给用户创建did，需要指定userId
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_user_did_ex(request, headers, runtime)

    async def create_auth_user_did_async(
        self,
        request: blockchain_models.CreateAuthUserDidRequest,
    ) -> blockchain_models.CreateAuthUserDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给用户创建did，需要指定userId
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_user_did_ex_async(request, headers, runtime)

    def create_auth_user_did_ex(
        self,
        request: blockchain_models.CreateAuthUserDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthUserDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给用户创建did，需要指定userId
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthUserDidResponse(),
            self.do_request('1.0', 'baas.auth.user.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_user_did_ex_async(
        self,
        request: blockchain_models.CreateAuthUserDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthUserDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给用户创建did，需要指定userId
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthUserDidResponse(),
            await self.do_request_async('1.0', 'baas.auth.user.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_corporate_did(
        self,
        request: blockchain_models.CreateAuthCorporateDidRequest,
    ) -> blockchain_models.CreateAuthCorporateDidResponse:
        """
        Description: 给企业DID创建DID，通常场景为对授权宝服务的开通，调用方对企业有认证能力。
        Summary: 创建企业DID，开通授权宝服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_corporate_did_ex(request, headers, runtime)

    async def create_auth_corporate_did_async(
        self,
        request: blockchain_models.CreateAuthCorporateDidRequest,
    ) -> blockchain_models.CreateAuthCorporateDidResponse:
        """
        Description: 给企业DID创建DID，通常场景为对授权宝服务的开通，调用方对企业有认证能力。
        Summary: 创建企业DID，开通授权宝服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_corporate_did_ex_async(request, headers, runtime)

    def create_auth_corporate_did_ex(
        self,
        request: blockchain_models.CreateAuthCorporateDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCorporateDidResponse:
        """
        Description: 给企业DID创建DID，通常场景为对授权宝服务的开通，调用方对企业有认证能力。
        Summary: 创建企业DID，开通授权宝服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCorporateDidResponse(),
            self.do_request('1.0', 'baas.auth.corporate.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_corporate_did_ex_async(
        self,
        request: blockchain_models.CreateAuthCorporateDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCorporateDidResponse:
        """
        Description: 给企业DID创建DID，通常场景为对授权宝服务的开通，调用方对企业有认证能力。
        Summary: 创建企业DID，开通授权宝服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCorporateDidResponse(),
            await self.do_request_async('1.0', 'baas.auth.corporate.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pull_auth_webpage_vc(
        self,
        request: blockchain_models.PullAuthWebpageVcRequest,
    ) -> blockchain_models.PullAuthWebpageVcResponse:
        """
        Description: 业务方的C端用户授权颁发“可验证声明”（简称VC）之后，就会异步推送结果给相关业务服务端，如果相关业务服务端没有接收到，或者本地缓存过期，则可以通过此接口到授权宝再次查询目标可验证声明结果情况。
        Summary: 查询目标可验证声明结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pull_auth_webpage_vc_ex(request, headers, runtime)

    async def pull_auth_webpage_vc_async(
        self,
        request: blockchain_models.PullAuthWebpageVcRequest,
    ) -> blockchain_models.PullAuthWebpageVcResponse:
        """
        Description: 业务方的C端用户授权颁发“可验证声明”（简称VC）之后，就会异步推送结果给相关业务服务端，如果相关业务服务端没有接收到，或者本地缓存过期，则可以通过此接口到授权宝再次查询目标可验证声明结果情况。
        Summary: 查询目标可验证声明结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pull_auth_webpage_vc_ex_async(request, headers, runtime)

    def pull_auth_webpage_vc_ex(
        self,
        request: blockchain_models.PullAuthWebpageVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthWebpageVcResponse:
        """
        Description: 业务方的C端用户授权颁发“可验证声明”（简称VC）之后，就会异步推送结果给相关业务服务端，如果相关业务服务端没有接收到，或者本地缓存过期，则可以通过此接口到授权宝再次查询目标可验证声明结果情况。
        Summary: 查询目标可验证声明结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthWebpageVcResponse(),
            self.do_request('1.0', 'baas.auth.webpage.vc.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pull_auth_webpage_vc_ex_async(
        self,
        request: blockchain_models.PullAuthWebpageVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthWebpageVcResponse:
        """
        Description: 业务方的C端用户授权颁发“可验证声明”（简称VC）之后，就会异步推送结果给相关业务服务端，如果相关业务服务端没有接收到，或者本地缓存过期，则可以通过此接口到授权宝再次查询目标可验证声明结果情况。
        Summary: 查询目标可验证声明结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthWebpageVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.webpage.vc.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pull_auth_webpage_url(
        self,
        request: blockchain_models.PullAuthWebpageUrlRequest,
    ) -> blockchain_models.PullAuthWebpageUrlResponse:
        """
        Description: 此接口提供了授权宝这边可用的H5页面的Url，此Url会携带一些参数：授权宝鉴权token(JWT机制生成，内部使用)、bizId(接口入参带入)
        Summary: 获取授权宝侧的H5授权Url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pull_auth_webpage_url_ex(request, headers, runtime)

    async def pull_auth_webpage_url_async(
        self,
        request: blockchain_models.PullAuthWebpageUrlRequest,
    ) -> blockchain_models.PullAuthWebpageUrlResponse:
        """
        Description: 此接口提供了授权宝这边可用的H5页面的Url，此Url会携带一些参数：授权宝鉴权token(JWT机制生成，内部使用)、bizId(接口入参带入)
        Summary: 获取授权宝侧的H5授权Url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pull_auth_webpage_url_ex_async(request, headers, runtime)

    def pull_auth_webpage_url_ex(
        self,
        request: blockchain_models.PullAuthWebpageUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthWebpageUrlResponse:
        """
        Description: 此接口提供了授权宝这边可用的H5页面的Url，此Url会携带一些参数：授权宝鉴权token(JWT机制生成，内部使用)、bizId(接口入参带入)
        Summary: 获取授权宝侧的H5授权Url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthWebpageUrlResponse(),
            self.do_request('1.0', 'baas.auth.webpage.url.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pull_auth_webpage_url_ex_async(
        self,
        request: blockchain_models.PullAuthWebpageUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PullAuthWebpageUrlResponse:
        """
        Description: 此接口提供了授权宝这边可用的H5页面的Url，此Url会携带一些参数：授权宝鉴权token(JWT机制生成，内部使用)、bizId(接口入参带入)
        Summary: 获取授权宝侧的H5授权Url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PullAuthWebpageUrlResponse(),
            await self.do_request_async('1.0', 'baas.auth.webpage.url.pull', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_auth(
        self,
        request: blockchain_models.StartAuthVcAuthRequest,
    ) -> blockchain_models.StartAuthVcAuthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，根据bizType的类型，直接发生代理颁发可验证声明的操作。
        Summary: 给定声明内容并颁发声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_auth_ex(request, headers, runtime)

    async def start_auth_vc_auth_async(
        self,
        request: blockchain_models.StartAuthVcAuthRequest,
    ) -> blockchain_models.StartAuthVcAuthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，根据bizType的类型，直接发生代理颁发可验证声明的操作。
        Summary: 给定声明内容并颁发声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_auth_ex_async(request, headers, runtime)

    def start_auth_vc_auth_ex(
        self,
        request: blockchain_models.StartAuthVcAuthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcAuthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，根据bizType的类型，直接发生代理颁发可验证声明的操作。
        Summary: 给定声明内容并颁发声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcAuthResponse(),
            self.do_request('1.0', 'baas.auth.vc.auth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_auth_ex_async(
        self,
        request: blockchain_models.StartAuthVcAuthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcAuthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，根据bizType的类型，直接发生代理颁发可验证声明的操作。
        Summary: 给定声明内容并颁发声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcAuthResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.auth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_share(
        self,
        request: blockchain_models.StartAuthVcShareRequest,
    ) -> blockchain_models.StartAuthVcShareResponse:
        """
        Description: 可验证声明（VC）的拥有者（vcContent中的subject）可以将声明分享权限给其它的DID。
        Summary: 将目标的声明内容，分享权限给目标的DID
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_share_ex(request, headers, runtime)

    async def start_auth_vc_share_async(
        self,
        request: blockchain_models.StartAuthVcShareRequest,
    ) -> blockchain_models.StartAuthVcShareResponse:
        """
        Description: 可验证声明（VC）的拥有者（vcContent中的subject）可以将声明分享权限给其它的DID。
        Summary: 将目标的声明内容，分享权限给目标的DID
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_share_ex_async(request, headers, runtime)

    def start_auth_vc_share_ex(
        self,
        request: blockchain_models.StartAuthVcShareRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcShareResponse:
        """
        Description: 可验证声明（VC）的拥有者（vcContent中的subject）可以将声明分享权限给其它的DID。
        Summary: 将目标的声明内容，分享权限给目标的DID
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcShareResponse(),
            self.do_request('1.0', 'baas.auth.vc.share.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_share_ex_async(
        self,
        request: blockchain_models.StartAuthVcShareRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcShareResponse:
        """
        Description: 可验证声明（VC）的拥有者（vcContent中的subject）可以将声明分享权限给其它的DID。
        Summary: 将目标的声明内容，分享权限给目标的DID
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcShareResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.share.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vc_content(
        self,
        request: blockchain_models.QueryAuthVcContentRequest,
    ) -> blockchain_models.QueryAuthVcContentResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明内容，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vc_content_ex(request, headers, runtime)

    async def query_auth_vc_content_async(
        self,
        request: blockchain_models.QueryAuthVcContentRequest,
    ) -> blockchain_models.QueryAuthVcContentResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明内容，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vc_content_ex_async(request, headers, runtime)

    def query_auth_vc_content_ex(
        self,
        request: blockchain_models.QueryAuthVcContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcContentResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明内容，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcContentResponse(),
            self.do_request('1.0', 'baas.auth.vc.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vc_content_ex_async(
        self,
        request: blockchain_models.QueryAuthVcContentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcContentResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明内容，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcContentResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.content.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_userinfo_did(
        self,
        request: blockchain_models.CreateAuthUserinfoDidRequest,
    ) -> blockchain_models.CreateAuthUserinfoDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给C类用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给C类用户建did，需要指定user信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_userinfo_did_ex(request, headers, runtime)

    async def create_auth_userinfo_did_async(
        self,
        request: blockchain_models.CreateAuthUserinfoDidRequest,
    ) -> blockchain_models.CreateAuthUserinfoDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给C类用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给C类用户建did，需要指定user信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_userinfo_did_ex_async(request, headers, runtime)

    def create_auth_userinfo_did_ex(
        self,
        request: blockchain_models.CreateAuthUserinfoDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthUserinfoDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给C类用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给C类用户建did，需要指定user信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthUserinfoDidResponse(),
            self.do_request('1.0', 'baas.auth.userinfo.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_userinfo_did_ex_async(
        self,
        request: blockchain_models.CreateAuthUserinfoDidRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthUserinfoDidResponse:
        """
        Description: 业务系统通过授权宝服务帮忙给C类用户创建did，此接口访问需预先在授权宝配置白名单开通。
        Summary: 给C类用户建did，需要指定user信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthUserinfoDidResponse(),
            await self.do_request_async('1.0', 'baas.auth.userinfo.did.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_revoke(
        self,
        request: blockchain_models.StartAuthVcRevokeRequest,
    ) -> blockchain_models.StartAuthVcRevokeResponse:
        """
        Description: 声明的持有者可以吊销一个已颁发的可验证声明(VC)
        Summary: 吊销已颁发声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_revoke_ex(request, headers, runtime)

    async def start_auth_vc_revoke_async(
        self,
        request: blockchain_models.StartAuthVcRevokeRequest,
    ) -> blockchain_models.StartAuthVcRevokeResponse:
        """
        Description: 声明的持有者可以吊销一个已颁发的可验证声明(VC)
        Summary: 吊销已颁发声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_revoke_ex_async(request, headers, runtime)

    def start_auth_vc_revoke_ex(
        self,
        request: blockchain_models.StartAuthVcRevokeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcRevokeResponse:
        """
        Description: 声明的持有者可以吊销一个已颁发的可验证声明(VC)
        Summary: 吊销已颁发声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcRevokeResponse(),
            self.do_request('1.0', 'baas.auth.vc.revoke.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_revoke_ex_async(
        self,
        request: blockchain_models.StartAuthVcRevokeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcRevokeResponse:
        """
        Description: 声明的持有者可以吊销一个已颁发的可验证声明(VC)
        Summary: 吊销已颁发声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcRevokeResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.revoke.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_give(
        self,
        request: blockchain_models.StartAuthVcGiveRequest,
    ) -> blockchain_models.StartAuthVcGiveResponse:
        """
        Description: 将可验证声明内的数据资产内容赠送给目标的did
        Summary: 将vc赠送给一个目标did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_give_ex(request, headers, runtime)

    async def start_auth_vc_give_async(
        self,
        request: blockchain_models.StartAuthVcGiveRequest,
    ) -> blockchain_models.StartAuthVcGiveResponse:
        """
        Description: 将可验证声明内的数据资产内容赠送给目标的did
        Summary: 将vc赠送给一个目标did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_give_ex_async(request, headers, runtime)

    def start_auth_vc_give_ex(
        self,
        request: blockchain_models.StartAuthVcGiveRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcGiveResponse:
        """
        Description: 将可验证声明内的数据资产内容赠送给目标的did
        Summary: 将vc赠送给一个目标did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcGiveResponse(),
            self.do_request('1.0', 'baas.auth.vc.give.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_give_ex_async(
        self,
        request: blockchain_models.StartAuthVcGiveRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcGiveResponse:
        """
        Description: 将可验证声明内的数据资产内容赠送给目标的did
        Summary: 将vc赠送给一个目标did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcGiveResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.give.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_sharebatch(
        self,
        request: blockchain_models.StartAuthVcSharebatchRequest,
    ) -> blockchain_models.StartAuthVcSharebatchResponse:
        """
        Description: 提供批量分享可验证声明到目标did
        Summary: 批量分享VC内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_sharebatch_ex(request, headers, runtime)

    async def start_auth_vc_sharebatch_async(
        self,
        request: blockchain_models.StartAuthVcSharebatchRequest,
    ) -> blockchain_models.StartAuthVcSharebatchResponse:
        """
        Description: 提供批量分享可验证声明到目标did
        Summary: 批量分享VC内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_sharebatch_ex_async(request, headers, runtime)

    def start_auth_vc_sharebatch_ex(
        self,
        request: blockchain_models.StartAuthVcSharebatchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcSharebatchResponse:
        """
        Description: 提供批量分享可验证声明到目标did
        Summary: 批量分享VC内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcSharebatchResponse(),
            self.do_request('1.0', 'baas.auth.vc.sharebatch.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_sharebatch_ex_async(
        self,
        request: blockchain_models.StartAuthVcSharebatchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcSharebatchResponse:
        """
        Description: 提供批量分享可验证声明到目标did
        Summary: 批量分享VC内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcSharebatchResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.sharebatch.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_corporate_sign(
        self,
        request: blockchain_models.StartAuthCorporateSignRequest,
    ) -> blockchain_models.StartAuthCorporateSignResponse:
        """
        Description: 如果机构没有接入网关能力需要合作方代理在授权宝管理签名能力，可使用此接口。
        初始申请创建此corp did的调用方，有权限申请签名。
        Summary: 代理签名
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_corporate_sign_ex(request, headers, runtime)

    async def start_auth_corporate_sign_async(
        self,
        request: blockchain_models.StartAuthCorporateSignRequest,
    ) -> blockchain_models.StartAuthCorporateSignResponse:
        """
        Description: 如果机构没有接入网关能力需要合作方代理在授权宝管理签名能力，可使用此接口。
        初始申请创建此corp did的调用方，有权限申请签名。
        Summary: 代理签名
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_corporate_sign_ex_async(request, headers, runtime)

    def start_auth_corporate_sign_ex(
        self,
        request: blockchain_models.StartAuthCorporateSignRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthCorporateSignResponse:
        """
        Description: 如果机构没有接入网关能力需要合作方代理在授权宝管理签名能力，可使用此接口。
        初始申请创建此corp did的调用方，有权限申请签名。
        Summary: 代理签名
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthCorporateSignResponse(),
            self.do_request('1.0', 'baas.auth.corporate.sign.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_corporate_sign_ex_async(
        self,
        request: blockchain_models.StartAuthCorporateSignRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthCorporateSignResponse:
        """
        Description: 如果机构没有接入网关能力需要合作方代理在授权宝管理签名能力，可使用此接口。
        初始申请创建此corp did的调用方，有权限申请签名。
        Summary: 代理签名
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthCorporateSignResponse(),
            await self.do_request_async('1.0', 'baas.auth.corporate.sign.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_batchauth(
        self,
        request: blockchain_models.StartAuthVcBatchauthRequest,
    ) -> blockchain_models.StartAuthVcBatchauthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，提交颁发可验证声明的操作。当前接口支持批量颁发声明，通常支持对多机构的数据授权。
        Summary: 批量给定声明内容颁发声明，并上链存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_batchauth_ex(request, headers, runtime)

    async def start_auth_vc_batchauth_async(
        self,
        request: blockchain_models.StartAuthVcBatchauthRequest,
    ) -> blockchain_models.StartAuthVcBatchauthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，提交颁发可验证声明的操作。当前接口支持批量颁发声明，通常支持对多机构的数据授权。
        Summary: 批量给定声明内容颁发声明，并上链存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_batchauth_ex_async(request, headers, runtime)

    def start_auth_vc_batchauth_ex(
        self,
        request: blockchain_models.StartAuthVcBatchauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcBatchauthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，提交颁发可验证声明的操作。当前接口支持批量颁发声明，通常支持对多机构的数据授权。
        Summary: 批量给定声明内容颁发声明，并上链存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcBatchauthResponse(),
            self.do_request('1.0', 'baas.auth.vc.batchauth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_batchauth_ex_async(
        self,
        request: blockchain_models.StartAuthVcBatchauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcBatchauthResponse:
        """
        Description: 在一些业务场景，指定可验证声明之后，提交颁发可验证声明的操作。当前接口支持批量颁发声明，通常支持对多机构的数据授权。
        Summary: 批量给定声明内容颁发声明，并上链存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcBatchauthResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.batchauth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_vc_replace(
        self,
        request: blockchain_models.StartAuthVcReplaceRequest,
    ) -> blockchain_models.StartAuthVcReplaceResponse:
        """
        Description: 将已颁发的可验证声明进行吊销，然后重新颁发一个新的可验证声明用于代替原有的业务语义的可验证声明。
        Summary: 将已颁发的可验证声明进行重置替换
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_vc_replace_ex(request, headers, runtime)

    async def start_auth_vc_replace_async(
        self,
        request: blockchain_models.StartAuthVcReplaceRequest,
    ) -> blockchain_models.StartAuthVcReplaceResponse:
        """
        Description: 将已颁发的可验证声明进行吊销，然后重新颁发一个新的可验证声明用于代替原有的业务语义的可验证声明。
        Summary: 将已颁发的可验证声明进行重置替换
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_vc_replace_ex_async(request, headers, runtime)

    def start_auth_vc_replace_ex(
        self,
        request: blockchain_models.StartAuthVcReplaceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcReplaceResponse:
        """
        Description: 将已颁发的可验证声明进行吊销，然后重新颁发一个新的可验证声明用于代替原有的业务语义的可验证声明。
        Summary: 将已颁发的可验证声明进行重置替换
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcReplaceResponse(),
            self.do_request('1.0', 'baas.auth.vc.replace.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_vc_replace_ex_async(
        self,
        request: blockchain_models.StartAuthVcReplaceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVcReplaceResponse:
        """
        Description: 将已颁发的可验证声明进行吊销，然后重新颁发一个新的可验证声明用于代替原有的业务语义的可验证声明。
        Summary: 将已颁发的可验证声明进行重置替换
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVcReplaceResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.replace.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def push_auth_insurance_policy(
        self,
        request: blockchain_models.PushAuthInsurancePolicyRequest,
    ) -> blockchain_models.PushAuthInsurancePolicyResponse:
        """
        Description: 推送保单信息
        Summary: 推送保单信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.push_auth_insurance_policy_ex(request, headers, runtime)

    async def push_auth_insurance_policy_async(
        self,
        request: blockchain_models.PushAuthInsurancePolicyRequest,
    ) -> blockchain_models.PushAuthInsurancePolicyResponse:
        """
        Description: 推送保单信息
        Summary: 推送保单信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.push_auth_insurance_policy_ex_async(request, headers, runtime)

    def push_auth_insurance_policy_ex(
        self,
        request: blockchain_models.PushAuthInsurancePolicyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthInsurancePolicyResponse:
        """
        Description: 推送保单信息
        Summary: 推送保单信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthInsurancePolicyResponse(),
            self.do_request('1.0', 'baas.auth.insurance.policy.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def push_auth_insurance_policy_ex_async(
        self,
        request: blockchain_models.PushAuthInsurancePolicyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushAuthInsurancePolicyResponse:
        """
        Description: 推送保单信息
        Summary: 推送保单信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushAuthInsurancePolicyResponse(),
            await self.do_request_async('1.0', 'baas.auth.insurance.policy.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_auth_frontend_accesstoken(
        self,
        request: blockchain_models.GetAuthFrontendAccesstokenRequest,
    ) -> blockchain_models.GetAuthFrontendAccesstokenResponse:
        """
        Description: 获取前端sdk使用的token
        Summary: 获取前端sdk使用的token
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_auth_frontend_accesstoken_ex(request, headers, runtime)

    async def get_auth_frontend_accesstoken_async(
        self,
        request: blockchain_models.GetAuthFrontendAccesstokenRequest,
    ) -> blockchain_models.GetAuthFrontendAccesstokenResponse:
        """
        Description: 获取前端sdk使用的token
        Summary: 获取前端sdk使用的token
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_auth_frontend_accesstoken_ex_async(request, headers, runtime)

    def get_auth_frontend_accesstoken_ex(
        self,
        request: blockchain_models.GetAuthFrontendAccesstokenRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthFrontendAccesstokenResponse:
        """
        Description: 获取前端sdk使用的token
        Summary: 获取前端sdk使用的token
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthFrontendAccesstokenResponse(),
            self.do_request('1.0', 'baas.auth.frontend.accesstoken.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_auth_frontend_accesstoken_ex_async(
        self,
        request: blockchain_models.GetAuthFrontendAccesstokenRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthFrontendAccesstokenResponse:
        """
        Description: 获取前端sdk使用的token
        Summary: 获取前端sdk使用的token
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthFrontendAccesstokenResponse(),
            await self.do_request_async('1.0', 'baas.auth.frontend.accesstoken.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_claim_url(
        self,
        request: blockchain_models.CreateAuthClaimUrlRequest,
    ) -> blockchain_models.CreateAuthClaimUrlResponse:
        """
        Description: 获取声明授权链接
        Summary: 获取声明授权链接
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_claim_url_ex(request, headers, runtime)

    async def create_auth_claim_url_async(
        self,
        request: blockchain_models.CreateAuthClaimUrlRequest,
    ) -> blockchain_models.CreateAuthClaimUrlResponse:
        """
        Description: 获取声明授权链接
        Summary: 获取声明授权链接
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_claim_url_ex_async(request, headers, runtime)

    def create_auth_claim_url_ex(
        self,
        request: blockchain_models.CreateAuthClaimUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthClaimUrlResponse:
        """
        Description: 获取声明授权链接
        Summary: 获取声明授权链接
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthClaimUrlResponse(),
            self.do_request('1.0', 'baas.auth.claim.url.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_claim_url_ex_async(
        self,
        request: blockchain_models.CreateAuthClaimUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthClaimUrlResponse:
        """
        Description: 获取声明授权链接
        Summary: 获取声明授权链接
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthClaimUrlResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.url.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_verify_carinfo(
        self,
        request: blockchain_models.StartAuthVerifyCarinfoRequest,
    ) -> blockchain_models.StartAuthVerifyCarinfoResponse:
        """
        Description: 行驶证核身授权
        Summary: 授权宝个人信息授权，行驶证核身授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_verify_carinfo_ex(request, headers, runtime)

    async def start_auth_verify_carinfo_async(
        self,
        request: blockchain_models.StartAuthVerifyCarinfoRequest,
    ) -> blockchain_models.StartAuthVerifyCarinfoResponse:
        """
        Description: 行驶证核身授权
        Summary: 授权宝个人信息授权，行驶证核身授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_verify_carinfo_ex_async(request, headers, runtime)

    def start_auth_verify_carinfo_ex(
        self,
        request: blockchain_models.StartAuthVerifyCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyCarinfoResponse:
        """
        Description: 行驶证核身授权
        Summary: 授权宝个人信息授权，行驶证核身授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyCarinfoResponse(),
            self.do_request('1.0', 'baas.auth.verify.carinfo.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_verify_carinfo_ex_async(
        self,
        request: blockchain_models.StartAuthVerifyCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyCarinfoResponse:
        """
        Description: 行驶证核身授权
        Summary: 授权宝个人信息授权，行驶证核身授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyCarinfoResponse(),
            await self.do_request_async('1.0', 'baas.auth.verify.carinfo.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_verify_driverinfo(
        self,
        request: blockchain_models.StartAuthVerifyDriverinfoRequest,
    ) -> blockchain_models.StartAuthVerifyDriverinfoResponse:
        """
        Description: 驾驶证相关信息核验并核身，并且结合授权宝完成授权。
        Summary: 授权宝个人信息授权，驾驶证核身授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_verify_driverinfo_ex(request, headers, runtime)

    async def start_auth_verify_driverinfo_async(
        self,
        request: blockchain_models.StartAuthVerifyDriverinfoRequest,
    ) -> blockchain_models.StartAuthVerifyDriverinfoResponse:
        """
        Description: 驾驶证相关信息核验并核身，并且结合授权宝完成授权。
        Summary: 授权宝个人信息授权，驾驶证核身授权
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_verify_driverinfo_ex_async(request, headers, runtime)

    def start_auth_verify_driverinfo_ex(
        self,
        request: blockchain_models.StartAuthVerifyDriverinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyDriverinfoResponse:
        """
        Description: 驾驶证相关信息核验并核身，并且结合授权宝完成授权。
        Summary: 授权宝个人信息授权，驾驶证核身授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyDriverinfoResponse(),
            self.do_request('1.0', 'baas.auth.verify.driverinfo.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_verify_driverinfo_ex_async(
        self,
        request: blockchain_models.StartAuthVerifyDriverinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyDriverinfoResponse:
        """
        Description: 驾驶证相关信息核验并核身，并且结合授权宝完成授权。
        Summary: 授权宝个人信息授权，驾驶证核身授权
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyDriverinfoResponse(),
            await self.do_request_async('1.0', 'baas.auth.verify.driverinfo.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_verify_carinspect(
        self,
        request: blockchain_models.StartAuthVerifyCarinspectRequest,
    ) -> blockchain_models.StartAuthVerifyCarinspectResponse:
        """
        Description: 检查车牌是否进行年检，当前状态，以及年检有效期止。
        Summary: 车检查询核验，目标车牌年检状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_verify_carinspect_ex(request, headers, runtime)

    async def start_auth_verify_carinspect_async(
        self,
        request: blockchain_models.StartAuthVerifyCarinspectRequest,
    ) -> blockchain_models.StartAuthVerifyCarinspectResponse:
        """
        Description: 检查车牌是否进行年检，当前状态，以及年检有效期止。
        Summary: 车检查询核验，目标车牌年检状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_verify_carinspect_ex_async(request, headers, runtime)

    def start_auth_verify_carinspect_ex(
        self,
        request: blockchain_models.StartAuthVerifyCarinspectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyCarinspectResponse:
        """
        Description: 检查车牌是否进行年检，当前状态，以及年检有效期止。
        Summary: 车检查询核验，目标车牌年检状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyCarinspectResponse(),
            self.do_request('1.0', 'baas.auth.verify.carinspect.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_verify_carinspect_ex_async(
        self,
        request: blockchain_models.StartAuthVerifyCarinspectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthVerifyCarinspectResponse:
        """
        Description: 检查车牌是否进行年检，当前状态，以及年检有效期止。
        Summary: 车检查询核验，目标车牌年检状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthVerifyCarinspectResponse(),
            await self.do_request_async('1.0', 'baas.auth.verify.carinspect.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_auth_claim_template(
        self,
        request: blockchain_models.GetAuthClaimTemplateRequest,
    ) -> blockchain_models.GetAuthClaimTemplateResponse:
        """
        Description: 获取授权声明模版
        Summary: 获取授权声明模版
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_auth_claim_template_ex(request, headers, runtime)

    async def get_auth_claim_template_async(
        self,
        request: blockchain_models.GetAuthClaimTemplateRequest,
    ) -> blockchain_models.GetAuthClaimTemplateResponse:
        """
        Description: 获取授权声明模版
        Summary: 获取授权声明模版
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_auth_claim_template_ex_async(request, headers, runtime)

    def get_auth_claim_template_ex(
        self,
        request: blockchain_models.GetAuthClaimTemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthClaimTemplateResponse:
        """
        Description: 获取授权声明模版
        Summary: 获取授权声明模版
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthClaimTemplateResponse(),
            self.do_request('1.0', 'baas.auth.claim.template.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_auth_claim_template_ex_async(
        self,
        request: blockchain_models.GetAuthClaimTemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthClaimTemplateResponse:
        """
        Description: 获取授权声明模版
        Summary: 获取授权声明模版
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthClaimTemplateResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.template.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_claim_vc(
        self,
        request: blockchain_models.CreateAuthClaimVcRequest,
    ) -> blockchain_models.CreateAuthClaimVcResponse:
        """
        Description: 通过claim创建vc
        Summary: 通过claim创建vc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_claim_vc_ex(request, headers, runtime)

    async def create_auth_claim_vc_async(
        self,
        request: blockchain_models.CreateAuthClaimVcRequest,
    ) -> blockchain_models.CreateAuthClaimVcResponse:
        """
        Description: 通过claim创建vc
        Summary: 通过claim创建vc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_claim_vc_ex_async(request, headers, runtime)

    def create_auth_claim_vc_ex(
        self,
        request: blockchain_models.CreateAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthClaimVcResponse:
        """
        Description: 通过claim创建vc
        Summary: 通过claim创建vc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthClaimVcResponse(),
            self.do_request('1.0', 'baas.auth.claim.vc.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_claim_vc_ex_async(
        self,
        request: blockchain_models.CreateAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthClaimVcResponse:
        """
        Description: 通过claim创建vc
        Summary: 通过claim创建vc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthClaimVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.vc.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_claim_vc(
        self,
        request: blockchain_models.QueryAuthClaimVcRequest,
    ) -> blockchain_models.QueryAuthClaimVcResponse:
        """
        Description: 查询vc详情
        Summary: 查询vc详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_claim_vc_ex(request, headers, runtime)

    async def query_auth_claim_vc_async(
        self,
        request: blockchain_models.QueryAuthClaimVcRequest,
    ) -> blockchain_models.QueryAuthClaimVcResponse:
        """
        Description: 查询vc详情
        Summary: 查询vc详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_claim_vc_ex_async(request, headers, runtime)

    def query_auth_claim_vc_ex(
        self,
        request: blockchain_models.QueryAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthClaimVcResponse:
        """
        Description: 查询vc详情
        Summary: 查询vc详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthClaimVcResponse(),
            self.do_request('1.0', 'baas.auth.claim.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_claim_vc_ex_async(
        self,
        request: blockchain_models.QueryAuthClaimVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthClaimVcResponse:
        """
        Description: 查询vc详情
        Summary: 查询vc详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthClaimVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vehicleinsurance(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceRequest,
    ) -> blockchain_models.QueryAuthVehicleinsuranceResponse:
        """
        Description: 车辆投保日期查询(存量)
        Summary: 车辆投保日期查询(存量)
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vehicleinsurance_ex(request, headers, runtime)

    async def query_auth_vehicleinsurance_async(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceRequest,
    ) -> blockchain_models.QueryAuthVehicleinsuranceResponse:
        """
        Description: 车辆投保日期查询(存量)
        Summary: 车辆投保日期查询(存量)
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vehicleinsurance_ex_async(request, headers, runtime)

    def query_auth_vehicleinsurance_ex(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVehicleinsuranceResponse:
        """
        Description: 车辆投保日期查询(存量)
        Summary: 车辆投保日期查询(存量)
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVehicleinsuranceResponse(),
            self.do_request('1.0', 'baas.auth.vehicleinsurance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vehicleinsurance_ex_async(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVehicleinsuranceResponse:
        """
        Description: 车辆投保日期查询(存量)
        Summary: 车辆投保日期查询(存量)
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVehicleinsuranceResponse(),
            await self.do_request_async('1.0', 'baas.auth.vehicleinsurance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vehicleinsurance_vc(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceVcRequest,
    ) -> blockchain_models.QueryAuthVehicleinsuranceVcResponse:
        """
        Description: 车辆投保日期查询(增量)
        Summary: 车辆投保日期查询(增量)
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vehicleinsurance_vc_ex(request, headers, runtime)

    async def query_auth_vehicleinsurance_vc_async(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceVcRequest,
    ) -> blockchain_models.QueryAuthVehicleinsuranceVcResponse:
        """
        Description: 车辆投保日期查询(增量)
        Summary: 车辆投保日期查询(增量)
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vehicleinsurance_vc_ex_async(request, headers, runtime)

    def query_auth_vehicleinsurance_vc_ex(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVehicleinsuranceVcResponse:
        """
        Description: 车辆投保日期查询(增量)
        Summary: 车辆投保日期查询(增量)
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVehicleinsuranceVcResponse(),
            self.do_request('1.0', 'baas.auth.vehicleinsurance.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vehicleinsurance_vc_ex_async(
        self,
        request: blockchain_models.QueryAuthVehicleinsuranceVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVehicleinsuranceVcResponse:
        """
        Description: 车辆投保日期查询(增量)
        Summary: 车辆投保日期查询(增量)
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVehicleinsuranceVcResponse(),
            await self.do_request_async('1.0', 'baas.auth.vehicleinsurance.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vc_statistics(
        self,
        request: blockchain_models.QueryAuthVcStatisticsRequest,
    ) -> blockchain_models.QueryAuthVcStatisticsResponse:
        """
        Description: 查询在特定业务bizType下的凭证颁发的统计数据，以及按照day维度的分布情况。
        Summary: 查询目标场景的凭证颁发的统计数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vc_statistics_ex(request, headers, runtime)

    async def query_auth_vc_statistics_async(
        self,
        request: blockchain_models.QueryAuthVcStatisticsRequest,
    ) -> blockchain_models.QueryAuthVcStatisticsResponse:
        """
        Description: 查询在特定业务bizType下的凭证颁发的统计数据，以及按照day维度的分布情况。
        Summary: 查询目标场景的凭证颁发的统计数据
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vc_statistics_ex_async(request, headers, runtime)

    def query_auth_vc_statistics_ex(
        self,
        request: blockchain_models.QueryAuthVcStatisticsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcStatisticsResponse:
        """
        Description: 查询在特定业务bizType下的凭证颁发的统计数据，以及按照day维度的分布情况。
        Summary: 查询目标场景的凭证颁发的统计数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcStatisticsResponse(),
            self.do_request('1.0', 'baas.auth.vc.statistics.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vc_statistics_ex_async(
        self,
        request: blockchain_models.QueryAuthVcStatisticsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcStatisticsResponse:
        """
        Description: 查询在特定业务bizType下的凭证颁发的统计数据，以及按照day维度的分布情况。
        Summary: 查询目标场景的凭证颁发的统计数据
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcStatisticsResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.statistics.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vc_realtime(
        self,
        request: blockchain_models.QueryAuthVcRealtimeRequest,
    ) -> blockchain_models.QueryAuthVcRealtimeResponse:
        """
        Description: 查询目标业务凭证的实时颁发的情况，返回一个列表。
        Summary: 查询目标业务凭证颁发的实时列表情况
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vc_realtime_ex(request, headers, runtime)

    async def query_auth_vc_realtime_async(
        self,
        request: blockchain_models.QueryAuthVcRealtimeRequest,
    ) -> blockchain_models.QueryAuthVcRealtimeResponse:
        """
        Description: 查询目标业务凭证的实时颁发的情况，返回一个列表。
        Summary: 查询目标业务凭证颁发的实时列表情况
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vc_realtime_ex_async(request, headers, runtime)

    def query_auth_vc_realtime_ex(
        self,
        request: blockchain_models.QueryAuthVcRealtimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcRealtimeResponse:
        """
        Description: 查询目标业务凭证的实时颁发的情况，返回一个列表。
        Summary: 查询目标业务凭证颁发的实时列表情况
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcRealtimeResponse(),
            self.do_request('1.0', 'baas.auth.vc.realtime.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vc_realtime_ex_async(
        self,
        request: blockchain_models.QueryAuthVcRealtimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcRealtimeResponse:
        """
        Description: 查询目标业务凭证的实时颁发的情况，返回一个列表。
        Summary: 查询目标业务凭证颁发的实时列表情况
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcRealtimeResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.realtime.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_org_status(
        self,
        request: blockchain_models.QueryAuthOrgStatusRequest,
    ) -> blockchain_models.QueryAuthOrgStatusResponse:
        """
        Description: 在机构颁发凭证的情况下，机构的可信度和状态会影响颁发的凭证的有效性和影响，因此提供接口查询机构状态。
        Summary: 特定场景下使用，查询机构状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_org_status_ex(request, headers, runtime)

    async def query_auth_org_status_async(
        self,
        request: blockchain_models.QueryAuthOrgStatusRequest,
    ) -> blockchain_models.QueryAuthOrgStatusResponse:
        """
        Description: 在机构颁发凭证的情况下，机构的可信度和状态会影响颁发的凭证的有效性和影响，因此提供接口查询机构状态。
        Summary: 特定场景下使用，查询机构状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_org_status_ex_async(request, headers, runtime)

    def query_auth_org_status_ex(
        self,
        request: blockchain_models.QueryAuthOrgStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthOrgStatusResponse:
        """
        Description: 在机构颁发凭证的情况下，机构的可信度和状态会影响颁发的凭证的有效性和影响，因此提供接口查询机构状态。
        Summary: 特定场景下使用，查询机构状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthOrgStatusResponse(),
            self.do_request('1.0', 'baas.auth.org.status.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_org_status_ex_async(
        self,
        request: blockchain_models.QueryAuthOrgStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthOrgStatusResponse:
        """
        Description: 在机构颁发凭证的情况下，机构的可信度和状态会影响颁发的凭证的有效性和影响，因此提供接口查询机构状态。
        Summary: 特定场景下使用，查询机构状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthOrgStatusResponse(),
            await self.do_request_async('1.0', 'baas.auth.org.status.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_asset_issue(
        self,
        request: blockchain_models.StartAuthAssetIssueRequest,
    ) -> blockchain_models.StartAuthAssetIssueResponse:
        """
        Description: 预充值交易通过身份的凭证封装的方式在区块链上资产化。
        Summary: 交易资产的归属
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_asset_issue_ex(request, headers, runtime)

    async def start_auth_asset_issue_async(
        self,
        request: blockchain_models.StartAuthAssetIssueRequest,
    ) -> blockchain_models.StartAuthAssetIssueResponse:
        """
        Description: 预充值交易通过身份的凭证封装的方式在区块链上资产化。
        Summary: 交易资产的归属
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_asset_issue_ex_async(request, headers, runtime)

    def start_auth_asset_issue_ex(
        self,
        request: blockchain_models.StartAuthAssetIssueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthAssetIssueResponse:
        """
        Description: 预充值交易通过身份的凭证封装的方式在区块链上资产化。
        Summary: 交易资产的归属
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthAssetIssueResponse(),
            self.do_request('1.0', 'baas.auth.asset.issue.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_asset_issue_ex_async(
        self,
        request: blockchain_models.StartAuthAssetIssueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthAssetIssueResponse:
        """
        Description: 预充值交易通过身份的凭证封装的方式在区块链上资产化。
        Summary: 交易资产的归属
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthAssetIssueResponse(),
            await self.do_request_async('1.0', 'baas.auth.asset.issue.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def all_auth_cert_template(
        self,
        request: blockchain_models.AllAuthCertTemplateRequest,
    ) -> blockchain_models.AllAuthCertTemplateResponse:
        """
        Description: 查询卡证模板的列表
        Summary: 查询模板列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.all_auth_cert_template_ex(request, headers, runtime)

    async def all_auth_cert_template_async(
        self,
        request: blockchain_models.AllAuthCertTemplateRequest,
    ) -> blockchain_models.AllAuthCertTemplateResponse:
        """
        Description: 查询卡证模板的列表
        Summary: 查询模板列表
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.all_auth_cert_template_ex_async(request, headers, runtime)

    def all_auth_cert_template_ex(
        self,
        request: blockchain_models.AllAuthCertTemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AllAuthCertTemplateResponse:
        """
        Description: 查询卡证模板的列表
        Summary: 查询模板列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AllAuthCertTemplateResponse(),
            self.do_request('1.0', 'baas.auth.cert.template.all', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def all_auth_cert_template_ex_async(
        self,
        request: blockchain_models.AllAuthCertTemplateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AllAuthCertTemplateResponse:
        """
        Description: 查询卡证模板的列表
        Summary: 查询模板列表
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AllAuthCertTemplateResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.template.all', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_auth_cert_instanceforcustom(
        self,
        request: blockchain_models.SaveAuthCertInstanceforcustomRequest,
    ) -> blockchain_models.SaveAuthCertInstanceforcustomResponse:
        """
        Description: 为客权业务定制化的编辑或新增证书实例，可以绕过审批流程
        Summary: 编辑或新增证书实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_auth_cert_instanceforcustom_ex(request, headers, runtime)

    async def save_auth_cert_instanceforcustom_async(
        self,
        request: blockchain_models.SaveAuthCertInstanceforcustomRequest,
    ) -> blockchain_models.SaveAuthCertInstanceforcustomResponse:
        """
        Description: 为客权业务定制化的编辑或新增证书实例，可以绕过审批流程
        Summary: 编辑或新增证书实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_auth_cert_instanceforcustom_ex_async(request, headers, runtime)

    def save_auth_cert_instanceforcustom_ex(
        self,
        request: blockchain_models.SaveAuthCertInstanceforcustomRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveAuthCertInstanceforcustomResponse:
        """
        Description: 为客权业务定制化的编辑或新增证书实例，可以绕过审批流程
        Summary: 编辑或新增证书实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveAuthCertInstanceforcustomResponse(),
            self.do_request('1.0', 'baas.auth.cert.instanceforcustom.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_auth_cert_instanceforcustom_ex_async(
        self,
        request: blockchain_models.SaveAuthCertInstanceforcustomRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveAuthCertInstanceforcustomResponse:
        """
        Description: 为客权业务定制化的编辑或新增证书实例，可以绕过审批流程
        Summary: 编辑或新增证书实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveAuthCertInstanceforcustomResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.instanceforcustom.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def batchcreate_auth_cert(
        self,
        request: blockchain_models.BatchcreateAuthCertRequest,
    ) -> blockchain_models.BatchcreateAuthCertResponse:
        """
        Description: 通过上传的领取人明细文件，为证书实例批量颁发证书
        Summary: 批量颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.batchcreate_auth_cert_ex(request, headers, runtime)

    async def batchcreate_auth_cert_async(
        self,
        request: blockchain_models.BatchcreateAuthCertRequest,
    ) -> blockchain_models.BatchcreateAuthCertResponse:
        """
        Description: 通过上传的领取人明细文件，为证书实例批量颁发证书
        Summary: 批量颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.batchcreate_auth_cert_ex_async(request, headers, runtime)

    def batchcreate_auth_cert_ex(
        self,
        request: blockchain_models.BatchcreateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAuthCertResponse:
        """
        Description: 通过上传的领取人明细文件，为证书实例批量颁发证书
        Summary: 批量颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAuthCertResponse(),
            self.do_request('1.0', 'baas.auth.cert.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def batchcreate_auth_cert_ex_async(
        self,
        request: blockchain_models.BatchcreateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BatchcreateAuthCertResponse:
        """
        Description: 通过上传的领取人明细文件，为证书实例批量颁发证书
        Summary: 批量颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BatchcreateAuthCertResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.batchcreate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_cert(
        self,
        request: blockchain_models.CreateAuthCertRequest,
    ) -> blockchain_models.CreateAuthCertResponse:
        """
        Description: 单个颁发证书
        Summary: 颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_cert_ex(request, headers, runtime)

    async def create_auth_cert_async(
        self,
        request: blockchain_models.CreateAuthCertRequest,
    ) -> blockchain_models.CreateAuthCertResponse:
        """
        Description: 单个颁发证书
        Summary: 颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_cert_ex_async(request, headers, runtime)

    def create_auth_cert_ex(
        self,
        request: blockchain_models.CreateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertResponse:
        """
        Description: 单个颁发证书
        Summary: 颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertResponse(),
            self.do_request('1.0', 'baas.auth.cert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_cert_ex_async(
        self,
        request: blockchain_models.CreateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertResponse:
        """
        Description: 单个颁发证书
        Summary: 颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def invalidate_auth_cert(
        self,
        request: blockchain_models.InvalidateAuthCertRequest,
    ) -> blockchain_models.InvalidateAuthCertResponse:
        """
        Description: 吊销已经颁发的证书
        Summary: 吊销证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.invalidate_auth_cert_ex(request, headers, runtime)

    async def invalidate_auth_cert_async(
        self,
        request: blockchain_models.InvalidateAuthCertRequest,
    ) -> blockchain_models.InvalidateAuthCertResponse:
        """
        Description: 吊销已经颁发的证书
        Summary: 吊销证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.invalidate_auth_cert_ex_async(request, headers, runtime)

    def invalidate_auth_cert_ex(
        self,
        request: blockchain_models.InvalidateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InvalidateAuthCertResponse:
        """
        Description: 吊销已经颁发的证书
        Summary: 吊销证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InvalidateAuthCertResponse(),
            self.do_request('1.0', 'baas.auth.cert.invalidate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def invalidate_auth_cert_ex_async(
        self,
        request: blockchain_models.InvalidateAuthCertRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InvalidateAuthCertResponse:
        """
        Description: 吊销已经颁发的证书
        Summary: 吊销证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InvalidateAuthCertResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.invalidate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_cert_progress(
        self,
        request: blockchain_models.QueryAuthCertProgressRequest,
    ) -> blockchain_models.QueryAuthCertProgressResponse:
        """
        Description: 查询批量颁发证书的进度详情
        Summary: 查询批量颁发证书的进度
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_cert_progress_ex(request, headers, runtime)

    async def query_auth_cert_progress_async(
        self,
        request: blockchain_models.QueryAuthCertProgressRequest,
    ) -> blockchain_models.QueryAuthCertProgressResponse:
        """
        Description: 查询批量颁发证书的进度详情
        Summary: 查询批量颁发证书的进度
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_cert_progress_ex_async(request, headers, runtime)

    def query_auth_cert_progress_ex(
        self,
        request: blockchain_models.QueryAuthCertProgressRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertProgressResponse:
        """
        Description: 查询批量颁发证书的进度详情
        Summary: 查询批量颁发证书的进度
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertProgressResponse(),
            self.do_request('1.0', 'baas.auth.cert.progress.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_cert_progress_ex_async(
        self,
        request: blockchain_models.QueryAuthCertProgressRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertProgressResponse:
        """
        Description: 查询批量颁发证书的进度详情
        Summary: 查询批量颁发证书的进度
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertProgressResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.progress.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def upload_auth_cert_instance(
        self,
        request: blockchain_models.UploadAuthCertInstanceRequest,
    ) -> blockchain_models.UploadAuthCertInstanceResponse:
        """
        Description: 上传需要批量颁发的证书领取人明细csv文件到oss服务器，并返回文件的路径
        Summary: 上传领取人明细csv文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.upload_auth_cert_instance_ex(request, headers, runtime)

    async def upload_auth_cert_instance_async(
        self,
        request: blockchain_models.UploadAuthCertInstanceRequest,
    ) -> blockchain_models.UploadAuthCertInstanceResponse:
        """
        Description: 上传需要批量颁发的证书领取人明细csv文件到oss服务器，并返回文件的路径
        Summary: 上传领取人明细csv文件
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.upload_auth_cert_instance_ex_async(request, headers, runtime)

    def upload_auth_cert_instance_ex(
        self,
        request: blockchain_models.UploadAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthCertInstanceResponse:
        """
        Description: 上传需要批量颁发的证书领取人明细csv文件到oss服务器，并返回文件的路径
        Summary: 上传领取人明细csv文件
        """
        if not UtilClient.is_unset(request.file_object):
            upload_req = blockchain_models.CreateAntcloudGatewayxFileUploadRequest(
                auth_token=request.auth_token,
                api_code='baas.auth.cert.instance.upload',
                file_name=request.file_object_name
            )
            upload_resp = self.create_antcloud_gatewayx_file_upload_ex(upload_req, headers, runtime)
            if not AntchainUtils.is_success(upload_resp.result_code, 'ok'):
                upload_auth_cert_instance_response = blockchain_models.UploadAuthCertInstanceResponse(
                    req_msg_id=upload_resp.req_msg_id,
                    result_code=upload_resp.result_code,
                    result_msg=upload_resp.result_msg
                )
                return upload_auth_cert_instance_response
            upload_headers = AntchainUtils.parse_upload_headers(upload_resp.upload_headers)
            AntchainUtils.put_object(request.file_object, upload_headers, upload_resp.upload_url)
            request.file_id = upload_resp.file_id
            request.file_object = None
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthCertInstanceResponse(),
            self.do_request('1.0', 'baas.auth.cert.instance.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def upload_auth_cert_instance_ex_async(
        self,
        request: blockchain_models.UploadAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthCertInstanceResponse:
        """
        Description: 上传需要批量颁发的证书领取人明细csv文件到oss服务器，并返回文件的路径
        Summary: 上传领取人明细csv文件
        """
        if not UtilClient.is_unset(request.file_object):
            upload_req = blockchain_models.CreateAntcloudGatewayxFileUploadRequest(
                auth_token=request.auth_token,
                api_code='baas.auth.cert.instance.upload',
                file_name=request.file_object_name
            )
            upload_resp = await self.create_antcloud_gatewayx_file_upload_ex_async(upload_req, headers, runtime)
            if not AntchainUtils.is_success(upload_resp.result_code, 'ok'):
                upload_auth_cert_instance_response = blockchain_models.UploadAuthCertInstanceResponse(
                    req_msg_id=upload_resp.req_msg_id,
                    result_code=upload_resp.result_code,
                    result_msg=upload_resp.result_msg
                )
                return upload_auth_cert_instance_response
            upload_headers = AntchainUtils.parse_upload_headers(upload_resp.upload_headers)
            await AntchainUtils.put_object_async(request.file_object, upload_headers, upload_resp.upload_url)
            request.file_id = upload_resp.file_id
            request.file_object = None
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthCertInstanceResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.instance.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def save_auth_cert_instance(
        self,
        request: blockchain_models.SaveAuthCertInstanceRequest,
    ) -> blockchain_models.SaveAuthCertInstanceResponse:
        """
        Description:  编辑或新增证书实例
        Summary:  编辑或新增证书实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.save_auth_cert_instance_ex(request, headers, runtime)

    async def save_auth_cert_instance_async(
        self,
        request: blockchain_models.SaveAuthCertInstanceRequest,
    ) -> blockchain_models.SaveAuthCertInstanceResponse:
        """
        Description:  编辑或新增证书实例
        Summary:  编辑或新增证书实例
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.save_auth_cert_instance_ex_async(request, headers, runtime)

    def save_auth_cert_instance_ex(
        self,
        request: blockchain_models.SaveAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveAuthCertInstanceResponse:
        """
        Description:  编辑或新增证书实例
        Summary:  编辑或新增证书实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveAuthCertInstanceResponse(),
            self.do_request('1.0', 'baas.auth.cert.instance.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def save_auth_cert_instance_ex_async(
        self,
        request: blockchain_models.SaveAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SaveAuthCertInstanceResponse:
        """
        Description:  编辑或新增证书实例
        Summary:  编辑或新增证书实例
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SaveAuthCertInstanceResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.instance.save', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def apply_auth_cert_instance(
        self,
        request: blockchain_models.ApplyAuthCertInstanceRequest,
    ) -> blockchain_models.ApplyAuthCertInstanceResponse:
        """
        Description: 状态为编辑中的证书实例，调用此接口提交审核
        Summary: 证书实例提交审核
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.apply_auth_cert_instance_ex(request, headers, runtime)

    async def apply_auth_cert_instance_async(
        self,
        request: blockchain_models.ApplyAuthCertInstanceRequest,
    ) -> blockchain_models.ApplyAuthCertInstanceResponse:
        """
        Description: 状态为编辑中的证书实例，调用此接口提交审核
        Summary: 证书实例提交审核
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.apply_auth_cert_instance_ex_async(request, headers, runtime)

    def apply_auth_cert_instance_ex(
        self,
        request: blockchain_models.ApplyAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyAuthCertInstanceResponse:
        """
        Description: 状态为编辑中的证书实例，调用此接口提交审核
        Summary: 证书实例提交审核
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyAuthCertInstanceResponse(),
            self.do_request('1.0', 'baas.auth.cert.instance.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def apply_auth_cert_instance_ex_async(
        self,
        request: blockchain_models.ApplyAuthCertInstanceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ApplyAuthCertInstanceResponse:
        """
        Description: 状态为编辑中的证书实例，调用此接口提交审核
        Summary: 证书实例提交审核
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ApplyAuthCertInstanceResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.instance.apply', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_auth_cert_instancedataurl(
        self,
        request: blockchain_models.GetAuthCertInstancedataurlRequest,
    ) -> blockchain_models.GetAuthCertInstancedataurlResponse:
        """
        Description: 向证书平台申请一个oss临时url，用来上传证书领取人csv文件，有效期30分钟
        Summary: 获取证书领取人csv上传url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_auth_cert_instancedataurl_ex(request, headers, runtime)

    async def get_auth_cert_instancedataurl_async(
        self,
        request: blockchain_models.GetAuthCertInstancedataurlRequest,
    ) -> blockchain_models.GetAuthCertInstancedataurlResponse:
        """
        Description: 向证书平台申请一个oss临时url，用来上传证书领取人csv文件，有效期30分钟
        Summary: 获取证书领取人csv上传url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_auth_cert_instancedataurl_ex_async(request, headers, runtime)

    def get_auth_cert_instancedataurl_ex(
        self,
        request: blockchain_models.GetAuthCertInstancedataurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthCertInstancedataurlResponse:
        """
        Description: 向证书平台申请一个oss临时url，用来上传证书领取人csv文件，有效期30分钟
        Summary: 获取证书领取人csv上传url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthCertInstancedataurlResponse(),
            self.do_request('1.0', 'baas.auth.cert.instancedataurl.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_auth_cert_instancedataurl_ex_async(
        self,
        request: blockchain_models.GetAuthCertInstancedataurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthCertInstancedataurlResponse:
        """
        Description: 向证书平台申请一个oss临时url，用来上传证书领取人csv文件，有效期30分钟
        Summary: 获取证书领取人csv上传url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthCertInstancedataurlResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.instancedataurl.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_cert_claim(
        self,
        request: blockchain_models.CreateAuthCertClaimRequest,
    ) -> blockchain_models.CreateAuthCertClaimResponse:
        """
        Description: 证书平台创建自定义存证
        Summary: 证书平台创建存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_cert_claim_ex(request, headers, runtime)

    async def create_auth_cert_claim_async(
        self,
        request: blockchain_models.CreateAuthCertClaimRequest,
    ) -> blockchain_models.CreateAuthCertClaimResponse:
        """
        Description: 证书平台创建自定义存证
        Summary: 证书平台创建存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_cert_claim_ex_async(request, headers, runtime)

    def create_auth_cert_claim_ex(
        self,
        request: blockchain_models.CreateAuthCertClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertClaimResponse:
        """
        Description: 证书平台创建自定义存证
        Summary: 证书平台创建存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertClaimResponse(),
            self.do_request('1.0', 'baas.auth.cert.claim.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_cert_claim_ex_async(
        self,
        request: blockchain_models.CreateAuthCertClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertClaimResponse:
        """
        Description: 证书平台创建自定义存证
        Summary: 证书平台创建存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertClaimResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.claim.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_cert_claim(
        self,
        request: blockchain_models.QueryAuthCertClaimRequest,
    ) -> blockchain_models.QueryAuthCertClaimResponse:
        """
        Description: 证书平台查询用户自定义存证
        Summary: 证书平台查询用户自定义存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_cert_claim_ex(request, headers, runtime)

    async def query_auth_cert_claim_async(
        self,
        request: blockchain_models.QueryAuthCertClaimRequest,
    ) -> blockchain_models.QueryAuthCertClaimResponse:
        """
        Description: 证书平台查询用户自定义存证
        Summary: 证书平台查询用户自定义存证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_cert_claim_ex_async(request, headers, runtime)

    def query_auth_cert_claim_ex(
        self,
        request: blockchain_models.QueryAuthCertClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertClaimResponse:
        """
        Description: 证书平台查询用户自定义存证
        Summary: 证书平台查询用户自定义存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertClaimResponse(),
            self.do_request('1.0', 'baas.auth.cert.claim.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_cert_claim_ex_async(
        self,
        request: blockchain_models.QueryAuthCertClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertClaimResponse:
        """
        Description: 证书平台查询用户自定义存证
        Summary: 证书平台查询用户自定义存证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertClaimResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.claim.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_cert_claimurl(
        self,
        request: blockchain_models.CreateAuthCertClaimurlRequest,
    ) -> blockchain_models.CreateAuthCertClaimurlResponse:
        """
        Description: 生成查验证书存证的url
        Summary: 生成查验证书存证的url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_cert_claimurl_ex(request, headers, runtime)

    async def create_auth_cert_claimurl_async(
        self,
        request: blockchain_models.CreateAuthCertClaimurlRequest,
    ) -> blockchain_models.CreateAuthCertClaimurlResponse:
        """
        Description: 生成查验证书存证的url
        Summary: 生成查验证书存证的url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_cert_claimurl_ex_async(request, headers, runtime)

    def create_auth_cert_claimurl_ex(
        self,
        request: blockchain_models.CreateAuthCertClaimurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertClaimurlResponse:
        """
        Description: 生成查验证书存证的url
        Summary: 生成查验证书存证的url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertClaimurlResponse(),
            self.do_request('1.0', 'baas.auth.cert.claimurl.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_cert_claimurl_ex_async(
        self,
        request: blockchain_models.CreateAuthCertClaimurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertClaimurlResponse:
        """
        Description: 生成查验证书存证的url
        Summary: 生成查验证书存证的url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertClaimurlResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.claimurl.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_auth_claim_recent(
        self,
        request: blockchain_models.GetAuthClaimRecentRequest,
    ) -> blockchain_models.GetAuthClaimRecentResponse:
        """
        Description: 获取用户已授权的最近存证信息，在理财风测卡场景获取最近的题目答案
        Summary: 获取用户已授权的最近存证信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_auth_claim_recent_ex(request, headers, runtime)

    async def get_auth_claim_recent_async(
        self,
        request: blockchain_models.GetAuthClaimRecentRequest,
    ) -> blockchain_models.GetAuthClaimRecentResponse:
        """
        Description: 获取用户已授权的最近存证信息，在理财风测卡场景获取最近的题目答案
        Summary: 获取用户已授权的最近存证信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_auth_claim_recent_ex_async(request, headers, runtime)

    def get_auth_claim_recent_ex(
        self,
        request: blockchain_models.GetAuthClaimRecentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthClaimRecentResponse:
        """
        Description: 获取用户已授权的最近存证信息，在理财风测卡场景获取最近的题目答案
        Summary: 获取用户已授权的最近存证信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthClaimRecentResponse(),
            self.do_request('1.0', 'baas.auth.claim.recent.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_auth_claim_recent_ex_async(
        self,
        request: blockchain_models.GetAuthClaimRecentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthClaimRecentResponse:
        """
        Description: 获取用户已授权的最近存证信息，在理财风测卡场景获取最近的题目答案
        Summary: 获取用户已授权的最近存证信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthClaimRecentResponse(),
            await self.do_request_async('1.0', 'baas.auth.claim.recent.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_auth_contract(
        self,
        request: blockchain_models.ExecAuthContractRequest,
    ) -> blockchain_models.ExecAuthContractResponse:
        """
        Description: 新的：baas.auth.contract.claim.exec
        Summary: 合约调用_废弃
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_auth_contract_ex(request, headers, runtime)

    async def exec_auth_contract_async(
        self,
        request: blockchain_models.ExecAuthContractRequest,
    ) -> blockchain_models.ExecAuthContractResponse:
        """
        Description: 新的：baas.auth.contract.claim.exec
        Summary: 合约调用_废弃
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_auth_contract_ex_async(request, headers, runtime)

    def exec_auth_contract_ex(
        self,
        request: blockchain_models.ExecAuthContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecAuthContractResponse:
        """
        Description: 新的：baas.auth.contract.claim.exec
        Summary: 合约调用_废弃
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecAuthContractResponse(),
            self.do_request('1.0', 'baas.auth.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_auth_contract_ex_async(
        self,
        request: blockchain_models.ExecAuthContractRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecAuthContractResponse:
        """
        Description: 新的：baas.auth.contract.claim.exec
        Summary: 合约调用_废弃
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecAuthContractResponse(),
            await self.do_request_async('1.0', 'baas.auth.contract.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_scene_authstatus(
        self,
        request: blockchain_models.QueryAuthSceneAuthstatusRequest,
    ) -> blockchain_models.QueryAuthSceneAuthstatusResponse:
        """
        Description: 查看用户对于某一场景的授权状态
        Summary: 查看用户授权状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_scene_authstatus_ex(request, headers, runtime)

    async def query_auth_scene_authstatus_async(
        self,
        request: blockchain_models.QueryAuthSceneAuthstatusRequest,
    ) -> blockchain_models.QueryAuthSceneAuthstatusResponse:
        """
        Description: 查看用户对于某一场景的授权状态
        Summary: 查看用户授权状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_scene_authstatus_ex_async(request, headers, runtime)

    def query_auth_scene_authstatus_ex(
        self,
        request: blockchain_models.QueryAuthSceneAuthstatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthSceneAuthstatusResponse:
        """
        Description: 查看用户对于某一场景的授权状态
        Summary: 查看用户授权状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthSceneAuthstatusResponse(),
            self.do_request('1.0', 'baas.auth.scene.authstatus.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_scene_authstatus_ex_async(
        self,
        request: blockchain_models.QueryAuthSceneAuthstatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthSceneAuthstatusResponse:
        """
        Description: 查看用户对于某一场景的授权状态
        Summary: 查看用户授权状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthSceneAuthstatusResponse(),
            await self.do_request_async('1.0', 'baas.auth.scene.authstatus.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def exec_auth_contract_claim(
        self,
        request: blockchain_models.ExecAuthContractClaimRequest,
    ) -> blockchain_models.ExecAuthContractClaimResponse:
        """
        Description: 使用调用方did注册的vc channel链上账户调用指定合约
        Summary: 合约调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.exec_auth_contract_claim_ex(request, headers, runtime)

    async def exec_auth_contract_claim_async(
        self,
        request: blockchain_models.ExecAuthContractClaimRequest,
    ) -> blockchain_models.ExecAuthContractClaimResponse:
        """
        Description: 使用调用方did注册的vc channel链上账户调用指定合约
        Summary: 合约调用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.exec_auth_contract_claim_ex_async(request, headers, runtime)

    def exec_auth_contract_claim_ex(
        self,
        request: blockchain_models.ExecAuthContractClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecAuthContractClaimResponse:
        """
        Description: 使用调用方did注册的vc channel链上账户调用指定合约
        Summary: 合约调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecAuthContractClaimResponse(),
            self.do_request('1.0', 'baas.auth.contract.claim.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def exec_auth_contract_claim_ex_async(
        self,
        request: blockchain_models.ExecAuthContractClaimRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ExecAuthContractClaimResponse:
        """
        Description: 使用调用方did注册的vc channel链上账户调用指定合约
        Summary: 合约调用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ExecAuthContractClaimResponse(),
            await self.do_request_async('1.0', 'baas.auth.contract.claim.exec', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def create_auth_cert_detailpageurl(
        self,
        request: blockchain_models.CreateAuthCertDetailpageurlRequest,
    ) -> blockchain_models.CreateAuthCertDetailpageurlResponse:
        """
        Description: B类用户获取证书查验页面二维码的url
        Summary: 获取证书查验页面二维码的url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_auth_cert_detailpageurl_ex(request, headers, runtime)

    async def create_auth_cert_detailpageurl_async(
        self,
        request: blockchain_models.CreateAuthCertDetailpageurlRequest,
    ) -> blockchain_models.CreateAuthCertDetailpageurlResponse:
        """
        Description: B类用户获取证书查验页面二维码的url
        Summary: 获取证书查验页面二维码的url
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_auth_cert_detailpageurl_ex_async(request, headers, runtime)

    def create_auth_cert_detailpageurl_ex(
        self,
        request: blockchain_models.CreateAuthCertDetailpageurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertDetailpageurlResponse:
        """
        Description: B类用户获取证书查验页面二维码的url
        Summary: 获取证书查验页面二维码的url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertDetailpageurlResponse(),
            self.do_request('1.0', 'baas.auth.cert.detailpageurl.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def create_auth_cert_detailpageurl_ex_async(
        self,
        request: blockchain_models.CreateAuthCertDetailpageurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CreateAuthCertDetailpageurlResponse:
        """
        Description: B类用户获取证书查验页面二维码的url
        Summary: 获取证书查验页面二维码的url
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CreateAuthCertDetailpageurlResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.detailpageurl.create', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def sign_auth_agreement_user(
        self,
        request: blockchain_models.SignAuthAgreementUserRequest,
    ) -> blockchain_models.SignAuthAgreementUserResponse:
        """
        Description: 用户合约签约接口
        Summary: 用户合约签约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.sign_auth_agreement_user_ex(request, headers, runtime)

    async def sign_auth_agreement_user_async(
        self,
        request: blockchain_models.SignAuthAgreementUserRequest,
    ) -> blockchain_models.SignAuthAgreementUserResponse:
        """
        Description: 用户合约签约接口
        Summary: 用户合约签约
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.sign_auth_agreement_user_ex_async(request, headers, runtime)

    def sign_auth_agreement_user_ex(
        self,
        request: blockchain_models.SignAuthAgreementUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SignAuthAgreementUserResponse:
        """
        Description: 用户合约签约接口
        Summary: 用户合约签约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SignAuthAgreementUserResponse(),
            self.do_request('1.0', 'baas.auth.agreement.user.sign', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def sign_auth_agreement_user_ex_async(
        self,
        request: blockchain_models.SignAuthAgreementUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SignAuthAgreementUserResponse:
        """
        Description: 用户合约签约接口
        Summary: 用户合约签约
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SignAuthAgreementUserResponse(),
            await self.do_request_async('1.0', 'baas.auth.agreement.user.sign', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def bind_auth_poap(
        self,
        request: blockchain_models.BindAuthPoapRequest,
    ) -> blockchain_models.BindAuthPoapResponse:
        """
        Description: 给指定用户发放POAP徽章
        Summary: 给指定用户发放POAP徽章
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.bind_auth_poap_ex(request, headers, runtime)

    async def bind_auth_poap_async(
        self,
        request: blockchain_models.BindAuthPoapRequest,
    ) -> blockchain_models.BindAuthPoapResponse:
        """
        Description: 给指定用户发放POAP徽章
        Summary: 给指定用户发放POAP徽章
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.bind_auth_poap_ex_async(request, headers, runtime)

    def bind_auth_poap_ex(
        self,
        request: blockchain_models.BindAuthPoapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BindAuthPoapResponse:
        """
        Description: 给指定用户发放POAP徽章
        Summary: 给指定用户发放POAP徽章
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BindAuthPoapResponse(),
            self.do_request('1.0', 'baas.auth.poap.bind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def bind_auth_poap_ex_async(
        self,
        request: blockchain_models.BindAuthPoapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.BindAuthPoapResponse:
        """
        Description: 给指定用户发放POAP徽章
        Summary: 给指定用户发放POAP徽章
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.BindAuthPoapResponse(),
            await self.do_request_async('1.0', 'baas.auth.poap.bind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_poap(
        self,
        request: blockchain_models.QueryAuthPoapRequest,
    ) -> blockchain_models.QueryAuthPoapResponse:
        """
        Description: 根据ID查询POAP徽章详情
        Summary: 查询POAP徽章详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_poap_ex(request, headers, runtime)

    async def query_auth_poap_async(
        self,
        request: blockchain_models.QueryAuthPoapRequest,
    ) -> blockchain_models.QueryAuthPoapResponse:
        """
        Description: 根据ID查询POAP徽章详情
        Summary: 查询POAP徽章详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_poap_ex_async(request, headers, runtime)

    def query_auth_poap_ex(
        self,
        request: blockchain_models.QueryAuthPoapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthPoapResponse:
        """
        Description: 根据ID查询POAP徽章详情
        Summary: 查询POAP徽章详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthPoapResponse(),
            self.do_request('1.0', 'baas.auth.poap.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_poap_ex_async(
        self,
        request: blockchain_models.QueryAuthPoapRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthPoapResponse:
        """
        Description: 根据ID查询POAP徽章详情
        Summary: 查询POAP徽章详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthPoapResponse(),
            await self.do_request_async('1.0', 'baas.auth.poap.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_auth_data(
        self,
        request: blockchain_models.StartAuthDataRequest,
    ) -> blockchain_models.StartAuthDataResponse:
        """
        Description: 授权宝数据授权流程，需要请求方先进行请求记录。
        Summary: 开启数据授权流程，首先记录授权请求
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_auth_data_ex(request, headers, runtime)

    async def start_auth_data_async(
        self,
        request: blockchain_models.StartAuthDataRequest,
    ) -> blockchain_models.StartAuthDataResponse:
        """
        Description: 授权宝数据授权流程，需要请求方先进行请求记录。
        Summary: 开启数据授权流程，首先记录授权请求
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_auth_data_ex_async(request, headers, runtime)

    def start_auth_data_ex(
        self,
        request: blockchain_models.StartAuthDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthDataResponse:
        """
        Description: 授权宝数据授权流程，需要请求方先进行请求记录。
        Summary: 开启数据授权流程，首先记录授权请求
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthDataResponse(),
            self.do_request('1.0', 'baas.auth.data.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_auth_data_ex_async(
        self,
        request: blockchain_models.StartAuthDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartAuthDataResponse:
        """
        Description: 授权宝数据授权流程，需要请求方先进行请求记录。
        Summary: 开启数据授权流程，首先记录授权请求
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartAuthDataResponse(),
            await self.do_request_async('1.0', 'baas.auth.data.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def get_auth_data(
        self,
        request: blockchain_models.GetAuthDataRequest,
    ) -> blockchain_models.GetAuthDataResponse:
        """
        Description: 授权宝数据授权流程，调用方经过授权之后请求数据
        Summary: 请求授权的数据，加密传输
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_auth_data_ex(request, headers, runtime)

    async def get_auth_data_async(
        self,
        request: blockchain_models.GetAuthDataRequest,
    ) -> blockchain_models.GetAuthDataResponse:
        """
        Description: 授权宝数据授权流程，调用方经过授权之后请求数据
        Summary: 请求授权的数据，加密传输
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_auth_data_ex_async(request, headers, runtime)

    def get_auth_data_ex(
        self,
        request: blockchain_models.GetAuthDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthDataResponse:
        """
        Description: 授权宝数据授权流程，调用方经过授权之后请求数据
        Summary: 请求授权的数据，加密传输
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthDataResponse(),
            self.do_request('1.0', 'baas.auth.data.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def get_auth_data_ex_async(
        self,
        request: blockchain_models.GetAuthDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.GetAuthDataResponse:
        """
        Description: 授权宝数据授权流程，调用方经过授权之后请求数据
        Summary: 请求授权的数据，加密传输
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.GetAuthDataResponse(),
            await self.do_request_async('1.0', 'baas.auth.data.get', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_identityauth(
        self,
        request: blockchain_models.QueryAuthIdentityauthRequest,
    ) -> blockchain_models.QueryAuthIdentityauthResponse:
        """
        Description: 查询核身结果
        Summary: 查询核身结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_identityauth_ex(request, headers, runtime)

    async def query_auth_identityauth_async(
        self,
        request: blockchain_models.QueryAuthIdentityauthRequest,
    ) -> blockchain_models.QueryAuthIdentityauthResponse:
        """
        Description: 查询核身结果
        Summary: 查询核身结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_identityauth_ex_async(request, headers, runtime)

    def query_auth_identityauth_ex(
        self,
        request: blockchain_models.QueryAuthIdentityauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthIdentityauthResponse:
        """
        Description: 查询核身结果
        Summary: 查询核身结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthIdentityauthResponse(),
            self.do_request('1.0', 'baas.auth.identityauth.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_identityauth_ex_async(
        self,
        request: blockchain_models.QueryAuthIdentityauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthIdentityauthResponse:
        """
        Description: 查询核身结果
        Summary: 查询核身结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthIdentityauthResponse(),
            await self.do_request_async('1.0', 'baas.auth.identityauth.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_cert_detailurl(
        self,
        request: blockchain_models.QueryAuthCertDetailurlRequest,
    ) -> blockchain_models.QueryAuthCertDetailurlResponse:
        """
        Description: 查询证书的详情h5链接
        Summary: 查询证书的详情h5链接
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_cert_detailurl_ex(request, headers, runtime)

    async def query_auth_cert_detailurl_async(
        self,
        request: blockchain_models.QueryAuthCertDetailurlRequest,
    ) -> blockchain_models.QueryAuthCertDetailurlResponse:
        """
        Description: 查询证书的详情h5链接
        Summary: 查询证书的详情h5链接
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_cert_detailurl_ex_async(request, headers, runtime)

    def query_auth_cert_detailurl_ex(
        self,
        request: blockchain_models.QueryAuthCertDetailurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertDetailurlResponse:
        """
        Description: 查询证书的详情h5链接
        Summary: 查询证书的详情h5链接
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertDetailurlResponse(),
            self.do_request('1.0', 'baas.auth.cert.detailurl.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_cert_detailurl_ex_async(
        self,
        request: blockchain_models.QueryAuthCertDetailurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCertDetailurlResponse:
        """
        Description: 查询证书的详情h5链接
        Summary: 查询证书的详情h5链接
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCertDetailurlResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.detailurl.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def notify_auth_task_status(
        self,
        request: blockchain_models.NotifyAuthTaskStatusRequest,
    ) -> blockchain_models.NotifyAuthTaskStatusResponse:
        """
        Description: 主站应用同步授权宝权益任务的完成情况
        Summary: 主站应用同步授权宝权益任务的完成情况
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.notify_auth_task_status_ex(request, headers, runtime)

    async def notify_auth_task_status_async(
        self,
        request: blockchain_models.NotifyAuthTaskStatusRequest,
    ) -> blockchain_models.NotifyAuthTaskStatusResponse:
        """
        Description: 主站应用同步授权宝权益任务的完成情况
        Summary: 主站应用同步授权宝权益任务的完成情况
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.notify_auth_task_status_ex_async(request, headers, runtime)

    def notify_auth_task_status_ex(
        self,
        request: blockchain_models.NotifyAuthTaskStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.NotifyAuthTaskStatusResponse:
        """
        Description: 主站应用同步授权宝权益任务的完成情况
        Summary: 主站应用同步授权宝权益任务的完成情况
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.NotifyAuthTaskStatusResponse(),
            self.do_request('1.0', 'baas.auth.task.status.notify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def notify_auth_task_status_ex_async(
        self,
        request: blockchain_models.NotifyAuthTaskStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.NotifyAuthTaskStatusResponse:
        """
        Description: 主站应用同步授权宝权益任务的完成情况
        Summary: 主站应用同步授权宝权益任务的完成情况
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.NotifyAuthTaskStatusResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.status.notify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def pause_auth_task(
        self,
        request: blockchain_models.PauseAuthTaskRequest,
    ) -> blockchain_models.PauseAuthTaskResponse:
        """
        Description: 任务暂停
        Summary: 任务暂停
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pause_auth_task_ex(request, headers, runtime)

    async def pause_auth_task_async(
        self,
        request: blockchain_models.PauseAuthTaskRequest,
    ) -> blockchain_models.PauseAuthTaskResponse:
        """
        Description: 任务暂停
        Summary: 任务暂停
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pause_auth_task_ex_async(request, headers, runtime)

    def pause_auth_task_ex(
        self,
        request: blockchain_models.PauseAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PauseAuthTaskResponse:
        """
        Description: 任务暂停
        Summary: 任务暂停
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PauseAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.pause', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def pause_auth_task_ex_async(
        self,
        request: blockchain_models.PauseAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PauseAuthTaskResponse:
        """
        Description: 任务暂停
        Summary: 任务暂停
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PauseAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.pause', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def finish_auth_task(
        self,
        request: blockchain_models.FinishAuthTaskRequest,
    ) -> blockchain_models.FinishAuthTaskResponse:
        """
        Description: 任务完成
        Summary: 任务完成
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.finish_auth_task_ex(request, headers, runtime)

    async def finish_auth_task_async(
        self,
        request: blockchain_models.FinishAuthTaskRequest,
    ) -> blockchain_models.FinishAuthTaskResponse:
        """
        Description: 任务完成
        Summary: 任务完成
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.finish_auth_task_ex_async(request, headers, runtime)

    def finish_auth_task_ex(
        self,
        request: blockchain_models.FinishAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FinishAuthTaskResponse:
        """
        Description: 任务完成
        Summary: 任务完成
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FinishAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.finish', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def finish_auth_task_ex_async(
        self,
        request: blockchain_models.FinishAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.FinishAuthTaskResponse:
        """
        Description: 任务完成
        Summary: 任务完成
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.FinishAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.finish', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reopen_auth_task(
        self,
        request: blockchain_models.ReopenAuthTaskRequest,
    ) -> blockchain_models.ReopenAuthTaskResponse:
        """
        Description: 任务重启
        Summary: 任务重启
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reopen_auth_task_ex(request, headers, runtime)

    async def reopen_auth_task_async(
        self,
        request: blockchain_models.ReopenAuthTaskRequest,
    ) -> blockchain_models.ReopenAuthTaskResponse:
        """
        Description: 任务重启
        Summary: 任务重启
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reopen_auth_task_ex_async(request, headers, runtime)

    def reopen_auth_task_ex(
        self,
        request: blockchain_models.ReopenAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReopenAuthTaskResponse:
        """
        Description: 任务重启
        Summary: 任务重启
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReopenAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.reopen', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reopen_auth_task_ex_async(
        self,
        request: blockchain_models.ReopenAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ReopenAuthTaskResponse:
        """
        Description: 任务重启
        Summary: 任务重启
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ReopenAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.reopen', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def operate_auth_task(
        self,
        request: blockchain_models.OperateAuthTaskRequest,
    ) -> blockchain_models.OperateAuthTaskResponse:
        """
        Description: 样本量修改
        Summary: 样本量修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.operate_auth_task_ex(request, headers, runtime)

    async def operate_auth_task_async(
        self,
        request: blockchain_models.OperateAuthTaskRequest,
    ) -> blockchain_models.OperateAuthTaskResponse:
        """
        Description: 样本量修改
        Summary: 样本量修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.operate_auth_task_ex_async(request, headers, runtime)

    def operate_auth_task_ex(
        self,
        request: blockchain_models.OperateAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OperateAuthTaskResponse:
        """
        Description: 样本量修改
        Summary: 样本量修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OperateAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.operate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def operate_auth_task_ex_async(
        self,
        request: blockchain_models.OperateAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OperateAuthTaskResponse:
        """
        Description: 样本量修改
        Summary: 样本量修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OperateAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.operate', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_task(
        self,
        request: blockchain_models.QueryAuthTaskRequest,
    ) -> blockchain_models.QueryAuthTaskResponse:
        """
        Description: 查询人群标签取值范围
        Summary: 查询人群标签取值范围
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_task_ex(request, headers, runtime)

    async def query_auth_task_async(
        self,
        request: blockchain_models.QueryAuthTaskRequest,
    ) -> blockchain_models.QueryAuthTaskResponse:
        """
        Description: 查询人群标签取值范围
        Summary: 查询人群标签取值范围
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_task_ex_async(request, headers, runtime)

    def query_auth_task_ex(
        self,
        request: blockchain_models.QueryAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthTaskResponse:
        """
        Description: 查询人群标签取值范围
        Summary: 查询人群标签取值范围
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_task_ex_async(
        self,
        request: blockchain_models.QueryAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthTaskResponse:
        """
        Description: 查询人群标签取值范围
        Summary: 查询人群标签取值范围
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def count_auth_task(
        self,
        request: blockchain_models.CountAuthTaskRequest,
    ) -> blockchain_models.CountAuthTaskResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.count_auth_task_ex(request, headers, runtime)

    async def count_auth_task_async(
        self,
        request: blockchain_models.CountAuthTaskRequest,
    ) -> blockchain_models.CountAuthTaskResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.count_auth_task_ex_async(request, headers, runtime)

    def count_auth_task_ex(
        self,
        request: blockchain_models.CountAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CountAuthTaskResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CountAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.count', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def count_auth_task_ex_async(
        self,
        request: blockchain_models.CountAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CountAuthTaskResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CountAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.count', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def match_auth_task(
        self,
        request: blockchain_models.MatchAuthTaskRequest,
    ) -> blockchain_models.MatchAuthTaskResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.match_auth_task_ex(request, headers, runtime)

    async def match_auth_task_async(
        self,
        request: blockchain_models.MatchAuthTaskRequest,
    ) -> blockchain_models.MatchAuthTaskResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.match_auth_task_ex_async(request, headers, runtime)

    def match_auth_task_ex(
        self,
        request: blockchain_models.MatchAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.MatchAuthTaskResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.MatchAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.match', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def match_auth_task_ex_async(
        self,
        request: blockchain_models.MatchAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.MatchAuthTaskResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.MatchAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.match', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def submit_auth_task(
        self,
        request: blockchain_models.SubmitAuthTaskRequest,
    ) -> blockchain_models.SubmitAuthTaskResponse:
        """
        Description: 问卷任务提交
        Summary: 问卷任务提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.submit_auth_task_ex(request, headers, runtime)

    async def submit_auth_task_async(
        self,
        request: blockchain_models.SubmitAuthTaskRequest,
    ) -> blockchain_models.SubmitAuthTaskResponse:
        """
        Description: 问卷任务提交
        Summary: 问卷任务提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.submit_auth_task_ex_async(request, headers, runtime)

    def submit_auth_task_ex(
        self,
        request: blockchain_models.SubmitAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthTaskResponse:
        """
        Description: 问卷任务提交
        Summary: 问卷任务提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def submit_auth_task_ex_async(
        self,
        request: blockchain_models.SubmitAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthTaskResponse:
        """
        Description: 问卷任务提交
        Summary: 问卷任务提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def detail_auth_task(
        self,
        request: blockchain_models.DetailAuthTaskRequest,
    ) -> blockchain_models.DetailAuthTaskResponse:
        """
        Description: 问卷任务详情
        Summary: 问卷任务详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.detail_auth_task_ex(request, headers, runtime)

    async def detail_auth_task_async(
        self,
        request: blockchain_models.DetailAuthTaskRequest,
    ) -> blockchain_models.DetailAuthTaskResponse:
        """
        Description: 问卷任务详情
        Summary: 问卷任务详情
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.detail_auth_task_ex_async(request, headers, runtime)

    def detail_auth_task_ex(
        self,
        request: blockchain_models.DetailAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DetailAuthTaskResponse:
        """
        Description: 问卷任务详情
        Summary: 问卷任务详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DetailAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.detail', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def detail_auth_task_ex_async(
        self,
        request: blockchain_models.DetailAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.DetailAuthTaskResponse:
        """
        Description: 问卷任务详情
        Summary: 问卷任务详情
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.DetailAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.detail', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_auth_task(
        self,
        request: blockchain_models.UpdateAuthTaskRequest,
    ) -> blockchain_models.UpdateAuthTaskResponse:
        """
        Description: 任务修改
        Summary: 任务修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_auth_task_ex(request, headers, runtime)

    async def update_auth_task_async(
        self,
        request: blockchain_models.UpdateAuthTaskRequest,
    ) -> blockchain_models.UpdateAuthTaskResponse:
        """
        Description: 任务修改
        Summary: 任务修改
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_auth_task_ex_async(request, headers, runtime)

    def update_auth_task_ex(
        self,
        request: blockchain_models.UpdateAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateAuthTaskResponse:
        """
        Description: 任务修改
        Summary: 任务修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_auth_task_ex_async(
        self,
        request: blockchain_models.UpdateAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateAuthTaskResponse:
        """
        Description: 任务修改
        Summary: 任务修改
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def count_auth_task_crowd(
        self,
        request: blockchain_models.CountAuthTaskCrowdRequest,
    ) -> blockchain_models.CountAuthTaskCrowdResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.count_auth_task_crowd_ex(request, headers, runtime)

    async def count_auth_task_crowd_async(
        self,
        request: blockchain_models.CountAuthTaskCrowdRequest,
    ) -> blockchain_models.CountAuthTaskCrowdResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.count_auth_task_crowd_ex_async(request, headers, runtime)

    def count_auth_task_crowd_ex(
        self,
        request: blockchain_models.CountAuthTaskCrowdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CountAuthTaskCrowdResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CountAuthTaskCrowdResponse(),
            self.do_request('1.0', 'baas.auth.task.crowd.count', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def count_auth_task_crowd_ex_async(
        self,
        request: blockchain_models.CountAuthTaskCrowdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.CountAuthTaskCrowdResponse:
        """
        Description: 人群量级查询
        Summary: 人群量级查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.CountAuthTaskCrowdResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.crowd.count', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def match_auth_task_crowd(
        self,
        request: blockchain_models.MatchAuthTaskCrowdRequest,
    ) -> blockchain_models.MatchAuthTaskCrowdResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.match_auth_task_crowd_ex(request, headers, runtime)

    async def match_auth_task_crowd_async(
        self,
        request: blockchain_models.MatchAuthTaskCrowdRequest,
    ) -> blockchain_models.MatchAuthTaskCrowdResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.match_auth_task_crowd_ex_async(request, headers, runtime)

    def match_auth_task_crowd_ex(
        self,
        request: blockchain_models.MatchAuthTaskCrowdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.MatchAuthTaskCrowdResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.MatchAuthTaskCrowdResponse(),
            self.do_request('1.0', 'baas.auth.task.crowd.match', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def match_auth_task_crowd_ex_async(
        self,
        request: blockchain_models.MatchAuthTaskCrowdRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.MatchAuthTaskCrowdResponse:
        """
        Description: 人群匹配查询
        Summary: 人群匹配查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.MatchAuthTaskCrowdResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.crowd.match', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_task_label(
        self,
        request: blockchain_models.QueryAuthTaskLabelRequest,
    ) -> blockchain_models.QueryAuthTaskLabelResponse:
        """
        Description: 人群标签取值范围查询
        Summary: 人群标签取值范围查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_task_label_ex(request, headers, runtime)

    async def query_auth_task_label_async(
        self,
        request: blockchain_models.QueryAuthTaskLabelRequest,
    ) -> blockchain_models.QueryAuthTaskLabelResponse:
        """
        Description: 人群标签取值范围查询
        Summary: 人群标签取值范围查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_task_label_ex_async(request, headers, runtime)

    def query_auth_task_label_ex(
        self,
        request: blockchain_models.QueryAuthTaskLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthTaskLabelResponse:
        """
        Description: 人群标签取值范围查询
        Summary: 人群标签取值范围查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthTaskLabelResponse(),
            self.do_request('1.0', 'baas.auth.task.label.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_task_label_ex_async(
        self,
        request: blockchain_models.QueryAuthTaskLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthTaskLabelResponse:
        """
        Description: 人群标签取值范围查询
        Summary: 人群标签取值范围查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthTaskLabelResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.label.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def list_auth_task(
        self,
        request: blockchain_models.ListAuthTaskRequest,
    ) -> blockchain_models.ListAuthTaskResponse:
        """
        Description: 任务列表查询
        Summary: 任务列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_auth_task_ex(request, headers, runtime)

    async def list_auth_task_async(
        self,
        request: blockchain_models.ListAuthTaskRequest,
    ) -> blockchain_models.ListAuthTaskResponse:
        """
        Description: 任务列表查询
        Summary: 任务列表查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_auth_task_ex_async(request, headers, runtime)

    def list_auth_task_ex(
        self,
        request: blockchain_models.ListAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListAuthTaskResponse:
        """
        Description: 任务列表查询
        Summary: 任务列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListAuthTaskResponse(),
            self.do_request('1.0', 'baas.auth.task.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def list_auth_task_ex_async(
        self,
        request: blockchain_models.ListAuthTaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.ListAuthTaskResponse:
        """
        Description: 任务列表查询
        Summary: 任务列表查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.ListAuthTaskResponse(),
            await self.do_request_async('1.0', 'baas.auth.task.list', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def unbind_auth_equity(
        self,
        request: blockchain_models.UnbindAuthEquityRequest,
    ) -> blockchain_models.UnbindAuthEquityResponse:
        """
        Description: 权益退订openAPI接口
        Summary: 权益退订
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.unbind_auth_equity_ex(request, headers, runtime)

    async def unbind_auth_equity_async(
        self,
        request: blockchain_models.UnbindAuthEquityRequest,
    ) -> blockchain_models.UnbindAuthEquityResponse:
        """
        Description: 权益退订openAPI接口
        Summary: 权益退订
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.unbind_auth_equity_ex_async(request, headers, runtime)

    def unbind_auth_equity_ex(
        self,
        request: blockchain_models.UnbindAuthEquityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnbindAuthEquityResponse:
        """
        Description: 权益退订openAPI接口
        Summary: 权益退订
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnbindAuthEquityResponse(),
            self.do_request('1.0', 'baas.auth.equity.unbind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def unbind_auth_equity_ex_async(
        self,
        request: blockchain_models.UnbindAuthEquityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UnbindAuthEquityResponse:
        """
        Description: 权益退订openAPI接口
        Summary: 权益退订
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UnbindAuthEquityResponse(),
            await self.do_request_async('1.0', 'baas.auth.equity.unbind', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def repay_auth_equity(
        self,
        request: blockchain_models.RepayAuthEquityRequest,
    ) -> blockchain_models.RepayAuthEquityResponse:
        """
        Description: 权益退款
        Summary: 权益退款接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.repay_auth_equity_ex(request, headers, runtime)

    async def repay_auth_equity_async(
        self,
        request: blockchain_models.RepayAuthEquityRequest,
    ) -> blockchain_models.RepayAuthEquityResponse:
        """
        Description: 权益退款
        Summary: 权益退款接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.repay_auth_equity_ex_async(request, headers, runtime)

    def repay_auth_equity_ex(
        self,
        request: blockchain_models.RepayAuthEquityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RepayAuthEquityResponse:
        """
        Description: 权益退款
        Summary: 权益退款接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RepayAuthEquityResponse(),
            self.do_request('1.0', 'baas.auth.equity.repay', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def repay_auth_equity_ex_async(
        self,
        request: blockchain_models.RepayAuthEquityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RepayAuthEquityResponse:
        """
        Description: 权益退款
        Summary: 权益退款接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RepayAuthEquityResponse(),
            await self.do_request_async('1.0', 'baas.auth.equity.repay', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def verify_auth_token_validity(
        self,
        request: blockchain_models.VerifyAuthTokenValidityRequest,
    ) -> blockchain_models.VerifyAuthTokenValidityResponse:
        """
        Description: 授权token校验
        Summary: 授权token校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.verify_auth_token_validity_ex(request, headers, runtime)

    async def verify_auth_token_validity_async(
        self,
        request: blockchain_models.VerifyAuthTokenValidityRequest,
    ) -> blockchain_models.VerifyAuthTokenValidityResponse:
        """
        Description: 授权token校验
        Summary: 授权token校验
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.verify_auth_token_validity_ex_async(request, headers, runtime)

    def verify_auth_token_validity_ex(
        self,
        request: blockchain_models.VerifyAuthTokenValidityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyAuthTokenValidityResponse:
        """
        Description: 授权token校验
        Summary: 授权token校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyAuthTokenValidityResponse(),
            self.do_request('1.0', 'baas.auth.token.validity.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def verify_auth_token_validity_ex_async(
        self,
        request: blockchain_models.VerifyAuthTokenValidityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyAuthTokenValidityResponse:
        """
        Description: 授权token校验
        Summary: 授权token校验
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyAuthTokenValidityResponse(),
            await self.do_request_async('1.0', 'baas.auth.token.validity.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def verify_auth_business_user(
        self,
        request: blockchain_models.VerifyAuthBusinessUserRequest,
    ) -> blockchain_models.VerifyAuthBusinessUserResponse:
        """
        Description: 核验当前用户是否权益新用户
        Summary: 权益核验是否新用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.verify_auth_business_user_ex(request, headers, runtime)

    async def verify_auth_business_user_async(
        self,
        request: blockchain_models.VerifyAuthBusinessUserRequest,
    ) -> blockchain_models.VerifyAuthBusinessUserResponse:
        """
        Description: 核验当前用户是否权益新用户
        Summary: 权益核验是否新用户
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.verify_auth_business_user_ex_async(request, headers, runtime)

    def verify_auth_business_user_ex(
        self,
        request: blockchain_models.VerifyAuthBusinessUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyAuthBusinessUserResponse:
        """
        Description: 核验当前用户是否权益新用户
        Summary: 权益核验是否新用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyAuthBusinessUserResponse(),
            self.do_request('1.0', 'baas.auth.business.user.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def verify_auth_business_user_ex_async(
        self,
        request: blockchain_models.VerifyAuthBusinessUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.VerifyAuthBusinessUserResponse:
        """
        Description: 核验当前用户是否权益新用户
        Summary: 权益核验是否新用户
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.VerifyAuthBusinessUserResponse(),
            await self.do_request_async('1.0', 'baas.auth.business.user.verify', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def submit_auth_business_data(
        self,
        request: blockchain_models.SubmitAuthBusinessDataRequest,
    ) -> blockchain_models.SubmitAuthBusinessDataResponse:
        """
        Description: 代运营场景下第三方应用调用该接口推送相关信息，例如车辆信息
        Summary: 代运营-推送用户授权的相关信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.submit_auth_business_data_ex(request, headers, runtime)

    async def submit_auth_business_data_async(
        self,
        request: blockchain_models.SubmitAuthBusinessDataRequest,
    ) -> blockchain_models.SubmitAuthBusinessDataResponse:
        """
        Description: 代运营场景下第三方应用调用该接口推送相关信息，例如车辆信息
        Summary: 代运营-推送用户授权的相关信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.submit_auth_business_data_ex_async(request, headers, runtime)

    def submit_auth_business_data_ex(
        self,
        request: blockchain_models.SubmitAuthBusinessDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthBusinessDataResponse:
        """
        Description: 代运营场景下第三方应用调用该接口推送相关信息，例如车辆信息
        Summary: 代运营-推送用户授权的相关信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthBusinessDataResponse(),
            self.do_request('1.0', 'baas.auth.business.data.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def submit_auth_business_data_ex_async(
        self,
        request: blockchain_models.SubmitAuthBusinessDataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthBusinessDataResponse:
        """
        Description: 代运营场景下第三方应用调用该接口推送相关信息，例如车辆信息
        Summary: 代运营-推送用户授权的相关信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthBusinessDataResponse(),
            await self.do_request_async('1.0', 'baas.auth.business.data.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def upload_auth_business_card(
        self,
        request: blockchain_models.UploadAuthBusinessCardRequest,
    ) -> blockchain_models.UploadAuthBusinessCardResponse:
        """
        Description: 支持调用该接口上传行驶证照片，返回上传链接
        Summary: 行驶证上传接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.upload_auth_business_card_ex(request, headers, runtime)

    async def upload_auth_business_card_async(
        self,
        request: blockchain_models.UploadAuthBusinessCardRequest,
    ) -> blockchain_models.UploadAuthBusinessCardResponse:
        """
        Description: 支持调用该接口上传行驶证照片，返回上传链接
        Summary: 行驶证上传接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.upload_auth_business_card_ex_async(request, headers, runtime)

    def upload_auth_business_card_ex(
        self,
        request: blockchain_models.UploadAuthBusinessCardRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthBusinessCardResponse:
        """
        Description: 支持调用该接口上传行驶证照片，返回上传链接
        Summary: 行驶证上传接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthBusinessCardResponse(),
            self.do_request('1.0', 'baas.auth.business.card.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def upload_auth_business_card_ex_async(
        self,
        request: blockchain_models.UploadAuthBusinessCardRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthBusinessCardResponse:
        """
        Description: 支持调用该接口上传行驶证照片，返回上传链接
        Summary: 行驶证上传接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthBusinessCardResponse(),
            await self.do_request_async('1.0', 'baas.auth.business.card.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_vc_transaction(
        self,
        request: blockchain_models.QueryAuthVcTransactionRequest,
    ) -> blockchain_models.QueryAuthVcTransactionResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明链上交易信息，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明链上交易信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_vc_transaction_ex(request, headers, runtime)

    async def query_auth_vc_transaction_async(
        self,
        request: blockchain_models.QueryAuthVcTransactionRequest,
    ) -> blockchain_models.QueryAuthVcTransactionResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明链上交易信息，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明链上交易信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_vc_transaction_ex_async(request, headers, runtime)

    def query_auth_vc_transaction_ex(
        self,
        request: blockchain_models.QueryAuthVcTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcTransactionResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明链上交易信息，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明链上交易信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcTransactionResponse(),
            self.do_request('1.0', 'baas.auth.vc.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_vc_transaction_ex_async(
        self,
        request: blockchain_models.QueryAuthVcTransactionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthVcTransactionResponse:
        """
        Description: 通过指定可验证声明id，获取目标可验证声明链上交易信息，需要可验证声明的拥有者分享声明才可查询，如果没有权限则获取失败。
        Summary: 获取目标可验证声明链上交易信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthVcTransactionResponse(),
            await self.do_request_async('1.0', 'baas.auth.vc.transaction.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def auth_auth_business_user(
        self,
        request: blockchain_models.AuthAuthBusinessUserRequest,
    ) -> blockchain_models.AuthAuthBusinessUserResponse:
        """
        Description: 代运营场景用户确认授权接口
        Summary: 代运营用户确认授权接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.auth_auth_business_user_ex(request, headers, runtime)

    async def auth_auth_business_user_async(
        self,
        request: blockchain_models.AuthAuthBusinessUserRequest,
    ) -> blockchain_models.AuthAuthBusinessUserResponse:
        """
        Description: 代运营场景用户确认授权接口
        Summary: 代运营用户确认授权接口
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.auth_auth_business_user_ex_async(request, headers, runtime)

    def auth_auth_business_user_ex(
        self,
        request: blockchain_models.AuthAuthBusinessUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthAuthBusinessUserResponse:
        """
        Description: 代运营场景用户确认授权接口
        Summary: 代运营用户确认授权接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthAuthBusinessUserResponse(),
            self.do_request('1.0', 'baas.auth.business.user.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def auth_auth_business_user_ex_async(
        self,
        request: blockchain_models.AuthAuthBusinessUserRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.AuthAuthBusinessUserResponse:
        """
        Description: 代运营场景用户确认授权接口
        Summary: 代运营用户确认授权接口
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.AuthAuthBusinessUserResponse(),
            await self.do_request_async('1.0', 'baas.auth.business.user.auth', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_crowd_uploadurl(
        self,
        request: blockchain_models.QueryAuthCrowdUploadurlRequest,
    ) -> blockchain_models.QueryAuthCrowdUploadurlResponse:
        """
        Description: 获取文件上传到OSS的地址和key信息
        Summary: 获取文件上传到OSS的地址和key信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_crowd_uploadurl_ex(request, headers, runtime)

    async def query_auth_crowd_uploadurl_async(
        self,
        request: blockchain_models.QueryAuthCrowdUploadurlRequest,
    ) -> blockchain_models.QueryAuthCrowdUploadurlResponse:
        """
        Description: 获取文件上传到OSS的地址和key信息
        Summary: 获取文件上传到OSS的地址和key信息
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_crowd_uploadurl_ex_async(request, headers, runtime)

    def query_auth_crowd_uploadurl_ex(
        self,
        request: blockchain_models.QueryAuthCrowdUploadurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCrowdUploadurlResponse:
        """
        Description: 获取文件上传到OSS的地址和key信息
        Summary: 获取文件上传到OSS的地址和key信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCrowdUploadurlResponse(),
            self.do_request('1.0', 'baas.auth.crowd.uploadurl.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_crowd_uploadurl_ex_async(
        self,
        request: blockchain_models.QueryAuthCrowdUploadurlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCrowdUploadurlResponse:
        """
        Description: 获取文件上传到OSS的地址和key信息
        Summary: 获取文件上传到OSS的地址和key信息
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCrowdUploadurlResponse(),
            await self.do_request_async('1.0', 'baas.auth.crowd.uploadurl.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def submit_auth_crowd_upload(
        self,
        request: blockchain_models.SubmitAuthCrowdUploadRequest,
    ) -> blockchain_models.SubmitAuthCrowdUploadResponse:
        """
        Description: 提交人群上传相关文件信息
        Summary: 提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.submit_auth_crowd_upload_ex(request, headers, runtime)

    async def submit_auth_crowd_upload_async(
        self,
        request: blockchain_models.SubmitAuthCrowdUploadRequest,
    ) -> blockchain_models.SubmitAuthCrowdUploadResponse:
        """
        Description: 提交人群上传相关文件信息
        Summary: 提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.submit_auth_crowd_upload_ex_async(request, headers, runtime)

    def submit_auth_crowd_upload_ex(
        self,
        request: blockchain_models.SubmitAuthCrowdUploadRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthCrowdUploadResponse:
        """
        Description: 提交人群上传相关文件信息
        Summary: 提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthCrowdUploadResponse(),
            self.do_request('1.0', 'baas.auth.crowd.upload.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def submit_auth_crowd_upload_ex_async(
        self,
        request: blockchain_models.SubmitAuthCrowdUploadRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthCrowdUploadResponse:
        """
        Description: 提交人群上传相关文件信息
        Summary: 提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthCrowdUploadResponse(),
            await self.do_request_async('1.0', 'baas.auth.crowd.upload.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def upload_auth_cert_photo(
        self,
        request: blockchain_models.UploadAuthCertPhotoRequest,
    ) -> blockchain_models.UploadAuthCertPhotoResponse:
        """
        Description: 上传证书动态图片
        Summary: 上传证书动态图片
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.upload_auth_cert_photo_ex(request, headers, runtime)

    async def upload_auth_cert_photo_async(
        self,
        request: blockchain_models.UploadAuthCertPhotoRequest,
    ) -> blockchain_models.UploadAuthCertPhotoResponse:
        """
        Description: 上传证书动态图片
        Summary: 上传证书动态图片
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.upload_auth_cert_photo_ex_async(request, headers, runtime)

    def upload_auth_cert_photo_ex(
        self,
        request: blockchain_models.UploadAuthCertPhotoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthCertPhotoResponse:
        """
        Description: 上传证书动态图片
        Summary: 上传证书动态图片
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthCertPhotoResponse(),
            self.do_request('1.0', 'baas.auth.cert.photo.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def upload_auth_cert_photo_ex_async(
        self,
        request: blockchain_models.UploadAuthCertPhotoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UploadAuthCertPhotoResponse:
        """
        Description: 上传证书动态图片
        Summary: 上传证书动态图片
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UploadAuthCertPhotoResponse(),
            await self.do_request_async('1.0', 'baas.auth.cert.photo.upload', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def submit_auth_carinfo(
        self,
        request: blockchain_models.SubmitAuthCarinfoRequest,
    ) -> blockchain_models.SubmitAuthCarinfoResponse:
        """
        Description: 车五项信息提交
        Summary: 车五项信息提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.submit_auth_carinfo_ex(request, headers, runtime)

    async def submit_auth_carinfo_async(
        self,
        request: blockchain_models.SubmitAuthCarinfoRequest,
    ) -> blockchain_models.SubmitAuthCarinfoResponse:
        """
        Description: 车五项信息提交
        Summary: 车五项信息提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.submit_auth_carinfo_ex_async(request, headers, runtime)

    def submit_auth_carinfo_ex(
        self,
        request: blockchain_models.SubmitAuthCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthCarinfoResponse:
        """
        Description: 车五项信息提交
        Summary: 车五项信息提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthCarinfoResponse(),
            self.do_request('1.0', 'baas.auth.carinfo.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def submit_auth_carinfo_ex_async(
        self,
        request: blockchain_models.SubmitAuthCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthCarinfoResponse:
        """
        Description: 车五项信息提交
        Summary: 车五项信息提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthCarinfoResponse(),
            await self.do_request_async('1.0', 'baas.auth.carinfo.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def recognize_auth_carinfo(
        self,
        request: blockchain_models.RecognizeAuthCarinfoRequest,
    ) -> blockchain_models.RecognizeAuthCarinfoResponse:
        """
        Description: 车信息识别
        Summary: 车信息识别
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.recognize_auth_carinfo_ex(request, headers, runtime)

    async def recognize_auth_carinfo_async(
        self,
        request: blockchain_models.RecognizeAuthCarinfoRequest,
    ) -> blockchain_models.RecognizeAuthCarinfoResponse:
        """
        Description: 车信息识别
        Summary: 车信息识别
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.recognize_auth_carinfo_ex_async(request, headers, runtime)

    def recognize_auth_carinfo_ex(
        self,
        request: blockchain_models.RecognizeAuthCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RecognizeAuthCarinfoResponse:
        """
        Description: 车信息识别
        Summary: 车信息识别
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RecognizeAuthCarinfoResponse(),
            self.do_request('1.0', 'baas.auth.carinfo.recognize', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def recognize_auth_carinfo_ex_async(
        self,
        request: blockchain_models.RecognizeAuthCarinfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RecognizeAuthCarinfoResponse:
        """
        Description: 车信息识别
        Summary: 车信息识别
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RecognizeAuthCarinfoResponse(),
            await self.do_request_async('1.0', 'baas.auth.carinfo.recognize', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def submit_auth_newcar(
        self,
        request: blockchain_models.SubmitAuthNewcarRequest,
    ) -> blockchain_models.SubmitAuthNewcarResponse:
        """
        Description: 新车线索提交
        Summary: 新车线索提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.submit_auth_newcar_ex(request, headers, runtime)

    async def submit_auth_newcar_async(
        self,
        request: blockchain_models.SubmitAuthNewcarRequest,
    ) -> blockchain_models.SubmitAuthNewcarResponse:
        """
        Description: 新车线索提交
        Summary: 新车线索提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.submit_auth_newcar_ex_async(request, headers, runtime)

    def submit_auth_newcar_ex(
        self,
        request: blockchain_models.SubmitAuthNewcarRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthNewcarResponse:
        """
        Description: 新车线索提交
        Summary: 新车线索提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthNewcarResponse(),
            self.do_request('1.0', 'baas.auth.newcar.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def submit_auth_newcar_ex_async(
        self,
        request: blockchain_models.SubmitAuthNewcarRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.SubmitAuthNewcarResponse:
        """
        Description: 新车线索提交
        Summary: 新车线索提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.SubmitAuthNewcarResponse(),
            await self.do_request_async('1.0', 'baas.auth.newcar.submit', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_insurance(
        self,
        request: blockchain_models.QueryAuthInsuranceRequest,
    ) -> blockchain_models.QueryAuthInsuranceResponse:
        """
        Description: 平安车险车辆绑定 天猫使用
        Summary: 平安车险车辆绑定 天猫使用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_insurance_ex(request, headers, runtime)

    async def query_auth_insurance_async(
        self,
        request: blockchain_models.QueryAuthInsuranceRequest,
    ) -> blockchain_models.QueryAuthInsuranceResponse:
        """
        Description: 平安车险车辆绑定 天猫使用
        Summary: 平安车险车辆绑定 天猫使用
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_insurance_ex_async(request, headers, runtime)

    def query_auth_insurance_ex(
        self,
        request: blockchain_models.QueryAuthInsuranceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthInsuranceResponse:
        """
        Description: 平安车险车辆绑定 天猫使用
        Summary: 平安车险车辆绑定 天猫使用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthInsuranceResponse(),
            self.do_request('1.0', 'baas.auth.insurance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_insurance_ex_async(
        self,
        request: blockchain_models.QueryAuthInsuranceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthInsuranceResponse:
        """
        Description: 平安车险车辆绑定 天猫使用
        Summary: 平安车险车辆绑定 天猫使用
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthInsuranceResponse(),
            await self.do_request_async('1.0', 'baas.auth.insurance.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def register_auth_carowner(
        self,
        request: blockchain_models.RegisterAuthCarownerRequest,
    ) -> blockchain_models.RegisterAuthCarownerResponse:
        """
        Description: 车主信息提交
        Summary: 车主信息提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.register_auth_carowner_ex(request, headers, runtime)

    async def register_auth_carowner_async(
        self,
        request: blockchain_models.RegisterAuthCarownerRequest,
    ) -> blockchain_models.RegisterAuthCarownerResponse:
        """
        Description: 车主信息提交
        Summary: 车主信息提交
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.register_auth_carowner_ex_async(request, headers, runtime)

    def register_auth_carowner_ex(
        self,
        request: blockchain_models.RegisterAuthCarownerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RegisterAuthCarownerResponse:
        """
        Description: 车主信息提交
        Summary: 车主信息提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RegisterAuthCarownerResponse(),
            self.do_request('1.0', 'baas.auth.carowner.register', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def register_auth_carowner_ex_async(
        self,
        request: blockchain_models.RegisterAuthCarownerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RegisterAuthCarownerResponse:
        """
        Description: 车主信息提交
        Summary: 车主信息提交
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RegisterAuthCarownerResponse(),
            await self.do_request_async('1.0', 'baas.auth.carowner.register', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_caritems(
        self,
        request: blockchain_models.QueryAuthCaritemsRequest,
    ) -> blockchain_models.QueryAuthCaritemsResponse:
        """
        Description: 车五项查询
        Summary: 车五项查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_caritems_ex(request, headers, runtime)

    async def query_auth_caritems_async(
        self,
        request: blockchain_models.QueryAuthCaritemsRequest,
    ) -> blockchain_models.QueryAuthCaritemsResponse:
        """
        Description: 车五项查询
        Summary: 车五项查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_caritems_ex_async(request, headers, runtime)

    def query_auth_caritems_ex(
        self,
        request: blockchain_models.QueryAuthCaritemsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCaritemsResponse:
        """
        Description: 车五项查询
        Summary: 车五项查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCaritemsResponse(),
            self.do_request('1.0', 'baas.auth.caritems.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_caritems_ex_async(
        self,
        request: blockchain_models.QueryAuthCaritemsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCaritemsResponse:
        """
        Description: 车五项查询
        Summary: 车五项查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCaritemsResponse(),
            await self.do_request_async('1.0', 'baas.auth.caritems.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_auth_carprice(
        self,
        request: blockchain_models.QueryAuthCarpriceRequest,
    ) -> blockchain_models.QueryAuthCarpriceResponse:
        """
        Description: 车辆价格查询
        Summary: 车辆价格查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_auth_carprice_ex(request, headers, runtime)

    async def query_auth_carprice_async(
        self,
        request: blockchain_models.QueryAuthCarpriceRequest,
    ) -> blockchain_models.QueryAuthCarpriceResponse:
        """
        Description: 车辆价格查询
        Summary: 车辆价格查询
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_auth_carprice_ex_async(request, headers, runtime)

    def query_auth_carprice_ex(
        self,
        request: blockchain_models.QueryAuthCarpriceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCarpriceResponse:
        """
        Description: 车辆价格查询
        Summary: 车辆价格查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCarpriceResponse(),
            self.do_request('1.0', 'baas.auth.carprice.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_auth_carprice_ex_async(
        self,
        request: blockchain_models.QueryAuthCarpriceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryAuthCarpriceResponse:
        """
        Description: 车辆价格查询
        Summary: 车辆价格查询
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryAuthCarpriceResponse(),
            await self.do_request_async('1.0', 'baas.auth.carprice.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_corporate_agentcreate(
        self,
        request: blockchain_models.StartDidCorporateAgentcreateRequest,
    ) -> blockchain_models.StartDidCorporateAgentcreateResponse:
        """
        Description: 通过代理模式为企业创建did
        Summary: 通过代理模式为企业创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_corporate_agentcreate_ex(request, headers, runtime)

    async def start_did_corporate_agentcreate_async(
        self,
        request: blockchain_models.StartDidCorporateAgentcreateRequest,
    ) -> blockchain_models.StartDidCorporateAgentcreateResponse:
        """
        Description: 通过代理模式为企业创建did
        Summary: 通过代理模式为企业创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_corporate_agentcreate_ex_async(request, headers, runtime)

    def start_did_corporate_agentcreate_ex(
        self,
        request: blockchain_models.StartDidCorporateAgentcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateAgentcreateResponse:
        """
        Description: 通过代理模式为企业创建did
        Summary: 通过代理模式为企业创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateAgentcreateResponse(),
            self.do_request('1.0', 'baas.did.corporate.agentcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_corporate_agentcreate_ex_async(
        self,
        request: blockchain_models.StartDidCorporateAgentcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateAgentcreateResponse:
        """
        Description: 通过代理模式为企业创建did
        Summary: 通过代理模式为企业创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateAgentcreateResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.agentcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_person_agentcreate(
        self,
        request: blockchain_models.StartDidPersonAgentcreateRequest,
    ) -> blockchain_models.StartDidPersonAgentcreateResponse:
        """
        Description: 通过代理模式为个人创建did
        Summary: 通过代理模式为个人创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_person_agentcreate_ex(request, headers, runtime)

    async def start_did_person_agentcreate_async(
        self,
        request: blockchain_models.StartDidPersonAgentcreateRequest,
    ) -> blockchain_models.StartDidPersonAgentcreateResponse:
        """
        Description: 通过代理模式为个人创建did
        Summary: 通过代理模式为个人创建did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_person_agentcreate_ex_async(request, headers, runtime)

    def start_did_person_agentcreate_ex(
        self,
        request: blockchain_models.StartDidPersonAgentcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidPersonAgentcreateResponse:
        """
        Description: 通过代理模式为个人创建did
        Summary: 通过代理模式为个人创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidPersonAgentcreateResponse(),
            self.do_request('1.0', 'baas.did.person.agentcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_person_agentcreate_ex_async(
        self,
        request: blockchain_models.StartDidPersonAgentcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidPersonAgentcreateResponse:
        """
        Description: 通过代理模式为个人创建did
        Summary: 通过代理模式为个人创建did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidPersonAgentcreateResponse(),
            await self.do_request_async('1.0', 'baas.did.person.agentcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_corporate_selfcreate(
        self,
        request: blockchain_models.StartDidCorporateSelfcreateRequest,
    ) -> blockchain_models.StartDidCorporateSelfcreateResponse:
        """
        Description: 直接创建自己的企业did
        Summary: 直接创建自己的企业did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_corporate_selfcreate_ex(request, headers, runtime)

    async def start_did_corporate_selfcreate_async(
        self,
        request: blockchain_models.StartDidCorporateSelfcreateRequest,
    ) -> blockchain_models.StartDidCorporateSelfcreateResponse:
        """
        Description: 直接创建自己的企业did
        Summary: 直接创建自己的企业did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_corporate_selfcreate_ex_async(request, headers, runtime)

    def start_did_corporate_selfcreate_ex(
        self,
        request: blockchain_models.StartDidCorporateSelfcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateSelfcreateResponse:
        """
        Description: 直接创建自己的企业did
        Summary: 直接创建自己的企业did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateSelfcreateResponse(),
            self.do_request('1.0', 'baas.did.corporate.selfcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_corporate_selfcreate_ex_async(
        self,
        request: blockchain_models.StartDidCorporateSelfcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateSelfcreateResponse:
        """
        Description: 直接创建自己的企业did
        Summary: 直接创建自己的企业did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateSelfcreateResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.selfcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_person_selfcreate(
        self,
        request: blockchain_models.StartDidPersonSelfcreateRequest,
    ) -> blockchain_models.StartDidPersonSelfcreateResponse:
        """
        Description: 直接创建自己的个人did
        Summary: 直接创建自己的个人did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_person_selfcreate_ex(request, headers, runtime)

    async def start_did_person_selfcreate_async(
        self,
        request: blockchain_models.StartDidPersonSelfcreateRequest,
    ) -> blockchain_models.StartDidPersonSelfcreateResponse:
        """
        Description: 直接创建自己的个人did
        Summary: 直接创建自己的个人did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_person_selfcreate_ex_async(request, headers, runtime)

    def start_did_person_selfcreate_ex(
        self,
        request: blockchain_models.StartDidPersonSelfcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidPersonSelfcreateResponse:
        """
        Description: 直接创建自己的个人did
        Summary: 直接创建自己的个人did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidPersonSelfcreateResponse(),
            self.do_request('1.0', 'baas.did.person.selfcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_person_selfcreate_ex_async(
        self,
        request: blockchain_models.StartDidPersonSelfcreateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidPersonSelfcreateResponse:
        """
        Description: 直接创建自己的个人did
        Summary: 直接创建自己的个人did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidPersonSelfcreateResponse(),
            await self.do_request_async('1.0', 'baas.did.person.selfcreate.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_verifiableclaim_issure(
        self,
        request: blockchain_models.StartDidVerifiableclaimIssureRequest,
    ) -> blockchain_models.StartDidVerifiableclaimIssureResponse:
        """
        Description: 使用自己或者代理的did为指定did颁发证书
        Summary: 为指定did颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_verifiableclaim_issure_ex(request, headers, runtime)

    async def start_did_verifiableclaim_issure_async(
        self,
        request: blockchain_models.StartDidVerifiableclaimIssureRequest,
    ) -> blockchain_models.StartDidVerifiableclaimIssureResponse:
        """
        Description: 使用自己或者代理的did为指定did颁发证书
        Summary: 为指定did颁发证书
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_verifiableclaim_issure_ex_async(request, headers, runtime)

    def start_did_verifiableclaim_issure_ex(
        self,
        request: blockchain_models.StartDidVerifiableclaimIssureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidVerifiableclaimIssureResponse:
        """
        Description: 使用自己或者代理的did为指定did颁发证书
        Summary: 为指定did颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidVerifiableclaimIssureResponse(),
            self.do_request('1.0', 'baas.did.verifiableclaim.issure.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_verifiableclaim_issure_ex_async(
        self,
        request: blockchain_models.StartDidVerifiableclaimIssureRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidVerifiableclaimIssureResponse:
        """
        Description: 使用自己或者代理的did为指定did颁发证书
        Summary: 为指定did颁发证书
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidVerifiableclaimIssureResponse(),
            await self.do_request_async('1.0', 'baas.did.verifiableclaim.issure.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_verifiableclaim_verifier(
        self,
        request: blockchain_models.StartDidVerifiableclaimVerifierRequest,
    ) -> blockchain_models.StartDidVerifiableclaimVerifierResponse:
        """
        Description: 验证可验证声明
        Summary: 验证可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_verifiableclaim_verifier_ex(request, headers, runtime)

    async def start_did_verifiableclaim_verifier_async(
        self,
        request: blockchain_models.StartDidVerifiableclaimVerifierRequest,
    ) -> blockchain_models.StartDidVerifiableclaimVerifierResponse:
        """
        Description: 验证可验证声明
        Summary: 验证可验证声明
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_verifiableclaim_verifier_ex_async(request, headers, runtime)

    def start_did_verifiableclaim_verifier_ex(
        self,
        request: blockchain_models.StartDidVerifiableclaimVerifierRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidVerifiableclaimVerifierResponse:
        """
        Description: 验证可验证声明
        Summary: 验证可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidVerifiableclaimVerifierResponse(),
            self.do_request('1.0', 'baas.did.verifiableclaim.verifier.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_verifiableclaim_verifier_ex_async(
        self,
        request: blockchain_models.StartDidVerifiableclaimVerifierRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidVerifiableclaimVerifierResponse:
        """
        Description: 验证可验证声明
        Summary: 验证可验证声明
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidVerifiableclaimVerifierResponse(),
            await self.do_request_async('1.0', 'baas.did.verifiableclaim.verifier.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_did_doc(
        self,
        request: blockchain_models.QueryDidDocRequest,
    ) -> blockchain_models.QueryDidDocResponse:
        """
        Description: 查询did对应的doc
        Summary: 查询did对应的doc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_did_doc_ex(request, headers, runtime)

    async def query_did_doc_async(
        self,
        request: blockchain_models.QueryDidDocRequest,
    ) -> blockchain_models.QueryDidDocResponse:
        """
        Description: 查询did对应的doc
        Summary: 查询did对应的doc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_did_doc_ex_async(request, headers, runtime)

    def query_did_doc_ex(
        self,
        request: blockchain_models.QueryDidDocRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidDocResponse:
        """
        Description: 查询did对应的doc
        Summary: 查询did对应的doc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidDocResponse(),
            self.do_request('1.0', 'baas.did.doc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_did_doc_ex_async(
        self,
        request: blockchain_models.QueryDidDocRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidDocResponse:
        """
        Description: 查询did对应的doc
        Summary: 查询did对应的doc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidDocResponse(),
            await self.do_request_async('1.0', 'baas.did.doc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_did_verifiableclaim_status(
        self,
        request: blockchain_models.UpdateDidVerifiableclaimStatusRequest,
    ) -> blockchain_models.UpdateDidVerifiableclaimStatusResponse:
        """
        Description: 更新可验证声明状态
        Summary: 更新可验证声明状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_did_verifiableclaim_status_ex(request, headers, runtime)

    async def update_did_verifiableclaim_status_async(
        self,
        request: blockchain_models.UpdateDidVerifiableclaimStatusRequest,
    ) -> blockchain_models.UpdateDidVerifiableclaimStatusResponse:
        """
        Description: 更新可验证声明状态
        Summary: 更新可验证声明状态
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_did_verifiableclaim_status_ex_async(request, headers, runtime)

    def update_did_verifiableclaim_status_ex(
        self,
        request: blockchain_models.UpdateDidVerifiableclaimStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDidVerifiableclaimStatusResponse:
        """
        Description: 更新可验证声明状态
        Summary: 更新可验证声明状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDidVerifiableclaimStatusResponse(),
            self.do_request('1.0', 'baas.did.verifiableclaim.status.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_did_verifiableclaim_status_ex_async(
        self,
        request: blockchain_models.UpdateDidVerifiableclaimStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDidVerifiableclaimStatusResponse:
        """
        Description: 更新可验证声明状态
        Summary: 更新可验证声明状态
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDidVerifiableclaimStatusResponse(),
            await self.do_request_async('1.0', 'baas.did.verifiableclaim.status.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def update_did_corporate_extensionservice(
        self,
        request: blockchain_models.UpdateDidCorporateExtensionserviceRequest,
    ) -> blockchain_models.UpdateDidCorporateExtensionserviceResponse:
        """
        Description: 用户更新扩展字段中的扩展字段
        Summary: 更新doc service中的扩展字段
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_did_corporate_extensionservice_ex(request, headers, runtime)

    async def update_did_corporate_extensionservice_async(
        self,
        request: blockchain_models.UpdateDidCorporateExtensionserviceRequest,
    ) -> blockchain_models.UpdateDidCorporateExtensionserviceResponse:
        """
        Description: 用户更新扩展字段中的扩展字段
        Summary: 更新doc service中的扩展字段
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_did_corporate_extensionservice_ex_async(request, headers, runtime)

    def update_did_corporate_extensionservice_ex(
        self,
        request: blockchain_models.UpdateDidCorporateExtensionserviceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDidCorporateExtensionserviceResponse:
        """
        Description: 用户更新扩展字段中的扩展字段
        Summary: 更新doc service中的扩展字段
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDidCorporateExtensionserviceResponse(),
            self.do_request('1.0', 'baas.did.corporate.extensionservice.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def update_did_corporate_extensionservice_ex_async(
        self,
        request: blockchain_models.UpdateDidCorporateExtensionserviceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.UpdateDidCorporateExtensionserviceResponse:
        """
        Description: 用户更新扩展字段中的扩展字段
        Summary: 更新doc service中的扩展字段
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.UpdateDidCorporateExtensionserviceResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.extensionservice.update', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_corporate_customerservicetype(
        self,
        request: blockchain_models.StartDidCorporateCustomerservicetypeRequest,
    ) -> blockchain_models.StartDidCorporateCustomerservicetypeResponse:
        """
        Description: 设置不通租户在DID中的不同扩展字段
        Summary: 设置不通租户在DID中的不同扩展字段
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_corporate_customerservicetype_ex(request, headers, runtime)

    async def start_did_corporate_customerservicetype_async(
        self,
        request: blockchain_models.StartDidCorporateCustomerservicetypeRequest,
    ) -> blockchain_models.StartDidCorporateCustomerservicetypeResponse:
        """
        Description: 设置不通租户在DID中的不同扩展字段
        Summary: 设置不通租户在DID中的不同扩展字段
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_corporate_customerservicetype_ex_async(request, headers, runtime)

    def start_did_corporate_customerservicetype_ex(
        self,
        request: blockchain_models.StartDidCorporateCustomerservicetypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateCustomerservicetypeResponse:
        """
        Description: 设置不通租户在DID中的不同扩展字段
        Summary: 设置不通租户在DID中的不同扩展字段
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateCustomerservicetypeResponse(),
            self.do_request('1.0', 'baas.did.corporate.customerservicetype.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_corporate_customerservicetype_ex_async(
        self,
        request: blockchain_models.StartDidCorporateCustomerservicetypeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCorporateCustomerservicetypeResponse:
        """
        Description: 设置不通租户在DID中的不同扩展字段
        Summary: 设置不通租户在DID中的不同扩展字段
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCorporateCustomerservicetypeResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.customerservicetype.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_certification_threemeta(
        self,
        request: blockchain_models.StartDidCertificationThreemetaRequest,
    ) -> blockchain_models.StartDidCertificationThreemetaResponse:
        """
        Description: 三要素实名认证
        Summary: 三要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_certification_threemeta_ex(request, headers, runtime)

    async def start_did_certification_threemeta_async(
        self,
        request: blockchain_models.StartDidCertificationThreemetaRequest,
    ) -> blockchain_models.StartDidCertificationThreemetaResponse:
        """
        Description: 三要素实名认证
        Summary: 三要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_certification_threemeta_ex_async(request, headers, runtime)

    def start_did_certification_threemeta_ex(
        self,
        request: blockchain_models.StartDidCertificationThreemetaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationThreemetaResponse:
        """
        Description: 三要素实名认证
        Summary: 三要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationThreemetaResponse(),
            self.do_request('1.0', 'baas.did.certification.threemeta.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_certification_threemeta_ex_async(
        self,
        request: blockchain_models.StartDidCertificationThreemetaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationThreemetaResponse:
        """
        Description: 三要素实名认证
        Summary: 三要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationThreemetaResponse(),
            await self.do_request_async('1.0', 'baas.did.certification.threemeta.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_certification_twometa(
        self,
        request: blockchain_models.StartDidCertificationTwometaRequest,
    ) -> blockchain_models.StartDidCertificationTwometaResponse:
        """
        Description: 二要素实名认证
        Summary: 二要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_certification_twometa_ex(request, headers, runtime)

    async def start_did_certification_twometa_async(
        self,
        request: blockchain_models.StartDidCertificationTwometaRequest,
    ) -> blockchain_models.StartDidCertificationTwometaResponse:
        """
        Description: 二要素实名认证
        Summary: 二要素实名认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_certification_twometa_ex_async(request, headers, runtime)

    def start_did_certification_twometa_ex(
        self,
        request: blockchain_models.StartDidCertificationTwometaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationTwometaResponse:
        """
        Description: 二要素实名认证
        Summary: 二要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationTwometaResponse(),
            self.do_request('1.0', 'baas.did.certification.twometa.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_certification_twometa_ex_async(
        self,
        request: blockchain_models.StartDidCertificationTwometaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationTwometaResponse:
        """
        Description: 二要素实名认证
        Summary: 二要素实名认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationTwometaResponse(),
            await self.do_request_async('1.0', 'baas.did.certification.twometa.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_did_vc(
        self,
        request: blockchain_models.QueryDidVcRequest,
    ) -> blockchain_models.QueryDidVcResponse:
        """
        Description: 通过vcid查询vc内容
        Summary: 通过vcid查询vc内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_did_vc_ex(request, headers, runtime)

    async def query_did_vc_async(
        self,
        request: blockchain_models.QueryDidVcRequest,
    ) -> blockchain_models.QueryDidVcResponse:
        """
        Description: 通过vcid查询vc内容
        Summary: 通过vcid查询vc内容
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_did_vc_ex_async(request, headers, runtime)

    def query_did_vc_ex(
        self,
        request: blockchain_models.QueryDidVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidVcResponse:
        """
        Description: 通过vcid查询vc内容
        Summary: 通过vcid查询vc内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidVcResponse(),
            self.do_request('1.0', 'baas.did.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_did_vc_ex_async(
        self,
        request: blockchain_models.QueryDidVcRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidVcResponse:
        """
        Description: 通过vcid查询vc内容
        Summary: 通过vcid查询vc内容
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidVcResponse(),
            await self.do_request_async('1.0', 'baas.did.vc.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_identification_faceauth(
        self,
        request: blockchain_models.StartDidIdentificationFaceauthRequest,
    ) -> blockchain_models.StartDidIdentificationFaceauthResponse:
        """
        Description: 开始实人认证
        Summary: 开始实人认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_identification_faceauth_ex(request, headers, runtime)

    async def start_did_identification_faceauth_async(
        self,
        request: blockchain_models.StartDidIdentificationFaceauthRequest,
    ) -> blockchain_models.StartDidIdentificationFaceauthResponse:
        """
        Description: 开始实人认证
        Summary: 开始实人认证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_identification_faceauth_ex_async(request, headers, runtime)

    def start_did_identification_faceauth_ex(
        self,
        request: blockchain_models.StartDidIdentificationFaceauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidIdentificationFaceauthResponse:
        """
        Description: 开始实人认证
        Summary: 开始实人认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidIdentificationFaceauthResponse(),
            self.do_request('1.0', 'baas.did.identification.faceauth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_identification_faceauth_ex_async(
        self,
        request: blockchain_models.StartDidIdentificationFaceauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidIdentificationFaceauthResponse:
        """
        Description: 开始实人认证
        Summary: 开始实人认证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidIdentificationFaceauthResponse(),
            await self.do_request_async('1.0', 'baas.did.identification.faceauth.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def query_did_identification_faceauth(
        self,
        request: blockchain_models.QueryDidIdentificationFaceauthRequest,
    ) -> blockchain_models.QueryDidIdentificationFaceauthResponse:
        """
        Description: 查询实人认证结果
        Summary: 查询实人认证结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.query_did_identification_faceauth_ex(request, headers, runtime)

    async def query_did_identification_faceauth_async(
        self,
        request: blockchain_models.QueryDidIdentificationFaceauthRequest,
    ) -> blockchain_models.QueryDidIdentificationFaceauthResponse:
        """
        Description: 查询实人认证结果
        Summary: 查询实人认证结果
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.query_did_identification_faceauth_ex_async(request, headers, runtime)

    def query_did_identification_faceauth_ex(
        self,
        request: blockchain_models.QueryDidIdentificationFaceauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidIdentificationFaceauthResponse:
        """
        Description: 查询实人认证结果
        Summary: 查询实人认证结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidIdentificationFaceauthResponse(),
            self.do_request('1.0', 'baas.did.identification.faceauth.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def query_did_identification_faceauth_ex_async(
        self,
        request: blockchain_models.QueryDidIdentificationFaceauthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.QueryDidIdentificationFaceauthResponse:
        """
        Description: 查询实人认证结果
        Summary: 查询实人认证结果
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.QueryDidIdentificationFaceauthResponse(),
            await self.do_request_async('1.0', 'baas.did.identification.faceauth.query', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_notification_consumer(
        self,
        request: blockchain_models.StartDidNotificationConsumerRequest,
    ) -> blockchain_models.StartDidNotificationConsumerResponse:
        """
        Description: 用户通过该接口订阅自己关心的did事件
        Summary: 订阅did事件服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_notification_consumer_ex(request, headers, runtime)

    async def start_did_notification_consumer_async(
        self,
        request: blockchain_models.StartDidNotificationConsumerRequest,
    ) -> blockchain_models.StartDidNotificationConsumerResponse:
        """
        Description: 用户通过该接口订阅自己关心的did事件
        Summary: 订阅did事件服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_notification_consumer_ex_async(request, headers, runtime)

    def start_did_notification_consumer_ex(
        self,
        request: blockchain_models.StartDidNotificationConsumerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidNotificationConsumerResponse:
        """
        Description: 用户通过该接口订阅自己关心的did事件
        Summary: 订阅did事件服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidNotificationConsumerResponse(),
            self.do_request('1.0', 'baas.did.notification.consumer.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_notification_consumer_ex_async(
        self,
        request: blockchain_models.StartDidNotificationConsumerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidNotificationConsumerResponse:
        """
        Description: 用户通过该接口订阅自己关心的did事件
        Summary: 订阅did事件服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidNotificationConsumerResponse(),
            await self.do_request_async('1.0', 'baas.did.notification.consumer.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def reboot_did_notification_consumer(
        self,
        request: blockchain_models.RebootDidNotificationConsumerRequest,
    ) -> blockchain_models.RebootDidNotificationConsumerResponse:
        """
        Description: 消费端在重启，或者需要重新拉之前的信息，需要调用这个接口重新注册
        Summary: 消费端重新启动
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reboot_did_notification_consumer_ex(request, headers, runtime)

    async def reboot_did_notification_consumer_async(
        self,
        request: blockchain_models.RebootDidNotificationConsumerRequest,
    ) -> blockchain_models.RebootDidNotificationConsumerResponse:
        """
        Description: 消费端在重启，或者需要重新拉之前的信息，需要调用这个接口重新注册
        Summary: 消费端重新启动
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reboot_did_notification_consumer_ex_async(request, headers, runtime)

    def reboot_did_notification_consumer_ex(
        self,
        request: blockchain_models.RebootDidNotificationConsumerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RebootDidNotificationConsumerResponse:
        """
        Description: 消费端在重启，或者需要重新拉之前的信息，需要调用这个接口重新注册
        Summary: 消费端重新启动
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RebootDidNotificationConsumerResponse(),
            self.do_request('1.0', 'baas.did.notification.consumer.reboot', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def reboot_did_notification_consumer_ex_async(
        self,
        request: blockchain_models.RebootDidNotificationConsumerRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.RebootDidNotificationConsumerResponse:
        """
        Description: 消费端在重启，或者需要重新拉之前的信息，需要调用这个接口重新注册
        Summary: 消费端重新启动
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.RebootDidNotificationConsumerResponse(),
            await self.do_request_async('1.0', 'baas.did.notification.consumer.reboot', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def init_did_corporate_direct(
        self,
        request: blockchain_models.InitDidCorporateDirectRequest,
    ) -> blockchain_models.InitDidCorporateDirectResponse:
        """
        Description: 向Dis申请DID号
        Summary: 非托管模式下创建DID时，申请ID
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.init_did_corporate_direct_ex(request, headers, runtime)

    async def init_did_corporate_direct_async(
        self,
        request: blockchain_models.InitDidCorporateDirectRequest,
    ) -> blockchain_models.InitDidCorporateDirectResponse:
        """
        Description: 向Dis申请DID号
        Summary: 非托管模式下创建DID时，申请ID
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.init_did_corporate_direct_ex_async(request, headers, runtime)

    def init_did_corporate_direct_ex(
        self,
        request: blockchain_models.InitDidCorporateDirectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDidCorporateDirectResponse:
        """
        Description: 向Dis申请DID号
        Summary: 非托管模式下创建DID时，申请ID
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDidCorporateDirectResponse(),
            self.do_request('1.0', 'baas.did.corporate.direct.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def init_did_corporate_direct_ex_async(
        self,
        request: blockchain_models.InitDidCorporateDirectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDidCorporateDirectResponse:
        """
        Description: 向Dis申请DID号
        Summary: 非托管模式下创建DID时，申请ID
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDidCorporateDirectResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.direct.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def push_did_corporate_direct(
        self,
        request: blockchain_models.PushDidCorporateDirectRequest,
    ) -> blockchain_models.PushDidCorporateDirectResponse:
        """
        Description: 推送或者更新did doc
        Summary: 推送或者更新did doc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.push_did_corporate_direct_ex(request, headers, runtime)

    async def push_did_corporate_direct_async(
        self,
        request: blockchain_models.PushDidCorporateDirectRequest,
    ) -> blockchain_models.PushDidCorporateDirectResponse:
        """
        Description: 推送或者更新did doc
        Summary: 推送或者更新did doc
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.push_did_corporate_direct_ex_async(request, headers, runtime)

    def push_did_corporate_direct_ex(
        self,
        request: blockchain_models.PushDidCorporateDirectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushDidCorporateDirectResponse:
        """
        Description: 推送或者更新did doc
        Summary: 推送或者更新did doc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushDidCorporateDirectResponse(),
            self.do_request('1.0', 'baas.did.corporate.direct.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def push_did_corporate_direct_ex_async(
        self,
        request: blockchain_models.PushDidCorporateDirectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.PushDidCorporateDirectResponse:
        """
        Description: 推送或者更新did doc
        Summary: 推送或者更新did doc
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.PushDidCorporateDirectResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.direct.push', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def init_did_corporate_identity(
        self,
        request: blockchain_models.InitDidCorporateIdentityRequest,
    ) -> blockchain_models.InitDidCorporateIdentityResponse:
        """
        Description: 企业申请did
        Summary: 申请did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.init_did_corporate_identity_ex(request, headers, runtime)

    async def init_did_corporate_identity_async(
        self,
        request: blockchain_models.InitDidCorporateIdentityRequest,
    ) -> blockchain_models.InitDidCorporateIdentityResponse:
        """
        Description: 企业申请did
        Summary: 申请did
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.init_did_corporate_identity_ex_async(request, headers, runtime)

    def init_did_corporate_identity_ex(
        self,
        request: blockchain_models.InitDidCorporateIdentityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDidCorporateIdentityResponse:
        """
        Description: 企业申请did
        Summary: 申请did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDidCorporateIdentityResponse(),
            self.do_request('1.0', 'baas.did.corporate.identity.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def init_did_corporate_identity_ex_async(
        self,
        request: blockchain_models.InitDidCorporateIdentityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.InitDidCorporateIdentityResponse:
        """
        Description: 企业申请did
        Summary: 申请did
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.InitDidCorporateIdentityResponse(),
            await self.do_request_async('1.0', 'baas.did.corporate.identity.init', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_agent_challengeresponse(
        self,
        request: blockchain_models.StartDidAgentChallengeresponseRequest,
    ) -> blockchain_models.StartDidAgentChallengeresponseResponse:
        """
        Description: 对authchallenge进行响应
        Summary: 对authchallenge进行响应
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_agent_challengeresponse_ex(request, headers, runtime)

    async def start_did_agent_challengeresponse_async(
        self,
        request: blockchain_models.StartDidAgentChallengeresponseRequest,
    ) -> blockchain_models.StartDidAgentChallengeresponseResponse:
        """
        Description: 对authchallenge进行响应
        Summary: 对authchallenge进行响应
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_agent_challengeresponse_ex_async(request, headers, runtime)

    def start_did_agent_challengeresponse_ex(
        self,
        request: blockchain_models.StartDidAgentChallengeresponseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidAgentChallengeresponseResponse:
        """
        Description: 对authchallenge进行响应
        Summary: 对authchallenge进行响应
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidAgentChallengeresponseResponse(),
            self.do_request('1.0', 'baas.did.agent.challengeresponse.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_agent_challengeresponse_ex_async(
        self,
        request: blockchain_models.StartDidAgentChallengeresponseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidAgentChallengeresponseResponse:
        """
        Description: 对authchallenge进行响应
        Summary: 对authchallenge进行响应
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidAgentChallengeresponseResponse(),
            await self.do_request_async('1.0', 'baas.did.agent.challengeresponse.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_agent_verifyauthresponse(
        self,
        request: blockchain_models.StartDidAgentVerifyauthresponseRequest,
    ) -> blockchain_models.StartDidAgentVerifyauthresponseResponse:
        """
        Description: 验证Auth Response有效性接口
        Summary: 验证Auth Response有效性
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_agent_verifyauthresponse_ex(request, headers, runtime)

    async def start_did_agent_verifyauthresponse_async(
        self,
        request: blockchain_models.StartDidAgentVerifyauthresponseRequest,
    ) -> blockchain_models.StartDidAgentVerifyauthresponseResponse:
        """
        Description: 验证Auth Response有效性接口
        Summary: 验证Auth Response有效性
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_agent_verifyauthresponse_ex_async(request, headers, runtime)

    def start_did_agent_verifyauthresponse_ex(
        self,
        request: blockchain_models.StartDidAgentVerifyauthresponseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidAgentVerifyauthresponseResponse:
        """
        Description: 验证Auth Response有效性接口
        Summary: 验证Auth Response有效性
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidAgentVerifyauthresponseResponse(),
            self.do_request('1.0', 'baas.did.agent.verifyauthresponse.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_agent_verifyauthresponse_ex_async(
        self,
        request: blockchain_models.StartDidAgentVerifyauthresponseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidAgentVerifyauthresponseResponse:
        """
        Description: 验证Auth Response有效性接口
        Summary: 验证Auth Response有效性
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidAgentVerifyauthresponseResponse(),
            await self.do_request_async('1.0', 'baas.did.agent.verifyauthresponse.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def start_did_certification_mask(
        self,
        request: blockchain_models.StartDidCertificationMaskRequest,
    ) -> blockchain_models.StartDidCertificationMaskResponse:
        """
        Description: 脱敏身份验证
        Summary: 脱敏身份验证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_did_certification_mask_ex(request, headers, runtime)

    async def start_did_certification_mask_async(
        self,
        request: blockchain_models.StartDidCertificationMaskRequest,
    ) -> blockchain_models.StartDidCertificationMaskResponse:
        """
        Description: 脱敏身份验证
        Summary: 脱敏身份验证
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_did_certification_mask_ex_async(request, headers, runtime)

    def start_did_certification_mask_ex(
        self,
        request: blockchain_models.StartDidCertificationMaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationMaskResponse:
        """
        Description: 脱敏身份验证
        Summary: 脱敏身份验证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationMaskResponse(),
            self.do_request('1.0', 'baas.did.certification.mask.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def start_did_certification_mask_ex_async(
        self,
        request: blockchain_models.StartDidCertificationMaskRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StartDidCertificationMaskResponse:
        """
        Description: 脱敏身份验证
        Summary: 脱敏身份验证
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StartDidCertificationMaskResponse(),
            await self.do_request_async('1.0', 'baas.did.certification.mask.start', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def open_did_admin_service(
        self,
        request: blockchain_models.OpenDidAdminServiceRequest,
    ) -> blockchain_models.OpenDidAdminServiceResponse:
        """
        Description: 管理员为租户开通did服务
        Summary: 管理员为租户开通did服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.open_did_admin_service_ex(request, headers, runtime)

    async def open_did_admin_service_async(
        self,
        request: blockchain_models.OpenDidAdminServiceRequest,
    ) -> blockchain_models.OpenDidAdminServiceResponse:
        """
        Description: 管理员为租户开通did服务
        Summary: 管理员为租户开通did服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.open_did_admin_service_ex_async(request, headers, runtime)

    def open_did_admin_service_ex(
        self,
        request: blockchain_models.OpenDidAdminServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenDidAdminServiceResponse:
        """
        Description: 管理员为租户开通did服务
        Summary: 管理员为租户开通did服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenDidAdminServiceResponse(),
            self.do_request('1.0', 'baas.did.admin.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def open_did_admin_service_ex_async(
        self,
        request: blockchain_models.OpenDidAdminServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.OpenDidAdminServiceResponse:
        """
        Description: 管理员为租户开通did服务
        Summary: 管理员为租户开通did服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.OpenDidAdminServiceResponse(),
            await self.do_request_async('1.0', 'baas.did.admin.service.open', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    def stop_did_admin_service(
        self,
        request: blockchain_models.StopDidAdminServiceRequest,
    ) -> blockchain_models.StopDidAdminServiceResponse:
        """
        Description: 针对指定租户关闭dis服务
        Summary: 针对指定租户关闭dis服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.stop_did_admin_service_ex(request, headers, runtime)

    async def stop_did_admin_service_async(
        self,
        request: blockchain_models.StopDidAdminServiceRequest,
    ) -> blockchain_models.StopDidAdminServiceResponse:
        """
        Description: 针对指定租户关闭dis服务
        Summary: 针对指定租户关闭dis服务
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.stop_did_admin_service_ex_async(request, headers, runtime)

    def stop_did_admin_service_ex(
        self,
        request: blockchain_models.StopDidAdminServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.StopDidAdminServiceResponse:
        """
        Description: 针对指定租户关闭dis服务
        Summary: 针对指定租户关闭dis服务
        """
        UtilClient.validate_model(request)
        return TeaCore.from_map(
            blockchain_models.StopDidAdminServiceResponse(),
            self.do_request('1.0', 'baas.did.admin.service.stop', 'HTTPS', 'POST', f'/gateway.do', TeaCore.to_map(request), headers, runtime)
        )

    async def stop_did_admin_service_ex_async(
        self,
        request: blockchain_models.StopDidAdminServiceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> blockchain_models.Sto