#!/usr/bin/env python3

import pytest
from bio96 import *

def test_iter_wells_in_block():
    examples = [
            (('A1', 0, 0), []),
            (('A1', 0, 1), []),
            (('A1', 1, 0), []),
            (('A1', 1, 1), ['A1']),
            (('A1', 2, 1), ['A1', 'A2']),
            (('A1', 1, 2), ['A1', 'B1']),
            (('A1', 2, 2), ['A1', 'A2', 'B1', 'B2']),

            (('A2', 0, 0), []),
            (('A2', 0, 1), []),
            (('A2', 1, 0), []),
            (('A2', 1, 1), ['A2']),
            (('A2', 2, 1), ['A2', 'A3']),
            (('A2', 1, 2), ['A2', 'B2']),
            (('A2', 2, 2), ['A2', 'A3', 'B2', 'B3']),

            (('B1', 0, 0), []),
            (('B1', 0, 1), []),
            (('B1', 1, 0), []),
            (('B1', 1, 1), ['B1']),
            (('B1', 2, 1), ['B1', 'B2']),
            (('B1', 1, 2), ['B1', 'C1']),
            (('B1', 2, 2), ['B1', 'B2', 'C1', 'C2']),
    ]
    for args, expected in examples:
        assert set(iter_wells_in_block(*args)) == set(expected)
