""" Provides Relationship classes to be used by client code.

All relationship classes must inherit from Relationship
to be usable within the framework.

The IsA and InstanceOf relationships are used internally for describing
inheritance relationships and are autogenerated when an object is added
to the data store.

They may be used for querying and map to pyhton's issubclass()
and isinstanceof() functionality.
"""
from kaiso.types import Relationship
from kaiso.attributes import Integer


class IsA(Relationship):
    """ Describes a sub-class relationship between two classes.

    It maps to python's issubclass(sub_class, base_class) as
    IsA(sub_class, base_class).
    """
    base_index = Integer(required=True)


class InstanceOf(Relationship):
    """ Describes a instance to type relationship
    between an object and a class.

    It maps to python's isinstance(obj, the_class) as
    InstanceOf(obj, the_class).
    """


class DeclaredOn(Relationship):
    """ Describes the relationship between a type and the properties that
    instances of that type can have.
    """


class Defines(Relationship):
    """ Relationship used by the ``TypeSystem`` to connect to the types
    it defines.
    """
