import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
/**
 * @stability stable
 */
export interface DataDockerNetworkConfig extends TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly id?: string;
    /**
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export declare class DataDockerNetworkIpamConfig extends ComplexComputedList {
    /**
     * @stability stable
     */
    get auxAddress(): any;
    /**
     * @stability stable
     */
    get gateway(): string;
    /**
     * @stability stable
     */
    get ipRange(): string;
    /**
     * @stability stable
     */
    get subnet(): string;
}
/**
 * @stability stable
 */
export declare class DataDockerNetwork extends TerraformDataSource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDockerNetworkConfig);
    /**
     * @stability stable
     */
    get driver(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get internal(): boolean;
    /**
     * @stability stable
     */
    ipamConfig(index: string): DataDockerNetworkIpamConfig;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    options(key: string): string;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
