import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 * @stability stable
 */
export interface ImageConfig extends TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly keepLocally?: boolean;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly pullTrigger?: string;
    /**
     * @stability stable
     */
    readonly pullTriggers?: string[];
}
/**
 * @stability stable
 */
export declare class Image extends TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImageConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _keepLocally?;
    /**
     * @stability stable
     */
    get keepLocally(): boolean;
    /**
     * @stability stable
     */
    set keepLocally(value: boolean);
    /**
     * @stability stable
     */
    resetKeepLocally(): void;
    /**
     * @stability stable
     */
    get keepLocallyInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get latest(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _pullTrigger?;
    /**
     * @stability stable
     */
    get pullTrigger(): string;
    /**
     * @stability stable
     */
    set pullTrigger(value: string);
    /**
     * @stability stable
     */
    resetPullTrigger(): void;
    /**
     * @stability stable
     */
    get pullTriggerInput(): string | undefined;
    private _pullTriggers?;
    /**
     * @stability stable
     */
    get pullTriggers(): string[];
    /**
     * @stability stable
     */
    set pullTriggers(value: string[]);
    /**
     * @stability stable
     */
    resetPullTriggers(): void;
    /**
     * @stability stable
     */
    get pullTriggersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
