import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkConfig extends TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly attachable?: boolean;
    /**
     * @stability stable
     */
    readonly checkDuplicate?: boolean;
    /**
     * @stability stable
     */
    readonly driver?: string;
    /**
     * @stability stable
     */
    readonly ingress?: boolean;
    /**
     * @stability stable
     */
    readonly internal?: boolean;
    /**
     * @stability stable
     */
    readonly ipamDriver?: string;
    /**
     * @stability stable
     */
    readonly ipv6?: boolean;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * ipam_config block.
     *
     * @stability stable
     */
    readonly ipamConfig?: NetworkIpamConfig[];
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: NetworkLabels[];
}
/**
 * @stability stable
 */
export interface NetworkIpamConfig {
    /**
     * @stability stable
     */
    readonly auxAddress?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly gateway?: string;
    /**
     * @stability stable
     */
    readonly ipRange?: string;
    /**
     * @stability stable
     */
    readonly subnet?: string;
}
/**
 * @stability stable
 */
export interface NetworkLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export declare class Network extends TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkConfig);
    private _attachable?;
    /**
     * @stability stable
     */
    get attachable(): boolean;
    /**
     * @stability stable
     */
    set attachable(value: boolean);
    /**
     * @stability stable
     */
    resetAttachable(): void;
    /**
     * @stability stable
     */
    get attachableInput(): boolean | undefined;
    private _checkDuplicate?;
    /**
     * @stability stable
     */
    get checkDuplicate(): boolean;
    /**
     * @stability stable
     */
    set checkDuplicate(value: boolean);
    /**
     * @stability stable
     */
    resetCheckDuplicate(): void;
    /**
     * @stability stable
     */
    get checkDuplicateInput(): boolean | undefined;
    private _driver?;
    /**
     * @stability stable
     */
    get driver(): string;
    /**
     * @stability stable
     */
    set driver(value: string);
    /**
     * @stability stable
     */
    resetDriver(): void;
    /**
     * @stability stable
     */
    get driverInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ingress?;
    /**
     * @stability stable
     */
    get ingress(): boolean;
    /**
     * @stability stable
     */
    set ingress(value: boolean);
    /**
     * @stability stable
     */
    resetIngress(): void;
    /**
     * @stability stable
     */
    get ingressInput(): boolean | undefined;
    private _internal?;
    /**
     * @stability stable
     */
    get internal(): boolean;
    /**
     * @stability stable
     */
    set internal(value: boolean);
    /**
     * @stability stable
     */
    resetInternal(): void;
    /**
     * @stability stable
     */
    get internalInput(): boolean | undefined;
    private _ipamDriver?;
    /**
     * @stability stable
     */
    get ipamDriver(): string;
    /**
     * @stability stable
     */
    set ipamDriver(value: string);
    /**
     * @stability stable
     */
    resetIpamDriver(): void;
    /**
     * @stability stable
     */
    get ipamDriverInput(): string | undefined;
    private _ipv6?;
    /**
     * @stability stable
     */
    get ipv6(): boolean;
    /**
     * @stability stable
     */
    set ipv6(value: boolean);
    /**
     * @stability stable
     */
    resetIpv6(): void;
    /**
     * @stability stable
     */
    get ipv6Input(): boolean | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _options?;
    /**
     * @stability stable
     */
    get options(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set options(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetOptions(): void;
    /**
     * @stability stable
     */
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get scope(): string;
    private _ipamConfig?;
    /**
     * @stability stable
     */
    get ipamConfig(): NetworkIpamConfig[];
    /**
     * @stability stable
     */
    set ipamConfig(value: NetworkIpamConfig[]);
    /**
     * @stability stable
     */
    resetIpamConfig(): void;
    /**
     * @stability stable
     */
    get ipamConfigInput(): NetworkIpamConfig[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): NetworkLabels[];
    /**
     * @stability stable
     */
    set labels(value: NetworkLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): NetworkLabels[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
