import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 * @stability stable
 */
export interface VolumeConfig extends TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly driver?: string;
    /**
     * @stability stable
     */
    readonly driverOpts?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: VolumeLabels[];
}
/**
 * @stability stable
 */
export interface VolumeLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export declare class Volume extends TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: VolumeConfig);
    private _driver?;
    /**
     * @stability stable
     */
    get driver(): string;
    /**
     * @stability stable
     */
    set driver(value: string);
    /**
     * @stability stable
     */
    resetDriver(): void;
    /**
     * @stability stable
     */
    get driverInput(): string | undefined;
    private _driverOpts?;
    /**
     * @stability stable
     */
    get driverOpts(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverOpts(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverOpts(): void;
    /**
     * @stability stable
     */
    get driverOptsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get mountpoint(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): VolumeLabels[];
    /**
     * @stability stable
     */
    set labels(value: VolumeLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): VolumeLabels[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
