from plone.dexterity.fti import DexterityFTI

import pytest


class TestContentTypeFTI:
    @pytest.fixture(autouse=True)
    def _setup(self, portal, get_fti):
        self.portal = portal
        self.get_fti = get_fti

    @pytest.mark.parametrize(
        "portal_type,fti_attr,expected",
        [
            ("Document", "title", "Page"),
            ("Document", "global_allow", True),
            (
                "Document",
                "behaviors",
                (
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.relateditems",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "plone.allowdiscussion",
                    "volto.blocks",
                    "plone.constraintypes",
                    "plone.namefromtitle",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                    "kitconcept.intranet.lcm",
                ),
            ),
            ("Event", "title", "Event"),
            ("Event", "global_allow", True),
            (
                "Event",
                "behaviors",
                (
                    "plone.eventbasic",
                    "plone.eventrecurrence",
                    "plone.eventattendees",
                    "plone.eventcontact",
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "plone.allowdiscussion",
                    "plone.relateditems",
                    "volto.blocks",
                    "plone.constraintypes",
                    "plone.namefromtitle",
                    "plone.textindexer",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("File", "title", "File"),
            ("File", "global_allow", True),
            (
                "File",
                "behaviors",
                (
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.relateditems",
                    "plone.namefromfilename",
                    "plone.versioning",
                    "plone.locking",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("Image", "title", "Image"),
            ("Image", "global_allow", True),
            (
                "Image",
                "behaviors",
                (
                    "volto.kicker",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.relateditems",
                    "plone.namefromfilename",
                    "plone.versioning",
                    "plone.locking",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("Link", "title", "Link"),
            ("Link", "global_allow", True),
            (
                "Link",
                "behaviors",
                (
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "plone.namefromtitle",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("Location", "title", "Location"),
            ("Location", "global_allow", True),
            (
                "Location",
                "behaviors",
                (
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "kitconcept.intranet.organisational_unit",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "volto.blocks",
                    "plone.constraintypes",
                    "plone.namefromtitle",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                ),
            ),
            ("News Item", "title", "News Item"),
            ("News Item", "global_allow", True),
            (
                "News Item",
                "behaviors",
                (
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "plone.relateditems",
                    "volto.blocks",
                    "plone.constraintypes",
                    "plone.namefromtitle",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("Organisational Unit", "title", "Organisational Unit"),
            ("Organisational Unit", "global_allow", True),
            (
                "Organisational Unit",
                "behaviors",
                (
                    "plone.basic",
                    "volto.preview_image_link",
                    "volto.kicker",
                    "kitconcept.intranet.location",
                    "plone.categorization",
                    "plone.publication",
                    "plone.ownership",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "volto.blocks",
                    "plone.constraintypes",
                    "plone.namefromtitle",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                ),
            ),
            ("Person", "title", "Person"),
            ("Person", "global_allow", True),
            (
                "Person",
                "behaviors",
                (
                    "kitconcept.core.person_image",
                    "volto.kicker",
                    "collective.person.person",
                    "kitconcept.core.biography",
                    "kitconcept.intranet.person",
                    "collective.contact_behaviors.contact_info",
                    "kitconcept.core.additional_contact_info",
                    "plone.namefromtitle",
                    "plone.shortname",
                    "volto.navtitle",
                    "plone.excludefromnavigation",
                    "plone.relateditems",
                    "plone.versioning",
                    "plone.locking",
                    "plone.translatable",
                    "kitconcept.intranet.location",
                    "kitconcept.intranet.organisational_unit",
                ),
            ),
            ("Plone Site", "title", "Plone Site"),
            ("Plone Site", "klass", "Products.CMFPlone.Portal.PloneSite"),
            ("Plone Site", "global_allow", False),
            (
                "Plone Site",
                "behaviors",
                (
                    "volto.preview_image_link",
                    "voltolighttheme.header",
                    "voltolighttheme.theme",
                    "voltolighttheme.footer",
                    "kitconcept.footer",
                    "kitconcept.sticky_menu",
                    "plonegovbr.socialmedia.settings",
                    "plone.basic",
                    "plone.relateditems",
                    "plone.locking",
                    "volto.blocks",
                    "kitconcept.blocks.config",
                ),
            ),
        ],
    )
    def test_fti_attributes(self, portal_type: str, fti_attr: str, expected):
        """Test FTI values."""
        fti: DexterityFTI = self.get_fti(portal_type)

        assert isinstance(fti, DexterityFTI)
        assert getattr(fti, fti_attr) == expected
