from enum import Enum

class OwnerType(Enum):
    PRO = "pro"
    PRIVATE = "private"
    ALL = "all"

class AdType(Enum):
    OFFER = "offer"
    DEMAND = "demand"

class Sort(Enum):
    RELEVANCE = ("relevance", None)
    NEWEST = ("time", "desc")
    OLDEST = ("time", "asc")
    EXPENSIVE = ("price", "asc")
    CHEAPEST = ("price", "desc")

class Department(Enum):
    BAS_RHIN = ("1", "ALSACE", "67", "BAS_RHIN")
    HAUT_RHIN = ("1", "ALSACE", "68", "HAUT_RHIN")
    DORDOGNE = ("2", "AQUITAINE", "24", "DORDOGNE")
    GIRONDE = ("2", "AQUITAINE", "33", "GIRONDE")
    LANDES = ("2", "AQUITAINE", "40", "LANDES")
    LOT_ET_GARONNE = ("2", "AQUITAINE", "47", "LOT_ET_GARONNE")
    PYRENEES_ATLANTIQUES = ("2", "AQUITAINE", "64", "PYRENEES_ATLANTIQUES")
    ALLIER = ("3", "AUVERGNE", "3", "ALLIER")
    CANTAL = ("3", "AUVERGNE", "15", "CANTAL")
    HAUTE_LOIRE = ("3", "AUVERGNE", "43", "HAUTE_LOIRE")
    PUY_DE_DOME = ("3", "AUVERGNE", "63", "PUY_DE_DOME")
    CALVADOS = ("4", "BASSE_NORMANDIE", "14", "CALVADOS")
    MANCHE = ("4", "BASSE_NORMANDIE", "50", "MANCHE")
    ORNE = ("4", "BASSE_NORMANDIE", "61", "ORNE")
    COTE_DOR = ("5", "BOURGOGNE", "21", "COTE_DOR")
    NIEVRE = ("5", "BOURGOGNE", "58", "NIEVRE")
    SAONE_ET_LOIRE = ("5", "BOURGOGNE", "71", "SAONE_ET_LOIRE")
    YONNE = ("5", "BOURGOGNE", "89", "YONNE")
    COTES_DARMOR = ("6", "BRETAGNE", "22", "COTES_DARMOR")
    FINISTERE = ("6", "BRETAGNE", "29", "FINISTERE")
    ILLE_ET_VILAINE = ("6", "BRETAGNE", "35", "ILLE_ET_VILAINE")
    MORBIHAN = ("6", "BRETAGNE", "56", "MORBIHAN")
    CHER = ("7", "CENTRE", "18", "CHER")
    EURE_ET_LOIR = ("7", "CENTRE", "28", "EURE_ET_LOIR")
    INDRE = ("7", "CENTRE", "36", "INDRE")
    INDRE_ET_LOIRE = ("7", "CENTRE", "37", "INDRE_ET_LOIRE")
    LOIR_ET_CHER = ("7", "CENTRE", "41", "LOIR_ET_CHER")
    LOIRET = ("7", "CENTRE", "45", "LOIRET")
    ARDENNES = ("8", "CHAMPAGNE_ARDENNE", "8", "ARDENNES")
    AUBE = ("8", "CHAMPAGNE_ARDENNE", "10", "AUBE")
    MARNE = ("8", "CHAMPAGNE_ARDENNE", "51", "MARNE")
    HAUTE_MARNE = ("8", "CHAMPAGNE_ARDENNE", "52", "HAUTE_MARNE")
    DOUBS = ("10", "FRANCHE_COMTE", "25", "DOUBS")
    JURA = ("10", "FRANCHE_COMTE", "39", "JURA")
    HAUTE_SAONE = ("10", "FRANCHE_COMTE", "70", "HAUTE_SAONE")
    TERRITOIRE_DE_BELFORT = ("10", "FRANCHE_COMTE", "90", "TERRITOIRE_DE_BELFORT")
    EURE = ("11", "HAUTE_NORMANDIE", "27", "EURE")
    SEINE_MARITIME = ("11", "HAUTE_NORMANDIE", "76", "SEINE_MARITIME")
    PARIS = ("12", "ILE_DE_FRANCE", "75", "PARIS")
    SEINE_ET_MARNE = ("12", "ILE_DE_FRANCE", "77", "SEINE_ET_MARNE")
    YVELINES = ("12", "ILE_DE_FRANCE", "78", "YVELINES")
    ESSONNE = ("12", "ILE_DE_FRANCE", "91", "ESSONNE")
    HAUTS_DE_SEINE = ("12", "ILE_DE_FRANCE", "92", "HAUTS_DE_SEINE")
    SEINE_SAINT_DENIS = ("12", "ILE_DE_FRANCE", "93", "SEINE_SAINT_DENIS")
    VAL_DE_MARNE = ("12", "ILE_DE_FRANCE", "94", "VAL_DE_MARNE")
    VAL_DOISE = ("12", "ILE_DE_FRANCE", "95", "VAL_DOISE")
    AUDE = ("13", "LANGUEDOC_ROUSSILLON", "11", "AUDE")
    GARD = ("13", "LANGUEDOC_ROUSSILLON", "30", "GARD")
    HERAULT = ("13", "LANGUEDOC_ROUSSILLON", "34", "HERAULT")
    LOZERE = ("13", "LANGUEDOC_ROUSSILLON", "48", "LOZERE")
    PYRENEES_ORIENTALES = ("13", "LANGUEDOC_ROUSSILLON", "66", "PYRENEES_ORIENTALES")
    CORREZE = ("14", "LIMOUSIN", "19", "CORREZE")
    CREUSE = ("14", "LIMOUSIN", "23", "CREUSE")
    HAUTE_VIENNE = ("14", "LIMOUSIN", "87", "HAUTE_VIENNE")
    MEURTHE_ET_MOSELLE = ("15", "LORRAINE", "54", "MEURTHE_ET_MOSELLE")
    MEUSE = ("15", "LORRAINE", "55", "MEUSE")
    MOSELLE = ("15", "LORRAINE", "57", "MOSELLE")
    VOSGES = ("15", "LORRAINE", "88", "VOSGES")
    ARIEGE = ("16", "MIDI_PYRENEES", "9", "ARIEGE")
    AVEYRON = ("16", "MIDI_PYRENEES", "12", "AVEYRON")
    HAUTE_GARONNE = ("16", "MIDI_PYRENEES", "31", "HAUTE_GARONNE")
    GERS = ("16", "MIDI_PYRENEES", "32", "GERS")
    LOT = ("16", "MIDI_PYRENEES", "46", "LOT")
    HAUTES_PYRENEES = ("16", "MIDI_PYRENEES", "65", "HAUTES_PYRENEES")
    TARN = ("16", "MIDI_PYRENEES", "81", "TARN")
    TARN_ET_GARONNE = ("16", "MIDI_PYRENEES", "82", "TARN_ET_GARONNE")
    NORD = ("17", "NORD_PAS_DE_CALAIS", "59", "NORD")
    PAS_DE_CALAIS = ("17", "NORD_PAS_DE_CALAIS", "62", "PAS_DE_CALAIS")
    LOIRE_ATLANTIQUE = ("18", "PAYS_DE_LA_LOIRE", "44", "LOIRE_ATLANTIQUE")
    MAINE_ET_LOIRE = ("18", "PAYS_DE_LA_LOIRE", "49", "MAINE_ET_LOIRE")
    MAYENNE = ("18", "PAYS_DE_LA_LOIRE", "53", "MAYENNE")
    SARTHE = ("18", "PAYS_DE_LA_LOIRE", "72", "SARTHE")
    VENDEE = ("18", "PAYS_DE_LA_LOIRE", "85", "VENDEE")
    AISNE = ("19", "PICARDIE", "2", "AISNE")
    OISE = ("19", "PICARDIE", "60", "OISE")
    SOMME = ("19", "PICARDIE", "80", "SOMME")
    CHARENTE = ("20", "POITOU_CHARENTES", "16", "CHARENTE")
    CHARENTE_MARITIME = ("20", "POITOU_CHARENTES", "17", "CHARENTE_MARITIME")
    DEUX_SEVRES = ("20", "POITOU_CHARENTES", "79", "DEUX_SEVRES")
    VIENNE = ("20", "POITOU_CHARENTES", "86", "VIENNE")
    ALPES_DE_HAUTE_PROVENCE = ("21", "PROVENCE_ALPES_COTE_DAZUR", "4", "ALPES_DE_HAUTE_PROVENCE")
    HAUTES_ALPES = ("21", "PROVENCE_ALPES_COTE_DAZUR", "5", "HAUTES_ALPES")
    ALPES_MARITIMES = ("21", "PROVENCE_ALPES_COTE_DAZUR", "6", "ALPES_MARITIMES")
    BOUCHES_DU_RHONE = ("21", "PROVENCE_ALPES_COTE_DAZUR", "13", "BOUCHES_DU_RHONE")
    VAR = ("21", "PROVENCE_ALPES_COTE_DAZUR", "83", "VAR")
    VAUCLUSE = ("21", "PROVENCE_ALPES_COTE_DAZUR", "84", "VAUCLUSE")
    AIN = ("22", "RHONE_ALPES", "1", "AIN")
    ARDECHE = ("22", "RHONE_ALPES", "7", "ARDECHE")
    DROME = ("22", "RHONE_ALPES", "26", "DROME")
    ISERE = ("22", "RHONE_ALPES", "38", "ISERE")
    LOIRE = ("22", "RHONE_ALPES", "42", "LOIRE")
    RHONE = ("22", "RHONE_ALPES", "69", "RHONE")
    SAVOIE = ("22", "RHONE_ALPES", "73", "SAVOIE")
    HAUTE_SAVOIE = ("22", "RHONE_ALPES", "74", "HAUTE_SAVOIE")

class Region(Enum):
    ALSACE = ("1", "ALSACE")
    AQUITAINE = ("2", "AQUITAINE")
    AUVERGNE = ("3", "AUVERGNE")
    AUVERGNE_RHONE_ALPES = ("30", "AUVERGNE_RHONE_ALPES")
    BASSE_NORMANDIE = ("4", "BASSE_NORMANDIE")
    BOURGOGNE = ("5", "BOURGOGNE")
    BOURGOGNE_FRANCHE_COMTE = ("31", "BOURGOGNE_FRANCHE_COMTE")
    BRETAGNE = ("6", "BRETAGNE")
    CENTRE = ("7", "CENTRE")
    CENTRE_VAL_DE_LOIRE = ("37", "CENTRE_VAL_DE_LOIRE")
    CHAMPAGNE_ARDENNE = ("8", "CHAMPAGNE_ARDENNE")
    CORSE = ("9", "CORSE")
    FRANCHE_COMTE = ("10", "FRANCHE_COMTE")
    GRAND_EST = ("33", "GRAND_EST")
    GUADELOUPE = ("23", "GUADELOUPE")
    GUYANE = ("25", "GUYANE")
    HAUTE_NORMANDIE = ("11", "HAUTE_NORMANDIE")
    HAUTS_DE_FRANCE = ("32", "HAUTS_DE_FRANCE")
    ILE_DE_FRANCE = ("12", "ILE_DE_FRANCE")
    LANGUEDOC_ROUSSILLON = ("13", "LANGUEDOC_ROUSSILLON")
    LIMOUSIN = ("14", "LIMOUSIN")
    LORRAINE = ("15", "LORRAINE")
    MARTINIQUE = ("24", "MARTINIQUE")
    MIDI_PYRENEES = ("16", "MIDI_PYRENEES")
    NORD_PAS_DE_CALAIS = ("17", "NORD_PAS_DE_CALAIS")
    NORMANDIE = ("34", "NORMANDIE")
    NOUVELLE_AQUITAINE = ("35", "NOUVELLE_AQUITAINE")
    OCCITANIE = ("36", "OCCITANIE")
    PAYS_DE_LA_LOIRE = ("18", "PAYS_DE_LA_LOIRE")
    PICARDIE = ("19", "PICARDIE")
    POITOU_CHARENTES = ("20", "POITOU_CHARENTES")
    PROVENCE_ALPES_COTE_DAZUR = ("21", "PROVENCE_ALPES_COTE_DAZUR")
    RHONE_ALPES = ("22", "RHONE_ALPES")
    REUNION = ("26", "REUNION")

class Category(Enum):
    TOUTES_CATEGORIES = "0"
    EMPLOI = "71"
    EMPLOI_OFFRES_DEMPLOI = "33"
    EMPLOI_FORMATIONS_PROFESSIONNELLES = "74"
    VEHICULES = "1"
    VEHICULES_VOITURES = "2"
    VEHICULES_MOTOS = "3"
    VEHICULES_CARAVANING = "4"
    VEHICULES_UTILITAIRES = "5"
    VEHICULES_CAMIONS = "300"
    VEHICULES_NAUTISME = "7"
    VEHICULES_VELOS = "1002"
    VEHICULES_EQUIPEMENT_AUTO = "6"
    VEHICULES_EQUIPEMENT_MOTO = "44"
    VEHICULES_EQUIPEMENT_CARAVANING = "50"
    VEHICULES_EQUIPEMENT_NAUTISME = "51"
    VEHICULES_EQUIPEMENTS_VELOS = "1003"
    VEHICULES_SERVICES_DE_REPARATIONS_MECANIQUES = "1004"
    IMMOBILIER = "8"
    IMMOBILIER_VENTES_IMMOBILIERES = "9"
    IMMOBILIER_LOCATIONS = "10"
    IMMOBILIER_COLOCATIONS = "11"
    IMMOBILIER_BUREAUX_ET_COMMERCES = "13"
    IMMOBILIER_IMMOBILIER_NEUF = "304"
    IMMOBILIER_SERVICES_DE_DEMENAGEMENT = "1001"
    LOCATIONS_DE_VACANCES = "66"
    LOCATIONS_DE_VACANCES_LOCATIONS_SAISONNIERES = "12"
    ELECTRONIQUE = "14"
    ELECTRONIQUE_ORDINATEURS = "15"
    ELECTRONIQUE_ACCESSOIRES_INFORMATIQUE = "83"
    ELECTRONIQUE_TABLETTES_ET_LISEUSES = "82"
    ELECTRONIQUE_PHOTO_AUDIO_ET_VIDEO = "16"
    ELECTRONIQUE_TELEPHONES_ET_OBJETS_CONNECTES = "17"
    ELECTRONIQUE_ACCESSOIRES_TELEPHONE_ET_OBJETS_CONNECTES = "81"
    ELECTRONIQUE_CONSOLES = "43"
    ELECTRONIQUE_JEUX_VIDEO = "84"
    ELECTRONIQUE_ELECTROMENAGER = "1006"
    ELECTRONIQUE_SERVICES_DE_REPARATIONS_ELECTRONIQUES = "1007"
    MAISON_ET_JARDIN = "18"
    MAISON_ET_JARDIN_AMEUBLEMENT = "19"
    MAISON_ET_JARDIN_PAPETERIE_ET_FOURNITURES_SCOLAIRES = "96"
    MAISON_ET_JARDIN_ELECTROMENAGER = "20"
    MAISON_ET_JARDIN_ARTS_DE_LA_TABLE = "45"
    MAISON_ET_JARDIN_DECORATION = "39"
    MAISON_ET_JARDIN_LINGE_DE_MAISON = "46"
    MAISON_ET_JARDIN_BRICOLAGE = "21"
    MAISON_ET_JARDIN_JARDIN_ET_PLANTES = "52"
    MAISON_ET_JARDIN_SERVICES_DE_JARDINERIE_ET_BRICOLAGE = "1005"
    FAMILLE = "79"
    FAMILLE_EQUIPEMENT_BEBE = "23"
    FAMILLE_MOBILIER_ENFANT = "80"
    FAMILLE_VETEMENTS_BEBE = "54"
    FAMILLE_VETEMENTS_ENFANTS = "1011"
    FAMILLE_VETEMENTS_MATERNITE = "1012"
    FAMILLE_CHAUSSURES_ENFANTS = "1013"
    FAMILLE_MONTRES_ET_BIJOUX_ENFANTS = "1014"
    FAMILLE_ACCESSOIRES_ET_BAGAGERIE_ENFANTS = "1015"
    FAMILLE_JEUX_ET_JOUETS = "1016"
    FAMILLE_BABY_SITTING = "1017"
    MODE = "72"
    MODE_VETEMENTS = "22"
    MODE_CHAUSSURES = "53"
    MODE_ACCESSOIRES_ET_BAGAGERIE = "47"
    MODE_MONTRES_ET_BIJOUX = "42"
    LOISIRS = "24"
    LOISIRS_ANTIQUITES = "89"
    LOISIRS_ARTISTES_ET_MUSICIENS = "1008"
    LOISIRS_BILLETTERIE = "1009"
    LOISIRS_COLLECTION = "40"
    LOISIRS_CD_MUSIQUE = "26"
    LOISIRS_DVD_FILMS = "25"
    LOISIRS_INSTRUMENTS_DE_MUSIQUE = "30"
    LOISIRS_LIVRES = "27"
    LOISIRS_MODELISME = "86"
    LOISIRS_VINS_ET_GASTRONOMIE = "48"
    LOISIRS_JEUX_ET_JOUETS = "41"
    LOISIRS_LOISIRS_CREATIFS = "88"
    LOISIRS_SPORT_ET_PLEIN_AIR = "29"
    LOISIRS_VELOS = "55"
    LOISIRS_EQUIPEMENTS_VELOS = "85"
    ANIMAUX = "75"
    ANIMAUX_ANIMAUX = "28"
    ANIMAUX_ACCESSOIRES_ANIMAUX = "76"
    ANIMAUX_ANIMAUX_PERDUS = "77"
    ANIMAUX_SERVICES_AUX_ANIMAUX = "1010"
    MATERIEL_PROFESSIONNEL = "56"
    MATERIEL_PROFESSIONNEL_TRACTEURS = "105"
    MATERIEL_PROFESSIONNEL_MATERIEL_AGRICOLE = "57"
    MATERIEL_PROFESSIONNEL_BTP_CHANTIER_GROS_OEUVRE = "59"
    MATERIEL_PROFESSIONNEL_POIDS_LOURDS = "106"
    MATERIEL_PROFESSIONNEL_MANUTENTION_LEVAGE = "58"
    MATERIEL_PROFESSIONNEL_EQUIPEMENTS_INDUSTRIELS = "32"
    MATERIEL_PROFESSIONNEL_EQUIPEMENTS_POUR_RESTAURANTS_ET_HOTELS = "61"
    MATERIEL_PROFESSIONNEL_EQUIPEMENTS_ET_FOURNITURES_DE_BUREAU = "62"
    MATERIEL_PROFESSIONNEL_EQUIPEMENTS_POUR_COMMERCES_ET_MARCHES = "63"
    MATERIEL_PROFESSIONNEL_MATERIEL_MEDICAL = "64"
    SERVICES = "31"
    SERVICES_ARTISTES_ET_MUSICIENS = "101"
    SERVICES_BABY_SITTING = "100"
    SERVICES_BILLETTERIE = "35"
    SERVICES_COVOITURAGE = "65"
    SERVICES_COURS_PARTICULIERS = "36"
    SERVICES_ENTRAIDE_ENTRE_VOISINS = "103"
    SERVICES_EVENEMENTS = "49"
    SERVICES_SERVICES_A_LA_PERSONNE = "99"
    SERVICES_SERVICES_AUX_ANIMAUX = "102"
    SERVICES_SERVICES_DE_DEMENAGEMENT = "92"
    SERVICES_SERVICES_DE_REPARATIONS_ELECTRONIQUES = "95"
    SERVICES_SERVICES_DE_REPARATIONS_MECANIQUES = "93"
    SERVICES_SERVICES_DE_JARDINERIE_ET_BRICOLAGE = "97"
    SERVICES_SERVICES_EVENEMENTIELS = "98"
    SERVICES_AUTRES_SERVICES = "34"
    DONS = "1000"
    DIVERS = "37"
    DIVERS_AUTRES = "38"