# drppy-client
# An RestFUL API-driven Provisioner and DHCP server

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 4.14.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
- For more information, please visit [https://doc.rackn.io/](https://docs.rackn.io/)

## Requirements.
Python 3.4+

## Installation & Usage
### pip install
This should be done in a virtual environment and not directly installed into the system python.

To install directly from public pypi use the following command:

```sh
pip install drppy_client
```

Once installed use the following code to import the package for use:

```python
import drppy_client
```

To use the development version of this library install directly from gitlab using:

```sh
pip install git+https://gitlab.com/rackn/drppy_client.git
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python -m pip install .
```


Then import the package:
```python
import drppy_client
```

## Getting Started
Examples are provided in the examples/ directory, and make an excellent initial place to start exploring for how to use the
library. The examples are implemented as a basic drpcli example.

Below is a basic example that can be created once the library is installed to verify things are working. It assumes at least 1 machine exists,
and also uses the default credentials and endpoint location. Be sure to adjust the host, username, and password as needed to match your environment.

```python
from pprint import pprint

from drppy_client.configuration import Configuration
from drppy_client.api_client import ApiClient
from drppy_client.api.machines_api import MachinesApi


config = Configuration()
config.host = 'https://localhost:8092/api/v3'
config.username = "rocketskates"
config.password = "r0cketsk8ts"
config.verify_ssl = False

client = ApiClient(config)

machines = MachinesApi(client)

my_machines = machines.list_machines()

print(my_machines[0])
```
## DRPCLI example using Python

The drpcli.py example is implemented using Python Click. Be sure click is installed if you plan to use the example
```sh
pip install click
```

Locate the examples directory. The examples are generally stored in $VENV_ROOT/share/drppy_client/examples

From the examples directory run:

```sh
$ python drpcli.py --help

Usage: drpcli.py [OPTIONS] COMMAND [ARGS]...

Main entry point for the CLI.

Options:
--endpoint TEXT  API host URL
--token TEXT     API token
--key TEXT       user:password  Used for basic auth
--help           Show this message and exit.

Commands:
contents  Contents Specific Commands.
machines  Machine Specific Commands.
params    Parameter Specific Commands.
profiles  Profiles Specific Commands.
subnets   Subnets Specific Commands.

$ python drpcli.py machines list
```
If you do not want to run the examples and just want to look at the code to see how to use the SDK open up the file for the thing you want to learn.
Machine examples are in the machines.py file, Profile examples in the profiles.py file etc.. The examples implemented are minimal by design to give
you a starting point. If you are having trouble using them, or finding an example that demonstrates the feature you need please send a support request
to support@rackn.com

## Documentation for API Endpoints

All URIs are relative to *https://localhost/api/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**create_activity**](docs/ActivitiesApi.md#create_activity) | **POST** /activities | Create a Activity
*ActivitiesApi* | [**delete_activity**](docs/ActivitiesApi.md#delete_activity) | **DELETE** /activities/{id} | Delete a Activity
*ActivitiesApi* | [**get_activity**](docs/ActivitiesApi.md#get_activity) | **GET** /activities/{id} | Get a Activity
*ActivitiesApi* | [**get_activity_action**](docs/ActivitiesApi.md#get_activity_action) | **GET** /activities/{id}/actions/{cmd} | List specific action for a activities Activity
*ActivitiesApi* | [**get_activity_actions**](docs/ActivitiesApi.md#get_activity_actions) | **GET** /activities/{id}/actions | List activities actions Activity
*ActivitiesApi* | [**head_activity**](docs/ActivitiesApi.md#head_activity) | **HEAD** /activities/{id} | See if a Activity exists
*ActivitiesApi* | [**list_activities**](docs/ActivitiesApi.md#list_activities) | **GET** /activities | Lists Activities filtered by some parameters.
*ActivitiesApi* | [**list_stats_activities**](docs/ActivitiesApi.md#list_stats_activities) | **HEAD** /activities | Stats of the List Activities filtered by some parameters.
*ActivitiesApi* | [**patch_activity**](docs/ActivitiesApi.md#patch_activity) | **PATCH** /activities/{id} | Patch a Activity
*ActivitiesApi* | [**post_activity_action**](docs/ActivitiesApi.md#post_activity_action) | **POST** /activities/{id}/actions/{cmd} | Call an action on the node.
*ActivitiesApi* | [**put_activity**](docs/ActivitiesApi.md#put_activity) | **PUT** /activities/{id} | Put a Activity
*AlertsApi* | [**create_alert**](docs/AlertsApi.md#create_alert) | **POST** /alerts | Create a Alert
*AlertsApi* | [**delete_alert**](docs/AlertsApi.md#delete_alert) | **DELETE** /alerts/{uuid} | Delete a Alert
*AlertsApi* | [**delete_alert_param**](docs/AlertsApi.md#delete_alert_param) | **DELETE** /alerts/{uuid}/params/{key} | Delete a single alerts parameter
*AlertsApi* | [**get_alert**](docs/AlertsApi.md#get_alert) | **GET** /alerts/{uuid} | Get a Alert
*AlertsApi* | [**get_alert_action**](docs/AlertsApi.md#get_alert_action) | **GET** /alerts/{uuid}/actions/{cmd} | List specific action for a alerts Alert
*AlertsApi* | [**get_alert_actions**](docs/AlertsApi.md#get_alert_actions) | **GET** /alerts/{uuid}/actions | List alerts actions Alert
*AlertsApi* | [**get_alert_param**](docs/AlertsApi.md#get_alert_param) | **GET** /alerts/{uuid}/params/{key} | Get a single alerts parameter
*AlertsApi* | [**get_alert_params**](docs/AlertsApi.md#get_alert_params) | **GET** /alerts/{uuid}/params | List alerts params Alert
*AlertsApi* | [**get_alert_pub_key**](docs/AlertsApi.md#get_alert_pub_key) | **GET** /alerts/{uuid}/pubkey | Get the public key for secure params on a alerts
*AlertsApi* | [**head_alert**](docs/AlertsApi.md#head_alert) | **HEAD** /alerts/{uuid} | See if a Alert exists
*AlertsApi* | [**list_alerts**](docs/AlertsApi.md#list_alerts) | **GET** /alerts | Lists Alerts filtered by some parameters.
*AlertsApi* | [**list_stats_alerts**](docs/AlertsApi.md#list_stats_alerts) | **HEAD** /alerts | Stats of the List Alerts filtered by some parameters.
*AlertsApi* | [**patch_alert**](docs/AlertsApi.md#patch_alert) | **PATCH** /alerts/{uuid} | Patch a Alert
*AlertsApi* | [**patch_alert_params**](docs/AlertsApi.md#patch_alert_params) | **PATCH** /alerts/{uuid}/params | Update all params on the object (merges with existing data)
*AlertsApi* | [**post_alert_ack**](docs/AlertsApi.md#post_alert_ack) | **POST** /alerts/{uuid}/acknowledge | Acknowledge an alert by {uuid}
*AlertsApi* | [**post_alert_action**](docs/AlertsApi.md#post_alert_action) | **POST** /alerts/{uuid}/actions/{cmd} | Call an action on the node.
*AlertsApi* | [**post_alert_param**](docs/AlertsApi.md#post_alert_param) | **POST** /alerts/{uuid}/params/{key} | Set a single parameter on an object
*AlertsApi* | [**post_alert_params**](docs/AlertsApi.md#post_alert_params) | **POST** /alerts/{uuid}/params | Replaces all parameters on the object
*AlertsApi* | [**put_alert**](docs/AlertsApi.md#put_alert) | **PUT** /alerts/{uuid} | Put a Alert
*BatchesApi* | [**create_batch**](docs/BatchesApi.md#create_batch) | **POST** /batches | Create a Batch
*BatchesApi* | [**delete_batch**](docs/BatchesApi.md#delete_batch) | **DELETE** /batches/{uuid} | Delete a Batch
*BatchesApi* | [**get_batch**](docs/BatchesApi.md#get_batch) | **GET** /batches/{uuid} | Get a Batch
*BatchesApi* | [**get_batch_action**](docs/BatchesApi.md#get_batch_action) | **GET** /batches/{uuid}/actions/{cmd} | List specific action for a batches Batch
*BatchesApi* | [**get_batch_actions**](docs/BatchesApi.md#get_batch_actions) | **GET** /batches/{uuid}/actions | List batches actions Batch
*BatchesApi* | [**head_batch**](docs/BatchesApi.md#head_batch) | **HEAD** /batches/{uuid} | See if a Batch exists
*BatchesApi* | [**list_batches**](docs/BatchesApi.md#list_batches) | **GET** /batches | Lists Batches filtered by some parameters.
*BatchesApi* | [**list_stats_batches**](docs/BatchesApi.md#list_stats_batches) | **HEAD** /batches | Stats of the List Batches filtered by some parameters.
*BatchesApi* | [**patch_batch**](docs/BatchesApi.md#patch_batch) | **PATCH** /batches/{uuid} | Patch a Batch
*BatchesApi* | [**post_batch_action**](docs/BatchesApi.md#post_batch_action) | **POST** /batches/{uuid}/actions/{cmd} | Call an action on the node.
*BatchesApi* | [**put_batch**](docs/BatchesApi.md#put_batch) | **PUT** /batches/{uuid} | Put a Batch
*BlueprintsApi* | [**create_blueprint**](docs/BlueprintsApi.md#create_blueprint) | **POST** /blueprints | Create a Blueprint
*BlueprintsApi* | [**delete_blueprint**](docs/BlueprintsApi.md#delete_blueprint) | **DELETE** /blueprints/{name} | Delete a Blueprint
*BlueprintsApi* | [**delete_blueprint_param**](docs/BlueprintsApi.md#delete_blueprint_param) | **DELETE** /blueprints/{name}/params/{key} | Delete a single blueprints parameter
*BlueprintsApi* | [**get_blueprint**](docs/BlueprintsApi.md#get_blueprint) | **GET** /blueprints/{name} | Get a Blueprint
*BlueprintsApi* | [**get_blueprint_action**](docs/BlueprintsApi.md#get_blueprint_action) | **GET** /blueprints/{name}/actions/{cmd} | List specific action for a blueprints Blueprint
*BlueprintsApi* | [**get_blueprint_actions**](docs/BlueprintsApi.md#get_blueprint_actions) | **GET** /blueprints/{name}/actions | List blueprints actions Blueprint
*BlueprintsApi* | [**get_blueprint_param**](docs/BlueprintsApi.md#get_blueprint_param) | **GET** /blueprints/{name}/params/{key} | Get a single blueprints parameter
*BlueprintsApi* | [**get_blueprint_params**](docs/BlueprintsApi.md#get_blueprint_params) | **GET** /blueprints/{name}/params | List blueprints params Blueprint
*BlueprintsApi* | [**get_blueprint_pub_key**](docs/BlueprintsApi.md#get_blueprint_pub_key) | **GET** /blueprints/{name}/pubkey | Get the public key for secure params on a blueprints
*BlueprintsApi* | [**head_blueprint**](docs/BlueprintsApi.md#head_blueprint) | **HEAD** /blueprints/{name} | See if a Blueprint exists
*BlueprintsApi* | [**list_blueprints**](docs/BlueprintsApi.md#list_blueprints) | **GET** /blueprints | Lists Blueprints filtered by some parameters.
*BlueprintsApi* | [**list_stats_blueprints**](docs/BlueprintsApi.md#list_stats_blueprints) | **HEAD** /blueprints | Stats of the List Blueprints filtered by some parameters.
*BlueprintsApi* | [**patch_blueprint**](docs/BlueprintsApi.md#patch_blueprint) | **PATCH** /blueprints/{name} | Patch a Blueprint
*BlueprintsApi* | [**patch_blueprint_params**](docs/BlueprintsApi.md#patch_blueprint_params) | **PATCH** /blueprints/{name}/params | Update all params on the object (merges with existing data)
*BlueprintsApi* | [**post_blueprint_action**](docs/BlueprintsApi.md#post_blueprint_action) | **POST** /blueprints/{name}/actions/{cmd} | Call an action on the node.
*BlueprintsApi* | [**post_blueprint_param**](docs/BlueprintsApi.md#post_blueprint_param) | **POST** /blueprints/{name}/params/{key} | Set a single parameter on an object
*BlueprintsApi* | [**post_blueprint_params**](docs/BlueprintsApi.md#post_blueprint_params) | **POST** /blueprints/{name}/params | Replaces all parameters on the object
*BlueprintsApi* | [**put_blueprint**](docs/BlueprintsApi.md#put_blueprint) | **PUT** /blueprints/{name} | Put a Blueprint
*BootEnvsApi* | [**create_boot_env**](docs/BootEnvsApi.md#create_boot_env) | **POST** /bootenvs | Create a BootEnv
*BootEnvsApi* | [**delete_boot_env**](docs/BootEnvsApi.md#delete_boot_env) | **DELETE** /bootenvs/{name} | Delete a BootEnv
*BootEnvsApi* | [**get_boot_env**](docs/BootEnvsApi.md#get_boot_env) | **GET** /bootenvs/{name} | Get a BootEnv
*BootEnvsApi* | [**get_boot_env_action**](docs/BootEnvsApi.md#get_boot_env_action) | **GET** /bootenvs/{name}/actions/{cmd} | List specific action for a bootenvs BootEnv
*BootEnvsApi* | [**get_boot_env_actions**](docs/BootEnvsApi.md#get_boot_env_actions) | **GET** /bootenvs/{name}/actions | List bootenvs actions BootEnv
*BootEnvsApi* | [**head_boot_env**](docs/BootEnvsApi.md#head_boot_env) | **HEAD** /bootenvs/{name} | See if a BootEnv exists
*BootEnvsApi* | [**list_boot_envs**](docs/BootEnvsApi.md#list_boot_envs) | **GET** /bootenvs | Lists BootEnvs filtered by some parameters.
*BootEnvsApi* | [**list_stats_boot_envs**](docs/BootEnvsApi.md#list_stats_boot_envs) | **HEAD** /bootenvs | Stats of the List BootEnvs filtered by some parameters.
*BootEnvsApi* | [**patch_boot_env**](docs/BootEnvsApi.md#patch_boot_env) | **PATCH** /bootenvs/{name} | Patch a BootEnv
*BootEnvsApi* | [**post_boot_env_action**](docs/BootEnvsApi.md#post_boot_env_action) | **POST** /bootenvs/{name}/actions/{cmd} | Call an action on the node.
*BootEnvsApi* | [**purge_local_boot_env**](docs/BootEnvsApi.md#purge_local_boot_env) | **DELETE** /bootenvs/{name}/purgeLocal | Purge local install files (ISOS and install trees) for a bootenv
*BootEnvsApi* | [**put_boot_env**](docs/BootEnvsApi.md#put_boot_env) | **PUT** /bootenvs/{name} | Put a BootEnv
*CatalogItemsApi* | [**create_catalog_item**](docs/CatalogItemsApi.md#create_catalog_item) | **POST** /catalog_items | Create a CatalogItem
*CatalogItemsApi* | [**delete_catalog_item**](docs/CatalogItemsApi.md#delete_catalog_item) | **DELETE** /catalog_items/{id} | Delete a CatalogItem
*CatalogItemsApi* | [**get_catalog_item**](docs/CatalogItemsApi.md#get_catalog_item) | **GET** /catalog_items/{id} | Get a CatalogItem
*CatalogItemsApi* | [**get_catalog_item_action**](docs/CatalogItemsApi.md#get_catalog_item_action) | **GET** /catalog_items/{id}/actions/{cmd} | List specific action for a catalog_items CatalogItem
*CatalogItemsApi* | [**get_catalog_item_actions**](docs/CatalogItemsApi.md#get_catalog_item_actions) | **GET** /catalog_items/{id}/actions | List catalog_items actions CatalogItem
*CatalogItemsApi* | [**head_catalog_item**](docs/CatalogItemsApi.md#head_catalog_item) | **HEAD** /catalog_items/{id} | See if a CatalogItem exists
*CatalogItemsApi* | [**list_catalog_items**](docs/CatalogItemsApi.md#list_catalog_items) | **GET** /catalog_items | Lists CatalogItems filtered by some parameters.
*CatalogItemsApi* | [**list_stats_catalog_items**](docs/CatalogItemsApi.md#list_stats_catalog_items) | **HEAD** /catalog_items | Stats of the List CatalogItems filtered by some parameters.
*CatalogItemsApi* | [**patch_catalog_item**](docs/CatalogItemsApi.md#patch_catalog_item) | **PATCH** /catalog_items/{id} | Patch a CatalogItem
*CatalogItemsApi* | [**post_catalog_item_action**](docs/CatalogItemsApi.md#post_catalog_item_action) | **POST** /catalog_items/{id}/actions/{cmd} | Call an action on the node.
*CatalogItemsApi* | [**put_catalog_item**](docs/CatalogItemsApi.md#put_catalog_item) | **PUT** /catalog_items/{id} | Put a CatalogItem
*ClustersApi* | [**cleanup_cluster**](docs/ClustersApi.md#cleanup_cluster) | **DELETE** /clusters/{uuid}/cleanup | Cleanup a Cluster
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /clusters | Create a Cluster
*ClustersApi* | [**delete_cluster**](docs/ClustersApi.md#delete_cluster) | **DELETE** /clusters/{uuid} | Delete a Cluster
*ClustersApi* | [**delete_cluster_group_param**](docs/ClustersApi.md#delete_cluster_group_param) | **DELETE** /clusters/{uuid}/group/params/{key} | Delete a single Cluster group profile parameter
*ClustersApi* | [**delete_cluster_param**](docs/ClustersApi.md#delete_cluster_param) | **DELETE** /clusters/{uuid}/params/{key} | Delete a single clusters parameter
*ClustersApi* | [**get_cluster**](docs/ClustersApi.md#get_cluster) | **GET** /clusters/{uuid} | Get a Cluster
*ClustersApi* | [**get_cluster_action**](docs/ClustersApi.md#get_cluster_action) | **GET** /clusters/{uuid}/actions/{cmd} | List specific action for a clusters Cluster
*ClustersApi* | [**get_cluster_actions**](docs/ClustersApi.md#get_cluster_actions) | **GET** /clusters/{uuid}/actions | List clusters actions Cluster
*ClustersApi* | [**get_cluster_group_param**](docs/ClustersApi.md#get_cluster_group_param) | **GET** /clusters/{uuid}/group/params/{key} | Get a single Cluster group profile parameter
*ClustersApi* | [**get_cluster_group_params**](docs/ClustersApi.md#get_cluster_group_params) | **GET** /clusters/{uuid}/group/params | List Cluster group profile params Cluster
*ClustersApi* | [**get_cluster_group_pub_key**](docs/ClustersApi.md#get_cluster_group_pub_key) | **GET** /clusters/{uuid}/group/pubkey | Get the public key for secure params on a Cluster group profile
*ClustersApi* | [**get_cluster_param**](docs/ClustersApi.md#get_cluster_param) | **GET** /clusters/{uuid}/params/{key} | Get a single clusters parameter
*ClustersApi* | [**get_cluster_params**](docs/ClustersApi.md#get_cluster_params) | **GET** /clusters/{uuid}/params | List clusters params Cluster
*ClustersApi* | [**get_cluster_pub_key**](docs/ClustersApi.md#get_cluster_pub_key) | **GET** /clusters/{uuid}/pubkey | Get the public key for secure params on a clusters
*ClustersApi* | [**get_cluster_render**](docs/ClustersApi.md#get_cluster_render) | **POST** /clusters/{uuid}/render | Render a blob on a machine
*ClustersApi* | [**get_cluster_token**](docs/ClustersApi.md#get_cluster_token) | **GET** /clusters/{uuid}/token | Get a Cluster Token
*ClustersApi* | [**head_cluster**](docs/ClustersApi.md#head_cluster) | **HEAD** /clusters/{uuid} | See if a Cluster exists
*ClustersApi* | [**list_clusters**](docs/ClustersApi.md#list_clusters) | **GET** /clusters | Lists Clusters filtered by some parameters.
*ClustersApi* | [**list_stats_clusters**](docs/ClustersApi.md#list_stats_clusters) | **HEAD** /clusters | Stats of the List Clusters filtered by some parameters.
*ClustersApi* | [**patch_cluster**](docs/ClustersApi.md#patch_cluster) | **PATCH** /clusters/{uuid} | Patch a Cluster
*ClustersApi* | [**patch_cluster_group_params**](docs/ClustersApi.md#patch_cluster_group_params) | **PATCH** /clusters/{uuid}/group/params | Update group profile parameters (merges with existing data)
*ClustersApi* | [**patch_cluster_params**](docs/ClustersApi.md#patch_cluster_params) | **PATCH** /clusters/{uuid}/params | Update all params on the object (merges with existing data)
*ClustersApi* | [**post_cluster_action**](docs/ClustersApi.md#post_cluster_action) | **POST** /clusters/{uuid}/actions/{cmd} | Call an action on the node.
*ClustersApi* | [**post_cluster_group_param**](docs/ClustersApi.md#post_cluster_group_param) | **POST** /clusters/{uuid}/group/params/{key} | Set a single Parameter in the group
*ClustersApi* | [**post_cluster_group_params**](docs/ClustersApi.md#post_cluster_group_params) | **POST** /clusters/{uuid}/group/params | Sets the group parameters (replaces)
*ClustersApi* | [**post_cluster_param**](docs/ClustersApi.md#post_cluster_param) | **POST** /clusters/{uuid}/params/{key} | Set a single parameter on an object
*ClustersApi* | [**post_cluster_params**](docs/ClustersApi.md#post_cluster_params) | **POST** /clusters/{uuid}/params | Replaces all parameters on the object
*ClustersApi* | [**post_cluster_release_to_pool**](docs/ClustersApi.md#post_cluster_release_to_pool) | **POST** /clusters/{uuid}/releaseToPool | Releases a cluster in this pool.
*ClustersApi* | [**put_cluster**](docs/ClustersApi.md#put_cluster) | **PUT** /clusters/{uuid} | Put a Cluster
*ClustersApi* | [**start_cluster**](docs/ClustersApi.md#start_cluster) | **PATCH** /clusters/{uuid}/start | Start a Cluster
*ConnectionsApi* | [**get_connection**](docs/ConnectionsApi.md#get_connection) | **GET** /connections/{id} | Close a websocket Connection
*ConnectionsApi* | [**get_connection_0**](docs/ConnectionsApi.md#get_connection_0) | **DELETE** /connections/{remoteaddr} | Close a websocket Connection
*ConnectionsApi* | [**list_connections**](docs/ConnectionsApi.md#list_connections) | **GET** /clusters/:uuid/connections | Lists Connections filtered by some parameters.
*ConnectionsApi* | [**list_connections_0**](docs/ConnectionsApi.md#list_connections_0) | **GET** /connections | Lists Connections filtered by some parameters
*ConnectionsApi* | [**list_connections_1**](docs/ConnectionsApi.md#list_connections_1) | **GET** /machines/:uuid/connections | Lists Connections filtered by some parameters.
*ConnectionsApi* | [**list_connections_2**](docs/ConnectionsApi.md#list_connections_2) | **GET** /resource_brokers/:uuid/connections | Lists Connections filtered by some parameters.
*ContentsApi* | [**create_content**](docs/ContentsApi.md#create_content) | **POST** /contents | Create content into Digital Rebar Provision
*ContentsApi* | [**delete_content**](docs/ContentsApi.md#delete_content) | **DELETE** /contents/{name} | Delete a content set.
*ContentsApi* | [**get_content**](docs/ContentsApi.md#get_content) | **GET** /contents/{name} | Get a specific content with {name}
*ContentsApi* | [**list_contents**](docs/ContentsApi.md#list_contents) | **GET** /contents | Lists possible contents on the system to serve DHCP
*ContentsApi* | [**upload_content**](docs/ContentsApi.md#upload_content) | **PUT** /contents/{name} | Replace content in Digital Rebar Provision
*ContextsApi* | [**create_context**](docs/ContextsApi.md#create_context) | **POST** /contexts | Create a Context
*ContextsApi* | [**delete_context**](docs/ContextsApi.md#delete_context) | **DELETE** /contexts/{name} | Delete a Context
*ContextsApi* | [**get_context**](docs/ContextsApi.md#get_context) | **GET** /contexts/{name} | Get a Context
*ContextsApi* | [**get_context_action**](docs/ContextsApi.md#get_context_action) | **GET** /contexts/{name}/actions/{cmd} | List specific action for a contexts Context
*ContextsApi* | [**get_context_actions**](docs/ContextsApi.md#get_context_actions) | **GET** /contexts/{name}/actions | List contexts actions Context
*ContextsApi* | [**head_context**](docs/ContextsApi.md#head_context) | **HEAD** /contexts/{name} | See if a Context exists
*ContextsApi* | [**list_contexts**](docs/ContextsApi.md#list_contexts) | **GET** /contexts | Lists Contexts filtered by some parameters.
*ContextsApi* | [**list_stats_contexts**](docs/ContextsApi.md#list_stats_contexts) | **HEAD** /contexts | Stats of the List Contexts filtered by some parameters.
*ContextsApi* | [**patch_context**](docs/ContextsApi.md#patch_context) | **PATCH** /contexts/{name} | Patch a Context
*ContextsApi* | [**post_context_action**](docs/ContextsApi.md#post_context_action) | **POST** /contexts/{name}/actions/{cmd} | Call an action on the node.
*ContextsApi* | [**put_context**](docs/ContextsApi.md#put_context) | **PUT** /contexts/{name} | Put a Context
*EndpointsApi* | [**create_endpoint**](docs/EndpointsApi.md#create_endpoint) | **POST** /endpoints | Create a Endpoint
*EndpointsApi* | [**delete_endpoint**](docs/EndpointsApi.md#delete_endpoint) | **DELETE** /endpoints/{id} | Delete a Endpoint
*EndpointsApi* | [**delete_endpoint_param**](docs/EndpointsApi.md#delete_endpoint_param) | **DELETE** /endpoints/{id}/params/{key} | Delete a single endpoints parameter
*EndpointsApi* | [**get_endpoint**](docs/EndpointsApi.md#get_endpoint) | **GET** /endpoints/{id} | Get a Endpoint
*EndpointsApi* | [**get_endpoint_action**](docs/EndpointsApi.md#get_endpoint_action) | **GET** /endpoints/{id}/actions/{cmd} | List specific action for a endpoint Endpoint
*EndpointsApi* | [**get_endpoint_actions**](docs/EndpointsApi.md#get_endpoint_actions) | **GET** /endpoints/{id}/actions | List endpoint actions Endpoint
*EndpointsApi* | [**get_endpoint_param**](docs/EndpointsApi.md#get_endpoint_param) | **GET** /endpoints/{id}/params/{key} | Get a single endpoints parameter
*EndpointsApi* | [**get_endpoint_params**](docs/EndpointsApi.md#get_endpoint_params) | **GET** /endpoints/{id}/params | List endpoints params Endpoint
*EndpointsApi* | [**get_endpoint_pub_key**](docs/EndpointsApi.md#get_endpoint_pub_key) | **GET** /endpoints/{id}/pubkey | Get the public key for secure params on a endpoints
*EndpointsApi* | [**head_endpoint**](docs/EndpointsApi.md#head_endpoint) | **HEAD** /endpoints/{id} | See if a Endpoint exists
*EndpointsApi* | [**list_endpoints**](docs/EndpointsApi.md#list_endpoints) | **GET** /endpoints | Lists Endpoints filtered by some parameters.
*EndpointsApi* | [**list_stats_endpoints**](docs/EndpointsApi.md#list_stats_endpoints) | **HEAD** /endpoints | Stats of the List Endpoints filtered by some parameters.
*EndpointsApi* | [**patch_endpoint**](docs/EndpointsApi.md#patch_endpoint) | **PATCH** /endpoints/{id} | Patch a Endpoint
*EndpointsApi* | [**patch_endpoint_params**](docs/EndpointsApi.md#patch_endpoint_params) | **PATCH** /endpoints/{id}/params | Update all params on the object (merges with existing data)
*EndpointsApi* | [**post_endpoint_action**](docs/EndpointsApi.md#post_endpoint_action) | **POST** /endpoints/{id}/actions/{cmd} | Call an action on the node.
*EndpointsApi* | [**post_endpoint_param**](docs/EndpointsApi.md#post_endpoint_param) | **POST** /endpoints/{id}/params/{key} | Set a single parameter on an object
*EndpointsApi* | [**post_endpoint_params**](docs/EndpointsApi.md#post_endpoint_params) | **POST** /endpoints/{id}/params | Replaces all parameters on the object
*EndpointsApi* | [**put_endpoint**](docs/EndpointsApi.md#put_endpoint) | **PUT** /endpoints/{id} | Put a Endpoint
*EventsApi* | [**post_event**](docs/EventsApi.md#post_event) | **POST** /events | Create an Event
*FilesApi* | [**delete_file**](docs/FilesApi.md#delete_file) | **DELETE** /files/{path} | Delete a file to a specific {path} in the tree under files.
*FilesApi* | [**get_file**](docs/FilesApi.md#get_file) | **GET** /files/{path} | Get a specific File with {path}
*FilesApi* | [**head_file**](docs/FilesApi.md#head_file) | **HEAD** /files/{path} | See if a file exists and return a checksum in the header
*FilesApi* | [**head_iso**](docs/FilesApi.md#head_iso) | **HEAD** /isos/{path} | See if a iso exists and return a checksum in the header
*FilesApi* | [**list_files**](docs/FilesApi.md#list_files) | **GET** /files | Lists files in files directory or subdirectory per query parameter
*FilesApi* | [**upload_file**](docs/FilesApi.md#upload_file) | **POST** /files/{path} | Upload a file to a specific {path} in the tree under files.
*FiltersApi* | [**create_filter**](docs/FiltersApi.md#create_filter) | **POST** /filters | Create a Filter
*FiltersApi* | [**delete_filter**](docs/FiltersApi.md#delete_filter) | **DELETE** /filters/{id} | Delete a Filter
*FiltersApi* | [**delete_filter_param**](docs/FiltersApi.md#delete_filter_param) | **DELETE** /filters/{id}/params/{key} | Delete a single filters parameter
*FiltersApi* | [**get_filter**](docs/FiltersApi.md#get_filter) | **GET** /filters/{id} | Get a Filter
*FiltersApi* | [**get_filter_action**](docs/FiltersApi.md#get_filter_action) | **GET** /filters/{id}/actions/{cmd} | List specific action for a filters Filter
*FiltersApi* | [**get_filter_actions**](docs/FiltersApi.md#get_filter_actions) | **GET** /filters/{id}/actions | List filters actions Filter
*FiltersApi* | [**get_filter_param**](docs/FiltersApi.md#get_filter_param) | **GET** /filters/{id}/params/{key} | Get a single filters parameter
*FiltersApi* | [**get_filter_params**](docs/FiltersApi.md#get_filter_params) | **GET** /filters/{id}/params | List filters params Filter
*FiltersApi* | [**get_filter_pub_key**](docs/FiltersApi.md#get_filter_pub_key) | **GET** /filters/{id}/pubkey | Get the public key for secure params on a filters
*FiltersApi* | [**head_filter**](docs/FiltersApi.md#head_filter) | **HEAD** /filters/{id} | See if a Filter exists
*FiltersApi* | [**list_filters**](docs/FiltersApi.md#list_filters) | **GET** /filters | Lists Filters filtered by some parameters.
*FiltersApi* | [**list_stats_filters**](docs/FiltersApi.md#list_stats_filters) | **HEAD** /filters | Stats of the List Filters filtered by some parameters.
*FiltersApi* | [**patch_filter**](docs/FiltersApi.md#patch_filter) | **PATCH** /filters/{id} | Patch a Filter
*FiltersApi* | [**patch_filter_params**](docs/FiltersApi.md#patch_filter_params) | **PATCH** /filters/{id}/params | Update all params on the object (merges with existing data)
*FiltersApi* | [**post_filter_action**](docs/FiltersApi.md#post_filter_action) | **POST** /filters/{id}/actions/{cmd} | Call an action on the node.
*FiltersApi* | [**post_filter_param**](docs/FiltersApi.md#post_filter_param) | **POST** /filters/{id}/params/{key} | Set a single parameter on an object
*FiltersApi* | [**post_filter_params**](docs/FiltersApi.md#post_filter_params) | **POST** /filters/{id}/params | Replaces all parameters on the object
*FiltersApi* | [**put_filter**](docs/FiltersApi.md#put_filter) | **PUT** /filters/{id} | Put a Filter
*IdentityProvidersApi* | [**create_identity_provider**](docs/IdentityProvidersApi.md#create_identity_provider) | **POST** /identity_providers | Create a IdentityProvider
*IdentityProvidersApi* | [**delete_identity_provider**](docs/IdentityProvidersApi.md#delete_identity_provider) | **DELETE** /identity_providers/{name} | Delete a IdentityProvider
*IdentityProvidersApi* | [**get_identity_provider**](docs/IdentityProvidersApi.md#get_identity_provider) | **GET** /identity_providers/{name} | Get a IdentityProvider
*IdentityProvidersApi* | [**get_identity_provider_action**](docs/IdentityProvidersApi.md#get_identity_provider_action) | **GET** /identity_providers/{name}/actions/{cmd} | List specific action for a identity_providers IdentityProvider
*IdentityProvidersApi* | [**get_identity_provider_actions**](docs/IdentityProvidersApi.md#get_identity_provider_actions) | **GET** /identity_providers/{name}/actions | List identity_providers actions IdentityProvider
*IdentityProvidersApi* | [**head_identity_provider**](docs/IdentityProvidersApi.md#head_identity_provider) | **HEAD** /identity_providers/{name} | See if a IdentityProvider exists
*IdentityProvidersApi* | [**list_identity_providers**](docs/IdentityProvidersApi.md#list_identity_providers) | **GET** /identity_providers | Lists IdentityProviders filtered by some parameters.
*IdentityProvidersApi* | [**list_stats_identity_providers**](docs/IdentityProvidersApi.md#list_stats_identity_providers) | **HEAD** /identity_providers | Stats of the List IdentityProviders filtered by some parameters.
*IdentityProvidersApi* | [**patch_identity_provider**](docs/IdentityProvidersApi.md#patch_identity_provider) | **PATCH** /identity_providers/{name} | Patch a IdentityProvider
*IdentityProvidersApi* | [**post_identity_provider_action**](docs/IdentityProvidersApi.md#post_identity_provider_action) | **POST** /identity_providers/{name}/actions/{cmd} | Call an action on the node.
*IdentityProvidersApi* | [**put_identity_provider**](docs/IdentityProvidersApi.md#put_identity_provider) | **PUT** /identity_providers/{name} | Put a IdentityProvider
*IndexesApi* | [**get_index**](docs/IndexesApi.md#get_index) | **GET** /indexes/{prefix} | Get static indexes for a specific object type
*IndexesApi* | [**get_single_index**](docs/IndexesApi.md#get_single_index) | **GET** /indexes/{prefix}/{param} | Get information on a specific index for a specific object type.
*IndexesApi* | [**list_indexes**](docs/IndexesApi.md#list_indexes) | **GET** /indexes | List all static indexes for objects
*InfoApi* | [**get_info**](docs/InfoApi.md#get_info) | **GET** /info | Return current system info.
*InterfacesApi* | [**get_interface**](docs/InterfacesApi.md#get_interface) | **GET** /interfaces/{name} | Get a specific interface with {name}
*InterfacesApi* | [**list_interfaces**](docs/InterfacesApi.md#list_interfaces) | **GET** /interfaces | Lists possible interfaces on the system to serve DHCP
*IsosApi* | [**delete_iso**](docs/IsosApi.md#delete_iso) | **DELETE** /isos/{path} | Delete an iso to a specific {path} in the tree under isos.
*IsosApi* | [**get_iso**](docs/IsosApi.md#get_iso) | **GET** /isos/{path} | Get a specific Iso with {path}
*IsosApi* | [**list_isos**](docs/IsosApi.md#list_isos) | **GET** /isos | Lists isos in isos directory
*IsosApi* | [**upload_iso**](docs/IsosApi.md#upload_iso) | **POST** /isos/{path} | Upload an iso to a specific {path} in the tree under isos.
*JobsApi* | [**create_job**](docs/JobsApi.md#create_job) | **POST** /jobs | Create a Job
*JobsApi* | [**delete_job**](docs/JobsApi.md#delete_job) | **DELETE** /jobs/{uuid} | Delete a Job
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /jobs/{uuid} | Get a Job
*JobsApi* | [**get_job_action**](docs/JobsApi.md#get_job_action) | **GET** /jobs/{uuid}/plugin_actions/{cmd} | List specific action for a job Job
*JobsApi* | [**get_job_actions**](docs/JobsApi.md#get_job_actions) | **GET** /jobs/{uuid}/actions | Get actions for this job
*JobsApi* | [**get_job_log**](docs/JobsApi.md#get_job_log) | **GET** /jobs/{uuid}/log | Get the log for this job
*JobsApi* | [**get_job_log_archive**](docs/JobsApi.md#get_job_log_archive) | **GET** /jobs/{uuid}/archive | Get the log archive entry for this job
*JobsApi* | [**get_job_plugin_actions**](docs/JobsApi.md#get_job_plugin_actions) | **GET** /jobs/{uuid}/plugin_actions | List job plugin_actions Job
*JobsApi* | [**head_job**](docs/JobsApi.md#head_job) | **HEAD** /jobs/{uuid} | See if a Job exists
*JobsApi* | [**head_job_log**](docs/JobsApi.md#head_job_log) | **HEAD** /jobs/{uuid}/log | Get the log for this job
*JobsApi* | [**list_jobs**](docs/JobsApi.md#list_jobs) | **GET** /jobs | Lists Jobs filtered by some parameters.
*JobsApi* | [**list_stats_jobs**](docs/JobsApi.md#list_stats_jobs) | **HEAD** /jobs | Stats of the List Jobs filtered by some parameters.
*JobsApi* | [**patch_job**](docs/JobsApi.md#patch_job) | **PATCH** /jobs/{uuid} | Patch a Job
*JobsApi* | [**post_job_action**](docs/JobsApi.md#post_job_action) | **POST** /jobs/{uuid}/plugin_actions/{cmd} | Call an action on the node.
*JobsApi* | [**put_job**](docs/JobsApi.md#put_job) | **PUT** /jobs/{uuid} | Put a Job
*JobsApi* | [**put_job_log**](docs/JobsApi.md#put_job_log) | **PUT** /jobs/{uuid}/log | Append the string to the end of the job&#39;s log.
*LeasesApi* | [**create_lease**](docs/LeasesApi.md#create_lease) | **POST** /leases | Create a Lease
*LeasesApi* | [**delete_lease**](docs/LeasesApi.md#delete_lease) | **DELETE** /leases/{address} | Delete a Lease
*LeasesApi* | [**get_lease**](docs/LeasesApi.md#get_lease) | **GET** /leases/{address} | Get a Lease
*LeasesApi* | [**get_lease_action**](docs/LeasesApi.md#get_lease_action) | **GET** /leases/{address}/actions/{cmd} | List specific action for a leases Lease
*LeasesApi* | [**get_lease_actions**](docs/LeasesApi.md#get_lease_actions) | **GET** /leases/{address}/actions | List leases actions Lease
*LeasesApi* | [**head_lease**](docs/LeasesApi.md#head_lease) | **HEAD** /leases/{address} | See if a Lease exists
*LeasesApi* | [**list_leases**](docs/LeasesApi.md#list_leases) | **GET** /leases | Lists Leases filtered by some parameters.
*LeasesApi* | [**list_stats_leases**](docs/LeasesApi.md#list_stats_leases) | **HEAD** /leases | Stats of the List Leases filtered by some parameters.
*LeasesApi* | [**patch_lease**](docs/LeasesApi.md#patch_lease) | **PATCH** /leases/{address} | Patch a Lease
*LeasesApi* | [**post_lease_action**](docs/LeasesApi.md#post_lease_action) | **POST** /leases/{address}/actions/{cmd} | Call an action on the node.
*LeasesApi* | [**put_lease**](docs/LeasesApi.md#put_lease) | **PUT** /leases/{address} | Put a Lease
*LogsApi* | [**get_logs**](docs/LogsApi.md#get_logs) | **GET** /logs | Return current contents of the log buffer
*MachinesApi* | [**cleanup_machine**](docs/MachinesApi.md#cleanup_machine) | **DELETE** /machines/{uuid}/cleanup | Cleanup a Machine
*MachinesApi* | [**create_machine**](docs/MachinesApi.md#create_machine) | **POST** /machines | Create a Machine
*MachinesApi* | [**delete_machine**](docs/MachinesApi.md#delete_machine) | **DELETE** /machines/{uuid} | Delete a Machine
*MachinesApi* | [**delete_machine_param**](docs/MachinesApi.md#delete_machine_param) | **DELETE** /machines/{uuid}/params/{key} | Delete a single machines parameter
*MachinesApi* | [**get_machine**](docs/MachinesApi.md#get_machine) | **GET** /machines/{uuid} | Get a Machine
*MachinesApi* | [**get_machine_action**](docs/MachinesApi.md#get_machine_action) | **GET** /machines/{uuid}/actions/{cmd} | List specific action for a machines Machine
*MachinesApi* | [**get_machine_actions**](docs/MachinesApi.md#get_machine_actions) | **GET** /machines/{uuid}/actions | List machines actions Machine
*MachinesApi* | [**get_machine_param**](docs/MachinesApi.md#get_machine_param) | **GET** /machines/{uuid}/params/{key} | Get a single machines parameter
*MachinesApi* | [**get_machine_params**](docs/MachinesApi.md#get_machine_params) | **GET** /machines/{uuid}/params | List machines params Machine
*MachinesApi* | [**get_machine_pub_key**](docs/MachinesApi.md#get_machine_pub_key) | **GET** /machines/{uuid}/pubkey | Get the public key for secure params on a machines
*MachinesApi* | [**get_machine_render**](docs/MachinesApi.md#get_machine_render) | **POST** /machines/{uuid}/render | Render a blob on a machine
*MachinesApi* | [**get_machine_token**](docs/MachinesApi.md#get_machine_token) | **GET** /machines/{uuid}/token | Get a Machine Token
*MachinesApi* | [**head_machine**](docs/MachinesApi.md#head_machine) | **HEAD** /machines/{uuid} | See if a Machine exists
*MachinesApi* | [**list_machines**](docs/MachinesApi.md#list_machines) | **GET** /machines | Lists Machines filtered by some parameters.
*MachinesApi* | [**list_stats_machines**](docs/MachinesApi.md#list_stats_machines) | **HEAD** /machines | Stats of the List Machines filtered by some parameters.
*MachinesApi* | [**patch_machine**](docs/MachinesApi.md#patch_machine) | **PATCH** /machines/{uuid} | Patch a Machine
*MachinesApi* | [**patch_machine_params**](docs/MachinesApi.md#patch_machine_params) | **PATCH** /machines/{uuid}/params | Update all params on the object (merges with existing data)
*MachinesApi* | [**pick_machine_work_order**](docs/MachinesApi.md#pick_machine_work_order) | **POST** /machines/{id}/pick/{key} | Pick a workorder for this agent.  This can return the current work order.
*MachinesApi* | [**post_machine_action**](docs/MachinesApi.md#post_machine_action) | **POST** /machines/{uuid}/actions/{cmd} | Call an action on the node.
*MachinesApi* | [**post_machine_param**](docs/MachinesApi.md#post_machine_param) | **POST** /machines/{uuid}/params/{key} | Set a single parameter on an object
*MachinesApi* | [**post_machine_params**](docs/MachinesApi.md#post_machine_params) | **POST** /machines/{uuid}/params | Replaces all parameters on the object
*MachinesApi* | [**post_machine_release_to_pool**](docs/MachinesApi.md#post_machine_release_to_pool) | **POST** /machines/{id}/releaseToPool | Releases a machine in this pool.
*MachinesApi* | [**put_machine**](docs/MachinesApi.md#put_machine) | **PUT** /machines/{uuid} | Put a Machine
*MachinesApi* | [**start_machine**](docs/MachinesApi.md#start_machine) | **PATCH** /machines/{uuid}/start | Start a Machine
*MetaApi* | [**get_meta**](docs/MetaApi.md#get_meta) | **GET** /meta/{type}/{id} | Get Metadata for an Object of {type} idendified by {id}
*MetaApi* | [**patch_meta**](docs/MetaApi.md#patch_meta) | **PATCH** /meta/{type}/{id} | Patch metadata on an Object of {type} with an ID of {id}
*ObjectsApi* | [**list_objects**](docs/ObjectsApi.md#list_objects) | **GET** /objects | Lists the object types in the system
*ParamsApi* | [**create_param**](docs/ParamsApi.md#create_param) | **POST** /params | Create a Param
*ParamsApi* | [**delete_param**](docs/ParamsApi.md#delete_param) | **DELETE** /params/{name} | Delete a Param
*ParamsApi* | [**get_param**](docs/ParamsApi.md#get_param) | **GET** /params/{name} | Get a Param
*ParamsApi* | [**head_param**](docs/ParamsApi.md#head_param) | **HEAD** /params/{name} | See if a Param exists
*ParamsApi* | [**list_params**](docs/ParamsApi.md#list_params) | **GET** /params | Lists Params filtered by some parameters.
*ParamsApi* | [**list_stats_params**](docs/ParamsApi.md#list_stats_params) | **HEAD** /params | Stats of the List Params filtered by some parameters.
*ParamsApi* | [**patch_param**](docs/ParamsApi.md#patch_param) | **PATCH** /params/{name} | Patch a Param
*ParamsApi* | [**put_param**](docs/ParamsApi.md#put_param) | **PUT** /params/{name} | Put a Param
*PluginProvidersApi* | [**delete_plugin_provider**](docs/PluginProvidersApi.md#delete_plugin_provider) | **DELETE** /plugin_providers/{name} | Delete a plugin provider
*PluginProvidersApi* | [**get_plugin_provider**](docs/PluginProvidersApi.md#get_plugin_provider) | **GET** /plugin_providers/{name} | Get a specific plugin with {name}
*PluginProvidersApi* | [**get_plugin_provider_binary**](docs/PluginProvidersApi.md#get_plugin_provider_binary) | **GET** /plugin_providers/{name}/binary | Get the binary for a specific plugin provider by {name}
*PluginProvidersApi* | [**head_plugin_provider**](docs/PluginProvidersApi.md#head_plugin_provider) | **HEAD** /plugin_providers/{name} | See if a Plugin Provider exists
*PluginProvidersApi* | [**head_plugin_providers**](docs/PluginProvidersApi.md#head_plugin_providers) | **HEAD** /plugin_providers | Stats of the list of plugin_provider on the system to create plugins
*PluginProvidersApi* | [**list_plugin_providers**](docs/PluginProvidersApi.md#list_plugin_providers) | **GET** /plugin_providers | Lists possible plugin_provider on the system to create plugins
*PluginProvidersApi* | [**upload_plugin_provider**](docs/PluginProvidersApi.md#upload_plugin_provider) | **POST** /plugin_providers/{name} | Upload a plugin provider to a specific {name}.
*PluginsApi* | [**create_plugin**](docs/PluginsApi.md#create_plugin) | **POST** /plugins | Create a Plugin
*PluginsApi* | [**delete_plugin**](docs/PluginsApi.md#delete_plugin) | **DELETE** /plugins/{name} | Delete a Plugin
*PluginsApi* | [**delete_plugin_param**](docs/PluginsApi.md#delete_plugin_param) | **DELETE** /plugins/{name}/params/{key} | Delete a single plugins parameter
*PluginsApi* | [**get_plugin**](docs/PluginsApi.md#get_plugin) | **GET** /plugins/{name} | Get a Plugin
*PluginsApi* | [**get_plugin_action**](docs/PluginsApi.md#get_plugin_action) | **GET** /plugins/{name}/actions/{cmd} | List specific action for a plugin Plugin
*PluginsApi* | [**get_plugin_actions**](docs/PluginsApi.md#get_plugin_actions) | **GET** /plugins/{name}/actions | List plugin actions Plugin
*PluginsApi* | [**get_plugin_param**](docs/PluginsApi.md#get_plugin_param) | **GET** /plugins/{name}/params/{key} | Get a single plugins parameter
*PluginsApi* | [**get_plugin_params**](docs/PluginsApi.md#get_plugin_params) | **GET** /plugins/{name}/params | List plugins params Plugin
*PluginsApi* | [**get_plugin_pub_key**](docs/PluginsApi.md#get_plugin_pub_key) | **GET** /plugins/{name}/pubkey | Get the public key for secure params on a plugins
*PluginsApi* | [**head_plugin**](docs/PluginsApi.md#head_plugin) | **HEAD** /plugins/{name} | See if a Plugin exists
*PluginsApi* | [**list_plugins**](docs/PluginsApi.md#list_plugins) | **GET** /plugins | Lists Plugins filtered by some parameters.
*PluginsApi* | [**list_stats_plugins**](docs/PluginsApi.md#list_stats_plugins) | **HEAD** /plugins | Stats of the List Plugins filtered by some parameters.
*PluginsApi* | [**patch_plugin**](docs/PluginsApi.md#patch_plugin) | **PATCH** /plugins/{name} | Patch a Plugin
*PluginsApi* | [**patch_plugin_params**](docs/PluginsApi.md#patch_plugin_params) | **PATCH** /plugins/{name}/params | Update all params on the object (merges with existing data)
*PluginsApi* | [**post_plugin_action**](docs/PluginsApi.md#post_plugin_action) | **POST** /plugins/{name}/actions/{cmd} | Call an action on the node.
*PluginsApi* | [**post_plugin_param**](docs/PluginsApi.md#post_plugin_param) | **POST** /plugins/{name}/params/{key} | Set a single parameter on an object
*PluginsApi* | [**post_plugin_params**](docs/PluginsApi.md#post_plugin_params) | **POST** /plugins/{name}/params | Replaces all parameters on the object
*PluginsApi* | [**put_plugin**](docs/PluginsApi.md#put_plugin) | **PUT** /plugins/{name} | Put a Plugin
*PoolsApi* | [**create_pool**](docs/PoolsApi.md#create_pool) | **POST** /pools | Create a Pool
*PoolsApi* | [**delete_pool**](docs/PoolsApi.md#delete_pool) | **DELETE** /pools/{id} | Delete a Pool
*PoolsApi* | [**get_pool**](docs/PoolsApi.md#get_pool) | **GET** /pools/{id} | Get a Pool
*PoolsApi* | [**get_pool_action**](docs/PoolsApi.md#get_pool_action) | **GET** /pools/{id}/actions/{cmd} | List specific action for a pools Pool
*PoolsApi* | [**get_pool_actions**](docs/PoolsApi.md#get_pool_actions) | **GET** /pools/{id}/actions | List pools actions Pool
*PoolsApi* | [**get_pool_status**](docs/PoolsApi.md#get_pool_status) | **GET** /pools/{id}/status | Returns the status of the machines in the pool
*PoolsApi* | [**head_pool**](docs/PoolsApi.md#head_pool) | **HEAD** /pools/{id} | See if a Pool exists
*PoolsApi* | [**list_active_pools**](docs/PoolsApi.md#list_active_pools) | **GET** /pools-active | Lists active Pools
*PoolsApi* | [**list_pools**](docs/PoolsApi.md#list_pools) | **GET** /pools | Lists Pools filtered by some parameters.
*PoolsApi* | [**list_stats_pools**](docs/PoolsApi.md#list_stats_pools) | **HEAD** /pools | Stats of the List Pools filtered by some parameters.
*PoolsApi* | [**patch_pool**](docs/PoolsApi.md#patch_pool) | **PATCH** /pools/{id} | Patch a Pool
*PoolsApi* | [**post_pool_action**](docs/PoolsApi.md#post_pool_action) | **POST** /pools/{id}/actions/{cmd} | Call an action on the node.
*PoolsApi* | [**post_pool_add_machines**](docs/PoolsApi.md#post_pool_add_machines) | **POST** /pools/{id}/addMachines | Add machines to this pool from default.
*PoolsApi* | [**post_pool_allocate_machines**](docs/PoolsApi.md#post_pool_allocate_machines) | **POST** /pools/{id}/allocateMachines | Allocate machines in this pool.
*PoolsApi* | [**post_pool_release_machines**](docs/PoolsApi.md#post_pool_release_machines) | **POST** /pools/{id}/releaseMachines | Release machines in this pool.
*PoolsApi* | [**post_pool_remove_machines**](docs/PoolsApi.md#post_pool_remove_machines) | **POST** /pools/{id}/removeMachines | Remove machines from this pool to default.
*PoolsApi* | [**put_pool**](docs/PoolsApi.md#put_pool) | **PUT** /pools/{id} | Put a Pool
*PrefsApi* | [**list_prefs**](docs/PrefsApi.md#list_prefs) | **GET** /prefs | Lists Prefs
*PrefsApi* | [**set_prefs**](docs/PrefsApi.md#set_prefs) | **POST** /prefs | Create a Pref
*ProfilesApi* | [**create_profile**](docs/ProfilesApi.md#create_profile) | **POST** /profiles | Create a Profile
*ProfilesApi* | [**delete_profile**](docs/ProfilesApi.md#delete_profile) | **DELETE** /profiles/{name} | Delete a Profile
*ProfilesApi* | [**delete_profile_param**](docs/ProfilesApi.md#delete_profile_param) | **DELETE** /profiles/{name}/params/{key} | Delete a single profiles parameter
*ProfilesApi* | [**get_profile**](docs/ProfilesApi.md#get_profile) | **GET** /profiles/{name} | Get a Profile
*ProfilesApi* | [**get_profile_action**](docs/ProfilesApi.md#get_profile_action) | **GET** /profiles/{name}/actions/{cmd} | List specific action for a profiles Profile
*ProfilesApi* | [**get_profile_actions**](docs/ProfilesApi.md#get_profile_actions) | **GET** /profiles/{name}/actions | List profiles actions Profile
*ProfilesApi* | [**get_profile_param**](docs/ProfilesApi.md#get_profile_param) | **GET** /profiles/{name}/params/{key} | Get a single profiles parameter
*ProfilesApi* | [**get_profile_params**](docs/ProfilesApi.md#get_profile_params) | **GET** /profiles/{name}/params | List profiles params Profile
*ProfilesApi* | [**get_profile_pub_key**](docs/ProfilesApi.md#get_profile_pub_key) | **GET** /profiles/{name}/pubkey | Get the public key for secure params on a profiles
*ProfilesApi* | [**head_profile**](docs/ProfilesApi.md#head_profile) | **HEAD** /profiles/{name} | See if a Profile exists
*ProfilesApi* | [**list_profiles**](docs/ProfilesApi.md#list_profiles) | **GET** /profiles | Lists Profiles filtered by some parameters.
*ProfilesApi* | [**list_stats_profiles**](docs/ProfilesApi.md#list_stats_profiles) | **HEAD** /profiles | Stats of the List Profiles filtered by some parameters.
*ProfilesApi* | [**patch_profile**](docs/ProfilesApi.md#patch_profile) | **PATCH** /profiles/{name} | Patch a Profile
*ProfilesApi* | [**patch_profile_params**](docs/ProfilesApi.md#patch_profile_params) | **PATCH** /profiles/{name}/params | Update all params on the object (merges with existing data)
*ProfilesApi* | [**post_profile_action**](docs/ProfilesApi.md#post_profile_action) | **POST** /profiles/{name}/actions/{cmd} | Call an action on the node.
*ProfilesApi* | [**post_profile_param**](docs/ProfilesApi.md#post_profile_param) | **POST** /profiles/{name}/params/{key} | Set a single parameter on an object
*ProfilesApi* | [**post_profile_params**](docs/ProfilesApi.md#post_profile_params) | **POST** /profiles/{name}/params | Replaces all parameters on the object
*ProfilesApi* | [**put_profile**](docs/ProfilesApi.md#put_profile) | **PUT** /profiles/{name} | Put a Profile
*ReservationsApi* | [**create_reservation**](docs/ReservationsApi.md#create_reservation) | **POST** /reservations | Create a Reservation
*ReservationsApi* | [**delete_reservation**](docs/ReservationsApi.md#delete_reservation) | **DELETE** /reservations/{address} | Delete a Reservation
*ReservationsApi* | [**delete_reservation_param**](docs/ReservationsApi.md#delete_reservation_param) | **DELETE** /reservations/{address}/params/{key} | Delete a single reservations parameter
*ReservationsApi* | [**get_reservation**](docs/ReservationsApi.md#get_reservation) | **GET** /reservations/{address} | Get a Reservation
*ReservationsApi* | [**get_reservation_action**](docs/ReservationsApi.md#get_reservation_action) | **GET** /reservations/{address}/actions/{cmd} | List specific action for a reservations Reservation
*ReservationsApi* | [**get_reservation_actions**](docs/ReservationsApi.md#get_reservation_actions) | **GET** /reservations/{address}/actions | List reservations actions Reservation
*ReservationsApi* | [**get_reservation_param**](docs/ReservationsApi.md#get_reservation_param) | **GET** /reservations/{address}/params/{key} | Get a single reservations parameter
*ReservationsApi* | [**get_reservation_params**](docs/ReservationsApi.md#get_reservation_params) | **GET** /reservations/{address}/params | List reservations params Reservation
*ReservationsApi* | [**get_reservation_pub_key**](docs/ReservationsApi.md#get_reservation_pub_key) | **GET** /reservations/{address}/pubkey | Get the public key for secure params on a reservations
*ReservationsApi* | [**head_reservation**](docs/ReservationsApi.md#head_reservation) | **HEAD** /reservations/{address} | See if a Reservation exists
*ReservationsApi* | [**list_reservations**](docs/ReservationsApi.md#list_reservations) | **GET** /reservations | Lists Reservations filtered by some parameters.
*ReservationsApi* | [**list_stats_reservations**](docs/ReservationsApi.md#list_stats_reservations) | **HEAD** /reservations | Stats of the List Reservations filtered by some parameters.
*ReservationsApi* | [**patch_reservation**](docs/ReservationsApi.md#patch_reservation) | **PATCH** /reservations/{address} | Patch a Reservation
*ReservationsApi* | [**patch_reservation_params**](docs/ReservationsApi.md#patch_reservation_params) | **PATCH** /reservations/{address}/params | Update all params on the object (merges with existing data)
*ReservationsApi* | [**post_reservation_action**](docs/ReservationsApi.md#post_reservation_action) | **POST** /reservations/{address}/actions/{cmd} | Call an action on the node.
*ReservationsApi* | [**post_reservation_param**](docs/ReservationsApi.md#post_reservation_param) | **POST** /reservations/{address}/params/{key} | Set a single parameter on an object
*ReservationsApi* | [**post_reservation_params**](docs/ReservationsApi.md#post_reservation_params) | **POST** /reservations/{address}/params | Replaces all parameters on the object
*ReservationsApi* | [**put_reservation**](docs/ReservationsApi.md#put_reservation) | **PUT** /reservations/{address} | Put a Reservation
*ResourceBrokersApi* | [**cleanup_resource_broker**](docs/ResourceBrokersApi.md#cleanup_resource_broker) | **DELETE** /resource_brokers/{uuid}/cleanup | Cleanup a ResourceBroker
*ResourceBrokersApi* | [**create_resource_broker**](docs/ResourceBrokersApi.md#create_resource_broker) | **POST** /resource_brokers | Create a ResourceBroker
*ResourceBrokersApi* | [**delete_resource_broker**](docs/ResourceBrokersApi.md#delete_resource_broker) | **DELETE** /resource_brokers/{uuid} | Delete a ResourceBroker
*ResourceBrokersApi* | [**delete_resource_broker_group_param**](docs/ResourceBrokersApi.md#delete_resource_broker_group_param) | **DELETE** /resource_brokers/{uuid}/group/params/{key} | Delete a single ResourceBroker group profile parameter
*ResourceBrokersApi* | [**delete_resource_broker_param**](docs/ResourceBrokersApi.md#delete_resource_broker_param) | **DELETE** /resource_brokers/{uuid}/params/{key} | Delete a single resource_brokers parameter
*ResourceBrokersApi* | [**get_resource_broker**](docs/ResourceBrokersApi.md#get_resource_broker) | **GET** /resource_brokers/{uuid} | Get a ResourceBroker
*ResourceBrokersApi* | [**get_resource_broker_action**](docs/ResourceBrokersApi.md#get_resource_broker_action) | **GET** /resource_brokers/{uuid}/actions/{cmd} | List specific action for a resource_brokers ResourceBroker
*ResourceBrokersApi* | [**get_resource_broker_actions**](docs/ResourceBrokersApi.md#get_resource_broker_actions) | **GET** /resource_brokers/{uuid}/actions | List resource_brokers actions ResourceBroker
*ResourceBrokersApi* | [**get_resource_broker_group_param**](docs/ResourceBrokersApi.md#get_resource_broker_group_param) | **GET** /resource_brokers/{uuid}/group/params/{key} | Get a single ResourceBroker group profile parameter
*ResourceBrokersApi* | [**get_resource_broker_group_params**](docs/ResourceBrokersApi.md#get_resource_broker_group_params) | **GET** /resource_brokers/{uuid}/group/params | List ResourceBroker group profile params ResourceBroker
*ResourceBrokersApi* | [**get_resource_broker_group_pub_key**](docs/ResourceBrokersApi.md#get_resource_broker_group_pub_key) | **GET** /resource_brokers/{uuid}/group/pubkey | Get the public key for secure params on a ResourceBroker group profile
*ResourceBrokersApi* | [**get_resource_broker_param**](docs/ResourceBrokersApi.md#get_resource_broker_param) | **GET** /resource_brokers/{uuid}/params/{key} | Get a single resource_brokers parameter
*ResourceBrokersApi* | [**get_resource_broker_params**](docs/ResourceBrokersApi.md#get_resource_broker_params) | **GET** /resource_brokers/{uuid}/params | List resource_brokers params ResourceBroker
*ResourceBrokersApi* | [**get_resource_broker_pub_key**](docs/ResourceBrokersApi.md#get_resource_broker_pub_key) | **GET** /resource_brokers/{uuid}/pubkey | Get the public key for secure params on a resource_brokers
*ResourceBrokersApi* | [**get_resource_broker_render**](docs/ResourceBrokersApi.md#get_resource_broker_render) | **POST** /resource_brokers/{uuid}/render | Render a blob on a resource_brokers
*ResourceBrokersApi* | [**get_resource_broker_token**](docs/ResourceBrokersApi.md#get_resource_broker_token) | **GET** /resource_brokers/{uuid}/token | Get a ResourceBroker Token
*ResourceBrokersApi* | [**head_resource_broker**](docs/ResourceBrokersApi.md#head_resource_broker) | **HEAD** /resource_brokers/{uuid} | See if a ResourceBroker exists
*ResourceBrokersApi* | [**list_resource_brokers**](docs/ResourceBrokersApi.md#list_resource_brokers) | **GET** /resource_brokers | Lists ResourceBrokers filtered by some parameters.
*ResourceBrokersApi* | [**list_stats_resource_brokers**](docs/ResourceBrokersApi.md#list_stats_resource_brokers) | **HEAD** /resource_brokers | Stats of the List ResourceBrokers filtered by some parameters.
*ResourceBrokersApi* | [**patch_resource_broker**](docs/ResourceBrokersApi.md#patch_resource_broker) | **PATCH** /resource_brokers/{uuid} | Patch a ResourceBroker
*ResourceBrokersApi* | [**patch_resource_broker_group_params**](docs/ResourceBrokersApi.md#patch_resource_broker_group_params) | **PATCH** /resource_brokers/{uuid}/group/params | Update group profile parameters (merges with existing data)
*ResourceBrokersApi* | [**patch_resource_broker_params**](docs/ResourceBrokersApi.md#patch_resource_broker_params) | **PATCH** /resource_brokers/{uuid}/params | Update all params on the object (merges with existing data)
*ResourceBrokersApi* | [**post_resource_broker_action**](docs/ResourceBrokersApi.md#post_resource_broker_action) | **POST** /resource_brokers/{uuid}/actions/{cmd} | Call an action on the node.
*ResourceBrokersApi* | [**post_resource_broker_group_param**](docs/ResourceBrokersApi.md#post_resource_broker_group_param) | **POST** /resource_brokers/{uuid}/group/params/{key} | Set a single Parameter in the group
*ResourceBrokersApi* | [**post_resource_broker_group_params**](docs/ResourceBrokersApi.md#post_resource_broker_group_params) | **POST** /resource_brokers/{uuid}/group/params | Sets the group parameters (replaces)
*ResourceBrokersApi* | [**post_resource_broker_param**](docs/ResourceBrokersApi.md#post_resource_broker_param) | **POST** /resource_brokers/{uuid}/params/{key} | Set a single parameter on an object
*ResourceBrokersApi* | [**post_resource_broker_params**](docs/ResourceBrokersApi.md#post_resource_broker_params) | **POST** /resource_brokers/{uuid}/params | Replaces all parameters on the object
*ResourceBrokersApi* | [**post_resource_broker_release_to_pool**](docs/ResourceBrokersApi.md#post_resource_broker_release_to_pool) | **POST** /resource_brokers/{uuid}/releaseToPool | Releases a resource_broker in this pool.
*ResourceBrokersApi* | [**put_resource_broker**](docs/ResourceBrokersApi.md#put_resource_broker) | **PUT** /resource_brokers/{uuid} | Put a ResourceBroker
*ResourceBrokersApi* | [**start_resource_broker**](docs/ResourceBrokersApi.md#start_resource_broker) | **PATCH** /resource_brokers/{uuid}/start | Start a ResourceBroker
*RolesApi* | [**create_role**](docs/RolesApi.md#create_role) | **POST** /roles | Create a Role
*RolesApi* | [**delete_role**](docs/RolesApi.md#delete_role) | **DELETE** /roles/{name} | Delete a Role
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /roles/{name} | Get a Role
*RolesApi* | [**get_role_action**](docs/RolesApi.md#get_role_action) | **GET** /roles/{name}/actions/{cmd} | List specific action for a roles Role
*RolesApi* | [**get_role_actions**](docs/RolesApi.md#get_role_actions) | **GET** /roles/{name}/actions | List roles actions Role
*RolesApi* | [**head_role**](docs/RolesApi.md#head_role) | **HEAD** /roles/{name} | See if a Role exists
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /roles | Lists Roles filtered by some parameters.
*RolesApi* | [**list_stats_roles**](docs/RolesApi.md#list_stats_roles) | **HEAD** /roles | Stats of the List Roles filtered by some parameters.
*RolesApi* | [**patch_role**](docs/RolesApi.md#patch_role) | **PATCH** /roles/{name} | Patch a Role
*RolesApi* | [**post_role_action**](docs/RolesApi.md#post_role_action) | **POST** /roles/{name}/actions/{cmd} | Call an action on the node.
*RolesApi* | [**put_role**](docs/RolesApi.md#put_role) | **PUT** /roles/{name} | Put a Role
*StagesApi* | [**create_stage**](docs/StagesApi.md#create_stage) | **POST** /stages | Create a Stage
*StagesApi* | [**delete_stage**](docs/StagesApi.md#delete_stage) | **DELETE** /stages/{name} | Delete a Stage
*StagesApi* | [**delete_stage_param**](docs/StagesApi.md#delete_stage_param) | **DELETE** /stages/{name}/params/{key} | Delete a single stages parameter
*StagesApi* | [**get_stage**](docs/StagesApi.md#get_stage) | **GET** /stages/{name} | Get a Stage
*StagesApi* | [**get_stage_action**](docs/StagesApi.md#get_stage_action) | **GET** /stages/{name}/actions/{cmd} | List specific action for a stages Stage
*StagesApi* | [**get_stage_actions**](docs/StagesApi.md#get_stage_actions) | **GET** /stages/{name}/actions | List stages actions Stage
*StagesApi* | [**get_stage_param**](docs/StagesApi.md#get_stage_param) | **GET** /stages/{name}/params/{key} | Get a single stages parameter
*StagesApi* | [**get_stage_params**](docs/StagesApi.md#get_stage_params) | **GET** /stages/{name}/params | List stages params Stage
*StagesApi* | [**get_stage_pub_key**](docs/StagesApi.md#get_stage_pub_key) | **GET** /stages/{name}/pubkey | Get the public key for secure params on a stages
*StagesApi* | [**head_stage**](docs/StagesApi.md#head_stage) | **HEAD** /stages/{name} | See if a Stage exists
*StagesApi* | [**list_stages**](docs/StagesApi.md#list_stages) | **GET** /stages | Lists Stages filtered by some parameters.
*StagesApi* | [**list_stats_stages**](docs/StagesApi.md#list_stats_stages) | **HEAD** /stages | Stats of the List Stages filtered by some parameters.
*StagesApi* | [**patch_stage**](docs/StagesApi.md#patch_stage) | **PATCH** /stages/{name} | Patch a Stage
*StagesApi* | [**patch_stage_params**](docs/StagesApi.md#patch_stage_params) | **PATCH** /stages/{name}/params | Update all params on the object (merges with existing data)
*StagesApi* | [**post_stage_action**](docs/StagesApi.md#post_stage_action) | **POST** /stages/{name}/actions/{cmd} | Call an action on the node.
*StagesApi* | [**post_stage_param**](docs/StagesApi.md#post_stage_param) | **POST** /stages/{name}/params/{key} | Set a single parameter on an object
*StagesApi* | [**post_stage_params**](docs/StagesApi.md#post_stage_params) | **POST** /stages/{name}/params | Replaces all parameters on the object
*StagesApi* | [**put_stage**](docs/StagesApi.md#put_stage) | **PUT** /stages/{name} | Put a Stage
*SubnetsApi* | [**allocate_subnet**](docs/SubnetsApi.md#allocate_subnet) | **POST** /subnets/{name}/allocate | Allocate or reserve an address in the subnet
*SubnetsApi* | [**create_subnet**](docs/SubnetsApi.md#create_subnet) | **POST** /subnets | Create a Subnet
*SubnetsApi* | [**del_subnet_release**](docs/SubnetsApi.md#del_subnet_release) | **DELETE** /subnets/{name}/release/{ip} | Release IP address from the Subnet name
*SubnetsApi* | [**delete_subnet**](docs/SubnetsApi.md#delete_subnet) | **DELETE** /subnets/{name} | Delete a Subnet
*SubnetsApi* | [**delete_subnet_param**](docs/SubnetsApi.md#delete_subnet_param) | **DELETE** /subnets/{name}/params/{key} | Delete a single subnets parameter
*SubnetsApi* | [**get_subnet**](docs/SubnetsApi.md#get_subnet) | **GET** /subnets/{name} | Get a Subnet
*SubnetsApi* | [**get_subnet_action**](docs/SubnetsApi.md#get_subnet_action) | **GET** /subnets/{name}/actions/{cmd} | List specific action for a subnets Subnet
*SubnetsApi* | [**get_subnet_actions**](docs/SubnetsApi.md#get_subnet_actions) | **GET** /subnets/{name}/actions | List subnets actions Subnet
*SubnetsApi* | [**get_subnet_param**](docs/SubnetsApi.md#get_subnet_param) | **GET** /subnets/{name}/params/{key} | Get a single subnets parameter
*SubnetsApi* | [**get_subnet_params**](docs/SubnetsApi.md#get_subnet_params) | **GET** /subnets/{name}/params | List subnets params Subnet
*SubnetsApi* | [**get_subnet_pub_key**](docs/SubnetsApi.md#get_subnet_pub_key) | **GET** /subnets/{name}/pubkey | Get the public key for secure params on a subnets
*SubnetsApi* | [**head_subnet**](docs/SubnetsApi.md#head_subnet) | **HEAD** /subnets/{name} | See if a Subnet exists
*SubnetsApi* | [**list_stats_subnets**](docs/SubnetsApi.md#list_stats_subnets) | **HEAD** /subnets | Stats of the List Subnets filtered by some parameters.
*SubnetsApi* | [**list_subnets**](docs/SubnetsApi.md#list_subnets) | **GET** /subnets | Lists Subnets filtered by some parameters.
*SubnetsApi* | [**patch_subnet**](docs/SubnetsApi.md#patch_subnet) | **PATCH** /subnets/{name} | Patch a Subnet
*SubnetsApi* | [**patch_subnet_params**](docs/SubnetsApi.md#patch_subnet_params) | **PATCH** /subnets/{name}/params | Update all params on the object (merges with existing data)
*SubnetsApi* | [**post_subnet_action**](docs/SubnetsApi.md#post_subnet_action) | **POST** /subnets/{name}/actions/{cmd} | Call an action on the node.
*SubnetsApi* | [**post_subnet_param**](docs/SubnetsApi.md#post_subnet_param) | **POST** /subnets/{name}/params/{key} | Set a single parameter on an object
*SubnetsApi* | [**post_subnet_params**](docs/SubnetsApi.md#post_subnet_params) | **POST** /subnets/{name}/params | Replaces all parameters on the object
*SubnetsApi* | [**put_subnet**](docs/SubnetsApi.md#put_subnet) | **PUT** /subnets/{name} | Put a Subnet
*SystemApi* | [**get_system_action**](docs/SystemApi.md#get_system_action) | **GET** /system/actions/{cmd} | List specific action for System
*SystemApi* | [**get_system_actions**](docs/SystemApi.md#get_system_actions) | **GET** /system/actions | List system actions System
*SystemApi* | [**post_system_action**](docs/SystemApi.md#post_system_action) | **POST** /system/actions/{cmd} | Call an action on the system.
*SystemApi* | [**system_update**](docs/SystemApi.md#system_update) | **POST** /system/upgrade | Upload a file to upgrade the DRP system
*SystemApi* | [**system_update_exec**](docs/SystemApi.md#system_update_exec) | **POST** /system/upgrade/exec | Execute a previously staged upgrade
*SystemApi* | [**system_update_run**](docs/SystemApi.md#system_update_run) | **POST** /system/upgrade/run | Perform a rolling upgrade of a dr-provision cluster.
*SystemApi* | [**system_update_stage**](docs/SystemApi.md#system_update_stage) | **POST** /system/upgrade/stage | Upload a file to perform a staged upgrade of a dr-provision cluster
*SystemApi* | [**system_update_unstage**](docs/SystemApi.md#system_update_unstage) | **DELETE** /system/upgrade/stage | Unstage a pending staged update.  This will fail if an update us running.
*TasksApi* | [**create_task**](docs/TasksApi.md#create_task) | **POST** /tasks | Create a Task
*TasksApi* | [**delete_task**](docs/TasksApi.md#delete_task) | **DELETE** /tasks/{name} | Delete a Task
*TasksApi* | [**get_task**](docs/TasksApi.md#get_task) | **GET** /tasks/{name} | Get a Task
*TasksApi* | [**get_task_action**](docs/TasksApi.md#get_task_action) | **GET** /tasks/{name}/actions/{cmd} | List specific action for a tasks Task
*TasksApi* | [**get_task_actions**](docs/TasksApi.md#get_task_actions) | **GET** /tasks/{name}/actions | List tasks actions Task
*TasksApi* | [**head_task**](docs/TasksApi.md#head_task) | **HEAD** /tasks/{name} | See if a Task exists
*TasksApi* | [**list_stats_tasks**](docs/TasksApi.md#list_stats_tasks) | **HEAD** /tasks | Stats of the List Tasks filtered by some parameters.
*TasksApi* | [**list_tasks**](docs/TasksApi.md#list_tasks) | **GET** /tasks | Lists Tasks filtered by some parameters.
*TasksApi* | [**patch_task**](docs/TasksApi.md#patch_task) | **PATCH** /tasks/{name} | Patch a Task
*TasksApi* | [**post_task_action**](docs/TasksApi.md#post_task_action) | **POST** /tasks/{name}/actions/{cmd} | Call an action on the node.
*TasksApi* | [**put_task**](docs/TasksApi.md#put_task) | **PUT** /tasks/{name} | Put a Task
*TemplatesApi* | [**create_template**](docs/TemplatesApi.md#create_template) | **POST** /templates | Create a Template
*TemplatesApi* | [**delete_template**](docs/TemplatesApi.md#delete_template) | **DELETE** /templates/{id} | Delete a Template
*TemplatesApi* | [**get_template**](docs/TemplatesApi.md#get_template) | **GET** /templates/{id} | Get a Template
*TemplatesApi* | [**get_template_action**](docs/TemplatesApi.md#get_template_action) | **GET** /templates/{id}/actions/{cmd} | List specific action for a templates Template
*TemplatesApi* | [**get_template_actions**](docs/TemplatesApi.md#get_template_actions) | **GET** /templates/{id}/actions | List templates actions Template
*TemplatesApi* | [**get_template_render**](docs/TemplatesApi.md#get_template_render) | **GET** /templates/{id}/render/{uuid} | 
*TemplatesApi* | [**head_template**](docs/TemplatesApi.md#head_template) | **HEAD** /templates/{id} | See if a Template exists
*TemplatesApi* | [**list_stats_templates**](docs/TemplatesApi.md#list_stats_templates) | **HEAD** /templates | Stats of the List Templates filtered by some parameters.
*TemplatesApi* | [**list_templates**](docs/TemplatesApi.md#list_templates) | **GET** /templates | Lists Templates filtered by some parameters.
*TemplatesApi* | [**patch_template**](docs/TemplatesApi.md#patch_template) | **PATCH** /templates/{id} | Patch a Template
*TemplatesApi* | [**post_template_action**](docs/TemplatesApi.md#post_template_action) | **POST** /templates/{id}/actions/{cmd} | Call an action on the node.
*TemplatesApi* | [**put_template**](docs/TemplatesApi.md#put_template) | **PUT** /templates/{id} | Put a Template
*TenantsApi* | [**create_tenant**](docs/TenantsApi.md#create_tenant) | **POST** /tenants | Create a Tenant
*TenantsApi* | [**delete_tenant**](docs/TenantsApi.md#delete_tenant) | **DELETE** /tenants/{name} | Delete a Tenant
*TenantsApi* | [**get_tenant**](docs/TenantsApi.md#get_tenant) | **GET** /tenants/{name} | Get a Tenant
*TenantsApi* | [**get_tenant_action**](docs/TenantsApi.md#get_tenant_action) | **GET** /tenants/{name}/actions/{cmd} | List specific action for a tenants Tenant
*TenantsApi* | [**get_tenant_actions**](docs/TenantsApi.md#get_tenant_actions) | **GET** /tenants/{name}/actions | List tenants actions Tenant
*TenantsApi* | [**head_tenant**](docs/TenantsApi.md#head_tenant) | **HEAD** /tenants/{name} | See if a Tenant exists
*TenantsApi* | [**list_stats_tenants**](docs/TenantsApi.md#list_stats_tenants) | **HEAD** /tenants | Stats of the List Tenants filtered by some parameters.
*TenantsApi* | [**list_tenants**](docs/TenantsApi.md#list_tenants) | **GET** /tenants | Lists Tenants filtered by some parameters.
*TenantsApi* | [**patch_tenant**](docs/TenantsApi.md#patch_tenant) | **PATCH** /tenants/{name} | Patch a Tenant
*TenantsApi* | [**post_tenant_action**](docs/TenantsApi.md#post_tenant_action) | **POST** /tenants/{name}/actions/{cmd} | Call an action on the node.
*TenantsApi* | [**put_tenant**](docs/TenantsApi.md#put_tenant) | **PUT** /tenants/{name} | Put a Tenant
*TriggerProvidersApi* | [**create_trigger_provider**](docs/TriggerProvidersApi.md#create_trigger_provider) | **POST** /trigger_providers | Create a TriggerProvider
*TriggerProvidersApi* | [**delete_trigger_provider**](docs/TriggerProvidersApi.md#delete_trigger_provider) | **DELETE** /trigger_providers/{name} | Delete a TriggerProvider
*TriggerProvidersApi* | [**delete_trigger_provider_param**](docs/TriggerProvidersApi.md#delete_trigger_provider_param) | **DELETE** /trigger_providers/{name}/params/{key} | Delete a single trigger_providers parameter
*TriggerProvidersApi* | [**get_trigger_provider**](docs/TriggerProvidersApi.md#get_trigger_provider) | **GET** /trigger_providers/{name} | Get a TriggerProvider
*TriggerProvidersApi* | [**get_trigger_provider_action**](docs/TriggerProvidersApi.md#get_trigger_provider_action) | **GET** /trigger_providers/{name}/actions/{cmd} | List specific action for a trigger_providers TriggerProvider
*TriggerProvidersApi* | [**get_trigger_provider_actions**](docs/TriggerProvidersApi.md#get_trigger_provider_actions) | **GET** /trigger_providers/{name}/actions | List trigger_providers actions TriggerProvider
*TriggerProvidersApi* | [**get_trigger_provider_param**](docs/TriggerProvidersApi.md#get_trigger_provider_param) | **GET** /trigger_providers/{name}/params/{key} | Get a single trigger_providers parameter
*TriggerProvidersApi* | [**get_trigger_provider_params**](docs/TriggerProvidersApi.md#get_trigger_provider_params) | **GET** /trigger_providers/{name}/params | List trigger_providers params TriggerProvider
*TriggerProvidersApi* | [**get_trigger_provider_pub_key**](docs/TriggerProvidersApi.md#get_trigger_provider_pub_key) | **GET** /trigger_providers/{name}/pubkey | Get the public key for secure params on a trigger_providers
*TriggerProvidersApi* | [**head_trigger_provider**](docs/TriggerProvidersApi.md#head_trigger_provider) | **HEAD** /trigger_providers/{name} | See if a TriggerProvider exists
*TriggerProvidersApi* | [**list_stats_trigger_providers**](docs/TriggerProvidersApi.md#list_stats_trigger_providers) | **HEAD** /trigger_providers | Stats of the List TriggerProviders filtered by some parameters.
*TriggerProvidersApi* | [**list_trigger_providers**](docs/TriggerProvidersApi.md#list_trigger_providers) | **GET** /trigger_providers | Lists TriggerProviders filtered by some parameters.
*TriggerProvidersApi* | [**patch_trigger_provider**](docs/TriggerProvidersApi.md#patch_trigger_provider) | **PATCH** /trigger_providers/{name} | Patch a TriggerProvider
*TriggerProvidersApi* | [**patch_trigger_provider_params**](docs/TriggerProvidersApi.md#patch_trigger_provider_params) | **PATCH** /trigger_providers/{name}/params | Update all params on the object (merges with existing data)
*TriggerProvidersApi* | [**post_trigger_provider_action**](docs/TriggerProvidersApi.md#post_trigger_provider_action) | **POST** /trigger_providers/{name}/actions/{cmd} | Call an action on the node.
*TriggerProvidersApi* | [**post_trigger_provider_param**](docs/TriggerProvidersApi.md#post_trigger_provider_param) | **POST** /trigger_providers/{name}/params/{key} | Set a single parameter on an object
*TriggerProvidersApi* | [**post_trigger_provider_params**](docs/TriggerProvidersApi.md#post_trigger_provider_params) | **POST** /trigger_providers/{name}/params | Replaces all parameters on the object
*TriggerProvidersApi* | [**put_trigger_provider**](docs/TriggerProvidersApi.md#put_trigger_provider) | **PUT** /trigger_providers/{name} | Put a TriggerProvider
*TriggersApi* | [**create_trigger**](docs/TriggersApi.md#create_trigger) | **POST** /triggers | Create a Trigger
*TriggersApi* | [**delete_trigger**](docs/TriggersApi.md#delete_trigger) | **DELETE** /triggers/{name} | Delete a Trigger
*TriggersApi* | [**delete_trigger_param**](docs/TriggersApi.md#delete_trigger_param) | **DELETE** /triggers/{name}/params/{key} | Delete a single triggers parameter
*TriggersApi* | [**get_trigger**](docs/TriggersApi.md#get_trigger) | **GET** /triggers/{name} | Get a Trigger
*TriggersApi* | [**get_trigger_action**](docs/TriggersApi.md#get_trigger_action) | **GET** /triggers/{name}/actions/{cmd} | List specific action for a triggers Trigger
*TriggersApi* | [**get_trigger_actions**](docs/TriggersApi.md#get_trigger_actions) | **GET** /triggers/{name}/actions | List triggers actions Trigger
*TriggersApi* | [**get_trigger_param**](docs/TriggersApi.md#get_trigger_param) | **GET** /triggers/{name}/params/{key} | Get a single triggers parameter
*TriggersApi* | [**get_trigger_params**](docs/TriggersApi.md#get_trigger_params) | **GET** /triggers/{name}/params | List triggers params Trigger
*TriggersApi* | [**get_trigger_pub_key**](docs/TriggersApi.md#get_trigger_pub_key) | **GET** /triggers/{name}/pubkey | Get the public key for secure params on a triggers
*TriggersApi* | [**head_trigger**](docs/TriggersApi.md#head_trigger) | **HEAD** /triggers/{name} | See if a Trigger exists
*TriggersApi* | [**list_stats_triggers**](docs/TriggersApi.md#list_stats_triggers) | **HEAD** /triggers | Stats of the List Triggers filtered by some parameters.
*TriggersApi* | [**list_triggers**](docs/TriggersApi.md#list_triggers) | **GET** /triggers | Lists Triggers filtered by some parameters.
*TriggersApi* | [**patch_trigger**](docs/TriggersApi.md#patch_trigger) | **PATCH** /triggers/{name} | Patch a Trigger
*TriggersApi* | [**patch_trigger_params**](docs/TriggersApi.md#patch_trigger_params) | **PATCH** /triggers/{name}/params | Update all params on the object (merges with existing data)
*TriggersApi* | [**post_trigger_action**](docs/TriggersApi.md#post_trigger_action) | **POST** /triggers/{name}/actions/{cmd} | Call an action on the node.
*TriggersApi* | [**post_trigger_param**](docs/TriggersApi.md#post_trigger_param) | **POST** /triggers/{name}/params/{key} | Set a single parameter on an object
*TriggersApi* | [**post_trigger_params**](docs/TriggersApi.md#post_trigger_params) | **POST** /triggers/{name}/params | Replaces all parameters on the object
*TriggersApi* | [**put_trigger**](docs/TriggersApi.md#put_trigger) | **PUT** /triggers/{name} | Put a Trigger
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /users | Create a User
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{name} | Delete a User
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /users/{name} | Get a User
*UsersApi* | [**get_user_action**](docs/UsersApi.md#get_user_action) | **GET** /users/{name}/actions/{cmd} | List specific action for a users User
*UsersApi* | [**get_user_actions**](docs/UsersApi.md#get_user_actions) | **GET** /users/{name}/actions | List users actions User
*UsersApi* | [**get_user_token**](docs/UsersApi.md#get_user_token) | **GET** /users/{name}/token | Get a User Token
*UsersApi* | [**head_user**](docs/UsersApi.md#head_user) | **HEAD** /users/{name} | See if a User exists
*UsersApi* | [**list_stats_users**](docs/UsersApi.md#list_stats_users) | **HEAD** /users | Stats of the List Users filtered by some parameters.
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /users | Lists Users filtered by some parameters.
*UsersApi* | [**patch_user**](docs/UsersApi.md#patch_user) | **PATCH** /users/{name} | Patch a User
*UsersApi* | [**post_user_action**](docs/UsersApi.md#post_user_action) | **POST** /users/{name}/actions/{cmd} | Call an action on the node.
*UsersApi* | [**put_user**](docs/UsersApi.md#put_user) | **PUT** /users/{name} | Put a User
*UsersApi* | [**put_user_password**](docs/UsersApi.md#put_user_password) | **PUT** /users/{name}/password | Set the password for a user.
*UxOptionsApi* | [**create_ux_option**](docs/UxOptionsApi.md#create_ux_option) | **POST** /ux_options | Create a UxOption
*UxOptionsApi* | [**delete_ux_option**](docs/UxOptionsApi.md#delete_ux_option) | **DELETE** /ux_options/{id} | Delete a UxOption
*UxOptionsApi* | [**delete_ux_option_param**](docs/UxOptionsApi.md#delete_ux_option_param) | **DELETE** /ux_options/{id}/params/{key} | Delete a single ux_options parameter
*UxOptionsApi* | [**get_ux_option**](docs/UxOptionsApi.md#get_ux_option) | **GET** /ux_options/{id} | Get a UxOption
*UxOptionsApi* | [**get_ux_option_action**](docs/UxOptionsApi.md#get_ux_option_action) | **GET** /ux_options/{id}/actions/{cmd} | List specific action for a ux_options UxOption
*UxOptionsApi* | [**get_ux_option_actions**](docs/UxOptionsApi.md#get_ux_option_actions) | **GET** /ux_options/{id}/actions | List ux_options actions UxOption
*UxOptionsApi* | [**get_ux_option_param**](docs/UxOptionsApi.md#get_ux_option_param) | **GET** /ux_options/{id}/params/{key} | Get a single ux_options parameter
*UxOptionsApi* | [**get_ux_option_params**](docs/UxOptionsApi.md#get_ux_option_params) | **GET** /ux_options/{id}/params | List ux_options params UxOption
*UxOptionsApi* | [**get_ux_option_pub_key**](docs/UxOptionsApi.md#get_ux_option_pub_key) | **GET** /ux_options/{id}/pubkey | Get the public key for secure params on a ux_options
*UxOptionsApi* | [**head_ux_option**](docs/UxOptionsApi.md#head_ux_option) | **HEAD** /ux_options/{id} | See if a UxOption exists
*UxOptionsApi* | [**list_stats_ux_options**](docs/UxOptionsApi.md#list_stats_ux_options) | **HEAD** /ux_options | Stats of the List UxOptions filtered by some parameters.
*UxOptionsApi* | [**list_ux_options**](docs/UxOptionsApi.md#list_ux_options) | **GET** /ux_options | Lists UxOptions filtered by some parameters.
*UxOptionsApi* | [**patch_ux_option**](docs/UxOptionsApi.md#patch_ux_option) | **PATCH** /ux_options/{id} | Patch a UxOption
*UxOptionsApi* | [**patch_ux_option_params**](docs/UxOptionsApi.md#patch_ux_option_params) | **PATCH** /ux_options/{id}/params | Update all params on the object (merges with existing data)
*UxOptionsApi* | [**post_ux_option_action**](docs/UxOptionsApi.md#post_ux_option_action) | **POST** /ux_options/{id}/actions/{cmd} | Call an action on the node.
*UxOptionsApi* | [**post_ux_option_param**](docs/UxOptionsApi.md#post_ux_option_param) | **POST** /ux_options/{id}/params/{key} | Set a single parameter on an object
*UxOptionsApi* | [**post_ux_option_params**](docs/UxOptionsApi.md#post_ux_option_params) | **POST** /ux_options/{id}/params | Replaces all parameters on the object
*UxOptionsApi* | [**put_ux_option**](docs/UxOptionsApi.md#put_ux_option) | **PUT** /ux_options/{id} | Put a UxOption
*UxSettingsApi* | [**create_ux_setting**](docs/UxSettingsApi.md#create_ux_setting) | **POST** /ux_settings | Create a UxSetting
*UxSettingsApi* | [**delete_ux_setting**](docs/UxSettingsApi.md#delete_ux_setting) | **DELETE** /ux_settings/{id} | Delete a UxSetting
*UxSettingsApi* | [**delete_ux_setting_param**](docs/UxSettingsApi.md#delete_ux_setting_param) | **DELETE** /ux_settings/{id}/params/{key} | Delete a single ux_settings parameter
*UxSettingsApi* | [**get_ux_setting**](docs/UxSettingsApi.md#get_ux_setting) | **GET** /ux_settings/{id} | Get a UxSetting
*UxSettingsApi* | [**get_ux_setting_action**](docs/UxSettingsApi.md#get_ux_setting_action) | **GET** /ux_settings/{id}/actions/{cmd} | List specific action for a ux_settings UxSetting
*UxSettingsApi* | [**get_ux_setting_actions**](docs/UxSettingsApi.md#get_ux_setting_actions) | **GET** /ux_settings/{id}/actions | List ux_settings actions UxSetting
*UxSettingsApi* | [**get_ux_setting_param**](docs/UxSettingsApi.md#get_ux_setting_param) | **GET** /ux_settings/{id}/params/{key} | Get a single ux_settings parameter
*UxSettingsApi* | [**get_ux_setting_params**](docs/UxSettingsApi.md#get_ux_setting_params) | **GET** /ux_settings/{id}/params | List ux_settings params UxSetting
*UxSettingsApi* | [**get_ux_setting_pub_key**](docs/UxSettingsApi.md#get_ux_setting_pub_key) | **GET** /ux_settings/{id}/pubkey | Get the public key for secure params on a ux_settings
*UxSettingsApi* | [**head_ux_setting**](docs/UxSettingsApi.md#head_ux_setting) | **HEAD** /ux_settings/{id} | See if a UxSetting exists
*UxSettingsApi* | [**list_stats_ux_settings**](docs/UxSettingsApi.md#list_stats_ux_settings) | **HEAD** /ux_settings | Stats of the List UxSettings filtered by some parameters.
*UxSettingsApi* | [**list_ux_settings**](docs/UxSettingsApi.md#list_ux_settings) | **GET** /ux_settings | Lists UxSettings filtered by some parameters.
*UxSettingsApi* | [**patch_ux_setting**](docs/UxSettingsApi.md#patch_ux_setting) | **PATCH** /ux_settings/{id} | Patch a UxSetting
*UxSettingsApi* | [**patch_ux_setting_params**](docs/UxSettingsApi.md#patch_ux_setting_params) | **PATCH** /ux_settings/{id}/params | Update all params on the object (merges with existing data)
*UxSettingsApi* | [**post_ux_setting_action**](docs/UxSettingsApi.md#post_ux_setting_action) | **POST** /ux_settings/{id}/actions/{cmd} | Call an action on the node.
*UxSettingsApi* | [**post_ux_setting_param**](docs/UxSettingsApi.md#post_ux_setting_param) | **POST** /ux_settings/{id}/params/{key} | Set a single parameter on an object
*UxSettingsApi* | [**post_ux_setting_params**](docs/UxSettingsApi.md#post_ux_setting_params) | **POST** /ux_settings/{id}/params | Replaces all parameters on the object
*UxSettingsApi* | [**put_ux_setting**](docs/UxSettingsApi.md#put_ux_setting) | **PUT** /ux_settings/{id} | Put a UxSetting
*UxViewsApi* | [**create_ux_view**](docs/UxViewsApi.md#create_ux_view) | **POST** /ux_views | Create a UxView
*UxViewsApi* | [**delete_ux_view**](docs/UxViewsApi.md#delete_ux_view) | **DELETE** /ux_views/{id} | Delete a UxView
*UxViewsApi* | [**delete_ux_view_param**](docs/UxViewsApi.md#delete_ux_view_param) | **DELETE** /ux_views/{id}/params/{key} | Delete a single ux_views parameter
*UxViewsApi* | [**get_ux_view**](docs/UxViewsApi.md#get_ux_view) | **GET** /ux_views/{id} | Get a UxView
*UxViewsApi* | [**get_ux_view_action**](docs/UxViewsApi.md#get_ux_view_action) | **GET** /ux_views/{id}/actions/{cmd} | List specific action for a ux_views UxView
*UxViewsApi* | [**get_ux_view_actions**](docs/UxViewsApi.md#get_ux_view_actions) | **GET** /ux_views/{id}/actions | List ux_views actions UxView
*UxViewsApi* | [**get_ux_view_param**](docs/UxViewsApi.md#get_ux_view_param) | **GET** /ux_views/{id}/params/{key} | Get a single ux_views parameter
*UxViewsApi* | [**get_ux_view_params**](docs/UxViewsApi.md#get_ux_view_params) | **GET** /ux_views/{id}/params | List ux_views params UxView
*UxViewsApi* | [**get_ux_view_pub_key**](docs/UxViewsApi.md#get_ux_view_pub_key) | **GET** /ux_views/{id}/pubkey | Get the public key for secure params on a ux_views
*UxViewsApi* | [**head_ux_view**](docs/UxViewsApi.md#head_ux_view) | **HEAD** /ux_views/{id} | See if a UxView exists
*UxViewsApi* | [**list_stats_ux_views**](docs/UxViewsApi.md#list_stats_ux_views) | **HEAD** /ux_views | Stats of the List UxViews filtered by some parameters.
*UxViewsApi* | [**list_ux_views**](docs/UxViewsApi.md#list_ux_views) | **GET** /ux_views | Lists UxViews filtered by some parameters.
*UxViewsApi* | [**patch_ux_view**](docs/UxViewsApi.md#patch_ux_view) | **PATCH** /ux_views/{id} | Patch a UxView
*UxViewsApi* | [**patch_ux_view_params**](docs/UxViewsApi.md#patch_ux_view_params) | **PATCH** /ux_views/{id}/params | Update all params on the object (merges with existing data)
*UxViewsApi* | [**post_ux_view_action**](docs/UxViewsApi.md#post_ux_view_action) | **POST** /ux_views/{id}/actions/{cmd} | Call an action on the node.
*UxViewsApi* | [**post_ux_view_param**](docs/UxViewsApi.md#post_ux_view_param) | **POST** /ux_views/{id}/params/{key} | Set a single parameter on an object
*UxViewsApi* | [**post_ux_view_params**](docs/UxViewsApi.md#post_ux_view_params) | **POST** /ux_views/{id}/params | Replaces all parameters on the object
*UxViewsApi* | [**put_ux_view**](docs/UxViewsApi.md#put_ux_view) | **PUT** /ux_views/{id} | Put a UxView
*VersionSetsApi* | [**create_version_set**](docs/VersionSetsApi.md#create_version_set) | **POST** /version_sets | Create a VersionSet
*VersionSetsApi* | [**delete_version_set**](docs/VersionSetsApi.md#delete_version_set) | **DELETE** /version_sets/{name} | Delete a VersionSet
*VersionSetsApi* | [**get_version_set**](docs/VersionSetsApi.md#get_version_set) | **GET** /version_sets/{name} | Get a VersionSet
*VersionSetsApi* | [**get_version_set_action**](docs/VersionSetsApi.md#get_version_set_action) | **GET** /version_sets/{name}/actions/{cmd} | List specific action for a version_sets VersionSet
*VersionSetsApi* | [**get_version_set_actions**](docs/VersionSetsApi.md#get_version_set_actions) | **GET** /version_sets/{name}/actions | List version_sets actions VersionSet
*VersionSetsApi* | [**head_version_set**](docs/VersionSetsApi.md#head_version_set) | **HEAD** /version_sets/{name} | See if a VersionSet exists
*VersionSetsApi* | [**list_stats_version_sets**](docs/VersionSetsApi.md#list_stats_version_sets) | **HEAD** /version_sets | Stats of the List VersionSets filtered by some parameters.
*VersionSetsApi* | [**list_version_sets**](docs/VersionSetsApi.md#list_version_sets) | **GET** /version_sets | Lists VersionSets filtered by some parameters.
*VersionSetsApi* | [**patch_version_set**](docs/VersionSetsApi.md#patch_version_set) | **PATCH** /version_sets/{name} | Patch a VersionSet
*VersionSetsApi* | [**post_version_set_action**](docs/VersionSetsApi.md#post_version_set_action) | **POST** /version_sets/{name}/actions/{cmd} | Call an action on the node.
*VersionSetsApi* | [**put_version_set**](docs/VersionSetsApi.md#put_version_set) | **PUT** /version_sets/{name} | Put a VersionSet
*WhoamiApi* | [**fill_whoami**](docs/WhoamiApi.md#fill_whoami) | **POST** /whoami | Fills a Whoami with the closest matching Machine
*WorkOrdersApi* | [**create_work_order**](docs/WorkOrdersApi.md#create_work_order) | **POST** /work_orders | Create a WorkOrder
*WorkOrdersApi* | [**delete_work_order**](docs/WorkOrdersApi.md#delete_work_order) | **DELETE** /work_orders/{uuid} | Delete a WorkOrder
*WorkOrdersApi* | [**delete_work_order_param**](docs/WorkOrdersApi.md#delete_work_order_param) | **DELETE** /work_orders/{uuid}/params/{key} | Delete a single work_orders parameter
*WorkOrdersApi* | [**delete_work_orders**](docs/WorkOrdersApi.md#delete_work_orders) | **DELETE** /work_orders | Delete WorkOrders that reference removed machines.
*WorkOrdersApi* | [**get_work_order**](docs/WorkOrdersApi.md#get_work_order) | **GET** /work_orders/{uuid} | Get a WorkOrder
*WorkOrdersApi* | [**get_work_order_action**](docs/WorkOrdersApi.md#get_work_order_action) | **GET** /work_orders/{uuid}/actions/{cmd} | List specific action for a work_orders WorkOrder
*WorkOrdersApi* | [**get_work_order_actions**](docs/WorkOrdersApi.md#get_work_order_actions) | **GET** /work_orders/{uuid}/actions | List work_orders actions WorkOrder
*WorkOrdersApi* | [**get_work_order_param**](docs/WorkOrdersApi.md#get_work_order_param) | **GET** /work_orders/{uuid}/params/{key} | Get a single work_orders parameter
*WorkOrdersApi* | [**get_work_order_params**](docs/WorkOrdersApi.md#get_work_order_params) | **GET** /work_orders/{uuid}/params | List work_orders params WorkOrder
*WorkOrdersApi* | [**get_work_order_pub_key**](docs/WorkOrdersApi.md#get_work_order_pub_key) | **GET** /work_orders/{uuid}/pubkey | Get the public key for secure params on a work_orders
*WorkOrdersApi* | [**head_work_order**](docs/WorkOrdersApi.md#head_work_order) | **HEAD** /work_orders/{uuid} | See if a WorkOrder exists
*WorkOrdersApi* | [**list_stats_work_orders**](docs/WorkOrdersApi.md#list_stats_work_orders) | **HEAD** /work_orders | Stats of the List WorkOrders filtered by some parameters.
*WorkOrdersApi* | [**list_work_orders**](docs/WorkOrdersApi.md#list_work_orders) | **GET** /work_orders | Lists WorkOrders filtered by some parameters.
*WorkOrdersApi* | [**patch_work_order**](docs/WorkOrdersApi.md#patch_work_order) | **PATCH** /work_orders/{uuid} | Patch a WorkOrder
*WorkOrdersApi* | [**patch_work_order_params**](docs/WorkOrdersApi.md#patch_work_order_params) | **PATCH** /work_orders/{uuid}/params | Update all params on the object (merges with existing data)
*WorkOrdersApi* | [**post_work_order_action**](docs/WorkOrdersApi.md#post_work_order_action) | **POST** /work_orders/{uuid}/actions/{cmd} | Call an action on the node.
*WorkOrdersApi* | [**post_work_order_param**](docs/WorkOrdersApi.md#post_work_order_param) | **POST** /work_orders/{uuid}/params/{key} | Set a single parameter on an object
*WorkOrdersApi* | [**post_work_order_params**](docs/WorkOrdersApi.md#post_work_order_params) | **POST** /work_orders/{uuid}/params | Replaces all parameters on the object
*WorkOrdersApi* | [**put_work_order**](docs/WorkOrdersApi.md#put_work_order) | **PUT** /work_orders/{uuid} | Put a WorkOrder
*WorkflowsApi* | [**create_workflow**](docs/WorkflowsApi.md#create_workflow) | **POST** /workflows | Create a Workflow
*WorkflowsApi* | [**delete_workflow**](docs/WorkflowsApi.md#delete_workflow) | **DELETE** /workflows/{name} | Delete a Workflow
*WorkflowsApi* | [**get_workflow**](docs/WorkflowsApi.md#get_workflow) | **GET** /workflows/{name} | Get a Workflow
*WorkflowsApi* | [**get_workflow_action**](docs/WorkflowsApi.md#get_workflow_action) | **GET** /workflows/{name}/actions/{cmd} | List specific action for a workflows Workflow
*WorkflowsApi* | [**get_workflow_actions**](docs/WorkflowsApi.md#get_workflow_actions) | **GET** /workflows/{name}/actions | List workflows actions Workflow
*WorkflowsApi* | [**head_workflow**](docs/WorkflowsApi.md#head_workflow) | **HEAD** /workflows/{name} | See if a Workflow exists
*WorkflowsApi* | [**list_stats_workflows**](docs/WorkflowsApi.md#list_stats_workflows) | **HEAD** /workflows | Stats of the List Workflows filtered by some parameters.
*WorkflowsApi* | [**list_workflows**](docs/WorkflowsApi.md#list_workflows) | **GET** /workflows | Lists Workflows filtered by some parameters.
*WorkflowsApi* | [**patch_workflow**](docs/WorkflowsApi.md#patch_workflow) | **PATCH** /workflows/{name} | Patch a Workflow
*WorkflowsApi* | [**post_workflow_action**](docs/WorkflowsApi.md#post_workflow_action) | **POST** /workflows/{name}/actions/{cmd} | Call an action on the node.
*WorkflowsApi* | [**put_workflow**](docs/WorkflowsApi.md#put_workflow) | **PUT** /workflows/{name} | Put a Workflow
*ZonesApi* | [**create_zone**](docs/ZonesApi.md#create_zone) | **POST** /zones | Create a Zone
*ZonesApi* | [**delete_zone**](docs/ZonesApi.md#delete_zone) | **DELETE** /zones/{name} | Delete a Zone
*ZonesApi* | [**get_zone**](docs/ZonesApi.md#get_zone) | **GET** /zones/{name} | Get a Zone
*ZonesApi* | [**get_zone_action**](docs/ZonesApi.md#get_zone_action) | **GET** /zones/{name}/actions/{cmd} | List specific action for a zones Zone
*ZonesApi* | [**get_zone_actions**](docs/ZonesApi.md#get_zone_actions) | **GET** /zones/{name}/actions | List zones actions Zone
*ZonesApi* | [**get_zone_info**](docs/ZonesApi.md#get_zone_info) | **GET** /zones-info | Returns the supported DNS records
*ZonesApi* | [**get_zone_view**](docs/ZonesApi.md#get_zone_view) | **GET** /zones/{name}/view | Returns the generated records of the zone
*ZonesApi* | [**head_zone**](docs/ZonesApi.md#head_zone) | **HEAD** /zones/{name} | See if a Zone exists
*ZonesApi* | [**list_stats_zones**](docs/ZonesApi.md#list_stats_zones) | **HEAD** /zones | Stats of the List Zones filtered by some parameters.
*ZonesApi* | [**list_zones**](docs/ZonesApi.md#list_zones) | **GET** /zones | Lists Zones filtered by some parameters.
*ZonesApi* | [**patch_zone**](docs/ZonesApi.md#patch_zone) | **PATCH** /zones/{name} | Patch a Zone
*ZonesApi* | [**post_zone_action**](docs/ZonesApi.md#post_zone_action) | **POST** /zones/{name}/actions/{cmd} | Call an action on the node.
*ZonesApi* | [**post_zone_import**](docs/ZonesApi.md#post_zone_import) | **POST** /zones-import | Using a ISC Bind zone formated data blob, a zone will be created.
*ZonesApi* | [**put_zone**](docs/ZonesApi.md#put_zone) | **PUT** /zones/{name} | Put a Zone


## Documentation For Models

 - [Action](docs/Action.md)
 - [Activity](docs/Activity.md)
 - [Alert](docs/Alert.md)
 - [ArchInfo](docs/ArchInfo.md)
 - [AvailableAction](docs/AvailableAction.md)
 - [Batch](docs/Batch.md)
 - [BlobInfo](docs/BlobInfo.md)
 - [Blueprint](docs/Blueprint.md)
 - [BootEnv](docs/BootEnv.md)
 - [CatalogItem](docs/CatalogItem.md)
 - [Cert](docs/Cert.md)
 - [Claim](docs/Claim.md)
 - [Classifier](docs/Classifier.md)
 - [Cluster](docs/Cluster.md)
 - [ClusterState](docs/ClusterState.md)
 - [Connection](docs/Connection.md)
 - [Content](docs/Content.md)
 - [ContentMetaData](docs/ContentMetaData.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [Context](docs/Context.md)
 - [DhcpOption](docs/DhcpOption.md)
 - [Element](docs/Element.md)
 - [ElementAction](docs/ElementAction.md)
 - [Endpoint](docs/Endpoint.md)
 - [Error](docs/Error.md)
 - [Event](docs/Event.md)
 - [FileData](docs/FileData.md)
 - [FilePaths](docs/FilePaths.md)
 - [Filter](docs/Filter.md)
 - [HaPassiveState](docs/HaPassiveState.md)
 - [IdentityProvider](docs/IdentityProvider.md)
 - [Index](docs/Index.md)
 - [Info](docs/Info.md)
 - [Interface](docs/Interface.md)
 - [IsoPaths](docs/IsoPaths.md)
 - [Job](docs/Job.md)
 - [Lease](docs/Lease.md)
 - [Level](docs/Level.md)
 - [License](docs/License.md)
 - [LicenseBundle](docs/LicenseBundle.md)
 - [Line](docs/Line.md)
 - [Machine](docs/Machine.md)
 - [MachineFingerprint](docs/MachineFingerprint.md)
 - [MenuGroup](docs/MenuGroup.md)
 - [MenuItem](docs/MenuItem.md)
 - [Meta](docs/Meta.md)
 - [NodeInfo](docs/NodeInfo.md)
 - [ObjectPrefixes](docs/ObjectPrefixes.md)
 - [Operation](docs/Operation.md)
 - [OsInfo](docs/OsInfo.md)
 - [Param](docs/Param.md)
 - [Patch](docs/Patch.md)
 - [Plugin](docs/Plugin.md)
 - [PluginProvider](docs/PluginProvider.md)
 - [PluginProviderUploadInfo](docs/PluginProviderUploadInfo.md)
 - [Pool](docs/Pool.md)
 - [PoolAutoFill](docs/PoolAutoFill.md)
 - [PoolResult](docs/PoolResult.md)
 - [PoolStatus](docs/PoolStatus.md)
 - [PoolTransitionActions](docs/PoolTransitionActions.md)
 - [PrivateKey](docs/PrivateKey.md)
 - [Profile](docs/Profile.md)
 - [Query](docs/Query.md)
 - [Reservation](docs/Reservation.md)
 - [ResourceBroker](docs/ResourceBroker.md)
 - [Role](docs/Role.md)
 - [Section](docs/Section.md)
 - [Sections](docs/Sections.md)
 - [Stage](docs/Stage.md)
 - [Stat](docs/Stat.md)
 - [Subnet](docs/Subnet.md)
 - [Task](docs/Task.md)
 - [TaskStack](docs/TaskStack.md)
 - [Template](docs/Template.md)
 - [TemplateInfo](docs/TemplateInfo.md)
 - [Tenant](docs/Tenant.md)
 - [Trigger](docs/Trigger.md)
 - [TriggerProvider](docs/TriggerProvider.md)
 - [User](docs/User.md)
 - [UserPassword](docs/UserPassword.md)
 - [UserToken](docs/UserToken.md)
 - [UxOption](docs/UxOption.md)
 - [UxSetting](docs/UxSetting.md)
 - [UxView](docs/UxView.md)
 - [VersionSet](docs/VersionSet.md)
 - [Whoami](docs/Whoami.md)
 - [WhoamiResult](docs/WhoamiResult.md)
 - [WorkOrder](docs/WorkOrder.md)
 - [Workflow](docs/Workflow.md)
 - [Zone](docs/Zone.md)
 - [ZoneFilter](docs/ZoneFilter.md)
 - [ZoneFilterType](docs/ZoneFilterType.md)
 - [ZoneName](docs/ZoneName.md)
 - [ZoneRecord](docs/ZoneRecord.md)
 - [ZoneType](docs/ZoneType.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

## basicAuth

- **Type**: HTTP basic authentication


## Author

support@rackn.com

