# NodeInfo

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**api_url** | **str** | ApiUrl is the URL that can be used to contact this node&#39;s API directly. | [optional] 
**consensus_addr** | **str** | ConsensusAddr is the addr:port that other nodes should attempt to contact this node no when operating in consensus mode.  All communication over these ports will be secured using TLS 1.3 using per-node short-lived certs signed by the certs in the global Roots field. | [optional] 
**consensus_id** | **str** | ConsensusID us the unique autogenerated ID for this node. Once set, it must not be changed, or else other nodes in a cluster will not recognize this node. | [optional] 
**last_artifact_commit_handled** | **int** | LastArtifactCommitHandled tracks how up to date a node is compared to the current cluster leader.  Artifact handling is allowed to happen asynchronusly from the rest of Raft based replication due to the potentially large size of artifacts.  In the event of a leadership transfer, the first node that is not Offline with the highest LastArtifactCommitHandled value will be chosen as the new cluster leader.  If that node is not also an Observer, it will become the new active dr-provision node.  If it is an Observer, it will wait for one of the operating Passive nodes to catch up to it, and then transfer leadership to it. | [optional] 
**observer** | **bool** | Observer indicates that this node cannot become the active node.  It is used when a node should act as a live backup and a consensus tiebreaker. | [optional] 
**offline** | **bool** | Offline indicates that leadership could not be transferred to this node in the most recent election, despite it being the best candidate. If a node is marks as Offline, it will stay that way until the node updates its state with the current leader. | [optional] 
**passive** | **bool** | Passive indicates that this node is not responsible for handling client connections or writes via the API. | [optional] 
**sha_sum** | **list[int]** | ShaSum is the SHA256 checksum of the running dr-provision binary on the node. | [optional] 
**version** | **str** | Version is the full version of dr-provision that is running on the node. | [optional] 
**virt_interface** | **str** | VirtInterface is the network interface that the global VirtAddr will be added on when this node si the active node, and removed from when this node is no longer the active node. | [optional] 
**virt_interface_script** | **str** | VirtInterfaceScript will be called whenever VirtAddr must be added or removed from VirtInterface.  If empty, a default set of scripts will be sued that are appropriate to the OS type dr-provision is running on. | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


