# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class ActivitiesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_activity(self, body, **kwargs):  # noqa: E501
        """Create a Activity  # noqa: E501

        Create a Activity from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Activity body: (required)
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_activity_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a Activity  # noqa: E501

        Create a Activity from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Activity body: (required)
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Activity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_activity(self, id, **kwargs):  # noqa: E501
        """Delete a Activity  # noqa: E501

        Delete a Activity specified by {id}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_activity_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_activity_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_activity_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a Activity  # noqa: E501

        Delete a Activity specified by {id}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Activity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity(self, id, **kwargs):  # noqa: E501
        """Get a Activity  # noqa: E501

        Get the Activity specified by {id}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_activity_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a Activity  # noqa: E501

        Get the Activity specified by {id}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Activity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_action(self, id, cmd, **kwargs):  # noqa: E501
        """List specific action for a activities Activity  # noqa: E501

        List specific {cmd} action for a Activity specified by {id}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_action(id, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_action_with_http_info(id, cmd, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_action_with_http_info(id, cmd, **kwargs)  # noqa: E501
            return data

    def get_activity_action_with_http_info(self, id, cmd, **kwargs):  # noqa: E501
        """List specific action for a activities Activity  # noqa: E501

        List specific {cmd} action for a Activity specified by {id}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_action_with_http_info(id, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'cmd', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_activity_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `get_activity_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}/actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_actions(self, id, **kwargs):  # noqa: E501
        """List activities actions Activity  # noqa: E501

        List Activity actions for a Activity specified by {id}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_actions(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_actions_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_actions_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_activity_actions_with_http_info(self, id, **kwargs):  # noqa: E501
        """List activities actions Activity  # noqa: E501

        List Activity actions for a Activity specified by {id}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_actions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_activity_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_activity(self, id, **kwargs):  # noqa: E501
        """See if a Activity exists  # noqa: E501

        Return 200 if the Activity specifiec by {id} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_activity(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_activity_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.head_activity_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def head_activity_with_http_info(self, id, **kwargs):  # noqa: E501
        """See if a Activity exists  # noqa: E501

        Return 200 if the Activity specifiec by {id} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_activity_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `head_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_activities(self, **kwargs):  # noqa: E501
        """Lists Activities filtered by some parameters.  # noqa: E501

        This will show all Activities by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Id=fred - returns items named fred<br/> Id=Lt(fred) - returns items that alphabetically less than fred.<br/> Id=Lt(fred)&Available=true - returns items with Id less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str arch: Arch is the architecture of the machine e.g. amd64
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str cloud: Cloud is the cloud it is running in if set.
        :param str context: Context is the context of the machine e.g. \"\" or drpcli-runner
        :param str count: Number of times for this entry
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str deleted: Deleted indicates if the entry was deleted.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint indicates a unique machine specific identifier
        :param str id: Id of the activity entry.
        :param str identity: Identity is the uuid/identity of the record
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str os: OS is the operating system of the machine - could be off
        :param str object_type: Object Type
        :param str platform: Platform is type of entry Usually: meta, physical, virtual, container
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str span: Span is the time window
        :param str type: Type of the activity (from RawModel days) Should be set to activities if present
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[Activity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Lists Activities filtered by some parameters.  # noqa: E501

        This will show all Activities by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Id=fred - returns items named fred<br/> Id=Lt(fred) - returns items that alphabetically less than fred.<br/> Id=Lt(fred)&Available=true - returns items with Id less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str arch: Arch is the architecture of the machine e.g. amd64
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str cloud: Cloud is the cloud it is running in if set.
        :param str context: Context is the context of the machine e.g. \"\" or drpcli-runner
        :param str count: Number of times for this entry
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str deleted: Deleted indicates if the entry was deleted.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint indicates a unique machine specific identifier
        :param str id: Id of the activity entry.
        :param str identity: Identity is the uuid/identity of the record
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str os: OS is the operating system of the machine - could be off
        :param str object_type: Object Type
        :param str platform: Platform is type of entry Usually: meta, physical, virtual, container
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str span: Span is the time window
        :param str type: Type of the activity (from RawModel days) Should be set to activities if present
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[Activity]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'arch', 'available', 'bundle', 'cloud', 'context', 'count', 'created_at', 'created_by', 'deleted', 'endpoint', 'errors', 'fingerprint', 'id', 'identity', 'last_modified_at', 'last_modified_by', 'os', 'object_type', 'platform', 'read_only', 'span', 'type', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_activities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'arch' in params:
            query_params.append(('Arch', params['arch']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'cloud' in params:
            query_params.append(('Cloud', params['cloud']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'count' in params:
            query_params.append(('Count', params['count']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'deleted' in params:
            query_params.append(('Deleted', params['deleted']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'fingerprint' in params:
            query_params.append(('Fingerprint', params['fingerprint']))  # noqa: E501
        if 'id' in params:
            query_params.append(('Id', params['id']))  # noqa: E501
        if 'identity' in params:
            query_params.append(('Identity', params['identity']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'os' in params:
            query_params.append(('OS', params['os']))  # noqa: E501
        if 'object_type' in params:
            query_params.append(('ObjectType', params['object_type']))  # noqa: E501
        if 'platform' in params:
            query_params.append(('Platform', params['platform']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'span' in params:
            query_params.append(('Span', params['span']))  # noqa: E501
        if 'type' in params:
            query_params.append(('Type', params['type']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Activity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_stats_activities(self, **kwargs):  # noqa: E501
        """Stats of the List Activities filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Id=fred - returns items named fred<br/> Id=Lt(fred) - returns items that alphabetically less than fred.<br/> Id=Lt(fred)&Available=true - returns items with Id less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str arch: Arch is the architecture of the machine e.g. amd64
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str cloud: Cloud is the cloud it is running in if set.
        :param str context: Context is the context of the machine e.g. \"\" or drpcli-runner
        :param str count: Number of times for this entry
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str deleted: Deleted indicates if the entry was deleted.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint indicates a unique machine specific identifier
        :param str id: Id of the activity entry.
        :param str identity: Identity is the uuid/identity of the record
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str os: OS is the operating system of the machine - could be off
        :param str object_type: Object Type
        :param str platform: Platform is type of entry Usually: meta, physical, virtual, container
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str span: Span is the time window
        :param str type: Type of the activity (from RawModel days) Should be set to activities if present
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stats_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_stats_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_stats_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Stats of the List Activities filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Id=fred - returns items named fred<br/> Id=Lt(fred) - returns items that alphabetically less than fred.<br/> Id=Lt(fred)&Available=true - returns items with Id less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str arch: Arch is the architecture of the machine e.g. amd64
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str cloud: Cloud is the cloud it is running in if set.
        :param str context: Context is the context of the machine e.g. \"\" or drpcli-runner
        :param str count: Number of times for this entry
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str deleted: Deleted indicates if the entry was deleted.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint indicates a unique machine specific identifier
        :param str id: Id of the activity entry.
        :param str identity: Identity is the uuid/identity of the record
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str os: OS is the operating system of the machine - could be off
        :param str object_type: Object Type
        :param str platform: Platform is type of entry Usually: meta, physical, virtual, container
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str span: Span is the time window
        :param str type: Type of the activity (from RawModel days) Should be set to activities if present
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'arch', 'available', 'bundle', 'cloud', 'context', 'count', 'created_at', 'created_by', 'deleted', 'endpoint', 'errors', 'fingerprint', 'id', 'identity', 'last_modified_at', 'last_modified_by', 'os', 'object_type', 'platform', 'read_only', 'span', 'type', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stats_activities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'arch' in params:
            query_params.append(('Arch', params['arch']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'cloud' in params:
            query_params.append(('Cloud', params['cloud']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'count' in params:
            query_params.append(('Count', params['count']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'deleted' in params:
            query_params.append(('Deleted', params['deleted']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'fingerprint' in params:
            query_params.append(('Fingerprint', params['fingerprint']))  # noqa: E501
        if 'id' in params:
            query_params.append(('Id', params['id']))  # noqa: E501
        if 'identity' in params:
            query_params.append(('Identity', params['identity']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'os' in params:
            query_params.append(('OS', params['os']))  # noqa: E501
        if 'object_type' in params:
            query_params.append(('ObjectType', params['object_type']))  # noqa: E501
        if 'platform' in params:
            query_params.append(('Platform', params['platform']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'span' in params:
            query_params.append(('Span', params['span']))  # noqa: E501
        if 'type' in params:
            query_params.append(('Type', params['type']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_activity(self, body, id, **kwargs):  # noqa: E501
        """Patch a Activity  # noqa: E501

        Update a Activity specified by {id} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_activity(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_activity_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_activity_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def patch_activity_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Patch a Activity  # noqa: E501

        Update a Activity specified by {id} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_activity_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_activity`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `patch_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Activity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_activity_action(self, id, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_activity_action(id, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_activity_action_with_http_info(id, cmd, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_activity_action_with_http_info(id, cmd, body, **kwargs)  # noqa: E501
            return data

    def post_activity_action_with_http_info(self, id, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_activity_action_with_http_info(id, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Identity key of the Activity (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'cmd', 'body', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_activity_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `post_activity_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `post_activity_action`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_activity_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}/actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_activity(self, body, id, **kwargs):  # noqa: E501
        """Put a Activity  # noqa: E501

        Update a Activity specified by {id} using a JSON Activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_activity(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Activity body: (required)
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_activity_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.put_activity_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def put_activity_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Put a Activity  # noqa: E501

        Update a Activity specified by {id} using a JSON Activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_activity_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Activity body: (required)
        :param str id: Identity key of the Activity (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Activity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `put_activity`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `put_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Activity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
