# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class AlertsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_alert(self, body, **kwargs):  # noqa: E501
        """Create a Alert  # noqa: E501

        Create a Alert from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alert(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Alert body: (required)
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_alert_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_alert_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_alert_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a Alert  # noqa: E501

        Create a Alert from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alert_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Alert body: (required)
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_alert(self, uuid, **kwargs):  # noqa: E501
        """Delete a Alert  # noqa: E501

        Delete a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_alert_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_alert_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_alert_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Alert  # noqa: E501

        Delete a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `delete_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_alert_param(self, **kwargs):  # noqa: E501
        """Delete a single alerts parameter  # noqa: E501

        Delete a single parameter {key} for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_param(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_alert_param_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_alert_param_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_alert_param_with_http_info(self, **kwargs):  # noqa: E501
        """Delete a single alerts parameter  # noqa: E501

        Delete a single parameter {key} for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_param_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alert_param" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params/{key}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert(self, uuid, **kwargs):  # noqa: E501
        """Get a Alert  # noqa: E501

        Get the Alert specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_alert_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get a Alert  # noqa: E501

        Get the Alert specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_action(self, uuid, cmd, **kwargs):  # noqa: E501
        """List specific action for a alerts Alert  # noqa: E501

        List specific {cmd} action for a Alert specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_action(uuid, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_action_with_http_info(uuid, cmd, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_action_with_http_info(uuid, cmd, **kwargs)  # noqa: E501
            return data

    def get_alert_action_with_http_info(self, uuid, cmd, **kwargs):  # noqa: E501
        """List specific action for a alerts Alert  # noqa: E501

        List specific {cmd} action for a Alert specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_action_with_http_info(uuid, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'cmd', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `get_alert_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_actions(self, uuid, **kwargs):  # noqa: E501
        """List alerts actions Alert  # noqa: E501

        List Alert actions for a Alert specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_actions(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_actions_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_actions_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_alert_actions_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List alerts actions Alert  # noqa: E501

        List Alert actions for a Alert specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_actions_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_param(self, uuid, key, **kwargs):  # noqa: E501
        """Get a single alerts parameter  # noqa: E501

        Get a single parameter {key} for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_param(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_param_with_http_info(uuid, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_param_with_http_info(uuid, key, **kwargs)  # noqa: E501
            return data

    def get_alert_param_with_http_info(self, uuid, key, **kwargs):  # noqa: E501
        """Get a single alerts parameter  # noqa: E501

        Get a single parameter {key} for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_param_with_http_info(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'key', 'aggregate', 'decode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `get_alert_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_params(self, uuid, **kwargs):  # noqa: E501
        """List alerts params Alert  # noqa: E501

        List Alert parms for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_params(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_params_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_params_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_alert_params_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List alerts params Alert  # noqa: E501

        List Alert parms for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_params_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'decode', 'params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_pub_key(self, uuid, **kwargs):  # noqa: E501
        """Get the public key for secure params on a alerts  # noqa: E501

        Get the public key for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_pub_key(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_pub_key_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_pub_key_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_alert_pub_key_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the public key for secure params on a alerts  # noqa: E501

        Get the public key for a Alert specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_pub_key_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_pub_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_alert_pub_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/pubkey', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_alert(self, uuid, **kwargs):  # noqa: E501
        """See if a Alert exists  # noqa: E501

        Return 200 if the Alert specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_alert(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_alert_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.head_alert_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def head_alert_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """See if a Alert exists  # noqa: E501

        Return 200 if the Alert specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_alert_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `head_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_alerts(self, **kwargs):  # noqa: E501
        """Lists Alerts filtered by some parameters.  # noqa: E501

        This will show all Alerts by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_alerts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str acknowledge_time: AcknowledgeTime - time of acknowledgement
        :param str acknowledge_user: AcknowledgeUser - user who acknowledged
        :param str acknowledged: Acknowledged - has the alert been acknowledged
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str contents: Contents is the full information about the alert
        :param str count: Count is the number of times this Name has been called uniquely
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str level: Level of the alert Range of values: Error, Warn, Info, Debug
        :param str name: Name is a short name for this alert.  This can contain any reference information for humans you want associated with the alert.
        :param str note: Notes - field for additional information about the Alert Use this field for notes about what is done with the alert.
        :param str params2: Params - structure of data elements - filterable
        :param str principal: Principal is the creator of the alert.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param datetime time: Time of the alert.
        :param str uuid: The UUID of the alert. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[Alert]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_alerts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_alerts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_alerts_with_http_info(self, **kwargs):  # noqa: E501
        """Lists Alerts filtered by some parameters.  # noqa: E501

        This will show all Alerts by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_alerts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str acknowledge_time: AcknowledgeTime - time of acknowledgement
        :param str acknowledge_user: AcknowledgeUser - user who acknowledged
        :param str acknowledged: Acknowledged - has the alert been acknowledged
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str contents: Contents is the full information about the alert
        :param str count: Count is the number of times this Name has been called uniquely
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str level: Level of the alert Range of values: Error, Warn, Info, Debug
        :param str name: Name is a short name for this alert.  This can contain any reference information for humans you want associated with the alert.
        :param str note: Notes - field for additional information about the Alert Use this field for notes about what is done with the alert.
        :param str params2: Params - structure of data elements - filterable
        :param str principal: Principal is the creator of the alert.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param datetime time: Time of the alert.
        :param str uuid: The UUID of the alert. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[Alert]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'acknowledge_time', 'acknowledge_user', 'acknowledged', 'available', 'contents', 'count', 'created_at', 'created_by', 'endpoint', 'errors', 'last_modified_at', 'last_modified_by', 'level', 'name', 'note', 'params2', 'principal', 'read_only', 'time', 'uuid', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_alerts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'acknowledge_time' in params:
            query_params.append(('AcknowledgeTime', params['acknowledge_time']))  # noqa: E501
        if 'acknowledge_user' in params:
            query_params.append(('AcknowledgeUser', params['acknowledge_user']))  # noqa: E501
        if 'acknowledged' in params:
            query_params.append(('Acknowledged', params['acknowledged']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'contents' in params:
            query_params.append(('Contents', params['contents']))  # noqa: E501
        if 'count' in params:
            query_params.append(('Count', params['count']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'level' in params:
            query_params.append(('Level', params['level']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'note' in params:
            query_params.append(('Note', params['note']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'principal' in params:
            query_params.append(('Principal', params['principal']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'time' in params:
            query_params.append(('Time', params['time']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Alert]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_stats_alerts(self, **kwargs):  # noqa: E501
        """Stats of the List Alerts filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_alerts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str acknowledge_time: AcknowledgeTime - time of acknowledgement
        :param str acknowledge_user: AcknowledgeUser - user who acknowledged
        :param str acknowledged: Acknowledged - has the alert been acknowledged
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str contents: Contents is the full information about the alert
        :param str count: Count is the number of times this Name has been called uniquely
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str level: Level of the alert Range of values: Error, Warn, Info, Debug
        :param str name: Name is a short name for this alert.  This can contain any reference information for humans you want associated with the alert.
        :param str note: Notes - field for additional information about the Alert Use this field for notes about what is done with the alert.
        :param str params2: Params - structure of data elements - filterable
        :param str principal: Principal is the creator of the alert.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param datetime time: Time of the alert.
        :param str uuid: The UUID of the alert. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stats_alerts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_stats_alerts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_stats_alerts_with_http_info(self, **kwargs):  # noqa: E501
        """Stats of the List Alerts filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_alerts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str acknowledge_time: AcknowledgeTime - time of acknowledgement
        :param str acknowledge_user: AcknowledgeUser - user who acknowledged
        :param str acknowledged: Acknowledged - has the alert been acknowledged
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str contents: Contents is the full information about the alert
        :param str count: Count is the number of times this Name has been called uniquely
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str level: Level of the alert Range of values: Error, Warn, Info, Debug
        :param str name: Name is a short name for this alert.  This can contain any reference information for humans you want associated with the alert.
        :param str note: Notes - field for additional information about the Alert Use this field for notes about what is done with the alert.
        :param str params2: Params - structure of data elements - filterable
        :param str principal: Principal is the creator of the alert.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param datetime time: Time of the alert.
        :param str uuid: The UUID of the alert. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'acknowledge_time', 'acknowledge_user', 'acknowledged', 'available', 'contents', 'count', 'created_at', 'created_by', 'endpoint', 'errors', 'last_modified_at', 'last_modified_by', 'level', 'name', 'note', 'params2', 'principal', 'read_only', 'time', 'uuid', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stats_alerts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'acknowledge_time' in params:
            query_params.append(('AcknowledgeTime', params['acknowledge_time']))  # noqa: E501
        if 'acknowledge_user' in params:
            query_params.append(('AcknowledgeUser', params['acknowledge_user']))  # noqa: E501
        if 'acknowledged' in params:
            query_params.append(('Acknowledged', params['acknowledged']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'contents' in params:
            query_params.append(('Contents', params['contents']))  # noqa: E501
        if 'count' in params:
            query_params.append(('Count', params['count']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'level' in params:
            query_params.append(('Level', params['level']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'note' in params:
            query_params.append(('Note', params['note']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'principal' in params:
            query_params.append(('Principal', params['principal']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'time' in params:
            query_params.append(('Time', params['time']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_alert(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Alert  # noqa: E501

        Update a Alert specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_alert_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_alert_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def patch_alert_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Alert  # noqa: E501

        Update a Alert specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_alert`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `patch_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_alert_params(self, body, uuid, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for Alert {uuid} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert_params(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Alert (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_alert_params_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_alert_params_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def patch_alert_params_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for Alert {uuid} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert_params_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Alert (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alert_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_alert_params`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `patch_alert_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_alert_ack(self, uuid, **kwargs):  # noqa: E501
        """Acknowledge an alert by {uuid}  # noqa: E501

        Acknowledge an alert by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_ack(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Key of the Object (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_alert_ack_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_alert_ack_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def post_alert_ack_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Acknowledge an alert by {uuid}  # noqa: E501

        Acknowledge an alert by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_ack_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Key of the Object (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alert_ack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_alert_ack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/acknowledge', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_alert_action(self, uuid, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_action(uuid, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_alert_action_with_http_info(uuid, cmd, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_alert_action_with_http_info(uuid, cmd, body, **kwargs)  # noqa: E501
            return data

    def post_alert_action_with_http_info(self, uuid, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_action_with_http_info(uuid, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Alert (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'cmd', 'body', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alert_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_alert_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `post_alert_action`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_alert_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_alert_param(self, body, uuid, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a alerts specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_param(body, uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_alert_param_with_http_info(body, uuid, key, **kwargs)  # noqa: E501
        else:
            (data) = self.post_alert_param_with_http_info(body, uuid, key, **kwargs)  # noqa: E501
            return data

    def post_alert_param_with_http_info(self, body, uuid, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a alerts specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_param_with_http_info(body, uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alert_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_alert_param`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_alert_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `post_alert_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params/{key}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_alert_params(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a alerts specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_params(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_alert_params_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_alert_params_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_alert_params_with_http_info(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a alerts specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_alert_params_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alert_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_alert_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}/params', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_alert(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Alert  # noqa: E501

        Update a Alert specified by {uuid} using a JSON Alert  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_alert(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Alert body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_alert_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_alert_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def put_alert_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Alert  # noqa: E501

        Update a Alert specified by {uuid} using a JSON Alert  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_alert_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Alert body: (required)
        :param str uuid: Identity key of the Alert (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `put_alert`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `put_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alerts/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
