# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class FilesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_file(self, path, **kwargs):  # noqa: E501
        """Delete a file to a specific {path} in the tree under files.  # noqa: E501

        The file will be removed from the {path} in /files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_with_http_info(path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_with_http_info(path, **kwargs)  # noqa: E501
            return data

    def delete_file_with_http_info(self, path, **kwargs):  # noqa: E501
        """Delete a file to a specific {path} in the tree under files.  # noqa: E501

        The file will be removed from the {path} in /files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'explode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in params or
                                                       params['path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `path` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']  # noqa: E501

        query_params = []
        if 'explode' in params:
            query_params.append(('explode', params['explode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{path}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, path, **kwargs):  # noqa: E501
        """Get a specific File with {path}  # noqa: E501

        Get a specific file specified by {path} under files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_with_http_info(path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_with_http_info(path, **kwargs)  # noqa: E501
            return data

    def get_file_with_http_info(self, path, **kwargs):  # noqa: E501
        """Get a specific File with {path}  # noqa: E501

        Get a specific file specified by {path} under files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'explode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in params or
                                                       params['path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `path` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']  # noqa: E501

        query_params = []
        if 'explode' in params:
            query_params.append(('explode', params['explode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_file(self, path, **kwargs):  # noqa: E501
        """See if a file exists and return a checksum in the header  # noqa: E501

        Return 200 if the file specified by {path} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_file(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_file_with_http_info(path, **kwargs)  # noqa: E501
        else:
            (data) = self.head_file_with_http_info(path, **kwargs)  # noqa: E501
            return data

    def head_file_with_http_info(self, path, **kwargs):  # noqa: E501
        """See if a file exists and return a checksum in the header  # noqa: E501

        Return 200 if the file specified by {path} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_file_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'explode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in params or
                                                       params['path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `path` when calling `head_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']  # noqa: E501

        query_params = []
        if 'explode' in params:
            query_params.append(('explode', params['explode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{path}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_iso(self, path, **kwargs):  # noqa: E501
        """See if a iso exists and return a checksum in the header  # noqa: E501

        Return 200 if the iso specified by {path} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_iso(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_iso_with_http_info(path, **kwargs)  # noqa: E501
        else:
            (data) = self.head_iso_with_http_info(path, **kwargs)  # noqa: E501
            return data

    def head_iso_with_http_info(self, path, **kwargs):  # noqa: E501
        """See if a iso exists and return a checksum in the header  # noqa: E501

        Return 200 if the iso specified by {path} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_iso_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_iso" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in params or
                                                       params['path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `path` when calling `head_iso`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/isos/{path}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_files(self, **kwargs):  # noqa: E501
        """Lists files in files directory or subdirectory per query parameter  # noqa: E501

        Lists the files in a directory under /files.  path=<path to return> Path defaults to /  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path:
        :param bool all:
        :return: FilePaths
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_files_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files in files directory or subdirectory per query parameter  # noqa: E501

        Lists the files in a directory under /files.  path=<path to return> Path defaults to /  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path:
        :param bool all:
        :return: FilePaths
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'all']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'all' in params:
            query_params.append(('all', params['all']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilePaths',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_file(self, path, **kwargs):  # noqa: E501
        """Upload a file to a specific {path} in the tree under files.  # noqa: E501

        The file will be uploaded to the {path} in /files.  The {path} will be created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :param object body:
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_file_with_http_info(path, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_file_with_http_info(path, **kwargs)  # noqa: E501
            return data

    def upload_file_with_http_info(self, path, **kwargs):  # noqa: E501
        """Upload a file to a specific {path} in the tree under files.  # noqa: E501

        The file will be uploaded to the {path} in /files.  The {path} will be created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str explode: in: explode
        :param object body:
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'explode', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in params or
                                                       params['path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `path` when calling `upload_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']  # noqa: E501

        query_params = []
        if 'explode' in params:
            query_params.append(('explode', params['explode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{path}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
