# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class JobsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_job(self, body, **kwargs):  # noqa: E501
        """Create a Job  # noqa: E501

        Create a Job from the provided object, Only Machine and UUID are used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_job(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Job body: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_job_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_job_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_job_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a Job  # noqa: E501

        Create a Job from the provided object, Only Machine and UUID are used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_job_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Job body: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job(self, uuid, **kwargs):  # noqa: E501
        """Delete a Job  # noqa: E501

        Delete a Job specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_job_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_job_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_job_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Job  # noqa: E501

        Delete a Job specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `delete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job(self, uuid, **kwargs):  # noqa: E501
        """Get a Job  # noqa: E501

        Get the Job specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get a Job  # noqa: E501

        Get the Job specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_action(self, uuid, **kwargs):  # noqa: E501
        """List specific action for a job Job  # noqa: E501

        List specific {cmd} action for a Job specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_action(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_action_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_action_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_action_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List specific action for a job Job  # noqa: E501

        List specific {cmd} action for a Job specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_action_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/plugin_actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_actions(self, uuid, **kwargs):  # noqa: E501
        """Get actions for this job  # noqa: E501

        Get actions for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_actions(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_actions_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_actions_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_actions_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get actions for this job  # noqa: E501

        Get actions for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_actions_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_log(self, uuid, **kwargs):  # noqa: E501
        """Get the log for this job  # noqa: E501

        Get log for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_log(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_log_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the log for this job  # noqa: E501

        Get log for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_log_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_log_archive(self, uuid, **kwargs):  # noqa: E501
        """Get the log archive entry for this job  # noqa: E501

        Get log archive entry for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_log_archive(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_log_archive_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_log_archive_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_log_archive_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the log archive entry for this job  # noqa: E501

        Get log archive entry for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_log_archive_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_log_archive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job_log_archive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/archive', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_plugin_actions(self, uuid, **kwargs):  # noqa: E501
        """List job plugin_actions Job  # noqa: E501

        List Job plugin_actions for a Job specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_plugin_actions(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_plugin_actions_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_plugin_actions_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_job_plugin_actions_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List job plugin_actions Job  # noqa: E501

        List Job plugin_actions for a Job specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_plugin_actions_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_plugin_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_job_plugin_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/plugin_actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_job(self, uuid, **kwargs):  # noqa: E501
        """See if a Job exists  # noqa: E501

        Return 200 if the Job specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_job(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_job_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.head_job_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def head_job_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """See if a Job exists  # noqa: E501

        Return 200 if the Job specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_job_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Job (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `head_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_job_log(self, uuid, **kwargs):  # noqa: E501
        """Get the log for this job  # noqa: E501

        Get log for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_job_log(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.head_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def head_job_log_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the log for this job  # noqa: E501

        Get log for the Job specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_job_log_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_job_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `head_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/log', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_jobs(self, **kwargs):  # noqa: E501
        """Lists Jobs filtered by some parameters.  # noqa: E501

        This will show all Jobs by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str action: Action contains the expanded Action information if this Job was created as part of Action processing.
        :param str archived: Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The bootenv that the task was created in. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Context is the context the job was created to run in.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current: Whether the job is the \"current one\" for the machine or if it has been superceded.
        :param str current_index: The current index is the machine CurrentTask that created this job.  read only: true
        :param str end_time: The time the job failed or finished.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str exit_state: The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str extra_claims: ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.
        :param str independent: Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str machine: The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str next_index: The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  read only: true
        :param str previous: The UUID of the previous job to run on this machine.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str stage: The stage that the task was created in. read only: true
        :param str start_time: The time the job started running.
        :param str state: The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"
        :param str target_key: TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".
        :param str target_prefix: TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.
        :param str task: The task the job was created for.  This will be the name of the task. read only: true
        :param str token: Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.
        :param str uuid: The UUID of the job.  The primary key.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order: The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.
        :param str workflow: The workflow that the task was created in. read only: true
        :return: list[Job]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """Lists Jobs filtered by some parameters.  # noqa: E501

        This will show all Jobs by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str action: Action contains the expanded Action information if this Job was created as part of Action processing.
        :param str archived: Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The bootenv that the task was created in. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Context is the context the job was created to run in.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current: Whether the job is the \"current one\" for the machine or if it has been superceded.
        :param str current_index: The current index is the machine CurrentTask that created this job.  read only: true
        :param str end_time: The time the job failed or finished.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str exit_state: The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str extra_claims: ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.
        :param str independent: Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str machine: The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str next_index: The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  read only: true
        :param str previous: The UUID of the previous job to run on this machine.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str stage: The stage that the task was created in. read only: true
        :param str start_time: The time the job started running.
        :param str state: The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"
        :param str target_key: TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".
        :param str target_prefix: TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.
        :param str task: The task the job was created for.  This will be the name of the task. read only: true
        :param str token: Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.
        :param str uuid: The UUID of the job.  The primary key.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order: The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.
        :param str workflow: The workflow that the task was created in. read only: true
        :return: list[Job]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'action', 'archived', 'available', 'boot_env', 'bundle', 'context', 'created_at', 'created_by', 'current', 'current_index', 'end_time', 'endpoint', 'errors', 'exit_state', 'extra_claims', 'independent', 'last_modified_at', 'last_modified_by', 'machine', 'meta', 'next_index', 'previous', 'read_only', 'result_errors', 'stage', 'start_time', 'state', 'target_key', 'target_prefix', 'task', 'token', 'uuid', 'validated', 'work_order', 'workflow']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'action' in params:
            query_params.append(('Action', params['action']))  # noqa: E501
        if 'archived' in params:
            query_params.append(('Archived', params['archived']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'boot_env' in params:
            query_params.append(('BootEnv', params['boot_env']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'current' in params:
            query_params.append(('Current', params['current']))  # noqa: E501
        if 'current_index' in params:
            query_params.append(('CurrentIndex', params['current_index']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('EndTime', params['end_time']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'exit_state' in params:
            query_params.append(('ExitState', params['exit_state']))  # noqa: E501
        if 'extra_claims' in params:
            query_params.append(('ExtraClaims', params['extra_claims']))  # noqa: E501
        if 'independent' in params:
            query_params.append(('Independent', params['independent']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'machine' in params:
            query_params.append(('Machine', params['machine']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'next_index' in params:
            query_params.append(('NextIndex', params['next_index']))  # noqa: E501
        if 'previous' in params:
            query_params.append(('Previous', params['previous']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'result_errors' in params:
            query_params.append(('ResultErrors', params['result_errors']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('Stage', params['stage']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('StartTime', params['start_time']))  # noqa: E501
        if 'state' in params:
            query_params.append(('State', params['state']))  # noqa: E501
        if 'target_key' in params:
            query_params.append(('TargetKey', params['target_key']))  # noqa: E501
        if 'target_prefix' in params:
            query_params.append(('TargetPrefix', params['target_prefix']))  # noqa: E501
        if 'task' in params:
            query_params.append(('Task', params['task']))  # noqa: E501
        if 'token' in params:
            query_params.append(('Token', params['token']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501
        if 'work_order' in params:
            query_params.append(('WorkOrder', params['work_order']))  # noqa: E501
        if 'workflow' in params:
            query_params.append(('Workflow', params['workflow']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Job]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_stats_jobs(self, **kwargs):  # noqa: E501
        """Stats of the List Jobs filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str action: Action contains the expanded Action information if this Job was created as part of Action processing.
        :param str archived: Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The bootenv that the task was created in. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Context is the context the job was created to run in.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current: Whether the job is the \"current one\" for the machine or if it has been superceded.
        :param str current_index: The current index is the machine CurrentTask that created this job.  read only: true
        :param str end_time: The time the job failed or finished.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str exit_state: The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str extra_claims: ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.
        :param str independent: Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str machine: The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str next_index: The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  read only: true
        :param str previous: The UUID of the previous job to run on this machine.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str stage: The stage that the task was created in. read only: true
        :param str start_time: The time the job started running.
        :param str state: The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"
        :param str target_key: TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".
        :param str target_prefix: TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.
        :param str task: The task the job was created for.  This will be the name of the task. read only: true
        :param str token: Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.
        :param str uuid: The UUID of the job.  The primary key.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order: The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.
        :param str workflow: The workflow that the task was created in. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stats_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_stats_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_stats_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """Stats of the List Jobs filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object.  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str action: Action contains the expanded Action information if this Job was created as part of Action processing.
        :param str archived: Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The bootenv that the task was created in. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Context is the context the job was created to run in.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current: Whether the job is the \"current one\" for the machine or if it has been superceded.
        :param str current_index: The current index is the machine CurrentTask that created this job.  read only: true
        :param str end_time: The time the job failed or finished.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str exit_state: The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str extra_claims: ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.
        :param str independent: Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str machine: The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str next_index: The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  read only: true
        :param str previous: The UUID of the previous job to run on this machine.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str stage: The stage that the task was created in. read only: true
        :param str start_time: The time the job started running.
        :param str state: The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"
        :param str target_key: TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".
        :param str target_prefix: TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.
        :param str task: The task the job was created for.  This will be the name of the task. read only: true
        :param str token: Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.
        :param str uuid: The UUID of the job.  The primary key.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order: The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.
        :param str workflow: The workflow that the task was created in. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'action', 'archived', 'available', 'boot_env', 'bundle', 'context', 'created_at', 'created_by', 'current', 'current_index', 'end_time', 'endpoint', 'errors', 'exit_state', 'extra_claims', 'independent', 'last_modified_at', 'last_modified_by', 'machine', 'meta', 'next_index', 'previous', 'read_only', 'result_errors', 'stage', 'start_time', 'state', 'target_key', 'target_prefix', 'task', 'token', 'uuid', 'validated', 'work_order', 'workflow']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stats_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'action' in params:
            query_params.append(('Action', params['action']))  # noqa: E501
        if 'archived' in params:
            query_params.append(('Archived', params['archived']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'boot_env' in params:
            query_params.append(('BootEnv', params['boot_env']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'current' in params:
            query_params.append(('Current', params['current']))  # noqa: E501
        if 'current_index' in params:
            query_params.append(('CurrentIndex', params['current_index']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('EndTime', params['end_time']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'exit_state' in params:
            query_params.append(('ExitState', params['exit_state']))  # noqa: E501
        if 'extra_claims' in params:
            query_params.append(('ExtraClaims', params['extra_claims']))  # noqa: E501
        if 'independent' in params:
            query_params.append(('Independent', params['independent']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'machine' in params:
            query_params.append(('Machine', params['machine']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'next_index' in params:
            query_params.append(('NextIndex', params['next_index']))  # noqa: E501
        if 'previous' in params:
            query_params.append(('Previous', params['previous']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'result_errors' in params:
            query_params.append(('ResultErrors', params['result_errors']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('Stage', params['stage']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('StartTime', params['start_time']))  # noqa: E501
        if 'state' in params:
            query_params.append(('State', params['state']))  # noqa: E501
        if 'target_key' in params:
            query_params.append(('TargetKey', params['target_key']))  # noqa: E501
        if 'target_prefix' in params:
            query_params.append(('TargetPrefix', params['target_prefix']))  # noqa: E501
        if 'task' in params:
            query_params.append(('Task', params['task']))  # noqa: E501
        if 'token' in params:
            query_params.append(('Token', params['token']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501
        if 'work_order' in params:
            query_params.append(('WorkOrder', params['work_order']))  # noqa: E501
        if 'workflow' in params:
            query_params.append(('Workflow', params['workflow']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_job(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Job  # noqa: E501

        Update a Job specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_job(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_job_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_job_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def patch_job_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Job  # noqa: E501

        Update a Job specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_job_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_job`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `patch_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_job_action(self, uuid, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_job_action(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_job_action_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_job_action_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def post_job_action_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_job_action_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_job_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_job_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/plugin_actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_job(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Job  # noqa: E501

        Update a Job specified by {uuid} using a JSON Job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_job(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Job body: (required)
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_job_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_job_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def put_job_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Job  # noqa: E501

        Update a Job specified by {uuid} using a JSON Job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_job_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Job body: (required)
        :param str uuid: Identity key of the Job (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `put_job`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `put_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_job_log(self, uuid, **kwargs):  # noqa: E501
        """Append the string to the end of the job's log.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_job_log(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_job_log_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def put_job_log_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Append the string to the end of the job's log.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_job_log_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_job_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `put_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobs/{uuid}/log', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
