# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class MachinesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cleanup_machine(self, uuid, **kwargs):  # noqa: E501
        """Cleanup a Machine  # noqa: E501

        Cleanup a Machine specified by {uuid}.  If 202 is returned, the on-delete-workflow has been started.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cleanup_machine(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cleanup_machine_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.cleanup_machine_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def cleanup_machine_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Cleanup a Machine  # noqa: E501

        Cleanup a Machine specified by {uuid}.  If 202 is returned, the on-delete-workflow has been started.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cleanup_machine_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cleanup_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `cleanup_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/cleanup', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_machine(self, body, **kwargs):  # noqa: E501
        """Create a Machine  # noqa: E501

        Create a Machine from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_machine(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Machine body: (required)
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_machine_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_machine_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_machine_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a Machine  # noqa: E501

        Create a Machine from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_machine_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Machine body: (required)
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_machine(self, uuid, **kwargs):  # noqa: E501
        """Delete a Machine  # noqa: E501

        Delete a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_machine(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_machine_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_machine_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_machine_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Machine  # noqa: E501

        Delete a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_machine_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `delete_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_machine_param(self, **kwargs):  # noqa: E501
        """Delete a single machines parameter  # noqa: E501

        Delete a single parameter {key} for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_machine_param(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_machine_param_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_machine_param_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_machine_param_with_http_info(self, **kwargs):  # noqa: E501
        """Delete a single machines parameter  # noqa: E501

        Delete a single parameter {key} for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_machine_param_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_machine_param" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params/{key}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine(self, uuid, **kwargs):  # noqa: E501
        """Get a Machine  # noqa: E501

        Get the Machine specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get a Machine  # noqa: E501

        Get the Machine specified by {uuid}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_action(self, uuid, cmd, **kwargs):  # noqa: E501
        """List specific action for a machines Machine  # noqa: E501

        List specific {cmd} action for a Machine specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_action(uuid, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_action_with_http_info(uuid, cmd, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_action_with_http_info(uuid, cmd, **kwargs)  # noqa: E501
            return data

    def get_machine_action_with_http_info(self, uuid, cmd, **kwargs):  # noqa: E501
        """List specific action for a machines Machine  # noqa: E501

        List specific {cmd} action for a Machine specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_action_with_http_info(uuid, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'cmd', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `get_machine_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_actions(self, uuid, **kwargs):  # noqa: E501
        """List machines actions Machine  # noqa: E501

        List Machine actions for a Machine specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_actions(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_actions_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_actions_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_actions_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List machines actions Machine  # noqa: E501

        List Machine actions for a Machine specified by {uuid}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_actions_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_param(self, uuid, key, **kwargs):  # noqa: E501
        """Get a single machines parameter  # noqa: E501

        Get a single parameter {key} for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_param(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_param_with_http_info(uuid, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_param_with_http_info(uuid, key, **kwargs)  # noqa: E501
            return data

    def get_machine_param_with_http_info(self, uuid, key, **kwargs):  # noqa: E501
        """Get a single machines parameter  # noqa: E501

        Get a single parameter {key} for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_param_with_http_info(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'key', 'aggregate', 'decode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `get_machine_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_params(self, uuid, **kwargs):  # noqa: E501
        """List machines params Machine  # noqa: E501

        List Machine parms for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_params(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_params_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_params_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_params_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """List machines params Machine  # noqa: E501

        List Machine parms for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_params_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'decode', 'params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_pub_key(self, uuid, **kwargs):  # noqa: E501
        """Get the public key for secure params on a machines  # noqa: E501

        Get the public key for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_pub_key(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_pub_key_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_pub_key_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_pub_key_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the public key for secure params on a machines  # noqa: E501

        Get the public key for a Machine specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_pub_key_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_pub_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_pub_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/pubkey', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_render(self, uuid, **kwargs):  # noqa: E501
        """get_machine_render  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_render(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param str body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_render_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_render_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_render_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """get_machine_render  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_render_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param str body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_render" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_render`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream', 'Render a blob on a machine', 'Renders the data posted on the Machine specified by {uuid}'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/render', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_token(self, uuid, **kwargs):  # noqa: E501
        """Get a Machine Token  # noqa: E501

        Get a Machine Token specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_token(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param int ttl:
        :return: UserToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_token_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_token_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_machine_token_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get a Machine Token  # noqa: E501

        Get a Machine Token specified by {uuid} or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_token_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param int ttl:
        :return: UserToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `get_machine_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'ttl' in params:
            query_params.append(('ttl', params['ttl']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/token', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserToken',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_machine(self, uuid, **kwargs):  # noqa: E501
        """See if a Machine exists  # noqa: E501

        Return 200 if the Machine specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_machine(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_machine_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.head_machine_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def head_machine_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """See if a Machine exists  # noqa: E501

        Return 200 if the Machine specifiec by {uuid} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_machine_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `head_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_machines(self, **kwargs):  # noqa: E501
        """Lists Machines filtered by some parameters.  # noqa: E501

        This will show all Machines by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> exclude-self = boolean to indicate that the returned list exclude the \"self\" runners (machines only)<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_machines(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str exclude_self: Should the self-runner be returned in the list
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str address: The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.
        :param str arch: Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current_job: The UUID of the job that is currently running.
        :param str current_task: The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.
        :param str description: Description is a string for providing a simple description
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint is a collection of data that can (in theory) be used to uniquely identify a machine based on various DMI information.  This (in conjunction with HardwareAddrs) is used to uniquely identify a Machine using a score based on how many total items in the Fingerprint match.  While marked readonly, it is writeable but should really only be written by the drp tooling.
        :param str hardware_addrs: HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.
        :param str job_exit_state: The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str job_result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str job_state: The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str locked: Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str name: The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.
        :param str os: OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str partial: Partial tracks if the object is not complete when returned. read only: true
        :param str pending_work_orders: PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.
        :param str pool: Pool contains the pool the machine is in. Unset machines will join the default Pool
        :param str pool_allocated: PoolAllocated defines if the machine is allocated in this pool This is a calculated field.
        :param str pool_status: PoolStatus contains the status of this machine in the Pool. Values are defined in Pool.PoolStatuses
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str retry_task_attempt: This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.
        :param str runnable: Runnable indicates that this is Runnable.
        :param str running_work_orders: RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.
        :param str secret: Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine
        :param str stage: The stage that this is currently in.
        :param str task_error_stacks: This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.
        :param str tasks: The current tasks that are being processed.
        :param str uuid: The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order_mode: WorkOrderMode indicates if the machine is action mode
        :param str workflow: Workflow is the workflow that is currently responsible for processing machine tasks.
        :param str workflow_complete: WorkflowComplete indicates if the workflow is complete
        :return: list[Machine]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_machines_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_machines_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_machines_with_http_info(self, **kwargs):  # noqa: E501
        """Lists Machines filtered by some parameters.  # noqa: E501

        This will show all Machines by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> exclude-self = boolean to indicate that the returned list exclude the \"self\" runners (machines only)<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_machines_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str exclude_self: Should the self-runner be returned in the list
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str address: The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.
        :param str arch: Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current_job: The UUID of the job that is currently running.
        :param str current_task: The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.
        :param str description: Description is a string for providing a simple description
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint is a collection of data that can (in theory) be used to uniquely identify a machine based on various DMI information.  This (in conjunction with HardwareAddrs) is used to uniquely identify a Machine using a score based on how many total items in the Fingerprint match.  While marked readonly, it is writeable but should really only be written by the drp tooling.
        :param str hardware_addrs: HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.
        :param str job_exit_state: The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str job_result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str job_state: The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str locked: Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str name: The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.
        :param str os: OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str partial: Partial tracks if the object is not complete when returned. read only: true
        :param str pending_work_orders: PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.
        :param str pool: Pool contains the pool the machine is in. Unset machines will join the default Pool
        :param str pool_allocated: PoolAllocated defines if the machine is allocated in this pool This is a calculated field.
        :param str pool_status: PoolStatus contains the status of this machine in the Pool. Values are defined in Pool.PoolStatuses
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str retry_task_attempt: This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.
        :param str runnable: Runnable indicates that this is Runnable.
        :param str running_work_orders: RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.
        :param str secret: Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine
        :param str stage: The stage that this is currently in.
        :param str task_error_stacks: This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.
        :param str tasks: The current tasks that are being processed.
        :param str uuid: The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order_mode: WorkOrderMode indicates if the machine is action mode
        :param str workflow: Workflow is the workflow that is currently responsible for processing machine tasks.
        :param str workflow_complete: WorkflowComplete indicates if the workflow is complete
        :return: list[Machine]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'exclude_self', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'address', 'arch', 'available', 'boot_env', 'bundle', 'context', 'created_at', 'created_by', 'current_job', 'current_task', 'description', 'endpoint', 'errors', 'fingerprint', 'hardware_addrs', 'job_exit_state', 'job_result_errors', 'job_state', 'last_modified_at', 'last_modified_by', 'locked', 'meta', 'name', 'os', 'params2', 'partial', 'pending_work_orders', 'pool', 'pool_allocated', 'pool_status', 'profiles', 'read_only', 'retry_task_attempt', 'runnable', 'running_work_orders', 'secret', 'stage', 'task_error_stacks', 'tasks', 'uuid', 'validated', 'work_order_mode', 'workflow', 'workflow_complete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_machines" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'exclude_self' in params:
            query_params.append(('exclude-self', params['exclude_self']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'address' in params:
            query_params.append(('Address', params['address']))  # noqa: E501
        if 'arch' in params:
            query_params.append(('Arch', params['arch']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'boot_env' in params:
            query_params.append(('BootEnv', params['boot_env']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'current_job' in params:
            query_params.append(('CurrentJob', params['current_job']))  # noqa: E501
        if 'current_task' in params:
            query_params.append(('CurrentTask', params['current_task']))  # noqa: E501
        if 'description' in params:
            query_params.append(('Description', params['description']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'fingerprint' in params:
            query_params.append(('Fingerprint', params['fingerprint']))  # noqa: E501
        if 'hardware_addrs' in params:
            query_params.append(('HardwareAddrs', params['hardware_addrs']))  # noqa: E501
        if 'job_exit_state' in params:
            query_params.append(('JobExitState', params['job_exit_state']))  # noqa: E501
        if 'job_result_errors' in params:
            query_params.append(('JobResultErrors', params['job_result_errors']))  # noqa: E501
        if 'job_state' in params:
            query_params.append(('JobState', params['job_state']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'locked' in params:
            query_params.append(('Locked', params['locked']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'os' in params:
            query_params.append(('OS', params['os']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'partial' in params:
            query_params.append(('Partial', params['partial']))  # noqa: E501
        if 'pending_work_orders' in params:
            query_params.append(('PendingWorkOrders', params['pending_work_orders']))  # noqa: E501
        if 'pool' in params:
            query_params.append(('Pool', params['pool']))  # noqa: E501
        if 'pool_allocated' in params:
            query_params.append(('PoolAllocated', params['pool_allocated']))  # noqa: E501
        if 'pool_status' in params:
            query_params.append(('PoolStatus', params['pool_status']))  # noqa: E501
        if 'profiles' in params:
            query_params.append(('Profiles', params['profiles']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'retry_task_attempt' in params:
            query_params.append(('RetryTaskAttempt', params['retry_task_attempt']))  # noqa: E501
        if 'runnable' in params:
            query_params.append(('Runnable', params['runnable']))  # noqa: E501
        if 'running_work_orders' in params:
            query_params.append(('RunningWorkOrders', params['running_work_orders']))  # noqa: E501
        if 'secret' in params:
            query_params.append(('Secret', params['secret']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('Stage', params['stage']))  # noqa: E501
        if 'task_error_stacks' in params:
            query_params.append(('TaskErrorStacks', params['task_error_stacks']))  # noqa: E501
        if 'tasks' in params:
            query_params.append(('Tasks', params['tasks']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501
        if 'work_order_mode' in params:
            query_params.append(('WorkOrderMode', params['work_order_mode']))  # noqa: E501
        if 'workflow' in params:
            query_params.append(('Workflow', params['workflow']))  # noqa: E501
        if 'workflow_complete' in params:
            query_params.append(('WorkflowComplete', params['workflow_complete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Machine]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_stats_machines(self, **kwargs):  # noqa: E501
        """Stats of the List Machines filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> exclude-self = boolean to indicate that the returned list exclude the \"self\" runners (machines only)<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_machines(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str exclude_self: Should the self-runner be returned in the list
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str address: The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.
        :param str arch: Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current_job: The UUID of the job that is currently running.
        :param str current_task: The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.
        :param str description: Description is a string for providing a simple description
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint is a collection of data that can (in theory) be used to uniquely identify a machine based on various DMI information.  This (in conjunction with HardwareAddrs) is used to uniquely identify a Machine using a score based on how many total items in the Fingerprint match.  While marked readonly, it is writeable but should really only be written by the drp tooling.
        :param str hardware_addrs: HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.
        :param str job_exit_state: The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str job_result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str job_state: The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str locked: Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str name: The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.
        :param str os: OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str partial: Partial tracks if the object is not complete when returned. read only: true
        :param str pending_work_orders: PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.
        :param str pool: Pool contains the pool the machine is in. Unset machines will join the default Pool
        :param str pool_allocated: PoolAllocated defines if the machine is allocated in this pool This is a calculated field.
        :param str pool_status: PoolStatus contains the status of this machine in the Pool. Values are defined in Pool.PoolStatuses
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str retry_task_attempt: This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.
        :param str runnable: Runnable indicates that this is Runnable.
        :param str running_work_orders: RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.
        :param str secret: Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine
        :param str stage: The stage that this is currently in.
        :param str task_error_stacks: This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.
        :param str tasks: The current tasks that are being processed.
        :param str uuid: The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order_mode: WorkOrderMode indicates if the machine is action mode
        :param str workflow: Workflow is the workflow that is currently responsible for processing machine tasks.
        :param str workflow_complete: WorkflowComplete indicates if the workflow is complete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stats_machines_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_stats_machines_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_stats_machines_with_http_info(self, **kwargs):  # noqa: E501
        """Stats of the List Machines filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> exclude-self = boolean to indicate that the returned list exclude the \"self\" runners (machines only)<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Uuid=fred - returns items named fred<br/> Uuid=Lt(fred) - returns items that alphabetically less than fred.<br/> Uuid=Lt(fred)&Available=true - returns items with Uuid less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_machines_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str exclude_self: Should the self-runner be returned in the list
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str address: The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.
        :param str arch: Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str boot_env: The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str context: Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str current_job: The UUID of the job that is currently running.
        :param str current_task: The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.
        :param str description: Description is a string for providing a simple description
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str fingerprint: Fingerprint is a collection of data that can (in theory) be used to uniquely identify a machine based on various DMI information.  This (in conjunction with HardwareAddrs) is used to uniquely identify a Machine using a score based on how many total items in the Fingerprint match.  While marked readonly, it is writeable but should really only be written by the drp tooling.
        :param str hardware_addrs: HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.
        :param str job_exit_state: The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on
        :param str job_result_errors: ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.
        :param str job_state: The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str locked: Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str name: The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.
        :param str os: OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str partial: Partial tracks if the object is not complete when returned. read only: true
        :param str pending_work_orders: PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.
        :param str pool: Pool contains the pool the machine is in. Unset machines will join the default Pool
        :param str pool_allocated: PoolAllocated defines if the machine is allocated in this pool This is a calculated field.
        :param str pool_status: PoolStatus contains the status of this machine in the Pool. Values are defined in Pool.PoolStatuses
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str retry_task_attempt: This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.
        :param str runnable: Runnable indicates that this is Runnable.
        :param str running_work_orders: RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.
        :param str secret: Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine
        :param str stage: The stage that this is currently in.
        :param str task_error_stacks: This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.
        :param str tasks: The current tasks that are being processed.
        :param str uuid: The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :param str work_order_mode: WorkOrderMode indicates if the machine is action mode
        :param str workflow: Workflow is the workflow that is currently responsible for processing machine tasks.
        :param str workflow_complete: WorkflowComplete indicates if the workflow is complete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'exclude_self', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'address', 'arch', 'available', 'boot_env', 'bundle', 'context', 'created_at', 'created_by', 'current_job', 'current_task', 'description', 'endpoint', 'errors', 'fingerprint', 'hardware_addrs', 'job_exit_state', 'job_result_errors', 'job_state', 'last_modified_at', 'last_modified_by', 'locked', 'meta', 'name', 'os', 'params2', 'partial', 'pending_work_orders', 'pool', 'pool_allocated', 'pool_status', 'profiles', 'read_only', 'retry_task_attempt', 'runnable', 'running_work_orders', 'secret', 'stage', 'task_error_stacks', 'tasks', 'uuid', 'validated', 'work_order_mode', 'workflow', 'workflow_complete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stats_machines" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'exclude_self' in params:
            query_params.append(('exclude-self', params['exclude_self']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'address' in params:
            query_params.append(('Address', params['address']))  # noqa: E501
        if 'arch' in params:
            query_params.append(('Arch', params['arch']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'boot_env' in params:
            query_params.append(('BootEnv', params['boot_env']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'context' in params:
            query_params.append(('Context', params['context']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'current_job' in params:
            query_params.append(('CurrentJob', params['current_job']))  # noqa: E501
        if 'current_task' in params:
            query_params.append(('CurrentTask', params['current_task']))  # noqa: E501
        if 'description' in params:
            query_params.append(('Description', params['description']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'fingerprint' in params:
            query_params.append(('Fingerprint', params['fingerprint']))  # noqa: E501
        if 'hardware_addrs' in params:
            query_params.append(('HardwareAddrs', params['hardware_addrs']))  # noqa: E501
        if 'job_exit_state' in params:
            query_params.append(('JobExitState', params['job_exit_state']))  # noqa: E501
        if 'job_result_errors' in params:
            query_params.append(('JobResultErrors', params['job_result_errors']))  # noqa: E501
        if 'job_state' in params:
            query_params.append(('JobState', params['job_state']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'locked' in params:
            query_params.append(('Locked', params['locked']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'os' in params:
            query_params.append(('OS', params['os']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'partial' in params:
            query_params.append(('Partial', params['partial']))  # noqa: E501
        if 'pending_work_orders' in params:
            query_params.append(('PendingWorkOrders', params['pending_work_orders']))  # noqa: E501
        if 'pool' in params:
            query_params.append(('Pool', params['pool']))  # noqa: E501
        if 'pool_allocated' in params:
            query_params.append(('PoolAllocated', params['pool_allocated']))  # noqa: E501
        if 'pool_status' in params:
            query_params.append(('PoolStatus', params['pool_status']))  # noqa: E501
        if 'profiles' in params:
            query_params.append(('Profiles', params['profiles']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'retry_task_attempt' in params:
            query_params.append(('RetryTaskAttempt', params['retry_task_attempt']))  # noqa: E501
        if 'runnable' in params:
            query_params.append(('Runnable', params['runnable']))  # noqa: E501
        if 'running_work_orders' in params:
            query_params.append(('RunningWorkOrders', params['running_work_orders']))  # noqa: E501
        if 'secret' in params:
            query_params.append(('Secret', params['secret']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('Stage', params['stage']))  # noqa: E501
        if 'task_error_stacks' in params:
            query_params.append(('TaskErrorStacks', params['task_error_stacks']))  # noqa: E501
        if 'tasks' in params:
            query_params.append(('Tasks', params['tasks']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('Uuid', params['uuid']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501
        if 'work_order_mode' in params:
            query_params.append(('WorkOrderMode', params['work_order_mode']))  # noqa: E501
        if 'workflow' in params:
            query_params.append(('Workflow', params['workflow']))  # noqa: E501
        if 'workflow_complete' in params:
            query_params.append(('WorkflowComplete', params['workflow_complete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_machine(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_machine(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_machine_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_machine_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def patch_machine_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Patch a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_machine_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_machine`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `patch_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_machine_params(self, body, uuid, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for Machine {uuid} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_machine_params(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Machine (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_machine_params_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_machine_params_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def patch_machine_params_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for Machine {uuid} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_machine_params_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str uuid: Identity key of the Machine (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_machine_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_machine_params`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `patch_machine_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pick_machine_work_order(self, uuid, key, **kwargs):  # noqa: E501
        """Pick a workorder for this agent.  This can return the current work order.  # noqa: E501

        No input. (optional WorkOrder may be provided)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pick_machine_work_order(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param str key: (required)
        :return: WorkOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pick_machine_work_order_with_http_info(uuid, key, **kwargs)  # noqa: E501
        else:
            (data) = self.pick_machine_work_order_with_http_info(uuid, key, **kwargs)  # noqa: E501
            return data

    def pick_machine_work_order_with_http_info(self, uuid, key, **kwargs):  # noqa: E501
        """Pick a workorder for this agent.  This can return the current work order.  # noqa: E501

        No input. (optional WorkOrder may be provided)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pick_machine_work_order_with_http_info(uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param str key: (required)
        :return: WorkOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pick_machine_work_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `pick_machine_work_order`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `pick_machine_work_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{id}/pick/{key}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkOrder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_machine_action(self, uuid, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_action(uuid, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_machine_action_with_http_info(uuid, cmd, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_machine_action_with_http_info(uuid, cmd, body, **kwargs)  # noqa: E501
            return data

    def post_machine_action_with_http_info(self, uuid, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_action_with_http_info(uuid, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identity key of the Machine (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'cmd', 'body', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_machine_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_machine_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `post_machine_action`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_machine_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_machine_param(self, body, uuid, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a machines specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_param(body, uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_machine_param_with_http_info(body, uuid, key, **kwargs)  # noqa: E501
        else:
            (data) = self.post_machine_param_with_http_info(body, uuid, key, **kwargs)  # noqa: E501
            return data

    def post_machine_param_with_http_info(self, body, uuid, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a machines specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_param_with_http_info(body, uuid, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_machine_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_machine_param`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_machine_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `post_machine_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params/{key}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_machine_params(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a machines specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_params(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_machine_params_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_machine_params_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_machine_params_with_http_info(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a machines specified by {uuid}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_params_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_machine_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_machine_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/params', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_machine_release_to_pool(self, uuid, **kwargs):  # noqa: E501
        """Releases a machine in this pool.  # noqa: E501

        No input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_release_to_pool(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: list[PoolResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_machine_release_to_pool_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_machine_release_to_pool_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def post_machine_release_to_pool_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Releases a machine in this pool.  # noqa: E501

        No input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_machine_release_to_pool_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: list[PoolResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_machine_release_to_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `post_machine_release_to_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{id}/releaseToPool', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PoolResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_machine(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a JSON Machine  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_machine(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Machine body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_machine_with_http_info(body, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_machine_with_http_info(body, uuid, **kwargs)  # noqa: E501
            return data

    def put_machine_with_http_info(self, body, uuid, **kwargs):  # noqa: E501
        """Put a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a JSON Machine  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_machine_with_http_info(body, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Machine body: (required)
        :param str uuid: Identity key of the Machine (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'uuid', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `put_machine`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in params or
                                                       params['uuid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `uuid` when calling `put_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_machine(self, body, **kwargs):  # noqa: E501
        """Start a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a RFC6902 Patch structure after clearing Workflow and Runnable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_machine(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param bool force: Attempt force the action with less validation
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_machine_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.start_machine_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def start_machine_with_http_info(self, body, **kwargs):  # noqa: E501
        """Start a Machine  # noqa: E501

        Update a Machine specified by {uuid} using a RFC6902 Patch structure after clearing Workflow and Runnable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_machine_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param bool force: Attempt force the action with less validation
        :return: Machine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_machine" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `start_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/machines/{uuid}/start', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Machine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
