# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class SystemApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_system_action(self, cmd, **kwargs):  # noqa: E501
        """List specific action for System  # noqa: E501

        List specific {cmd} action for System  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_action(cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmd: (required)
        :param str plugin:
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_action_with_http_info(cmd, **kwargs)  # noqa: E501
        else:
            (data) = self.get_system_action_with_http_info(cmd, **kwargs)  # noqa: E501
            return data

    def get_system_action_with_http_info(self, cmd, **kwargs):  # noqa: E501
        """List specific action for System  # noqa: E501

        List specific {cmd} action for System  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_action_with_http_info(cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmd: (required)
        :param str plugin:
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cmd', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `get_system_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_actions(self, **kwargs):  # noqa: E501
        """List system actions System  # noqa: E501

        List System actions  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_actions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin:
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_actions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_system_actions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_system_actions_with_http_info(self, **kwargs):  # noqa: E501
        """List system actions System  # noqa: E501

        List System actions  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_actions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin:
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_actions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_system_action(self, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the system.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_system_action(cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmd: (required)
        :param object body: (required)
        :param str plugin:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_system_action_with_http_info(cmd, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_system_action_with_http_info(cmd, body, **kwargs)  # noqa: E501
            return data

    def post_system_action_with_http_info(self, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the system.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_system_action_with_http_info(cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmd: (required)
        :param object body: (required)
        :param str plugin:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cmd', 'body', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_system_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `post_system_action`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_system_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_status(self, **kwargs):  # noqa: E501
        """Returns the status profile of the system upgrade.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Profile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_status_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the status profile of the system upgrade.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Profile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Profile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_update(self, **kwargs):  # noqa: E501
        """Upload a file to upgrade the DRP system  # noqa: E501

        The file will be uploaded and used to replace the running DRP instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_update_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_update_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_update_with_http_info(self, **kwargs):  # noqa: E501
        """Upload a file to upgrade the DRP system  # noqa: E501

        The file will be uploaded and used to replace the running DRP instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_update" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_update_exec(self, **kwargs):  # noqa: E501
        """Execute a previously staged upgrade  # noqa: E501

        The system will attempt to replace the current dr-provision and drpcli binaries with the ones staged by /system/upgrade/stage.  If the staged upgrade matches the running binary (based on SHA256sums), this will return 204, and no further action will be taken.  If the staged upgrade does not match the running binary, this will swap binaries, return 202, and restart 2 seconds after the API call finishes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_exec(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_update_exec_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_update_exec_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_update_exec_with_http_info(self, **kwargs):  # noqa: E501
        """Execute a previously staged upgrade  # noqa: E501

        The system will attempt to replace the current dr-provision and drpcli binaries with the ones staged by /system/upgrade/stage.  If the staged upgrade matches the running binary (based on SHA256sums), this will return 204, and no further action will be taken.  If the staged upgrade does not match the running binary, this will swap binaries, return 202, and restart 2 seconds after the API call finishes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_exec_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_update_exec" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade/exec', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_update_run(self, **kwargs):  # noqa: E501
        """Perform a rolling upgrade of a dr-provision cluster.  # noqa: E501

        The upgrade must already be staged.  All the nodes of the cluster will be upgraded by calling their /system/upgrade/exec API endpoint and then waiting on that node to restart and update its version in the consensus metadata.  Once that happens, the update process will move on to the next node.  All other nodes will be updated before the cluster leader.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_run(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_update_run_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_update_run_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_update_run_with_http_info(self, **kwargs):  # noqa: E501
        """Perform a rolling upgrade of a dr-provision cluster.  # noqa: E501

        The upgrade must already be staged.  All the nodes of the cluster will be upgraded by calling their /system/upgrade/exec API endpoint and then waiting on that node to restart and update its version in the consensus metadata.  Once that happens, the update process will move on to the next node.  All other nodes will be updated before the cluster leader.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_run_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_update_run" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade/run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_update_stage(self, **kwargs):  # noqa: E501
        """Upload a file to perform a staged upgrade of a dr-provision cluster  # noqa: E501

        The file will be uploaded and used to replace the running DRP instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_stage(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_update_stage_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_update_stage_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_update_stage_with_http_info(self, **kwargs):  # noqa: E501
        """Upload a file to perform a staged upgrade of a dr-provision cluster  # noqa: E501

        The file will be uploaded and used to replace the running DRP instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_stage_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BlobInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_update_stage" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade/stage', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_update_unstage(self, **kwargs):  # noqa: E501
        """Unstage a pending staged update.  This will fail if an update us running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_unstage(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_update_unstage_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_update_unstage_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_update_unstage_with_http_info(self, **kwargs):  # noqa: E501
        """Unstage a pending staged update.  This will fail if an update us running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_update_unstage_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_update_unstage" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/upgrade/stage', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
