# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from drppy_client.api_client import ApiClient


class TriggerProvidersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_trigger_provider(self, body, **kwargs):  # noqa: E501
        """Create a TriggerProvider  # noqa: E501

        Create a TriggerProvider from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_trigger_provider(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TriggerProvider body: (required)
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_trigger_provider_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_trigger_provider_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_trigger_provider_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a TriggerProvider  # noqa: E501

        Create a TriggerProvider from the provided object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_trigger_provider_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TriggerProvider body: (required)
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TriggerProvider',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_trigger_provider(self, name, **kwargs):  # noqa: E501
        """Delete a TriggerProvider  # noqa: E501

        Delete a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trigger_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_trigger_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete a TriggerProvider  # noqa: E501

        Delete a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trigger_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `delete_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TriggerProvider',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_trigger_provider_param(self, **kwargs):  # noqa: E501
        """Delete a single trigger_providers parameter  # noqa: E501

        Delete a single parameter {key} for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trigger_provider_param(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_trigger_provider_param_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_trigger_provider_param_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_trigger_provider_param_with_http_info(self, **kwargs):  # noqa: E501
        """Delete a single trigger_providers parameter  # noqa: E501

        Delete a single parameter {key} for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trigger_provider_param_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_trigger_provider_param" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params/{key}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider(self, name, **kwargs):  # noqa: E501
        """Get a TriggerProvider  # noqa: E501

        Get the TriggerProvider specified by {name}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get a TriggerProvider  # noqa: E501

        Get the TriggerProvider specified by {name}  or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TriggerProvider',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider_action(self, name, cmd, **kwargs):  # noqa: E501
        """List specific action for a trigger_providers TriggerProvider  # noqa: E501

        List specific {cmd} action for a TriggerProvider specified by {name}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_action(name, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_action_with_http_info(name, cmd, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_action_with_http_info(name, cmd, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_action_with_http_info(self, name, cmd, **kwargs):  # noqa: E501
        """List specific action for a trigger_providers TriggerProvider  # noqa: E501

        List specific {cmd} action for a TriggerProvider specified by {name}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_action_with_http_info(name, cmd, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str cmd: The action to run on the plugin (required)
        :param str plugin: Plugin that should be used for this action
        :return: AvailableAction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'cmd', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `get_trigger_provider_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/actions/{cmd}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableAction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider_actions(self, name, **kwargs):  # noqa: E501
        """List trigger_providers actions TriggerProvider  # noqa: E501

        List TriggerProvider actions for a TriggerProvider specified by {name}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_actions(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_actions_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_actions_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_actions_with_http_info(self, name, **kwargs):  # noqa: E501
        """List trigger_providers actions TriggerProvider  # noqa: E501

        List TriggerProvider actions for a TriggerProvider specified by {name}  Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_actions_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str plugin: Plugin that should be used for this action
        :return: list[AvailableAction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableAction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider_param(self, name, key, **kwargs):  # noqa: E501
        """Get a single trigger_providers parameter  # noqa: E501

        Get a single parameter {key} for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_param(name, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_param_with_http_info(name, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_param_with_http_info(name, key, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_param_with_http_info(self, name, key, **kwargs):  # noqa: E501
        """Get a single trigger_providers parameter  # noqa: E501

        Get a single parameter {key} for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_param_with_http_info(name, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str key: Param name (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'key', 'aggregate', 'decode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `get_trigger_provider_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider_params(self, name, **kwargs):  # noqa: E501
        """List trigger_providers params TriggerProvider  # noqa: E501

        List TriggerProvider parms for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_params(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_params_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_params_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_params_with_http_info(self, name, **kwargs):  # noqa: E501
        """List trigger_providers params TriggerProvider  # noqa: E501

        List TriggerProvider parms for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_params_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool decode: Should Secure Params be decrypted in the result
        :param str params:
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'aggregate', 'decode', 'params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_provider_pub_key(self, name, **kwargs):  # noqa: E501
        """Get the public key for secure params on a trigger_providers  # noqa: E501

        Get the public key for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_pub_key(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_provider_pub_key_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_provider_pub_key_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_trigger_provider_pub_key_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get the public key for secure params on a trigger_providers  # noqa: E501

        Get the public key for a TriggerProvider specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_provider_pub_key_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_provider_pub_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_trigger_provider_pub_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/pubkey', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_trigger_provider(self, name, **kwargs):  # noqa: E501
        """See if a TriggerProvider exists  # noqa: E501

        Return 200 if the TriggerProvider specifiec by {name} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_trigger_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.head_trigger_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def head_trigger_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """See if a TriggerProvider exists  # noqa: E501

        Return 200 if the TriggerProvider specifiec by {name} exists, or return NotFound.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_trigger_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool decode: Should Secure Params be decrypted in the result
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool reduced: Should the returned object have only read/write fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'aggregate', 'commented', 'decode', 'expand', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `head_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_stats_trigger_providers(self, **kwargs):  # noqa: E501
        """Stats of the List TriggerProviders filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Name=fred - returns items named fred<br/> Name=Lt(fred) - returns items that alphabetically less than fred.<br/> Name=Lt(fred)&Available=true - returns items with Name less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_trigger_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str description: Description is a string for providing a simple description
        :param str documentation: Documentation is a string for providing additional in depth information.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str method: Method defines the method used on that URL
        :param str name: Name is the key of this particular TriggerProvider.
        :param str no_url: NoURL indicates that a URL should NOT be created
        :param str optional_parameters: OptionalParameters define the optional values that can be in Params on the Trigger
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str required_parameters: RequiredParameters define the values that must be in Params on the Trigger
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stats_trigger_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_stats_trigger_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_stats_trigger_providers_with_http_info(self, **kwargs):  # noqa: E501
        """Stats of the List TriggerProviders filtered by some parameters.  # noqa: E501

        This will return headers with the stats of the list.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> range-only = returns only counts of the objects in the groups.<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Name=fred - returns items named fred<br/> Name=Lt(fred) - returns items that alphabetically less than fred.<br/> Name=Lt(fred)&Available=true - returns items with Name less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stats_trigger_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str description: Description is a string for providing a simple description
        :param str documentation: Documentation is a string for providing additional in depth information.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str method: Method defines the method used on that URL
        :param str name: Name is the key of this particular TriggerProvider.
        :param str no_url: NoURL indicates that a URL should NOT be created
        :param str optional_parameters: OptionalParameters define the optional values that can be in Params on the Trigger
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str required_parameters: RequiredParameters define the values that must be in Params on the Trigger
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'available', 'bundle', 'created_at', 'created_by', 'description', 'documentation', 'endpoint', 'errors', 'last_modified_at', 'last_modified_by', 'meta', 'method', 'name', 'no_url', 'optional_parameters', 'params2', 'profiles', 'read_only', 'required_parameters', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stats_trigger_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'description' in params:
            query_params.append(('Description', params['description']))  # noqa: E501
        if 'documentation' in params:
            query_params.append(('Documentation', params['documentation']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'method' in params:
            query_params.append(('Method', params['method']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'no_url' in params:
            query_params.append(('NoURL', params['no_url']))  # noqa: E501
        if 'optional_parameters' in params:
            query_params.append(('OptionalParameters', params['optional_parameters']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'profiles' in params:
            query_params.append(('Profiles', params['profiles']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'required_parameters' in params:
            query_params.append(('RequiredParameters', params['required_parameters']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_trigger_providers(self, **kwargs):  # noqa: E501
        """Lists TriggerProviders filtered by some parameters.  # noqa: E501

        This will show all TriggerProviders by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Name=fred - returns items named fred<br/> Name=Lt(fred) - returns items that alphabetically less than fred.<br/> Name=Lt(fred)&Available=true - returns items with Name less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_trigger_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str description: Description is a string for providing a simple description
        :param str documentation: Documentation is a string for providing additional in depth information.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str method: Method defines the method used on that URL
        :param str name: Name is the key of this particular TriggerProvider.
        :param str no_url: NoURL indicates that a URL should NOT be created
        :param str optional_parameters: OptionalParameters define the optional values that can be in Params on the Trigger
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str required_parameters: RequiredParameters define the values that must be in Params on the Trigger
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[TriggerProvider]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_trigger_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_trigger_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_trigger_providers_with_http_info(self, **kwargs):  # noqa: E501
        """Lists TriggerProviders filtered by some parameters.  # noqa: E501

        This will show all TriggerProviders by default.  You may specify to control the search:  aggregate = boolean to indicate if the parameters should be aggregated for search and return<br/> expand = boolean to indicate if the parameters should be expanded for search and return<br/> filter = a string that defines a Named filter<br/> raw = a string that is template expanded and then parsed for filter functions<br/>  You may specify to control the output:  decode = boolean to indicate that the returned object have the secure parameters decoded.<br/> group-by = can be specified multiple times. An array of objects (nested) grouped by the value is returned.<br/> limit = integer, number of items to return<br/> offset = integer, 0-based inclusive starting point in filter data.<br/> params = a comma separated list of parameters, or list functions to allow for inclusion in the returned object (if appropriate)<br/> range-only = returns only counts of the objects in the groups.<br/> reverse = boolean to indicate to reverse the returned list<br/> slim = A comma separated list of fields to exclude (meta, params, or other field names)<br/> sort = A list of strings defining the fields or parameters to sort by<br/> reduced = boolean to indicate that the objects should not have read-only fields<br/> commented = boolean to indicate that field comments should be included in object<br/>  Functions:  Eq(value) = Return items that are equal to value<br/> Lt(value) = Return items that are less than value<br/> Lte(value) = Return items that less than or equal to value<br/> Gt(value) = Return items that are greater than value<br/> Gte(value) = Return items that greater than or equal to value<br/> Between(lower,upper) = Return items that are inclusively between lower and upper<br/> Except(lower,upper) = Return items that are not inclusively between lower and upper<br/>  Functions can be applied against fields of the object. Functions can also be applied against values in the Params field as well. e.g. Params.ipmi/enabled=Eq(true)  Example:  Name=fred - returns items named fred<br/> Name=Lt(fred) - returns items that alphabetically less than fred.<br/> Name=Lt(fred)&Available=true - returns items with Name less than fred and Available is true<br/>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_trigger_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset: The page offset (0-based) into limit per page pages
        :param int limit: The number of objects to return
        :param str filter: A named filter to user in restricting the query
        :param str raw: A raw query string to proess
        :param bool decode: Should Secure Params be decrypted in the result
        :param str group_by: A field generate groups from. Can be specified multiple times
        :param str params: A comma separated list of parameters to include in the Params field
        :param bool range_only: Indicates that only the counts of the objects should be returned for a group-by field
        :param bool reverse: Indicates that the reverse order of the sort.
        :param str slim: A comma separated list of fields to remove from the returned objects
        :param str sort: A field to sort the results by. Multiple can be specified Searches are applied in order across all results.
        :param bool aggregate: Should the objects have aggregated parameters used in return and evaluation
        :param bool expand: Should the objects have expanded parameters used in return and evaluation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :param str available: Available tracks whether or not the model passed validation. read only: true
        :param str bundle: Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  read only: true
        :param str created_at: CreatedAt is the time that this object was created.
        :param str created_by: CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob
        :param str description: Description is a string for providing a simple description
        :param str documentation: Documentation is a string for providing additional in depth information.
        :param str endpoint: Endpoint tracks the owner of the object among DRP endpoints read only: true
        :param str errors: If there are any errors in the validation process, they will be available here. read only: true
        :param str last_modified_at: LastModifiedAt is the time that this object was last modified.
        :param str last_modified_by: LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked
        :param str meta: Meta contains the meta data of the object.  The type of this field is a key / value map/dictionary. The key type is string. The value type is also string.  The general content of the field is undefined and can be an arbritary store. There are some common known keys:  color - The color the UX uses when displaying icon - The icon the UX uses when displaying title - The UX uses this for additional display information.  Often the source of the object.  Specific Object types use additional meta data fields.  These are described at: https://docs.rackn.io/stable/redirect/?ref=rs_object_metadata
        :param str method: Method defines the method used on that URL
        :param str name: Name is the key of this particular TriggerProvider.
        :param str no_url: NoURL indicates that a URL should NOT be created
        :param str optional_parameters: OptionalParameters define the optional values that can be in Params on the Trigger
        :param str params2: Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.
        :param str profiles: Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.
        :param str read_only: ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  read only: true
        :param str required_parameters: RequiredParameters define the values that must be in Params on the Trigger
        :param str validated: Validated tracks whether or not the model has been validated. read only: true
        :return: list[TriggerProvider]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'raw', 'decode', 'group_by', 'params', 'range_only', 'reverse', 'slim', 'sort', 'aggregate', 'expand', 'commented', 'reduced', 'available', 'bundle', 'created_at', 'created_by', 'description', 'documentation', 'endpoint', 'errors', 'last_modified_at', 'last_modified_by', 'meta', 'method', 'name', 'no_url', 'optional_parameters', 'params2', 'profiles', 'read_only', 'required_parameters', 'validated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_trigger_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'decode' in params:
            query_params.append(('decode', params['decode']))  # noqa: E501
        if 'group_by' in params:
            query_params.append(('group-by', params['group_by']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'range_only' in params:
            query_params.append(('range-only', params['range_only']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'slim' in params:
            query_params.append(('slim', params['slim']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501
        if 'available' in params:
            query_params.append(('Available', params['available']))  # noqa: E501
        if 'bundle' in params:
            query_params.append(('Bundle', params['bundle']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('CreatedAt', params['created_at']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('CreatedBy', params['created_by']))  # noqa: E501
        if 'description' in params:
            query_params.append(('Description', params['description']))  # noqa: E501
        if 'documentation' in params:
            query_params.append(('Documentation', params['documentation']))  # noqa: E501
        if 'endpoint' in params:
            query_params.append(('Endpoint', params['endpoint']))  # noqa: E501
        if 'errors' in params:
            query_params.append(('Errors', params['errors']))  # noqa: E501
        if 'last_modified_at' in params:
            query_params.append(('LastModifiedAt', params['last_modified_at']))  # noqa: E501
        if 'last_modified_by' in params:
            query_params.append(('LastModifiedBy', params['last_modified_by']))  # noqa: E501
        if 'meta' in params:
            query_params.append(('Meta', params['meta']))  # noqa: E501
        if 'method' in params:
            query_params.append(('Method', params['method']))  # noqa: E501
        if 'name' in params:
            query_params.append(('Name', params['name']))  # noqa: E501
        if 'no_url' in params:
            query_params.append(('NoURL', params['no_url']))  # noqa: E501
        if 'optional_parameters' in params:
            query_params.append(('OptionalParameters', params['optional_parameters']))  # noqa: E501
        if 'params2' in params:
            query_params.append(('Params', params['params2']))  # noqa: E501
        if 'profiles' in params:
            query_params.append(('Profiles', params['profiles']))  # noqa: E501
        if 'read_only' in params:
            query_params.append(('ReadOnly', params['read_only']))  # noqa: E501
        if 'required_parameters' in params:
            query_params.append(('RequiredParameters', params['required_parameters']))  # noqa: E501
        if 'validated' in params:
            query_params.append(('Validated', params['validated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TriggerProvider]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_trigger_provider(self, body, name, **kwargs):  # noqa: E501
        """Patch a TriggerProvider  # noqa: E501

        Update a TriggerProvider specified by {name} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_trigger_provider(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_trigger_provider_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_trigger_provider_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def patch_trigger_provider_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Patch a TriggerProvider  # noqa: E501

        Update a TriggerProvider specified by {name} using a RFC6902 Patch structure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_trigger_provider_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_trigger_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `patch_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TriggerProvider',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_trigger_provider_params(self, body, name, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for TriggerProvider {name} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_trigger_provider_params(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_trigger_provider_params_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_trigger_provider_params_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def patch_trigger_provider_params_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Update all params on the object (merges with existing data)  # noqa: E501

        Update params for TriggerProvider {name} with the passed-in patch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_trigger_provider_params_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Patch body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_trigger_provider_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `patch_trigger_provider_params`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `patch_trigger_provider_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_trigger_provider_action(self, name, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_action(name, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_trigger_provider_action_with_http_info(name, cmd, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_trigger_provider_action_with_http_info(name, cmd, body, **kwargs)  # noqa: E501
            return data

    def post_trigger_provider_action_with_http_info(self, name, cmd, body, **kwargs):  # noqa: E501
        """Call an action on the node.  # noqa: E501

        Optionally, a query parameter can be used to limit the scope to a specific plugin. e.g. ?plugin=fred  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_action_with_http_info(name, cmd, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Identity key of the TriggerProvider (required)
        :param str cmd: The action to run on the plugin (required)
        :param object body: Additional parameter data for the action.  At a minimum, an empty object must be provided e.g. {} (required)
        :param str plugin: Plugin that should be used for this action
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'cmd', 'body', 'plugin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_trigger_provider_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `post_trigger_provider_action`")  # noqa: E501
        # verify the required parameter 'cmd' is set
        if self.api_client.client_side_validation and ('cmd' not in params or
                                                       params['cmd'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cmd` when calling `post_trigger_provider_action`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_trigger_provider_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'cmd' in params:
            path_params['cmd'] = params['cmd']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/actions/{cmd}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_trigger_provider_param(self, body, name, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a trigger_providers specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_param(body, name, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_trigger_provider_param_with_http_info(body, name, key, **kwargs)  # noqa: E501
        else:
            (data) = self.post_trigger_provider_param_with_http_info(body, name, key, **kwargs)  # noqa: E501
            return data

    def post_trigger_provider_param_with_http_info(self, body, name, key, **kwargs):  # noqa: E501
        """Set a single parameter on an object  # noqa: E501

        Set as single Parameter {key} for a trigger_providers specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_param_with_http_info(body, name, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param str key: Param name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_trigger_provider_param" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_trigger_provider_param`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `post_trigger_provider_param`")  # noqa: E501
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in params or
                                                       params['key'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `key` when calling `post_trigger_provider_param`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params/{key}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_trigger_provider_params(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a trigger_providers specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_params(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_trigger_provider_params_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_trigger_provider_params_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_trigger_provider_params_with_http_info(self, body, **kwargs):  # noqa: E501
        """Replaces all parameters on the object  # noqa: E501

        Sets parameters for a trigger_providers specified by {name}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_trigger_provider_params_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_trigger_provider_params" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_trigger_provider_params`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}/params', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_trigger_provider(self, body, name, **kwargs):  # noqa: E501
        """Put a TriggerProvider  # noqa: E501

        Update a TriggerProvider specified by {name} using a JSON TriggerProvider  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_trigger_provider(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TriggerProvider body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_trigger_provider_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_trigger_provider_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def put_trigger_provider_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Put a TriggerProvider  # noqa: E501

        Update a TriggerProvider specified by {name} using a JSON TriggerProvider  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_trigger_provider_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TriggerProvider body: (required)
        :param str name: Identity key of the TriggerProvider (required)
        :param bool force: Attempt force the action with less validation
        :param bool commented: Should the returned object have comments added
        :param bool reduced: Should the returned object have only read/write fields
        :return: TriggerProvider
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'force', 'commented', 'reduced']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_trigger_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `put_trigger_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `put_trigger_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'commented' in params:
            query_params.append(('commented', params['commented']))  # noqa: E501
        if 'reduced' in params:
            query_params.append(('reduced', params['reduced']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trigger_providers/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TriggerProvider',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
