# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class ArchInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'boot_params': 'str',
        'initrds': 'list[str]',
        'iso_file': 'str',
        'iso_url': 'str',
        'kernel': 'str',
        'loader': 'str',
        'sha256': 'str'
    }

    attribute_map = {
        'boot_params': 'BootParams',
        'initrds': 'Initrds',
        'iso_file': 'IsoFile',
        'iso_url': 'IsoUrl',
        'kernel': 'Kernel',
        'loader': 'Loader',
        'sha256': 'Sha256'
    }

    def __init__(self, boot_params=None, initrds=None, iso_file=None, iso_url=None, kernel=None, loader=None, sha256=None, _configuration=None):  # noqa: E501
        """ArchInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._boot_params = None
        self._initrds = None
        self._iso_file = None
        self._iso_url = None
        self._kernel = None
        self._loader = None
        self._sha256 = None
        self.discriminator = None

        self.boot_params = boot_params
        self.initrds = initrds
        if iso_file is not None:
            self.iso_file = iso_file
        if iso_url is not None:
            self.iso_url = iso_url
        self.kernel = kernel
        if loader is not None:
            self.loader = loader
        if sha256 is not None:
            self.sha256 = sha256

    @property
    def boot_params(self):
        """Gets the boot_params of this ArchInfo.  # noqa: E501

        A template that will be expanded to create the full list of boot parameters for the environment.  If empty, this will fall back to the top-level BootParams field in the BootEnv  # noqa: E501

        :return: The boot_params of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._boot_params

    @boot_params.setter
    def boot_params(self, boot_params):
        """Sets the boot_params of this ArchInfo.

        A template that will be expanded to create the full list of boot parameters for the environment.  If empty, this will fall back to the top-level BootParams field in the BootEnv  # noqa: E501

        :param boot_params: The boot_params of this ArchInfo.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and boot_params is None:
            raise ValueError("Invalid value for `boot_params`, must not be `None`")  # noqa: E501

        self._boot_params = boot_params

    @property
    def initrds(self):
        """Gets the initrds of this ArchInfo.  # noqa: E501

        Partial paths to the initrds that should be loaded for the boot environment. These should be paths that the initrds are located at in the OS ISO or install archive.  If empty, this will fall back to the top-level Initrds field in the BootEnv  # noqa: E501

        :return: The initrds of this ArchInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._initrds

    @initrds.setter
    def initrds(self, initrds):
        """Sets the initrds of this ArchInfo.

        Partial paths to the initrds that should be loaded for the boot environment. These should be paths that the initrds are located at in the OS ISO or install archive.  If empty, this will fall back to the top-level Initrds field in the BootEnv  # noqa: E501

        :param initrds: The initrds of this ArchInfo.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and initrds is None:
            raise ValueError("Invalid value for `initrds`, must not be `None`")  # noqa: E501

        self._initrds = initrds

    @property
    def iso_file(self):
        """Gets the iso_file of this ArchInfo.  # noqa: E501

        IsoFile is the name of the ISO file (or other archive) that contains all the necessary information to be able to boot into this BootEnv for a given arch. At a minimum, it must contain a kernel and initrd that can be booted over the network.  # noqa: E501

        :return: The iso_file of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._iso_file

    @iso_file.setter
    def iso_file(self, iso_file):
        """Sets the iso_file of this ArchInfo.

        IsoFile is the name of the ISO file (or other archive) that contains all the necessary information to be able to boot into this BootEnv for a given arch. At a minimum, it must contain a kernel and initrd that can be booted over the network.  # noqa: E501

        :param iso_file: The iso_file of this ArchInfo.  # noqa: E501
        :type: str
        """

        self._iso_file = iso_file

    @property
    def iso_url(self):
        """Gets the iso_url of this ArchInfo.  # noqa: E501

        IsoUrl is the location that IsoFile can be downloaded from, if any. This must be a full URL, including the filename.  dr-provision does not use this field internally.  drpcli and the UX use this field to provide a default source for downloading the IsoFile.  # noqa: E501

        :return: The iso_url of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._iso_url

    @iso_url.setter
    def iso_url(self, iso_url):
        """Sets the iso_url of this ArchInfo.

        IsoUrl is the location that IsoFile can be downloaded from, if any. This must be a full URL, including the filename.  dr-provision does not use this field internally.  drpcli and the UX use this field to provide a default source for downloading the IsoFile.  # noqa: E501

        :param iso_url: The iso_url of this ArchInfo.  # noqa: E501
        :type: str
        """

        self._iso_url = iso_url

    @property
    def kernel(self):
        """Gets the kernel of this ArchInfo.  # noqa: E501

        The partial path to the kernel for the boot environment.  This should be path that the kernel is located at in the OS ISO or install archive.  If empty, this will fall back to the top-level Kernel field in the BootEnv  # noqa: E501

        :return: The kernel of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._kernel

    @kernel.setter
    def kernel(self, kernel):
        """Sets the kernel of this ArchInfo.

        The partial path to the kernel for the boot environment.  This should be path that the kernel is located at in the OS ISO or install archive.  If empty, this will fall back to the top-level Kernel field in the BootEnv  # noqa: E501

        :param kernel: The kernel of this ArchInfo.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and kernel is None:
            raise ValueError("Invalid value for `kernel`, must not be `None`")  # noqa: E501

        self._kernel = kernel

    @property
    def loader(self):
        """Gets the loader of this ArchInfo.  # noqa: E501

        Loader is the bootloader that should be used for this boot environment.  If left unspecified and not overridden by a subnet or reservation option, the following boot loaders will be used:  lpxelinux.0 on 386-pcbios platforms that are not otherwise using ipxe.  ipxe.pxe on 386-pcbios platforms that already use ipxe.  ipxe.efi on amd64 EFI platforms.  ipxe-arm64.efi on arm64 EFI platforms.  This setting will be overridden by Subnet and Reservation options, and it will also only be in effect when dr-provision is the DHCP server of record.  It will also be overridden by the corresponding entry in the Loaders field of the BootEnv, if present and secure boot is enabled by the license.  # noqa: E501

        :return: The loader of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._loader

    @loader.setter
    def loader(self, loader):
        """Sets the loader of this ArchInfo.

        Loader is the bootloader that should be used for this boot environment.  If left unspecified and not overridden by a subnet or reservation option, the following boot loaders will be used:  lpxelinux.0 on 386-pcbios platforms that are not otherwise using ipxe.  ipxe.pxe on 386-pcbios platforms that already use ipxe.  ipxe.efi on amd64 EFI platforms.  ipxe-arm64.efi on arm64 EFI platforms.  This setting will be overridden by Subnet and Reservation options, and it will also only be in effect when dr-provision is the DHCP server of record.  It will also be overridden by the corresponding entry in the Loaders field of the BootEnv, if present and secure boot is enabled by the license.  # noqa: E501

        :param loader: The loader of this ArchInfo.  # noqa: E501
        :type: str
        """

        self._loader = loader

    @property
    def sha256(self):
        """Gets the sha256 of this ArchInfo.  # noqa: E501

        Sha256 should contain the SHA256 checksum for the IsoFile. If it does, the IsoFile will be checked upon upload to make sure it has not been corrupted.  # noqa: E501

        :return: The sha256 of this ArchInfo.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this ArchInfo.

        Sha256 should contain the SHA256 checksum for the IsoFile. If it does, the IsoFile will be checked upon upload to make sure it has not been corrupted.  # noqa: E501

        :param sha256: The sha256 of this ArchInfo.  # noqa: E501
        :type: str
        """

        self._sha256 = sha256

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ArchInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArchInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ArchInfo):
            return True

        return self.to_dict() != other.to_dict()
