# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class BootEnv(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'available': 'bool',
        'boot_params': 'str',
        'bundle': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'description': 'str',
        'documentation': 'str',
        'end_delimiter': 'str',
        'endpoint': 'str',
        'errors': 'list[str]',
        'initrds': 'list[str]',
        'kernel': 'str',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'loaders': 'dict(str, str)',
        'meta': 'Meta',
        'name': 'str',
        'os': 'OsInfo',
        'only_unknown': 'bool',
        'optional_params': 'list[str]',
        'read_only': 'bool',
        'required_params': 'list[str]',
        'start_delimiter': 'str',
        'templates': 'list[TemplateInfo]',
        'validated': 'bool'
    }

    attribute_map = {
        'available': 'Available',
        'boot_params': 'BootParams',
        'bundle': 'Bundle',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'description': 'Description',
        'documentation': 'Documentation',
        'end_delimiter': 'EndDelimiter',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'initrds': 'Initrds',
        'kernel': 'Kernel',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'loaders': 'Loaders',
        'meta': 'Meta',
        'name': 'Name',
        'os': 'OS',
        'only_unknown': 'OnlyUnknown',
        'optional_params': 'OptionalParams',
        'read_only': 'ReadOnly',
        'required_params': 'RequiredParams',
        'start_delimiter': 'StartDelimiter',
        'templates': 'Templates',
        'validated': 'Validated'
    }

    def __init__(self, available=None, boot_params=None, bundle=None, created_at=None, created_by=None, description=None, documentation=None, end_delimiter=None, endpoint=None, errors=None, initrds=None, kernel=None, last_modified_at=None, last_modified_by=None, loaders=None, meta=None, name=None, os=None, only_unknown=None, optional_params=None, read_only=None, required_params=None, start_delimiter=None, templates=None, validated=None, _configuration=None):  # noqa: E501
        """BootEnv - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._available = None
        self._boot_params = None
        self._bundle = None
        self._created_at = None
        self._created_by = None
        self._description = None
        self._documentation = None
        self._end_delimiter = None
        self._endpoint = None
        self._errors = None
        self._initrds = None
        self._kernel = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._loaders = None
        self._meta = None
        self._name = None
        self._os = None
        self._only_unknown = None
        self._optional_params = None
        self._read_only = None
        self._required_params = None
        self._start_delimiter = None
        self._templates = None
        self._validated = None
        self.discriminator = None

        if available is not None:
            self.available = available
        self.boot_params = boot_params
        if bundle is not None:
            self.bundle = bundle
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if description is not None:
            self.description = description
        if documentation is not None:
            self.documentation = documentation
        if end_delimiter is not None:
            self.end_delimiter = end_delimiter
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        self.initrds = initrds
        self.kernel = kernel
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        self.loaders = loaders
        if meta is not None:
            self.meta = meta
        self.name = name
        if os is not None:
            self.os = os
        self.only_unknown = only_unknown
        if optional_params is not None:
            self.optional_params = optional_params
        if read_only is not None:
            self.read_only = read_only
        self.required_params = required_params
        if start_delimiter is not None:
            self.start_delimiter = start_delimiter
        self.templates = templates
        if validated is not None:
            self.validated = validated

    @property
    def available(self):
        """Gets the available of this BootEnv.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this BootEnv.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this BootEnv.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this BootEnv.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def boot_params(self):
        """Gets the boot_params of this BootEnv.  # noqa: E501

        A template that will be expanded to create the full list of boot parameters for the environment.  This list will generally be passed as command line arguments to the Kernel as it boots up.  # noqa: E501

        :return: The boot_params of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._boot_params

    @boot_params.setter
    def boot_params(self, boot_params):
        """Sets the boot_params of this BootEnv.

        A template that will be expanded to create the full list of boot parameters for the environment.  This list will generally be passed as command line arguments to the Kernel as it boots up.  # noqa: E501

        :param boot_params: The boot_params of this BootEnv.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and boot_params is None:
            raise ValueError("Invalid value for `boot_params`, must not be `None`")  # noqa: E501

        self._boot_params = boot_params

    @property
    def bundle(self):
        """Gets the bundle of this BootEnv.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this BootEnv.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this BootEnv.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def created_at(self):
        """Gets the created_at of this BootEnv.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this BootEnv.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BootEnv.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this BootEnv.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this BootEnv.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this BootEnv.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this BootEnv.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def description(self):
        """Gets the description of this BootEnv.  # noqa: E501

        Description is a string for providing a simple description  # noqa: E501

        :return: The description of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BootEnv.

        Description is a string for providing a simple description  # noqa: E501

        :param description: The description of this BootEnv.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def documentation(self):
        """Gets the documentation of this BootEnv.  # noqa: E501

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :return: The documentation of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._documentation

    @documentation.setter
    def documentation(self, documentation):
        """Sets the documentation of this BootEnv.

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :param documentation: The documentation of this BootEnv.  # noqa: E501
        :type: str
        """

        self._documentation = documentation

    @property
    def end_delimiter(self):
        """Gets the end_delimiter of this BootEnv.  # noqa: E501

        EndDelimiter is an optional end delimiter.  # noqa: E501

        :return: The end_delimiter of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._end_delimiter

    @end_delimiter.setter
    def end_delimiter(self, end_delimiter):
        """Sets the end_delimiter of this BootEnv.

        EndDelimiter is an optional end delimiter.  # noqa: E501

        :param end_delimiter: The end_delimiter of this BootEnv.  # noqa: E501
        :type: str
        """

        self._end_delimiter = end_delimiter

    @property
    def endpoint(self):
        """Gets the endpoint of this BootEnv.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this BootEnv.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this BootEnv.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this BootEnv.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this BootEnv.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this BootEnv.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this BootEnv.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def initrds(self):
        """Gets the initrds of this BootEnv.  # noqa: E501

        Partial paths to the initrds that should be loaded for the boot environment. These should be paths that the initrds are located at in the OS ISO or install archive.  # noqa: E501

        :return: The initrds of this BootEnv.  # noqa: E501
        :rtype: list[str]
        """
        return self._initrds

    @initrds.setter
    def initrds(self, initrds):
        """Sets the initrds of this BootEnv.

        Partial paths to the initrds that should be loaded for the boot environment. These should be paths that the initrds are located at in the OS ISO or install archive.  # noqa: E501

        :param initrds: The initrds of this BootEnv.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and initrds is None:
            raise ValueError("Invalid value for `initrds`, must not be `None`")  # noqa: E501

        self._initrds = initrds

    @property
    def kernel(self):
        """Gets the kernel of this BootEnv.  # noqa: E501

        The partial path to the kernel for the boot environment.  This should be path that the kernel is located at in the OS ISO or install archive.  Kernel must be non-empty for a BootEnv to be considered net bootable.  # noqa: E501

        :return: The kernel of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._kernel

    @kernel.setter
    def kernel(self, kernel):
        """Sets the kernel of this BootEnv.

        The partial path to the kernel for the boot environment.  This should be path that the kernel is located at in the OS ISO or install archive.  Kernel must be non-empty for a BootEnv to be considered net bootable.  # noqa: E501

        :param kernel: The kernel of this BootEnv.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and kernel is None:
            raise ValueError("Invalid value for `kernel`, must not be `None`")  # noqa: E501

        self._kernel = kernel

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this BootEnv.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this BootEnv.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this BootEnv.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this BootEnv.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this BootEnv.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this BootEnv.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this BootEnv.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def loaders(self):
        """Gets the loaders of this BootEnv.  # noqa: E501

        Loaders contains the boot loaders that should be used for various different network boot scenarios.  It consists of a map of machine type -> partial paths to the bootloaders. Valid machine types are:  386-pcbios for x86 devices using the legacy bios.  amd64-uefi for x86 devices operating in UEFI mode  arm64-uefi for arm64 devices operating in UEFI mode  Other machine types will be added as dr-provision gains support for them.  If this map does not contain an entry for the machine type, the DHCP server will fall back to the following entries in this order:  The Loader specified in the ArchInfo struct from this BootEnv, if it exists.  The value specified in the bootloaders param for the machine type specified on the machine, if it exists.  The value specified in the bootloaders param in the global profile, if it exists.  The value specified in the default value for the bootloaders param.  One of the following vaiues:  lpxelinux.0 for 386-pcbios  ipxe.efi for amd64-uefi  ipxe-arm64.efi for arm64-uefi  # noqa: E501

        :return: The loaders of this BootEnv.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._loaders

    @loaders.setter
    def loaders(self, loaders):
        """Sets the loaders of this BootEnv.

        Loaders contains the boot loaders that should be used for various different network boot scenarios.  It consists of a map of machine type -> partial paths to the bootloaders. Valid machine types are:  386-pcbios for x86 devices using the legacy bios.  amd64-uefi for x86 devices operating in UEFI mode  arm64-uefi for arm64 devices operating in UEFI mode  Other machine types will be added as dr-provision gains support for them.  If this map does not contain an entry for the machine type, the DHCP server will fall back to the following entries in this order:  The Loader specified in the ArchInfo struct from this BootEnv, if it exists.  The value specified in the bootloaders param for the machine type specified on the machine, if it exists.  The value specified in the bootloaders param in the global profile, if it exists.  The value specified in the default value for the bootloaders param.  One of the following vaiues:  lpxelinux.0 for 386-pcbios  ipxe.efi for amd64-uefi  ipxe-arm64.efi for arm64-uefi  # noqa: E501

        :param loaders: The loaders of this BootEnv.  # noqa: E501
        :type: dict(str, str)
        """
        if self._configuration.client_side_validation and loaders is None:
            raise ValueError("Invalid value for `loaders`, must not be `None`")  # noqa: E501

        self._loaders = loaders

    @property
    def meta(self):
        """Gets the meta of this BootEnv.  # noqa: E501


        :return: The meta of this BootEnv.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this BootEnv.


        :param meta: The meta of this BootEnv.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this BootEnv.  # noqa: E501

        Name is the name of the boot environment.  Boot environments that install an operating system must end in '-install'.  All boot environment names must be unique.  # noqa: E501

        :return: The name of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BootEnv.

        Name is the name of the boot environment.  Boot environments that install an operating system must end in '-install'.  All boot environment names must be unique.  # noqa: E501

        :param name: The name of this BootEnv.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def os(self):
        """Gets the os of this BootEnv.  # noqa: E501


        :return: The os of this BootEnv.  # noqa: E501
        :rtype: OsInfo
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this BootEnv.


        :param os: The os of this BootEnv.  # noqa: E501
        :type: OsInfo
        """

        self._os = os

    @property
    def only_unknown(self):
        """Gets the only_unknown of this BootEnv.  # noqa: E501

        OnlyUnknown indicates whether this bootenv can be used without a machine.  Only bootenvs with this flag set to `true` be used for the unknownBootEnv preference.  If this flag is set to True, then the Templates provided byt this boot environment must take care to be able to chainload into the appropriate boot environments for other machines if the bootloader that machine is using does not support it natively. The built-in ignore boot environment and the discovery boot environment provided by the community content bundle should be used as references for satisfying that requirement.  # noqa: E501

        :return: The only_unknown of this BootEnv.  # noqa: E501
        :rtype: bool
        """
        return self._only_unknown

    @only_unknown.setter
    def only_unknown(self, only_unknown):
        """Sets the only_unknown of this BootEnv.

        OnlyUnknown indicates whether this bootenv can be used without a machine.  Only bootenvs with this flag set to `true` be used for the unknownBootEnv preference.  If this flag is set to True, then the Templates provided byt this boot environment must take care to be able to chainload into the appropriate boot environments for other machines if the bootloader that machine is using does not support it natively. The built-in ignore boot environment and the discovery boot environment provided by the community content bundle should be used as references for satisfying that requirement.  # noqa: E501

        :param only_unknown: The only_unknown of this BootEnv.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and only_unknown is None:
            raise ValueError("Invalid value for `only_unknown`, must not be `None`")  # noqa: E501

        self._only_unknown = only_unknown

    @property
    def optional_params(self):
        """Gets the optional_params of this BootEnv.  # noqa: E501

        The list of extra optional parameters for this boot environment. They can be present as Machine.Params when the bootenv is applied to the machine.  These are more other consumers of the bootenv to know what parameters could additionally be applied to the bootenv by the renderer based upon the Machine.Params  # noqa: E501

        :return: The optional_params of this BootEnv.  # noqa: E501
        :rtype: list[str]
        """
        return self._optional_params

    @optional_params.setter
    def optional_params(self, optional_params):
        """Sets the optional_params of this BootEnv.

        The list of extra optional parameters for this boot environment. They can be present as Machine.Params when the bootenv is applied to the machine.  These are more other consumers of the bootenv to know what parameters could additionally be applied to the bootenv by the renderer based upon the Machine.Params  # noqa: E501

        :param optional_params: The optional_params of this BootEnv.  # noqa: E501
        :type: list[str]
        """

        self._optional_params = optional_params

    @property
    def read_only(self):
        """Gets the read_only of this BootEnv.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this BootEnv.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this BootEnv.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this BootEnv.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def required_params(self):
        """Gets the required_params of this BootEnv.  # noqa: E501

        The list of extra required parameters for this boot environment. They should be present as Machine.Params when the bootenv is applied to the machine.  # noqa: E501

        :return: The required_params of this BootEnv.  # noqa: E501
        :rtype: list[str]
        """
        return self._required_params

    @required_params.setter
    def required_params(self, required_params):
        """Sets the required_params of this BootEnv.

        The list of extra required parameters for this boot environment. They should be present as Machine.Params when the bootenv is applied to the machine.  # noqa: E501

        :param required_params: The required_params of this BootEnv.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and required_params is None:
            raise ValueError("Invalid value for `required_params`, must not be `None`")  # noqa: E501

        self._required_params = required_params

    @property
    def start_delimiter(self):
        """Gets the start_delimiter of this BootEnv.  # noqa: E501

        StartDelimiter is an optional start delimiter.  # noqa: E501

        :return: The start_delimiter of this BootEnv.  # noqa: E501
        :rtype: str
        """
        return self._start_delimiter

    @start_delimiter.setter
    def start_delimiter(self, start_delimiter):
        """Sets the start_delimiter of this BootEnv.

        StartDelimiter is an optional start delimiter.  # noqa: E501

        :param start_delimiter: The start_delimiter of this BootEnv.  # noqa: E501
        :type: str
        """

        self._start_delimiter = start_delimiter

    @property
    def templates(self):
        """Gets the templates of this BootEnv.  # noqa: E501

        Templates contains a list of templates that should be expanded into files for the boot environment.  These expanded templates will be available via TFTP and static HTTP from dr-provision.  You should take care that the final paths for the temmplates do not overlap with ones provided by other boot environments.  # noqa: E501

        :return: The templates of this BootEnv.  # noqa: E501
        :rtype: list[TemplateInfo]
        """
        return self._templates

    @templates.setter
    def templates(self, templates):
        """Sets the templates of this BootEnv.

        Templates contains a list of templates that should be expanded into files for the boot environment.  These expanded templates will be available via TFTP and static HTTP from dr-provision.  You should take care that the final paths for the temmplates do not overlap with ones provided by other boot environments.  # noqa: E501

        :param templates: The templates of this BootEnv.  # noqa: E501
        :type: list[TemplateInfo]
        """
        if self._configuration.client_side_validation and templates is None:
            raise ValueError("Invalid value for `templates`, must not be `None`")  # noqa: E501

        self._templates = templates

    @property
    def validated(self):
        """Gets the validated of this BootEnv.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this BootEnv.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this BootEnv.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this BootEnv.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BootEnv, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BootEnv):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BootEnv):
            return True

        return self.to_dict() != other.to_dict()
