# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class Cluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'address': 'str',
        'arch': 'str',
        'available': 'bool',
        'boot_env': 'str',
        'bundle': 'str',
        'context': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'current_job': 'str',
        'current_task': 'int',
        'description': 'str',
        'endpoint': 'str',
        'errors': 'list[str]',
        'fingerprint': 'MachineFingerprint',
        'hardware_addrs': 'list[str]',
        'job_exit_state': 'str',
        'job_result_errors': 'list[str]',
        'job_state': 'str',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'locked': 'bool',
        'meta': 'Meta',
        'name': 'str',
        'os': 'str',
        'params': 'dict(str, object)',
        'partial': 'bool',
        'pending_work_orders': 'int',
        'pool': 'str',
        'pool_allocated': 'bool',
        'pool_status': 'PoolStatus',
        'profiles': 'list[str]',
        'read_only': 'bool',
        'retry_task_attempt': 'int',
        'runnable': 'bool',
        'running_work_orders': 'int',
        'secret': 'str',
        'stage': 'str',
        'task_error_stacks': 'list[TaskStack]',
        'tasks': 'list[str]',
        'uuid': 'str',
        'validated': 'bool',
        'work_order_mode': 'bool',
        'workflow': 'str',
        'workflow_complete': 'bool'
    }

    attribute_map = {
        'address': 'Address',
        'arch': 'Arch',
        'available': 'Available',
        'boot_env': 'BootEnv',
        'bundle': 'Bundle',
        'context': 'Context',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'current_job': 'CurrentJob',
        'current_task': 'CurrentTask',
        'description': 'Description',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'fingerprint': 'Fingerprint',
        'hardware_addrs': 'HardwareAddrs',
        'job_exit_state': 'JobExitState',
        'job_result_errors': 'JobResultErrors',
        'job_state': 'JobState',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'locked': 'Locked',
        'meta': 'Meta',
        'name': 'Name',
        'os': 'OS',
        'params': 'Params',
        'partial': 'Partial',
        'pending_work_orders': 'PendingWorkOrders',
        'pool': 'Pool',
        'pool_allocated': 'PoolAllocated',
        'pool_status': 'PoolStatus',
        'profiles': 'Profiles',
        'read_only': 'ReadOnly',
        'retry_task_attempt': 'RetryTaskAttempt',
        'runnable': 'Runnable',
        'running_work_orders': 'RunningWorkOrders',
        'secret': 'Secret',
        'stage': 'Stage',
        'task_error_stacks': 'TaskErrorStacks',
        'tasks': 'Tasks',
        'uuid': 'Uuid',
        'validated': 'Validated',
        'work_order_mode': 'WorkOrderMode',
        'workflow': 'Workflow',
        'workflow_complete': 'WorkflowComplete'
    }

    def __init__(self, address=None, arch=None, available=None, boot_env=None, bundle=None, context=None, created_at=None, created_by=None, current_job=None, current_task=None, description=None, endpoint=None, errors=None, fingerprint=None, hardware_addrs=None, job_exit_state=None, job_result_errors=None, job_state=None, last_modified_at=None, last_modified_by=None, locked=None, meta=None, name=None, os=None, params=None, partial=None, pending_work_orders=None, pool=None, pool_allocated=None, pool_status=None, profiles=None, read_only=None, retry_task_attempt=None, runnable=None, running_work_orders=None, secret=None, stage=None, task_error_stacks=None, tasks=None, uuid=None, validated=None, work_order_mode=None, workflow=None, workflow_complete=None, _configuration=None):  # noqa: E501
        """Cluster - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._address = None
        self._arch = None
        self._available = None
        self._boot_env = None
        self._bundle = None
        self._context = None
        self._created_at = None
        self._created_by = None
        self._current_job = None
        self._current_task = None
        self._description = None
        self._endpoint = None
        self._errors = None
        self._fingerprint = None
        self._hardware_addrs = None
        self._job_exit_state = None
        self._job_result_errors = None
        self._job_state = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._locked = None
        self._meta = None
        self._name = None
        self._os = None
        self._params = None
        self._partial = None
        self._pending_work_orders = None
        self._pool = None
        self._pool_allocated = None
        self._pool_status = None
        self._profiles = None
        self._read_only = None
        self._retry_task_attempt = None
        self._runnable = None
        self._running_work_orders = None
        self._secret = None
        self._stage = None
        self._task_error_stacks = None
        self._tasks = None
        self._uuid = None
        self._validated = None
        self._work_order_mode = None
        self._workflow = None
        self._workflow_complete = None
        self.discriminator = None

        if address is not None:
            self.address = address
        self.arch = arch
        if available is not None:
            self.available = available
        if boot_env is not None:
            self.boot_env = boot_env
        if bundle is not None:
            self.bundle = bundle
        if context is not None:
            self.context = context
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if current_job is not None:
            self.current_job = current_job
        self.current_task = current_task
        if description is not None:
            self.description = description
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        if fingerprint is not None:
            self.fingerprint = fingerprint
        if hardware_addrs is not None:
            self.hardware_addrs = hardware_addrs
        if job_exit_state is not None:
            self.job_exit_state = job_exit_state
        if job_result_errors is not None:
            self.job_result_errors = job_result_errors
        if job_state is not None:
            self.job_state = job_state
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        self.locked = locked
        if meta is not None:
            self.meta = meta
        self.name = name
        if os is not None:
            self.os = os
        if params is not None:
            self.params = params
        if partial is not None:
            self.partial = partial
        if pending_work_orders is not None:
            self.pending_work_orders = pending_work_orders
        if pool is not None:
            self.pool = pool
        if pool_allocated is not None:
            self.pool_allocated = pool_allocated
        if pool_status is not None:
            self.pool_status = pool_status
        if profiles is not None:
            self.profiles = profiles
        if read_only is not None:
            self.read_only = read_only
        if retry_task_attempt is not None:
            self.retry_task_attempt = retry_task_attempt
        if runnable is not None:
            self.runnable = runnable
        if running_work_orders is not None:
            self.running_work_orders = running_work_orders
        if secret is not None:
            self.secret = secret
        if stage is not None:
            self.stage = stage
        if task_error_stacks is not None:
            self.task_error_stacks = task_error_stacks
        if tasks is not None:
            self.tasks = tasks
        self.uuid = uuid
        if validated is not None:
            self.validated = validated
        if work_order_mode is not None:
            self.work_order_mode = work_order_mode
        self.workflow = workflow
        if workflow_complete is not None:
            self.workflow_complete = workflow_complete

    @property
    def address(self):
        """Gets the address of this Cluster.  # noqa: E501

        The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.  # noqa: E501

        :return: The address of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this Cluster.

        The IPv4 address of the machine that should be used for PXE purposes.  Note that this field does not directly tie into DHCP leases or reservations -- the provisioner relies solely on this address when determining what to render for a specific machine. Address is updated automatically by the DHCP system if HardwareAddrs is filled out.  # noqa: E501

        :param address: The address of this Cluster.  # noqa: E501
        :type: str
        """

        self._address = address

    @property
    def arch(self):
        """Gets the arch of this Cluster.  # noqa: E501

        Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.  # noqa: E501

        :return: The arch of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._arch

    @arch.setter
    def arch(self, arch):
        """Sets the arch of this Cluster.

        Arch is the machine architecture. It should be an arch that can be fed into $GOARCH.  # noqa: E501

        :param arch: The arch of this Cluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and arch is None:
            raise ValueError("Invalid value for `arch`, must not be `None`")  # noqa: E501

        self._arch = arch

    @property
    def available(self):
        """Gets the available of this Cluster.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this Cluster.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this Cluster.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def boot_env(self):
        """Gets the boot_env of this Cluster.  # noqa: E501

        The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.  # noqa: E501

        :return: The boot_env of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._boot_env

    @boot_env.setter
    def boot_env(self, boot_env):
        """Sets the boot_env of this Cluster.

        The boot environment that the machine should boot into.  This must be the name of a boot environment present in the backend. If this field is not present or blank, the global default bootenv will be used instead.  # noqa: E501

        :param boot_env: The boot_env of this Cluster.  # noqa: E501
        :type: str
        """

        self._boot_env = boot_env

    @property
    def bundle(self):
        """Gets the bundle of this Cluster.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this Cluster.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this Cluster.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def context(self):
        """Gets the context of this Cluster.  # noqa: E501

        Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.  # noqa: E501

        :return: The context of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this Cluster.

        Contexts contains the name of the current execution context. An empty string indicates that an agent running on a Machine should be executing tasks, and any other value means that an agent running with its context set for this value should be executing tasks.  # noqa: E501

        :param context: The context of this Cluster.  # noqa: E501
        :type: str
        """

        self._context = context

    @property
    def created_at(self):
        """Gets the created_at of this Cluster.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Cluster.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Cluster.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Cluster.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this Cluster.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def current_job(self):
        """Gets the current_job of this Cluster.  # noqa: E501

        The UUID of the job that is currently running.  # noqa: E501

        :return: The current_job of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._current_job

    @current_job.setter
    def current_job(self, current_job):
        """Sets the current_job of this Cluster.

        The UUID of the job that is currently running.  # noqa: E501

        :param current_job: The current_job of this Cluster.  # noqa: E501
        :type: str
        """

        self._current_job = current_job

    @property
    def current_task(self):
        """Gets the current_task of this Cluster.  # noqa: E501

        The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.  # noqa: E501

        :return: The current_task of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._current_task

    @current_task.setter
    def current_task(self, current_task):
        """Sets the current_task of this Cluster.

        The index into the Tasks list for the task that is currently running (if a task is running) or the next task that will run (if no task is currently running).  If -1, then the first task will run next, and if it is equal to the length of the Tasks list then all the tasks have finished running.  # noqa: E501

        :param current_task: The current_task of this Cluster.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and current_task is None:
            raise ValueError("Invalid value for `current_task`, must not be `None`")  # noqa: E501

        self._current_task = current_task

    @property
    def description(self):
        """Gets the description of this Cluster.  # noqa: E501

        Description is a string for providing a simple description  # noqa: E501

        :return: The description of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Cluster.

        Description is a string for providing a simple description  # noqa: E501

        :param description: The description of this Cluster.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def endpoint(self):
        """Gets the endpoint of this Cluster.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Cluster.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this Cluster.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this Cluster.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Cluster.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this Cluster.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def fingerprint(self):
        """Gets the fingerprint of this Cluster.  # noqa: E501


        :return: The fingerprint of this Cluster.  # noqa: E501
        :rtype: MachineFingerprint
        """
        return self._fingerprint

    @fingerprint.setter
    def fingerprint(self, fingerprint):
        """Sets the fingerprint of this Cluster.


        :param fingerprint: The fingerprint of this Cluster.  # noqa: E501
        :type: MachineFingerprint
        """

        self._fingerprint = fingerprint

    @property
    def hardware_addrs(self):
        """Gets the hardware_addrs of this Cluster.  # noqa: E501

        HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.  # noqa: E501

        :return: The hardware_addrs of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._hardware_addrs

    @hardware_addrs.setter
    def hardware_addrs(self, hardware_addrs):
        """Sets the hardware_addrs of this Cluster.

        HardwareAddrs is a list of MAC addresses we expect that the system might boot from. This must be filled out to enable MAC address based booting from the various bootenvs, and must be updated if the MAC addresses for a system change for whatever reason.  # noqa: E501

        :param hardware_addrs: The hardware_addrs of this Cluster.  # noqa: E501
        :type: list[str]
        """

        self._hardware_addrs = hardware_addrs

    @property
    def job_exit_state(self):
        """Gets the job_exit_state of this Cluster.  # noqa: E501

        The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on  # noqa: E501

        :return: The job_exit_state of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._job_exit_state

    @job_exit_state.setter
    def job_exit_state(self, job_exit_state):
        """Sets the job_exit_state of this Cluster.

        The final disposition of the current job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on  # noqa: E501

        :param job_exit_state: The job_exit_state of this Cluster.  # noqa: E501
        :type: str
        """

        self._job_exit_state = job_exit_state

    @property
    def job_result_errors(self):
        """Gets the job_result_errors of this Cluster.  # noqa: E501

        ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.  # noqa: E501

        :return: The job_result_errors of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._job_result_errors

    @job_result_errors.setter
    def job_result_errors(self, job_result_errors):
        """Sets the job_result_errors of this Cluster.

        ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.  # noqa: E501

        :param job_result_errors: The job_result_errors of this Cluster.  # noqa: E501
        :type: list[str]
        """

        self._job_result_errors = job_result_errors

    @property
    def job_state(self):
        """Gets the job_state of this Cluster.  # noqa: E501

        The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"  # noqa: E501

        :return: The job_state of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._job_state

    @job_state.setter
    def job_state(self, job_state):
        """Sets the job_state of this Cluster.

        The state the current job is in.  Must be one of \"created\", \"failed\", \"finished\", \"incomplete\"  # noqa: E501

        :param job_state: The job_state of this Cluster.  # noqa: E501
        :type: str
        """

        self._job_state = job_state

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this Cluster.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this Cluster.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Cluster.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Cluster.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this Cluster.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def locked(self):
        """Gets the locked of this Cluster.  # noqa: E501

        Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.  # noqa: E501

        :return: The locked of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Cluster.

        Locked indicates that changes to the Machine by users are not allowed, except for unlocking the machine, which will always generate an Audit event.  # noqa: E501

        :param locked: The locked of this Cluster.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and locked is None:
            raise ValueError("Invalid value for `locked`, must not be `None`")  # noqa: E501

        self._locked = locked

    @property
    def meta(self):
        """Gets the meta of this Cluster.  # noqa: E501


        :return: The meta of this Cluster.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Cluster.


        :param meta: The meta of this Cluster.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this Cluster.  # noqa: E501

        The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.  # noqa: E501

        :return: The name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Cluster.

        The name of the machine.  This must be unique across all machines, and by convention it is the FQDN of the machine, although nothing enforces that.  # noqa: E501

        :param name: The name of this Cluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def os(self):
        """Gets the os of this Cluster.  # noqa: E501

        OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.  # noqa: E501

        :return: The os of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this Cluster.

        OS is the operating system that the node is running in.  It is updated by Sledgehammer and by the various OS install tasks.  # noqa: E501

        :param os: The os of this Cluster.  # noqa: E501
        :type: str
        """

        self._os = os

    @property
    def params(self):
        """Gets the params of this Cluster.  # noqa: E501

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :return: The params of this Cluster.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this Cluster.

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :param params: The params of this Cluster.  # noqa: E501
        :type: dict(str, object)
        """

        self._params = params

    @property
    def partial(self):
        """Gets the partial of this Cluster.  # noqa: E501

        Partial tracks if the object is not complete when returned.  # noqa: E501

        :return: The partial of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._partial

    @partial.setter
    def partial(self, partial):
        """Sets the partial of this Cluster.

        Partial tracks if the object is not complete when returned.  # noqa: E501

        :param partial: The partial of this Cluster.  # noqa: E501
        :type: bool
        """

        self._partial = partial

    @property
    def pending_work_orders(self):
        """Gets the pending_work_orders of this Cluster.  # noqa: E501

        PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.  # noqa: E501

        :return: The pending_work_orders of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._pending_work_orders

    @pending_work_orders.setter
    def pending_work_orders(self, pending_work_orders):
        """Sets the pending_work_orders of this Cluster.

        PendingWorkOrders is the number of work orders for this Machine that are in the 'created' state.  # noqa: E501

        :param pending_work_orders: The pending_work_orders of this Cluster.  # noqa: E501
        :type: int
        """

        self._pending_work_orders = pending_work_orders

    @property
    def pool(self):
        """Gets the pool of this Cluster.  # noqa: E501

        Pool contains the pool the machine is in. Unset machines will join the default Pool  # noqa: E501

        :return: The pool of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._pool

    @pool.setter
    def pool(self, pool):
        """Sets the pool of this Cluster.

        Pool contains the pool the machine is in. Unset machines will join the default Pool  # noqa: E501

        :param pool: The pool of this Cluster.  # noqa: E501
        :type: str
        """

        self._pool = pool

    @property
    def pool_allocated(self):
        """Gets the pool_allocated of this Cluster.  # noqa: E501

        PoolAllocated defines if the machine is allocated in this pool This is a calculated field.  # noqa: E501

        :return: The pool_allocated of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._pool_allocated

    @pool_allocated.setter
    def pool_allocated(self, pool_allocated):
        """Sets the pool_allocated of this Cluster.

        PoolAllocated defines if the machine is allocated in this pool This is a calculated field.  # noqa: E501

        :param pool_allocated: The pool_allocated of this Cluster.  # noqa: E501
        :type: bool
        """

        self._pool_allocated = pool_allocated

    @property
    def pool_status(self):
        """Gets the pool_status of this Cluster.  # noqa: E501


        :return: The pool_status of this Cluster.  # noqa: E501
        :rtype: PoolStatus
        """
        return self._pool_status

    @pool_status.setter
    def pool_status(self, pool_status):
        """Sets the pool_status of this Cluster.


        :param pool_status: The pool_status of this Cluster.  # noqa: E501
        :type: PoolStatus
        """

        self._pool_status = pool_status

    @property
    def profiles(self):
        """Gets the profiles of this Cluster.  # noqa: E501

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :return: The profiles of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._profiles

    @profiles.setter
    def profiles(self, profiles):
        """Sets the profiles of this Cluster.

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :param profiles: The profiles of this Cluster.  # noqa: E501
        :type: list[str]
        """

        self._profiles = profiles

    @property
    def read_only(self):
        """Gets the read_only of this Cluster.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Cluster.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this Cluster.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def retry_task_attempt(self):
        """Gets the retry_task_attempt of this Cluster.  # noqa: E501

        This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.  # noqa: E501

        :return: The retry_task_attempt of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._retry_task_attempt

    @retry_task_attempt.setter
    def retry_task_attempt(self, retry_task_attempt):
        """Sets the retry_task_attempt of this Cluster.

        This tracks the number of retry attempts for the current task. When a task succeeds, the retry value is reset.  # noqa: E501

        :param retry_task_attempt: The retry_task_attempt of this Cluster.  # noqa: E501
        :type: int
        """

        self._retry_task_attempt = retry_task_attempt

    @property
    def runnable(self):
        """Gets the runnable of this Cluster.  # noqa: E501

        Runnable indicates that this is Runnable.  # noqa: E501

        :return: The runnable of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._runnable

    @runnable.setter
    def runnable(self, runnable):
        """Sets the runnable of this Cluster.

        Runnable indicates that this is Runnable.  # noqa: E501

        :param runnable: The runnable of this Cluster.  # noqa: E501
        :type: bool
        """

        self._runnable = runnable

    @property
    def running_work_orders(self):
        """Gets the running_work_orders of this Cluster.  # noqa: E501

        RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.  # noqa: E501

        :return: The running_work_orders of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._running_work_orders

    @running_work_orders.setter
    def running_work_orders(self, running_work_orders):
        """Sets the running_work_orders of this Cluster.

        RunningWorkOrders is the number of work orders for this Machine that are in the 'running' state.  # noqa: E501

        :param running_work_orders: The running_work_orders of this Cluster.  # noqa: E501
        :type: int
        """

        self._running_work_orders = running_work_orders

    @property
    def secret(self):
        """Gets the secret of this Cluster.  # noqa: E501

        Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine  # noqa: E501

        :return: The secret of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this Cluster.

        Secret for machine token revocation.  Changing the secret will invalidate all existing tokens for this machine  # noqa: E501

        :param secret: The secret of this Cluster.  # noqa: E501
        :type: str
        """

        self._secret = secret

    @property
    def stage(self):
        """Gets the stage of this Cluster.  # noqa: E501

        The stage that this is currently in.  # noqa: E501

        :return: The stage of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._stage

    @stage.setter
    def stage(self, stage):
        """Sets the stage of this Cluster.

        The stage that this is currently in.  # noqa: E501

        :param stage: The stage of this Cluster.  # noqa: E501
        :type: str
        """

        self._stage = stage

    @property
    def task_error_stacks(self):
        """Gets the task_error_stacks of this Cluster.  # noqa: E501

        This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.  # noqa: E501

        :return: The task_error_stacks of this Cluster.  # noqa: E501
        :rtype: list[TaskStack]
        """
        return self._task_error_stacks

    @task_error_stacks.setter
    def task_error_stacks(self, task_error_stacks):
        """Sets the task_error_stacks of this Cluster.

        This list of previous task lists and current tasks to handle errors. Upon completing the list, the previous task list will be executed.  This will be capped to a depth of 1.  Error failures can not be handled.  # noqa: E501

        :param task_error_stacks: The task_error_stacks of this Cluster.  # noqa: E501
        :type: list[TaskStack]
        """

        self._task_error_stacks = task_error_stacks

    @property
    def tasks(self):
        """Gets the tasks of this Cluster.  # noqa: E501

        The current tasks that are being processed.  # noqa: E501

        :return: The tasks of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this Cluster.

        The current tasks that are being processed.  # noqa: E501

        :param tasks: The tasks of this Cluster.  # noqa: E501
        :type: list[str]
        """

        self._tasks = tasks

    @property
    def uuid(self):
        """Gets the uuid of this Cluster.  # noqa: E501

        The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.  # noqa: E501

        :return: The uuid of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this Cluster.

        The UUID of the machine. This is auto-created at Create time, and cannot change afterwards.  # noqa: E501

        :param uuid: The uuid of this Cluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and uuid is None:
            raise ValueError("Invalid value for `uuid`, must not be `None`")  # noqa: E501

        self._uuid = uuid

    @property
    def validated(self):
        """Gets the validated of this Cluster.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this Cluster.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this Cluster.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    @property
    def work_order_mode(self):
        """Gets the work_order_mode of this Cluster.  # noqa: E501

        WorkOrderMode indicates if the machine is action mode  # noqa: E501

        :return: The work_order_mode of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._work_order_mode

    @work_order_mode.setter
    def work_order_mode(self, work_order_mode):
        """Sets the work_order_mode of this Cluster.

        WorkOrderMode indicates if the machine is action mode  # noqa: E501

        :param work_order_mode: The work_order_mode of this Cluster.  # noqa: E501
        :type: bool
        """

        self._work_order_mode = work_order_mode

    @property
    def workflow(self):
        """Gets the workflow of this Cluster.  # noqa: E501

        Workflow is the workflow that is currently responsible for processing machine tasks.  # noqa: E501

        :return: The workflow of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._workflow

    @workflow.setter
    def workflow(self, workflow):
        """Sets the workflow of this Cluster.

        Workflow is the workflow that is currently responsible for processing machine tasks.  # noqa: E501

        :param workflow: The workflow of this Cluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and workflow is None:
            raise ValueError("Invalid value for `workflow`, must not be `None`")  # noqa: E501

        self._workflow = workflow

    @property
    def workflow_complete(self):
        """Gets the workflow_complete of this Cluster.  # noqa: E501

        WorkflowComplete indicates if the workflow is complete  # noqa: E501

        :return: The workflow_complete of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._workflow_complete

    @workflow_complete.setter
    def workflow_complete(self, workflow_complete):
        """Sets the workflow_complete of this Cluster.

        WorkflowComplete indicates if the workflow is complete  # noqa: E501

        :param workflow_complete: The workflow_complete of this Cluster.  # noqa: E501
        :type: bool
        """

        self._workflow_complete = workflow_complete

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Cluster, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Cluster):
            return True

        return self.to_dict() != other.to_dict()
