# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class Job(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'Action',
        'archived': 'bool',
        'available': 'bool',
        'boot_env': 'str',
        'bundle': 'str',
        'context': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'current': 'bool',
        'current_index': 'int',
        'end_time': 'datetime',
        'endpoint': 'str',
        'errors': 'list[str]',
        'exit_state': 'str',
        'extra_claims': 'list[Claim]',
        'independent': 'bool',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'machine': 'str',
        'meta': 'Meta',
        'next_index': 'int',
        'previous': 'str',
        'read_only': 'bool',
        'result_errors': 'list[str]',
        'stage': 'str',
        'start_time': 'datetime',
        'state': 'str',
        'target_key': 'str',
        'target_prefix': 'str',
        'task': 'str',
        'token': 'str',
        'uuid': 'str',
        'validated': 'bool',
        'work_order': 'str',
        'workflow': 'str'
    }

    attribute_map = {
        'action': 'Action',
        'archived': 'Archived',
        'available': 'Available',
        'boot_env': 'BootEnv',
        'bundle': 'Bundle',
        'context': 'Context',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'current': 'Current',
        'current_index': 'CurrentIndex',
        'end_time': 'EndTime',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'exit_state': 'ExitState',
        'extra_claims': 'ExtraClaims',
        'independent': 'Independent',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'machine': 'Machine',
        'meta': 'Meta',
        'next_index': 'NextIndex',
        'previous': 'Previous',
        'read_only': 'ReadOnly',
        'result_errors': 'ResultErrors',
        'stage': 'Stage',
        'start_time': 'StartTime',
        'state': 'State',
        'target_key': 'TargetKey',
        'target_prefix': 'TargetPrefix',
        'task': 'Task',
        'token': 'Token',
        'uuid': 'Uuid',
        'validated': 'Validated',
        'work_order': 'WorkOrder',
        'workflow': 'Workflow'
    }

    def __init__(self, action=None, archived=None, available=None, boot_env=None, bundle=None, context=None, created_at=None, created_by=None, current=None, current_index=None, end_time=None, endpoint=None, errors=None, exit_state=None, extra_claims=None, independent=None, last_modified_at=None, last_modified_by=None, machine=None, meta=None, next_index=None, previous=None, read_only=None, result_errors=None, stage=None, start_time=None, state=None, target_key=None, target_prefix=None, task=None, token=None, uuid=None, validated=None, work_order=None, workflow=None, _configuration=None):  # noqa: E501
        """Job - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._action = None
        self._archived = None
        self._available = None
        self._boot_env = None
        self._bundle = None
        self._context = None
        self._created_at = None
        self._created_by = None
        self._current = None
        self._current_index = None
        self._end_time = None
        self._endpoint = None
        self._errors = None
        self._exit_state = None
        self._extra_claims = None
        self._independent = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._machine = None
        self._meta = None
        self._next_index = None
        self._previous = None
        self._read_only = None
        self._result_errors = None
        self._stage = None
        self._start_time = None
        self._state = None
        self._target_key = None
        self._target_prefix = None
        self._task = None
        self._token = None
        self._uuid = None
        self._validated = None
        self._work_order = None
        self._workflow = None
        self.discriminator = None

        if action is not None:
            self.action = action
        self.archived = archived
        if available is not None:
            self.available = available
        if boot_env is not None:
            self.boot_env = boot_env
        if bundle is not None:
            self.bundle = bundle
        if context is not None:
            self.context = context
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        self.current = current
        self.current_index = current_index
        if end_time is not None:
            self.end_time = end_time
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        if exit_state is not None:
            self.exit_state = exit_state
        if extra_claims is not None:
            self.extra_claims = extra_claims
        if independent is not None:
            self.independent = independent
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if machine is not None:
            self.machine = machine
        if meta is not None:
            self.meta = meta
        self.next_index = next_index
        if previous is not None:
            self.previous = previous
        if read_only is not None:
            self.read_only = read_only
        if result_errors is not None:
            self.result_errors = result_errors
        if stage is not None:
            self.stage = stage
        if start_time is not None:
            self.start_time = start_time
        self.state = state
        if target_key is not None:
            self.target_key = target_key
        if target_prefix is not None:
            self.target_prefix = target_prefix
        if task is not None:
            self.task = task
        if token is not None:
            self.token = token
        self.uuid = uuid
        if validated is not None:
            self.validated = validated
        if work_order is not None:
            self.work_order = work_order
        if workflow is not None:
            self.workflow = workflow

    @property
    def action(self):
        """Gets the action of this Job.  # noqa: E501


        :return: The action of this Job.  # noqa: E501
        :rtype: Action
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this Job.


        :param action: The action of this Job.  # noqa: E501
        :type: Action
        """

        self._action = action

    @property
    def archived(self):
        """Gets the archived of this Job.  # noqa: E501

        Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.  # noqa: E501

        :return: The archived of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this Job.

        Archived indicates whether the complete log for the job can be retrieved via the API.  If Archived is true, then the log cannot be retrieved.  # noqa: E501

        :param archived: The archived of this Job.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and archived is None:
            raise ValueError("Invalid value for `archived`, must not be `None`")  # noqa: E501

        self._archived = archived

    @property
    def available(self):
        """Gets the available of this Job.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this Job.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this Job.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def boot_env(self):
        """Gets the boot_env of this Job.  # noqa: E501

        The bootenv that the task was created in.  # noqa: E501

        :return: The boot_env of this Job.  # noqa: E501
        :rtype: str
        """
        return self._boot_env

    @boot_env.setter
    def boot_env(self, boot_env):
        """Sets the boot_env of this Job.

        The bootenv that the task was created in.  # noqa: E501

        :param boot_env: The boot_env of this Job.  # noqa: E501
        :type: str
        """

        self._boot_env = boot_env

    @property
    def bundle(self):
        """Gets the bundle of this Job.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this Job.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this Job.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this Job.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def context(self):
        """Gets the context of this Job.  # noqa: E501

        Context is the context the job was created to run in.  # noqa: E501

        :return: The context of this Job.  # noqa: E501
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this Job.

        Context is the context the job was created to run in.  # noqa: E501

        :param context: The context of this Job.  # noqa: E501
        :type: str
        """

        self._context = context

    @property
    def created_at(self):
        """Gets the created_at of this Job.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Job.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this Job.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Job.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this Job.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Job.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this Job.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def current(self):
        """Gets the current of this Job.  # noqa: E501

        Whether the job is the \"current one\" for the machine or if it has been superceded.  # noqa: E501

        :return: The current of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._current

    @current.setter
    def current(self, current):
        """Sets the current of this Job.

        Whether the job is the \"current one\" for the machine or if it has been superceded.  # noqa: E501

        :param current: The current of this Job.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and current is None:
            raise ValueError("Invalid value for `current`, must not be `None`")  # noqa: E501

        self._current = current

    @property
    def current_index(self):
        """Gets the current_index of this Job.  # noqa: E501

        The current index is the machine CurrentTask that created this job.  # noqa: E501

        :return: The current_index of this Job.  # noqa: E501
        :rtype: int
        """
        return self._current_index

    @current_index.setter
    def current_index(self, current_index):
        """Sets the current_index of this Job.

        The current index is the machine CurrentTask that created this job.  # noqa: E501

        :param current_index: The current_index of this Job.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and current_index is None:
            raise ValueError("Invalid value for `current_index`, must not be `None`")  # noqa: E501

        self._current_index = current_index

    @property
    def end_time(self):
        """Gets the end_time of this Job.  # noqa: E501

        The time the job failed or finished.  # noqa: E501

        :return: The end_time of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this Job.

        The time the job failed or finished.  # noqa: E501

        :param end_time: The end_time of this Job.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def endpoint(self):
        """Gets the endpoint of this Job.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this Job.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Job.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this Job.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this Job.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this Job.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Job.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this Job.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def exit_state(self):
        """Gets the exit_state of this Job.  # noqa: E501

        The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on  # noqa: E501

        :return: The exit_state of this Job.  # noqa: E501
        :rtype: str
        """
        return self._exit_state

    @exit_state.setter
    def exit_state(self, exit_state):
        """Sets the exit_state of this Job.

        The final disposition of the job. Can be one of \"reboot\",\"poweroff\",\"stop\", or \"complete\" Other substates may be added as time goes on  # noqa: E501

        :param exit_state: The exit_state of this Job.  # noqa: E501
        :type: str
        """

        self._exit_state = exit_state

    @property
    def extra_claims(self):
        """Gets the extra_claims of this Job.  # noqa: E501

        ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.  # noqa: E501

        :return: The extra_claims of this Job.  # noqa: E501
        :rtype: list[Claim]
        """
        return self._extra_claims

    @extra_claims.setter
    def extra_claims(self, extra_claims):
        """Sets the extra_claims of this Job.

        ExtraClaims is the expanded list of extra Claims that were added to the default machine Claims via the ExtraRoles field on the Task that the Job was created to run.  # noqa: E501

        :param extra_claims: The extra_claims of this Job.  # noqa: E501
        :type: list[Claim]
        """

        self._extra_claims = extra_claims

    @property
    def independent(self):
        """Gets the independent of this Job.  # noqa: E501

        Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.  # noqa: E501

        :return: The independent of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._independent

    @independent.setter
    def independent(self, independent):
        """Sets the independent of this Job.

        Independent indicates that this Job was created to track something besides a task being executed by an agent.  Most of the task state sanity checking performed by the job lifecycle checking will be skipped -- in particular, the job need not be associated with a Workorder or a Machine, it will be permitted to have multiple simultaneous Jobs in flight for the same Target, and State will be ignored for job cleanup purposes.  # noqa: E501

        :param independent: The independent of this Job.  # noqa: E501
        :type: bool
        """

        self._independent = independent

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this Job.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this Job.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this Job.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Job.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this Job.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Job.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this Job.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def machine(self):
        """Gets the machine of this Job.  # noqa: E501

        The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.  # noqa: E501

        :return: The machine of this Job.  # noqa: E501
        :rtype: str
        """
        return self._machine

    @machine.setter
    def machine(self, machine):
        """Sets the machine of this Job.

        The machine the job was created for.  This field must be the UUID of the machine. It must be set if Independent is false.  # noqa: E501

        :param machine: The machine of this Job.  # noqa: E501
        :type: str
        """

        self._machine = machine

    @property
    def meta(self):
        """Gets the meta of this Job.  # noqa: E501


        :return: The meta of this Job.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Job.


        :param meta: The meta of this Job.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def next_index(self):
        """Gets the next_index of this Job.  # noqa: E501

        The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  # noqa: E501

        :return: The next_index of this Job.  # noqa: E501
        :rtype: int
        """
        return self._next_index

    @next_index.setter
    def next_index(self, next_index):
        """Sets the next_index of this Job.

        The next task index that should be run when this job finishes.  It is used in conjunction with the machine CurrentTask to implement the server side of the machine agent state machine.  # noqa: E501

        :param next_index: The next_index of this Job.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and next_index is None:
            raise ValueError("Invalid value for `next_index`, must not be `None`")  # noqa: E501

        self._next_index = next_index

    @property
    def previous(self):
        """Gets the previous of this Job.  # noqa: E501

        The UUID of the previous job to run on this machine.  # noqa: E501

        :return: The previous of this Job.  # noqa: E501
        :rtype: str
        """
        return self._previous

    @previous.setter
    def previous(self, previous):
        """Sets the previous of this Job.

        The UUID of the previous job to run on this machine.  # noqa: E501

        :param previous: The previous of this Job.  # noqa: E501
        :type: str
        """

        self._previous = previous

    @property
    def read_only(self):
        """Gets the read_only of this Job.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Job.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this Job.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def result_errors(self):
        """Gets the result_errors of this Job.  # noqa: E501

        ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.  # noqa: E501

        :return: The result_errors of this Job.  # noqa: E501
        :rtype: list[str]
        """
        return self._result_errors

    @result_errors.setter
    def result_errors(self, result_errors):
        """Sets the result_errors of this Job.

        ResultErrors is a list of error from the task.  This is filled in by the task if it is written to do so.  This tracks results without requiring job logs.  # noqa: E501

        :param result_errors: The result_errors of this Job.  # noqa: E501
        :type: list[str]
        """

        self._result_errors = result_errors

    @property
    def stage(self):
        """Gets the stage of this Job.  # noqa: E501

        The stage that the task was created in.  # noqa: E501

        :return: The stage of this Job.  # noqa: E501
        :rtype: str
        """
        return self._stage

    @stage.setter
    def stage(self, stage):
        """Sets the stage of this Job.

        The stage that the task was created in.  # noqa: E501

        :param stage: The stage of this Job.  # noqa: E501
        :type: str
        """

        self._stage = stage

    @property
    def start_time(self):
        """Gets the start_time of this Job.  # noqa: E501

        The time the job started running.  # noqa: E501

        :return: The start_time of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this Job.

        The time the job started running.  # noqa: E501

        :param start_time: The start_time of this Job.  # noqa: E501
        :type: datetime
        """

        self._start_time = start_time

    @property
    def state(self):
        """Gets the state of this Job.  # noqa: E501

        The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"  # noqa: E501

        :return: The state of this Job.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Job.

        The state the job is in.  Must be one of \"created\", \"running\", \"failed\", \"finished\", \"incomplete\"  # noqa: E501

        :param state: The state of this Job.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def target_key(self):
        """Gets the target_key of this Job.  # noqa: E501

        TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".  # noqa: E501

        :return: The target_key of this Job.  # noqa: E501
        :rtype: str
        """
        return self._target_key

    @target_key.setter
    def target_key(self, target_key):
        """Sets the target_key of this Job.

        TargetKey is the Key of the Object that an Independent job was invoked against. It may be empty if TargetPrefix is \"system\".  # noqa: E501

        :param target_key: The target_key of this Job.  # noqa: E501
        :type: str
        """

        self._target_key = target_key

    @property
    def target_prefix(self):
        """Gets the target_prefix of this Job.  # noqa: E501

        TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.  # noqa: E501

        :return: The target_prefix of this Job.  # noqa: E501
        :rtype: str
        """
        return self._target_prefix

    @target_prefix.setter
    def target_prefix(self, target_prefix):
        """Sets the target_prefix of this Job.

        TargetPrefix is the Prefix of the Object that an Independent job was invoked against. It must be set if Independent is true.  # noqa: E501

        :param target_prefix: The target_prefix of this Job.  # noqa: E501
        :type: str
        """

        self._target_prefix = target_prefix

    @property
    def task(self):
        """Gets the task of this Job.  # noqa: E501

        The task the job was created for.  This will be the name of the task.  # noqa: E501

        :return: The task of this Job.  # noqa: E501
        :rtype: str
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this Job.

        The task the job was created for.  This will be the name of the task.  # noqa: E501

        :param task: The task of this Job.  # noqa: E501
        :type: str
        """

        self._task = task

    @property
    def token(self):
        """Gets the token of this Job.  # noqa: E501

        Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.  # noqa: E501

        :return: The token of this Job.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this Job.

        Token is the JWT token that should be used when running this Job.  If not present or empty, the Agent running the Job will use its ambient Token instead.  If set, the Token will only be valid for the current Job.  # noqa: E501

        :param token: The token of this Job.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uuid(self):
        """Gets the uuid of this Job.  # noqa: E501

        The UUID of the job.  The primary key.  # noqa: E501

        :return: The uuid of this Job.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this Job.

        The UUID of the job.  The primary key.  # noqa: E501

        :param uuid: The uuid of this Job.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and uuid is None:
            raise ValueError("Invalid value for `uuid`, must not be `None`")  # noqa: E501

        self._uuid = uuid

    @property
    def validated(self):
        """Gets the validated of this Job.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this Job.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this Job.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this Job.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    @property
    def work_order(self):
        """Gets the work_order of this Job.  # noqa: E501

        The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.  # noqa: E501

        :return: The work_order of this Job.  # noqa: E501
        :rtype: str
        """
        return self._work_order

    @work_order.setter
    def work_order(self, work_order):
        """Sets the work_order of this Job.

        The work order the job was created for.  This field must be the UUID of the work order. It must be set if Independent is false and the job is being run on behalf of a WorkOrder.  # noqa: E501

        :param work_order: The work_order of this Job.  # noqa: E501
        :type: str
        """

        self._work_order = work_order

    @property
    def workflow(self):
        """Gets the workflow of this Job.  # noqa: E501

        The workflow that the task was created in.  # noqa: E501

        :return: The workflow of this Job.  # noqa: E501
        :rtype: str
        """
        return self._workflow

    @workflow.setter
    def workflow(self, workflow):
        """Sets the workflow of this Job.

        The workflow that the task was created in.  # noqa: E501

        :param workflow: The workflow of this Job.  # noqa: E501
        :type: str
        """

        self._workflow = workflow

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Job, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Job):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Job):
            return True

        return self.to_dict() != other.to_dict()
