# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class Lease(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'addr': 'str',
        'available': 'bool',
        'bundle': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'duration': 'int',
        'endpoint': 'str',
        'errors': 'list[str]',
        'expire_time': 'datetime',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'machine_uuid': 'str',
        'meta': 'Meta',
        'next_server': 'str',
        'options': 'list[DhcpOption]',
        'provided_options': 'list[DhcpOption]',
        'read_only': 'bool',
        'skip_boot': 'bool',
        'state': 'str',
        'strategy': 'str',
        'token': 'str',
        'validated': 'bool',
        'via': 'str'
    }

    attribute_map = {
        'addr': 'Addr',
        'available': 'Available',
        'bundle': 'Bundle',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'duration': 'Duration',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'expire_time': 'ExpireTime',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'machine_uuid': 'MachineUuid',
        'meta': 'Meta',
        'next_server': 'NextServer',
        'options': 'Options',
        'provided_options': 'ProvidedOptions',
        'read_only': 'ReadOnly',
        'skip_boot': 'SkipBoot',
        'state': 'State',
        'strategy': 'Strategy',
        'token': 'Token',
        'validated': 'Validated',
        'via': 'Via'
    }

    def __init__(self, addr=None, available=None, bundle=None, created_at=None, created_by=None, duration=None, endpoint=None, errors=None, expire_time=None, last_modified_at=None, last_modified_by=None, machine_uuid=None, meta=None, next_server=None, options=None, provided_options=None, read_only=None, skip_boot=None, state=None, strategy=None, token=None, validated=None, via=None, _configuration=None):  # noqa: E501
        """Lease - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._addr = None
        self._available = None
        self._bundle = None
        self._created_at = None
        self._created_by = None
        self._duration = None
        self._endpoint = None
        self._errors = None
        self._expire_time = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._machine_uuid = None
        self._meta = None
        self._next_server = None
        self._options = None
        self._provided_options = None
        self._read_only = None
        self._skip_boot = None
        self._state = None
        self._strategy = None
        self._token = None
        self._validated = None
        self._via = None
        self.discriminator = None

        self.addr = addr
        if available is not None:
            self.available = available
        if bundle is not None:
            self.bundle = bundle
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if duration is not None:
            self.duration = duration
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        self.expire_time = expire_time
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if machine_uuid is not None:
            self.machine_uuid = machine_uuid
        if meta is not None:
            self.meta = meta
        if next_server is not None:
            self.next_server = next_server
        if options is not None:
            self.options = options
        if provided_options is not None:
            self.provided_options = provided_options
        if read_only is not None:
            self.read_only = read_only
        if skip_boot is not None:
            self.skip_boot = skip_boot
        self.state = state
        self.strategy = strategy
        self.token = token
        if validated is not None:
            self.validated = validated
        if via is not None:
            self.via = via

    @property
    def addr(self):
        """Gets the addr of this Lease.  # noqa: E501

        Addr is the IP address that the lease handed out.  # noqa: E501

        :return: The addr of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this Lease.

        Addr is the IP address that the lease handed out.  # noqa: E501

        :param addr: The addr of this Lease.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and addr is None:
            raise ValueError("Invalid value for `addr`, must not be `None`")  # noqa: E501

        self._addr = addr

    @property
    def available(self):
        """Gets the available of this Lease.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this Lease.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this Lease.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this Lease.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def bundle(self):
        """Gets the bundle of this Lease.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this Lease.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this Lease.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def created_at(self):
        """Gets the created_at of this Lease.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this Lease.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Lease.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this Lease.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Lease.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Lease.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this Lease.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def duration(self):
        """Gets the duration of this Lease.  # noqa: E501

        Duration is the time in seconds for which a lease can be valid. ExpireTime is calculated from Duration.  # noqa: E501

        :return: The duration of this Lease.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Lease.

        Duration is the time in seconds for which a lease can be valid. ExpireTime is calculated from Duration.  # noqa: E501

        :param duration: The duration of this Lease.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def endpoint(self):
        """Gets the endpoint of this Lease.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Lease.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this Lease.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this Lease.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this Lease.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Lease.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this Lease.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def expire_time(self):
        """Gets the expire_time of this Lease.  # noqa: E501

        ExpireTime is the time at which the lease expires and is no longer valid The DHCP renewal time will be half this, and the DHCP rebind time will be three quarters of this.  # noqa: E501

        :return: The expire_time of this Lease.  # noqa: E501
        :rtype: datetime
        """
        return self._expire_time

    @expire_time.setter
    def expire_time(self, expire_time):
        """Sets the expire_time of this Lease.

        ExpireTime is the time at which the lease expires and is no longer valid The DHCP renewal time will be half this, and the DHCP rebind time will be three quarters of this.  # noqa: E501

        :param expire_time: The expire_time of this Lease.  # noqa: E501
        :type: datetime
        """
        if self._configuration.client_side_validation and expire_time is None:
            raise ValueError("Invalid value for `expire_time`, must not be `None`")  # noqa: E501

        self._expire_time = expire_time

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this Lease.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this Lease.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this Lease.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this Lease.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Lease.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Lease.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this Lease.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def machine_uuid(self):
        """Gets the machine_uuid of this Lease.  # noqa: E501

        MachineUuid is set when the lease is created on a machine object only.  # noqa: E501

        :return: The machine_uuid of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._machine_uuid

    @machine_uuid.setter
    def machine_uuid(self, machine_uuid):
        """Sets the machine_uuid of this Lease.

        MachineUuid is set when the lease is created on a machine object only.  # noqa: E501

        :param machine_uuid: The machine_uuid of this Lease.  # noqa: E501
        :type: str
        """

        self._machine_uuid = machine_uuid

    @property
    def meta(self):
        """Gets the meta of this Lease.  # noqa: E501


        :return: The meta of this Lease.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Lease.


        :param meta: The meta of this Lease.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def next_server(self):
        """Gets the next_server of this Lease.  # noqa: E501

        NextServer is the IP address that we should have the machine talk to next.  In most cases, this will be our address.  # noqa: E501

        :return: The next_server of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._next_server

    @next_server.setter
    def next_server(self, next_server):
        """Sets the next_server of this Lease.

        NextServer is the IP address that we should have the machine talk to next.  In most cases, this will be our address.  # noqa: E501

        :param next_server: The next_server of this Lease.  # noqa: E501
        :type: str
        """

        self._next_server = next_server

    @property
    def options(self):
        """Gets the options of this Lease.  # noqa: E501

        Options are the DHCP options that the Lease is running with.  # noqa: E501

        :return: The options of this Lease.  # noqa: E501
        :rtype: list[DhcpOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Lease.

        Options are the DHCP options that the Lease is running with.  # noqa: E501

        :param options: The options of this Lease.  # noqa: E501
        :type: list[DhcpOption]
        """

        self._options = options

    @property
    def provided_options(self):
        """Gets the provided_options of this Lease.  # noqa: E501

        ProvidedOptions are the DHCP options the last Discover or Offer packet for this lease provided to us.  # noqa: E501

        :return: The provided_options of this Lease.  # noqa: E501
        :rtype: list[DhcpOption]
        """
        return self._provided_options

    @provided_options.setter
    def provided_options(self, provided_options):
        """Sets the provided_options of this Lease.

        ProvidedOptions are the DHCP options the last Discover or Offer packet for this lease provided to us.  # noqa: E501

        :param provided_options: The provided_options of this Lease.  # noqa: E501
        :type: list[DhcpOption]
        """

        self._provided_options = provided_options

    @property
    def read_only(self):
        """Gets the read_only of this Lease.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this Lease.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Lease.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this Lease.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def skip_boot(self):
        """Gets the skip_boot of this Lease.  # noqa: E501

        SkipBoot indicates that the DHCP system is allowed to offer boot options for whatever boot protocol the machine wants to use.  # noqa: E501

        :return: The skip_boot of this Lease.  # noqa: E501
        :rtype: bool
        """
        return self._skip_boot

    @skip_boot.setter
    def skip_boot(self, skip_boot):
        """Sets the skip_boot of this Lease.

        SkipBoot indicates that the DHCP system is allowed to offer boot options for whatever boot protocol the machine wants to use.  # noqa: E501

        :param skip_boot: The skip_boot of this Lease.  # noqa: E501
        :type: bool
        """

        self._skip_boot = skip_boot

    @property
    def state(self):
        """Gets the state of this Lease.  # noqa: E501

        State is the current state of the lease.  This field is for informational purposes only.  # noqa: E501

        :return: The state of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Lease.

        State is the current state of the lease.  This field is for informational purposes only.  # noqa: E501

        :param state: The state of this Lease.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def strategy(self):
        """Gets the strategy of this Lease.  # noqa: E501

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :return: The strategy of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """Sets the strategy of this Lease.

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :param strategy: The strategy of this Lease.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and strategy is None:
            raise ValueError("Invalid value for `strategy`, must not be `None`")  # noqa: E501

        self._strategy = strategy

    @property
    def token(self):
        """Gets the token of this Lease.  # noqa: E501

        Token is the unique token for this lease based on the Strategy this lease used.  # noqa: E501

        :return: The token of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this Lease.

        Token is the unique token for this lease based on the Strategy this lease used.  # noqa: E501

        :param token: The token of this Lease.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and token is None:
            raise ValueError("Invalid value for `token`, must not be `None`")  # noqa: E501

        self._token = token

    @property
    def validated(self):
        """Gets the validated of this Lease.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this Lease.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this Lease.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this Lease.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    @property
    def via(self):
        """Gets the via of this Lease.  # noqa: E501

        Via is the IP address used to select which subnet the lease belongs to. It is either an address present on a local interface that dr-provision is listening on, or the GIADDR field of the DHCP request.  # noqa: E501

        :return: The via of this Lease.  # noqa: E501
        :rtype: str
        """
        return self._via

    @via.setter
    def via(self, via):
        """Sets the via of this Lease.

        Via is the IP address used to select which subnet the lease belongs to. It is either an address present on a local interface that dr-provision is listening on, or the GIADDR field of the DHCP request.  # noqa: E501

        :param via: The via of this Lease.  # noqa: E501
        :type: str
        """

        self._via = via

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Lease, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Lease):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Lease):
            return True

        return self.to_dict() != other.to_dict()
