# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class NodeInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_url': 'str',
        'consensus_addr': 'str',
        'consensus_id': 'str',
        'last_artifact_commit_handled': 'int',
        'last_conn_time': 'datetime',
        'observer': 'bool',
        'offline': 'bool',
        'passive': 'bool',
        'sha_sum': 'list[int]',
        'version': 'str',
        'virt_interface': 'str',
        'virt_interface_script': 'str'
    }

    attribute_map = {
        'api_url': 'ApiUrl',
        'consensus_addr': 'ConsensusAddr',
        'consensus_id': 'ConsensusID',
        'last_artifact_commit_handled': 'LastArtifactCommitHandled',
        'last_conn_time': 'LastConnTime',
        'observer': 'Observer',
        'offline': 'Offline',
        'passive': 'Passive',
        'sha_sum': 'ShaSum',
        'version': 'Version',
        'virt_interface': 'VirtInterface',
        'virt_interface_script': 'VirtInterfaceScript'
    }

    def __init__(self, api_url=None, consensus_addr=None, consensus_id=None, last_artifact_commit_handled=None, last_conn_time=None, observer=None, offline=None, passive=None, sha_sum=None, version=None, virt_interface=None, virt_interface_script=None, _configuration=None):  # noqa: E501
        """NodeInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._api_url = None
        self._consensus_addr = None
        self._consensus_id = None
        self._last_artifact_commit_handled = None
        self._last_conn_time = None
        self._observer = None
        self._offline = None
        self._passive = None
        self._sha_sum = None
        self._version = None
        self._virt_interface = None
        self._virt_interface_script = None
        self.discriminator = None

        if api_url is not None:
            self.api_url = api_url
        if consensus_addr is not None:
            self.consensus_addr = consensus_addr
        if consensus_id is not None:
            self.consensus_id = consensus_id
        if last_artifact_commit_handled is not None:
            self.last_artifact_commit_handled = last_artifact_commit_handled
        if last_conn_time is not None:
            self.last_conn_time = last_conn_time
        if observer is not None:
            self.observer = observer
        if offline is not None:
            self.offline = offline
        if passive is not None:
            self.passive = passive
        if sha_sum is not None:
            self.sha_sum = sha_sum
        if version is not None:
            self.version = version
        if virt_interface is not None:
            self.virt_interface = virt_interface
        if virt_interface_script is not None:
            self.virt_interface_script = virt_interface_script

    @property
    def api_url(self):
        """Gets the api_url of this NodeInfo.  # noqa: E501

        ApiUrl is the URL that can be used to contact this node's API directly.  # noqa: E501

        :return: The api_url of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._api_url

    @api_url.setter
    def api_url(self, api_url):
        """Sets the api_url of this NodeInfo.

        ApiUrl is the URL that can be used to contact this node's API directly.  # noqa: E501

        :param api_url: The api_url of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._api_url = api_url

    @property
    def consensus_addr(self):
        """Gets the consensus_addr of this NodeInfo.  # noqa: E501

        ConsensusAddr is the addr:port that other nodes should attempt to contact this node no when operating in consensus mode.  All communication over these ports will be secured using TLS 1.3 using per-node short-lived certs signed by the certs in the global Roots field.  # noqa: E501

        :return: The consensus_addr of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._consensus_addr

    @consensus_addr.setter
    def consensus_addr(self, consensus_addr):
        """Sets the consensus_addr of this NodeInfo.

        ConsensusAddr is the addr:port that other nodes should attempt to contact this node no when operating in consensus mode.  All communication over these ports will be secured using TLS 1.3 using per-node short-lived certs signed by the certs in the global Roots field.  # noqa: E501

        :param consensus_addr: The consensus_addr of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._consensus_addr = consensus_addr

    @property
    def consensus_id(self):
        """Gets the consensus_id of this NodeInfo.  # noqa: E501

        ConsensusID us the unique autogenerated ID for this node. Once set, it must not be changed, or else other nodes in a cluster will not recognize this node.  # noqa: E501

        :return: The consensus_id of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._consensus_id

    @consensus_id.setter
    def consensus_id(self, consensus_id):
        """Sets the consensus_id of this NodeInfo.

        ConsensusID us the unique autogenerated ID for this node. Once set, it must not be changed, or else other nodes in a cluster will not recognize this node.  # noqa: E501

        :param consensus_id: The consensus_id of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._consensus_id = consensus_id

    @property
    def last_artifact_commit_handled(self):
        """Gets the last_artifact_commit_handled of this NodeInfo.  # noqa: E501

        LastArtifactCommitHandled tracks how up to date a node is compared to the current cluster leader.  Artifact handling is allowed to happen asynchronusly from the rest of Raft based replication due to the potentially large size of artifacts.  In the event of a leadership transfer, the first node that is not Offline with the highest LastArtifactCommitHandled value will be chosen as the new cluster leader.  If that node is not also an Observer, it will become the new active dr-provision node.  If it is an Observer, it will wait for one of the operating Passive nodes to catch up to it, and then transfer leadership to it.  # noqa: E501

        :return: The last_artifact_commit_handled of this NodeInfo.  # noqa: E501
        :rtype: int
        """
        return self._last_artifact_commit_handled

    @last_artifact_commit_handled.setter
    def last_artifact_commit_handled(self, last_artifact_commit_handled):
        """Sets the last_artifact_commit_handled of this NodeInfo.

        LastArtifactCommitHandled tracks how up to date a node is compared to the current cluster leader.  Artifact handling is allowed to happen asynchronusly from the rest of Raft based replication due to the potentially large size of artifacts.  In the event of a leadership transfer, the first node that is not Offline with the highest LastArtifactCommitHandled value will be chosen as the new cluster leader.  If that node is not also an Observer, it will become the new active dr-provision node.  If it is an Observer, it will wait for one of the operating Passive nodes to catch up to it, and then transfer leadership to it.  # noqa: E501

        :param last_artifact_commit_handled: The last_artifact_commit_handled of this NodeInfo.  # noqa: E501
        :type: int
        """

        self._last_artifact_commit_handled = last_artifact_commit_handled

    @property
    def last_conn_time(self):
        """Gets the last_conn_time of this NodeInfo.  # noqa: E501

        LastConnTime is the last time the leader was able to dial this node.  # noqa: E501

        :return: The last_conn_time of this NodeInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._last_conn_time

    @last_conn_time.setter
    def last_conn_time(self, last_conn_time):
        """Sets the last_conn_time of this NodeInfo.

        LastConnTime is the last time the leader was able to dial this node.  # noqa: E501

        :param last_conn_time: The last_conn_time of this NodeInfo.  # noqa: E501
        :type: datetime
        """

        self._last_conn_time = last_conn_time

    @property
    def observer(self):
        """Gets the observer of this NodeInfo.  # noqa: E501

        Observer indicates that this node cannot become the active node.  It is used when a node should act as a live backup and a consensus tiebreaker.  # noqa: E501

        :return: The observer of this NodeInfo.  # noqa: E501
        :rtype: bool
        """
        return self._observer

    @observer.setter
    def observer(self, observer):
        """Sets the observer of this NodeInfo.

        Observer indicates that this node cannot become the active node.  It is used when a node should act as a live backup and a consensus tiebreaker.  # noqa: E501

        :param observer: The observer of this NodeInfo.  # noqa: E501
        :type: bool
        """

        self._observer = observer

    @property
    def offline(self):
        """Gets the offline of this NodeInfo.  # noqa: E501

        Offline indicates that leadership could not be transferred to this node in the most recent election, despite it being the best candidate. If a node is marks as Offline, it will stay that way until the node updates its state with the current leader.  # noqa: E501

        :return: The offline of this NodeInfo.  # noqa: E501
        :rtype: bool
        """
        return self._offline

    @offline.setter
    def offline(self, offline):
        """Sets the offline of this NodeInfo.

        Offline indicates that leadership could not be transferred to this node in the most recent election, despite it being the best candidate. If a node is marks as Offline, it will stay that way until the node updates its state with the current leader.  # noqa: E501

        :param offline: The offline of this NodeInfo.  # noqa: E501
        :type: bool
        """

        self._offline = offline

    @property
    def passive(self):
        """Gets the passive of this NodeInfo.  # noqa: E501

        Passive indicates that this node is not responsible for handling client connections or writes via the API.  # noqa: E501

        :return: The passive of this NodeInfo.  # noqa: E501
        :rtype: bool
        """
        return self._passive

    @passive.setter
    def passive(self, passive):
        """Sets the passive of this NodeInfo.

        Passive indicates that this node is not responsible for handling client connections or writes via the API.  # noqa: E501

        :param passive: The passive of this NodeInfo.  # noqa: E501
        :type: bool
        """

        self._passive = passive

    @property
    def sha_sum(self):
        """Gets the sha_sum of this NodeInfo.  # noqa: E501

        ShaSum is the SHA256 checksum of the running dr-provision binary on the node.  # noqa: E501

        :return: The sha_sum of this NodeInfo.  # noqa: E501
        :rtype: list[int]
        """
        return self._sha_sum

    @sha_sum.setter
    def sha_sum(self, sha_sum):
        """Sets the sha_sum of this NodeInfo.

        ShaSum is the SHA256 checksum of the running dr-provision binary on the node.  # noqa: E501

        :param sha_sum: The sha_sum of this NodeInfo.  # noqa: E501
        :type: list[int]
        """

        self._sha_sum = sha_sum

    @property
    def version(self):
        """Gets the version of this NodeInfo.  # noqa: E501

        Version is the full version of dr-provision that is running on the node.  # noqa: E501

        :return: The version of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this NodeInfo.

        Version is the full version of dr-provision that is running on the node.  # noqa: E501

        :param version: The version of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def virt_interface(self):
        """Gets the virt_interface of this NodeInfo.  # noqa: E501

        VirtInterface is the network interface that the global VirtAddr will be added on when this node si the active node, and removed from when this node is no longer the active node.  # noqa: E501

        :return: The virt_interface of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._virt_interface

    @virt_interface.setter
    def virt_interface(self, virt_interface):
        """Sets the virt_interface of this NodeInfo.

        VirtInterface is the network interface that the global VirtAddr will be added on when this node si the active node, and removed from when this node is no longer the active node.  # noqa: E501

        :param virt_interface: The virt_interface of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._virt_interface = virt_interface

    @property
    def virt_interface_script(self):
        """Gets the virt_interface_script of this NodeInfo.  # noqa: E501

        VirtInterfaceScript will be called whenever VirtAddr must be added or removed from VirtInterface.  If empty, a default set of scripts will be sued that are appropriate to the OS type dr-provision is running on.  # noqa: E501

        :return: The virt_interface_script of this NodeInfo.  # noqa: E501
        :rtype: str
        """
        return self._virt_interface_script

    @virt_interface_script.setter
    def virt_interface_script(self, virt_interface_script):
        """Sets the virt_interface_script of this NodeInfo.

        VirtInterfaceScript will be called whenever VirtAddr must be added or removed from VirtInterface.  If empty, a default set of scripts will be sued that are appropriate to the OS type dr-provision is running on.  # noqa: E501

        :param virt_interface_script: The virt_interface_script of this NodeInfo.  # noqa: E501
        :type: str
        """

        self._virt_interface_script = virt_interface_script

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NodeInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NodeInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NodeInfo):
            return True

        return self.to_dict() != other.to_dict()
