# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class OsInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'codename': 'str',
        'family': 'str',
        'iso_file': 'str',
        'iso_sha256': 'str',
        'iso_url': 'str',
        'name': 'str',
        'supported_architectures': 'dict(str, ArchInfo)',
        'version': 'str'
    }

    attribute_map = {
        'codename': 'Codename',
        'family': 'Family',
        'iso_file': 'IsoFile',
        'iso_sha256': 'IsoSha256',
        'iso_url': 'IsoUrl',
        'name': 'Name',
        'supported_architectures': 'SupportedArchitectures',
        'version': 'Version'
    }

    def __init__(self, codename=None, family=None, iso_file=None, iso_sha256=None, iso_url=None, name=None, supported_architectures=None, version=None, _configuration=None):  # noqa: E501
        """OsInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._codename = None
        self._family = None
        self._iso_file = None
        self._iso_sha256 = None
        self._iso_url = None
        self._name = None
        self._supported_architectures = None
        self._version = None
        self.discriminator = None

        if codename is not None:
            self.codename = codename
        if family is not None:
            self.family = family
        if iso_file is not None:
            self.iso_file = iso_file
        if iso_sha256 is not None:
            self.iso_sha256 = iso_sha256
        if iso_url is not None:
            self.iso_url = iso_url
        self.name = name
        if supported_architectures is not None:
            self.supported_architectures = supported_architectures
        if version is not None:
            self.version = version

    @property
    def codename(self):
        """Gets the codename of this OsInfo.  # noqa: E501

        The codename of the OS, if any.  # noqa: E501

        :return: The codename of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._codename

    @codename.setter
    def codename(self, codename):
        """Sets the codename of this OsInfo.

        The codename of the OS, if any.  # noqa: E501

        :param codename: The codename of this OsInfo.  # noqa: E501
        :type: str
        """

        self._codename = codename

    @property
    def family(self):
        """Gets the family of this OsInfo.  # noqa: E501

        The family of operating system (linux distro lineage, etc)  # noqa: E501

        :return: The family of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._family

    @family.setter
    def family(self, family):
        """Sets the family of this OsInfo.

        The family of operating system (linux distro lineage, etc)  # noqa: E501

        :param family: The family of this OsInfo.  # noqa: E501
        :type: str
        """

        self._family = family

    @property
    def iso_file(self):
        """Gets the iso_file of this OsInfo.  # noqa: E501

        The name of the ISO that the OS should install from.  If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :return: The iso_file of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._iso_file

    @iso_file.setter
    def iso_file(self, iso_file):
        """Sets the iso_file of this OsInfo.

        The name of the ISO that the OS should install from.  If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :param iso_file: The iso_file of this OsInfo.  # noqa: E501
        :type: str
        """

        self._iso_file = iso_file

    @property
    def iso_sha256(self):
        """Gets the iso_sha256 of this OsInfo.  # noqa: E501

        The SHA256 of the ISO file.  Used to check for corrupt downloads. If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :return: The iso_sha256 of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._iso_sha256

    @iso_sha256.setter
    def iso_sha256(self, iso_sha256):
        """Sets the iso_sha256 of this OsInfo.

        The SHA256 of the ISO file.  Used to check for corrupt downloads. If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :param iso_sha256: The iso_sha256 of this OsInfo.  # noqa: E501
        :type: str
        """

        self._iso_sha256 = iso_sha256

    @property
    def iso_url(self):
        """Gets the iso_url of this OsInfo.  # noqa: E501

        The URL that the ISO can be downloaded from, if any.  If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :return: The iso_url of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._iso_url

    @iso_url.setter
    def iso_url(self, iso_url):
        """Sets the iso_url of this OsInfo.

        The URL that the ISO can be downloaded from, if any.  If non-empty, this is assumed to be for the amd64 hardware architecture.  # noqa: E501

        :param iso_url: The iso_url of this OsInfo.  # noqa: E501
        :type: str
        """

        self._iso_url = iso_url

    @property
    def name(self):
        """Gets the name of this OsInfo.  # noqa: E501

        The name of the OS this BootEnv has.  It should be formatted as family-version.  # noqa: E501

        :return: The name of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OsInfo.

        The name of the OS this BootEnv has.  It should be formatted as family-version.  # noqa: E501

        :param name: The name of this OsInfo.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def supported_architectures(self):
        """Gets the supported_architectures of this OsInfo.  # noqa: E501

        SupportedArchitectures maps from hardware architecture (named according to the distro architecture naming scheme) to the architecture-specific parameters for this OS.  If SupportedArchitectures is left empty, then the system assumes that the BootEnv only supports amd64 platforms.  # noqa: E501

        :return: The supported_architectures of this OsInfo.  # noqa: E501
        :rtype: dict(str, ArchInfo)
        """
        return self._supported_architectures

    @supported_architectures.setter
    def supported_architectures(self, supported_architectures):
        """Sets the supported_architectures of this OsInfo.

        SupportedArchitectures maps from hardware architecture (named according to the distro architecture naming scheme) to the architecture-specific parameters for this OS.  If SupportedArchitectures is left empty, then the system assumes that the BootEnv only supports amd64 platforms.  # noqa: E501

        :param supported_architectures: The supported_architectures of this OsInfo.  # noqa: E501
        :type: dict(str, ArchInfo)
        """

        self._supported_architectures = supported_architectures

    @property
    def version(self):
        """Gets the version of this OsInfo.  # noqa: E501

        The version of the OS, if any.  # noqa: E501

        :return: The version of this OsInfo.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this OsInfo.

        The version of the OS, if any.  # noqa: E501

        :param version: The version of this OsInfo.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OsInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OsInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OsInfo):
            return True

        return self.to_dict() != other.to_dict()
