# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class PluginProvider(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auto_start': 'bool',
        'available_actions': 'list[AvailableAction]',
        'content': 'str',
        'documentation': 'str',
        'has_publish': 'bool',
        'meta': 'Meta',
        'name': 'str',
        'optional_params': 'list[str]',
        'plugin_version': 'int',
        'required_params': 'list[str]',
        'store_objects': 'dict(str, object)',
        'version': 'str'
    }

    attribute_map = {
        'auto_start': 'AutoStart',
        'available_actions': 'AvailableActions',
        'content': 'Content',
        'documentation': 'Documentation',
        'has_publish': 'HasPublish',
        'meta': 'Meta',
        'name': 'Name',
        'optional_params': 'OptionalParams',
        'plugin_version': 'PluginVersion',
        'required_params': 'RequiredParams',
        'store_objects': 'StoreObjects',
        'version': 'Version'
    }

    def __init__(self, auto_start=None, available_actions=None, content=None, documentation=None, has_publish=None, meta=None, name=None, optional_params=None, plugin_version=None, required_params=None, store_objects=None, version=None, _configuration=None):  # noqa: E501
        """PluginProvider - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._auto_start = None
        self._available_actions = None
        self._content = None
        self._documentation = None
        self._has_publish = None
        self._meta = None
        self._name = None
        self._optional_params = None
        self._plugin_version = None
        self._required_params = None
        self._store_objects = None
        self._version = None
        self.discriminator = None

        if auto_start is not None:
            self.auto_start = auto_start
        if available_actions is not None:
            self.available_actions = available_actions
        if content is not None:
            self.content = content
        if documentation is not None:
            self.documentation = documentation
        if has_publish is not None:
            self.has_publish = has_publish
        if meta is not None:
            self.meta = meta
        if name is not None:
            self.name = name
        if optional_params is not None:
            self.optional_params = optional_params
        if plugin_version is not None:
            self.plugin_version = plugin_version
        if required_params is not None:
            self.required_params = required_params
        if store_objects is not None:
            self.store_objects = store_objects
        if version is not None:
            self.version = version

    @property
    def auto_start(self):
        """Gets the auto_start of this PluginProvider.  # noqa: E501

        If AutoStart is true, a Plugin will be created for this Provider at provider definition time, if one is not already present.  # noqa: E501

        :return: The auto_start of this PluginProvider.  # noqa: E501
        :rtype: bool
        """
        return self._auto_start

    @auto_start.setter
    def auto_start(self, auto_start):
        """Sets the auto_start of this PluginProvider.

        If AutoStart is true, a Plugin will be created for this Provider at provider definition time, if one is not already present.  # noqa: E501

        :param auto_start: The auto_start of this PluginProvider.  # noqa: E501
        :type: bool
        """

        self._auto_start = auto_start

    @property
    def available_actions(self):
        """Gets the available_actions of this PluginProvider.  # noqa: E501

        AvailableActions lists the actions that this PluginProvider can take.  # noqa: E501

        :return: The available_actions of this PluginProvider.  # noqa: E501
        :rtype: list[AvailableAction]
        """
        return self._available_actions

    @available_actions.setter
    def available_actions(self, available_actions):
        """Sets the available_actions of this PluginProvider.

        AvailableActions lists the actions that this PluginProvider can take.  # noqa: E501

        :param available_actions: The available_actions of this PluginProvider.  # noqa: E501
        :type: list[AvailableAction]
        """

        self._available_actions = available_actions

    @property
    def content(self):
        """Gets the content of this PluginProvider.  # noqa: E501

        Content Bundle Yaml string - can be optional or empty  # noqa: E501

        :return: The content of this PluginProvider.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this PluginProvider.

        Content Bundle Yaml string - can be optional or empty  # noqa: E501

        :param content: The content of this PluginProvider.  # noqa: E501
        :type: str
        """

        self._content = content

    @property
    def documentation(self):
        """Gets the documentation of this PluginProvider.  # noqa: E501

        Documentation of this plugin provider.  This should tell what the plugin provider is for, any special considerations that should be taken into account when using it, etc. in rich structured text (rst).  # noqa: E501

        :return: The documentation of this PluginProvider.  # noqa: E501
        :rtype: str
        """
        return self._documentation

    @documentation.setter
    def documentation(self, documentation):
        """Sets the documentation of this PluginProvider.

        Documentation of this plugin provider.  This should tell what the plugin provider is for, any special considerations that should be taken into account when using it, etc. in rich structured text (rst).  # noqa: E501

        :param documentation: The documentation of this PluginProvider.  # noqa: E501
        :type: str
        """

        self._documentation = documentation

    @property
    def has_publish(self):
        """Gets the has_publish of this PluginProvider.  # noqa: E501

        HasPlugin is deprecated, plugin provider binaries should use a websocket event stream instead.  # noqa: E501

        :return: The has_publish of this PluginProvider.  # noqa: E501
        :rtype: bool
        """
        return self._has_publish

    @has_publish.setter
    def has_publish(self, has_publish):
        """Sets the has_publish of this PluginProvider.

        HasPlugin is deprecated, plugin provider binaries should use a websocket event stream instead.  # noqa: E501

        :param has_publish: The has_publish of this PluginProvider.  # noqa: E501
        :type: bool
        """

        self._has_publish = has_publish

    @property
    def meta(self):
        """Gets the meta of this PluginProvider.  # noqa: E501


        :return: The meta of this PluginProvider.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this PluginProvider.


        :param meta: The meta of this PluginProvider.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this PluginProvider.  # noqa: E501

        Name is the unique name of the PluginProvider. Each Plugin provider must have a unique Name.  # noqa: E501

        :return: The name of this PluginProvider.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PluginProvider.

        Name is the unique name of the PluginProvider. Each Plugin provider must have a unique Name.  # noqa: E501

        :param name: The name of this PluginProvider.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def optional_params(self):
        """Gets the optional_params of this PluginProvider.  # noqa: E501

        OptionalParams are Params that can be present on a Plugin for the Provider to operate.  This is used to ensure default parameters are available.  # noqa: E501

        :return: The optional_params of this PluginProvider.  # noqa: E501
        :rtype: list[str]
        """
        return self._optional_params

    @optional_params.setter
    def optional_params(self, optional_params):
        """Sets the optional_params of this PluginProvider.

        OptionalParams are Params that can be present on a Plugin for the Provider to operate.  This is used to ensure default parameters are available.  # noqa: E501

        :param optional_params: The optional_params of this PluginProvider.  # noqa: E501
        :type: list[str]
        """

        self._optional_params = optional_params

    @property
    def plugin_version(self):
        """Gets the plugin_version of this PluginProvider.  # noqa: E501

        This is used to indicate what version the plugin is built for This is effectively the API version of the protocol that plugin providers use to communicate with dr-provision. Right now, all plugin providers must set this to version 4, which is the only supported protocol version.  # noqa: E501

        :return: The plugin_version of this PluginProvider.  # noqa: E501
        :rtype: int
        """
        return self._plugin_version

    @plugin_version.setter
    def plugin_version(self, plugin_version):
        """Sets the plugin_version of this PluginProvider.

        This is used to indicate what version the plugin is built for This is effectively the API version of the protocol that plugin providers use to communicate with dr-provision. Right now, all plugin providers must set this to version 4, which is the only supported protocol version.  # noqa: E501

        :param plugin_version: The plugin_version of this PluginProvider.  # noqa: E501
        :type: int
        """

        self._plugin_version = plugin_version

    @property
    def required_params(self):
        """Gets the required_params of this PluginProvider.  # noqa: E501

        RequiredParams are Params that must be present on a Plugin for the Provider to operate.  # noqa: E501

        :return: The required_params of this PluginProvider.  # noqa: E501
        :rtype: list[str]
        """
        return self._required_params

    @required_params.setter
    def required_params(self, required_params):
        """Sets the required_params of this PluginProvider.

        RequiredParams are Params that must be present on a Plugin for the Provider to operate.  # noqa: E501

        :param required_params: The required_params of this PluginProvider.  # noqa: E501
        :type: list[str]
        """

        self._required_params = required_params

    @property
    def store_objects(self):
        """Gets the store_objects of this PluginProvider.  # noqa: E501

        Object prefixes that can be accessed by this plugin. The interface can be empty struct{} or a JSONSchema draft v4 This allows PluginProviders to define custom Object types that dr-provision will store and check the validity of.  # noqa: E501

        :return: The store_objects of this PluginProvider.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._store_objects

    @store_objects.setter
    def store_objects(self, store_objects):
        """Sets the store_objects of this PluginProvider.

        Object prefixes that can be accessed by this plugin. The interface can be empty struct{} or a JSONSchema draft v4 This allows PluginProviders to define custom Object types that dr-provision will store and check the validity of.  # noqa: E501

        :param store_objects: The store_objects of this PluginProvider.  # noqa: E501
        :type: dict(str, object)
        """

        self._store_objects = store_objects

    @property
    def version(self):
        """Gets the version of this PluginProvider.  # noqa: E501

        The version of the PluginProvider.  This is a semver compatible string.  # noqa: E501

        :return: The version of this PluginProvider.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this PluginProvider.

        The version of the PluginProvider.  This is a semver compatible string.  # noqa: E501

        :param version: The version of this PluginProvider.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PluginProvider, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PluginProvider):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PluginProvider):
            return True

        return self.to_dict() != other.to_dict()
