# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class Reservation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'addr': 'str',
        'allocated': 'bool',
        'available': 'bool',
        'bundle': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'description': 'str',
        'documentation': 'str',
        'duration': 'int',
        'endpoint': 'str',
        'errors': 'list[str]',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'machine': 'str',
        'meta': 'Meta',
        'next_server': 'str',
        'options': 'list[DhcpOption]',
        'parameter': 'str',
        'params': 'dict(str, object)',
        'prefix_parameter': 'str',
        'profiles': 'list[str]',
        'read_only': 'bool',
        'scoped': 'bool',
        'skip_dad': 'bool',
        'strategy': 'str',
        'subnet': 'str',
        'token': 'str',
        'validated': 'bool'
    }

    attribute_map = {
        'addr': 'Addr',
        'allocated': 'Allocated',
        'available': 'Available',
        'bundle': 'Bundle',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'description': 'Description',
        'documentation': 'Documentation',
        'duration': 'Duration',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'machine': 'Machine',
        'meta': 'Meta',
        'next_server': 'NextServer',
        'options': 'Options',
        'parameter': 'Parameter',
        'params': 'Params',
        'prefix_parameter': 'PrefixParameter',
        'profiles': 'Profiles',
        'read_only': 'ReadOnly',
        'scoped': 'Scoped',
        'skip_dad': 'SkipDAD',
        'strategy': 'Strategy',
        'subnet': 'Subnet',
        'token': 'Token',
        'validated': 'Validated'
    }

    def __init__(self, addr=None, allocated=None, available=None, bundle=None, created_at=None, created_by=None, description=None, documentation=None, duration=None, endpoint=None, errors=None, last_modified_at=None, last_modified_by=None, machine=None, meta=None, next_server=None, options=None, parameter=None, params=None, prefix_parameter=None, profiles=None, read_only=None, scoped=None, skip_dad=None, strategy=None, subnet=None, token=None, validated=None, _configuration=None):  # noqa: E501
        """Reservation - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._addr = None
        self._allocated = None
        self._available = None
        self._bundle = None
        self._created_at = None
        self._created_by = None
        self._description = None
        self._documentation = None
        self._duration = None
        self._endpoint = None
        self._errors = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._machine = None
        self._meta = None
        self._next_server = None
        self._options = None
        self._parameter = None
        self._params = None
        self._prefix_parameter = None
        self._profiles = None
        self._read_only = None
        self._scoped = None
        self._skip_dad = None
        self._strategy = None
        self._subnet = None
        self._token = None
        self._validated = None
        self.discriminator = None

        self.addr = addr
        if allocated is not None:
            self.allocated = allocated
        if available is not None:
            self.available = available
        if bundle is not None:
            self.bundle = bundle
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if description is not None:
            self.description = description
        if documentation is not None:
            self.documentation = documentation
        if duration is not None:
            self.duration = duration
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if machine is not None:
            self.machine = machine
        if meta is not None:
            self.meta = meta
        if next_server is not None:
            self.next_server = next_server
        if options is not None:
            self.options = options
        if parameter is not None:
            self.parameter = parameter
        if params is not None:
            self.params = params
        if prefix_parameter is not None:
            self.prefix_parameter = prefix_parameter
        if profiles is not None:
            self.profiles = profiles
        if read_only is not None:
            self.read_only = read_only
        self.scoped = scoped
        if skip_dad is not None:
            self.skip_dad = skip_dad
        self.strategy = strategy
        if subnet is not None:
            self.subnet = subnet
        self.token = token
        if validated is not None:
            self.validated = validated

    @property
    def addr(self):
        """Gets the addr of this Reservation.  # noqa: E501

        Addr is the IP address permanently assigned to the strategy/token combination.  # noqa: E501

        :return: The addr of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this Reservation.

        Addr is the IP address permanently assigned to the strategy/token combination.  # noqa: E501

        :param addr: The addr of this Reservation.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and addr is None:
            raise ValueError("Invalid value for `addr`, must not be `None`")  # noqa: E501

        self._addr = addr

    @property
    def allocated(self):
        """Gets the allocated of this Reservation.  # noqa: E501

        Allocated indicates this is a reapable reservation  # noqa: E501

        :return: The allocated of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._allocated

    @allocated.setter
    def allocated(self, allocated):
        """Sets the allocated of this Reservation.

        Allocated indicates this is a reapable reservation  # noqa: E501

        :param allocated: The allocated of this Reservation.  # noqa: E501
        :type: bool
        """

        self._allocated = allocated

    @property
    def available(self):
        """Gets the available of this Reservation.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this Reservation.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this Reservation.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def bundle(self):
        """Gets the bundle of this Reservation.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this Reservation.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this Reservation.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def created_at(self):
        """Gets the created_at of this Reservation.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this Reservation.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Reservation.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this Reservation.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Reservation.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Reservation.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this Reservation.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def description(self):
        """Gets the description of this Reservation.  # noqa: E501

        Description is a string for providing a simple description  # noqa: E501

        :return: The description of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Reservation.

        Description is a string for providing a simple description  # noqa: E501

        :param description: The description of this Reservation.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def documentation(self):
        """Gets the documentation of this Reservation.  # noqa: E501

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :return: The documentation of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._documentation

    @documentation.setter
    def documentation(self, documentation):
        """Sets the documentation of this Reservation.

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :param documentation: The documentation of this Reservation.  # noqa: E501
        :type: str
        """

        self._documentation = documentation

    @property
    def duration(self):
        """Gets the duration of this Reservation.  # noqa: E501

        Duration is the time in seconds for which a lease can be valid. ExpireTime is calculated from Duration.  # noqa: E501

        :return: The duration of this Reservation.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Reservation.

        Duration is the time in seconds for which a lease can be valid. ExpireTime is calculated from Duration.  # noqa: E501

        :param duration: The duration of this Reservation.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def endpoint(self):
        """Gets the endpoint of this Reservation.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Reservation.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this Reservation.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this Reservation.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this Reservation.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Reservation.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this Reservation.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this Reservation.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this Reservation.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this Reservation.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this Reservation.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Reservation.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Reservation.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this Reservation.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def machine(self):
        """Gets the machine of this Reservation.  # noqa: E501

        Machine is the associated machine  # noqa: E501

        :return: The machine of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._machine

    @machine.setter
    def machine(self, machine):
        """Sets the machine of this Reservation.

        Machine is the associated machine  # noqa: E501

        :param machine: The machine of this Reservation.  # noqa: E501
        :type: str
        """

        self._machine = machine

    @property
    def meta(self):
        """Gets the meta of this Reservation.  # noqa: E501


        :return: The meta of this Reservation.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Reservation.


        :param meta: The meta of this Reservation.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def next_server(self):
        """Gets the next_server of this Reservation.  # noqa: E501

        NextServer is the address the server should contact next. You should only set this if you want to talk to a DHCP or TFTP server other than the one provided by dr-provision.  # noqa: E501

        :return: The next_server of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._next_server

    @next_server.setter
    def next_server(self, next_server):
        """Sets the next_server of this Reservation.

        NextServer is the address the server should contact next. You should only set this if you want to talk to a DHCP or TFTP server other than the one provided by dr-provision.  # noqa: E501

        :param next_server: The next_server of this Reservation.  # noqa: E501
        :type: str
        """

        self._next_server = next_server

    @property
    def options(self):
        """Gets the options of this Reservation.  # noqa: E501

        Options is the list of DHCP options that apply to this Reservation  # noqa: E501

        :return: The options of this Reservation.  # noqa: E501
        :rtype: list[DhcpOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Reservation.

        Options is the list of DHCP options that apply to this Reservation  # noqa: E501

        :param options: The options of this Reservation.  # noqa: E501
        :type: list[DhcpOption]
        """

        self._options = options

    @property
    def parameter(self):
        """Gets the parameter of this Reservation.  # noqa: E501

        Parameter is the parameter that this address should be stored in for the machine if specified  # noqa: E501

        :return: The parameter of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._parameter

    @parameter.setter
    def parameter(self, parameter):
        """Sets the parameter of this Reservation.

        Parameter is the parameter that this address should be stored in for the machine if specified  # noqa: E501

        :param parameter: The parameter of this Reservation.  # noqa: E501
        :type: str
        """

        self._parameter = parameter

    @property
    def params(self):
        """Gets the params of this Reservation.  # noqa: E501

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :return: The params of this Reservation.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this Reservation.

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :param params: The params of this Reservation.  # noqa: E501
        :type: dict(str, object)
        """

        self._params = params

    @property
    def prefix_parameter(self):
        """Gets the prefix_parameter of this Reservation.  # noqa: E501

        PrefixParameter a string that should be the beginning of a set of option-based parameters  # noqa: E501

        :return: The prefix_parameter of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._prefix_parameter

    @prefix_parameter.setter
    def prefix_parameter(self, prefix_parameter):
        """Sets the prefix_parameter of this Reservation.

        PrefixParameter a string that should be the beginning of a set of option-based parameters  # noqa: E501

        :param prefix_parameter: The prefix_parameter of this Reservation.  # noqa: E501
        :type: str
        """

        self._prefix_parameter = prefix_parameter

    @property
    def profiles(self):
        """Gets the profiles of this Reservation.  # noqa: E501

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :return: The profiles of this Reservation.  # noqa: E501
        :rtype: list[str]
        """
        return self._profiles

    @profiles.setter
    def profiles(self, profiles):
        """Sets the profiles of this Reservation.

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :param profiles: The profiles of this Reservation.  # noqa: E501
        :type: list[str]
        """

        self._profiles = profiles

    @property
    def read_only(self):
        """Gets the read_only of this Reservation.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Reservation.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this Reservation.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def scoped(self):
        """Gets the scoped of this Reservation.  # noqa: E501

        Scoped indicates that this reservation is tied to a particular Subnet, as determined by the reservation's Addr.  # noqa: E501

        :return: The scoped of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._scoped

    @scoped.setter
    def scoped(self, scoped):
        """Sets the scoped of this Reservation.

        Scoped indicates that this reservation is tied to a particular Subnet, as determined by the reservation's Addr.  # noqa: E501

        :param scoped: The scoped of this Reservation.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and scoped is None:
            raise ValueError("Invalid value for `scoped`, must not be `None`")  # noqa: E501

        self._scoped = scoped

    @property
    def skip_dad(self):
        """Gets the skip_dad of this Reservation.  # noqa: E501

        SkipDAD will cause the DHCP server to skip duplicate address detection via ping testing when in discovery phase.  Only set this if you know this reservation can never conflict with any other system.  # noqa: E501

        :return: The skip_dad of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._skip_dad

    @skip_dad.setter
    def skip_dad(self, skip_dad):
        """Sets the skip_dad of this Reservation.

        SkipDAD will cause the DHCP server to skip duplicate address detection via ping testing when in discovery phase.  Only set this if you know this reservation can never conflict with any other system.  # noqa: E501

        :param skip_dad: The skip_dad of this Reservation.  # noqa: E501
        :type: bool
        """

        self._skip_dad = skip_dad

    @property
    def strategy(self):
        """Gets the strategy of this Reservation.  # noqa: E501

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :return: The strategy of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """Sets the strategy of this Reservation.

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :param strategy: The strategy of this Reservation.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and strategy is None:
            raise ValueError("Invalid value for `strategy`, must not be `None`")  # noqa: E501

        self._strategy = strategy

    @property
    def subnet(self):
        """Gets the subnet of this Reservation.  # noqa: E501

        Subnet is the name of the Subnet that this Reservation is associated with. This property is read-only.  # noqa: E501

        :return: The subnet of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._subnet

    @subnet.setter
    def subnet(self, subnet):
        """Sets the subnet of this Reservation.

        Subnet is the name of the Subnet that this Reservation is associated with. This property is read-only.  # noqa: E501

        :param subnet: The subnet of this Reservation.  # noqa: E501
        :type: str
        """

        self._subnet = subnet

    @property
    def token(self):
        """Gets the token of this Reservation.  # noqa: E501

        Token is the unique identifier that the strategy for this Reservation should use.  # noqa: E501

        :return: The token of this Reservation.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this Reservation.

        Token is the unique identifier that the strategy for this Reservation should use.  # noqa: E501

        :param token: The token of this Reservation.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and token is None:
            raise ValueError("Invalid value for `token`, must not be `None`")  # noqa: E501

        self._token = token

    @property
    def validated(self):
        """Gets the validated of this Reservation.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this Reservation.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this Reservation.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this Reservation.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Reservation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Reservation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Reservation):
            return True

        return self.to_dict() != other.to_dict()
