# coding: utf-8

"""
    DigitalRebar Provision Server

    # An RestFUL API-driven Provisioner and DHCP server  # noqa: E501

    OpenAPI spec version: 4.15.0
    Contact: support@rackn.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from drppy_client.configuration import Configuration


class Subnet(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'active_end': 'str',
        'active_lease_time': 'int',
        'active_start': 'str',
        'allocate_end': 'str',
        'allocate_start': 'str',
        'available': 'bool',
        'bundle': 'str',
        'created_at': 'datetime',
        'created_by': 'str',
        'description': 'str',
        'documentation': 'str',
        'enabled': 'bool',
        'endpoint': 'str',
        'errors': 'list[str]',
        'last_modified_at': 'datetime',
        'last_modified_by': 'str',
        'meta': 'Meta',
        'name': 'str',
        'next_server': 'str',
        'only_reservations': 'bool',
        'options': 'list[DhcpOption]',
        'params': 'dict(str, object)',
        'pickers': 'list[str]',
        'prefix_parameter': 'str',
        'profiles': 'list[str]',
        'proxy': 'bool',
        'read_only': 'bool',
        'reserved_lease_time': 'int',
        'skip_dad': 'bool',
        'strategy': 'str',
        'subnet': 'str',
        'unmanaged': 'bool',
        'validated': 'bool'
    }

    attribute_map = {
        'active_end': 'ActiveEnd',
        'active_lease_time': 'ActiveLeaseTime',
        'active_start': 'ActiveStart',
        'allocate_end': 'AllocateEnd',
        'allocate_start': 'AllocateStart',
        'available': 'Available',
        'bundle': 'Bundle',
        'created_at': 'CreatedAt',
        'created_by': 'CreatedBy',
        'description': 'Description',
        'documentation': 'Documentation',
        'enabled': 'Enabled',
        'endpoint': 'Endpoint',
        'errors': 'Errors',
        'last_modified_at': 'LastModifiedAt',
        'last_modified_by': 'LastModifiedBy',
        'meta': 'Meta',
        'name': 'Name',
        'next_server': 'NextServer',
        'only_reservations': 'OnlyReservations',
        'options': 'Options',
        'params': 'Params',
        'pickers': 'Pickers',
        'prefix_parameter': 'PrefixParameter',
        'profiles': 'Profiles',
        'proxy': 'Proxy',
        'read_only': 'ReadOnly',
        'reserved_lease_time': 'ReservedLeaseTime',
        'skip_dad': 'SkipDAD',
        'strategy': 'Strategy',
        'subnet': 'Subnet',
        'unmanaged': 'Unmanaged',
        'validated': 'Validated'
    }

    def __init__(self, active_end=None, active_lease_time=None, active_start=None, allocate_end=None, allocate_start=None, available=None, bundle=None, created_at=None, created_by=None, description=None, documentation=None, enabled=None, endpoint=None, errors=None, last_modified_at=None, last_modified_by=None, meta=None, name=None, next_server=None, only_reservations=None, options=None, params=None, pickers=None, prefix_parameter=None, profiles=None, proxy=None, read_only=None, reserved_lease_time=None, skip_dad=None, strategy=None, subnet=None, unmanaged=None, validated=None, _configuration=None):  # noqa: E501
        """Subnet - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._active_end = None
        self._active_lease_time = None
        self._active_start = None
        self._allocate_end = None
        self._allocate_start = None
        self._available = None
        self._bundle = None
        self._created_at = None
        self._created_by = None
        self._description = None
        self._documentation = None
        self._enabled = None
        self._endpoint = None
        self._errors = None
        self._last_modified_at = None
        self._last_modified_by = None
        self._meta = None
        self._name = None
        self._next_server = None
        self._only_reservations = None
        self._options = None
        self._params = None
        self._pickers = None
        self._prefix_parameter = None
        self._profiles = None
        self._proxy = None
        self._read_only = None
        self._reserved_lease_time = None
        self._skip_dad = None
        self._strategy = None
        self._subnet = None
        self._unmanaged = None
        self._validated = None
        self.discriminator = None

        self.active_end = active_end
        self.active_lease_time = active_lease_time
        self.active_start = active_start
        if allocate_end is not None:
            self.allocate_end = allocate_end
        if allocate_start is not None:
            self.allocate_start = allocate_start
        if available is not None:
            self.available = available
        if bundle is not None:
            self.bundle = bundle
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if description is not None:
            self.description = description
        if documentation is not None:
            self.documentation = documentation
        self.enabled = enabled
        if endpoint is not None:
            self.endpoint = endpoint
        if errors is not None:
            self.errors = errors
        if last_modified_at is not None:
            self.last_modified_at = last_modified_at
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if meta is not None:
            self.meta = meta
        self.name = name
        self.next_server = next_server
        self.only_reservations = only_reservations
        if options is not None:
            self.options = options
        if params is not None:
            self.params = params
        self.pickers = pickers
        if prefix_parameter is not None:
            self.prefix_parameter = prefix_parameter
        if profiles is not None:
            self.profiles = profiles
        self.proxy = proxy
        if read_only is not None:
            self.read_only = read_only
        self.reserved_lease_time = reserved_lease_time
        if skip_dad is not None:
            self.skip_dad = skip_dad
        self.strategy = strategy
        self.subnet = subnet
        self.unmanaged = unmanaged
        if validated is not None:
            self.validated = validated

    @property
    def active_end(self):
        """Gets the active_end of this Subnet.  # noqa: E501

        ActiveEnd is the last non-reserved IP address we will hand non-reserved leases from.  # noqa: E501

        :return: The active_end of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._active_end

    @active_end.setter
    def active_end(self, active_end):
        """Sets the active_end of this Subnet.

        ActiveEnd is the last non-reserved IP address we will hand non-reserved leases from.  # noqa: E501

        :param active_end: The active_end of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and active_end is None:
            raise ValueError("Invalid value for `active_end`, must not be `None`")  # noqa: E501

        self._active_end = active_end

    @property
    def active_lease_time(self):
        """Gets the active_lease_time of this Subnet.  # noqa: E501

        ActiveLeaseTime is the default lease duration in seconds we will hand out to leases that do not have a reservation.  # noqa: E501

        :return: The active_lease_time of this Subnet.  # noqa: E501
        :rtype: int
        """
        return self._active_lease_time

    @active_lease_time.setter
    def active_lease_time(self, active_lease_time):
        """Sets the active_lease_time of this Subnet.

        ActiveLeaseTime is the default lease duration in seconds we will hand out to leases that do not have a reservation.  # noqa: E501

        :param active_lease_time: The active_lease_time of this Subnet.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and active_lease_time is None:
            raise ValueError("Invalid value for `active_lease_time`, must not be `None`")  # noqa: E501

        self._active_lease_time = active_lease_time

    @property
    def active_start(self):
        """Gets the active_start of this Subnet.  # noqa: E501

        ActiveStart is the first non-reserved IP address we will hand non-reserved leases from.  # noqa: E501

        :return: The active_start of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._active_start

    @active_start.setter
    def active_start(self, active_start):
        """Sets the active_start of this Subnet.

        ActiveStart is the first non-reserved IP address we will hand non-reserved leases from.  # noqa: E501

        :param active_start: The active_start of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and active_start is None:
            raise ValueError("Invalid value for `active_start`, must not be `None`")  # noqa: E501

        self._active_start = active_start

    @property
    def allocate_end(self):
        """Gets the allocate_end of this Subnet.  # noqa: E501

        AllocateEnd is the last IP address we will hand out on allocation calls 0.0.0.0/unset means last address in CIDR  # noqa: E501

        :return: The allocate_end of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._allocate_end

    @allocate_end.setter
    def allocate_end(self, allocate_end):
        """Sets the allocate_end of this Subnet.

        AllocateEnd is the last IP address we will hand out on allocation calls 0.0.0.0/unset means last address in CIDR  # noqa: E501

        :param allocate_end: The allocate_end of this Subnet.  # noqa: E501
        :type: str
        """

        self._allocate_end = allocate_end

    @property
    def allocate_start(self):
        """Gets the allocate_start of this Subnet.  # noqa: E501

        AllocateStart is the first IP address we will hand out on allocation calls 0.0.0.0/unset means first address in CIDR  # noqa: E501

        :return: The allocate_start of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._allocate_start

    @allocate_start.setter
    def allocate_start(self, allocate_start):
        """Sets the allocate_start of this Subnet.

        AllocateStart is the first IP address we will hand out on allocation calls 0.0.0.0/unset means first address in CIDR  # noqa: E501

        :param allocate_start: The allocate_start of this Subnet.  # noqa: E501
        :type: str
        """

        self._allocate_start = allocate_start

    @property
    def available(self):
        """Gets the available of this Subnet.  # noqa: E501

        Available tracks whether or not the model passed validation.  # noqa: E501

        :return: The available of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this Subnet.

        Available tracks whether or not the model passed validation.  # noqa: E501

        :param available: The available of this Subnet.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def bundle(self):
        """Gets the bundle of this Subnet.  # noqa: E501

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :return: The bundle of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """Sets the bundle of this Subnet.

        Bundle tracks the name of the store containing this object. This field is read-only, and cannot be changed via the API.  # noqa: E501

        :param bundle: The bundle of this Subnet.  # noqa: E501
        :type: str
        """

        self._bundle = bundle

    @property
    def created_at(self):
        """Gets the created_at of this Subnet.  # noqa: E501

        CreatedAt is the time that this object was created.  # noqa: E501

        :return: The created_at of this Subnet.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Subnet.

        CreatedAt is the time that this object was created.  # noqa: E501

        :param created_at: The created_at of this Subnet.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Subnet.  # noqa: E501

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :return: The created_by of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Subnet.

        CreatedBy stores the value of the user that created this object. Note: This value is stored ONLY if the object was created by a user which means that `currentUserName` needs to be populated in the authBlob  # noqa: E501

        :param created_by: The created_by of this Subnet.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def description(self):
        """Gets the description of this Subnet.  # noqa: E501

        Description is a string for providing a simple description  # noqa: E501

        :return: The description of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Subnet.

        Description is a string for providing a simple description  # noqa: E501

        :param description: The description of this Subnet.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def documentation(self):
        """Gets the documentation of this Subnet.  # noqa: E501

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :return: The documentation of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._documentation

    @documentation.setter
    def documentation(self, documentation):
        """Sets the documentation of this Subnet.

        Documentation is a string for providing additional in depth information.  # noqa: E501

        :param documentation: The documentation of this Subnet.  # noqa: E501
        :type: str
        """

        self._documentation = documentation

    @property
    def enabled(self):
        """Gets the enabled of this Subnet.  # noqa: E501

        Enabled indicates if the subnet should hand out leases or continue operating leases if already running.  # noqa: E501

        :return: The enabled of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this Subnet.

        Enabled indicates if the subnet should hand out leases or continue operating leases if already running.  # noqa: E501

        :param enabled: The enabled of this Subnet.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and enabled is None:
            raise ValueError("Invalid value for `enabled`, must not be `None`")  # noqa: E501

        self._enabled = enabled

    @property
    def endpoint(self):
        """Gets the endpoint of this Subnet.  # noqa: E501

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :return: The endpoint of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Subnet.

        Endpoint tracks the owner of the object among DRP endpoints  # noqa: E501

        :param endpoint: The endpoint of this Subnet.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def errors(self):
        """Gets the errors of this Subnet.  # noqa: E501

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :return: The errors of this Subnet.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Subnet.

        If there are any errors in the validation process, they will be available here.  # noqa: E501

        :param errors: The errors of this Subnet.  # noqa: E501
        :type: list[str]
        """

        self._errors = errors

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this Subnet.  # noqa: E501

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :return: The last_modified_at of this Subnet.  # noqa: E501
        :rtype: datetime
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this Subnet.

        LastModifiedAt is the time that this object was last modified.  # noqa: E501

        :param last_modified_at: The last_modified_at of this Subnet.  # noqa: E501
        :type: datetime
        """

        self._last_modified_at = last_modified_at

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Subnet.  # noqa: E501

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :return: The last_modified_by of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Subnet.

        LastModifiedBy stores the value of the user that last modified this object. NOTE: This value is populated ONLY if the object was modified by a user which means any actions done using machine tokens will not get tracked  # noqa: E501

        :param last_modified_by: The last_modified_by of this Subnet.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def meta(self):
        """Gets the meta of this Subnet.  # noqa: E501


        :return: The meta of this Subnet.  # noqa: E501
        :rtype: Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Subnet.


        :param meta: The meta of this Subnet.  # noqa: E501
        :type: Meta
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this Subnet.  # noqa: E501

        Name is the name of the subnet. Subnet names must be unique  # noqa: E501

        :return: The name of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Subnet.

        Name is the name of the subnet. Subnet names must be unique  # noqa: E501

        :param name: The name of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def next_server(self):
        """Gets the next_server of this Subnet.  # noqa: E501

        NextServer is the IP address of next server to use in the bootstrap process. The next server address is returned in DHCPOFFER, DHCPACK by the DHCP server.  # noqa: E501

        :return: The next_server of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._next_server

    @next_server.setter
    def next_server(self, next_server):
        """Sets the next_server of this Subnet.

        NextServer is the IP address of next server to use in the bootstrap process. The next server address is returned in DHCPOFFER, DHCPACK by the DHCP server.  # noqa: E501

        :param next_server: The next_server of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and next_server is None:
            raise ValueError("Invalid value for `next_server`, must not be `None`")  # noqa: E501

        self._next_server = next_server

    @property
    def only_reservations(self):
        """Gets the only_reservations of this Subnet.  # noqa: E501

        OnlyReservations indicates that we will only allow leases for which there is a preexisting reservation.  # noqa: E501

        :return: The only_reservations of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._only_reservations

    @only_reservations.setter
    def only_reservations(self, only_reservations):
        """Sets the only_reservations of this Subnet.

        OnlyReservations indicates that we will only allow leases for which there is a preexisting reservation.  # noqa: E501

        :param only_reservations: The only_reservations of this Subnet.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and only_reservations is None:
            raise ValueError("Invalid value for `only_reservations`, must not be `None`")  # noqa: E501

        self._only_reservations = only_reservations

    @property
    def options(self):
        """Gets the options of this Subnet.  # noqa: E501

        Additional options to send to DHCP clients  # noqa: E501

        :return: The options of this Subnet.  # noqa: E501
        :rtype: list[DhcpOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Subnet.

        Additional options to send to DHCP clients  # noqa: E501

        :param options: The options of this Subnet.  # noqa: E501
        :type: list[DhcpOption]
        """

        self._options = options

    @property
    def params(self):
        """Gets the params of this Subnet.  # noqa: E501

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :return: The params of this Subnet.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this Subnet.

        Params holds the values of parameters on the object.  The field is a key / value store of the parameters. The key is the name of a parameter.  The key is of type string. The value is the value of the parameter.  The type of the value is defined by the parameter object.  If the key doesn't reference a parameter, the type of the object can be anything.  The system will enforce the named parameter's value's type.  Go calls the \"anything\" parameters as \"interface {}\".  Hence, the type of this field is a map[string]interface{}.  # noqa: E501

        :param params: The params of this Subnet.  # noqa: E501
        :type: dict(str, object)
        """

        self._params = params

    @property
    def pickers(self):
        """Gets the pickers of this Subnet.  # noqa: E501

        Pickers is list of methods that will allocate IP addresses. Each string must refer to a valid address picking strategy.  The current ones are:  \"none\", which will refuse to hand out an address and refuse to try any remaining strategies.  \"hint\", which will try to reuse the address that the DHCP packet is requesting, if it has one.  If the request does not have a requested address, \"hint\" will fall through to the next strategy. Otherwise, it will refuse to try any remaining strategies whether or not it can satisfy the request.  This should force the client to fall back to DHCPDISCOVER with no requsted IP address. \"hint\" will reuse expired leases and unexpired leases that match on the requested address, strategy, and token.  \"nextFree\", which will try to create a Lease with the next free address in the subnet active range.  It will fall through to the next strategy if it cannot find a free IP. \"nextFree\" only considers addresses that do not have a lease, whether or not the lease is expired.  \"mostExpired\" will try to recycle the most expired lease in the subnet's active range.  All of the address allocation strategies do not consider any addresses that are reserved, as lease creation will be handled by the reservation instead.  We will consider adding more address allocation strategies in the future.  # noqa: E501

        :return: The pickers of this Subnet.  # noqa: E501
        :rtype: list[str]
        """
        return self._pickers

    @pickers.setter
    def pickers(self, pickers):
        """Sets the pickers of this Subnet.

        Pickers is list of methods that will allocate IP addresses. Each string must refer to a valid address picking strategy.  The current ones are:  \"none\", which will refuse to hand out an address and refuse to try any remaining strategies.  \"hint\", which will try to reuse the address that the DHCP packet is requesting, if it has one.  If the request does not have a requested address, \"hint\" will fall through to the next strategy. Otherwise, it will refuse to try any remaining strategies whether or not it can satisfy the request.  This should force the client to fall back to DHCPDISCOVER with no requsted IP address. \"hint\" will reuse expired leases and unexpired leases that match on the requested address, strategy, and token.  \"nextFree\", which will try to create a Lease with the next free address in the subnet active range.  It will fall through to the next strategy if it cannot find a free IP. \"nextFree\" only considers addresses that do not have a lease, whether or not the lease is expired.  \"mostExpired\" will try to recycle the most expired lease in the subnet's active range.  All of the address allocation strategies do not consider any addresses that are reserved, as lease creation will be handled by the reservation instead.  We will consider adding more address allocation strategies in the future.  # noqa: E501

        :param pickers: The pickers of this Subnet.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and pickers is None:
            raise ValueError("Invalid value for `pickers`, must not be `None`")  # noqa: E501

        self._pickers = pickers

    @property
    def prefix_parameter(self):
        """Gets the prefix_parameter of this Subnet.  # noqa: E501

        PrefixParameter a string that should be the beginning of a set of option-based parameters  # noqa: E501

        :return: The prefix_parameter of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._prefix_parameter

    @prefix_parameter.setter
    def prefix_parameter(self, prefix_parameter):
        """Sets the prefix_parameter of this Subnet.

        PrefixParameter a string that should be the beginning of a set of option-based parameters  # noqa: E501

        :param prefix_parameter: The prefix_parameter of this Subnet.  # noqa: E501
        :type: str
        """

        self._prefix_parameter = prefix_parameter

    @property
    def profiles(self):
        """Gets the profiles of this Subnet.  # noqa: E501

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :return: The profiles of this Subnet.  # noqa: E501
        :rtype: list[str]
        """
        return self._profiles

    @profiles.setter
    def profiles(self, profiles):
        """Sets the profiles of this Subnet.

        Profiles is an array of profiles to apply to this object in order when looking for a parameter during rendering.  # noqa: E501

        :param profiles: The profiles of this Subnet.  # noqa: E501
        :type: list[str]
        """

        self._profiles = profiles

    @property
    def proxy(self):
        """Gets the proxy of this Subnet.  # noqa: E501

        Proxy indicates if the subnet should act as a proxy DHCP server. If true, the subnet will not manage ip addresses but will send offers to requests.  It is an error for Proxy and Unmanaged to be true.  # noqa: E501

        :return: The proxy of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._proxy

    @proxy.setter
    def proxy(self, proxy):
        """Sets the proxy of this Subnet.

        Proxy indicates if the subnet should act as a proxy DHCP server. If true, the subnet will not manage ip addresses but will send offers to requests.  It is an error for Proxy and Unmanaged to be true.  # noqa: E501

        :param proxy: The proxy of this Subnet.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and proxy is None:
            raise ValueError("Invalid value for `proxy`, must not be `None`")  # noqa: E501

        self._proxy = proxy

    @property
    def read_only(self):
        """Gets the read_only of this Subnet.  # noqa: E501

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :return: The read_only of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Subnet.

        ReadOnly tracks if the store for this object is read-only. This flag is informational, and cannot be changed via the API.  # noqa: E501

        :param read_only: The read_only of this Subnet.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def reserved_lease_time(self):
        """Gets the reserved_lease_time of this Subnet.  # noqa: E501

        ReservedLeasTime is the default lease time we will hand out to leases created from a reservation in our subnet.  # noqa: E501

        :return: The reserved_lease_time of this Subnet.  # noqa: E501
        :rtype: int
        """
        return self._reserved_lease_time

    @reserved_lease_time.setter
    def reserved_lease_time(self, reserved_lease_time):
        """Sets the reserved_lease_time of this Subnet.

        ReservedLeasTime is the default lease time we will hand out to leases created from a reservation in our subnet.  # noqa: E501

        :param reserved_lease_time: The reserved_lease_time of this Subnet.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and reserved_lease_time is None:
            raise ValueError("Invalid value for `reserved_lease_time`, must not be `None`")  # noqa: E501

        self._reserved_lease_time = reserved_lease_time

    @property
    def skip_dad(self):
        """Gets the skip_dad of this Subnet.  # noqa: E501

        SkipDAD will cause the DHCP server to skip duplicate address detection via ping testing when in discovery phase.  Only set this if you know nothing in this subnet will ever have address conflicts with any other system.  # noqa: E501

        :return: The skip_dad of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._skip_dad

    @skip_dad.setter
    def skip_dad(self, skip_dad):
        """Sets the skip_dad of this Subnet.

        SkipDAD will cause the DHCP server to skip duplicate address detection via ping testing when in discovery phase.  Only set this if you know nothing in this subnet will ever have address conflicts with any other system.  # noqa: E501

        :param skip_dad: The skip_dad of this Subnet.  # noqa: E501
        :type: bool
        """

        self._skip_dad = skip_dad

    @property
    def strategy(self):
        """Gets the strategy of this Subnet.  # noqa: E501

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :return: The strategy of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """Sets the strategy of this Subnet.

        Strategy is the leasing strategy that will be used determine what to use from the DHCP packet to handle lease management.  # noqa: E501

        :param strategy: The strategy of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and strategy is None:
            raise ValueError("Invalid value for `strategy`, must not be `None`")  # noqa: E501

        self._strategy = strategy

    @property
    def subnet(self):
        """Gets the subnet of this Subnet.  # noqa: E501

        Subnet is the network address in CIDR form that all leases acquired in its range will use for options, lease times, and NextServer settings by default  # noqa: E501

        :return: The subnet of this Subnet.  # noqa: E501
        :rtype: str
        """
        return self._subnet

    @subnet.setter
    def subnet(self, subnet):
        """Sets the subnet of this Subnet.

        Subnet is the network address in CIDR form that all leases acquired in its range will use for options, lease times, and NextServer settings by default  # noqa: E501

        :param subnet: The subnet of this Subnet.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and subnet is None:
            raise ValueError("Invalid value for `subnet`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                subnet is not None and not re.search(r'^([0-9]+\\.){3}[0-9]+\/[0-9]+$', subnet)):  # noqa: E501
            raise ValueError(r"Invalid value for `subnet`, must be a follow pattern or equal to `/^([0-9]+\\.){3}[0-9]+\/[0-9]+$/`")  # noqa: E501

        self._subnet = subnet

    @property
    def unmanaged(self):
        """Gets the unmanaged of this Subnet.  # noqa: E501

        Unmanaged indicates that dr-provision will never send boot-related options to machines that get leases from this subnet.  If false, dr-provision will send whatever boot-related options it would normally send.  It is an error for Unmanaged and Proxy to both be true.  # noqa: E501

        :return: The unmanaged of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._unmanaged

    @unmanaged.setter
    def unmanaged(self, unmanaged):
        """Sets the unmanaged of this Subnet.

        Unmanaged indicates that dr-provision will never send boot-related options to machines that get leases from this subnet.  If false, dr-provision will send whatever boot-related options it would normally send.  It is an error for Unmanaged and Proxy to both be true.  # noqa: E501

        :param unmanaged: The unmanaged of this Subnet.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and unmanaged is None:
            raise ValueError("Invalid value for `unmanaged`, must not be `None`")  # noqa: E501

        self._unmanaged = unmanaged

    @property
    def validated(self):
        """Gets the validated of this Subnet.  # noqa: E501

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :return: The validated of this Subnet.  # noqa: E501
        :rtype: bool
        """
        return self._validated

    @validated.setter
    def validated(self, validated):
        """Sets the validated of this Subnet.

        Validated tracks whether or not the model has been validated.  # noqa: E501

        :param validated: The validated of this Subnet.  # noqa: E501
        :type: bool
        """

        self._validated = validated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Subnet, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Subnet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Subnet):
            return True

        return self.to_dict() != other.to_dict()
