"""fluxion's plugin subcommand.

fluxion's plugin subcommand is accessed in the command-line interface via ``fluxion
plugin``. Here you can specify options, subcommands, and subgroups for the plugin
group.

"""

from __future__ import annotations

import cloup

from fluxion.constants import CONTEXT_SETTINGS, EPILOG
from fluxion.plugins.plugins_flags import list_plugins

__all__ = ["plugins"]


@cloup.command(
    context_settings=CONTEXT_SETTINGS,
    no_args_is_help=True,
    epilog=EPILOG,
    help="Manages fluxion plugins.",
)
@cloup.option(
    "-l",
    "--list",
    "list_available",
    is_flag=True,
    help="List available plugins.",
)
def plugins(list_available: bool) -> None:
    """Print a list of all available plugins when calling ``fluxion plugins -l``
    or ``fluxion plugins --list``.

    Parameters
    ----------
    list_available
        If the ``-l`` or ``-list`` option is passed to ``fluxion plugins``, this
        parameter will be set to ``True``, which will print a list of all
        available plugins.
    """
    if list_available:
        list_plugins()
