from fluxion import *
from fluxion import Scene, NumberPlane, Line, Text, Circle, Arrow, TracedPath, ValueTracker, always_redraw
import sys
import os



class ProjectilePhysics(Scene):
    def construct(self):
        # 1. Setup the environment
        axes = NumberPlane(
            x_range=[-1, 10, 1],
            y_range=[-1, 6, 1],
            background_line_style={"stroke_opacity": 0.4}
        )
        
        ground = Line(axes.c2p(-5, 0), axes.c2p(15, 0), color=GREEN, stroke_width=5)
        title = Text("Physics: Projectile Motion Vectors", font_size=36).to_edge(UP)
        
        self.add(axes, ground, title)

        # 2. Define the Physics Parameters
        v0 = 8         # Initial velocity magnitude
        theta = 60 * DEGREES # Launch angle
        g = 9.8        # Gravity
        total_time = (2 * v0 * np.sin(theta)) / g # Time of flight formula

        # 3. Create the Object (Cannonball)
        ball = Circle(radius=0.15, color=WHITE, fill_opacity=1)
        
        # 4. Create Vectors (Velocity and Components)
        # We use 'always_redraw' so they update automatically every frame
        
        def get_ball_pos(t):
            x = v0 * np.cos(theta) * t
            y = v0 * np.sin(theta) * t - (0.5 * g * t**2)
            return axes.c2p(x, y)

        # Time tracker
        t = ValueTracker(0)

        # Update ball position based on time
        ball.add_updater(lambda m: m.move_to(get_ball_pos(t.get_value())))

        # Velocity Vector (Red)
        velocity_vector = always_redraw(lambda: Arrow(
            start=ball.get_center(),
            end=ball.get_center() + RIGHT * np.cos(theta) + UP * (np.sin(theta) - g * t.get_value() / v0),
            color=RED, buff=0
        ))

        # Horizontal Component (Blue - Constant)
        vx_vector = always_redraw(lambda: Arrow(
            start=ball.get_center(),
            end=ball.get_center() + RIGHT * np.cos(theta),
            color=BLUE, buff=0, stroke_width=3
        ))

        # Vertical Component (Yellow - Changes)
        vy_vector = always_redraw(lambda: Arrow(
            start=ball.get_center(),
            end=ball.get_center() + UP * (np.sin(theta) - g * t.get_value() / v0),
            color=YELLOW, buff=0, stroke_width=3
        ))

        # Path trace
        path = TracedPath(ball.get_center, stroke_color=WHITE, stroke_opacity=0.5)

        # 5. Animation Sequence
        self.add(path, ball, velocity_vector, vx_vector, vy_vector)
        self.play(t.animate.set_value(total_time), run_time=5, rate_func=linear)
        self.wait()