"""Australian Color Standard

In 1985 the Australian Independent Color Standard AS 2700 was created. In
this standard, all colors can be identified via a category code (one of
B -- Blue, G -- Green, N -- Neutrals (grey), P -- Purple, R -- Red, T -- Blue/Green,
X -- Yellow/Red, Y -- Yellow) and a number. The colors also have (natural) names.

To use the colors from this list, access them directly from the module (which
is exposed to fluxion's global name space):

.. code:: pycon

    >>> from fluxion import AS2700
    >>> AS2700.B23_BRIGHT_BLUE
    fluxionColor('#174F90')

List of Color Constants
-----------------------

These hex values (taken from https://www.w3schools.com/colors/colors_australia.asp)
are non official approximate values intended to simulate AS 2700 colors:

.. autofluxioncolormodule:: fluxion.utils.color.AS2700

"""

from __future__ import annotations

from .core import fluxionColor

B11_RICH_BLUE = fluxionColor("#2B3770")
B12_ROYAL_BLUE = fluxionColor("#2C3563")
B13_NAVY_BLUE = fluxionColor("#28304D")
B14_SAPHHIRE = fluxionColor("#28426B")
B15_MID_BLUE = fluxionColor("#144B6F")
B21_ULTRAMARINE = fluxionColor("#2C5098")
B22_HOMEBUSH_BLUE = fluxionColor("#215097")
B23_BRIGHT_BLUE = fluxionColor("#174F90")
B24_HARBOUR_BLUE = fluxionColor("#1C6293")
B25_AQUA = fluxionColor("#5097AC")
B32_POWDER_BLUE = fluxionColor("#B7C8DB")
B33_MIST_BLUE = fluxionColor("#E0E6E2")
B34_PARADISE_BLUE = fluxionColor("#3499BA")
B35_PALE_BLUE = fluxionColor("#CDE4E2")
B41_BLUEBELL = fluxionColor("#5B94D1")
B42_PURPLE_BLUE = fluxionColor("#5E7899")
B43_GREY_BLUE = fluxionColor("#627C8D")
B44_LIGHT_GREY_BLUE = fluxionColor("#C0C0C1")
B45_SKY_BLUE = fluxionColor("#7DB7C7")
B51_PERIWINKLE = fluxionColor("#3871AC")
B53_DARK_GREY_BLUE = fluxionColor("#4F6572")
B55_STORM_BLUE = fluxionColor("#3F7C94")
B61_CORAL_SEA = fluxionColor("#2B3873")
B62_MIDNIGHT_BLUE = fluxionColor("#292A34")
B64_CHARCOAL = fluxionColor("#363E45")
G11_BOTTLE_GREEN = fluxionColor("#253A32")
G12_HOLLY = fluxionColor("#21432D")
G13_EMERALD = fluxionColor("#195F35")
G14_MOSS_GREEN = fluxionColor("#33572D")
G15_RAINFOREST_GREEN = fluxionColor("#3D492D")
G16_TRAFFIC_GREEN = fluxionColor("#305442")
G17_MINT_GREEN = fluxionColor("#006B45")
G21_JADE = fluxionColor("#127453")
G22_SERPENTINE = fluxionColor("#78A681")
G23_SHAMROCK = fluxionColor("#336634")
G24_FERN_TREE = fluxionColor("#477036")
G25_OLIVE = fluxionColor("#595B2A")
G26_APPLE_GREEN = fluxionColor("#4E9843")
G27_HOMEBUSH_GREEN = fluxionColor("#017F4D")
G31_VERTIGRIS = fluxionColor("#468A65")
G32_OPALINE = fluxionColor("#AFCBB8")
G33_LETTUCE = fluxionColor("#7B9954")
G34_AVOCADO = fluxionColor("#757C4C")
G35_LIME_GREEN = fluxionColor("#89922E")
G36_KIKUYU = fluxionColor("#95B43B")
G37_BEANSTALK = fluxionColor("#45A56A")
G41_LAWN_GREEN = fluxionColor("#0D875D")
G42_GLACIER = fluxionColor("#D5E1D2")
G43_SURF_GREEN = fluxionColor("#C8C8A7")
G44_PALM_GREEN = fluxionColor("#99B179")
G45_CHARTREUSE = fluxionColor("#C7C98D")
G46_CITRONELLA = fluxionColor("#BFC83E")
G47_CRYSTAL_GREEN = fluxionColor("#ADCCA8")
G51_SPRUCE = fluxionColor("#05674F")
G52_EUCALYPTUS = fluxionColor("#66755B")
G53_BANKSIA = fluxionColor("#929479")
G54_MIST_GREEN = fluxionColor("#7A836D")
G55_LICHEN = fluxionColor("#A7A98C")
G56_SAGE_GREEN = fluxionColor("#677249")
G61_DARK_GREEN = fluxionColor("#283533")
G62_RIVERGUM = fluxionColor("#617061")
G63_DEEP_BRONZE_GREEN = fluxionColor("#333334")
G64_SLATE = fluxionColor("#5E6153")
G65_TI_TREE = fluxionColor("#5D5F4E")
G66_ENVIRONMENT_GREEN = fluxionColor("#484C3F")
G67_ZUCCHINI = fluxionColor("#2E443A")
N11_PEARL_GREY = fluxionColor("#D8D3C7")
N12_PASTEL_GREY = fluxionColor("#CCCCCC")
N14_WHITE = fluxionColor("#FFFFFF")
N15_HOMEBUSH_GREY = fluxionColor("#A29B93")
N22_CLOUD_GREY = fluxionColor("#C4C1B9")
N23_NEUTRAL_GREY = fluxionColor("#CCCCCC")
N24_SILVER_GREY = fluxionColor("#BDC7C5")
N25_BIRCH_GREY = fluxionColor("#ABA498")
N32_GREEN_GREY = fluxionColor("#8E9282")
N33_LIGHTBOX_GREY = fluxionColor("#ACADAD")
N35_LIGHT_GREY = fluxionColor("#A6A7A1")
N41_OYSTER = fluxionColor("#998F78")
N42_STORM_GREY = fluxionColor("#858F88")
N43_PIPELINE_GREY = fluxionColor("#999999")
N44_BRIDGE_GREY = fluxionColor("#767779")
N45_KOALA_GREY = fluxionColor("#928F88")
N52_MID_GREY = fluxionColor("#727A77")
N53_BLUE_GREY = fluxionColor("#7C8588")
N54_BASALT = fluxionColor("#585C63")
N55_LEAD_GREY = fluxionColor("#5E5C58")
N61_BLACK = fluxionColor("#2A2A2C")
N63_PEWTER = fluxionColor("#596064")
N64_DARK_GREY = fluxionColor("#4B5259")
N65_GRAPHITE_GREY = fluxionColor("#45474A")
P11_MAGENTA = fluxionColor("#7B2B48")
P12_PURPLE = fluxionColor("#85467B")
P13_VIOLET = fluxionColor("#5D3A61")
P14_BLUEBERRY = fluxionColor("#4C4176")
P21_SUNSET_PINK = fluxionColor("#E3BBBD")
P22_CYCLAMEN = fluxionColor("#83597D")
P23_LILAC = fluxionColor("#A69FB1")
P24_JACKARANDA = fluxionColor("#795F91")
P31_DUSTY_PINK = fluxionColor("#DBBEBC")
P33_RIBBON_PINK = fluxionColor("#D1BCC9")
P41_ERICA_PINK = fluxionColor("#C55A83")
P42_MULBERRY = fluxionColor("#A06574")
P43_WISTERIA = fluxionColor("#756D91")
P52_PLUM = fluxionColor("#6E3D4B")
R11_INTERNATIONAL_ORANGE = fluxionColor("#CE482A")
R12_SCARLET = fluxionColor("#CD392A")
R13_SIGNAL_RED = fluxionColor("#BA312B")
R14_WARATAH = fluxionColor("#AA2429")
R15_CRIMSON = fluxionColor("#9E2429")
R21_TANGERINE = fluxionColor("#E96957")
R22_HOMEBUSH_RED = fluxionColor("#D83A2D")
R23_LOLLIPOP = fluxionColor("#CC5058")
R24_STRAWBERRY = fluxionColor("#B4292A")
R25_ROSE_PINK = fluxionColor("#E8919C")
R32_APPLE_BLOSSOM = fluxionColor("#F2E1D8")
R33_GHOST_GUM = fluxionColor("#E8DAD4")
R34_MUSHROOM = fluxionColor("#D7C0B6")
R35_DEEP_ROSE = fluxionColor("#CD6D71")
R41_SHELL_PINK = fluxionColor("#F9D9BB")
R42_SALMON_PINK = fluxionColor("#D99679")
R43_RED_DUST = fluxionColor("#D0674F")
R44_POSSUM = fluxionColor("#A18881")
R45_RUBY = fluxionColor("#8F3E5C")
R51_BURNT_PINK = fluxionColor("#E19B8E")
R52_TERRACOTTA = fluxionColor("#A04C36")
R53_RED_GUM = fluxionColor("#8D4338")
R54_RASPBERRY = fluxionColor("#852F31")
R55_CLARET = fluxionColor("#67292D")
R62_VENETIAN_RED = fluxionColor("#77372B")
R63_RED_OXIDE = fluxionColor("#663334")
R64_DEEP_INDIAN_RED = fluxionColor("#542E2B")
R65_MAROON = fluxionColor("#3F2B3C")
T11_TROPICAL_BLUE = fluxionColor("#006698")
T12_DIAMANTIA = fluxionColor("#006C74")
T14_MALACHITE = fluxionColor("#105154")
T15_TURQUOISE = fluxionColor("#098587")
T22_ORIENTAL_BLUE = fluxionColor("#358792")
T24_BLUE_JADE = fluxionColor("#427F7E")
T32_HUON_GREEN = fluxionColor("#72B3B1")
T33_SMOKE_BLUE = fluxionColor("#9EB6B2")
T35_GREEN_ICE = fluxionColor("#78AEA2")
T44_BLUE_GUM = fluxionColor("#6A8A88")
T45_COOTAMUNDRA = fluxionColor("#759E91")
T51_MOUNTAIN_BLUE = fluxionColor("#295668")
T53_PEACOCK_BLUE = fluxionColor("#245764")
T63_TEAL = fluxionColor("#183F4E")
X11_BUTTERSCOTCH = fluxionColor("#D38F43")
X12_PUMPKIN = fluxionColor("#DD7E1A")
X13_MARIGOLD = fluxionColor("#ED7F15")
X14_MANDARIN = fluxionColor("#E45427")
X15_ORANGE = fluxionColor("#E36C2B")
X21_PALE_OCHRE = fluxionColor("#DAA45F")
X22_SAFFRON = fluxionColor("#F6AA51")
X23_APRICOT = fluxionColor("#FEB56D")
X24_ROCKMELON = fluxionColor("#F6894B")
X31_RAFFIA = fluxionColor("#EBC695")
X32_MAGNOLIA = fluxionColor("#F1DEBE")
X33_WARM_WHITE = fluxionColor("#F3E7D4")
X34_DRIFTWOOD = fluxionColor("#D5C4AE")
X41_BUFF = fluxionColor("#C28A44")
X42_BISCUIT = fluxionColor("#DEBA92")
X43_BEIGE = fluxionColor("#C9AA8C")
X45_CINNAMON = fluxionColor("#AC826D")
X51_TAN = fluxionColor("#8F5F32")
X52_COFFEE = fluxionColor("#AD7948")
X53_GOLDEN_TAN = fluxionColor("#925629")
X54_BROWN = fluxionColor("#68452C")
X55_NUT_BROWN = fluxionColor("#764832")
X61_WOMBAT = fluxionColor("#6E5D52")
X62_DARK_EARTH = fluxionColor("#6E5D52")
X63_IRONBARK = fluxionColor("#443B36")
X64_CHOCOLATE = fluxionColor("#4A3B31")
X65_DARK_BROWN = fluxionColor("#4F372D")
Y11_CANARY = fluxionColor("#E7BD11")
Y12_WATTLE = fluxionColor("#E8AF01")
Y13_VIVID_YELLOW = fluxionColor("#FCAE01")
Y14_GOLDEN_YELLOW = fluxionColor("#F5A601")
Y15_SUNFLOWER = fluxionColor("#FFA709")
Y16_INCA_GOLD = fluxionColor("#DF8C19")
Y21_PRIMROSE = fluxionColor("#F5CF5B")
Y22_CUSTARD = fluxionColor("#EFD25C")
Y23_BUTTERCUP = fluxionColor("#E0CD41")
Y24_STRAW = fluxionColor("#E3C882")
Y25_DEEP_CREAM = fluxionColor("#F3C968")
Y26_HOMEBUSH_GOLD = fluxionColor("#FCC51A")
Y31_LILY_GREEN = fluxionColor("#E3E3CD")
Y32_FLUMMERY = fluxionColor("#E6DF9E")
Y33_PALE_PRIMROSE = fluxionColor("#F5F3CE")
Y34_CREAM = fluxionColor("#EFE3BE")
Y35_OFF_WHITE = fluxionColor("#F1E9D5")
Y41_OLIVE_YELLOW = fluxionColor("#8E7426")
Y42_MUSTARD = fluxionColor("#C4A32E")
Y43_PARCHMENT = fluxionColor("#D4C9A3")
Y44_SAND = fluxionColor("#DCC18B")
Y45_MANILLA = fluxionColor("#E5D0A7")
Y51_BRONZE_OLIVE = fluxionColor("#695D3E")
Y52_CHAMOIS = fluxionColor("#BEA873")
Y53_SANDSTONE = fluxionColor("#D5BF8E")
Y54_OATMEAL = fluxionColor("#CAAE82")
Y55_DEEP_STONE = fluxionColor("#BC9969")
Y56_MERINO = fluxionColor("#C9B79E")
Y61_BLACK_OLIVE = fluxionColor("#47473B")
Y62_SUGAR_CANE = fluxionColor("#BCA55C")
Y63_KHAKI = fluxionColor("#826843")
Y65_MUSHROOM = fluxionColor("#A39281")
Y66_MUDSTONE = fluxionColor("#574E45")
