"""British Color Standard

This module contains colors defined in one of the British Standards
for colors, BS381C. This standard specifies colors used in identification,
coding, and other special purposes. See https://www.britishstandardcolour.com/
for more information.

To use the colors from this list, access them directly from the module (which
is exposed to fluxion's global name space):

.. code:: pycon

    >>> from fluxion import BS381
    >>> BS381.OXFORD_BLUE
    fluxionColor('#1F3057')

List of Color Constants
-----------------------

These hex values (taken from https://www.w3schools.com/colors/colors_british.asp)
are non official approximate values intended to simulate the ones defined
in the standard:

.. autofluxioncolormodule:: fluxion.utils.color.BS381

"""

from __future__ import annotations

from .core import fluxionColor

BS381_101 = fluxionColor("#94BFAC")
SKY_BLUE = fluxionColor("#94BFAC")
BS381_102 = fluxionColor("#5B9291")
TURQUOISE_BLUE = fluxionColor("#5B9291")
BS381_103 = fluxionColor("#3B6879")
PEACOCK_BLUE = fluxionColor("#3B6879")
BS381_104 = fluxionColor("#264D7E")
AZURE_BLUE = fluxionColor("#264D7E")
BS381_105 = fluxionColor("#1F3057")
OXFORD_BLUE = fluxionColor("#1F3057")
BS381_106 = fluxionColor("#2A283D")
ROYAL_BLUE = fluxionColor("#2A283D")
BS381_107 = fluxionColor("#3A73A9")
STRONG_BLUE = fluxionColor("#3A73A9")
BS381_108 = fluxionColor("#173679")
AIRCRAFT_BLUE = fluxionColor("#173679")
BS381_109 = fluxionColor("#1C5680")
MIDDLE_BLUE = fluxionColor("#1C5680")
BS381_110 = fluxionColor("#2C3E75")
ROUNDEL_BLUE = fluxionColor("#2C3E75")
BS381_111 = fluxionColor("#8CC5BB")
PALE_BLUE = fluxionColor("#8CC5BB")
BS381_112 = fluxionColor("#78ADC2")
ARCTIC_BLUE = fluxionColor("#78ADC2")
FIESTA_BLUE = fluxionColor("#78ADC2")
BS381_113 = fluxionColor("#3F687D")
DEEP_SAXE_BLUE = fluxionColor("#3F687D")
BS381_114 = fluxionColor("#1F4B61")
RAIL_BLUE = fluxionColor("#1F4B61")
BS381_115 = fluxionColor("#5F88C1")
COBALT_BLUE = fluxionColor("#5F88C1")
BS381_166 = fluxionColor("#2458AF")
FRENCH_BLUE = fluxionColor("#2458AF")
BS381_169 = fluxionColor("#135B75")
TRAFFIC_BLUE = fluxionColor("#135B75")
BS381_172 = fluxionColor("#A7C6EB")
PALE_ROUNDEL_BLUE = fluxionColor("#A7C6EB")
BS381_174 = fluxionColor("#64A0AA")
ORIENT_BLUE = fluxionColor("#64A0AA")
BS381_175 = fluxionColor("#4F81C5")
LIGHT_FRENCH_BLUE = fluxionColor("#4F81C5")
BS381_210 = fluxionColor("#BBC9A5")
SKY = fluxionColor("#BBC9A5")
BS381_216 = fluxionColor("#BCD890")
EAU_DE_NIL = fluxionColor("#BCD890")
BS381_217 = fluxionColor("#96BF65")
SEA_GREEN = fluxionColor("#96BF65")
BS381_218 = fluxionColor("#698B47")
GRASS_GREEN = fluxionColor("#698B47")
BS381_219 = fluxionColor("#757639")
SAGE_GREEN = fluxionColor("#757639")
BS381_220 = fluxionColor("#4B5729")
OLIVE_GREEN = fluxionColor("#4B5729")
BS381_221 = fluxionColor("#507D3A")
BRILLIANT_GREEN = fluxionColor("#507D3A")
BS381_222 = fluxionColor("#6A7031")
LIGHT_BRONZE_GREEN = fluxionColor("#6A7031")
BS381_223 = fluxionColor("#49523A")
MIDDLE_BRONZE_GREEN = fluxionColor("#49523A")
BS381_224 = fluxionColor("#3E4630")
DEEP_BRONZE_GREEN = fluxionColor("#3E4630")
BS381_225 = fluxionColor("#406A28")
LIGHT_BRUNSWICK_GREEN = fluxionColor("#406A28")
BS381_226 = fluxionColor("#33533B")
MID_BRUNSWICK_GREEN = fluxionColor("#33533B")
BS381_227 = fluxionColor("#254432")
DEEP_BRUNSWICK_GREEN = fluxionColor("#254432")
BS381_228 = fluxionColor("#428B64")
EMERALD_GREEN = fluxionColor("#428B64")
BS381_241 = fluxionColor("#4F5241")
DARK_GREEN = fluxionColor("#4F5241")
BS381_262 = fluxionColor("#44945E")
BOLD_GREEN = fluxionColor("#44945E")
BS381_267 = fluxionColor("#476A4C")
DEEP_CHROME_GREEN = fluxionColor("#476A4C")
TRAFFIC_GREEN = fluxionColor("#476A4C")
BS381_275 = fluxionColor("#8FC693")
OPALINE_GREEN = fluxionColor("#8FC693")
BS381_276 = fluxionColor("#2E4C1E")
LINCON_GREEN = fluxionColor("#2E4C1E")
BS381_277 = fluxionColor("#364A20")
CYPRESS_GREEN = fluxionColor("#364A20")
BS381_278 = fluxionColor("#87965A")
LIGHT_OLIVE_GREEN = fluxionColor("#87965A")
BS381_279 = fluxionColor("#3B3629")
STEEL_FURNITURE_GREEN = fluxionColor("#3B3629")
BS381_280 = fluxionColor("#68AB77")
VERDIGRIS_GREEN = fluxionColor("#68AB77")
BS381_282 = fluxionColor("#506B52")
FOREST_GREEN = fluxionColor("#506B52")
BS381_283 = fluxionColor("#7E8F6E")
AIRCRAFT_GREY_GREEN = fluxionColor("#7E8F6E")
BS381_284 = fluxionColor("#6B6F5A")
SPRUCE_GREEN = fluxionColor("#6B6F5A")
BS381_285 = fluxionColor("#5F5C4B")
NATO_GREEN = fluxionColor("#5F5C4B")
BS381_298 = fluxionColor("#4F5138")
OLIVE_DRAB = fluxionColor("#4F5138")
BS381_309 = fluxionColor("#FEEC04")
CANARY_YELLOW = fluxionColor("#FEEC04")
BS381_310 = fluxionColor("#FEF963")
PRIMROSE = fluxionColor("#FEF963")
BS381_315 = fluxionColor("#FEF96A")
GRAPEFRUIT = fluxionColor("#FEF96A")
BS381_320 = fluxionColor("#9E7339")
LIGHT_BROWN = fluxionColor("#9E7339")
BS381_337 = fluxionColor("#4C4A3C")
VERY_DARK_DRAB = fluxionColor("#4C4A3C")
BS381_350 = fluxionColor("#7B6B4F")
DARK_EARTH = fluxionColor("#7B6B4F")
BS381_352 = fluxionColor("#FCED96")
PALE_CREAM = fluxionColor("#FCED96")
BS381_353 = fluxionColor("#FDF07A")
DEEP_CREAM = fluxionColor("#FDF07A")
BS381_354 = fluxionColor("#E9BB43")
PRIMROSE_2 = fluxionColor("#E9BB43")
BS381_355 = fluxionColor("#FDD906")
LEMON = fluxionColor("#FDD906")
BS381_356 = fluxionColor("#FCC808")
GOLDEN_YELLOW = fluxionColor("#FCC808")
BS381_358 = fluxionColor("#F6C870")
LIGHT_BUFF = fluxionColor("#F6C870")
BS381_359 = fluxionColor("#DBAC50")
MIDDLE_BUFF = fluxionColor("#DBAC50")
BS381_361 = fluxionColor("#D4B97D")
LIGHT_STONE = fluxionColor("#D4B97D")
BS381_362 = fluxionColor("#AC7C42")
MIDDLE_STONE = fluxionColor("#AC7C42")
BS381_363 = fluxionColor("#FDE706")
BOLD_YELLOW = fluxionColor("#FDE706")
BS381_364 = fluxionColor("#CEC093")
PORTLAND_STONE = fluxionColor("#CEC093")
BS381_365 = fluxionColor("#F4F0BD")
VELLUM = fluxionColor("#F4F0BD")
BS381_366 = fluxionColor("#F5E7A1")
LIGHT_BEIGE = fluxionColor("#F5E7A1")
BS381_367 = fluxionColor("#FEF6BF")
MANILLA = fluxionColor("#fef6bf")
BS381_368 = fluxionColor("#DD7B00")
TRAFFIC_YELLOW = fluxionColor("#DD7B00")
BS381_369 = fluxionColor("#FEEBA8")
BISCUIT = fluxionColor("#feeba8")
BS381_380 = fluxionColor("#BBA38A")
CAMOUFLAGE_DESERT_SAND = fluxionColor("#BBA38A")
BS381_384 = fluxionColor("#EEDFA5")
LIGHT_STRAW = fluxionColor("#EEDFA5")
BS381_385 = fluxionColor("#E8C88F")
LIGHT_BISCUIT = fluxionColor("#E8C88F")
BS381_386 = fluxionColor("#E6C18D")
CHAMPAGNE = fluxionColor("#e6c18d")
BS381_387 = fluxionColor("#CFB48A")
SUNRISE = fluxionColor("#cfb48a")
SUNSHINE = fluxionColor("#cfb48a")
BS381_388 = fluxionColor("#E4CF93")
BEIGE = fluxionColor("#e4cf93")
BS381_389 = fluxionColor("#B2A788")
CAMOUFLAGE_BEIGE = fluxionColor("#B2A788")
BS381_397 = fluxionColor("#F3D163")
JASMINE_YELLOW = fluxionColor("#F3D163")
BS381_411 = fluxionColor("#74542F")
MIDDLE_BROWN = fluxionColor("#74542F")
BS381_412 = fluxionColor("#5C422E")
DARK_BROWN = fluxionColor("#5C422E")
BS381_413 = fluxionColor("#402D21")
NUT_BROWN = fluxionColor("#402D21")
BS381_414 = fluxionColor("#A86C29")
GOLDEN_BROWN = fluxionColor("#A86C29")
BS381_415 = fluxionColor("#61361E")
IMPERIAL_BROWN = fluxionColor("#61361E")
BS381_420 = fluxionColor("#A89177")
DARK_CAMOUFLAGE_DESERT_SAND = fluxionColor("#A89177")
BS381_435 = fluxionColor("#845B4D")
CAMOUFLAGE_RED = fluxionColor("#845B4D")
BS381_436 = fluxionColor("#564B47")
DARK_CAMOUFLAGE_BROWN = fluxionColor("#564B47")
BS381_439 = fluxionColor("#753B1E")
ORANGE_BROWN = fluxionColor("#753B1E")
BS381_443 = fluxionColor("#C98A71")
SALMON = fluxionColor("#c98a71")
BS381_444 = fluxionColor("#A65341")
TERRACOTTA = fluxionColor("#a65341")
BS381_445 = fluxionColor("#83422B")
VENETIAN_RED = fluxionColor("#83422B")
BS381_446 = fluxionColor("#774430")
RED_OXIDE = fluxionColor("#774430")
BS381_447 = fluxionColor("#F3B28B")
SALMON_PINK = fluxionColor("#F3B28B")
BS381_448 = fluxionColor("#67403A")
DEEP_INDIAN_RED = fluxionColor("#67403A")
BS381_449 = fluxionColor("#693B3F")
LIGHT_PURPLE_BROWN = fluxionColor("#693B3F")
BS381_452 = fluxionColor("#613339")
DARK_CRIMSON = fluxionColor("#613339")
BS381_453 = fluxionColor("#FBDED6")
SHELL_PINK = fluxionColor("#FBDED6")
BS381_454 = fluxionColor("#E8A1A2")
PALE_ROUNDEL_RED = fluxionColor("#E8A1A2")
BS381_460 = fluxionColor("#BD8F56")
DEEP_BUFF = fluxionColor("#BD8F56")
BS381_473 = fluxionColor("#793932")
GULF_RED = fluxionColor("#793932")
BS381_489 = fluxionColor("#8D5B41")
LEAF_BROWN = fluxionColor("#8D5B41")
BS381_490 = fluxionColor("#573320")
BEECH_BROWN = fluxionColor("#573320")
BS381_499 = fluxionColor("#59493E")
SERVICE_BROWN = fluxionColor("#59493E")
BS381_536 = fluxionColor("#BB3016")
POPPY = fluxionColor("#bb3016")
BS381_537 = fluxionColor("#DD3420")
SIGNAL_RED = fluxionColor("#DD3420")
BS381_538 = fluxionColor("#C41C22")
POST_OFFICE_RED = fluxionColor("#C41C22")
CHERRY = fluxionColor("#c41c22")
BS381_539 = fluxionColor("#D21E2B")
CURRANT_RED = fluxionColor("#D21E2B")
BS381_540 = fluxionColor("#8B1A32")
CRIMSON = fluxionColor("#8b1a32")
BS381_541 = fluxionColor("#471B21")
MAROON = fluxionColor("#471b21")
BS381_542 = fluxionColor("#982D57")
RUBY = fluxionColor("#982d57")
BS381_557 = fluxionColor("#EF841E")
LIGHT_ORANGE = fluxionColor("#EF841E")
BS381_564 = fluxionColor("#DD3524")
BOLD_RED = fluxionColor("#DD3524")
BS381_568 = fluxionColor("#FB9C06")
APRICOT = fluxionColor("#fb9c06")
BS381_570 = fluxionColor("#A83C19")
TRAFFIC_RED = fluxionColor("#A83C19")
BS381_591 = fluxionColor("#D04E09")
DEEP_ORANGE = fluxionColor("#D04E09")
BS381_592 = fluxionColor("#E45523")
INTERNATIONAL_ORANGE = fluxionColor("#E45523")
BS381_593 = fluxionColor("#F24816")
RAIL_RED = fluxionColor("#F24816")
AZO_ORANGE = fluxionColor("#F24816")
BS381_626 = fluxionColor("#A0A9AA")
CAMOUFLAGE_GREY = fluxionColor("#A0A9AA")
BS381_627 = fluxionColor("#BEC0B8")
LIGHT_AIRCRAFT_GREY = fluxionColor("#BEC0B8")
BS381_628 = fluxionColor("#9D9D7E")
SILVER_GREY = fluxionColor("#9D9D7E")
BS381_629 = fluxionColor("#7A838B")
DARK_CAMOUFLAGE_GREY = fluxionColor("#7A838B")
BS381_630 = fluxionColor("#A5AD98")
FRENCH_GREY = fluxionColor("#A5AD98")
BS381_631 = fluxionColor("#9AAA9F")
LIGHT_GREY = fluxionColor("#9AAA9F")
BS381_632 = fluxionColor("#6B7477")
DARK_ADMIRALTY_GREY = fluxionColor("#6B7477")
BS381_633 = fluxionColor("#424C53")
RAF_BLUE_GREY = fluxionColor("#424C53")
BS381_634 = fluxionColor("#6F7264")
SLATE = fluxionColor("#6f7264")
BS381_635 = fluxionColor("#525B55")
LEAD = fluxionColor("#525b55")
BS381_636 = fluxionColor("#5F7682")
PRU_BLUE = fluxionColor("#5F7682")
BS381_637 = fluxionColor("#8E9B9C")
MEDIUM_SEA_GREY = fluxionColor("#8E9B9C")
BS381_638 = fluxionColor("#6C7377")
DARK_SEA_GREY = fluxionColor("#6C7377")
BS381_639 = fluxionColor("#667563")
LIGHT_SLATE_GREY = fluxionColor("#667563")
BS381_640 = fluxionColor("#566164")
EXTRA_DARK_SEA_GREY = fluxionColor("#566164")
BS381_642 = fluxionColor("#282B2F")
NIGHT = fluxionColor("#282b2f")
BS381_671 = fluxionColor("#4E5355")
MIDDLE_GRAPHITE = fluxionColor("#4E5355")
BS381_676 = fluxionColor("#A9B7B9")
LIGHT_WEATHERWORK_GREY = fluxionColor("#A9B7B9")
BS381_677 = fluxionColor("#676F76")
DARK_WEATHERWORK_GREY = fluxionColor("#676F76")
BS381_692 = fluxionColor("#7B93A3")
SMOKE_GREY = fluxionColor("#7B93A3")
BS381_693 = fluxionColor("#88918D")
AIRCRAFT_GREY = fluxionColor("#88918D")
BS381_694 = fluxionColor("#909A92")
DOVE_GREY = fluxionColor("#909A92")
BS381_697 = fluxionColor("#B6D3CC")
LIGHT_ADMIRALTY_GREY = fluxionColor("#B6D3CC")
BS381_796 = fluxionColor("#6E4A75")
DARK_VIOLET = fluxionColor("#6E4A75")
BS381_797 = fluxionColor("#C9A8CE")
LIGHT_VIOLET = fluxionColor("#C9A8CE")
