r"""dvips Colors

This module contains the colors defined in the dvips driver, which are commonly accessed
as named colors in LaTeX via the ``\usepackage[dvipsnames]{xcolor}`` package.

To use the colors from this list, access them directly from the module (which
is exposed to fluxion's global name space):

.. code:: pycon

    >>> from fluxion import DVIPSNAMES
    >>> DVIPSNAMES.DARKORCHID
    fluxionColor('#A4538A')

List of Color Constants
-----------------------

These hex values are derived from those specified in the ``xcolor`` package
documentation (see https://ctan.org/pkg/xcolor):

.. autofluxioncolormodule:: fluxion.utils.color.DVIPSNAMES

"""

from __future__ import annotations

from .core import fluxionColor

AQUAMARINE = fluxionColor("#00B5BE")
BITTERSWEET = fluxionColor("#C04F17")
APRICOT = fluxionColor("#FBB982")
BLACK = fluxionColor("#221E1F")
BLUE = fluxionColor("#2D2F92")
BLUEGREEN = fluxionColor("#00B3B8")
BLUEVIOLET = fluxionColor("#473992")
BRICKRED = fluxionColor("#B6321C")
BROWN = fluxionColor("#792500")
BURNTORANGE = fluxionColor("#F7921D")
CADETBLUE = fluxionColor("#74729A")
CARNATIONPINK = fluxionColor("#F282B4")
CERULEAN = fluxionColor("#00A2E3")
CORNFLOWERBLUE = fluxionColor("#41B0E4")
CYAN = fluxionColor("#00AEEF")
DANDELION = fluxionColor("#FDBC42")
DARKORCHID = fluxionColor("#A4538A")
EMERALD = fluxionColor("#00A99D")
FORESTGREEN = fluxionColor("#009B55")
FUCHSIA = fluxionColor("#8C368C")
GOLDENROD = fluxionColor("#FFDF42")
GRAY = fluxionColor("#949698")
GREEN = fluxionColor("#00A64F")
GREENYELLOW = fluxionColor("#DFE674")
JUNGLEGREEN = fluxionColor("#00A99A")
LAVENDER = fluxionColor("#F49EC4")
LIMEGREEN = fluxionColor("#8DC73E")
MAGENTA = fluxionColor("#EC008C")
MAHOGANY = fluxionColor("#A9341F")
MAROON = fluxionColor("#AF3235")
MELON = fluxionColor("#F89E7B")
MIDNIGHTBLUE = fluxionColor("#006795")
MULBERRY = fluxionColor("#A93C93")
NAVYBLUE = fluxionColor("#006EB8")
OLIVEGREEN = fluxionColor("#3C8031")
ORANGE = fluxionColor("#F58137")
ORANGERED = fluxionColor("#ED135A")
ORCHID = fluxionColor("#AF72B0")
PEACH = fluxionColor("#F7965A")
PERIWINKLE = fluxionColor("#7977B8")
PINEGREEN = fluxionColor("#008B72")
PLUM = fluxionColor("#92268F")
PROCESSBLUE = fluxionColor("#00B0F0")
PURPLE = fluxionColor("#99479B")
RAWSIENNA = fluxionColor("#974006")
RED = fluxionColor("#ED1B23")
REDORANGE = fluxionColor("#F26035")
REDVIOLET = fluxionColor("#A1246B")
RHODAMINE = fluxionColor("#EF559F")
ROYALBLUE = fluxionColor("#0071BC")
ROYALPURPLE = fluxionColor("#613F99")
RUBINERED = fluxionColor("#ED017D")
SALMON = fluxionColor("#F69289")
SEAGREEN = fluxionColor("#3FBC9D")
SEPIA = fluxionColor("#671800")
SKYBLUE = fluxionColor("#46C5DD")
SPRINGGREEN = fluxionColor("#C6DC67")
TAN = fluxionColor("#DA9D76")
TEALBLUE = fluxionColor("#00AEB3")
THISTLE = fluxionColor("#D883B7")
TURQUOISE = fluxionColor("#00B4CE")
VIOLET = fluxionColor("#58429B")
VIOLETRED = fluxionColor("#EF58A0")
WHITE = fluxionColor("#FFFFFF")
WILDSTRAWBERRY = fluxionColor("#EE2967")
YELLOW = fluxionColor("#FFF200")
YELLOWGREEN = fluxionColor("#98CC70")
YELLOWORANGE = fluxionColor("#FAA21A")
