r"""SVG 1.1 Colors

This module contains the colors defined in the SVG 1.1 specification, which are commonly
accessed as named colors in LaTeX via the ``\usepackage[svgnames]{xcolor}`` package.

To use the colors from this list, access them directly from the module (which
is exposed to fluxion's global name space):

.. code:: pycon

    >>> from fluxion import SVGNAMES
    >>> SVGNAMES.LIGHTCORAL
    fluxionColor('#EF7F7F')

List of Color Constants
-----------------------

These hex values are derived from those specified in the ``xcolor`` package
documentation (see https://ctan.org/pkg/xcolor):

.. autofluxioncolormodule:: fluxion.utils.color.SVGNAMES

"""

from __future__ import annotations

from .core import fluxionColor

ALICEBLUE = fluxionColor("#EFF7FF")
ANTIQUEWHITE = fluxionColor("#F9EAD7")
AQUA = fluxionColor("#00FFFF")
AQUAMARINE = fluxionColor("#7EFFD3")
AZURE = fluxionColor("#EFFFFF")
BEIGE = fluxionColor("#F4F4DC")
BISQUE = fluxionColor("#FFE3C4")
BLACK = fluxionColor("#000000")
BLANCHEDALMOND = fluxionColor("#FFEACD")
BLUE = fluxionColor("#0000FF")
BLUEVIOLET = fluxionColor("#892BE2")
BROWN = fluxionColor("#A52A2A")
BURLYWOOD = fluxionColor("#DDB787")
CADETBLUE = fluxionColor("#5E9EA0")
CHARTREUSE = fluxionColor("#7EFF00")
CHOCOLATE = fluxionColor("#D2681D")
CORAL = fluxionColor("#FF7E4F")
CORNFLOWERBLUE = fluxionColor("#6395ED")
CORNSILK = fluxionColor("#FFF7DC")
CRIMSON = fluxionColor("#DC143B")
CYAN = fluxionColor("#00FFFF")
DARKBLUE = fluxionColor("#00008A")
DARKCYAN = fluxionColor("#008A8A")
DARKGOLDENROD = fluxionColor("#B7850B")
DARKGRAY = fluxionColor("#A9A9A9")
DARKGREEN = fluxionColor("#006300")
DARKGREY = fluxionColor("#A9A9A9")
DARKKHAKI = fluxionColor("#BCB66B")
DARKMAGENTA = fluxionColor("#8A008A")
DARKOLIVEGREEN = fluxionColor("#546B2F")
DARKORANGE = fluxionColor("#FF8C00")
DARKORCHID = fluxionColor("#9931CC")
DARKRED = fluxionColor("#8A0000")
DARKSALMON = fluxionColor("#E8967A")
DARKSEAGREEN = fluxionColor("#8EBB8E")
DARKSLATEBLUE = fluxionColor("#483D8A")
DARKSLATEGRAY = fluxionColor("#2F4F4F")
DARKSLATEGREY = fluxionColor("#2F4F4F")
DARKTURQUOISE = fluxionColor("#00CED1")
DARKVIOLET = fluxionColor("#9300D3")
DEEPPINK = fluxionColor("#FF1492")
DEEPSKYBLUE = fluxionColor("#00BFFF")
DIMGRAY = fluxionColor("#686868")
DIMGREY = fluxionColor("#686868")
DODGERBLUE = fluxionColor("#1D90FF")
FIREBRICK = fluxionColor("#B12121")
FLORALWHITE = fluxionColor("#FFF9EF")
FORESTGREEN = fluxionColor("#218A21")
FUCHSIA = fluxionColor("#FF00FF")
GAINSBORO = fluxionColor("#DCDCDC")
GHOSTWHITE = fluxionColor("#F7F7FF")
GOLD = fluxionColor("#FFD700")
GOLDENROD = fluxionColor("#DAA51F")
GRAY = fluxionColor("#7F7F7F")
GREEN = fluxionColor("#007F00")
GREENYELLOW = fluxionColor("#ADFF2F")
GREY = fluxionColor("#7F7F7F")
HONEYDEW = fluxionColor("#EFFFEF")
HOTPINK = fluxionColor("#FF68B3")
INDIANRED = fluxionColor("#CD5B5B")
INDIGO = fluxionColor("#4A0082")
IVORY = fluxionColor("#FFFFEF")
KHAKI = fluxionColor("#EFE58C")
LAVENDER = fluxionColor("#E5E5F9")
LAVENDERBLUSH = fluxionColor("#FFEFF4")
LAWNGREEN = fluxionColor("#7CFC00")
LEMONCHIFFON = fluxionColor("#FFF9CD")
LIGHTBLUE = fluxionColor("#ADD8E5")
LIGHTCORAL = fluxionColor("#EF7F7F")
LIGHTCYAN = fluxionColor("#E0FFFF")
LIGHTGOLDENROD = fluxionColor("#EDDD82")
LIGHTGOLDENRODYELLOW = fluxionColor("#F9F9D2")
LIGHTGRAY = fluxionColor("#D3D3D3")
LIGHTGREEN = fluxionColor("#90ED90")
LIGHTGREY = fluxionColor("#D3D3D3")
LIGHTPINK = fluxionColor("#FFB5C0")
LIGHTSALMON = fluxionColor("#FFA07A")
LIGHTSEAGREEN = fluxionColor("#1FB1AA")
LIGHTSKYBLUE = fluxionColor("#87CEF9")
LIGHTSLATEBLUE = fluxionColor("#8470FF")
LIGHTSLATEGRAY = fluxionColor("#778799")
LIGHTSLATEGREY = fluxionColor("#778799")
LIGHTSTEELBLUE = fluxionColor("#AFC4DD")
LIGHTYELLOW = fluxionColor("#FFFFE0")
LIME = fluxionColor("#00FF00")
LIMEGREEN = fluxionColor("#31CD31")
LINEN = fluxionColor("#F9EFE5")
MAGENTA = fluxionColor("#FF00FF")
MAROON = fluxionColor("#7F0000")
MEDIUMAQUAMARINE = fluxionColor("#66CDAA")
MEDIUMBLUE = fluxionColor("#0000CD")
MEDIUMORCHID = fluxionColor("#BA54D3")
MEDIUMPURPLE = fluxionColor("#9270DB")
MEDIUMSEAGREEN = fluxionColor("#3BB271")
MEDIUMSLATEBLUE = fluxionColor("#7B68ED")
MEDIUMSPRINGGREEN = fluxionColor("#00F99A")
MEDIUMTURQUOISE = fluxionColor("#48D1CC")
MEDIUMVIOLETRED = fluxionColor("#C61584")
MIDNIGHTBLUE = fluxionColor("#181870")
MINTCREAM = fluxionColor("#F4FFF9")
MISTYROSE = fluxionColor("#FFE3E1")
MOCCASIN = fluxionColor("#FFE3B5")
NAVAJOWHITE = fluxionColor("#FFDDAD")
NAVY = fluxionColor("#00007F")
NAVYBLUE = fluxionColor("#00007F")
OLDLACE = fluxionColor("#FCF4E5")
OLIVE = fluxionColor("#7F7F00")
OLIVEDRAB = fluxionColor("#6B8D22")
ORANGE = fluxionColor("#FFA500")
ORANGERED = fluxionColor("#FF4400")
ORCHID = fluxionColor("#DA70D6")
PALEGOLDENROD = fluxionColor("#EDE8AA")
PALEGREEN = fluxionColor("#97FB97")
PALETURQUOISE = fluxionColor("#AFEDED")
PALEVIOLETRED = fluxionColor("#DB7092")
PAPAYAWHIP = fluxionColor("#FFEED4")
PEACHPUFF = fluxionColor("#FFDAB8")
PERU = fluxionColor("#CD843F")
PINK = fluxionColor("#FFBFCA")
PLUM = fluxionColor("#DDA0DD")
POWDERBLUE = fluxionColor("#AFE0E5")
PURPLE = fluxionColor("#7F007F")
RED = fluxionColor("#FF0000")
ROSYBROWN = fluxionColor("#BB8E8E")
ROYALBLUE = fluxionColor("#4168E1")
SADDLEBROWN = fluxionColor("#8A4413")
SALMON = fluxionColor("#F97F72")
SANDYBROWN = fluxionColor("#F3A45F")
SEAGREEN = fluxionColor("#2D8A56")
SEASHELL = fluxionColor("#FFF4ED")
SIENNA = fluxionColor("#A0512C")
SILVER = fluxionColor("#BFBFBF")
SKYBLUE = fluxionColor("#87CEEA")
SLATEBLUE = fluxionColor("#6959CD")
SLATEGRAY = fluxionColor("#707F90")
SLATEGREY = fluxionColor("#707F90")
SNOW = fluxionColor("#FFF9F9")
SPRINGGREEN = fluxionColor("#00FF7E")
STEELBLUE = fluxionColor("#4682B3")
TAN = fluxionColor("#D2B38C")
TEAL = fluxionColor("#007F7F")
THISTLE = fluxionColor("#D8BFD8")
TOMATO = fluxionColor("#FF6347")
TURQUOISE = fluxionColor("#3FE0CF")
VIOLET = fluxionColor("#ED82ED")
VIOLETRED = fluxionColor("#D01F90")
WHEAT = fluxionColor("#F4DDB2")
WHITE = fluxionColor("#FFFFFF")
WHITESMOKE = fluxionColor("#F4F4F4")
YELLOW = fluxionColor("#FFFF00")
YELLOWGREEN = fluxionColor("#9ACD30")
