# from https://www.w3schools.com/colors/colors_x11.asp

"""X11 Colors

These color and their names (taken from
https://www.w3schools.com/colors/colors_x11.asp) were developed at the
Massachusetts Intitute of Technology (MIT) during
the development of color based computer display system.

To use the colors from this list, access them directly from the module (which
is exposed to fluxion's global name space):

.. code:: pycon

    >>> from fluxion import X11
    >>> X11.BEIGE
    fluxionColor('#F5F5DC')


List of Color Constants
-----------------------

.. autofluxioncolormodule:: fluxion.utils.color.X11
"""

from __future__ import annotations

from .core import fluxionColor

ALICEBLUE = fluxionColor("#F0F8FF")
ANTIQUEWHITE = fluxionColor("#FAEBD7")
ANTIQUEWHITE1 = fluxionColor("#FFEFDB")
ANTIQUEWHITE2 = fluxionColor("#EEDFCC")
ANTIQUEWHITE3 = fluxionColor("#CDC0B0")
ANTIQUEWHITE4 = fluxionColor("#8B8378")
AQUAMARINE1 = fluxionColor("#7FFFD4")
AQUAMARINE2 = fluxionColor("#76EEC6")
AQUAMARINE4 = fluxionColor("#458B74")
AZURE1 = fluxionColor("#F0FFFF")
AZURE2 = fluxionColor("#E0EEEE")
AZURE3 = fluxionColor("#C1CDCD")
AZURE4 = fluxionColor("#838B8B")
BEIGE = fluxionColor("#F5F5DC")
BISQUE1 = fluxionColor("#FFE4C4")
BISQUE2 = fluxionColor("#EED5B7")
BISQUE3 = fluxionColor("#CDB79E")
BISQUE4 = fluxionColor("#8B7D6B")
BLACK = fluxionColor("#000000")
BLANCHEDALMOND = fluxionColor("#FFEBCD")
BLUE1 = fluxionColor("#0000FF")
BLUE2 = fluxionColor("#0000EE")
BLUE4 = fluxionColor("#00008B")
BLUEVIOLET = fluxionColor("#8A2BE2")
BROWN = fluxionColor("#A52A2A")
BROWN1 = fluxionColor("#FF4040")
BROWN2 = fluxionColor("#EE3B3B")
BROWN3 = fluxionColor("#CD3333")
BROWN4 = fluxionColor("#8B2323")
BURLYWOOD = fluxionColor("#DEB887")
BURLYWOOD1 = fluxionColor("#FFD39B")
BURLYWOOD2 = fluxionColor("#EEC591")
BURLYWOOD3 = fluxionColor("#CDAA7D")
BURLYWOOD4 = fluxionColor("#8B7355")
CADETBLUE = fluxionColor("#5F9EA0")
CADETBLUE1 = fluxionColor("#98F5FF")
CADETBLUE2 = fluxionColor("#8EE5EE")
CADETBLUE3 = fluxionColor("#7AC5CD")
CADETBLUE4 = fluxionColor("#53868B")
CHARTREUSE1 = fluxionColor("#7FFF00")
CHARTREUSE2 = fluxionColor("#76EE00")
CHARTREUSE3 = fluxionColor("#66CD00")
CHARTREUSE4 = fluxionColor("#458B00")
CHOCOLATE = fluxionColor("#D2691E")
CHOCOLATE1 = fluxionColor("#FF7F24")
CHOCOLATE2 = fluxionColor("#EE7621")
CHOCOLATE3 = fluxionColor("#CD661D")
CORAL = fluxionColor("#FF7F50")
CORAL1 = fluxionColor("#FF7256")
CORAL2 = fluxionColor("#EE6A50")
CORAL3 = fluxionColor("#CD5B45")
CORAL4 = fluxionColor("#8B3E2F")
CORNFLOWERBLUE = fluxionColor("#6495ED")
CORNSILK1 = fluxionColor("#FFF8DC")
CORNSILK2 = fluxionColor("#EEE8CD")
CORNSILK3 = fluxionColor("#CDC8B1")
CORNSILK4 = fluxionColor("#8B8878")
CYAN1 = fluxionColor("#00FFFF")
CYAN2 = fluxionColor("#00EEEE")
CYAN3 = fluxionColor("#00CDCD")
CYAN4 = fluxionColor("#008B8B")
DARKGOLDENROD = fluxionColor("#B8860B")
DARKGOLDENROD1 = fluxionColor("#FFB90F")
DARKGOLDENROD2 = fluxionColor("#EEAD0E")
DARKGOLDENROD3 = fluxionColor("#CD950C")
DARKGOLDENROD4 = fluxionColor("#8B6508")
DARKGREEN = fluxionColor("#006400")
DARKKHAKI = fluxionColor("#BDB76B")
DARKOLIVEGREEN = fluxionColor("#556B2F")
DARKOLIVEGREEN1 = fluxionColor("#CAFF70")
DARKOLIVEGREEN2 = fluxionColor("#BCEE68")
DARKOLIVEGREEN3 = fluxionColor("#A2CD5A")
DARKOLIVEGREEN4 = fluxionColor("#6E8B3D")
DARKORANGE = fluxionColor("#FF8C00")
DARKORANGE1 = fluxionColor("#FF7F00")
DARKORANGE2 = fluxionColor("#EE7600")
DARKORANGE3 = fluxionColor("#CD6600")
DARKORANGE4 = fluxionColor("#8B4500")
DARKORCHID = fluxionColor("#9932CC")
DARKORCHID1 = fluxionColor("#BF3EFF")
DARKORCHID2 = fluxionColor("#B23AEE")
DARKORCHID3 = fluxionColor("#9A32CD")
DARKORCHID4 = fluxionColor("#68228B")
DARKSALMON = fluxionColor("#E9967A")
DARKSEAGREEN = fluxionColor("#8FBC8F")
DARKSEAGREEN1 = fluxionColor("#C1FFC1")
DARKSEAGREEN2 = fluxionColor("#B4EEB4")
DARKSEAGREEN3 = fluxionColor("#9BCD9B")
DARKSEAGREEN4 = fluxionColor("#698B69")
DARKSLATEBLUE = fluxionColor("#483D8B")
DARKSLATEGRAY = fluxionColor("#2F4F4F")
DARKSLATEGRAY1 = fluxionColor("#97FFFF")
DARKSLATEGRAY2 = fluxionColor("#8DEEEE")
DARKSLATEGRAY3 = fluxionColor("#79CDCD")
DARKSLATEGRAY4 = fluxionColor("#528B8B")
DARKTURQUOISE = fluxionColor("#00CED1")
DARKVIOLET = fluxionColor("#9400D3")
DEEPPINK1 = fluxionColor("#FF1493")
DEEPPINK2 = fluxionColor("#EE1289")
DEEPPINK3 = fluxionColor("#CD1076")
DEEPPINK4 = fluxionColor("#8B0A50")
DEEPSKYBLUE1 = fluxionColor("#00BFFF")
DEEPSKYBLUE2 = fluxionColor("#00B2EE")
DEEPSKYBLUE3 = fluxionColor("#009ACD")
DEEPSKYBLUE4 = fluxionColor("#00688B")
DIMGRAY = fluxionColor("#696969")
DODGERBLUE1 = fluxionColor("#1E90FF")
DODGERBLUE2 = fluxionColor("#1C86EE")
DODGERBLUE3 = fluxionColor("#1874CD")
DODGERBLUE4 = fluxionColor("#104E8B")
FIREBRICK = fluxionColor("#B22222")
FIREBRICK1 = fluxionColor("#FF3030")
FIREBRICK2 = fluxionColor("#EE2C2C")
FIREBRICK3 = fluxionColor("#CD2626")
FIREBRICK4 = fluxionColor("#8B1A1A")
FLORALWHITE = fluxionColor("#FFFAF0")
FORESTGREEN = fluxionColor("#228B22")
GAINSBORO = fluxionColor("#DCDCDC")
GHOSTWHITE = fluxionColor("#F8F8FF")
GOLD1 = fluxionColor("#FFD700")
GOLD2 = fluxionColor("#EEC900")
GOLD3 = fluxionColor("#CDAD00")
GOLD4 = fluxionColor("#8B7500")
GOLDENROD = fluxionColor("#DAA520")
GOLDENROD1 = fluxionColor("#FFC125")
GOLDENROD2 = fluxionColor("#EEB422")
GOLDENROD3 = fluxionColor("#CD9B1D")
GOLDENROD4 = fluxionColor("#8B6914")
GRAY = fluxionColor("#BEBEBE")
GRAY1 = fluxionColor("#030303")
GRAY2 = fluxionColor("#050505")
GRAY3 = fluxionColor("#080808")
GRAY4 = fluxionColor("#0A0A0A")
GRAY5 = fluxionColor("#0D0D0D")
GRAY6 = fluxionColor("#0F0F0F")
GRAY7 = fluxionColor("#121212")
GRAY8 = fluxionColor("#141414")
GRAY9 = fluxionColor("#171717")
GRAY10 = fluxionColor("#1A1A1A")
GRAY11 = fluxionColor("#1C1C1C")
GRAY12 = fluxionColor("#1F1F1F")
GRAY13 = fluxionColor("#212121")
GRAY14 = fluxionColor("#242424")
GRAY15 = fluxionColor("#262626")
GRAY16 = fluxionColor("#292929")
GRAY17 = fluxionColor("#2B2B2B")
GRAY18 = fluxionColor("#2E2E2E")
GRAY19 = fluxionColor("#303030")
GRAY20 = fluxionColor("#333333")
GRAY21 = fluxionColor("#363636")
GRAY22 = fluxionColor("#383838")
GRAY23 = fluxionColor("#3B3B3B")
GRAY24 = fluxionColor("#3D3D3D")
GRAY25 = fluxionColor("#404040")
GRAY26 = fluxionColor("#424242")
GRAY27 = fluxionColor("#454545")
GRAY28 = fluxionColor("#474747")
GRAY29 = fluxionColor("#4A4A4A")
GRAY30 = fluxionColor("#4D4D4D")
GRAY31 = fluxionColor("#4F4F4F")
GRAY32 = fluxionColor("#525252")
GRAY33 = fluxionColor("#545454")
GRAY34 = fluxionColor("#575757")
GRAY35 = fluxionColor("#595959")
GRAY36 = fluxionColor("#5C5C5C")
GRAY37 = fluxionColor("#5E5E5E")
GRAY38 = fluxionColor("#616161")
GRAY39 = fluxionColor("#636363")
GRAY40 = fluxionColor("#666666")
GRAY41 = fluxionColor("#696969")
GRAY42 = fluxionColor("#6B6B6B")
GRAY43 = fluxionColor("#6E6E6E")
GRAY44 = fluxionColor("#707070")
GRAY45 = fluxionColor("#737373")
GRAY46 = fluxionColor("#757575")
GRAY47 = fluxionColor("#787878")
GRAY48 = fluxionColor("#7A7A7A")
GRAY49 = fluxionColor("#7D7D7D")
GRAY50 = fluxionColor("#7F7F7F")
GRAY51 = fluxionColor("#828282")
GRAY52 = fluxionColor("#858585")
GRAY53 = fluxionColor("#878787")
GRAY54 = fluxionColor("#8A8A8A")
GRAY55 = fluxionColor("#8C8C8C")
GRAY56 = fluxionColor("#8F8F8F")
GRAY57 = fluxionColor("#919191")
GRAY58 = fluxionColor("#949494")
GRAY59 = fluxionColor("#969696")
GRAY60 = fluxionColor("#999999")
GRAY61 = fluxionColor("#9C9C9C")
GRAY62 = fluxionColor("#9E9E9E")
GRAY63 = fluxionColor("#A1A1A1")
GRAY64 = fluxionColor("#A3A3A3")
GRAY65 = fluxionColor("#A6A6A6")
GRAY66 = fluxionColor("#A8A8A8")
GRAY67 = fluxionColor("#ABABAB")
GRAY68 = fluxionColor("#ADADAD")
GRAY69 = fluxionColor("#B0B0B0")
GRAY70 = fluxionColor("#B3B3B3")
GRAY71 = fluxionColor("#B5B5B5")
GRAY72 = fluxionColor("#B8B8B8")
GRAY73 = fluxionColor("#BABABA")
GRAY74 = fluxionColor("#BDBDBD")
GRAY75 = fluxionColor("#BFBFBF")
GRAY76 = fluxionColor("#C2C2C2")
GRAY77 = fluxionColor("#C4C4C4")
GRAY78 = fluxionColor("#C7C7C7")
GRAY79 = fluxionColor("#C9C9C9")
GRAY80 = fluxionColor("#CCCCCC")
GRAY81 = fluxionColor("#CFCFCF")
GRAY82 = fluxionColor("#D1D1D1")
GRAY83 = fluxionColor("#D4D4D4")
GRAY84 = fluxionColor("#D6D6D6")
GRAY85 = fluxionColor("#D9D9D9")
GRAY86 = fluxionColor("#DBDBDB")
GRAY87 = fluxionColor("#DEDEDE")
GRAY88 = fluxionColor("#E0E0E0")
GRAY89 = fluxionColor("#E3E3E3")
GRAY90 = fluxionColor("#E5E5E5")
GRAY91 = fluxionColor("#E8E8E8")
GRAY92 = fluxionColor("#EBEBEB")
GRAY93 = fluxionColor("#EDEDED")
GRAY94 = fluxionColor("#F0F0F0")
GRAY95 = fluxionColor("#F2F2F2")
GRAY97 = fluxionColor("#F7F7F7")
GRAY98 = fluxionColor("#FAFAFA")
GRAY99 = fluxionColor("#FCFCFC")
GREEN1 = fluxionColor("#00FF00")
GREEN2 = fluxionColor("#00EE00")
GREEN3 = fluxionColor("#00CD00")
GREEN4 = fluxionColor("#008B00")
GREENYELLOW = fluxionColor("#ADFF2F")
HONEYDEW1 = fluxionColor("#F0FFF0")
HONEYDEW2 = fluxionColor("#E0EEE0")
HONEYDEW3 = fluxionColor("#C1CDC1")
HONEYDEW4 = fluxionColor("#838B83")
HOTPINK = fluxionColor("#FF69B4")
HOTPINK1 = fluxionColor("#FF6EB4")
HOTPINK2 = fluxionColor("#EE6AA7")
HOTPINK3 = fluxionColor("#CD6090")
HOTPINK4 = fluxionColor("#8B3A62")
INDIANRED = fluxionColor("#CD5C5C")
INDIANRED1 = fluxionColor("#FF6A6A")
INDIANRED2 = fluxionColor("#EE6363")
INDIANRED3 = fluxionColor("#CD5555")
INDIANRED4 = fluxionColor("#8B3A3A")
IVORY1 = fluxionColor("#FFFFF0")
IVORY2 = fluxionColor("#EEEEE0")
IVORY3 = fluxionColor("#CDCDC1")
IVORY4 = fluxionColor("#8B8B83")
KHAKI = fluxionColor("#F0E68C")
KHAKI1 = fluxionColor("#FFF68F")
KHAKI2 = fluxionColor("#EEE685")
KHAKI3 = fluxionColor("#CDC673")
KHAKI4 = fluxionColor("#8B864E")
LAVENDER = fluxionColor("#E6E6FA")
LAVENDERBLUSH1 = fluxionColor("#FFF0F5")
LAVENDERBLUSH2 = fluxionColor("#EEE0E5")
LAVENDERBLUSH3 = fluxionColor("#CDC1C5")
LAVENDERBLUSH4 = fluxionColor("#8B8386")
LAWNGREEN = fluxionColor("#7CFC00")
LEMONCHIFFON1 = fluxionColor("#FFFACD")
LEMONCHIFFON2 = fluxionColor("#EEE9BF")
LEMONCHIFFON3 = fluxionColor("#CDC9A5")
LEMONCHIFFON4 = fluxionColor("#8B8970")
LIGHT = fluxionColor("#EEDD82")
LIGHTBLUE = fluxionColor("#ADD8E6")
LIGHTBLUE1 = fluxionColor("#BFEFFF")
LIGHTBLUE2 = fluxionColor("#B2DFEE")
LIGHTBLUE3 = fluxionColor("#9AC0CD")
LIGHTBLUE4 = fluxionColor("#68838B")
LIGHTCORAL = fluxionColor("#F08080")
LIGHTCYAN1 = fluxionColor("#E0FFFF")
LIGHTCYAN2 = fluxionColor("#D1EEEE")
LIGHTCYAN3 = fluxionColor("#B4CDCD")
LIGHTCYAN4 = fluxionColor("#7A8B8B")
LIGHTGOLDENROD1 = fluxionColor("#FFEC8B")
LIGHTGOLDENROD2 = fluxionColor("#EEDC82")
LIGHTGOLDENROD3 = fluxionColor("#CDBE70")
LIGHTGOLDENROD4 = fluxionColor("#8B814C")
LIGHTGOLDENRODYELLOW = fluxionColor("#FAFAD2")
LIGHTGRAY = fluxionColor("#D3D3D3")
LIGHTPINK = fluxionColor("#FFB6C1")
LIGHTPINK1 = fluxionColor("#FFAEB9")
LIGHTPINK2 = fluxionColor("#EEA2AD")
LIGHTPINK3 = fluxionColor("#CD8C95")
LIGHTPINK4 = fluxionColor("#8B5F65")
LIGHTSALMON1 = fluxionColor("#FFA07A")
LIGHTSALMON2 = fluxionColor("#EE9572")
LIGHTSALMON3 = fluxionColor("#CD8162")
LIGHTSALMON4 = fluxionColor("#8B5742")
LIGHTSEAGREEN = fluxionColor("#20B2AA")
LIGHTSKYBLUE = fluxionColor("#87CEFA")
LIGHTSKYBLUE1 = fluxionColor("#B0E2FF")
LIGHTSKYBLUE2 = fluxionColor("#A4D3EE")
LIGHTSKYBLUE3 = fluxionColor("#8DB6CD")
LIGHTSKYBLUE4 = fluxionColor("#607B8B")
LIGHTSLATEBLUE = fluxionColor("#8470FF")
LIGHTSLATEGRAY = fluxionColor("#778899")
LIGHTSTEELBLUE = fluxionColor("#B0C4DE")
LIGHTSTEELBLUE1 = fluxionColor("#CAE1FF")
LIGHTSTEELBLUE2 = fluxionColor("#BCD2EE")
LIGHTSTEELBLUE3 = fluxionColor("#A2B5CD")
LIGHTSTEELBLUE4 = fluxionColor("#6E7B8B")
LIGHTYELLOW1 = fluxionColor("#FFFFE0")
LIGHTYELLOW2 = fluxionColor("#EEEED1")
LIGHTYELLOW3 = fluxionColor("#CDCDB4")
LIGHTYELLOW4 = fluxionColor("#8B8B7A")
LIMEGREEN = fluxionColor("#32CD32")
LINEN = fluxionColor("#FAF0E6")
MAGENTA = fluxionColor("#FF00FF")
MAGENTA2 = fluxionColor("#EE00EE")
MAGENTA3 = fluxionColor("#CD00CD")
MAGENTA4 = fluxionColor("#8B008B")
MAROON = fluxionColor("#B03060")
MAROON1 = fluxionColor("#FF34B3")
MAROON2 = fluxionColor("#EE30A7")
MAROON3 = fluxionColor("#CD2990")
MAROON4 = fluxionColor("#8B1C62")
MEDIUM = fluxionColor("#66CDAA")
MEDIUMAQUAMARINE = fluxionColor("#66CDAA")
MEDIUMBLUE = fluxionColor("#0000CD")
MEDIUMORCHID = fluxionColor("#BA55D3")
MEDIUMORCHID1 = fluxionColor("#E066FF")
MEDIUMORCHID2 = fluxionColor("#D15FEE")
MEDIUMORCHID3 = fluxionColor("#B452CD")
MEDIUMORCHID4 = fluxionColor("#7A378B")
MEDIUMPURPLE = fluxionColor("#9370DB")
MEDIUMPURPLE1 = fluxionColor("#AB82FF")
MEDIUMPURPLE2 = fluxionColor("#9F79EE")
MEDIUMPURPLE3 = fluxionColor("#8968CD")
MEDIUMPURPLE4 = fluxionColor("#5D478B")
MEDIUMSEAGREEN = fluxionColor("#3CB371")
MEDIUMSLATEBLUE = fluxionColor("#7B68EE")
MEDIUMSPRINGGREEN = fluxionColor("#00FA9A")
MEDIUMTURQUOISE = fluxionColor("#48D1CC")
MEDIUMVIOLETRED = fluxionColor("#C71585")
MIDNIGHTBLUE = fluxionColor("#191970")
MINTCREAM = fluxionColor("#F5FFFA")
MISTYROSE1 = fluxionColor("#FFE4E1")
MISTYROSE2 = fluxionColor("#EED5D2")
MISTYROSE3 = fluxionColor("#CDB7B5")
MISTYROSE4 = fluxionColor("#8B7D7B")
MOCCASIN = fluxionColor("#FFE4B5")
NAVAJOWHITE1 = fluxionColor("#FFDEAD")
NAVAJOWHITE2 = fluxionColor("#EECFA1")
NAVAJOWHITE3 = fluxionColor("#CDB38B")
NAVAJOWHITE4 = fluxionColor("#8B795E")
NAVYBLUE = fluxionColor("#000080")
OLDLACE = fluxionColor("#FDF5E6")
OLIVEDRAB = fluxionColor("#6B8E23")
OLIVEDRAB1 = fluxionColor("#C0FF3E")
OLIVEDRAB2 = fluxionColor("#B3EE3A")
OLIVEDRAB4 = fluxionColor("#698B22")
ORANGE1 = fluxionColor("#FFA500")
ORANGE2 = fluxionColor("#EE9A00")
ORANGE3 = fluxionColor("#CD8500")
ORANGE4 = fluxionColor("#8B5A00")
ORANGERED1 = fluxionColor("#FF4500")
ORANGERED2 = fluxionColor("#EE4000")
ORANGERED3 = fluxionColor("#CD3700")
ORANGERED4 = fluxionColor("#8B2500")
ORCHID = fluxionColor("#DA70D6")
ORCHID1 = fluxionColor("#FF83FA")
ORCHID2 = fluxionColor("#EE7AE9")
ORCHID3 = fluxionColor("#CD69C9")
ORCHID4 = fluxionColor("#8B4789")
PALE = fluxionColor("#DB7093")
PALEGOLDENROD = fluxionColor("#EEE8AA")
PALEGREEN = fluxionColor("#98FB98")
PALEGREEN1 = fluxionColor("#9AFF9A")
PALEGREEN2 = fluxionColor("#90EE90")
PALEGREEN3 = fluxionColor("#7CCD7C")
PALEGREEN4 = fluxionColor("#548B54")
PALETURQUOISE = fluxionColor("#AFEEEE")
PALETURQUOISE1 = fluxionColor("#BBFFFF")
PALETURQUOISE2 = fluxionColor("#AEEEEE")
PALETURQUOISE3 = fluxionColor("#96CDCD")
PALETURQUOISE4 = fluxionColor("#668B8B")
PALEVIOLETRED = fluxionColor("#DB7093")
PALEVIOLETRED1 = fluxionColor("#FF82AB")
PALEVIOLETRED2 = fluxionColor("#EE799F")
PALEVIOLETRED3 = fluxionColor("#CD6889")
PALEVIOLETRED4 = fluxionColor("#8B475D")
PAPAYAWHIP = fluxionColor("#FFEFD5")
PEACHPUFF1 = fluxionColor("#FFDAB9")
PEACHPUFF2 = fluxionColor("#EECBAD")
PEACHPUFF3 = fluxionColor("#CDAF95")
PEACHPUFF4 = fluxionColor("#8B7765")
PINK = fluxionColor("#FFC0CB")
PINK1 = fluxionColor("#FFB5C5")
PINK2 = fluxionColor("#EEA9B8")
PINK3 = fluxionColor("#CD919E")
PINK4 = fluxionColor("#8B636C")
PLUM = fluxionColor("#DDA0DD")
PLUM1 = fluxionColor("#FFBBFF")
PLUM2 = fluxionColor("#EEAEEE")
PLUM3 = fluxionColor("#CD96CD")
PLUM4 = fluxionColor("#8B668B")
POWDERBLUE = fluxionColor("#B0E0E6")
PURPLE = fluxionColor("#A020F0")
PURPLE1 = fluxionColor("#9B30FF")
PURPLE2 = fluxionColor("#912CEE")
PURPLE3 = fluxionColor("#7D26CD")
PURPLE4 = fluxionColor("#551A8B")
RED1 = fluxionColor("#FF0000")
RED2 = fluxionColor("#EE0000")
RED3 = fluxionColor("#CD0000")
RED4 = fluxionColor("#8B0000")
ROSYBROWN = fluxionColor("#BC8F8F")
ROSYBROWN1 = fluxionColor("#FFC1C1")
ROSYBROWN2 = fluxionColor("#EEB4B4")
ROSYBROWN3 = fluxionColor("#CD9B9B")
ROSYBROWN4 = fluxionColor("#8B6969")
ROYALBLUE = fluxionColor("#4169E1")
ROYALBLUE1 = fluxionColor("#4876FF")
ROYALBLUE2 = fluxionColor("#436EEE")
ROYALBLUE3 = fluxionColor("#3A5FCD")
ROYALBLUE4 = fluxionColor("#27408B")
SADDLEBROWN = fluxionColor("#8B4513")
SALMON = fluxionColor("#FA8072")
SALMON1 = fluxionColor("#FF8C69")
SALMON2 = fluxionColor("#EE8262")
SALMON3 = fluxionColor("#CD7054")
SALMON4 = fluxionColor("#8B4C39")
SANDYBROWN = fluxionColor("#F4A460")
SEAGREEN1 = fluxionColor("#54FF9F")
SEAGREEN2 = fluxionColor("#4EEE94")
SEAGREEN3 = fluxionColor("#43CD80")
SEAGREEN4 = fluxionColor("#2E8B57")
SEASHELL1 = fluxionColor("#FFF5EE")
SEASHELL2 = fluxionColor("#EEE5DE")
SEASHELL3 = fluxionColor("#CDC5BF")
SEASHELL4 = fluxionColor("#8B8682")
SIENNA = fluxionColor("#A0522D")
SIENNA1 = fluxionColor("#FF8247")
SIENNA2 = fluxionColor("#EE7942")
SIENNA3 = fluxionColor("#CD6839")
SIENNA4 = fluxionColor("#8B4726")
SKYBLUE = fluxionColor("#87CEEB")
SKYBLUE1 = fluxionColor("#87CEFF")
SKYBLUE2 = fluxionColor("#7EC0EE")
SKYBLUE3 = fluxionColor("#6CA6CD")
SKYBLUE4 = fluxionColor("#4A708B")
SLATEBLUE = fluxionColor("#6A5ACD")
SLATEBLUE1 = fluxionColor("#836FFF")
SLATEBLUE2 = fluxionColor("#7A67EE")
SLATEBLUE3 = fluxionColor("#6959CD")
SLATEBLUE4 = fluxionColor("#473C8B")
SLATEGRAY = fluxionColor("#708090")
SLATEGRAY1 = fluxionColor("#C6E2FF")
SLATEGRAY2 = fluxionColor("#B9D3EE")
SLATEGRAY3 = fluxionColor("#9FB6CD")
SLATEGRAY4 = fluxionColor("#6C7B8B")
SNOW1 = fluxionColor("#FFFAFA")
SNOW2 = fluxionColor("#EEE9E9")
SNOW3 = fluxionColor("#CDC9C9")
SNOW4 = fluxionColor("#8B8989")
SPRINGGREEN1 = fluxionColor("#00FF7F")
SPRINGGREEN2 = fluxionColor("#00EE76")
SPRINGGREEN3 = fluxionColor("#00CD66")
SPRINGGREEN4 = fluxionColor("#008B45")
STEELBLUE = fluxionColor("#4682B4")
STEELBLUE1 = fluxionColor("#63B8FF")
STEELBLUE2 = fluxionColor("#5CACEE")
STEELBLUE3 = fluxionColor("#4F94CD")
STEELBLUE4 = fluxionColor("#36648B")
TAN = fluxionColor("#D2B48C")
TAN1 = fluxionColor("#FFA54F")
TAN2 = fluxionColor("#EE9A49")
TAN3 = fluxionColor("#CD853F")
TAN4 = fluxionColor("#8B5A2B")
THISTLE = fluxionColor("#D8BFD8")
THISTLE1 = fluxionColor("#FFE1FF")
THISTLE2 = fluxionColor("#EED2EE")
THISTLE3 = fluxionColor("#CDB5CD")
THISTLE4 = fluxionColor("#8B7B8B")
TOMATO1 = fluxionColor("#FF6347")
TOMATO2 = fluxionColor("#EE5C42")
TOMATO3 = fluxionColor("#CD4F39")
TOMATO4 = fluxionColor("#8B3626")
TURQUOISE = fluxionColor("#40E0D0")
TURQUOISE1 = fluxionColor("#00F5FF")
TURQUOISE2 = fluxionColor("#00E5EE")
TURQUOISE3 = fluxionColor("#00C5CD")
TURQUOISE4 = fluxionColor("#00868B")
VIOLET = fluxionColor("#EE82EE")
VIOLETRED = fluxionColor("#D02090")
VIOLETRED1 = fluxionColor("#FF3E96")
VIOLETRED2 = fluxionColor("#EE3A8C")
VIOLETRED3 = fluxionColor("#CD3278")
VIOLETRED4 = fluxionColor("#8B2252")
WHEAT = fluxionColor("#F5DEB3")
WHEAT1 = fluxionColor("#FFE7BA")
WHEAT2 = fluxionColor("#EED8AE")
WHEAT3 = fluxionColor("#CDBA96")
WHEAT4 = fluxionColor("#8B7E66")
WHITE = fluxionColor("#FFFFFF")
WHITESMOKE = fluxionColor("#F5F5F5")
YELLOW1 = fluxionColor("#FFFF00")
YELLOW2 = fluxionColor("#EEEE00")
YELLOW3 = fluxionColor("#CDCD00")
YELLOW4 = fluxionColor("#8B8B00")
YELLOWGREEN = fluxionColor("#9ACD32")
