"""Colors from the XKCD Color Name Survey

XKCD is a popular `web comic <https://xkcd.com/353/>`__ created by Randall Munroe.
His "`Color Name Survey <http://blog.xkcd.com/2010/05/03/color-survey-results/>`__" (with
200000 participants) resulted in a list of nearly 1000 color names.

While the ``XKCD`` module is exposed to fluxion's global name space, the colors included
in it are not. This means that in order to use the colors, access them via the module name:

.. code:: pycon

    >>> from fluxion import XKCD
    >>> XKCD.MANGO
    fluxionColor('#FFA62B')


List of Color Constants
-----------------------

These hex values are non official approximate values intended to simulate the colors in HTML,
taken from https://www.w3schools.com/colors/colors_xkcd.asp.

.. autofluxioncolormodule:: fluxion.utils.color.XKCD

"""

from __future__ import annotations

from .core import fluxionColor

ACIDGREEN = fluxionColor("#8FFE09")
ADOBE = fluxionColor("#BD6C48")
ALGAE = fluxionColor("#54AC68")
ALGAEGREEN = fluxionColor("#21C36F")
ALMOSTBLACK = fluxionColor("#070D0D")
AMBER = fluxionColor("#FEB308")
AMETHYST = fluxionColor("#9B5FC0")
APPLE = fluxionColor("#6ECB3C")
APPLEGREEN = fluxionColor("#76CD26")
APRICOT = fluxionColor("#FFB16D")
AQUA = fluxionColor("#13EAC9")
AQUABLUE = fluxionColor("#02D8E9")
AQUAGREEN = fluxionColor("#12E193")
AQUAMARINE = fluxionColor("#2EE8BB")
ARMYGREEN = fluxionColor("#4B5D16")
ASPARAGUS = fluxionColor("#77AB56")
AUBERGINE = fluxionColor("#3D0734")
AUBURN = fluxionColor("#9A3001")
AVOCADO = fluxionColor("#90B134")
AVOCADOGREEN = fluxionColor("#87A922")
AZUL = fluxionColor("#1D5DEC")
AZURE = fluxionColor("#069AF3")
BABYBLUE = fluxionColor("#A2CFFE")
BABYGREEN = fluxionColor("#8CFF9E")
BABYPINK = fluxionColor("#FFB7CE")
BABYPOO = fluxionColor("#AB9004")
BABYPOOP = fluxionColor("#937C00")
BABYPOOPGREEN = fluxionColor("#8F9805")
BABYPUKEGREEN = fluxionColor("#B6C406")
BABYPURPLE = fluxionColor("#CA9BF7")
BABYSHITBROWN = fluxionColor("#AD900D")
BABYSHITGREEN = fluxionColor("#889717")
BANANA = fluxionColor("#FFFF7E")
BANANAYELLOW = fluxionColor("#FAFE4B")
BARBIEPINK = fluxionColor("#FE46A5")
BARFGREEN = fluxionColor("#94AC02")
BARNEY = fluxionColor("#AC1DB8")
BARNEYPURPLE = fluxionColor("#A00498")
BATTLESHIPGREY = fluxionColor("#6B7C85")
BEIGE = fluxionColor("#E6DAA6")
BERRY = fluxionColor("#990F4B")
BILE = fluxionColor("#B5C306")
BLACK = fluxionColor("#000000")
BLAND = fluxionColor("#AFA88B")
BLOOD = fluxionColor("#770001")
BLOODORANGE = fluxionColor("#FE4B03")
BLOODRED = fluxionColor("#980002")
BLUE = fluxionColor("#0343DF")
BLUEBERRY = fluxionColor("#464196")
BLUEBLUE = fluxionColor("#2242C7")
BLUEGREEN = fluxionColor("#0F9B8E")
BLUEGREY = fluxionColor("#85A3B2")
BLUEPURPLE = fluxionColor("#5A06EF")
BLUEVIOLET = fluxionColor("#5D06E9")
BLUEWITHAHINTOFPURPLE = fluxionColor("#533CC6")
BLUEYGREEN = fluxionColor("#2BB179")
BLUEYGREY = fluxionColor("#89A0B0")
BLUEYPURPLE = fluxionColor("#6241C7")
BLUISH = fluxionColor("#2976BB")
BLUISHGREEN = fluxionColor("#10A674")
BLUISHGREY = fluxionColor("#748B97")
BLUISHPURPLE = fluxionColor("#703BE7")
BLURPLE = fluxionColor("#5539CC")
BLUSH = fluxionColor("#F29E8E")
BLUSHPINK = fluxionColor("#FE828C")
BOOGER = fluxionColor("#9BB53C")
BOOGERGREEN = fluxionColor("#96B403")
BORDEAUX = fluxionColor("#7B002C")
BORINGGREEN = fluxionColor("#63B365")
BOTTLEGREEN = fluxionColor("#044A05")
BRICK = fluxionColor("#A03623")
BRICKORANGE = fluxionColor("#C14A09")
BRICKRED = fluxionColor("#8F1402")
BRIGHTAQUA = fluxionColor("#0BF9EA")
BRIGHTBLUE = fluxionColor("#0165FC")
BRIGHTCYAN = fluxionColor("#41FDFE")
BRIGHTGREEN = fluxionColor("#01FF07")
BRIGHTLAVENDER = fluxionColor("#C760FF")
BRIGHTLIGHTBLUE = fluxionColor("#26F7FD")
BRIGHTLIGHTGREEN = fluxionColor("#2DFE54")
BRIGHTLILAC = fluxionColor("#C95EFB")
BRIGHTLIME = fluxionColor("#87FD05")
BRIGHTLIMEGREEN = fluxionColor("#65FE08")
BRIGHTMAGENTA = fluxionColor("#FF08E8")
BRIGHTOLIVE = fluxionColor("#9CBB04")
BRIGHTORANGE = fluxionColor("#FF5B00")
BRIGHTPINK = fluxionColor("#FE01B1")
BRIGHTPURPLE = fluxionColor("#BE03FD")
BRIGHTRED = fluxionColor("#FF000D")
BRIGHTSEAGREEN = fluxionColor("#05FFA6")
BRIGHTSKYBLUE = fluxionColor("#02CCFE")
BRIGHTTEAL = fluxionColor("#01F9C6")
BRIGHTTURQUOISE = fluxionColor("#0FFEF9")
BRIGHTVIOLET = fluxionColor("#AD0AFD")
BRIGHTYELLOW = fluxionColor("#FFFD01")
BRIGHTYELLOWGREEN = fluxionColor("#9DFF00")
BRITISHRACINGGREEN = fluxionColor("#05480D")
BRONZE = fluxionColor("#A87900")
BROWN = fluxionColor("#653700")
BROWNGREEN = fluxionColor("#706C11")
BROWNGREY = fluxionColor("#8D8468")
BROWNISH = fluxionColor("#9C6D57")
BROWNISHGREEN = fluxionColor("#6A6E09")
BROWNISHGREY = fluxionColor("#86775F")
BROWNISHORANGE = fluxionColor("#CB7723")
BROWNISHPINK = fluxionColor("#C27E79")
BROWNISHPURPLE = fluxionColor("#76424E")
BROWNISHRED = fluxionColor("#9E3623")
BROWNISHYELLOW = fluxionColor("#C9B003")
BROWNORANGE = fluxionColor("#B96902")
BROWNRED = fluxionColor("#922B05")
BROWNYELLOW = fluxionColor("#B29705")
BROWNYGREEN = fluxionColor("#6F6C0A")
BROWNYORANGE = fluxionColor("#CA6B02")
BRUISE = fluxionColor("#7E4071")
BUBBLEGUM = fluxionColor("#FF6CB5")
BUBBLEGUMPINK = fluxionColor("#FF69AF")
BUFF = fluxionColor("#FEF69E")
BURGUNDY = fluxionColor("#610023")
BURNTORANGE = fluxionColor("#C04E01")
BURNTRED = fluxionColor("#9F2305")
BURNTSIENA = fluxionColor("#B75203")
BURNTSIENNA = fluxionColor("#B04E0F")
BURNTUMBER = fluxionColor("#A0450E")
BURNTYELLOW = fluxionColor("#D5AB09")
BURPLE = fluxionColor("#6832E3")
BUTTER = fluxionColor("#FFFF81")
BUTTERSCOTCH = fluxionColor("#FDB147")
BUTTERYELLOW = fluxionColor("#FFFD74")
CADETBLUE = fluxionColor("#4E7496")
CAMEL = fluxionColor("#C69F59")
CAMO = fluxionColor("#7F8F4E")
CAMOGREEN = fluxionColor("#526525")
CAMOUFLAGEGREEN = fluxionColor("#4B6113")
CANARY = fluxionColor("#FDFF63")
CANARYYELLOW = fluxionColor("#FFFE40")
CANDYPINK = fluxionColor("#FF63E9")
CARAMEL = fluxionColor("#AF6F09")
CARMINE = fluxionColor("#9D0216")
CARNATION = fluxionColor("#FD798F")
CARNATIONPINK = fluxionColor("#FF7FA7")
CAROLINABLUE = fluxionColor("#8AB8FE")
CELADON = fluxionColor("#BEFDB7")
CELERY = fluxionColor("#C1FD95")
CEMENT = fluxionColor("#A5A391")
CERISE = fluxionColor("#DE0C62")
CERULEAN = fluxionColor("#0485D1")
CERULEANBLUE = fluxionColor("#056EEE")
CHARCOAL = fluxionColor("#343837")
CHARCOALGREY = fluxionColor("#3C4142")
CHARTREUSE = fluxionColor("#C1F80A")
CHERRY = fluxionColor("#CF0234")
CHERRYRED = fluxionColor("#F7022A")
CHESTNUT = fluxionColor("#742802")
CHOCOLATE = fluxionColor("#3D1C02")
CHOCOLATEBROWN = fluxionColor("#411900")
CINNAMON = fluxionColor("#AC4F06")
CLARET = fluxionColor("#680018")
CLAY = fluxionColor("#B66A50")
CLAYBROWN = fluxionColor("#B2713D")
CLEARBLUE = fluxionColor("#247AFD")
COBALT = fluxionColor("#1E488F")
COBALTBLUE = fluxionColor("#030AA7")
COCOA = fluxionColor("#875F42")
COFFEE = fluxionColor("#A6814C")
COOLBLUE = fluxionColor("#4984B8")
COOLGREEN = fluxionColor("#33B864")
COOLGREY = fluxionColor("#95A3A6")
COPPER = fluxionColor("#B66325")
CORAL = fluxionColor("#FC5A50")
CORALPINK = fluxionColor("#FF6163")
CORNFLOWER = fluxionColor("#6A79F7")
CORNFLOWERBLUE = fluxionColor("#5170D7")
CRANBERRY = fluxionColor("#9E003A")
CREAM = fluxionColor("#FFFFC2")
CREME = fluxionColor("#FFFFB6")
CRIMSON = fluxionColor("#8C000F")
CUSTARD = fluxionColor("#FFFD78")
CYAN = fluxionColor("#00FFFF")
DANDELION = fluxionColor("#FEDF08")
DARK = fluxionColor("#1B2431")
DARKAQUA = fluxionColor("#05696B")
DARKAQUAMARINE = fluxionColor("#017371")
DARKBEIGE = fluxionColor("#AC9362")
DARKBLUE = fluxionColor("#030764")
DARKBLUEGREEN = fluxionColor("#005249")
DARKBLUEGREY = fluxionColor("#1F3B4D")
DARKBROWN = fluxionColor("#341C02")
DARKCORAL = fluxionColor("#CF524E")
DARKCREAM = fluxionColor("#FFF39A")
DARKCYAN = fluxionColor("#0A888A")
DARKFORESTGREEN = fluxionColor("#002D04")
DARKFUCHSIA = fluxionColor("#9D0759")
DARKGOLD = fluxionColor("#B59410")
DARKGRASSGREEN = fluxionColor("#388004")
DARKGREEN = fluxionColor("#054907")
DARKGREENBLUE = fluxionColor("#1F6357")
DARKGREY = fluxionColor("#363737")
DARKGREYBLUE = fluxionColor("#29465B")
DARKHOTPINK = fluxionColor("#D90166")
DARKINDIGO = fluxionColor("#1F0954")
DARKISHBLUE = fluxionColor("#014182")
DARKISHGREEN = fluxionColor("#287C37")
DARKISHPINK = fluxionColor("#DA467D")
DARKISHPURPLE = fluxionColor("#751973")
DARKISHRED = fluxionColor("#A90308")
DARKKHAKI = fluxionColor("#9B8F55")
DARKLAVENDER = fluxionColor("#856798")
DARKLILAC = fluxionColor("#9C6DA5")
DARKLIME = fluxionColor("#84B701")
DARKLIMEGREEN = fluxionColor("#7EBD01")
DARKMAGENTA = fluxionColor("#960056")
DARKMAROON = fluxionColor("#3C0008")
DARKMAUVE = fluxionColor("#874C62")
DARKMINT = fluxionColor("#48C072")
DARKMINTGREEN = fluxionColor("#20C073")
DARKMUSTARD = fluxionColor("#A88905")
DARKNAVY = fluxionColor("#000435")
DARKNAVYBLUE = fluxionColor("#00022E")
DARKOLIVE = fluxionColor("#373E02")
DARKOLIVEGREEN = fluxionColor("#3C4D03")
DARKORANGE = fluxionColor("#C65102")
DARKPASTELGREEN = fluxionColor("#56AE57")
DARKPEACH = fluxionColor("#DE7E5D")
DARKPERIWINKLE = fluxionColor("#665FD1")
DARKPINK = fluxionColor("#CB416B")
DARKPLUM = fluxionColor("#3F012C")
DARKPURPLE = fluxionColor("#35063E")
DARKRED = fluxionColor("#840000")
DARKROSE = fluxionColor("#B5485D")
DARKROYALBLUE = fluxionColor("#02066F")
DARKSAGE = fluxionColor("#598556")
DARKSALMON = fluxionColor("#C85A53")
DARKSAND = fluxionColor("#A88F59")
DARKSEAFOAM = fluxionColor("#1FB57A")
DARKSEAFOAMGREEN = fluxionColor("#3EAF76")
DARKSEAGREEN = fluxionColor("#11875D")
DARKSKYBLUE = fluxionColor("#448EE4")
DARKSLATEBLUE = fluxionColor("#214761")
DARKTAN = fluxionColor("#AF884A")
DARKTAUPE = fluxionColor("#7F684E")
DARKTEAL = fluxionColor("#014D4E")
DARKTURQUOISE = fluxionColor("#045C5A")
DARKVIOLET = fluxionColor("#34013F")
DARKYELLOW = fluxionColor("#D5B60A")
DARKYELLOWGREEN = fluxionColor("#728F02")
DEEPAQUA = fluxionColor("#08787F")
DEEPBLUE = fluxionColor("#040273")
DEEPBROWN = fluxionColor("#410200")
DEEPGREEN = fluxionColor("#02590F")
DEEPLAVENDER = fluxionColor("#8D5EB7")
DEEPLILAC = fluxionColor("#966EBD")
DEEPMAGENTA = fluxionColor("#A0025C")
DEEPORANGE = fluxionColor("#DC4D01")
DEEPPINK = fluxionColor("#CB0162")
DEEPPURPLE = fluxionColor("#36013F")
DEEPRED = fluxionColor("#9A0200")
DEEPROSE = fluxionColor("#C74767")
DEEPSEABLUE = fluxionColor("#015482")
DEEPSKYBLUE = fluxionColor("#0D75F8")
DEEPTEAL = fluxionColor("#00555A")
DEEPTURQUOISE = fluxionColor("#017374")
DEEPVIOLET = fluxionColor("#490648")
DENIM = fluxionColor("#3B638C")
DENIMBLUE = fluxionColor("#3B5B92")
DESERT = fluxionColor("#CCAD60")
DIARRHEA = fluxionColor("#9F8303")
DIRT = fluxionColor("#8A6E45")
DIRTBROWN = fluxionColor("#836539")
DIRTYBLUE = fluxionColor("#3F829D")
DIRTYGREEN = fluxionColor("#667E2C")
DIRTYORANGE = fluxionColor("#C87606")
DIRTYPINK = fluxionColor("#CA7B80")
DIRTYPURPLE = fluxionColor("#734A65")
DIRTYYELLOW = fluxionColor("#CDC50A")
DODGERBLUE = fluxionColor("#3E82FC")
DRAB = fluxionColor("#828344")
DRABGREEN = fluxionColor("#749551")
DRIEDBLOOD = fluxionColor("#4B0101")
DUCKEGGBLUE = fluxionColor("#C3FBF4")
DULLBLUE = fluxionColor("#49759C")
DULLBROWN = fluxionColor("#876E4B")
DULLGREEN = fluxionColor("#74A662")
DULLORANGE = fluxionColor("#D8863B")
DULLPINK = fluxionColor("#D5869D")
DULLPURPLE = fluxionColor("#84597E")
DULLRED = fluxionColor("#BB3F3F")
DULLTEAL = fluxionColor("#5F9E8F")
DULLYELLOW = fluxionColor("#EEDC5B")
DUSK = fluxionColor("#4E5481")
DUSKBLUE = fluxionColor("#26538D")
DUSKYBLUE = fluxionColor("#475F94")
DUSKYPINK = fluxionColor("#CC7A8B")
DUSKYPURPLE = fluxionColor("#895B7B")
DUSKYROSE = fluxionColor("#BA6873")
DUST = fluxionColor("#B2996E")
DUSTYBLUE = fluxionColor("#5A86AD")
DUSTYGREEN = fluxionColor("#76A973")
DUSTYLAVENDER = fluxionColor("#AC86A8")
DUSTYORANGE = fluxionColor("#F0833A")
DUSTYPINK = fluxionColor("#D58A94")
DUSTYPURPLE = fluxionColor("#825F87")
DUSTYRED = fluxionColor("#B9484E")
DUSTYROSE = fluxionColor("#C0737A")
DUSTYTEAL = fluxionColor("#4C9085")
EARTH = fluxionColor("#A2653E")
EASTERGREEN = fluxionColor("#8CFD7E")
EASTERPURPLE = fluxionColor("#C071FE")
ECRU = fluxionColor("#FEFFCA")
EGGPLANT = fluxionColor("#380835")
EGGPLANTPURPLE = fluxionColor("#430541")
EGGSHELL = fluxionColor("#FFFCC4")
EGGSHELLBLUE = fluxionColor("#C4FFF7")
ELECTRICBLUE = fluxionColor("#0652FF")
ELECTRICGREEN = fluxionColor("#21FC0D")
ELECTRICLIME = fluxionColor("#A8FF04")
ELECTRICPINK = fluxionColor("#FF0490")
ELECTRICPURPLE = fluxionColor("#AA23FF")
EMERALD = fluxionColor("#01A049")
EMERALDGREEN = fluxionColor("#028F1E")
EVERGREEN = fluxionColor("#05472A")
FADEDBLUE = fluxionColor("#658CBB")
FADEDGREEN = fluxionColor("#7BB274")
FADEDORANGE = fluxionColor("#F0944D")
FADEDPINK = fluxionColor("#DE9DAC")
FADEDPURPLE = fluxionColor("#916E99")
FADEDRED = fluxionColor("#D3494E")
FADEDYELLOW = fluxionColor("#FEFF7F")
FAWN = fluxionColor("#CFAF7B")
FERN = fluxionColor("#63A950")
FERNGREEN = fluxionColor("#548D44")
FIREENGINERED = fluxionColor("#FE0002")
FLATBLUE = fluxionColor("#3C73A8")
FLATGREEN = fluxionColor("#699D4C")
FLUORESCENTGREEN = fluxionColor("#08FF08")
FLUROGREEN = fluxionColor("#0AFF02")
FOAMGREEN = fluxionColor("#90FDA9")
FOREST = fluxionColor("#0B5509")
FORESTGREEN = fluxionColor("#06470C")
FORRESTGREEN = fluxionColor("#154406")
FRENCHBLUE = fluxionColor("#436BAD")
FRESHGREEN = fluxionColor("#69D84F")
FROGGREEN = fluxionColor("#58BC08")
FUCHSIA = fluxionColor("#ED0DD9")
GOLD = fluxionColor("#DBB40C")
GOLDEN = fluxionColor("#F5BF03")
GOLDENBROWN = fluxionColor("#B27A01")
GOLDENROD = fluxionColor("#F9BC08")
GOLDENYELLOW = fluxionColor("#FEC615")
GRAPE = fluxionColor("#6C3461")
GRAPEFRUIT = fluxionColor("#FD5956")
GRAPEPURPLE = fluxionColor("#5D1451")
GRASS = fluxionColor("#5CAC2D")
GRASSGREEN = fluxionColor("#3F9B0B")
GRASSYGREEN = fluxionColor("#419C03")
GREEN = fluxionColor("#15B01A")
GREENAPPLE = fluxionColor("#5EDC1F")
GREENBLUE = fluxionColor("#01C08D")
GREENBROWN = fluxionColor("#544E03")
GREENGREY = fluxionColor("#77926F")
GREENISH = fluxionColor("#40A368")
GREENISHBEIGE = fluxionColor("#C9D179")
GREENISHBLUE = fluxionColor("#0B8B87")
GREENISHBROWN = fluxionColor("#696112")
GREENISHCYAN = fluxionColor("#2AFEB7")
GREENISHGREY = fluxionColor("#96AE8D")
GREENISHTAN = fluxionColor("#BCCB7A")
GREENISHTEAL = fluxionColor("#32BF84")
GREENISHTURQUOISE = fluxionColor("#00FBB0")
GREENISHYELLOW = fluxionColor("#CDFD02")
GREENTEAL = fluxionColor("#0CB577")
GREENYBLUE = fluxionColor("#42B395")
GREENYBROWN = fluxionColor("#696006")
GREENYELLOW = fluxionColor("#B5CE08")
GREENYGREY = fluxionColor("#7EA07A")
GREENYYELLOW = fluxionColor("#C6F808")
GREY = fluxionColor("#929591")
GREYBLUE = fluxionColor("#647D8E")
GREYBROWN = fluxionColor("#7F7053")
GREYGREEN = fluxionColor("#86A17D")
GREYISH = fluxionColor("#A8A495")
GREYISHBLUE = fluxionColor("#5E819D")
GREYISHBROWN = fluxionColor("#7A6A4F")
GREYISHGREEN = fluxionColor("#82A67D")
GREYISHPINK = fluxionColor("#C88D94")
GREYISHPURPLE = fluxionColor("#887191")
GREYISHTEAL = fluxionColor("#719F91")
GREYPINK = fluxionColor("#C3909B")
GREYPURPLE = fluxionColor("#826D8C")
GREYTEAL = fluxionColor("#5E9B8A")
GROSSGREEN = fluxionColor("#A0BF16")
GUNMETAL = fluxionColor("#536267")
HAZEL = fluxionColor("#8E7618")
HEATHER = fluxionColor("#A484AC")
HELIOTROPE = fluxionColor("#D94FF5")
HIGHLIGHTERGREEN = fluxionColor("#1BFC06")
HOSPITALGREEN = fluxionColor("#9BE5AA")
HOTGREEN = fluxionColor("#25FF29")
HOTMAGENTA = fluxionColor("#F504C9")
HOTPINK = fluxionColor("#FF028D")
HOTPURPLE = fluxionColor("#CB00F5")
HUNTERGREEN = fluxionColor("#0B4008")
ICE = fluxionColor("#D6FFFA")
ICEBLUE = fluxionColor("#D7FFFE")
ICKYGREEN = fluxionColor("#8FAE22")
INDIANRED = fluxionColor("#850E04")
INDIGO = fluxionColor("#380282")
INDIGOBLUE = fluxionColor("#3A18B1")
IRIS = fluxionColor("#6258C4")
IRISHGREEN = fluxionColor("#019529")
IVORY = fluxionColor("#FFFFCB")
JADE = fluxionColor("#1FA774")
JADEGREEN = fluxionColor("#2BAF6A")
JUNGLEGREEN = fluxionColor("#048243")
KELLEYGREEN = fluxionColor("#009337")
KELLYGREEN = fluxionColor("#02AB2E")
KERMITGREEN = fluxionColor("#5CB200")
KEYLIME = fluxionColor("#AEFF6E")
KHAKI = fluxionColor("#AAA662")
KHAKIGREEN = fluxionColor("#728639")
KIWI = fluxionColor("#9CEF43")
KIWIGREEN = fluxionColor("#8EE53F")
LAVENDER = fluxionColor("#C79FEF")
LAVENDERBLUE = fluxionColor("#8B88F8")
LAVENDERPINK = fluxionColor("#DD85D7")
LAWNGREEN = fluxionColor("#4DA409")
LEAF = fluxionColor("#71AA34")
LEAFGREEN = fluxionColor("#5CA904")
LEAFYGREEN = fluxionColor("#51B73B")
LEATHER = fluxionColor("#AC7434")
LEMON = fluxionColor("#FDFF52")
LEMONGREEN = fluxionColor("#ADF802")
LEMONLIME = fluxionColor("#BFFE28")
LEMONYELLOW = fluxionColor("#FDFF38")
LICHEN = fluxionColor("#8FB67B")
LIGHTAQUA = fluxionColor("#8CFFDB")
LIGHTAQUAMARINE = fluxionColor("#7BFDC7")
LIGHTBEIGE = fluxionColor("#FFFEB6")
LIGHTBLUE = fluxionColor("#7BC8F6")
LIGHTBLUEGREEN = fluxionColor("#7EFBB3")
LIGHTBLUEGREY = fluxionColor("#B7C9E2")
LIGHTBLUISHGREEN = fluxionColor("#76FDA8")
LIGHTBRIGHTGREEN = fluxionColor("#53FE5C")
LIGHTBROWN = fluxionColor("#AD8150")
LIGHTBURGUNDY = fluxionColor("#A8415B")
LIGHTCYAN = fluxionColor("#ACFFFC")
LIGHTEGGPLANT = fluxionColor("#894585")
LIGHTERGREEN = fluxionColor("#75FD63")
LIGHTERPURPLE = fluxionColor("#A55AF4")
LIGHTFORESTGREEN = fluxionColor("#4F9153")
LIGHTGOLD = fluxionColor("#FDDC5C")
LIGHTGRASSGREEN = fluxionColor("#9AF764")
LIGHTGREEN = fluxionColor("#76FF7B")
LIGHTGREENBLUE = fluxionColor("#56FCA2")
LIGHTGREENISHBLUE = fluxionColor("#63F7B4")
LIGHTGREY = fluxionColor("#D8DCD6")
LIGHTGREYBLUE = fluxionColor("#9DBCD4")
LIGHTGREYGREEN = fluxionColor("#B7E1A1")
LIGHTINDIGO = fluxionColor("#6D5ACF")
LIGHTISHBLUE = fluxionColor("#3D7AFD")
LIGHTISHGREEN = fluxionColor("#61E160")
LIGHTISHPURPLE = fluxionColor("#A552E6")
LIGHTISHRED = fluxionColor("#FE2F4A")
LIGHTKHAKI = fluxionColor("#E6F2A2")
LIGHTLAVENDAR = fluxionColor("#EFC0FE")
LIGHTLAVENDER = fluxionColor("#DFC5FE")
LIGHTLIGHTBLUE = fluxionColor("#CAFFFB")
LIGHTLIGHTGREEN = fluxionColor("#C8FFB0")
LIGHTLILAC = fluxionColor("#EDC8FF")
LIGHTLIME = fluxionColor("#AEFD6C")
LIGHTLIMEGREEN = fluxionColor("#B9FF66")
LIGHTMAGENTA = fluxionColor("#FA5FF7")
LIGHTMAROON = fluxionColor("#A24857")
LIGHTMAUVE = fluxionColor("#C292A1")
LIGHTMINT = fluxionColor("#B6FFBB")
LIGHTMINTGREEN = fluxionColor("#A6FBB2")
LIGHTMOSSGREEN = fluxionColor("#A6C875")
LIGHTMUSTARD = fluxionColor("#F7D560")
LIGHTNAVY = fluxionColor("#155084")
LIGHTNAVYBLUE = fluxionColor("#2E5A88")
LIGHTNEONGREEN = fluxionColor("#4EFD54")
LIGHTOLIVE = fluxionColor("#ACBF69")
LIGHTOLIVEGREEN = fluxionColor("#A4BE5C")
LIGHTORANGE = fluxionColor("#FDAA48")
LIGHTPASTELGREEN = fluxionColor("#B2FBA5")
LIGHTPEACH = fluxionColor("#FFD8B1")
LIGHTPEAGREEN = fluxionColor("#C4FE82")
LIGHTPERIWINKLE = fluxionColor("#C1C6FC")
LIGHTPINK = fluxionColor("#FFD1DF")
LIGHTPLUM = fluxionColor("#9D5783")
LIGHTPURPLE = fluxionColor("#BF77F6")
LIGHTRED = fluxionColor("#FF474C")
LIGHTROSE = fluxionColor("#FFC5CB")
LIGHTROYALBLUE = fluxionColor("#3A2EFE")
LIGHTSAGE = fluxionColor("#BCECAC")
LIGHTSALMON = fluxionColor("#FEA993")
LIGHTSEAFOAM = fluxionColor("#A0FEBF")
LIGHTSEAFOAMGREEN = fluxionColor("#a7ffb5")
LIGHTSEAGREEN = fluxionColor("#98F6B0")
LIGHTSKYBLUE = fluxionColor("#C6FCFF")
LIGHTTAN = fluxionColor("#FBEEAC")
LIGHTTEAL = fluxionColor("#90E4C1")
LIGHTTURQUOISE = fluxionColor("#7EF4CC")
LIGHTURPLE = fluxionColor("#B36FF6")
LIGHTVIOLET = fluxionColor("#D6B4FC")
LIGHTYELLOW = fluxionColor("#FFFE7A")
LIGHTYELLOWGREEN = fluxionColor("#CCFD7F")
LIGHTYELLOWISHGREEN = fluxionColor("#C2FF89")
LILAC = fluxionColor("#CEA2FD")
LILIAC = fluxionColor("#C48EFD")
LIME = fluxionColor("#AAFF32")
LIMEGREEN = fluxionColor("#89FE05")
LIMEYELLOW = fluxionColor("#D0FE1D")
LIPSTICK = fluxionColor("#D5174E")
LIPSTICKRED = fluxionColor("#C0022F")
MACARONIANDCHEESE = fluxionColor("#EFB435")
MAGENTA = fluxionColor("#C20078")
MAHOGANY = fluxionColor("#4A0100")
MAIZE = fluxionColor("#F4D054")
MANGO = fluxionColor("#FFA62B")
MANILLA = fluxionColor("#FFFA86")
MARIGOLD = fluxionColor("#FCC006")
MARINE = fluxionColor("#042E60")
MARINEBLUE = fluxionColor("#01386A")
MAROON = fluxionColor("#650021")
MAUVE = fluxionColor("#AE7181")
MEDIUMBLUE = fluxionColor("#2C6FBB")
MEDIUMBROWN = fluxionColor("#7F5112")
MEDIUMGREEN = fluxionColor("#39AD48")
MEDIUMGREY = fluxionColor("#7D7F7C")
MEDIUMPINK = fluxionColor("#F36196")
MEDIUMPURPLE = fluxionColor("#9E43A2")
MELON = fluxionColor("#FF7855")
MERLOT = fluxionColor("#730039")
METALLICBLUE = fluxionColor("#4F738E")
MIDBLUE = fluxionColor("#276AB3")
MIDGREEN = fluxionColor("#50A747")
MIDNIGHT = fluxionColor("#03012D")
MIDNIGHTBLUE = fluxionColor("#020035")
MIDNIGHTPURPLE = fluxionColor("#280137")
MILITARYGREEN = fluxionColor("#667C3E")
MILKCHOCOLATE = fluxionColor("#7F4E1E")
MINT = fluxionColor("#9FFEB0")
MINTGREEN = fluxionColor("#8FFF9F")
MINTYGREEN = fluxionColor("#0BF77D")
MOCHA = fluxionColor("#9D7651")
MOSS = fluxionColor("#769958")
MOSSGREEN = fluxionColor("#658B38")
MOSSYGREEN = fluxionColor("#638B27")
MUD = fluxionColor("#735C12")
MUDBROWN = fluxionColor("#60460F")
MUDDYBROWN = fluxionColor("#886806")
MUDDYGREEN = fluxionColor("#657432")
MUDDYYELLOW = fluxionColor("#BFAC05")
MUDGREEN = fluxionColor("#606602")
MULBERRY = fluxionColor("#920A4E")
MURKYGREEN = fluxionColor("#6C7A0E")
MUSHROOM = fluxionColor("#BA9E88")
MUSTARD = fluxionColor("#CEB301")
MUSTARDBROWN = fluxionColor("#AC7E04")
MUSTARDGREEN = fluxionColor("#A8B504")
MUSTARDYELLOW = fluxionColor("#D2BD0A")
MUTEDBLUE = fluxionColor("#3B719F")
MUTEDGREEN = fluxionColor("#5FA052")
MUTEDPINK = fluxionColor("#D1768F")
MUTEDPURPLE = fluxionColor("#805B87")
NASTYGREEN = fluxionColor("#70B23F")
NAVY = fluxionColor("#01153E")
NAVYBLUE = fluxionColor("#001146")
NAVYGREEN = fluxionColor("#35530A")
NEONBLUE = fluxionColor("#04D9FF")
NEONGREEN = fluxionColor("#0CFF0C")
NEONPINK = fluxionColor("#FE019A")
NEONPURPLE = fluxionColor("#BC13FE")
NEONRED = fluxionColor("#FF073A")
NEONYELLOW = fluxionColor("#CFFF04")
NICEBLUE = fluxionColor("#107AB0")
NIGHTBLUE = fluxionColor("#040348")
OCEAN = fluxionColor("#017B92")
OCEANBLUE = fluxionColor("#03719C")
OCEANGREEN = fluxionColor("#3D9973")
OCHER = fluxionColor("#BF9B0C")
OCHRE = fluxionColor("#BF9005")
OCRE = fluxionColor("#C69C04")
OFFBLUE = fluxionColor("#5684AE")
OFFGREEN = fluxionColor("#6BA353")
OFFWHITE = fluxionColor("#FFFFE4")
OFFYELLOW = fluxionColor("#F1F33F")
OLDPINK = fluxionColor("#C77986")
OLDROSE = fluxionColor("#C87F89")
OLIVE = fluxionColor("#6E750E")
OLIVEBROWN = fluxionColor("#645403")
OLIVEDRAB = fluxionColor("#6F7632")
OLIVEGREEN = fluxionColor("#677A04")
OLIVEYELLOW = fluxionColor("#C2B709")
ORANGE = fluxionColor("#F97306")
ORANGEBROWN = fluxionColor("#BE6400")
ORANGEISH = fluxionColor("#FD8D49")
ORANGEPINK = fluxionColor("#FF6F52")
ORANGERED = fluxionColor("#FE420F")
ORANGEYBROWN = fluxionColor("#B16002")
ORANGEYELLOW = fluxionColor("#FFAD01")
ORANGEYRED = fluxionColor("#FA4224")
ORANGEYYELLOW = fluxionColor("#FDB915")
ORANGISH = fluxionColor("#FC824A")
ORANGISHBROWN = fluxionColor("#B25F03")
ORANGISHRED = fluxionColor("#F43605")
ORCHID = fluxionColor("#C875C4")
PALE = fluxionColor("#FFF9D0")
PALEAQUA = fluxionColor("#B8FFEB")
PALEBLUE = fluxionColor("#D0FEFE")
PALEBROWN = fluxionColor("#B1916E")
PALECYAN = fluxionColor("#B7FFFA")
PALEGOLD = fluxionColor("#FDDE6C")
PALEGREEN = fluxionColor("#C7FDB5")
PALEGREY = fluxionColor("#FDFDFE")
PALELAVENDER = fluxionColor("#EECFFE")
PALELIGHTGREEN = fluxionColor("#B1FC99")
PALELILAC = fluxionColor("#E4CBFF")
PALELIME = fluxionColor("#BEFD73")
PALELIMEGREEN = fluxionColor("#B1FF65")
PALEMAGENTA = fluxionColor("#D767AD")
PALEMAUVE = fluxionColor("#FED0FC")
PALEOLIVE = fluxionColor("#B9CC81")
PALEOLIVEGREEN = fluxionColor("#B1D27B")
PALEORANGE = fluxionColor("#FFA756")
PALEPEACH = fluxionColor("#FFE5AD")
PALEPINK = fluxionColor("#FFCFDC")
PALEPURPLE = fluxionColor("#B790D4")
PALERED = fluxionColor("#D9544D")
PALEROSE = fluxionColor("#FDC1C5")
PALESALMON = fluxionColor("#FFB19A")
PALESKYBLUE = fluxionColor("#BDF6FE")
PALETEAL = fluxionColor("#82CBB2")
PALETURQUOISE = fluxionColor("#A5FBD5")
PALEVIOLET = fluxionColor("#CEAEFA")
PALEYELLOW = fluxionColor("#FFFF84")
PARCHMENT = fluxionColor("#FEFCAF")
PASTELBLUE = fluxionColor("#A2BFFE")
PASTELGREEN = fluxionColor("#B0FF9D")
PASTELORANGE = fluxionColor("#FF964F")
PASTELPINK = fluxionColor("#FFBACD")
PASTELPURPLE = fluxionColor("#CAA0FF")
PASTELRED = fluxionColor("#DB5856")
PASTELYELLOW = fluxionColor("#FFFE71")
PEA = fluxionColor("#A4BF20")
PEACH = fluxionColor("#FFB07C")
PEACHYPINK = fluxionColor("#FF9A8A")
PEACOCKBLUE = fluxionColor("#016795")
PEAGREEN = fluxionColor("#8EAB12")
PEAR = fluxionColor("#CBF85F")
PEASOUP = fluxionColor("#929901")
PEASOUPGREEN = fluxionColor("#94A617")
PERIWINKLE = fluxionColor("#8E82FE")
PERIWINKLEBLUE = fluxionColor("#8F99FB")
PERRYWINKLE = fluxionColor("#8F8CE7")
PETROL = fluxionColor("#005F6A")
PIGPINK = fluxionColor("#E78EA5")
PINE = fluxionColor("#2B5D34")
PINEGREEN = fluxionColor("#0A481E")
PINK = fluxionColor("#FF81C0")
PINKISH = fluxionColor("#D46A7E")
PINKISHBROWN = fluxionColor("#B17261")
PINKISHGREY = fluxionColor("#C8ACA9")
PINKISHORANGE = fluxionColor("#FF724C")
PINKISHPURPLE = fluxionColor("#D648D7")
PINKISHRED = fluxionColor("#F10C45")
PINKISHTAN = fluxionColor("#D99B82")
PINKPURPLE = fluxionColor("#EF1DE7")
PINKRED = fluxionColor("#F5054F")
PINKY = fluxionColor("#FC86AA")
PINKYPURPLE = fluxionColor("#C94CBE")
PINKYRED = fluxionColor("#FC2647")
PISSYELLOW = fluxionColor("#DDD618")
PISTACHIO = fluxionColor("#C0FA8B")
PLUM = fluxionColor("#580F41")
PLUMPURPLE = fluxionColor("#4E0550")
POISONGREEN = fluxionColor("#40FD14")
POO = fluxionColor("#8F7303")
POOBROWN = fluxionColor("#885F01")
POOP = fluxionColor("#7F5E00")
POOPBROWN = fluxionColor("#7A5901")
POOPGREEN = fluxionColor("#6F7C00")
POWDERBLUE = fluxionColor("#B1D1FC")
POWDERPINK = fluxionColor("#FFB2D0")
PRIMARYBLUE = fluxionColor("#0804F9")
PRUSSIANBLUE = fluxionColor("#004577")
PUCE = fluxionColor("#A57E52")
PUKE = fluxionColor("#A5A502")
PUKEBROWN = fluxionColor("#947706")
PUKEGREEN = fluxionColor("#9AAE07")
PUKEYELLOW = fluxionColor("#C2BE0E")
PUMPKIN = fluxionColor("#E17701")
PUMPKINORANGE = fluxionColor("#FB7D07")
PUREBLUE = fluxionColor("#0203E2")
PURPLE = fluxionColor("#7E1E9C")
PURPLEBLUE = fluxionColor("#5D21D0")
PURPLEBROWN = fluxionColor("#673A3F")
PURPLEGREY = fluxionColor("#866F85")
PURPLEISH = fluxionColor("#98568D")
PURPLEISHBLUE = fluxionColor("#6140EF")
PURPLEISHPINK = fluxionColor("#DF4EC8")
PURPLEPINK = fluxionColor("#D725DE")
PURPLERED = fluxionColor("#990147")
PURPLEY = fluxionColor("#8756E4")
PURPLEYBLUE = fluxionColor("#5F34E7")
PURPLEYGREY = fluxionColor("#947E94")
PURPLEYPINK = fluxionColor("#C83CB9")
PURPLISH = fluxionColor("#94568C")
PURPLISHBLUE = fluxionColor("#601EF9")
PURPLISHBROWN = fluxionColor("#6B4247")
PURPLISHGREY = fluxionColor("#7A687F")
PURPLISHPINK = fluxionColor("#CE5DAE")
PURPLISHRED = fluxionColor("#B0054B")
PURPLY = fluxionColor("#983FB2")
PURPLYBLUE = fluxionColor("#661AEE")
PURPLYPINK = fluxionColor("#F075E6")
PUTTY = fluxionColor("#BEAE8A")
RACINGGREEN = fluxionColor("#014600")
RADIOACTIVEGREEN = fluxionColor("#2CFA1F")
RASPBERRY = fluxionColor("#B00149")
RAWSIENNA = fluxionColor("#9A6200")
RAWUMBER = fluxionColor("#A75E09")
REALLYLIGHTBLUE = fluxionColor("#D4FFFF")
RED = fluxionColor("#E50000")
REDBROWN = fluxionColor("#8B2E16")
REDDISH = fluxionColor("#C44240")
REDDISHBROWN = fluxionColor("#7F2B0A")
REDDISHGREY = fluxionColor("#997570")
REDDISHORANGE = fluxionColor("#F8481C")
REDDISHPINK = fluxionColor("#FE2C54")
REDDISHPURPLE = fluxionColor("#910951")
REDDYBROWN = fluxionColor("#6E1005")
REDORANGE = fluxionColor("#FD3C06")
REDPINK = fluxionColor("#FA2A55")
REDPURPLE = fluxionColor("#820747")
REDVIOLET = fluxionColor("#9E0168")
REDWINE = fluxionColor("#8C0034")
RICHBLUE = fluxionColor("#021BF9")
RICHPURPLE = fluxionColor("#720058")
ROBINEGGBLUE = fluxionColor("#8AF1FE")
ROBINSEGG = fluxionColor("#6DEDFD")
ROBINSEGGBLUE = fluxionColor("#98EFF9")
ROSA = fluxionColor("#FE86A4")
ROSE = fluxionColor("#CF6275")
ROSEPINK = fluxionColor("#F7879A")
ROSERED = fluxionColor("#BE013C")
ROSYPINK = fluxionColor("#F6688E")
ROGUE = fluxionColor("#AB1239")
ROYAL = fluxionColor("#0C1793")
ROYALBLUE = fluxionColor("#0504AA")
ROYALPURPLE = fluxionColor("#4B006E")
RUBY = fluxionColor("#CA0147")
RUSSET = fluxionColor("#A13905")
RUST = fluxionColor("#A83C09")
RUSTBROWN = fluxionColor("#8B3103")
RUSTORANGE = fluxionColor("#C45508")
RUSTRED = fluxionColor("#AA2704")
RUSTYORANGE = fluxionColor("#CD5909")
RUSTYRED = fluxionColor("#AF2F0D")
SAFFRON = fluxionColor("#FEB209")
SAGE = fluxionColor("#87AE73")
SAGEGREEN = fluxionColor("#88B378")
SALMON = fluxionColor("#FF796C")
SALMONPINK = fluxionColor("#FE7B7C")
SAND = fluxionColor("#E2CA76")
SANDBROWN = fluxionColor("#CBA560")
SANDSTONE = fluxionColor("#C9AE74")
SANDY = fluxionColor("#F1DA7A")
SANDYBROWN = fluxionColor("#C4A661")
SANDYELLOW = fluxionColor("#FCE166")
SANDYYELLOW = fluxionColor("#FDEE73")
SAPGREEN = fluxionColor("#5C8B15")
SAPPHIRE = fluxionColor("#2138AB")
SCARLET = fluxionColor("#BE0119")
SEA = fluxionColor("#3C9992")
SEABLUE = fluxionColor("#047495")
SEAFOAM = fluxionColor("#80F9AD")
SEAFOAMBLUE = fluxionColor("#78D1B6")
SEAFOAMGREEN = fluxionColor("#7AF9AB")
SEAGREEN = fluxionColor("#53FCA1")
SEAWEED = fluxionColor("#18D17B")
SEAWEEDGREEN = fluxionColor("#35AD6B")
SEPIA = fluxionColor("#985E2B")
SHAMROCK = fluxionColor("#01B44C")
SHAMROCKGREEN = fluxionColor("#02C14D")
SHIT = fluxionColor("#7F5F00")
SHITBROWN = fluxionColor("#7B5804")
SHITGREEN = fluxionColor("#758000")
SHOCKINGPINK = fluxionColor("#FE02A2")
SICKGREEN = fluxionColor("#9DB92C")
SICKLYGREEN = fluxionColor("#94B21C")
SICKLYYELLOW = fluxionColor("#D0E429")
SIENNA = fluxionColor("#A9561E")
SILVER = fluxionColor("#C5C9C7")
SKY = fluxionColor("#82CAFC")
SKYBLUE = fluxionColor("#75BBFD")
SLATE = fluxionColor("#516572")
SLATEBLUE = fluxionColor("#5B7C99")
SLATEGREEN = fluxionColor("#658D6D")
SLATEGREY = fluxionColor("#59656D")
SLIMEGREEN = fluxionColor("#99CC04")
SNOT = fluxionColor("#ACBB0D")
SNOTGREEN = fluxionColor("#9DC100")
SOFTBLUE = fluxionColor("#6488EA")
SOFTGREEN = fluxionColor("#6FC276")
SOFTPINK = fluxionColor("#FDB0C0")
SOFTPURPLE = fluxionColor("#A66FB5")
SPEARMINT = fluxionColor("#1EF876")
SPRINGGREEN = fluxionColor("#A9F971")
SPRUCE = fluxionColor("#0A5F38")
SQUASH = fluxionColor("#F2AB15")
STEEL = fluxionColor("#738595")
STEELBLUE = fluxionColor("#5A7D9A")
STEELGREY = fluxionColor("#6F828A")
STONE = fluxionColor("#ADA587")
STORMYBLUE = fluxionColor("#507B9C")
STRAW = fluxionColor("#FCF679")
STRAWBERRY = fluxionColor("#FB2943")
STRONGBLUE = fluxionColor("#0C06F7")
STRONGPINK = fluxionColor("#FF0789")
SUNFLOWER = fluxionColor("#FFC512")
SUNFLOWERYELLOW = fluxionColor("#FFDA03")
SUNNYYELLOW = fluxionColor("#FFF917")
SUNSHINEYELLOW = fluxionColor("#FFFD37")
SUNYELLOW = fluxionColor("#FFDF22")
SWAMP = fluxionColor("#698339")
SWAMPGREEN = fluxionColor("#748500")
TAN = fluxionColor("#D1B26F")
TANBROWN = fluxionColor("#AB7E4C")
TANGERINE = fluxionColor("#FF9408")
TANGREEN = fluxionColor("#A9BE70")
TAUPE = fluxionColor("#B9A281")
TEA = fluxionColor("#65AB7C")
TEAGREEN = fluxionColor("#BDF8A3")
TEAL = fluxionColor("#029386")
TEALBLUE = fluxionColor("#01889F")
TEALGREEN = fluxionColor("#25A36F")
TEALISH = fluxionColor("#24BCA8")
TEALISHGREEN = fluxionColor("#0CDC73")
TERRACOTA = fluxionColor("#CB6843")
TERRACOTTA = fluxionColor("#C9643B")
TIFFANYBLUE = fluxionColor("#7BF2DA")
TOMATO = fluxionColor("#EF4026")
TOMATORED = fluxionColor("#EC2D01")
TOPAZ = fluxionColor("#13BBAF")
TOUPE = fluxionColor("#C7AC7D")
TOXICGREEN = fluxionColor("#61DE2A")
TREEGREEN = fluxionColor("#2A7E19")
TRUEBLUE = fluxionColor("#010FCC")
TRUEGREEN = fluxionColor("#089404")
TURQUOISE = fluxionColor("#06C2AC")
TURQUOISEBLUE = fluxionColor("#06B1C4")
TURQUOISEGREEN = fluxionColor("#04F489")
TURTLEGREEN = fluxionColor("#75B84F")
TWILIGHT = fluxionColor("#4E518B")
TWILIGHTBLUE = fluxionColor("#0A437A")
UGLYBLUE = fluxionColor("#31668A")
UGLYBROWN = fluxionColor("#7D7103")
UGLYGREEN = fluxionColor("#7A9703")
UGLYPINK = fluxionColor("#CD7584")
UGLYPURPLE = fluxionColor("#A442A0")
UGLYYELLOW = fluxionColor("#D0C101")
ULTRAMARINE = fluxionColor("#2000B1")
ULTRAMARINEBLUE = fluxionColor("#1805DB")
UMBER = fluxionColor("#B26400")
VELVET = fluxionColor("#750851")
VERMILION = fluxionColor("#F4320C")
VERYDARKBLUE = fluxionColor("#000133")
VERYDARKBROWN = fluxionColor("#1D0200")
VERYDARKGREEN = fluxionColor("#062E03")
VERYDARKPURPLE = fluxionColor("#2A0134")
VERYLIGHTBLUE = fluxionColor("#D5FFFF")
VERYLIGHTBROWN = fluxionColor("#D3B683")
VERYLIGHTGREEN = fluxionColor("#D1FFBD")
VERYLIGHTPINK = fluxionColor("#FFF4F2")
VERYLIGHTPURPLE = fluxionColor("#F6CEFC")
VERYPALEBLUE = fluxionColor("#D6FFFE")
VERYPALEGREEN = fluxionColor("#CFFDBC")
VIBRANTBLUE = fluxionColor("#0339F8")
VIBRANTGREEN = fluxionColor("#0ADD08")
VIBRANTPURPLE = fluxionColor("#AD03DE")
VIOLET = fluxionColor("#9A0EEA")
VIOLETBLUE = fluxionColor("#510AC9")
VIOLETPINK = fluxionColor("#FB5FFC")
VIOLETRED = fluxionColor("#A50055")
VIRIDIAN = fluxionColor("#1E9167")
VIVIDBLUE = fluxionColor("#152EFF")
VIVIDGREEN = fluxionColor("#2FEF10")
VIVIDPURPLE = fluxionColor("#9900FA")
VOMIT = fluxionColor("#A2A415")
VOMITGREEN = fluxionColor("#89A203")
VOMITYELLOW = fluxionColor("#C7C10C")
WARMBLUE = fluxionColor("#4B57DB")
WARMBROWN = fluxionColor("#964E02")
WARMGREY = fluxionColor("#978A84")
WARMPINK = fluxionColor("#FB5581")
WARMPURPLE = fluxionColor("#952E8F")
WASHEDOUTGREEN = fluxionColor("#BCF5A6")
WATERBLUE = fluxionColor("#0E87CC")
WATERMELON = fluxionColor("#FD4659")
WEIRDGREEN = fluxionColor("#3AE57F")
WHEAT = fluxionColor("#FBDD7E")
WHITE = fluxionColor("#FFFFFF")
WINDOWSBLUE = fluxionColor("#3778BF")
WINE = fluxionColor("#80013F")
WINERED = fluxionColor("#7B0323")
WINTERGREEN = fluxionColor("#20F986")
WISTERIA = fluxionColor("#A87DC2")
YELLOW = fluxionColor("#FFFF14")
YELLOWBROWN = fluxionColor("#B79400")
YELLOWGREEN = fluxionColor("#BBF90F")
YELLOWISH = fluxionColor("#FAEE66")
YELLOWISHBROWN = fluxionColor("#9B7A01")
YELLOWISHGREEN = fluxionColor("#B0DD16")
YELLOWISHORANGE = fluxionColor("#FFAB0F")
YELLOWISHTAN = fluxionColor("#FCFC81")
YELLOWOCHRE = fluxionColor("#CB9D06")
YELLOWORANGE = fluxionColor("#FCB001")
YELLOWTAN = fluxionColor("#FFE36E")
YELLOWYBROWN = fluxionColor("#AE8B0C")
YELLOWYGREEN = fluxionColor("#BFF128")
