"""Colors included in the global name space.

These colors form fluxion's default color space.

.. fluxion:: ColorsOverview
    :save_last_frame:
    :hide_source:

    import fluxion.utils.color.fluxion_colors as Colors

    class ColorsOverview(Scene):
        def construct(self):
            def color_group(color):
                group = VGroup(
                    *[
                        Line(ORIGIN, RIGHT * 1.5, stroke_width=35, color=getattr(Colors, name.upper()))
                        for name in subnames(color)
                    ]
                ).arrange_submobjects(buff=0.4, direction=DOWN)

                name = Text(color).scale(0.6).next_to(group, UP, buff=0.3)
                if any(decender in color for decender in "gjpqy"):
                    name.shift(DOWN * 0.08)
                group.add(name)
                return group

            def subnames(name):
                return [name + "_" + char for char in "abcde"]

            color_groups = VGroup(
                *[
                    color_group(color)
                    for color in [
                        "blue",
                        "teal",
                        "green",
                        "yellow",
                        "gold",
                        "red",
                        "maroon",
                        "purple",
                    ]
                ]
            ).arrange_submobjects(buff=0.2, aligned_edge=DOWN)

            for line, char in zip(color_groups[0], "abcde"):
                color_groups.add(Text(char).scale(0.6).next_to(line, LEFT, buff=0.2))

            def named_lines_group(length, color_names, labels, align_to_block):
                colors = [getattr(Colors, color.upper()) for color in color_names]
                lines = VGroup(
                    *[
                        Line(
                            ORIGIN,
                            RIGHT * length,
                            stroke_width=55,
                            color=color,
                        )
                        for color in colors
                    ]
                ).arrange_submobjects(buff=0.6, direction=DOWN)

                for line, name, color in zip(lines, labels, colors):
                    line.add(Text(name, color=color.contrasting()).scale(0.6).move_to(line))
                lines.next_to(color_groups, DOWN, buff=0.5).align_to(
                    color_groups[align_to_block], LEFT
                )
                return lines

            other_colors = (
                "pink",
                "light_pink",
                "orange",
                "light_brown",
                "dark_brown",
                "gray_brown",
            )

            other_lines = named_lines_group(
                3.2,
                other_colors,
                other_colors,
                0,
            )

            gray_lines = named_lines_group(
                6.6,
                ["white"] + subnames("gray") + ["black"],
                [
                    "white",
                    "lighter_gray / gray_a",
                    "light_gray / gray_b",
                    "gray / gray_c",
                    "dark_gray / gray_d",
                    "darker_gray / gray_e",
                    "black",
                ],
                2,
            )

            pure_colors = (
                "pure_red",
                "pure_green",
                "pure_blue",
            )

            pure_lines = named_lines_group(
                3.2,
                pure_colors,
                pure_colors,
                6,
            )

            self.add(color_groups, other_lines, gray_lines, pure_lines)

            VGroup(*self.mobjects).move_to(ORIGIN)

.. autofluxioncolormodule:: fluxion.utils.color.fluxion_colors

"""

from __future__ import annotations

from .core import fluxionColor

WHITE = fluxionColor("#FFFFFF")
GRAY_A = fluxionColor("#DDDDDD")
GREY_A = fluxionColor("#DDDDDD")
GRAY_B = fluxionColor("#BBBBBB")
GREY_B = fluxionColor("#BBBBBB")
GRAY_C = fluxionColor("#888888")
GREY_C = fluxionColor("#888888")
GRAY_D = fluxionColor("#444444")
GREY_D = fluxionColor("#444444")
GRAY_E = fluxionColor("#222222")
GREY_E = fluxionColor("#222222")
BLACK = fluxionColor("#000000")
LIGHTER_GRAY = fluxionColor("#DDDDDD")
LIGHTER_GREY = fluxionColor("#DDDDDD")
LIGHT_GRAY = fluxionColor("#BBBBBB")
LIGHT_GREY = fluxionColor("#BBBBBB")
GRAY = fluxionColor("#888888")
GREY = fluxionColor("#888888")
DARK_GRAY = fluxionColor("#444444")
DARK_GREY = fluxionColor("#444444")
DARKER_GRAY = fluxionColor("#222222")
DARKER_GREY = fluxionColor("#222222")
BLUE_A = fluxionColor("#C7E9F1")
BLUE_B = fluxionColor("#9CDCEB")
BLUE_C = fluxionColor("#58C4DD")
BLUE_D = fluxionColor("#29ABCA")
BLUE_E = fluxionColor("#236B8E")
PURE_BLUE = fluxionColor("#0000FF")
BLUE = fluxionColor("#58C4DD")
DARK_BLUE = fluxionColor("#236B8E")
TEAL_A = fluxionColor("#ACEAD7")
TEAL_B = fluxionColor("#76DDC0")
TEAL_C = fluxionColor("#5CD0B3")
TEAL_D = fluxionColor("#55C1A7")
TEAL_E = fluxionColor("#49A88F")
TEAL = fluxionColor("#5CD0B3")
GREEN_A = fluxionColor("#C9E2AE")
GREEN_B = fluxionColor("#A6CF8C")
GREEN_C = fluxionColor("#83C167")
GREEN_D = fluxionColor("#77B05D")
GREEN_E = fluxionColor("#699C52")
PURE_GREEN = fluxionColor("#00FF00")
GREEN = fluxionColor("#83C167")
YELLOW_A = fluxionColor("#FFF1B6")
YELLOW_B = fluxionColor("#FFEA94")
YELLOW_C = fluxionColor("#FFFF00")
YELLOW_D = fluxionColor("#F4D345")
YELLOW_E = fluxionColor("#E8C11C")
YELLOW = fluxionColor("#FFFF00")
GOLD_A = fluxionColor("#F7C797")
GOLD_B = fluxionColor("#F9B775")
GOLD_C = fluxionColor("#F0AC5F")
GOLD_D = fluxionColor("#E1A158")
GOLD_E = fluxionColor("#C78D46")
GOLD = fluxionColor("#F0AC5F")
RED_A = fluxionColor("#F7A1A3")
RED_B = fluxionColor("#FF8080")
RED_C = fluxionColor("#FC6255")
RED_D = fluxionColor("#E65A4C")
RED_E = fluxionColor("#CF5044")
PURE_RED = fluxionColor("#FF0000")
RED = fluxionColor("#FC6255")
MAROON_A = fluxionColor("#ECABC1")
MAROON_B = fluxionColor("#EC92AB")
MAROON_C = fluxionColor("#C55F73")
MAROON_D = fluxionColor("#A24D61")
MAROON_E = fluxionColor("#94424F")
MAROON = fluxionColor("#C55F73")
PURPLE_A = fluxionColor("#CAA3E8")
PURPLE_B = fluxionColor("#B189C6")
PURPLE_C = fluxionColor("#9A72AC")
PURPLE_D = fluxionColor("#715582")
PURPLE_E = fluxionColor("#644172")
PURPLE = fluxionColor("#9A72AC")
PINK = fluxionColor("#D147BD")
LIGHT_PINK = fluxionColor("#DC75CD")
ORANGE = fluxionColor("#FF862F")
LIGHT_BROWN = fluxionColor("#CD853F")
DARK_BROWN = fluxionColor("#8B4513")
GRAY_BROWN = fluxionColor("#736357")
GREY_BROWN = fluxionColor("#736357")

# Colors used for fluxion Community's logo and banner

LOGO_WHITE = fluxionColor("#ECE7E2")
LOGO_GREEN = fluxionColor("#87C2A5")
LOGO_BLUE = fluxionColor("#525893")
LOGO_RED = fluxionColor("#E07A5F")
LOGO_BLACK = fluxionColor("#343434")

_all_fluxion_colors: list[fluxionColor] = [
    x for x in globals().values() if isinstance(x, fluxionColor)
]
