# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-09-01T12:48:09+00:00

from __future__ import annotations

from datetime import datetime, timedelta
from typing import Dict, List, Literal, Optional, Union
from uuid import UUID

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    PositiveInt,
    RootModel,
    conint,
    constr,
)


class AtomicProperty(BaseModel):
    type: Literal["atomic"] = Field(default="atomic", title="Type")
    name: Literal[
        "app_id",
        "platform",
        "etl_tstamp",
        "collector_tstamp",
        "dvce_created_tstamp",
        "event",
        "event_id",
        "txn_id",
        "name_tracker",
        "v_tracker",
        "v_collector",
        "v_etl",
        "user_id",
        "user_ipaddress",
        "user_fingerprint",
        "domain_userid",
        "domain_sessionidx",
        "network_userid",
        "geo_country",
        "geo_region",
        "geo_city",
        "geo_zipcode",
        "geo_latitude",
        "geo_longitude",
        "geo_region_name",
        "ip_isp",
        "ip_organization",
        "ip_domain",
        "ip_netspeed",
        "page_url",
        "page_title",
        "page_referrer",
        "page_urlscheme",
        "page_urlhost",
        "page_urlport",
        "page_urlpath",
        "page_urlquery",
        "page_urlfragment",
        "refr_urlscheme",
        "refr_urlhost",
        "refr_urlport",
        "refr_urlpath",
        "refr_urlquery",
        "refr_urlfragment",
        "refr_medium",
        "refr_source",
        "refr_term",
        "mkt_medium",
        "mkt_source",
        "mkt_term",
        "mkt_content",
        "mkt_campaign",
        "contexts",
        "se_category",
        "se_action",
        "se_label",
        "se_property",
        "se_value",
        "unstruct_event",
        "tr_orderid",
        "tr_affiliation",
        "tr_total",
        "tr_tax",
        "tr_shipping",
        "tr_city",
        "tr_state",
        "tr_country",
        "ti_orderid",
        "ti_sku",
        "ti_name",
        "ti_category",
        "ti_price",
        "ti_quantity",
        "pp_xoffset_min",
        "pp_xoffset_max",
        "pp_yoffset_min",
        "pp_yoffset_max",
        "useragent",
        "br_name",
        "br_family",
        "br_version",
        "br_type",
        "br_renderengine",
        "br_lang",
        "br_features_pdf",
        "br_features_flash",
        "br_features_java",
        "br_features_director",
        "br_features_quicktime",
        "br_features_realplayer",
        "br_features_windowsmedia",
        "br_features_gears",
        "br_features_silverlight",
        "br_cookies",
        "br_colordepth",
        "br_viewwidth",
        "br_viewheight",
        "os_name",
        "os_family",
        "os_manufacturer",
        "os_timezone",
        "dvce_type",
        "dvce_ismobile",
        "dvce_screenwidth",
        "dvce_screenheight",
        "doc_charset",
        "doc_width",
        "doc_height",
        "tr_currency",
        "tr_total_base",
        "tr_tax_base",
        "tr_shipping_base",
        "ti_currency",
        "ti_price_base",
        "base_currency",
        "geo_timezone",
        "mkt_clickid",
        "mkt_network",
        "etl_tags",
        "dvce_sent_tstamp",
        "refr_domain_userid",
        "refr_device_tstamp",
        "derived_contexts",
        "domain_sessionid",
        "derived_tstamp",
        "event_vendor",
        "event_name",
        "event_format",
        "event_version",
        "event_fingerprint",
        "true_tstamp",
    ] = Field(..., description="The name of the atomic property.", title="Name")


class AttributeGroupReference(BaseModel):
    name: str = Field(..., description="View name", title="Name")
    version: int = Field(..., description="View version", title="Version")


class AttributeKey(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    key: Optional[constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128)] = (
        Field(
            default=None,
            description="The key used to join this entity to an attribute table. If not specified, the name is used.",
            examples=["domain_sessionid"],
            title="Key",
        )
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the entity, typically the email of the primary maintainer.",
        title="Owner",
    )
    ttl: Optional[timedelta] = Field(
        default=None,
        description="The amount of time that attributes for the entity will live in the online store. If not specified both here and in the View, the ttl is not limited.",
        title="Ttl",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this entity has been published to the compute engines.",
        title="Is Published",
    )


class AttributeKeyIdentifiers(RootModel[Optional[Dict[str, List[str]]]]):
    root: Optional[Dict[str, List[str]]] = None


class AttributeKeyReference(BaseModel):
    name: str = Field(..., description="Attribute key name", title="Name")


class AttributesResponse(RootModel[Optional[Dict[str, List]]]):
    root: Optional[Dict[str, List]] = None


class BaseIntervention(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the intervention, typically the email of the primary maintainer.",
        title="Owner",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this intervention has been published to the compute engines.",
        title="Is Published",
    )


class BatchSource(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the batch source.",
        examples=["warehouse_source"],
        title="Name",
    )
    timestamp_field: Optional[constr(pattern=r"^[A-Za-z0-9_]+$")] = Field(
        default=None,
        description="Event timestamp field used for point-in-time joins of attribute values.",
        examples=["derived_tstamp"],
        title="Timestamp Field",
    )
    created_timestamp_column: Optional[constr(pattern=r"^[A-Za-z0-9_]+$")] = Field(
        default=None,
        description="Timestamp column indicating when the row was created, used for deduplicating rows.",
        examples=["created_at"],
        title="Created Timestamp Column",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the data source, typically the email of the primary maintainer.",
        title="Owner",
    )
    date_partition_column: Optional[constr(pattern=r"^[A-Za-z0-9_]+$")] = Field(
        default=None,
        description="Timestamp column used for partitioning.",
        examples=["derived_tstamp"],
        title="Date Partition Column",
    )
    database: constr(pattern=r"^[A-Za-z0-9_\-]+$", min_length=1) = Field(
        ...,
        description="Database where the attributes are stored.",
        examples=["snowflake_db", "my-bigquery-project"],
        title="Database",
    )
    schema_: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1) = Field(
        ...,
        alias="schema",
        description="Schema in which the table is located.",
        examples=["sales_schema", "my_dataset"],
        title="Schema",
    )
    table: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1) = Field(
        ...,
        description="Table where the attributes are stored.",
        examples=["users_table", "transactions"],
        title="Table",
    )


class DeliveryStatus(BaseModel):
    status: Literal["failure", "success", "undelivered"] = Field(..., title="Status")


class EntityProperty(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    vendor: constr(min_length=1) = Field(
        ..., description="The vendor of the property.", title="Vendor"
    )
    name: constr(pattern=r"^[a-zA-Z0-9-_]+$", min_length=1, max_length=128) = Field(
        ..., description="The name of the property.", title="Name"
    )
    major_version: PositiveInt = Field(
        ..., description="The major version of the property.", title="Major Version"
    )
    path: constr(pattern=r"^(?!\$$)(?!.*\[[\'\"]).+$", min_length=1) = Field(
        ...,
        description="The path to the attribute targeted. Allows for direct dot (.) notation and index ([n]) access. Uses a subset of JSONPath syntax E.g. '$.user.profile.name' or '$.events[0].items[1].value'.",
        title="Path",
    )
    type: Literal["entity"] = Field(default="entity", title="Type")
    index: Optional[conint(ge=0)] = Field(
        default=0,
        description="Index of the entity. The :nth entity in the event context.",
        title="Index",
    )


class Event(BaseModel):
    name: Optional[
        constr(pattern=r"^[a-zA-Z0-9-_]+$", min_length=1, max_length=128)
    ] = Field(
        default=None,
        description="Name of the event (`event_name` column in atomic.events table).",
        examples=["page_view"],
        title="Name",
    )
    vendor: Optional[
        constr(pattern=r"^[a-zA-Z0-9-_.]+$", min_length=1, max_length=128)
    ] = Field(
        default=None,
        description="Vendor of the event (`event_vendor` column in atomic.events table).",
        examples=["com.snowplowanalytics"],
        title="Vendor",
    )
    version: Optional[constr(pattern=r"^[0-9]+-[0-9]+-[0-9]+$")] = Field(
        default=None,
        description="Version of the event (`event_version` column in atomic.events table).",
        examples=["1-0-0"],
        title="Version",
    )


class EventProperty(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    vendor: constr(min_length=1) = Field(
        ..., description="The vendor of the property.", title="Vendor"
    )
    name: constr(pattern=r"^[a-zA-Z0-9-_]+$", min_length=1, max_length=128) = Field(
        ..., description="The name of the property.", title="Name"
    )
    major_version: PositiveInt = Field(
        ..., description="The major version of the property.", title="Major Version"
    )
    path: constr(pattern=r"^(?!\$$)(?!.*\[[\'\"]).+$", min_length=1) = Field(
        ...,
        description="The path to the attribute targeted. Allows for direct dot (.) notation and index ([n]) access. Uses a subset of JSONPath syntax E.g. '$.user.profile.name' or '$.events[0].items[1].value'.",
        title="Path",
    )
    type: Literal["event"] = Field(default="event", title="Type")


class FieldModel(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The name of the field.",
        examples=["purchase_amount"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    type: Literal[
        "bytes",
        "string",
        "int32",
        "int64",
        "double",
        "float",
        "bool",
        "unix_timestamp",
        "bytes_list",
        "string_list",
        "int32_list",
        "int64_list",
        "double_list",
        "float_list",
        "bool_list",
        "unix_timestamp_list",
    ] = Field(
        ..., description="The type of the field, such as string or float.", title="Type"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )


class GetAttributeGroupAttributesRequest(BaseModel):
    attribute_keys: AttributeKeyIdentifiers
    full_attribute_names: Optional[bool] = Field(
        default=False, title="Full Attribute Names"
    )
    attributes: List[str] = Field(..., title="Attributes")


class GetServiceAttributesRequest(BaseModel):
    attribute_keys: AttributeKeyIdentifiers
    full_attribute_names: Optional[bool] = Field(
        default=False, title="Full Attribute Names"
    )
    service: str = Field(..., title="Service")


class InterventionReference(BaseModel):
    name: str = Field(..., description="Intervention name", title="Name")
    version: int = Field(..., description="Intervention version", title="Version")


class LinkAttributeKey(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["link_name"],
        title="Name",
    )


class PublishResponse(BaseModel):
    status: Literal["published", "nothing to publish"] = Field(..., title="Status")


class PushAttributesRequest(BaseModel):
    group_name: str = Field(
        ..., description="The name of the attribute group.", title="Group Name"
    )
    group_version: int = Field(
        ..., description="The version of the attribute group.", title="Group Version"
    )
    identifiers: List[str] = Field(
        ...,
        description="The values for the attribute key (e.g. the ID of the user).",
        max_length=100,
        min_length=1,
        title="Identifiers",
    )
    attributes: Dict[str, List] = Field(
        ..., description="The values of the attributes.", title="Attributes"
    )


class ServiceReference(BaseModel):
    name: str = Field(..., description="Service name", title="Name")


class TargetAttributeKey(BaseModel):
    name: str = Field(
        ..., description="The name of the entity being targeted.", title="Name"
    )
    id: str = Field(
        ..., description="The identifier for this entity instance.", title="Id"
    )


class AppId(RootModel[constr(min_length=1, max_length=255)]):
    root: constr(min_length=1, max_length=255)


class AttributeKeyId(
    RootModel[
        constr(
            pattern=r"^[A-Za-z0-9._-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$|^[A-Za-z0-9_-]+$",
            min_length=1,
            max_length=128,
        )
    ]
):
    root: constr(
        pattern=r"^[A-Za-z0-9._-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$|^[A-Za-z0-9_-]+$",
        min_length=1,
        max_length=128,
    )


class UnpublishRequest(BaseModel):
    attribute_keys: Optional[List[AttributeKeyReference]] = Field(
        default=None,
        description="List of attribute key references to remove from Feast",
        title="Attribute Keys",
    )
    attribute_groups: Optional[List[AttributeGroupReference]] = Field(
        default=None,
        description="List of attribute group references with explicit versions to remove from Feast",
        title="Attribute Groups",
    )
    services: Optional[List[ServiceReference]] = Field(
        default=None,
        description="List of service references to remove from Feast",
        title="Services",
    )
    interventions: Optional[List[InterventionReference]] = Field(
        default=None,
        description="List of intervention references with explicit versions to remove from Feast",
        title="Interventions",
    )


class UnpublishResponse(BaseModel):
    status: Literal["unpublished", "nothing to unpublish"] = Field(..., title="Status")


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class VersionedLinkAttributeGroup(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["link_name"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )


class SignalsApiModelsInterventionCriterionCriterion(BaseModel):
    attribute: constr(
        pattern=r"^[A-Za-z0-9_]{1,128}:[A-Za-z0-9_]{1,128}$",
        min_length=3,
        max_length=257,
    ) = Field(
        ...,
        description="The name of the attribute to evaluate for this criterion using operator and value. The attribute name should be qualified, including the name of the view that contains it",
        examples=["my_view:my_attribute"],
        title="Attribute",
    )
    operator: Literal[
        "=",
        "!=",
        "<",
        ">",
        "<=",
        ">=",
        "like",
        "not like",
        "rlike",
        "not rlike",
        "in",
        "not in",
        "is null",
        "is not null",
    ] = Field(
        ...,
        description="The operator used to compare the attribute to the value.",
        title="Operator",
    )
    value: Optional[
        Union[str, int, float, bool, List[str], List[int], List[float], List[bool]]
    ] = Field(
        default=None,
        description="The value to be compared using operator against the attribute value for this criterion.",
        title="Value",
    )


class SignalsApiModelsViewCriterionCriterion(BaseModel):
    property: Union[AtomicProperty, EventProperty, EntityProperty] = Field(
        ...,
        description="The path to the property on the event or entity you wish to filter.",
        discriminator="type",
        title="Property",
    )
    operator: Literal["=", "!=", "<", ">", "<=", ">=", "like", "in"] = Field(
        ...,
        description="The operator used to compare the property to the value.",
        title="Operator",
    )
    value: Union[
        str, int, float, bool, List[str], List[int], List[float], List[bool]
    ] = Field(..., description="The value to compare the property to.", title="Value")


class CriteriaInput(BaseModel):
    all: Optional[List[SignalsApiModelsViewCriterionCriterion]] = Field(
        default=None,
        description="An array of conditions used to filter the events. All conditions must be met.",
        title="All",
    )
    any: Optional[List[SignalsApiModelsViewCriterionCriterion]] = Field(
        default=None,
        description="An array of conditions used to filter the events. At least one condition must be met.",
        title="Any",
    )


class CriteriaOutput(BaseModel):
    all: Optional[List[SignalsApiModelsViewCriterionCriterion]] = Field(
        default=None,
        description="An array of conditions used to filter the events. All conditions must be met.",
        title="All",
    )
    any: Optional[List[SignalsApiModelsViewCriterionCriterion]] = Field(
        default=None,
        description="An array of conditions used to filter the events. At least one condition must be met.",
        title="Any",
    )


class CriterionWithStringProperty(BaseModel):
    property: Union[Union[AtomicProperty, EventProperty, EntityProperty], str] = Field(
        ...,
        description="The path to the property on the event or entity you wish to filter.",
        title="Property",
    )
    operator: Literal["=", "!=", "<", ">", "<=", ">=", "like", "in"] = Field(
        ...,
        description="The operator used to compare the property to the value.",
        title="Operator",
    )
    value: Union[
        str, int, float, bool, List[str], List[int], List[float], List[bool]
    ] = Field(..., description="The value to compare the property to.", title="Value")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(default=None, title="Detail")


class InterventionInstance(BaseModel):
    intervention_id: Optional[UUID] = Field(default=None, title="Intervention Id")
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the intervention.",
        examples=["my_intervention"],
        title="Name",
    )
    version: int = Field(..., description="The version of the object.", title="Version")
    target_attribute_key: Optional[TargetAttributeKey] = Field(
        default=None,
        description="The entity instance that triggered this intervention.",
    )
    attributes: Optional[Dict[str, str]] = Field(
        default=None,
        description="Current attributes for the target_attribute_key at the time of this intervention.",
        title="Attributes",
    )


class SelectivePublishRequest(BaseModel):
    attribute_keys: Optional[List[AttributeKeyReference]] = Field(
        default=None,
        description="List of attribute key references to publish",
        title="Attribute Keys",
    )
    attribute_groups: Optional[List[AttributeGroupReference]] = Field(
        default=None,
        description="List of attribute group references with explicit versions to publish",
        title="Attribute Groups",
    )
    services: Optional[List[ServiceReference]] = Field(
        default=None,
        description="List of service references to publish",
        title="Services",
    )
    interventions: Optional[List[InterventionReference]] = Field(
        default=None,
        description="List of intervention references with explicit versions to publish",
        title="Interventions",
    )


class Service(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    attribute_groups: Optional[List[VersionedLinkAttributeGroup]] = Field(
        default=None,
        description="A list containing attribute groups, representing the features in the service.",
        max_length=100,
        min_length=1,
        title="Attribute Groups",
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the service, typically the email of the primary maintainer.",
        title="Owner",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this service has been published to the compute engines.",
        title="Is Published",
    )


class AttributeInput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The name of the field.",
        examples=["purchase_amount"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    type: Literal[
        "bytes",
        "string",
        "int32",
        "int64",
        "double",
        "float",
        "bool",
        "unix_timestamp",
        "bytes_list",
        "string_list",
        "int32_list",
        "int64_list",
        "double_list",
        "float_list",
        "bool_list",
        "unix_timestamp_list",
    ] = Field(
        ..., description="The type of the field, such as string or float.", title="Type"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    events: List[Event] = Field(
        ...,
        description="An array of event schemas that the attribute should be calculated for.",
        min_length=1,
        title="Events",
    )
    aggregation: Literal[
        "counter", "sum", "min", "max", "mean", "first", "last", "unique_list"
    ] = Field(
        ..., description="The aggregation type of the attribute.", title="Aggregation"
    )
    property: Optional[Union[AtomicProperty, EventProperty, EntityProperty]] = Field(
        default=None,
        description="The path to the property on the event or entity you wish to use in the aggregation.",
        title="Property",
    )
    criteria: Optional[CriteriaInput] = Field(
        default=None, description="An array of conditions used to filter the events."
    )
    period: Optional[timedelta] = Field(
        default=None,
        description="The time period over which the aggregation should be calculated.",
        title="Period",
    )
    default_value: Optional[
        Union[str, int, float, bool, List[Union[str, int, float, bool]]]
    ] = Field(
        default=None,
        description="The default value to use if the aggregation returns no results. If not set, the default value is automatically assigned based on the `type`.",
        title="Default Value",
    )


class AttributeOutput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The name of the field.",
        examples=["purchase_amount"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    type: Literal[
        "bytes",
        "string",
        "int32",
        "int64",
        "double",
        "float",
        "bool",
        "unix_timestamp",
        "bytes_list",
        "string_list",
        "int32_list",
        "int64_list",
        "double_list",
        "float_list",
        "bool_list",
        "unix_timestamp_list",
    ] = Field(
        ..., description="The type of the field, such as string or float.", title="Type"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    events: List[Event] = Field(
        ...,
        description="An array of event schemas that the attribute should be calculated for.",
        min_length=1,
        title="Events",
    )
    aggregation: Literal[
        "counter", "sum", "min", "max", "mean", "first", "last", "unique_list"
    ] = Field(
        ..., description="The aggregation type of the attribute.", title="Aggregation"
    )
    property: Optional[Union[AtomicProperty, EventProperty, EntityProperty]] = Field(
        default=None,
        description="The path to the property on the event or entity you wish to use in the aggregation.",
        title="Property",
    )
    criteria: Optional[CriteriaOutput] = Field(
        default=None, description="An array of conditions used to filter the events."
    )
    period: Optional[timedelta] = Field(
        default=None,
        description="The time period over which the aggregation should be calculated.",
        title="Period",
    )
    default_value: Optional[
        Union[str, int, float, bool, List[Union[str, int, float, bool]]]
    ] = Field(
        default=None,
        description="The default value to use if the aggregation returns no results. If not set, the default value is automatically assigned based on the `type`.",
        title="Default Value",
    )


class AttributeGroupInput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    attribute_key: LinkAttributeKey = Field(
        ..., description="The attribute_key that this view is associated with."
    )
    ttl: Optional[timedelta] = Field(
        default=None,
        description="The amount of time this group of attributes lives. If not specified, the attribute_key's ttl is used or the ttl is not limited.",
        title="Ttl",
    )
    batch_source: Optional[BatchSource] = Field(
        default=None,
        description="The batch source for materializing this view from the warehouse.",
    )
    online: Optional[bool] = Field(
        default=True,
        description="A boolean indicating whether online retrieval is enabled for this view.",
        title="Online",
    )
    offline: Optional[bool] = Field(
        default=None,
        description="A boolean indicating whether the attributes are pre-computed in the warehouse.",
        title="Offline",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the view, typically the email of the primary maintainer.",
        title="Owner",
    )
    fields: Optional[List[FieldModel]] = Field(
        default=None,
        description="The list of table columns that are part of this view during materialization.",
        title="Fields",
    )
    attributes: Optional[List[AttributeInput]] = Field(
        default=None,
        description="The list of attributes that will be calculated from events as part of this view.",
        title="Attributes",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this view has been published to the compute engines.",
        title="Is Published",
    )


class AttributeGroupOutput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    attribute_key: LinkAttributeKey = Field(
        ..., description="The attribute_key that this view is associated with."
    )
    ttl: Optional[timedelta] = Field(
        default=None,
        description="The amount of time this group of attributes lives. If not specified, the attribute_key's ttl is used or the ttl is not limited.",
        title="Ttl",
    )
    batch_source: Optional[BatchSource] = Field(
        default=None,
        description="The batch source for materializing this view from the warehouse.",
    )
    online: Optional[bool] = Field(
        default=True,
        description="A boolean indicating whether online retrieval is enabled for this view.",
        title="Online",
    )
    offline: Optional[bool] = Field(
        default=None,
        description="A boolean indicating whether the attributes are pre-computed in the warehouse.",
        title="Offline",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the view, typically the email of the primary maintainer.",
        title="Owner",
    )
    fields: Optional[List[FieldModel]] = Field(
        default=None,
        description="The list of table columns that are part of this view during materialization.",
        title="Fields",
    )
    attributes: Optional[List[AttributeOutput]] = Field(
        default=None,
        description="The list of attributes that will be calculated from events as part of this view.",
        title="Attributes",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this view has been published to the compute engines.",
        title="Is Published",
    )
    feast_name: str = Field(..., title="Feast Name")
    full_name: str = Field(..., title="Full Name")
    stream_source_name: Optional[str] = Field(..., title="Stream Source Name")


class CriteriaWithStringProperty(BaseModel):
    all: Optional[List[CriterionWithStringProperty]] = Field(
        default=None,
        description="An array of conditions used to filter the events. All conditions must be met.",
        title="All",
    )
    any: Optional[List[CriterionWithStringProperty]] = Field(
        default=None,
        description="An array of conditions used to filter the events. At least one condition must be met.",
        title="Any",
    )


class TestAttributeGroupRequest(BaseModel):
    attribute_group: AttributeGroupInput = Field(
        ..., description="Attribute group to test"
    )
    app_ids: Optional[List[AppId]] = Field(
        default=None,
        description="List of app_ids to test. If empty, all app_ids will be tested",
        max_length=10,
        title="App Ids",
    )
    window: Optional[timedelta] = Field(
        default="PT1H",
        description="The time window to consider when querying the atomic events table",
        title="Window",
    )
    attribute_key_ids: Optional[List[AttributeKeyId]] = Field(
        default=None,
        description="List of attribute key IDs to test (e.g., list of domain_userid). If empty, a sample of 10 random IDs will be used",
        max_length=50,
        title="Attribute Key Ids",
    )


class AttributeWithStringProperty(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The name of the field.",
        examples=["purchase_amount"],
        title="Name",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    type: Literal[
        "bytes",
        "string",
        "int32",
        "int64",
        "double",
        "float",
        "bool",
        "unix_timestamp",
        "bytes_list",
        "string_list",
        "int32_list",
        "int64_list",
        "double_list",
        "float_list",
        "bool_list",
        "unix_timestamp_list",
    ] = Field(
        ..., description="The type of the field, such as string or float.", title="Type"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    events: List[Event] = Field(
        ...,
        description="An array of event schemas that the attribute should be calculated for.",
        min_length=1,
        title="Events",
    )
    aggregation: Literal[
        "counter", "sum", "min", "max", "mean", "first", "last", "unique_list"
    ] = Field(
        ..., description="The aggregation type of the attribute.", title="Aggregation"
    )
    property: Optional[
        Union[Union[AtomicProperty, EventProperty, EntityProperty], str]
    ] = Field(
        default=None,
        description="The path to the property on the event or entity you wish to use in the aggregation.",
        title="Property",
    )
    criteria: Optional[CriteriaWithStringProperty] = Field(
        default=None, description="An array of conditions used to filter the events."
    )
    period: Optional[timedelta] = Field(
        default=None,
        description="The time period over which the aggregation should be calculated.",
        title="Period",
    )
    default_value: Optional[
        Union[str, int, float, bool, List[Union[str, int, float, bool]]]
    ] = Field(
        default=None,
        description="The default value to use if the aggregation returns no results. If not set, the default value is automatically assigned based on the `type`.",
        title="Default Value",
    )


class AttributeGroupResponse(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    attribute_key: LinkAttributeKey = Field(
        ..., description="The attribute_key that this view is associated with."
    )
    ttl: Optional[timedelta] = Field(
        default=None,
        description="The amount of time this group of attributes lives. If not specified, the attribute_key's ttl is used or the ttl is not limited.",
        title="Ttl",
    )
    batch_source: Optional[BatchSource] = Field(
        default=None,
        description="The batch source for materializing this view from the warehouse.",
    )
    online: Optional[bool] = Field(
        default=True,
        description="A boolean indicating whether online retrieval is enabled for this view.",
        title="Online",
    )
    offline: Optional[bool] = Field(
        default=None,
        description="A boolean indicating whether the attributes are pre-computed in the warehouse.",
        title="Offline",
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the view, typically the email of the primary maintainer.",
        title="Owner",
    )
    fields: Optional[List[FieldModel]] = Field(
        default=None,
        description="The list of table columns that are part of this view during materialization.",
        title="Fields",
    )
    attributes: Optional[List[AttributeWithStringProperty]] = Field(
        default=None,
        description="The list of attributes that will be calculated from events as part of this view.",
        title="Attributes",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this view has been published to the compute engines.",
        title="Is Published",
    )
    attribute_key_or_name: str = Field(
        ...,
        description="The key of the associated entity.",
        title="Attribute Key Or Name",
    )
    attribute_group_or_attribute_key_ttl: Optional[timedelta] = Field(
        default=None,
        description="The TTL of the view or entity.",
        title="Attribute Group Or Attribute Key Ttl",
    )
    feast_name: str = Field(..., title="Feast Name")
    full_name: str = Field(..., title="Full Name")
    stream_source_name: Optional[str] = Field(..., title="Stream Source Name")


class PublishedAttributesForStream(BaseModel):
    attribute_groups: List[AttributeGroupResponse] = Field(
        ..., title="Attribute Groups"
    )
    published_at: Optional[datetime] = Field(default=None, title="Published At")


class CriteriaAllInput(BaseModel):
    all: List[
        Union[
            CriteriaAllInput,
            CriteriaAnyInput,
            CriteriaNoneInput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. All conditions must be met.",
        title="All",
    )


class CriteriaAllOutput(BaseModel):
    all: List[
        Union[
            CriteriaAllOutput,
            CriteriaAnyOutput,
            CriteriaNoneOutput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. All conditions must be met.",
        title="All",
    )


class CriteriaAnyInput(BaseModel):
    any: List[
        Union[
            CriteriaAllInput,
            CriteriaAnyInput,
            CriteriaNoneInput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. At least one condition must be met.",
        title="Any",
    )


class CriteriaAnyOutput(BaseModel):
    any: List[
        Union[
            CriteriaAllOutput,
            CriteriaAnyOutput,
            CriteriaNoneOutput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. At least one condition must be met.",
        title="Any",
    )


class CriteriaNoneInput(BaseModel):
    none: List[
        Union[
            CriteriaAllInput,
            CriteriaAnyInput,
            CriteriaNoneInput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. None of the conditions may be met.",
        title="None",
    )


class CriteriaNoneOutput(BaseModel):
    none: List[
        Union[
            CriteriaAllOutput,
            CriteriaAnyOutput,
            CriteriaNoneOutput,
            SignalsApiModelsInterventionCriterionCriterion,
        ]
    ] = Field(
        ...,
        description="An array of conditions used to determine if the intervention should trigger. None of the conditions may be met.",
        title="None",
    )


class PublishedInterventionsForStream(BaseModel):
    interventions: List[Union[RuleInterventionOutput, BaseIntervention]] = Field(
        ..., title="Interventions"
    )
    published_at: Optional[datetime] = Field(default=None, title="Published At")


class RuleInterventionInput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the intervention, typically the email of the primary maintainer.",
        title="Owner",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this intervention has been published to the compute engines.",
        title="Is Published",
    )
    criteria: Union[
        CriteriaAllInput,
        CriteriaAnyInput,
        CriteriaNoneInput,
        SignalsApiModelsInterventionCriterionCriterion,
    ] = Field(
        ...,
        description="Rule or group of rules defining features that should be evaluated to determine if the intervention should be triggered",
        title="Criteria",
    )
    target_attribute_keys: Optional[List[LinkAttributeKey]] = Field(
        default=None,
        description="The attribute keys that should be targeted with this intervention by having their IDs extracted from the event that triggered this intervention",
        title="Target Attribute Keys",
    )


class RuleInterventionOutput(BaseModel):
    name: constr(pattern=r"^[A-Za-z0-9_]+$", min_length=1, max_length=128) = Field(
        ...,
        description="The unique name of the object.",
        examples=["my_resource"],
        title="Name",
    )
    version: Optional[int] = Field(
        default=1, description="The version of the object.", title="Version"
    )
    description: Optional[str] = Field(
        default=None, description="A human-readable description.", title="Description"
    )
    tags: Optional[Dict[str, str]] = Field(
        default=None,
        description="A dictionary of key-value pairs to store arbitrary metadata.",
        title="Tags",
    )
    owner: Optional[str] = Field(
        default=None,
        description="The owner of the intervention, typically the email of the primary maintainer.",
        title="Owner",
    )
    is_published: Optional[bool] = Field(
        default=False,
        description="Whether this intervention has been published to the compute engines.",
        title="Is Published",
    )
    criteria: Union[
        CriteriaAllOutput,
        CriteriaAnyOutput,
        CriteriaNoneOutput,
        SignalsApiModelsInterventionCriterionCriterion,
    ] = Field(
        ...,
        description="Rule or group of rules defining features that should be evaluated to determine if the intervention should be triggered",
        title="Criteria",
    )
    target_attribute_keys: Optional[List[LinkAttributeKey]] = Field(
        default=None,
        description="The attribute keys that should be targeted with this intervention by having their IDs extracted from the event that triggered this intervention",
        title="Target Attribute Keys",
    )


CriteriaAllInput.model_rebuild()
CriteriaAllOutput.model_rebuild()
CriteriaAnyInput.model_rebuild()
CriteriaAnyOutput.model_rebuild()
PublishedInterventionsForStream.model_rebuild()
