"""
Web application
(from lessweb)
"""
from typing import List, Any, Callable

from lessweb.context import Context
from lessweb.bridge import JsonBridgeFunc
from lessweb.pluginproto import PluginProto


__all__ = [
    "Interceptor", "Mapping", "interceptor", "Application",
]


class Interceptor:
    pattern: str
    method: str
    dealer: Callable
    patternobj: Any
    def __init__(self, pattern, method, dealer, patternobj) -> None: ...

class Mapping:
    pattern: str
    method: str
    dealer: Callable
    doc: str
    patternobj: Any
    def __init__(self, pattern, method, dealer, doc, patternobj) -> None: ...


def build_controller(dealer): ...


def interceptor(dealer): ...


class Application(object):
    mapping: List[Mapping]
    interceptors: List[Interceptor]
    response_bridges: List[Callable]
    response_encoder: Any
    encoding: str
    plugins: List[PluginProto]
    def __init__(self, encoding:str='utf-8') -> None: ...
    def _handle_with_dealers(self, ctx: Context): ...
    def add_interceptor(self, pattern: str, method: str, dealer: Callable): ...
    def add_json_bridge(self, bridge_func: JsonBridgeFunc): ...
    def add_mapping(self, pattern: str, method: str, dealer: Callable): ...
    def add_connect_interceptor(self, pattern: str, dealer: Callable): ...
    def add_connect_mapping(self, pattern: str, dealer: Callable): ...
    def add_delete_interceptor(self, pattern: str, dealer: Callable): ...
    def add_delete_mapping(self, pattern: str, dealer: Callable): ...
    def add_get_interceptor(self, pattern: str, dealer: Callable): ...
    def add_get_mapping(self, pattern: str, dealer: Callable): ...
    def add_head_interceptor(self, pattern: str, dealer: Callable): ...
    def add_head_mapping(self, pattern: str, dealer: Callable): ...
    def add_options_interceptor(self, pattern: str, dealer: Callable): ...
    def add_options_mapping(self, pattern: str, dealer: Callable): ...
    def add_patch_interceptor(self, pattern: str, dealer: Callable): ...
    def add_patch_mapping(self, pattern: str, dealer: Callable): ...
    def add_post_interceptor(self, pattern: str, dealer: Callable): ...
    def add_post_mapping(self, pattern: str, dealer: Callable): ...
    def add_put_interceptor(self, pattern: str, dealer: Callable): ...
    def add_put_mapping(self, pattern: str, dealer: Callable): ...
    def add_plugin(self, plugin: PluginProto): ...
    def wsgifunc(self, *middleware): ...
    def run(self, wsgifunc=None, port:int=8080, homepath:str='', staticpath:str='static'): ...
