from typing import Optional, Dict, List, Tuple
import cgi
from io import BytesIO
from http.cookies import Morsel, SimpleCookie, CookieError
from urllib.parse import parse_qs, unquote
from enum import Enum
from typing import NamedTuple
from .bridge import ParamStr, MultipartFile


__all__ = ["mimetypes", "hop_by_hop_headers", "http_methods", "ParamInput", "ResponseStatus", "HttpStatus",
           "Cookie", "parse_cookie", "BadParamError", "NotFoundError"]


mimetypes: Dict

hop_by_hop_headers: Tuple

http_methods: Tuple


class ParamInput:
    url_input: Dict[str, ParamStr]
    query_input: Dict[str, List[ParamStr]]
    form_input: Dict[str, List[ParamStr]]
    def __init__(self) -> None: ...
    def load_query(self, query: str, encoding: str) -> None: ...
    def load_form(self, body: bytes, env: Dict, encoding: str, file_input: Dict[str, List[MultipartFile]]) -> None: ...
    def load_url(self, groupdict: Dict) -> None: ...


class ResponseStatus(NamedTuple):
    code: int
    reason: str


class HttpStatus(Enum):
    @staticmethod
    def of(code: int) -> 'HttpStatus': ...
    OK: ResponseStatus = ...
    Created: ResponseStatus = ...
    Accepted: ResponseStatus = ...
    NoContent: ResponseStatus = ...
    MovedPermanently: ResponseStatus = ...
    Found: ResponseStatus = ...
    SeeOther: ResponseStatus = ...
    NotModified: ResponseStatus = ...
    TemporaryRedirect: ResponseStatus = ...
    BadRequest: ResponseStatus = ...
    Unauthorized: ResponseStatus = ...
    Forbidden: ResponseStatus = ...
    NotFound: ResponseStatus = ...
    MethodNotAllowed: ResponseStatus = ...
    NotAcceptable: ResponseStatus = ...
    Conflict: ResponseStatus = ...
    Gone: ResponseStatus = ...
    PreconditionFailed: ResponseStatus = ...
    UnsupportedMediaType: ResponseStatus = ...
    UnprocessableEntity: ResponseStatus = ...
    UnavailableForLegalReasons: ResponseStatus = ...
    InternalServerError: ResponseStatus = ...


class Cookie:
    name: str
    value: str
    expires: Optional[int]
    path: str
    domain: Optional[str]
    secure: bool
    httponly: bool
    def __init__(self, name:str, value:str, expires:int=None, path:str='/',
                 domain:str=None, secure:bool=False, httponly:bool=False) -> None: ...
    def dumps(self) -> str: ...


def parse_cookie(http_cookie: str)->Dict[str, str]: ...


class BadParamError(Exception):
    param: str
    message: str
    def __init__(self, message: str, param: str=...) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


class NotFoundError(Exception):
    methods: Optional[List[str]]
    def __init__(self, methods: List[str]=None): ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...


def header_name_of_wsgi_key(wsgi_key: str) -> str: ...
def wsgi_key_of_header_name(header_name: str) -> str: ...