"""README content generation for mirrored repositories."""


def create_readme_content(username, repo_name, num_commits, date_range_start, date_range_end, original_repo):
    """
    Generate a README for the mirrored repository.

    Args:
        username: GitHub username who owns the mirrored repo
        repo_name: Name of the mirrored repository
        num_commits: Number of commits that were mirrored
        date_range_start: Start date string (YYYY-MM-DD format)
        date_range_end: End date string (YYYY-MM-DD format)
        original_repo: Name of the original work repository

    Returns:
        str: Complete markdown content for the README
    """
    return f"""# {repo_name}

[![shōmei](https://img.shields.io/badge/generated_by-shōmei-blueviolet?style=for-the-badge)](https://github.com/petarran/shomei)
[![commits](https://img.shields.io/badge/commits-{num_commits}-green?style=for-the-badge)](https://github.com/{username}/{repo_name})

> **proof of work** - this repository mirrors verified contributions without exposing proprietary code

## what is this?

this repo was automatically generated by [**shōmei**](https://github.com/petarran/shomei) (証明, "proof" in Japanese), a tool that mirrors your work commits to your personal GitHub while keeping your company's IP safe.

### the story

i've been shipping code at `{original_repo}`, but all those contributions were tied to my work email. my personal GitHub looked dead. recruiters thought i was on a permanent vacation. 

**shōmei** solved this by creating empty commits that match my work contribution timeline and my contribution graph now reflects reality.

## stats

- **{num_commits} commits** mirrored from my work repo
- **date range**: {date_range_start} → {date_range_end}
- **zero code leaked** - only commit timestamps were used
- **fully automated** - generated in seconds

## why does this exist?

lots of developers use separate GitHubs for work. when you leave a company or just want to showcase your activity, your personal profile makes it look like you took years off. this is especially annoying when job hunting.

**shōmei** fixes this safely and ethically:
- no proprietary code is exposed
- no commit messages from work
- no file names or structure
- just timestamps proving you were actually working

## want to do this too?

check out [**shōmei**](https://github.com/petarran/shomei) - it's dead simple:

```bash
pip install shomei
cd ~/work/your-repo
shomei
```

that's it! your contribution graph will thank you!

---

<div align="center">

**[⭐ star shōmei on GitHub](https://github.com/petarran/shomei)** if this helped you!

*generated with [shōmei](https://github.com/petarran/shomei) - proof of your work*

</div>
"""
