from __future__ import annotations
import typing
__all__ = ['Environment', 'FileEnv', 'Graph', 'GraphNode', 'GraphNodeStatus', 'Vector', 'aggregate', 'argmax', 'argmin', 'backward', 'cat', 'const', 'copy', 'dot', 'euclidean', 'exp', 'forward', 'log', 'max', 'maximum', 'mean', 'min', 'minimum', 'negative_entropy', 'normalize', 'project', 'set_seed', 'sum']
class Environment:
    @typing.overload
    def exploitability(self, strategy: GraphNode, type_name: str = 'default') -> list[float]:
        ...
    @typing.overload
    def exploitability(self, strategy: list[GraphNode], type_name: str = 'default') -> list[float]:
        ...
    def get_strategy(self, player: int, strategy: GraphNode, type_name: str = 'default') -> list[tuple[str, list[float]]]:
        ...
    def get_value(self, player: int, node: GraphNode) -> list[tuple[str, list[float]]]:
        ...
    def set_graph(self, graph: Graph) -> None:
        ...
    def set_value(self, player: int, node: GraphNode, values: list[list[float]]) -> None:
        ...
    @typing.overload
    def update(self, strategy: GraphNode, upd_player: int = -1, upd_color: list[int] = [-1], traverse_type: str = 'default') -> None:
        ...
    @typing.overload
    def update(self, strategies: list[GraphNode], upd_player: int = -1, upd_color: list[int] = [-1], traverse_type: str = 'default') -> None:
        ...
    def update_strategy(self, strategy: GraphNode, update_best: bool = False) -> None:
        ...
    @typing.overload
    def utility(self, strategy: GraphNode, type_name: str = 'default') -> list[float]:
        ...
    @typing.overload
    def utility(self, strategy: list[GraphNode], type_name: str = 'default') -> list[float]:
        ...
class FileEnv(Environment):
    def __init__(self, file_name: str, traverse_type: str = 'Enumerate') -> None:
        ...
class Graph:
    def __init__(self) -> None:
        ...
    @property
    def action_set_size(self) -> GraphNode:
        ...
    @property
    def opponent_reach_prob(self) -> GraphNode:
        ...
    @property
    def reach_prob(self) -> GraphNode:
        ...
    @property
    def subtree_size(self) -> GraphNode:
        ...
    @property
    def utility(self) -> GraphNode:
        ...
class GraphNode:
    __hash__: typing.ClassVar[None] = None
    def __add__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __eq__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __eq__(self, arg0: float | int) -> GraphNode:
        ...
    @typing.overload
    def __ge__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __ge__(self, arg0: float | int) -> GraphNode:
        ...
    @typing.overload
    def __gt__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __gt__(self, arg0: float | int) -> GraphNode:
        ...
    def __init__(self) -> None:
        ...
    @typing.overload
    def __le__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __le__(self, arg0: float | int) -> GraphNode:
        ...
    @typing.overload
    def __lt__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    @typing.overload
    def __lt__(self, arg0: float | int) -> GraphNode:
        ...
    def __mul__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    def __neg__(self) -> GraphNode:
        ...
    def __pow__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    def __radd__(self, arg0: float | int) -> GraphNode:
        ...
    def __rmul__(self, arg0: float | int) -> GraphNode:
        ...
    def __rpow__(self: float | int, arg0: GraphNode) -> GraphNode:
        ...
    def __rsub__(self, arg0: float | int) -> GraphNode:
        ...
    def __rtruediv__(self, arg0: float | int) -> GraphNode:
        ...
    def __sub__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    def __truediv__(self, arg0: int | float | GraphNode) -> GraphNode:
        ...
    def argmax(self) -> GraphNode:
        ...
    def argmin(self) -> GraphNode:
        ...
    def copy(self) -> GraphNode:
        ...
    def dot(self, arg0: GraphNode) -> GraphNode:
        ...
    def euclidean(self) -> GraphNode:
        ...
    def exp(self) -> GraphNode:
        ...
    def inplace(self, arg0: GraphNode) -> None:
        ...
    def log(self) -> GraphNode:
        ...
    def max(self) -> GraphNode:
        ...
    def mean(self) -> GraphNode:
        ...
    def min(self) -> GraphNode:
        ...
    def negative_entropy(self, shifted: bool = False) -> GraphNode:
        ...
    def normalize(self, p_norm: float, ignore_negative: bool = False) -> GraphNode:
        ...
    @typing.overload
    def project(self, distance: str, gamma: int | float | GraphNode = 0.0) -> GraphNode:
        ...
    @typing.overload
    def project(self, distance: str, gamma: int | float | GraphNode, mu: GraphNode) -> GraphNode:
        ...
    def sum(self) -> GraphNode:
        ...
class GraphNodeStatus:
    def __enter__(self) -> GraphNodeStatus:
        ...
    def __exit__(self, *args) -> None:
        ...
    def __init__(self) -> None:
        ...
class Vector:
    def __init__(self) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def print(self) -> None:
        ...
class backward(GraphNodeStatus):
    def __init__(self, is_static: bool = False, color: int = 0) -> None:
        ...
class forward(GraphNodeStatus):
    def __init__(self, is_static: bool = False, color: int = 0) -> None:
        ...
def aggregate(arg0: GraphNode, aggregator: str, object: str = 'children', player: str = 'self', padding: float = 0.0) -> GraphNode:
    ...
def argmax(arg0: GraphNode) -> GraphNode:
    ...
def argmin(arg0: GraphNode) -> GraphNode:
    ...
def cat(nodes: list[GraphNode]) -> GraphNode:
    ...
def const(size: int | float | GraphNode, val: int | float | GraphNode) -> GraphNode:
    ...
def copy(arg0: GraphNode) -> GraphNode:
    ...
def dot(arg0: GraphNode, arg1: GraphNode) -> GraphNode:
    ...
def euclidean(arg0: GraphNode) -> GraphNode:
    ...
def exp(arg0: GraphNode) -> GraphNode:
    ...
def log(arg0: GraphNode) -> GraphNode:
    ...
def max(arg0: GraphNode) -> GraphNode:
    ...
def maximum(arg0: GraphNode, arg1: int | float | GraphNode) -> GraphNode:
    ...
def mean(arg0: GraphNode) -> GraphNode:
    ...
def min(arg0: GraphNode) -> GraphNode:
    ...
def minimum(arg0: GraphNode, arg1: int | float | GraphNode) -> GraphNode:
    ...
def negative_entropy(arg0: GraphNode, shifted: bool = False) -> GraphNode:
    ...
def normalize(arg0: GraphNode, p_norm: float, ignore_negative: bool = False) -> GraphNode:
    ...
@typing.overload
def project(arg0: GraphNode, distance: str, gamma: int | float | GraphNode = 0.0) -> GraphNode:
    ...
@typing.overload
def project(arg0: GraphNode, distance: str, gamma: int | float | GraphNode, mu: GraphNode) -> GraphNode:
    ...
def set_seed(seed: int) -> None:
    ...
def sum(arg0: GraphNode) -> GraphNode:
    ...
