# Generated by Django 4.2.23 on 2025-07-04 23:56

import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='API',
            fields=[
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('method', models.CharField(default='GET', max_length=18, verbose_name='Method')),
                ('api', models.CharField(max_length=255, verbose_name='API API')),
                ('func_name', models.CharField(max_length=255, verbose_name='API Name')),
                ('name', models.CharField(default='', max_length=255, verbose_name='API Description')),
            ],
            options={
                'verbose_name': 'bomiot API',
                'verbose_name_plural': 'bomiot API',
                'db_table': 'bomiot_api',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='ASN',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot ASN',
                'verbose_name_plural': 'bomiot ASN',
                'db_table': 'bomiot_asn',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Bar',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Bar',
                'verbose_name_plural': 'bomiot Bar',
                'db_table': 'bomiot_bar',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Bin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Bin',
                'verbose_name_plural': 'bomiot Bin',
                'db_table': 'bomiot_bin',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Capital',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Capital',
                'verbose_name_plural': 'bomiot Capital',
                'db_table': 'bomiot_capital',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='CPU',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('cpu_usage', models.FloatField(default=0, verbose_name='CPU Usage')),
                ('physical_cores', models.IntegerField(default=0, verbose_name='Physical Cores')),
                ('logical_cores', models.IntegerField(default=0, verbose_name='Logical Cores')),
                ('cpu_frequency', models.CharField(default='', max_length=255, verbose_name='CPU Frequency')),
                ('min_cpu_frequency', models.CharField(default='', max_length=255, verbose_name='Min CPU Frequency')),
                ('max_cpu_frequency', models.CharField(default='', max_length=255, verbose_name='Max CPU Frequency')),
            ],
            options={
                'verbose_name': 'bomiot CPU',
                'verbose_name_plural': 'bomiot CPU',
                'db_table': 'bomiot_cpu',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Customer',
                'verbose_name_plural': 'bomiot Customer',
                'db_table': 'bomiot_customer',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('name', models.CharField(default='', max_length=255, verbose_name='Department Name')),
            ],
            options={
                'verbose_name': 'bomiot Department',
                'verbose_name_plural': 'bomiot Department',
                'db_table': 'bomiot_department',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Disk',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('device', models.CharField(default='', max_length=255, verbose_name='Device')),
                ('mountpoint', models.CharField(default='', max_length=255, verbose_name='Mountpoint')),
                ('total', models.BigIntegerField(default=0, verbose_name='Total')),
                ('used', models.BigIntegerField(default=0, verbose_name='Used')),
                ('free', models.BigIntegerField(default=0, verbose_name='Free')),
                ('percent', models.FloatField(default=0, verbose_name='Percent')),
            ],
            options={
                'verbose_name': 'bomiot Disk',
                'verbose_name_plural': 'bomiot Disk',
                'db_table': 'bomiot_disk',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='DN',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot DN',
                'verbose_name_plural': 'bomiot DN',
                'db_table': 'bomiot_dn',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Driver',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Driver',
                'verbose_name_plural': 'bomiot Driver',
                'db_table': 'bomiot_driver',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Example',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Example',
                'verbose_name_plural': 'bomiot Example',
                'db_table': 'bomiot_example',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Fee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Fee',
                'verbose_name_plural': 'bomiot Fee',
                'db_table': 'bomiot_fee',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Files',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('name', models.CharField(blank=True, default='', max_length=255, verbose_name='File Name')),
                ('type', models.CharField(blank=True, default='', max_length=255, verbose_name='Type')),
                ('size', models.BigIntegerField(blank=True, default=0, verbose_name='Size')),
                ('owner', models.CharField(blank=True, default='', max_length=255, verbose_name='Owner')),
                ('shared_to', models.CharField(blank=True, default='', max_length=255, verbose_name='Shared To')),
            ],
            options={
                'verbose_name': 'bomiot Files',
                'verbose_name_plural': 'bomiot Files',
                'db_table': 'bomiot_files',
                'ordering': ['-updated_time'],
            },
        ),
        migrations.CreateModel(
            name='Goods',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Goods',
                'verbose_name_plural': 'bomiot Goods',
                'db_table': 'bomiot_goods',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='JobList',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('job_id', models.CharField(max_length=255, verbose_name='Job ID')),
                ('module_name', models.CharField(max_length=255, verbose_name='Module Name')),
                ('func_name', models.CharField(max_length=255, verbose_name='Function Name')),
                ('trigger', models.CharField(max_length=255, verbose_name='Trigger')),
                ('description', models.TextField(blank=True, default='', null=True, verbose_name='Description')),
                ('configuration', models.TextField(null=True, verbose_name='Configuration')),
                ('type', models.BooleanField(default=True, verbose_name='Type')),
            ],
            options={
                'verbose_name': 'bomiot Job',
                'verbose_name_plural': 'bomiot Job',
                'db_table': 'bomiot_job',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Memory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('total', models.BigIntegerField(default=0, verbose_name='Total Memory')),
                ('used', models.BigIntegerField(default=0, verbose_name='Used Memory')),
                ('free', models.BigIntegerField(default=0, verbose_name='Free Memory')),
                ('percent', models.FloatField(default=0, verbose_name='Percent')),
                ('swap_total', models.BigIntegerField(default=0, verbose_name='Swap Total Memory')),
                ('swap_used', models.BigIntegerField(default=0, verbose_name='Swap Used Memory')),
                ('swap_free', models.BigIntegerField(default=0, verbose_name='Swap Free Memory')),
                ('swap_percent', models.FloatField(default=0, verbose_name='Swap Percent')),
            ],
            options={
                'verbose_name': 'bomiot Memory',
                'verbose_name_plural': 'bomiot Memory',
                'db_table': 'bomiot_memory',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('sender', models.CharField(blank=True, default='', max_length=255, verbose_name='Sender')),
                ('receiver', models.CharField(blank=True, default='', max_length=255, verbose_name='Receiver')),
                ('detail', models.CharField(default='', max_length=255, verbose_name='Detail')),
                ('can_send', models.BooleanField(default=False, verbose_name='Can Send')),
            ],
            options={
                'verbose_name': 'bomiot Message',
                'verbose_name_plural': 'bomiot Message',
                'db_table': 'bomiot_message',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Network',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('bytes_sent', models.BigIntegerField(default=0, verbose_name='Bytes Sent')),
                ('bytes_recv', models.BigIntegerField(default=0, verbose_name='Bytes Received')),
            ],
            options={
                'verbose_name': 'bomiot Network',
                'verbose_name_plural': 'bomiot Network',
                'db_table': 'bomiot_network',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Permission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('api', models.CharField(max_length=255, verbose_name='Permission API')),
                ('name', models.CharField(max_length=255, verbose_name='Permission Name')),
            ],
            options={
                'verbose_name': 'bomiot Permission',
                'verbose_name_plural': 'bomiot Permission',
                'db_table': 'bomiot_permission',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Pids',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('pid', models.IntegerField(default=0, verbose_name='PID')),
                ('name', models.CharField(blank=True, default='', max_length=255, verbose_name='PID Name')),
                ('memory', models.BigIntegerField(default=0, verbose_name='Memory')),
                ('create_time', models.DateTimeField(blank=True, verbose_name='Create Time')),
                ('memory_usage', models.FloatField(default=0, verbose_name='Memory Usage')),
                ('cpu_usage', models.FloatField(default=0, verbose_name='CPU Usage')),
            ],
            options={
                'verbose_name': 'bomiot Pids',
                'verbose_name_plural': 'bomiot Pids',
                'db_table': 'bomiot_pids',
                'ordering': ['-cpu_usage'],
            },
        ),
        migrations.CreateModel(
            name='Purchase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Purchase',
                'verbose_name_plural': 'bomiot Purchase',
                'db_table': 'bomiot_purchase',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='PyPi',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('category', models.CharField(max_length=255, verbose_name='Category')),
                ('date', models.DateTimeField(blank=True, verbose_name='PyPi Date')),
                ('percent', models.FloatField(default=0, verbose_name='Percent')),
                ('downloads', models.IntegerField(default=0, verbose_name='Downloads')),
            ],
            options={
                'verbose_name': 'bomiot PyPi',
                'verbose_name_plural': 'bomiot PyPi',
                'db_table': 'bomiot_pypi',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Stock',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Stock',
                'verbose_name_plural': 'bomiot Stock',
                'db_table': 'bomiot_stock',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('data', models.JSONField()),
            ],
            options={
                'verbose_name': 'bomiot Supplier',
                'verbose_name_plural': 'bomiot Supplier',
                'db_table': 'bomiot_supplier',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('name', models.CharField(default='', max_length=255, verbose_name='Team Name')),
                ('permission', models.JSONField(default=dict, null=True, verbose_name='Permission')),
            ],
            options={
                'verbose_name': 'bomiot Team',
                'verbose_name_plural': 'bomiot Team',
                'db_table': 'bomiot_team',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='ThrottleModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('ip', models.CharField(max_length=255, verbose_name='IP')),
                ('method', models.CharField(max_length=18, verbose_name='Method')),
            ],
            options={
                'verbose_name': 'bomiot Throttle',
                'verbose_name_plural': 'bomiot Throttle',
                'db_table': 'bomiot_throttle',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('is_delete', models.BooleanField(default=False, verbose_name='Delete Label')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='Created Time')),
                ('updated_time', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated Time')),
                ('type', models.IntegerField(default=1, verbose_name='User Type')),
                ('phone', models.CharField(blank=True, default='', max_length=255, verbose_name='Phone')),
                ('permission', models.JSONField(default=dict, null=True, verbose_name='Permission')),
                ('request_limit', models.IntegerField(default=0, verbose_name='Request Limit')),
                ('team', models.IntegerField(blank=True, default=0, verbose_name='Team')),
                ('department', models.IntegerField(blank=True, default=0, verbose_name='Department')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'bomiot User',
                'verbose_name_plural': 'bomiot User',
                'db_table': 'bomiot_user',
                'ordering': ['-id'],
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
    ]
