funcs = [('/app', 'get', 'apps/get-authenticated', 'Get the authenticated app', 'v3/apps/#get-the-authenticated-app', [], [], ''),
 ('/app-manifests/{code}/conversions', 'post', 'apps/create-from-manifest', 'Create a GitHub App from a manifest', 'v3/apps/#create-a-github-app-from-a-manifest', [], [], ''),
 ('/app/hook/config', 'get', 'apps/get-webhook-config-for-app', 'Get a webhook configuration for an app', 'v3/apps#get-a-webhook-configuration-for-an-app', [], [], ''),
 ('/app/hook/config', 'patch', 'apps/update-webhook-config-for-app', 'Update a webhook configuration for an app', 'v3/apps#update-a-webhook-configuration-for-an-app', [], [['url', str], ['content_type', str], ['secret', str], ['insecure_ssl', str]], ''),
 ('/app/installations', 'get', 'apps/list-installations', 'List installations for the authenticated app', 'v3/apps/#list-installations-for-the-authenticated-app', ['per_page', 'page', 'since', 'outdated'], [], ''),
 ('/app/installations/{installation_id}', 'get', 'apps/get-installation', 'Get an installation for the authenticated app', 'v3/apps/#get-an-installation-for-the-authenticated-app', [], [], ''),
 ('/app/installations/{installation_id}', 'delete', 'apps/delete-installation', 'Delete an installation for the authenticated app', 'v3/apps/#delete-an-installation-for-the-authenticated-app', [], [], ''),
 ('/app/installations/{installation_id}/access_tokens', 'post', 'apps/create-installation-access-token', 'Create an installation access token for an app', 'v3/apps/#create-an-installation-access-token-for-an-app', [], [['repositories', list], ['repository_ids', list], ['permissions', dict]], ''),
 ('/app/installations/{installation_id}/suspended', 'put', 'apps/suspend-installation', 'Suspend an app installation', 'v3/apps/#suspend-an-app-installation', [], [], ''),
 ('/app/installations/{installation_id}/suspended', 'delete', 'apps/unsuspend-installation', 'Unsuspend an app installation', 'v3/apps/#unsuspend-an-app-installation', [], [], ''),
 ('/applications/grants', 'get', 'oauth-authorizations/list-grants', 'List your grants', 'rest/reference/oauth-authorizations#list-your-grants', ['per_page', 'page'], [], ''),
 ('/applications/grants/{grant_id}', 'get', 'oauth-authorizations/get-grant', 'Get a single grant', 'rest/reference/oauth-authorizations#get-a-single-grant', [], [], ''),
 ('/applications/grants/{grant_id}', 'delete', 'oauth-authorizations/delete-grant', 'Delete a grant', 'rest/reference/oauth-authorizations#delete-a-grant', [], [], ''),
 ('/applications/{client_id}/grant', 'delete', 'apps/delete-authorization', 'Delete an app authorization', 'rest/reference/apps#delete-an-app-authorization', [], [['access_token', str]], ''),
 ('/applications/{client_id}/grants/{access_token}', 'delete', 'apps/revoke-grant-for-application', 'Revoke a grant for an application', 'rest/reference/apps#revoke-a-grant-for-an-application', [], [], ''),
 ('/applications/{client_id}/token', 'post', 'apps/check-token', 'Check a token', 'rest/reference/apps#check-a-token', [], [['access_token', str]], ''),
 ('/applications/{client_id}/token', 'patch', 'apps/reset-token', 'Reset a token', 'rest/reference/apps#reset-a-token', [], [['access_token', str]], ''),
 ('/applications/{client_id}/token', 'delete', 'apps/delete-token', 'Delete an app token', 'rest/reference/apps#delete-an-app-token', [], [['access_token', str]], ''),
 ('/applications/{client_id}/tokens/{access_token}', 'get', 'apps/check-authorization', 'Check an authorization', 'rest/reference/apps#check-an-authorization', [], [], ''),
 ('/applications/{client_id}/tokens/{access_token}', 'post', 'apps/reset-authorization', 'Reset an authorization', 'rest/reference/apps#reset-an-authorization', [], [], ''),
 ('/applications/{client_id}/tokens/{access_token}', 'delete', 'apps/revoke-authorization-for-application', 'Revoke an authorization for an application', 'rest/reference/apps#revoke-an-authorization-for-an-application', [], [], ''),
 ('/apps/{app_slug}', 'get', 'apps/get-by-slug', 'Get an app', 'v3/apps/#get-an-app', [], [], ''),
 ('/authorizations', 'get', 'oauth-authorizations/list-authorizations', 'List your authorizations', 'rest/reference/oauth-authorizations#list-your-authorizations', ['per_page', 'page'], [], ''),
 ('/authorizations', 'post', 'oauth-authorizations/create-authorization', 'Create a new authorization', 'rest/reference/oauth-authorizations#create-a-new-authorization', [], [['scopes', list], ['note', str], ['note_url', str], ['client_id', str], ['client_secret', str], ['fingerprint', str]], ''),
 ('/authorizations/clients/{client_id}', 'put', 'oauth-authorizations/get-or-create-authorization-for-app', 'Get-or-create an authorization for a specific app', 'rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app', [], [['client_secret', str], ['scopes', list], ['note', str], ['note_url', str], ['fingerprint', str]], ''),
 ('/authorizations/clients/{client_id}/{fingerprint}',
  'put',
  'oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint',
  'Get-or-create an authorization for a specific app and fingerprint',
  'rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app-and-fingerprint',
  [],
  [['client_secret', str], ['scopes', list], ['note', str], ['note_url', str]],
  ''),
 ('/authorizations/{authorization_id}', 'get', 'oauth-authorizations/get-authorization', 'Get a single authorization', 'rest/reference/oauth-authorizations#get-a-single-authorization', [], [], ''),
 ('/authorizations/{authorization_id}', 'patch', 'oauth-authorizations/update-authorization', 'Update an existing authorization', 'rest/reference/oauth-authorizations#update-an-existing-authorization', [], [['scopes', list], ['add_scopes', list], ['remove_scopes', list], ['note', str], ['note_url', str], ['fingerprint', str]], ''),
 ('/authorizations/{authorization_id}', 'delete', 'oauth-authorizations/delete-authorization', 'Delete an authorization', 'rest/reference/oauth-authorizations#delete-an-authorization', [], [], ''),
 ('/codes_of_conduct', 'get', 'codes-of-conduct/get-all-codes-of-conduct', 'Get all codes of conduct', 'v3/codes_of_conduct/#get-all-codes-of-conduct', [], [], 'scarlet-witch'),
 ('/codes_of_conduct/{key}', 'get', 'codes-of-conduct/get-conduct-code', 'Get a code of conduct', 'v3/codes_of_conduct/#get-a-code-of-conduct', [], [], 'scarlet-witch'),
 ('/content_references/{content_reference_id}/attachments', 'post', 'apps/create-content-attachment', 'Create a content attachment', 'rest/reference/apps#create-a-content-attachment', [], [['title', str], ['body', str]], 'corsair'),
 ('/emojis', 'get', 'emojis/get', 'Get emojis', 'v3/emojis/#get-emojis', [], [], ''),
 ('/enterprises/{enterprise}/actions/permissions', 'get', 'enterprise-admin/get-github-actions-permissions-enterprise', 'Get GitHub Actions permissions for an enterprise', 'rest/reference/enterprise-admin#get-github-actions-permissions-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/permissions', 'put', 'enterprise-admin/set-github-actions-permissions-enterprise', 'Set GitHub Actions permissions for an enterprise', 'rest/reference/enterprise-admin#set-github-actions-permissions-for-an-enterprise', [], [['enabled_organizations', str], ['allowed_actions', str]], ''),
 ('/enterprises/{enterprise}/actions/permissions/organizations',
  'get',
  'enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise',
  'List selected organizations enabled for GitHub Actions in an enterprise',
  'rest/reference/enterprise-admin#list-selected-organizations-enabled-for-github-actions-in-an-enterprise',
  ['per_page', 'page'],
  [],
  ''),
 ('/enterprises/{enterprise}/actions/permissions/organizations',
  'put',
  'enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise',
  'Set selected organizations enabled for GitHub Actions in an enterprise',
  'rest/reference/enterprise-admin#set-selected-organizations-enabled-for-github-actions-in-an-enterprise',
  [],
  [['selected_organization_ids', list]],
  ''),
 ('/enterprises/{enterprise}/actions/permissions/organizations/{org_id}', 'put', 'enterprise-admin/enable-selected-organization-github-actions-enterprise', 'Enable a selected organization for GitHub Actions in an enterprise', 'rest/reference/enterprise-admin#enable-a-selected-organization-for-github-actions-in-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/permissions/organizations/{org_id}', 'delete', 'enterprise-admin/disable-selected-organization-github-actions-enterprise', 'Disable a selected organization for GitHub Actions in an enterprise', 'rest/reference/enterprise-admin#disable-a-selected-organization-for-github-actions-in-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/permissions/selected-actions', 'get', 'enterprise-admin/get-allowed-actions-enterprise', 'Get allowed actions for an enterprise', 'rest/reference/enterprise-admin#get-allowed-actions-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/permissions/selected-actions', 'put', 'enterprise-admin/set-allowed-actions-enterprise', 'Set allowed actions for an enterprise', 'rest/reference/enterprise-admin#set-allowed-actions-for-an-enterprise', [], [['github_owned_allowed', bool], ['verified_allowed', bool], ['patterns_allowed', list]], ''),
 ('/enterprises/{enterprise}/actions/runner-groups', 'get', 'enterprise-admin/list-self-hosted-runner-groups-for-enterprise', 'List self-hosted runner groups for an enterprise', 'rest/reference/enterprise-admin#list-self-hosted-runner-groups-for-an-enterprise', ['per_page', 'page'], [], ''),
 ('/enterprises/{enterprise}/actions/runner-groups',
  'post',
  'enterprise-admin/create-self-hosted-runner-group-for-enterprise',
  'Create a self-hosted runner group for an enterprise',
  'rest/reference/enterprise-admin#create-self-hosted-runner-group-for-an-enterprise',
  [],
  [['name', str], ['visibility', str], ['selected_organization_ids', list], ['runners', list]],
  ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}', 'get', 'enterprise-admin/get-self-hosted-runner-group-for-enterprise', 'Get a self-hosted runner group for an enterprise', 'rest/reference/enterprise-admin#get-a-self-hosted-runner-group-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}', 'patch', 'enterprise-admin/update-self-hosted-runner-group-for-enterprise', 'Update a self-hosted runner group for an enterprise', 'rest/reference/enterprise-admin#update-a-self-hosted-runner-group-for-an-enterprise', [], [['name', str], ['visibility', str, 'all']], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}', 'delete', 'enterprise-admin/delete-self-hosted-runner-group-from-enterprise', 'Delete a self-hosted runner group from an enterprise', 'rest/reference/enterprise-admin#delete-a-self-hosted-runner-group-from-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations',
  'get',
  'enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise',
  'List organization access to a self-hosted runner group in an enterprise',
  'rest/reference/enterprise-admin#list-organization-access-to-a-self-hosted-runner-group-in-a-enterprise',
  ['per_page', 'page'],
  [],
  ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations',
  'put',
  'enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise',
  'Set organization access for a self-hosted runner group in an enterprise',
  'rest/reference/enterprise-admin#set-organization-access-to-a-self-hosted-runner-group-in-an-enterprise',
  [],
  [['selected_organization_ids', list]],
  ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}',
  'put',
  'enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise',
  'Add organization access to a self-hosted runner group in an enterprise',
  'rest/reference/enterprise-admin#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise',
  [],
  [],
  ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}',
  'delete',
  'enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise',
  'Remove organization access to a self-hosted runner group in an enterprise',
  'rest/reference/enterprise-admin#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise',
  [],
  [],
  ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners', 'get', 'enterprise-admin/list-self-hosted-runners-in-group-for-enterprise', 'List self-hosted runners in a group for an enterprise', 'rest/reference/enterprise-admin#list-self-hosted-runners-in-a-group-for-an-enterprise', ['per_page', 'page'], [], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners', 'put', 'enterprise-admin/set-self-hosted-runners-in-group-for-enterprise', 'Set self-hosted runners in a group for an enterprise', 'rest/reference/enterprise-admin#set-self-hosted-runners-in-a-group-for-an-enterprise', [], [['runners', list]], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}', 'put', 'enterprise-admin/add-self-hosted-runner-to-group-for-enterprise', 'Add a self-hosted runner to a group for an enterprise', 'rest/reference/enterprise-admin#add-a-self-hosted-runner-to-a-group-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}', 'delete', 'enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise', 'Remove a self-hosted runner from a group for an enterprise', 'rest/reference/enterprise-admin#remove-a-self-hosted-runner-from-a-group-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runners', 'get', 'enterprise-admin/list-self-hosted-runners-for-enterprise', 'List self-hosted runners for an enterprise', 'rest/reference/enterprise-admin#list-self-hosted-runners-for-an-enterprise', ['per_page', 'page'], [], ''),
 ('/enterprises/{enterprise}/actions/runners/downloads', 'get', 'enterprise-admin/list-runner-applications-for-enterprise', 'List runner applications for an enterprise', 'rest/reference/enterprise-admin#list-runner-applications-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runners/registration-token', 'post', 'enterprise-admin/create-registration-token-for-enterprise', 'Create a registration token for an enterprise', 'rest/reference/enterprise-admin#create-a-registration-token-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runners/remove-token', 'post', 'enterprise-admin/create-remove-token-for-enterprise', 'Create a remove token for an enterprise', 'rest/reference/enterprise-admin#create-a-remove-token-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runners/{runner_id}', 'get', 'enterprise-admin/get-self-hosted-runner-for-enterprise', 'Get a self-hosted runner for an enterprise', 'rest/reference/enterprise-admin#get-a-self-hosted-runner-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/actions/runners/{runner_id}', 'delete', 'enterprise-admin/delete-self-hosted-runner-from-enterprise', 'Delete a self-hosted runner from an enterprise', 'rest/reference/enterprise-admin#delete-self-hosted-runner-from-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/settings/billing/actions', 'get', 'billing/get-github-actions-billing-ghe', 'Get GitHub Actions billing for an enterprise', 'v3/billing/#get-github-actions-billing-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/settings/billing/packages', 'get', 'billing/get-github-packages-billing-ghe', 'Get GitHub Packages billing for an enterprise', 'v3/billing/#get-github-packages-billing-for-an-enterprise', [], [], ''),
 ('/enterprises/{enterprise}/settings/billing/shared-storage', 'get', 'billing/get-shared-storage-billing-ghe', 'Get shared storage billing for an enterprise', 'v3/billing/#get-shared-storage-billing-for-an-enterprise', [], [], ''),
 ('/events', 'get', 'activity/list-public-events', 'List public events', 'rest/reference/activity#list-public-events', ['per_page', 'page'], [], ''),
 ('/feeds', 'get', 'activity/get-feeds', 'Get feeds', 'rest/reference/activity#get-feeds', [], [], ''),
 ('/gists', 'get', 'gists/list', 'List gists for the authenticated user', 'v3/gists/#list-gists-for-the-authenticated-user', ['since', 'per_page', 'page'], [], ''),
 ('/gists', 'post', 'gists/create', 'Create a gist', 'v3/gists/#create-a-gist', [], [['description', str], ['files', dict], ['public', object]], ''),
 ('/gists/public', 'get', 'gists/list-public', 'List public gists', 'v3/gists/#list-public-gists', ['since', 'per_page', 'page'], [], ''),
 ('/gists/starred', 'get', 'gists/list-starred', 'List starred gists', 'v3/gists/#list-starred-gists', ['since', 'per_page', 'page'], [], ''),
 ('/gists/{gist_id}', 'get', 'gists/get', 'Get a gist', 'v3/gists/#get-a-gist', [], [], ''),
 ('/gists/{gist_id}', 'patch', 'gists/update', 'Update a gist', 'v3/gists/#update-a-gist', [], [['description', str], ['files', dict]], ''),
 ('/gists/{gist_id}', 'delete', 'gists/delete', 'Delete a gist', 'v3/gists/#delete-a-gist', [], [], ''),
 ('/gists/{gist_id}/comments', 'get', 'gists/list-comments', 'List gist comments', 'rest/reference/gists#list-gist-comments', ['per_page', 'page'], [], ''),
 ('/gists/{gist_id}/comments', 'post', 'gists/create-comment', 'Create a gist comment', 'rest/reference/gists#create-a-gist-comment', [], [['body', str]], ''),
 ('/gists/{gist_id}/comments/{comment_id}', 'get', 'gists/get-comment', 'Get a gist comment', 'rest/reference/gists#get-a-gist-comment', [], [], ''),
 ('/gists/{gist_id}/comments/{comment_id}', 'patch', 'gists/update-comment', 'Update a gist comment', 'rest/reference/gists#update-a-gist-comment', [], [['body', str]], ''),
 ('/gists/{gist_id}/comments/{comment_id}', 'delete', 'gists/delete-comment', 'Delete a gist comment', 'rest/reference/gists#delete-a-gist-comment', [], [], ''),
 ('/gists/{gist_id}/commits', 'get', 'gists/list-commits', 'List gist commits', 'v3/gists/#list-gist-commits', ['per_page', 'page'], [], ''),
 ('/gists/{gist_id}/forks', 'get', 'gists/list-forks', 'List gist forks', 'v3/gists/#list-gist-forks', ['per_page', 'page'], [], ''),
 ('/gists/{gist_id}/forks', 'post', 'gists/fork', 'Fork a gist', 'v3/gists/#fork-a-gist', [], [], ''),
 ('/gists/{gist_id}/star', 'get', 'gists/check-is-starred', 'Check if a gist is starred', 'v3/gists/#check-if-a-gist-is-starred', [], [], ''),
 ('/gists/{gist_id}/star', 'put', 'gists/star', 'Star a gist', 'v3/gists/#star-a-gist', [], [], ''),
 ('/gists/{gist_id}/star', 'delete', 'gists/unstar', 'Unstar a gist', 'v3/gists/#unstar-a-gist', [], [], ''),
 ('/gists/{gist_id}/{sha}', 'get', 'gists/get-revision', 'Get a gist revision', 'v3/gists/#get-a-gist-revision', [], [], ''),
 ('/gitignore/templates', 'get', 'gitignore/get-all-templates', 'Get all gitignore templates', 'v3/gitignore/#get-all-gitignore-templates', [], [], ''),
 ('/gitignore/templates/{name}', 'get', 'gitignore/get-template', 'Get a gitignore template', 'v3/gitignore/#get-a-gitignore-template', [], [], ''),
 ('/installation/repositories', 'get', 'apps/list-repos-accessible-to-installation', 'List repositories accessible to the app installation', 'rest/reference/apps#list-repositories-accessible-to-the-app-installation', ['per_page', 'page'], [], 'mercy'),
 ('/installation/token', 'delete', 'apps/revoke-installation-access-token', 'Revoke an installation access token', 'rest/reference/apps#revoke-an-installation-access-token', [], [], ''),
 ('/issues', 'get', 'issues/list', 'List issues assigned to the authenticated user', 'v3/issues/#list-issues-assigned-to-the-authenticated-user', ['filter', 'state', 'labels', 'sort', 'direction', 'since', 'collab', 'orgs', 'owned', 'pulls', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/licenses', 'get', 'licenses/get-all-commonly-used', 'Get all commonly used licenses', 'v3/licenses/#get-all-commonly-used-licenses', ['featured', 'per_page'], [], ''),
 ('/licenses/{license}', 'get', 'licenses/get', 'Get a license', 'v3/licenses/#get-a-license', [], [], ''),
 ('/markdown', 'post', 'markdown/render', 'Render a Markdown document', 'v3/markdown/#render-a-markdown-document', [], [['text', str], ['mode', str, 'markdown'], ['context', str]], ''),
 ('/markdown/raw', 'post', 'markdown/render-raw', 'Render a Markdown document in raw mode', 'v3/markdown/#render-a-markdown-document-in-raw-mode', [], [], ''),
 ('/marketplace_listing/accounts/{account_id}', 'get', 'apps/get-subscription-plan-for-account', 'Get a subscription plan for an account', 'rest/reference/apps#get-a-subscription-plan-for-an-account', [], [], ''),
 ('/marketplace_listing/plans', 'get', 'apps/list-plans', 'List plans', 'rest/reference/apps#list-plans', ['per_page', 'page'], [], ''),
 ('/marketplace_listing/plans/{plan_id}/accounts', 'get', 'apps/list-accounts-for-plan', 'List accounts for a plan', 'rest/reference/apps#list-accounts-for-a-plan', ['sort', 'direction', 'per_page', 'page'], [], ''),
 ('/marketplace_listing/stubbed/accounts/{account_id}', 'get', 'apps/get-subscription-plan-for-account-stubbed', 'Get a subscription plan for an account (stubbed)', 'rest/reference/apps#get-a-subscription-plan-for-an-account-stubbed', [], [], ''),
 ('/marketplace_listing/stubbed/plans', 'get', 'apps/list-plans-stubbed', 'List plans (stubbed)', 'rest/reference/apps#list-plans-stubbed', ['per_page', 'page'], [], ''),
 ('/marketplace_listing/stubbed/plans/{plan_id}/accounts', 'get', 'apps/list-accounts-for-plan-stubbed', 'List accounts for a plan (stubbed)', 'rest/reference/apps#list-accounts-for-a-plan-stubbed', ['sort', 'direction', 'per_page', 'page'], [], ''),
 ('/meta', 'get', 'meta/get', 'Get GitHub meta information', 'v3/meta/#get-github-meta-information', [], [], ''),
 ('/networks/{owner}/{repo}/events', 'get', 'activity/list-public-events-for-repo-network', 'List public events for a network of repositories', 'rest/reference/activity#list-public-events-for-a-network-of-repositories', ['per_page', 'page'], [], ''),
 ('/notifications', 'get', 'activity/list-notifications-for-authenticated-user', 'List notifications for the authenticated user', 'rest/reference/activity#list-notifications-for-the-authenticated-user', ['all', 'participating', 'since', 'before', 'per_page', 'page'], [], ''),
 ('/notifications', 'put', 'activity/mark-notifications-as-read', 'Mark notifications as read', 'rest/reference/activity#mark-notifications-as-read', [], [['last_read_at', str], ['read', bool]], ''),
 ('/notifications/threads/{thread_id}', 'get', 'activity/get-thread', 'Get a thread', 'rest/reference/activity#get-a-thread', [], [], ''),
 ('/notifications/threads/{thread_id}', 'patch', 'activity/mark-thread-as-read', 'Mark a thread as read', 'rest/reference/activity#mark-a-thread-as-read', [], [], ''),
 ('/notifications/threads/{thread_id}/subscription', 'get', 'activity/get-thread-subscription-for-authenticated-user', 'Get a thread subscription for the authenticated user', 'rest/reference/activity#get-a-thread-subscription-for-the-authenticated-user', [], [], ''),
 ('/notifications/threads/{thread_id}/subscription', 'put', 'activity/set-thread-subscription', 'Set a thread subscription', 'rest/reference/activity#set-a-thread-subscription', [], [['ignored', bool, False]], ''),
 ('/notifications/threads/{thread_id}/subscription', 'delete', 'activity/delete-thread-subscription', 'Delete a thread subscription', 'rest/reference/activity#delete-a-thread-subscription', [], [], ''),
 ('/organizations', 'get', 'orgs/list', 'List organizations', 'v3/orgs/#list-organizations', ['since', 'per_page'], [], ''),
 ('/orgs/{org}', 'get', 'orgs/get', 'Get an organization', 'v3/orgs/#get-an-organization', [], [], 'surtur'),
 ('/orgs/{org}',
  'patch',
  'orgs/update',
  'Update an organization',
  'v3/orgs/#update-an-organization',
  [],
  [['billing_email', str],
   ['company', str],
   ['email', str],
   ['twitter_username', str],
   ['location', str],
   ['name', str],
   ['description', str],
   ['has_organization_projects', bool],
   ['has_repository_projects', bool],
   ['default_repository_permission', str, 'read'],
   ['members_can_create_repositories', bool, True],
   ['members_can_create_internal_repositories', bool],
   ['members_can_create_private_repositories', bool],
   ['members_can_create_public_repositories', bool],
   ['members_allowed_repository_creation_type', str],
   ['members_can_create_pages', bool],
   ['blog', str]],
  'surtur'),
 ('/orgs/{org}/actions/permissions', 'get', 'actions/get-github-actions-permissions-organization', 'Get GitHub Actions permissions for an organization', 'rest/reference/actions#get-github-actions-permissions-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/permissions', 'put', 'actions/set-github-actions-permissions-organization', 'Set GitHub Actions permissions for an organization', 'rest/reference/actions#set-github-actions-permissions-for-an-organization', [], [['enabled_repositories', str], ['allowed_actions', str]], ''),
 ('/orgs/{org}/actions/permissions/repositories', 'get', 'actions/list-selected-repositories-enabled-github-actions-organization', 'List selected repositories enabled for GitHub Actions in an organization', 'rest/reference/actions#list-selected-repositories-enabled-for-github-actions-in-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/actions/permissions/repositories', 'put', 'actions/set-selected-repositories-enabled-github-actions-organization', 'Set selected repositories enabled for GitHub Actions in an organization', 'rest/reference/actions#set-selected-repositories-enabled-for-github-actions-in-an-organization', [], [['selected_repository_ids', list]], ''),
 ('/orgs/{org}/actions/permissions/repositories/{repository_id}', 'put', 'actions/enable-selected-repository-github-actions-organization', 'Enable a selected repository for GitHub Actions in an organization', 'rest/reference/actions#enable-a-selected-repository-for-github-actions-in-an-organization', [], [], ''),
 ('/orgs/{org}/actions/permissions/repositories/{repository_id}', 'delete', 'actions/disable-selected-repository-github-actions-organization', 'Disable a selected repository for GitHub Actions in an organization', 'rest/reference/actions#disable-a-selected-repository-for-github-actions-in-an-organization', [], [], ''),
 ('/orgs/{org}/actions/permissions/selected-actions', 'get', 'actions/get-allowed-actions-organization', 'Get allowed actions for an organization', 'rest/reference/actions#get-allowed-actions-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/permissions/selected-actions', 'put', 'actions/set-allowed-actions-organization', 'Set allowed actions for an organization', 'rest/reference/actions#set-allowed-actions-for-an-organization', [], [['github_owned_allowed', bool], ['verified_allowed', bool], ['patterns_allowed', list]], ''),
 ('/orgs/{org}/actions/runner-groups', 'get', 'actions/list-self-hosted-runner-groups-for-org', 'List self-hosted runner groups for an organization', 'rest/reference/actions#list-self-hosted-runner-groups-for-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/actions/runner-groups', 'post', 'actions/create-self-hosted-runner-group-for-org', 'Create a self-hosted runner group for an organization', 'rest/reference/actions#create-a-self-hosted-runner-group-for-an-organization', [], [['name', str], ['visibility', str, 'all'], ['selected_repository_ids', list], ['runners', list]], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}', 'get', 'actions/get-self-hosted-runner-group-for-org', 'Get a self-hosted runner group for an organization', 'rest/reference/actions#get-a-self-hosted-runner-group-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}', 'patch', 'actions/update-self-hosted-runner-group-for-org', 'Update a self-hosted runner group for an organization', 'rest/reference/actions#update-a-self-hosted-runner-group-for-an-organization', [], [['name', str], ['visibility', str]], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}', 'delete', 'actions/delete-self-hosted-runner-group-from-org', 'Delete a self-hosted runner group from an organization', 'rest/reference/actions#delete-a-self-hosted-runner-group-from-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories', 'get', 'actions/list-repo-access-to-self-hosted-runner-group-in-org', 'List repository access to a self-hosted runner group in an organization', 'rest/reference/actions#list-repository-access-to-a-self-hosted-runner-group-in-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories', 'put', 'actions/set-repo-access-to-self-hosted-runner-group-in-org', 'Set repository access for a self-hosted runner group in an organization', 'rest/reference/actions#set-repository-access-to-a-self-hosted-runner-group-in-an-organization', [], [['selected_repository_ids', list]], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}', 'put', 'actions/add-repo-access-to-self-hosted-runner-group-in-org', 'Add repository access to a self-hosted runner group in an organization', 'rest/reference/actions#add-repository-acess-to-a-self-hosted-runner-group-in-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}', 'delete', 'actions/remove-repo-access-to-self-hosted-runner-group-in-org', 'Remove repository access to a self-hosted runner group in an organization', 'rest/reference/actions#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/runners', 'get', 'actions/list-self-hosted-runners-in-group-for-org', 'List self-hosted runners in a group for an organization', 'rest/reference/actions#list-self-hosted-runners-in-a-group-for-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/runners', 'put', 'actions/set-self-hosted-runners-in-group-for-org', 'Set self-hosted runners in a group for an organization', 'rest/reference/actions#set-self-hosted-runners-in-a-group-for-an-organization', [], [['runners', list]], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}', 'put', 'actions/add-self-hosted-runner-to-group-for-org', 'Add a self-hosted runner to a group for an organization', 'rest/reference/actions#add-a-self-hosted-runner-to-a-group-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}', 'delete', 'actions/remove-self-hosted-runner-from-group-for-org', 'Remove a self-hosted runner from a group for an organization', 'rest/reference/actions#remove-a-self-hosted-runner-from-a-group-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runners', 'get', 'actions/list-self-hosted-runners-for-org', 'List self-hosted runners for an organization', 'rest/reference/actions#list-self-hosted-runners-for-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/actions/runners/downloads', 'get', 'actions/list-runner-applications-for-org', 'List runner applications for an organization', 'rest/reference/actions#list-runner-applications-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runners/registration-token', 'post', 'actions/create-registration-token-for-org', 'Create a registration token for an organization', 'rest/reference/actions#create-a-registration-token-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runners/remove-token', 'post', 'actions/create-remove-token-for-org', 'Create a remove token for an organization', 'rest/reference/actions#create-a-remove-token-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runners/{runner_id}', 'get', 'actions/get-self-hosted-runner-for-org', 'Get a self-hosted runner for an organization', 'rest/reference/actions#get-a-self-hosted-runner-for-an-organization', [], [], ''),
 ('/orgs/{org}/actions/runners/{runner_id}', 'delete', 'actions/delete-self-hosted-runner-from-org', 'Delete a self-hosted runner from an organization', 'rest/reference/actions#delete-a-self-hosted-runner-from-an-organization', [], [], ''),
 ('/orgs/{org}/actions/secrets', 'get', 'actions/list-org-secrets', 'List organization secrets', 'rest/reference/actions#list-organization-secrets', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/actions/secrets/public-key', 'get', 'actions/get-org-public-key', 'Get an organization public key', 'rest/reference/actions#get-an-organization-public-key', [], [], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}', 'get', 'actions/get-org-secret', 'Get an organization secret', 'rest/reference/actions#get-an-organization-secret', [], [], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}', 'put', 'actions/create-or-update-org-secret', 'Create or update an organization secret', 'rest/reference/actions#create-or-update-an-organization-secret', [], [['encrypted_value', str], ['key_id', str], ['visibility', str], ['selected_repository_ids', list]], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}', 'delete', 'actions/delete-org-secret', 'Delete an organization secret', 'rest/reference/actions#delete-an-organization-secret', [], [], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}/repositories', 'get', 'actions/list-selected-repos-for-org-secret', 'List selected repositories for an organization secret', 'rest/reference/actions#list-selected-repositories-for-an-organization-secret', [], [], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}/repositories', 'put', 'actions/set-selected-repos-for-org-secret', 'Set selected repositories for an organization secret', 'rest/reference/actions#set-selected-repositories-for-an-organization-secret', [], [['selected_repository_ids', list]], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}', 'put', 'actions/add-selected-repo-to-org-secret', 'Add selected repository to an organization secret', 'rest/reference/actions#add-selected-repository-to-an-organization-secret', [], [], ''),
 ('/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}', 'delete', 'actions/remove-selected-repo-from-org-secret', 'Remove selected repository from an organization secret', 'rest/reference/actions#remove-selected-repository-from-an-organization-secret', [], [], ''),
 ('/orgs/{org}/blocks', 'get', 'orgs/list-blocked-users', 'List users blocked by an organization', 'rest/reference/orgs#list-users-blocked-by-an-organization', [], [], ''),
 ('/orgs/{org}/blocks/{username}', 'get', 'orgs/check-blocked-user', 'Check if a user is blocked by an organization', 'rest/reference/orgs#check-if-a-user-is-blocked-by-an-organization', [], [], ''),
 ('/orgs/{org}/blocks/{username}', 'put', 'orgs/block-user', 'Block a user from an organization', 'rest/reference/orgs#block-a-user-from-an-organization', [], [], ''),
 ('/orgs/{org}/blocks/{username}', 'delete', 'orgs/unblock-user', 'Unblock a user from an organization', 'rest/reference/orgs#unblock-a-user-from-an-organization', [], [], ''),
 ('/orgs/{org}/credential-authorizations', 'get', 'orgs/list-saml-sso-authorizations', 'List SAML SSO authorizations for an organization', 'v3/orgs/#list-saml-sso-authorizations-for-an-organization', [], [], ''),
 ('/orgs/{org}/credential-authorizations/{credential_id}', 'delete', 'orgs/remove-saml-sso-authorization', 'Remove a SAML SSO authorization for an organization', 'v3/orgs/#remove-a-saml-sso-authorization-for-an-organization', [], [], ''),
 ('/orgs/{org}/events', 'get', 'activity/list-public-org-events', 'List public organization events', 'rest/reference/activity#list-public-organization-events', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/hooks', 'get', 'orgs/list-webhooks', 'List organization webhooks', 'rest/reference/orgs#list-organization-webhooks', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/hooks', 'post', 'orgs/create-webhook', 'Create an organization webhook', 'rest/reference/orgs#create-an-organization-webhook', [], [['name', str], ['config', dict], ['events', list, ['push']], ['active', bool, True]], ''),
 ('/orgs/{org}/hooks/{hook_id}', 'get', 'orgs/get-webhook', 'Get an organization webhook', 'rest/reference/orgs#get-an-organization-webhook', [], [], ''),
 ('/orgs/{org}/hooks/{hook_id}', 'patch', 'orgs/update-webhook', 'Update an organization webhook', 'rest/reference/orgs#update-an-organization-webhook', [], [['config', dict], ['events', list, ['push']], ['active', bool, True], ['name', str]], ''),
 ('/orgs/{org}/hooks/{hook_id}', 'delete', 'orgs/delete-webhook', 'Delete an organization webhook', 'rest/reference/orgs#delete-an-organization-webhook', [], [], ''),
 ('/orgs/{org}/hooks/{hook_id}/config', 'get', 'orgs/get-webhook-config-for-org', 'Get a webhook configuration for an organization', 'v3/orgs#get-a-webhook-configuration-for-an-organization', [], [], ''),
 ('/orgs/{org}/hooks/{hook_id}/config', 'patch', 'orgs/update-webhook-config-for-org', 'Update a webhook configuration for an organization', 'v3/orgs#update-a-webhook-configuration-for-an-organization', [], [['url', str], ['content_type', str], ['secret', str], ['insecure_ssl', str]], ''),
 ('/orgs/{org}/hooks/{hook_id}/pings', 'post', 'orgs/ping-webhook', 'Ping an organization webhook', 'rest/reference/orgs#ping-an-organization-webhook', [], [], ''),
 ('/orgs/{org}/installation', 'get', 'apps/get-org-installation', 'Get an organization installation for the authenticated app', 'v3/apps/#get-an-organization-installation-for-the-authenticated-app', [], [], ''),
 ('/orgs/{org}/installations', 'get', 'orgs/list-app-installations', 'List app installations for an organization', 'v3/orgs/#list-app-installations-for-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/interaction-limits', 'get', 'interactions/get-restrictions-for-org', 'Get interaction restrictions for an organization', 'rest/reference/interactions#get-interaction-restrictions-for-an-organization', [], [], ''),
 ('/orgs/{org}/interaction-limits', 'put', 'interactions/set-restrictions-for-org', 'Set interaction restrictions for an organization', 'rest/reference/interactions#set-interaction-restrictions-for-an-organization', [], [['limit', str], ['expiry', str]], ''),
 ('/orgs/{org}/interaction-limits', 'delete', 'interactions/remove-restrictions-for-org', 'Remove interaction restrictions for an organization', 'rest/reference/interactions#remove-interaction-restrictions-for-an-organization', [], [], ''),
 ('/orgs/{org}/invitations', 'get', 'orgs/list-pending-invitations', 'List pending organization invitations', 'rest/reference/orgs#list-pending-organization-invitations', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/invitations', 'post', 'orgs/create-invitation', 'Create an organization invitation', 'rest/reference/orgs#create-an-organization-invitation', [], [['invitee_id', int], ['email', str], ['role', str, 'direct_member'], ['team_ids', list]], ''),
 ('/orgs/{org}/invitations/{invitation_id}/teams', 'get', 'orgs/list-invitation-teams', 'List organization invitation teams', 'rest/reference/orgs#list-organization-invitation-teams', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/issues', 'get', 'issues/list-for-org', 'List organization issues assigned to the authenticated user', 'v3/issues/#list-organization-issues-assigned-to-the-authenticated-user', ['filter', 'state', 'labels', 'sort', 'direction', 'since', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/orgs/{org}/members', 'get', 'orgs/list-members', 'List organization members', 'rest/reference/orgs#list-organization-members', ['filter', 'role', 'per_page', 'page'], [], ''),
 ('/orgs/{org}/members/{username}', 'get', 'orgs/check-membership-for-user', 'Check organization membership for a user', 'rest/reference/orgs#check-organization-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/members/{username}', 'delete', 'orgs/remove-member', 'Remove an organization member', 'rest/reference/orgs#remove-an-organization-member', [], [], ''),
 ('/orgs/{org}/memberships/{username}', 'get', 'orgs/get-membership-for-user', 'Get organization membership for a user', 'rest/reference/orgs#get-organization-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/memberships/{username}', 'put', 'orgs/set-membership-for-user', 'Set organization membership for a user', 'rest/reference/orgs#set-organization-membership-for-a-user', [], [['role', str, 'member']], ''),
 ('/orgs/{org}/memberships/{username}', 'delete', 'orgs/remove-membership-for-user', 'Remove organization membership for a user', 'rest/reference/orgs#remove-organization-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/migrations', 'get', 'migrations/list-for-org', 'List organization migrations', 'rest/reference/migrations#list-organization-migrations', ['per_page', 'page'], [], 'wyandotte'),
 ('/orgs/{org}/migrations', 'post', 'migrations/start-for-org', 'Start an organization migration', 'rest/reference/migrations#start-an-organization-migration', [], [['repositories', list], ['lock_repositories', bool, False], ['exclude_attachments', bool, False], ['exclude', list]], ''),
 ('/orgs/{org}/migrations/{migration_id}', 'get', 'migrations/get-status-for-org', 'Get an organization migration status', 'rest/reference/migrations#get-an-organization-migration-status', [], [], 'wyandotte'),
 ('/orgs/{org}/migrations/{migration_id}/archive', 'get', 'migrations/download-archive-for-org', 'Download an organization migration archive', 'rest/reference/migrations#download-an-organization-migration-archive', [], [], 'wyandotte'),
 ('/orgs/{org}/migrations/{migration_id}/archive', 'delete', 'migrations/delete-archive-for-org', 'Delete an organization migration archive', 'rest/reference/migrations#delete-an-organization-migration-archive', [], [], 'wyandotte'),
 ('/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock', 'delete', 'migrations/unlock-repo-for-org', 'Unlock an organization repository', 'rest/reference/migrations#unlock-an-organization-repository', [], [], 'wyandotte'),
 ('/orgs/{org}/migrations/{migration_id}/repositories', 'get', 'migrations/list-repos-for-org', 'List repositories in an organization migration', 'rest/reference/migrations#list-repositories-in-an-organization-migration', ['per_page', 'page'], [], 'wyandotte'),
 ('/orgs/{org}/outside_collaborators', 'get', 'orgs/list-outside-collaborators', 'List outside collaborators for an organization', 'rest/reference/orgs#list-outside-collaborators-for-an-organization', ['filter', 'per_page', 'page'], [], ''),
 ('/orgs/{org}/outside_collaborators/{username}', 'put', 'orgs/convert-member-to-outside-collaborator', 'Convert an organization member to outside collaborator', 'rest/reference/orgs#convert-an-organization-member-to-outside-collaborator', [], [], ''),
 ('/orgs/{org}/outside_collaborators/{username}', 'delete', 'orgs/remove-outside-collaborator', 'Remove outside collaborator from an organization', 'rest/reference/orgs#remove-outside-collaborator-from-an-organization', [], [], ''),
 ('/orgs/{org}/projects', 'get', 'projects/list-for-org', 'List organization projects', 'v3/projects/#list-organization-projects', ['state', 'per_page', 'page'], [], 'inertia'),
 ('/orgs/{org}/projects', 'post', 'projects/create-for-org', 'Create an organization project', 'v3/projects/#create-an-organization-project', [], [['name', str], ['body', str]], 'inertia'),
 ('/orgs/{org}/public_members', 'get', 'orgs/list-public-members', 'List public organization members', 'rest/reference/orgs#list-public-organization-members', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/public_members/{username}', 'get', 'orgs/check-public-membership-for-user', 'Check public organization membership for a user', 'rest/reference/orgs#check-public-organization-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/public_members/{username}', 'put', 'orgs/set-public-membership-for-authenticated-user', 'Set public organization membership for the authenticated user', 'rest/reference/orgs#set-public-organization-membership-for-the-authenticated-user', [], [], ''),
 ('/orgs/{org}/public_members/{username}', 'delete', 'orgs/remove-public-membership-for-authenticated-user', 'Remove public organization membership for the authenticated user', 'rest/reference/orgs#remove-public-organization-membership-for-the-authenticated-user', [], [], ''),
 ('/orgs/{org}/repos', 'get', 'repos/list-for-org', 'List organization repositories', 'v3/repos/#list-organization-repositories', ['type', 'sort', 'direction', 'per_page', 'page'], [], 'nebula'),
 ('/orgs/{org}/repos',
  'post',
  'repos/create-in-org',
  'Create an organization repository',
  'v3/repos/#create-an-organization-repository',
  [],
  [['name', str],
   ['description', str],
   ['homepage', str],
   ['private', bool, False],
   ['visibility', str],
   ['has_issues', bool, True],
   ['has_projects', bool, True],
   ['has_wiki', bool, True],
   ['is_template', bool, False],
   ['team_id', int],
   ['auto_init', bool, False],
   ['gitignore_template', str],
   ['license_template', str],
   ['allow_squash_merge', bool, True],
   ['allow_merge_commit', bool, True],
   ['allow_rebase_merge', bool, True],
   ['delete_branch_on_merge', bool, False]],
  'nebula'),
 ('/orgs/{org}/settings/billing/actions', 'get', 'billing/get-github-actions-billing-org', 'Get GitHub Actions billing for an organization', 'v3/billing/#get-github-actions-billing-for-an-organization', [], [], ''),
 ('/orgs/{org}/settings/billing/packages', 'get', 'billing/get-github-packages-billing-org', 'Get GitHub Packages billing for an organization', 'v3/billing/#get-github-packages-billing-for-an-organization', [], [], ''),
 ('/orgs/{org}/settings/billing/shared-storage', 'get', 'billing/get-shared-storage-billing-org', 'Get shared storage billing for an organization', 'v3/billing/#get-shared-storage-billing-for-an-organization', [], [], ''),
 ('/orgs/{org}/team-sync/groups', 'get', 'teams/list-idp-groups-for-org', 'List IdP groups for an organization', 'rest/reference/teams#list-idp-groups-for-an-organization', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/teams', 'get', 'teams/list', 'List teams', 'v3/teams/#list-teams', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/teams', 'post', 'teams/create', 'Create a team', 'v3/teams/#create-a-team', [], [['name', str], ['description', str], ['maintainers', list], ['repo_names', list], ['privacy', str], ['permission', str, 'pull'], ['parent_team_id', int]], ''),
 ('/orgs/{org}/teams/{team_slug}', 'get', 'teams/get-by-name', 'Get a team by name', 'v3/teams/#get-a-team-by-name', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}', 'patch', 'teams/update-in-org', 'Update a team', 'v3/teams/#update-a-team', [], [['name', str], ['description', str], ['privacy', str], ['permission', str, 'pull'], ['parent_team_id', int]], ''),
 ('/orgs/{org}/teams/{team_slug}', 'delete', 'teams/delete-in-org', 'Delete a team', 'v3/teams/#delete-a-team', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/discussions', 'get', 'teams/list-discussions-in-org', 'List discussions', 'rest/reference/teams#list-discussions', ['direction', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions', 'post', 'teams/create-discussion-in-org', 'Create a discussion', 'rest/reference/teams#create-a-discussion', [], [['title', str], ['body', str], ['private', bool, False]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}', 'get', 'teams/get-discussion-in-org', 'Get a discussion', 'rest/reference/teams#get-a-discussion', [], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}', 'patch', 'teams/update-discussion-in-org', 'Update a discussion', 'rest/reference/teams#update-a-discussion', [], [['title', str], ['body', str]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}', 'delete', 'teams/delete-discussion-in-org', 'Delete a discussion', 'rest/reference/teams#delete-a-discussion', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments', 'get', 'teams/list-discussion-comments-in-org', 'List discussion comments', 'rest/reference/teams#list-discussion-comments', ['direction', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments', 'post', 'teams/create-discussion-comment-in-org', 'Create a discussion comment', 'rest/reference/teams#create-a-discussion-comment', [], [['body', str]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}', 'get', 'teams/get-discussion-comment-in-org', 'Get a discussion comment', 'rest/reference/teams#get-a-discussion-comment', [], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}', 'patch', 'teams/update-discussion-comment-in-org', 'Update a discussion comment', 'rest/reference/teams#update-a-discussion-comment', [], [['body', str]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}', 'delete', 'teams/delete-discussion-comment-in-org', 'Delete a discussion comment', 'rest/reference/teams#delete-a-discussion-comment', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions', 'get', 'reactions/list-for-team-discussion-comment-in-org', 'List reactions for a team discussion comment', 'v3/reactions/#list-reactions-for-a-team-discussion-comment', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions', 'post', 'reactions/create-for-team-discussion-comment-in-org', 'Create reaction for a team discussion comment', 'v3/reactions/#create-reaction-for-a-team-discussion-comment', [], [['content', str]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-team-discussion-comment', 'Delete team discussion comment reaction', 'v3/reactions/#delete-team-discussion-comment-reaction', [], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions', 'get', 'reactions/list-for-team-discussion-in-org', 'List reactions for a team discussion', 'v3/reactions/#list-reactions-for-a-team-discussion', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions', 'post', 'reactions/create-for-team-discussion-in-org', 'Create reaction for a team discussion', 'v3/reactions/#create-reaction-for-a-team-discussion', [], [['content', str]], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-team-discussion', 'Delete team discussion reaction', 'v3/reactions/#delete-team-discussion-reaction', [], [], 'squirrel-girl'),
 ('/orgs/{org}/teams/{team_slug}/invitations', 'get', 'teams/list-pending-invitations-in-org', 'List pending team invitations', 'rest/reference/teams#list-pending-team-invitations', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/teams/{team_slug}/members', 'get', 'teams/list-members-in-org', 'List team members', 'rest/reference/teams#list-team-members', ['role', 'per_page', 'page'], [], ''),
 ('/orgs/{org}/teams/{team_slug}/memberships/{username}', 'get', 'teams/get-membership-for-user-in-org', 'Get team membership for a user', 'rest/reference/teams#get-team-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/memberships/{username}', 'put', 'teams/add-or-update-membership-for-user-in-org', 'Add or update team membership for a user', 'rest/reference/teams#add-or-update-team-membership-for-a-user', [], [['role', str, 'member']], ''),
 ('/orgs/{org}/teams/{team_slug}/memberships/{username}', 'delete', 'teams/remove-membership-for-user-in-org', 'Remove team membership for a user', 'rest/reference/teams#remove-team-membership-for-a-user', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/projects', 'get', 'teams/list-projects-in-org', 'List team projects', 'v3/teams/#list-team-projects', ['per_page', 'page'], [], 'inertia'),
 ('/orgs/{org}/teams/{team_slug}/projects/{project_id}', 'get', 'teams/check-permissions-for-project-in-org', 'Check team permissions for a project', 'v3/teams/#check-team-permissions-for-a-project', [], [], 'inertia'),
 ('/orgs/{org}/teams/{team_slug}/projects/{project_id}', 'put', 'teams/add-or-update-project-permissions-in-org', 'Add or update team project permissions', 'v3/teams/#add-or-update-team-project-permissions', [], [['permission', str]], 'inertia'),
 ('/orgs/{org}/teams/{team_slug}/projects/{project_id}', 'delete', 'teams/remove-project-in-org', 'Remove a project from a team', 'v3/teams/#remove-a-project-from-a-team', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/repos', 'get', 'teams/list-repos-in-org', 'List team repositories', 'v3/teams/#list-team-repositories', ['per_page', 'page'], [], ''),
 ('/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}', 'get', 'teams/check-permissions-for-repo-in-org', 'Check team permissions for a repository', 'v3/teams/#check-team-permissions-for-a-repository', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}', 'put', 'teams/add-or-update-repo-permissions-in-org', 'Add or update team repository permissions', 'v3/teams/#add-or-update-team-repository-permissions', [], [['permission', str]], ''),
 ('/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}', 'delete', 'teams/remove-repo-in-org', 'Remove a repository from a team', 'v3/teams/#remove-a-repository-from-a-team', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/team-sync/group-mappings', 'get', 'teams/list-idp-groups-in-org', 'List IdP groups for a team', 'rest/reference/teams#list-idp-groups-for-a-team', [], [], ''),
 ('/orgs/{org}/teams/{team_slug}/team-sync/group-mappings', 'patch', 'teams/create-or-update-idp-group-connections-in-org', 'Create or update IdP group connections', 'rest/reference/teams#create-or-update-idp-group-connections', [], [['groups', list]], ''),
 ('/orgs/{org}/teams/{team_slug}/teams', 'get', 'teams/list-child-in-org', 'List child teams', 'v3/teams/#list-child-teams', ['per_page', 'page'], [], ''),
 ('/projects/columns/cards/{card_id}', 'get', 'projects/get-card', 'Get a project card', 'rest/reference/projects#get-a-project-card', [], [], 'inertia'),
 ('/projects/columns/cards/{card_id}', 'patch', 'projects/update-card', 'Update an existing project card', 'rest/reference/projects#update-a-project-card', [], [['note', str], ['archived', bool]], 'inertia'),
 ('/projects/columns/cards/{card_id}', 'delete', 'projects/delete-card', 'Delete a project card', 'rest/reference/projects#delete-a-project-card', [], [], 'inertia'),
 ('/projects/columns/cards/{card_id}/moves', 'post', 'projects/move-card', 'Move a project card', 'rest/reference/projects#move-a-project-card', [], [['position', str], ['column_id', int]], 'inertia'),
 ('/projects/columns/{column_id}', 'get', 'projects/get-column', 'Get a project column', 'rest/reference/projects#get-a-project-column', [], [], 'inertia'),
 ('/projects/columns/{column_id}', 'patch', 'projects/update-column', 'Update an existing project column', 'rest/reference/projects#update-a-project-column', [], [['name', str]], 'inertia'),
 ('/projects/columns/{column_id}', 'delete', 'projects/delete-column', 'Delete a project column', 'rest/reference/projects#delete-a-project-column', [], [], 'inertia'),
 ('/projects/columns/{column_id}/cards', 'get', 'projects/list-cards', 'List project cards', 'rest/reference/projects#list-project-cards', ['archived_state', 'per_page', 'page'], [], 'inertia'),
 ('/projects/columns/{column_id}/cards', 'post', 'projects/create-card', 'Create a project card', 'rest/reference/projects#create-a-project-card', [], [], 'inertia'),
 ('/projects/columns/{column_id}/moves', 'post', 'projects/move-column', 'Move a project column', 'rest/reference/projects#move-a-project-column', [], [['position', str]], 'inertia'),
 ('/projects/{project_id}', 'get', 'projects/get', 'Get a project', 'v3/projects/#get-a-project', [], [], 'inertia'),
 ('/projects/{project_id}', 'patch', 'projects/update', 'Update a project', 'v3/projects/#update-a-project', [], [['name', str], ['body', str], ['state', str], ['organization_permission', str], ['private', bool]], 'inertia'),
 ('/projects/{project_id}', 'delete', 'projects/delete', 'Delete a project', 'v3/projects/#delete-a-project', [], [], 'inertia'),
 ('/projects/{project_id}/collaborators', 'get', 'projects/list-collaborators', 'List project collaborators', 'rest/reference/projects#list-project-collaborators', ['affiliation', 'per_page', 'page'], [], 'inertia'),
 ('/projects/{project_id}/collaborators/{username}', 'put', 'projects/add-collaborator', 'Add project collaborator', 'rest/reference/projects#add-project-collaborator', [], [['permission', str, 'write']], 'inertia'),
 ('/projects/{project_id}/collaborators/{username}', 'delete', 'projects/remove-collaborator', 'Remove user as a collaborator', 'rest/reference/projects#remove-project-collaborator', [], [], 'inertia'),
 ('/projects/{project_id}/collaborators/{username}/permission', 'get', 'projects/get-permission-for-user', 'Get project permission for a user', 'rest/reference/projects#get-project-permission-for-a-user', [], [], 'inertia'),
 ('/projects/{project_id}/columns', 'get', 'projects/list-columns', 'List project columns', 'rest/reference/projects#list-project-columns', ['per_page', 'page'], [], 'inertia'),
 ('/projects/{project_id}/columns', 'post', 'projects/create-column', 'Create a project column', 'rest/reference/projects#create-a-project-column', [], [['name', str]], 'inertia'),
 ('/rate_limit', 'get', 'rate-limit/get', 'Get rate limit status for the authenticated user', 'v3/rate_limit/#get-rate-limit-status-for-the-authenticated-user', [], [], ''),
 ('/reactions/{reaction_id}', 'delete', 'reactions/delete-legacy', 'Delete a reaction (Legacy)', 'v3/reactions/#delete-a-reaction-legacy', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}', 'get', 'repos/get', 'Get a repository', 'v3/repos/#get-a-repository', [], [], 'nebula'),
 ('/repos/{owner}/{repo}',
  'patch',
  'repos/update',
  'Update a repository',
  'v3/repos/#update-a-repository',
  [],
  [['name', str],
   ['description', str],
   ['homepage', str],
   ['private', bool, False],
   ['visibility', str],
   ['has_issues', bool, True],
   ['has_projects', bool, True],
   ['has_wiki', bool, True],
   ['is_template', bool, False],
   ['default_branch', str],
   ['allow_squash_merge', bool, True],
   ['allow_merge_commit', bool, True],
   ['allow_rebase_merge', bool, True],
   ['delete_branch_on_merge', bool, False],
   ['archived', bool, False]],
  'nebula'),
 ('/repos/{owner}/{repo}', 'delete', 'repos/delete', 'Delete a repository', 'v3/repos/#delete-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/artifacts', 'get', 'actions/list-artifacts-for-repo', 'List artifacts for a repository', 'rest/reference/actions#list-artifacts-for-a-repository', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/artifacts/{artifact_id}', 'get', 'actions/get-artifact', 'Get an artifact', 'rest/reference/actions#get-an-artifact', [], [], ''),
 ('/repos/{owner}/{repo}/actions/artifacts/{artifact_id}', 'delete', 'actions/delete-artifact', 'Delete an artifact', 'rest/reference/actions#delete-an-artifact', [], [], ''),
 ('/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}', 'get', 'actions/download-artifact', 'Download an artifact', 'rest/reference/actions#download-an-artifact', [], [], ''),
 ('/repos/{owner}/{repo}/actions/jobs/{job_id}', 'get', 'actions/get-job-for-workflow-run', 'Get a job for a workflow run', 'rest/reference/actions#get-a-job-for-a-workflow-run', [], [], ''),
 ('/repos/{owner}/{repo}/actions/jobs/{job_id}/logs', 'get', 'actions/download-job-logs-for-workflow-run', 'Download job logs for a workflow run', 'rest/reference/actions#download-job-logs-for-a-workflow-run', [], [], ''),
 ('/repos/{owner}/{repo}/actions/permissions', 'get', 'actions/get-github-actions-permissions-repository', 'Get GitHub Actions permissions for a repository', 'rest/reference/actions#get-github-actions-permissions-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/permissions', 'put', 'actions/set-github-actions-permissions-repository', 'Set GitHub Actions permissions for a repository', 'rest/reference/actions#set-github-actions-permissions-for-a-repository', [], [['enabled', bool], ['allowed_actions', str]], ''),
 ('/repos/{owner}/{repo}/actions/permissions/selected-actions', 'get', 'actions/get-allowed-actions-repository', 'Get allowed actions for a repository', 'rest/reference/actions#get-allowed-actions-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/permissions/selected-actions', 'put', 'actions/set-allowed-actions-repository', 'Set allowed actions for a repository', 'rest/reference/actions#set-allowed-actions-for-a-repository', [], [['github_owned_allowed', bool], ['verified_allowed', bool], ['patterns_allowed', list]], ''),
 ('/repos/{owner}/{repo}/actions/runners', 'get', 'actions/list-self-hosted-runners-for-repo', 'List self-hosted runners for a repository', 'rest/reference/actions#list-self-hosted-runners-for-a-repository', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/runners/downloads', 'get', 'actions/list-runner-applications-for-repo', 'List runner applications for a repository', 'rest/reference/actions#list-runner-applications-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runners/registration-token', 'post', 'actions/create-registration-token-for-repo', 'Create a registration token for a repository', 'rest/reference/actions#create-a-registration-token-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runners/remove-token', 'post', 'actions/create-remove-token-for-repo', 'Create a remove token for a repository', 'rest/reference/actions#create-a-remove-token-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runners/{runner_id}', 'get', 'actions/get-self-hosted-runner-for-repo', 'Get a self-hosted runner for a repository', 'rest/reference/actions#get-a-self-hosted-runner-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runners/{runner_id}', 'delete', 'actions/delete-self-hosted-runner-from-repo', 'Delete a self-hosted runner from a repository', 'rest/reference/actions#delete-a-self-hosted-runner-from-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs', 'get', 'actions/list-workflow-runs-for-repo', 'List workflow runs for a repository', 'rest/reference/actions#list-workflow-runs-for-a-repository', ['actor', 'branch', 'event', 'status', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}', 'get', 'actions/get-workflow-run', 'Get a workflow run', 'rest/reference/actions#get-a-workflow-run', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}', 'delete', 'actions/delete-workflow-run', 'Delete a workflow run', 'rest/reference/actions#delete-a-workflow-run', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts', 'get', 'actions/list-workflow-run-artifacts', 'List workflow run artifacts', 'rest/reference/actions#list-workflow-run-artifacts', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/cancel', 'post', 'actions/cancel-workflow-run', 'Cancel a workflow run', 'rest/reference/actions#cancel-a-workflow-run', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/jobs', 'get', 'actions/list-jobs-for-workflow-run', 'List jobs for a workflow run', 'rest/reference/actions#list-jobs-for-a-workflow-run', ['filter', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/logs', 'get', 'actions/download-workflow-run-logs', 'Download workflow run logs', 'rest/reference/actions#download-workflow-run-logs', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/logs', 'delete', 'actions/delete-workflow-run-logs', 'Delete workflow run logs', 'rest/reference/actions#delete-workflow-run-logs', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/rerun', 'post', 'actions/re-run-workflow', 'Re-run a workflow', 'rest/reference/actions#re-run-a-workflow', [], [], ''),
 ('/repos/{owner}/{repo}/actions/runs/{run_id}/timing', 'get', 'actions/get-workflow-run-usage', 'Get workflow run usage', 'rest/reference/actions#get-workflow-run-usage', [], [], ''),
 ('/repos/{owner}/{repo}/actions/secrets', 'get', 'actions/list-repo-secrets', 'List repository secrets', 'rest/reference/actions#list-repository-secrets', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/secrets/public-key', 'get', 'actions/get-repo-public-key', 'Get a repository public key', 'rest/reference/actions#get-a-repository-public-key', [], [], ''),
 ('/repos/{owner}/{repo}/actions/secrets/{secret_name}', 'get', 'actions/get-repo-secret', 'Get a repository secret', 'rest/reference/actions#get-a-repository-secret', [], [], ''),
 ('/repos/{owner}/{repo}/actions/secrets/{secret_name}', 'put', 'actions/create-or-update-repo-secret', 'Create or update a repository secret', 'rest/reference/actions#create-or-update-a-repository-secret', [], [['encrypted_value', str], ['key_id', str]], ''),
 ('/repos/{owner}/{repo}/actions/secrets/{secret_name}', 'delete', 'actions/delete-repo-secret', 'Delete a repository secret', 'rest/reference/actions#delete-a-repository-secret', [], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows', 'get', 'actions/list-repo-workflows', 'List repository workflows', 'rest/reference/actions#list-repository-workflows', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}', 'get', 'actions/get-workflow', 'Get a workflow', 'rest/reference/actions#get-a-workflow', [], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable', 'put', 'actions/disable-workflow', 'Disable a workflow', 'rest/reference/actions#disable-a-workflow', [], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches', 'post', 'actions/create-workflow-dispatch', 'Create a workflow dispatch event', 'rest/reference/actions#create-a-workflow-dispatch-event', [], [['ref', str], ['inputs', dict]], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable', 'put', 'actions/enable-workflow', 'Enable a workflow', 'rest/reference/actions#enable-a-workflow', [], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs', 'get', 'actions/list-workflow-runs', 'List workflow runs', 'rest/reference/actions#list-workflow-runs', ['actor', 'branch', 'event', 'status', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing', 'get', 'actions/get-workflow-usage', 'Get workflow usage', 'rest/reference/actions#get-workflow-usage', [], [], ''),
 ('/repos/{owner}/{repo}/assignees', 'get', 'issues/list-assignees', 'List assignees', 'rest/reference/issues#list-assignees', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/assignees/{assignee}', 'get', 'issues/check-user-can-be-assigned', 'Check if a user can be assigned', 'rest/reference/issues#check-if-a-user-can-be-assigned', [], [], ''),
 ('/repos/{owner}/{repo}/automated-security-fixes', 'put', 'repos/enable-automated-security-fixes', 'Enable automated security fixes', 'v3/repos/#enable-automated-security-fixes', [], [], 'london'),
 ('/repos/{owner}/{repo}/automated-security-fixes', 'delete', 'repos/disable-automated-security-fixes', 'Disable automated security fixes', 'v3/repos/#disable-automated-security-fixes', [], [], 'london'),
 ('/repos/{owner}/{repo}/branches', 'get', 'repos/list-branches', 'List branches', 'rest/reference/repos#list-branches', ['protected', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}', 'get', 'repos/get-branch', 'Get a branch', 'rest/reference/repos#get-a-branch', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection', 'get', 'repos/get-branch-protection', 'Get branch protection', 'rest/reference/repos#get-branch-protection', [], [], 'luke-cage'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection',
  'put',
  'repos/update-branch-protection',
  'Update branch protection',
  'rest/reference/repos#update-branch-protection',
  [],
  [['required_status_checks', dict], ['enforce_admins', bool], ['required_pull_request_reviews', dict], ['restrictions', dict], ['required_linear_history', bool], ['allow_force_pushes', bool], ['allow_deletions', bool]],
  'luke-cage'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection', 'delete', 'repos/delete-branch-protection', 'Delete branch protection', 'rest/reference/repos#delete-branch-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins', 'get', 'repos/get-admin-branch-protection', 'Get admin branch protection', 'rest/reference/repos#get-admin-branch-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins', 'post', 'repos/set-admin-branch-protection', 'Set admin branch protection', 'rest/reference/repos#set-admin-branch-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins', 'delete', 'repos/delete-admin-branch-protection', 'Delete admin branch protection', 'rest/reference/repos#delete-admin-branch-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews', 'get', 'repos/get-pull-request-review-protection', 'Get pull request review protection', 'rest/reference/repos#get-pull-request-review-protection', [], [], 'luke-cage'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews',
  'patch',
  'repos/update-pull-request-review-protection',
  'Update pull request review protection',
  'rest/reference/repos#update-pull-request-review-protection',
  [],
  [['dismissal_restrictions', dict], ['dismiss_stale_reviews', bool], ['require_code_owner_reviews', bool], ['required_approving_review_count', int]],
  'luke-cage'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews', 'delete', 'repos/delete-pull-request-review-protection', 'Delete pull request review protection', 'rest/reference/repos#delete-pull-request-review-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures', 'get', 'repos/get-commit-signature-protection', 'Get commit signature protection', 'rest/reference/repos#get-commit-signature-protection', [], [], 'zzzax'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures', 'post', 'repos/create-commit-signature-protection', 'Create commit signature protection', 'rest/reference/repos#create-commit-signature-protection', [], [], 'zzzax'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures', 'delete', 'repos/delete-commit-signature-protection', 'Delete commit signature protection', 'rest/reference/repos#delete-commit-signature-protection', [], [], 'zzzax'),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks', 'get', 'repos/get-status-checks-protection', 'Get status checks protection', 'rest/reference/repos#get-status-checks-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks', 'patch', 'repos/update-status-check-protection', 'Update status check protection', 'rest/reference/repos#update-status-check-potection', [], [['strict', bool], ['contexts', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks', 'delete', 'repos/remove-status-check-protection', 'Remove status check protection', 'rest/reference/repos#remove-status-check-protection', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts', 'get', 'repos/get-all-status-check-contexts', 'Get all status check contexts', 'rest/reference/repos#get-all-status-check-contexts', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts', 'post', 'repos/add-status-check-contexts', 'Add status check contexts', 'rest/reference/repos#add-status-check-contexts', [], [['contexts', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts', 'put', 'repos/set-status-check-contexts', 'Set status check contexts', 'rest/reference/repos#set-status-check-contexts', [], [['contexts', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts', 'delete', 'repos/remove-status-check-contexts', 'Remove status check contexts', 'rest/reference/repos#remove-status-check-contexts', [], [['contexts', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions', 'get', 'repos/get-access-restrictions', 'Get access restrictions', 'rest/reference/repos#get-access-restrictions', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions', 'delete', 'repos/delete-access-restrictions', 'Delete access restrictions', 'rest/reference/repos#delete-access-restrictions', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps', 'get', 'repos/get-apps-with-access-to-protected-branch', 'Get apps with access to the protected branch', 'rest/reference/repos#list-apps-with-access-to-the-protected-branch', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps', 'post', 'repos/add-app-access-restrictions', 'Add app access restrictions', 'rest/reference/repos#add-app-access-restrictions', [], [['apps', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps', 'put', 'repos/set-app-access-restrictions', 'Set app access restrictions', 'rest/reference/repos#set-app-access-restrictions', [], [['apps', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps', 'delete', 'repos/remove-app-access-restrictions', 'Remove app access restrictions', 'rest/reference/repos#remove-app-access-restrictions', [], [['apps', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams', 'get', 'repos/get-teams-with-access-to-protected-branch', 'Get teams with access to the protected branch', 'rest/reference/repos#list-teams-with-access-to-the-protected-branch', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams', 'post', 'repos/add-team-access-restrictions', 'Add team access restrictions', 'rest/reference/repos#add-team-access-restrictions', [], [['teams', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams', 'put', 'repos/set-team-access-restrictions', 'Set team access restrictions', 'rest/reference/repos#set-team-access-restrictions', [], [['teams', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams', 'delete', 'repos/remove-team-access-restrictions', 'Remove team access restrictions', 'rest/reference/repos#remove-team-access-restrictions', [], [['teams', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users', 'get', 'repos/get-users-with-access-to-protected-branch', 'Get users with access to the protected branch', 'rest/reference/repos#list-users-with-access-to-the-protected-branch', [], [], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users', 'post', 'repos/add-user-access-restrictions', 'Add user access restrictions', 'rest/reference/repos#add-user-access-restrictions', [], [['users', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users', 'put', 'repos/set-user-access-restrictions', 'Set user access restrictions', 'rest/reference/repos#set-user-access-restrictions', [], [['users', list]], ''),
 ('/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users', 'delete', 'repos/remove-user-access-restrictions', 'Remove user access restrictions', 'rest/reference/repos#remove-user-access-restrictions', [], [['users', list]], ''),
 ('/repos/{owner}/{repo}/check-runs', 'post', 'checks/create', 'Create a check run', 'rest/reference/checks#create-a-check-run', [], [['name', str], ['head_sha', str], ['details_url', str], ['external_id', str], ['status', str, 'queued'], ['started_at', str], ['conclusion', str], ['completed_at', str], ['output', dict], ['actions', list]], ''),
 ('/repos/{owner}/{repo}/check-runs/{check_run_id}', 'get', 'checks/get', 'Get a check run', 'rest/reference/checks#get-a-check-run', [], [], ''),
 ('/repos/{owner}/{repo}/check-runs/{check_run_id}', 'patch', 'checks/update', 'Update a check run', 'rest/reference/checks#update-a-check-run', [], [['name', str], ['details_url', str], ['external_id', str], ['started_at', str], ['status', str], ['conclusion', str], ['completed_at', str], ['output', dict], ['actions', list]], ''),
 ('/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations', 'get', 'checks/list-annotations', 'List check run annotations', 'rest/reference/checks#list-check-run-annotations', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/check-suites', 'post', 'checks/create-suite', 'Create a check suite', 'rest/reference/checks#create-a-check-suite', [], [['head_sha', str]], ''),
 ('/repos/{owner}/{repo}/check-suites/preferences', 'patch', 'checks/set-suites-preferences', 'Update repository preferences for check suites', 'rest/reference/checks#update-repository-preferences-for-check-suites', [], [['auto_trigger_checks', list]], ''),
 ('/repos/{owner}/{repo}/check-suites/{check_suite_id}', 'get', 'checks/get-suite', 'Get a check suite', 'rest/reference/checks#get-a-check-suite', [], [], ''),
 ('/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs', 'get', 'checks/list-for-suite', 'List check runs in a check suite', 'rest/reference/checks#list-check-runs-in-a-check-suite', ['check_name', 'status', 'filter', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest', 'post', 'checks/rerequest-suite', 'Rerequest a check suite', 'rest/reference/checks#rerequest-a-check-suite', [], [], ''),
 ('/repos/{owner}/{repo}/code-scanning/alerts', 'get', 'code-scanning/list-alerts-for-repo', 'List code scanning alerts for a repository', 'v3/code-scanning/#list-code-scanning-alerts-for-a-repository', ['state', 'ref'], [], ''),
 ('/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}', 'get', 'code-scanning/get-alert', 'Get a code scanning alert', 'v3/code-scanning/#get-a-code-scanning-alert', [], [], ''),
 ('/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}', 'patch', 'code-scanning/update-alert', 'Update a code scanning alert', 'v3/code-scanning/#upload-a-code-scanning-alert', [], [['state', str], ['dismissed_reason', str]], ''),
 ('/repos/{owner}/{repo}/code-scanning/analyses', 'get', 'code-scanning/list-recent-analyses', 'List recent code scanning analyses for a repository', 'v3/code-scanning/#list-recent-analyses', ['ref', 'tool_name'], [], ''),
 ('/repos/{owner}/{repo}/code-scanning/sarifs', 'post', 'code-scanning/upload-sarif', 'Upload a SARIF file', 'v3/code-scanning/#upload-a-sarif-analysis', [], [['commit_sha', str], ['ref', str], ['sarif', str], ['checkout_uri', str], ['started_at', str], ['tool_name', str]], ''),
 ('/repos/{owner}/{repo}/collaborators', 'get', 'repos/list-collaborators', 'List repository collaborators', 'rest/reference/repos#list-repository-collaborators', ['affiliation', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/collaborators/{username}', 'get', 'repos/check-collaborator', 'Check if a user is a repository collaborator', 'rest/reference/repos#check-if-a-user-is-a-repository-collaborator', [], [], ''),
 ('/repos/{owner}/{repo}/collaborators/{username}', 'put', 'repos/add-collaborator', 'Add a repository collaborator', 'rest/reference/repos#add-a-repository-collaborator', [], [['permission', str, 'push'], ['permissions', str]], ''),
 ('/repos/{owner}/{repo}/collaborators/{username}', 'delete', 'repos/remove-collaborator', 'Remove a repository collaborator', 'rest/reference/repos#remove-a-repository-collaborator', [], [], ''),
 ('/repos/{owner}/{repo}/collaborators/{username}/permission', 'get', 'repos/get-collaborator-permission-level', 'Get repository permissions for a user', 'rest/reference/repos#get-repository-permissions-for-a-user', [], [], ''),
 ('/repos/{owner}/{repo}/comments', 'get', 'repos/list-commit-comments-for-repo', 'List commit comments for a repository', 'rest/reference/repos#list-commit-comments-for-a-repository', ['per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/comments/{comment_id}', 'get', 'repos/get-commit-comment', 'Get a commit comment', 'rest/reference/repos#get-a-commit-comment', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/comments/{comment_id}', 'patch', 'repos/update-commit-comment', 'Update a commit comment', 'rest/reference/repos#update-a-commit-comment', [], [['body', str]], ''),
 ('/repos/{owner}/{repo}/comments/{comment_id}', 'delete', 'repos/delete-commit-comment', 'Delete a commit comment', 'rest/reference/repos#delete-a-commit-comment', [], [], ''),
 ('/repos/{owner}/{repo}/comments/{comment_id}/reactions', 'get', 'reactions/list-for-commit-comment', 'List reactions for a commit comment', 'v3/reactions/#list-reactions-for-a-commit-comment', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/comments/{comment_id}/reactions', 'post', 'reactions/create-for-commit-comment', 'Create reaction for a commit comment', 'v3/reactions/#create-reaction-for-a-commit-comment', [], [['content', str]], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-commit-comment', 'Delete a commit comment reaction', 'v3/reactions/#delete-a-commit-comment-reaction', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/commits', 'get', 'repos/list-commits', 'List commits', 'rest/reference/repos#list-commits', ['sha', 'path', 'author', 'since', 'until', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head', 'get', 'repos/list-branches-for-head-commit', 'List branches for HEAD commit', 'rest/reference/repos#list-branches-for-head-commit', [], [], 'groot'),
 ('/repos/{owner}/{repo}/commits/{commit_sha}/comments', 'get', 'repos/list-comments-for-commit', 'List commit comments', 'rest/reference/repos#list-commit-comments', ['per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/commits/{commit_sha}/comments', 'post', 'repos/create-commit-comment', 'Create a commit comment', 'rest/reference/repos#create-a-commit-comment', [], [['body', str], ['path', str], ['position', int], ['line', int]], ''),
 ('/repos/{owner}/{repo}/commits/{commit_sha}/pulls', 'get', 'repos/list-pull-requests-associated-with-commit', 'List pull requests associated with a commit', 'rest/reference/repos#list-pull-requests-associated-with-a-commit', ['per_page', 'page'], [], 'groot'),
 ('/repos/{owner}/{repo}/commits/{ref}', 'get', 'repos/get-commit', 'Get a commit', 'rest/reference/repos#get-a-commit', [], [], ''),
 ('/repos/{owner}/{repo}/commits/{ref}/check-runs', 'get', 'checks/list-for-ref', 'List check runs for a Git reference', 'rest/reference/checks#list-check-runs-for-a-git-reference', ['check_name', 'status', 'filter', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/commits/{ref}/check-suites', 'get', 'checks/list-suites-for-ref', 'List check suites for a Git reference', 'rest/reference/checks#list-check-suites-for-a-git-reference', ['app_id', 'check_name', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/commits/{ref}/status', 'get', 'repos/get-combined-status-for-ref', 'Get the combined status for a specific reference', 'rest/reference/repos#get-the-combined-status-for-a-specific-reference', [], [], ''),
 ('/repos/{owner}/{repo}/commits/{ref}/statuses', 'get', 'repos/list-commit-statuses-for-ref', 'List commit statuses for a reference', 'rest/reference/repos#list-commit-statuses-for-a-reference', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/community/code_of_conduct', 'get', 'codes-of-conduct/get-for-repo', 'Get the code of conduct for a repository', 'v3/codes_of_conduct/#get-the-code-of-conduct-for-a-repository', [], [], 'scarlet-witch'),
 ('/repos/{owner}/{repo}/community/profile', 'get', 'repos/get-community-profile-metrics', 'Get community profile metrics', 'rest/reference/repos#get-community-profile-metrics', [], [], ''),
 ('/repos/{owner}/{repo}/compare/{base}...{head}', 'get', 'repos/compare-commits', 'Compare two commits', 'rest/reference/repos#compare-two-commits', [], [], ''),
 ('/repos/{owner}/{repo}/contents/{path}', 'get', 'repos/get-content', 'Get repository content', 'rest/reference/repos#get-repository-content', ['ref'], [], ''),
 ('/repos/{owner}/{repo}/contents/{path}', 'put', 'repos/create-or-update-file-contents', 'Create or update file contents', 'rest/reference/repos#create-or-update-file-contents', [], [['message', str], ['content', str], ['sha', str], ['branch', str], ['committer', dict], ['author', dict]], ''),
 ('/repos/{owner}/{repo}/contents/{path}', 'delete', 'repos/delete-file', 'Delete a file', 'rest/reference/repos#delete-a-file', [], [['message', str], ['sha', str], ['branch', str], ['committer', dict], ['author', dict]], ''),
 ('/repos/{owner}/{repo}/contributors', 'get', 'repos/list-contributors', 'List repository contributors', 'v3/repos/#list-repository-contributors', ['anon', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/deployments', 'get', 'repos/list-deployments', 'List deployments', 'rest/reference/repos#list-deployments', ['sha', 'ref', 'task', 'environment', 'per_page', 'page'], [], 'ant-man'),
 ('/repos/{owner}/{repo}/deployments',
  'post',
  'repos/create-deployment',
  'Create a deployment',
  'rest/reference/repos#create-a-deployment',
  [],
  [['ref', str], ['task', str, 'deploy'], ['auto_merge', bool, True], ['required_contexts', list], ['payload', str, ''], ['environment', str, 'production'], ['description', str, ''], ['transient_environment', bool, False], ['production_environment', bool], ['created_at', str]],
  'ant-man'),
 ('/repos/{owner}/{repo}/deployments/{deployment_id}', 'get', 'repos/get-deployment', 'Get a deployment', 'rest/reference/repos#get-a-deployment', [], [], 'ant-man'),
 ('/repos/{owner}/{repo}/deployments/{deployment_id}', 'delete', 'repos/delete-deployment', 'Delete a deployment', 'rest/reference/repos#delete-a-deployment', [], [], ''),
 ('/repos/{owner}/{repo}/deployments/{deployment_id}/statuses', 'get', 'repos/list-deployment-statuses', 'List deployment statuses', 'rest/reference/repos#list-deployment-statuses', ['per_page', 'page'], [], 'flash'),
 ('/repos/{owner}/{repo}/deployments/{deployment_id}/statuses',
  'post',
  'repos/create-deployment-status',
  'Create a deployment status',
  'rest/reference/repos#create-a-deployment-status',
  [],
  [['state', str], ['target_url', str, ''], ['log_url', str, ''], ['description', str, ''], ['environment', str], ['environment_url', str, ''], ['auto_inactive', bool]],
  'flash'),
 ('/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}', 'get', 'repos/get-deployment-status', 'Get a deployment status', 'rest/reference/repos#get-a-deployment-status', [], [], 'flash'),
 ('/repos/{owner}/{repo}/dispatches', 'post', 'repos/create-dispatch-event', 'Create a repository dispatch event', 'v3/repos/#create-a-repository-dispatch-event', [], [['event_type', str], ['client_payload', dict]], ''),
 ('/repos/{owner}/{repo}/events', 'get', 'activity/list-repo-events', 'List repository events', 'rest/reference/activity#list-repository-events', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/forks', 'get', 'repos/list-forks', 'List forks', 'rest/reference/repos#list-forks', ['sort', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/forks', 'post', 'repos/create-fork', 'Create a fork', 'rest/reference/repos#create-a-fork', [], [['organization', str]], ''),
 ('/repos/{owner}/{repo}/git/blobs', 'post', 'git/create-blob', 'Create a blob', 'rest/reference/git#create-a-blob', [], [['content', str], ['encoding', str, 'utf-8']], ''),
 ('/repos/{owner}/{repo}/git/blobs/{file_sha}', 'get', 'git/get-blob', 'Get a blob', 'rest/reference/git#get-a-blob', [], [], ''),
 ('/repos/{owner}/{repo}/git/commits', 'post', 'git/create-commit', 'Create a commit', 'rest/reference/git#create-a-commit', [], [['message', str], ['tree', str], ['parents', list], ['author', dict], ['committer', dict], ['signature', str]], ''),
 ('/repos/{owner}/{repo}/git/commits/{commit_sha}', 'get', 'git/get-commit', 'Get a commit', 'rest/reference/git#get-a-commit', [], [], ''),
 ('/repos/{owner}/{repo}/git/matching-refs/{ref}', 'get', 'git/list-matching-refs', 'List matching references', 'rest/reference/git#list-matching-references', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/git/ref/{ref}', 'get', 'git/get-ref', 'Get a reference', 'rest/reference/git#get-a-reference', [], [], ''),
 ('/repos/{owner}/{repo}/git/refs', 'post', 'git/create-ref', 'Create a reference', 'rest/reference/git#create-a-reference', [], [['ref', str], ['sha', str], ['key', str]], ''),
 ('/repos/{owner}/{repo}/git/refs/{ref}', 'patch', 'git/update-ref', 'Update a reference', 'rest/reference/git#update-a-reference', [], [['sha', str], ['force', bool, False]], ''),
 ('/repos/{owner}/{repo}/git/refs/{ref}', 'delete', 'git/delete-ref', 'Delete a reference', 'rest/reference/git#delete-a-reference', [], [], ''),
 ('/repos/{owner}/{repo}/git/tags', 'post', 'git/create-tag', 'Create a tag object', 'rest/reference/git#create-a-tag-object', [], [['tag', str], ['message', str], ['object', str], ['type', str], ['tagger', dict]], ''),
 ('/repos/{owner}/{repo}/git/tags/{tag_sha}', 'get', 'git/get-tag', 'Get a tag', 'rest/reference/git#get-a-tag', [], [], ''),
 ('/repos/{owner}/{repo}/git/trees', 'post', 'git/create-tree', 'Create a tree', 'rest/reference/git#create-a-tree', [], [['tree', list], ['base_tree', str]], ''),
 ('/repos/{owner}/{repo}/git/trees/{tree_sha}', 'get', 'git/get-tree', 'Get a tree', 'rest/reference/git#get-a-tree', ['recursive'], [], ''),
 ('/repos/{owner}/{repo}/hooks', 'get', 'repos/list-webhooks', 'List repository webhooks', 'rest/reference/repos#list-repository-webhooks', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/hooks', 'post', 'repos/create-webhook', 'Create a repository webhook', 'rest/reference/repos#create-a-repository-webhook', [], [['name', str], ['config', dict], ['events', list, ['push']], ['active', bool, True]], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}', 'get', 'repos/get-webhook', 'Get a repository webhook', 'rest/reference/repos#get-a-repository-webhook', [], [], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}', 'patch', 'repos/update-webhook', 'Update a repository webhook', 'rest/reference/repos#update-a-repository-webhook', [], [['config', dict], ['events', list, ['push']], ['add_events', list], ['remove_events', list], ['active', bool, True]], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}', 'delete', 'repos/delete-webhook', 'Delete a repository webhook', 'rest/reference/repos#delete-a-repository-webhook', [], [], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}/config', 'get', 'repos/get-webhook-config-for-repo', 'Get a webhook configuration for a repository', 'v3/repos#get-a-webhook-configuration-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}/config', 'patch', 'repos/update-webhook-config-for-repo', 'Update a webhook configuration for a repository', 'v3/repos#update-a-webhook-configuration-for-a-repository', [], [['url', str], ['content_type', str], ['secret', str], ['insecure_ssl', str]], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}/pings', 'post', 'repos/ping-webhook', 'Ping a repository webhook', 'rest/reference/repos#ping-a-repository-webhook', [], [], ''),
 ('/repos/{owner}/{repo}/hooks/{hook_id}/tests', 'post', 'repos/test-push-webhook', 'Test the push repository webhook', 'rest/reference/repos#test-the-push-repository-webhook', [], [], ''),
 ('/repos/{owner}/{repo}/import', 'get', 'migrations/get-import-status', 'Get an import status', 'rest/reference/migrations#get-an-import-status', [], [], ''),
 ('/repos/{owner}/{repo}/import', 'put', 'migrations/start-import', 'Start an import', 'rest/reference/migrations#start-an-import', [], [['vcs_url', str], ['vcs', str], ['vcs_username', str], ['vcs_password', str], ['tfvc_project', str]], ''),
 ('/repos/{owner}/{repo}/import', 'patch', 'migrations/update-import', 'Update an import', 'rest/reference/migrations#update-an-import', [], [['vcs_username', str], ['vcs_password', str], ['vcs', str], ['tfvc_project', str]], ''),
 ('/repos/{owner}/{repo}/import', 'delete', 'migrations/cancel-import', 'Cancel an import', 'rest/reference/migrations#cancel-an-import', [], [], ''),
 ('/repos/{owner}/{repo}/import/authors', 'get', 'migrations/get-commit-authors', 'Get commit authors', 'rest/reference/migrations#get-commit-authors', ['since'], [], ''),
 ('/repos/{owner}/{repo}/import/authors/{author_id}', 'patch', 'migrations/map-commit-author', 'Map a commit author', 'rest/reference/migrations#map-a-commit-author', [], [['email', str], ['name', str], ['remote_id', str]], ''),
 ('/repos/{owner}/{repo}/import/large_files', 'get', 'migrations/get-large-files', 'Get large files', 'rest/reference/migrations#get-large-files', [], [], ''),
 ('/repos/{owner}/{repo}/import/lfs', 'patch', 'migrations/set-lfs-preference', 'Update Git LFS preference', 'rest/reference/migrations#update-git-lfs-preference', [], [['use_lfs', str]], ''),
 ('/repos/{owner}/{repo}/installation', 'get', 'apps/get-repo-installation', 'Get a repository installation for the authenticated app', 'v3/apps/#get-a-repository-installation-for-the-authenticated-app', [], [], ''),
 ('/repos/{owner}/{repo}/interaction-limits', 'get', 'interactions/get-restrictions-for-repo', 'Get interaction restrictions for a repository', 'rest/reference/interactions#get-interaction-restrictions-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/interaction-limits', 'put', 'interactions/set-restrictions-for-repo', 'Set interaction restrictions for a repository', 'rest/reference/interactions#set-interaction-restrictions-for-a-repository', [], [['limit', str], ['expiry', str]], ''),
 ('/repos/{owner}/{repo}/interaction-limits', 'delete', 'interactions/remove-restrictions-for-repo', 'Remove interaction restrictions for a repository', 'rest/reference/interactions#remove-interaction-restrictions-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/invitations', 'get', 'repos/list-invitations', 'List repository invitations', 'rest/reference/repos#list-repository-invitations', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/invitations/{invitation_id}', 'patch', 'repos/update-invitation', 'Update a repository invitation', 'rest/reference/repos#update-a-repository-invitation', [], [['permissions', str]], ''),
 ('/repos/{owner}/{repo}/invitations/{invitation_id}', 'delete', 'repos/delete-invitation', 'Delete a repository invitation', 'rest/reference/repos#delete-a-repository-invitation', [], [], ''),
 ('/repos/{owner}/{repo}/issues', 'get', 'issues/list-for-repo', 'List repository issues', 'v3/issues/#list-repository-issues', ['milestone', 'state', 'assignee', 'creator', 'mentioned', 'labels', 'sort', 'direction', 'since', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues', 'post', 'issues/create', 'Create an issue', 'v3/issues/#create-an-issue', [], [['title', str], ['body', str], ['assignee', str], ['milestone', int], ['labels', list], ['assignees', list]], ''),
 ('/repos/{owner}/{repo}/issues/comments', 'get', 'issues/list-comments-for-repo', 'List issue comments for a repository', 'rest/reference/issues#list-issue-comments-for-a-repository', ['sort', 'direction', 'since', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}', 'get', 'issues/get-comment', 'Get an issue comment', 'rest/reference/issues#get-an-issue-comment', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}', 'patch', 'issues/update-comment', 'Update an issue comment', 'rest/reference/issues#update-an-issue-comment', [], [['body', str]], ''),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}', 'delete', 'issues/delete-comment', 'Delete an issue comment', 'rest/reference/issues#delete-an-issue-comment', [], [], ''),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions', 'get', 'reactions/list-for-issue-comment', 'List reactions for an issue comment', 'v3/reactions/#list-reactions-for-an-issue-comment', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions', 'post', 'reactions/create-for-issue-comment', 'Create reaction for an issue comment', 'v3/reactions/#create-reaction-for-an-issue-comment', [], [['content', str]], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-issue-comment', 'Delete an issue comment reaction', 'v3/reactions/#delete-an-issue-comment-reaction', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/events', 'get', 'issues/list-events-for-repo', 'List issue events for a repository', 'rest/reference/issues#list-issue-events-for-a-repository', ['per_page', 'page'], [], 'starfox'),
 ('/repos/{owner}/{repo}/issues/events/{event_id}', 'get', 'issues/get-event', 'Get an issue event', 'rest/reference/issues#get-an-issue-event', [], [], 'starfox'),
 ('/repos/{owner}/{repo}/issues/{issue_number}', 'get', 'issues/get', 'Get an issue', 'v3/issues/#get-an-issue', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/{issue_number}', 'patch', 'issues/update', 'Update an issue', 'v3/issues/#update-an-issue', [], [['title', str], ['body', str], ['assignee', str], ['state', str], ['milestone', int], ['labels', list], ['assignees', list]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/assignees', 'post', 'issues/add-assignees', 'Add assignees to an issue', 'rest/reference/issues#add-assignees-to-an-issue', [], [['assignees', list]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/assignees', 'delete', 'issues/remove-assignees', 'Remove assignees from an issue', 'rest/reference/issues#remove-assignees-from-an-issue', [], [['assignees', list]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/comments', 'get', 'issues/list-comments', 'List issue comments', 'rest/reference/issues#list-issue-comments', ['since', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/{issue_number}/comments', 'post', 'issues/create-comment', 'Create an issue comment', 'rest/reference/issues#create-an-issue-comment', [], [['body', str]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/events', 'get', 'issues/list-events', 'List issue events', 'rest/reference/issues#list-issue-events', ['per_page', 'page'], [], 'starfox'),
 ('/repos/{owner}/{repo}/issues/{issue_number}/labels', 'get', 'issues/list-labels-on-issue', 'List labels for an issue', 'rest/reference/issues#list-labels-for-an-issue', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/labels', 'post', 'issues/add-labels', 'Add labels to an issue', 'rest/reference/issues#add-labels-to-an-issue', [], [['labels', list]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/labels', 'put', 'issues/set-labels', 'Set labels for an issue', 'rest/reference/issues#set-labels-for-an-issue', [], [['labels', list]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/labels', 'delete', 'issues/remove-all-labels', 'Remove all labels from an issue', 'rest/reference/issues#remove-all-labels-from-an-issue', [], [], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}', 'delete', 'issues/remove-label', 'Remove a label from an issue', 'rest/reference/issues#remove-a-label-from-an-issue', [], [], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/lock', 'put', 'issues/lock', 'Lock an issue', 'v3/issues/#lock-an-issue', [], [['lock_reason', str]], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/lock', 'delete', 'issues/unlock', 'Unlock an issue', 'v3/issues/#unlock-an-issue', [], [], ''),
 ('/repos/{owner}/{repo}/issues/{issue_number}/reactions', 'get', 'reactions/list-for-issue', 'List reactions for an issue', 'v3/reactions/#list-reactions-for-an-issue', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/{issue_number}/reactions', 'post', 'reactions/create-for-issue', 'Create reaction for an issue', 'v3/reactions/#create-reaction-for-an-issue', [], [['content', str]], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-issue', 'Delete an issue reaction', 'v3/reactions/#delete-an-issue-reaction', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/issues/{issue_number}/timeline', 'get', 'issues/list-events-for-timeline', 'List timeline events for an issue', 'rest/reference/issues#list-timeline-events-for-an-issue', ['per_page', 'page'], [], 'mockingbird'),
 ('/repos/{owner}/{repo}/keys', 'get', 'repos/list-deploy-keys', 'List deploy keys', 'rest/reference/repos#list-deploy-keys', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/keys', 'post', 'repos/create-deploy-key', 'Create a deploy key', 'rest/reference/repos#create-a-deploy-key', [], [['title', str], ['key', str], ['read_only', bool]], ''),
 ('/repos/{owner}/{repo}/keys/{key_id}', 'get', 'repos/get-deploy-key', 'Get a deploy key', 'rest/reference/repos#get-a-deploy-key', [], [], ''),
 ('/repos/{owner}/{repo}/keys/{key_id}', 'delete', 'repos/delete-deploy-key', 'Delete a deploy key', 'rest/reference/repos#delete-a-deploy-key', [], [], ''),
 ('/repos/{owner}/{repo}/labels', 'get', 'issues/list-labels-for-repo', 'List labels for a repository', 'rest/reference/issues#list-labels-for-a-repository', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/labels', 'post', 'issues/create-label', 'Create a label', 'rest/reference/issues#create-a-label', [], [['name', str], ['color', str], ['description', str]], ''),
 ('/repos/{owner}/{repo}/labels/{name}', 'get', 'issues/get-label', 'Get a label', 'rest/reference/issues#get-a-label', [], [], ''),
 ('/repos/{owner}/{repo}/labels/{name}', 'patch', 'issues/update-label', 'Update a label', 'rest/reference/issues#update-a-label', [], [['new_name', str], ['color', str], ['description', str]], ''),
 ('/repos/{owner}/{repo}/labels/{name}', 'delete', 'issues/delete-label', 'Delete a label', 'rest/reference/issues#delete-a-label', [], [], ''),
 ('/repos/{owner}/{repo}/languages', 'get', 'repos/list-languages', 'List repository languages', 'v3/repos/#list-repository-languages', [], [], ''),
 ('/repos/{owner}/{repo}/license', 'get', 'licenses/get-for-repo', 'Get the license for a repository', 'v3/licenses/#get-the-license-for-a-repository', [], [], ''),
 ('/repos/{owner}/{repo}/merges', 'post', 'repos/merge', 'Merge a branch', 'rest/reference/repos#merge-a-branch', [], [['base', str], ['head', str], ['commit_message', str]], ''),
 ('/repos/{owner}/{repo}/milestones', 'get', 'issues/list-milestones', 'List milestones', 'rest/reference/issues#list-milestones', ['state', 'sort', 'direction', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/milestones', 'post', 'issues/create-milestone', 'Create a milestone', 'rest/reference/issues#create-a-milestone', [], [['title', str], ['state', str, 'open'], ['description', str], ['due_on', str]], ''),
 ('/repos/{owner}/{repo}/milestones/{milestone_number}', 'get', 'issues/get-milestone', 'Get a milestone', 'rest/reference/issues#get-a-milestone', [], [], ''),
 ('/repos/{owner}/{repo}/milestones/{milestone_number}', 'patch', 'issues/update-milestone', 'Update a milestone', 'rest/reference/issues#update-a-milestone', [], [['title', str], ['state', str, 'open'], ['description', str], ['due_on', str]], ''),
 ('/repos/{owner}/{repo}/milestones/{milestone_number}', 'delete', 'issues/delete-milestone', 'Delete a milestone', 'rest/reference/issues#delete-a-milestone', [], [], ''),
 ('/repos/{owner}/{repo}/milestones/{milestone_number}/labels', 'get', 'issues/list-labels-for-milestone', 'List labels for issues in a milestone', 'rest/reference/issues#list-labels-for-issues-in-a-milestone', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/notifications', 'get', 'activity/list-repo-notifications-for-authenticated-user', 'List repository notifications for the authenticated user', 'rest/reference/activity#list-repository-notifications-for-the-authenticated-user', ['all', 'participating', 'since', 'before', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/notifications', 'put', 'activity/mark-repo-notifications-as-read', 'Mark repository notifications as read', 'rest/reference/activity#mark-repository-notifications-as-read', [], [['last_read_at', str]], ''),
 ('/repos/{owner}/{repo}/pages', 'get', 'repos/get-pages', 'Get a GitHub Pages site', 'rest/reference/repos#get-a-github-pages-site', [], [], ''),
 ('/repos/{owner}/{repo}/pages', 'post', 'repos/create-pages-site', 'Create a GitHub Pages site', 'rest/reference/repos#create-a-github-pages-site', [], [['source', dict]], 'switcheroo'),
 ('/repos/{owner}/{repo}/pages', 'put', 'repos/update-information-about-pages-site', 'Update information about a GitHub Pages site', 'rest/reference/repos#update-information-about-a-github-pages-site', [], [['cname', str], ['source', object]], ''),
 ('/repos/{owner}/{repo}/pages', 'delete', 'repos/delete-pages-site', 'Delete a GitHub Pages site', 'rest/reference/repos#delete-a-github-pages-site', [], [], 'switcheroo'),
 ('/repos/{owner}/{repo}/pages/builds', 'get', 'repos/list-pages-builds', 'List GitHub Pages builds', 'rest/reference/repos#list-github-pages-builds', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pages/builds', 'post', 'repos/request-pages-build', 'Request a GitHub Pages build', 'rest/reference/repos#request-a-github-pages-build', [], [], ''),
 ('/repos/{owner}/{repo}/pages/builds/latest', 'get', 'repos/get-latest-pages-build', 'Get latest Pages build', 'rest/reference/repos#get-latest-pages-build', [], [], ''),
 ('/repos/{owner}/{repo}/pages/builds/{build_id}', 'get', 'repos/get-pages-build', 'Get GitHub Pages build', 'rest/reference/repos#get-github-pages-build', [], [], ''),
 ('/repos/{owner}/{repo}/projects', 'get', 'projects/list-for-repo', 'List repository projects', 'v3/projects/#list-repository-projects', ['state', 'per_page', 'page'], [], 'inertia'),
 ('/repos/{owner}/{repo}/projects', 'post', 'projects/create-for-repo', 'Create a repository project', 'v3/projects/#create-a-repository-project', [], [['name', str], ['body', str]], 'inertia'),
 ('/repos/{owner}/{repo}/pulls', 'get', 'pulls/list', 'List pull requests', 'v3/pulls/#list-pull-requests', ['state', 'head', 'base', 'sort', 'direction', 'per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls', 'post', 'pulls/create', 'Create a pull request', 'v3/pulls/#create-a-pull-request', [], [['title', str], ['head', str], ['base', str], ['body', str], ['maintainer_can_modify', bool], ['draft', bool], ['issue', int]], ''),
 ('/repos/{owner}/{repo}/pulls/comments', 'get', 'pulls/list-review-comments-for-repo', 'List review comments in a repository', 'rest/reference/pulls#list-review-comments-in-a-repository', ['sort', 'direction', 'since', 'per_page', 'page'], [], 'comfort-fade'),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}', 'get', 'pulls/get-review-comment', 'Get a review comment for a pull request', 'rest/reference/pulls#get-a-review-comment-for-a-pull-request', [], [], 'comfort-fade'),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}', 'patch', 'pulls/update-review-comment', 'Update a review comment for a pull request', 'rest/reference/pulls#update-a-review-comment-for-a-pull-request', [], [['body', str]], 'comfort-fade'),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}', 'delete', 'pulls/delete-review-comment', 'Delete a review comment for a pull request', 'rest/reference/pulls#delete-a-review-comment-for-a-pull-request', [], [], ''),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions', 'get', 'reactions/list-for-pull-request-review-comment', 'List reactions for a pull request review comment', 'v3/reactions/#list-reactions-for-a-pull-request-review-comment', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions', 'post', 'reactions/create-for-pull-request-review-comment', 'Create reaction for a pull request review comment', 'v3/reactions/#create-reaction-for-a-pull-request-review-comment', [], [['content', str]], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}', 'delete', 'reactions/delete-for-pull-request-comment', 'Delete a pull request comment reaction', 'v3/reactions/#delete-a-pull-request-comment-reaction', [], [], 'squirrel-girl'),
 ('/repos/{owner}/{repo}/pulls/{pull_number}', 'get', 'pulls/get', 'Get a pull request', 'v3/pulls/#get-a-pull-request', [], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}', 'patch', 'pulls/update', 'Update a pull request', 'v3/pulls/#update-a-pull-request', [], [['title', str], ['body', str], ['state', str], ['base', str], ['maintainer_can_modify', bool]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/comments', 'get', 'pulls/list-review-comments', 'List review comments on a pull request', 'rest/reference/pulls#list-review-comments-on-a-pull-request', ['sort', 'direction', 'since', 'per_page', 'page'], [], 'comfort-fade'),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/comments',
  'post',
  'pulls/create-review-comment',
  'Create a review comment for a pull request',
  'rest/reference/pulls#create-a-review-comment-for-a-pull-request',
  [],
  [['body', str], ['commit_id', str], ['path', str], ['position', int], ['side', str], ['line', int], ['start_line', int], ['start_side', str], ['in_reply_to', int]],
  'comfort-fade'),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies', 'post', 'pulls/create-reply-for-review-comment', 'Create a reply for a review comment', 'rest/reference/pulls#create-a-reply-for-a-review-comment', [], [['body', str]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/commits', 'get', 'pulls/list-commits', 'List commits on a pull request', 'v3/pulls/#list-commits-on-a-pull-request', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/files', 'get', 'pulls/list-files', 'List pull requests files', 'v3/pulls/#list-pull-requests-files', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/merge', 'get', 'pulls/check-if-merged', 'Check if a pull request has been merged', 'v3/pulls/#check-if-a-pull-request-has-been-merged', [], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/merge', 'put', 'pulls/merge', 'Merge a pull request', 'v3/pulls/#merge-a-pull-request', [], [['commit_title', str], ['commit_message', str], ['sha', str], ['merge_method', str]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers', 'get', 'pulls/list-requested-reviewers', 'List requested reviewers for a pull request', 'rest/reference/pulls#list-requested-reviewers-for-a-pull-request', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers', 'post', 'pulls/request-reviewers', 'Request reviewers for a pull request', 'rest/reference/pulls#request-reviewers-for-a-pull-request', [], [['reviewers', list], ['team_reviewers', list]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers', 'delete', 'pulls/remove-requested-reviewers', 'Remove requested reviewers from a pull request', 'rest/reference/pulls#remove-requested-reviewers-from-a-pull-request', [], [['reviewers', list], ['team_reviewers', list]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews', 'get', 'pulls/list-reviews', 'List reviews for a pull request', 'rest/reference/pulls#list-reviews-for-a-pull-request', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews', 'post', 'pulls/create-review', 'Create a review for a pull request', 'rest/reference/pulls#create-a-review-for-a-pull-request', [], [['commit_id', str], ['body', str], ['event', str], ['comments', list]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}', 'get', 'pulls/get-review', 'Get a review for a pull request', 'rest/reference/pulls#get-a-review-for-a-pull-request', [], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}', 'put', 'pulls/update-review', 'Update a review for a pull request', 'rest/reference/pulls#update-a-review-for-a-pull-request', [], [['body', str]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}', 'delete', 'pulls/delete-pending-review', 'Delete a pending review for a pull request', 'rest/reference/pulls#delete-a-pending-review-for-a-pull-request', [], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments', 'get', 'pulls/list-comments-for-review', 'List comments for a pull request review', 'rest/reference/pulls#list-comments-for-a-pull-request-review', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals', 'put', 'pulls/dismiss-review', 'Dismiss a review for a pull request', 'rest/reference/pulls#dismiss-a-review-for-a-pull-request', [], [['message', str], ['event', str]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events', 'post', 'pulls/submit-review', 'Submit a review for a pull request', 'rest/reference/pulls#submit-a-review-for-a-pull-request', [], [['body', str], ['event', str]], ''),
 ('/repos/{owner}/{repo}/pulls/{pull_number}/update-branch', 'put', 'pulls/update-branch', 'Update a pull request branch', 'v3/pulls/#update-a-pull-request-branch', [], [['expected_head_sha', str]], 'lydian'),
 ('/repos/{owner}/{repo}/readme', 'get', 'repos/get-readme', 'Get a repository README', 'rest/reference/repos#get-a-repository-readme', ['ref'], [], ''),
 ('/repos/{owner}/{repo}/releases', 'get', 'repos/list-releases', 'List releases', 'rest/reference/repos#list-releases', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/releases', 'post', 'repos/create-release', 'Create a release', 'rest/reference/repos#create-a-release', [], [['tag_name', str], ['target_commitish', str], ['name', str], ['body', str], ['draft', bool, False], ['prerelease', bool, False]], ''),
 ('/repos/{owner}/{repo}/releases/assets/{asset_id}', 'get', 'repos/get-release-asset', 'Get a release asset', 'rest/reference/repos#get-a-release-asset', [], [], ''),
 ('/repos/{owner}/{repo}/releases/assets/{asset_id}', 'patch', 'repos/update-release-asset', 'Update a release asset', 'rest/reference/repos#update-a-release-asset', [], [['name', str], ['label', str], ['state', str]], ''),
 ('/repos/{owner}/{repo}/releases/assets/{asset_id}', 'delete', 'repos/delete-release-asset', 'Delete a release asset', 'rest/reference/repos#delete-a-release-asset', [], [], ''),
 ('/repos/{owner}/{repo}/releases/latest', 'get', 'repos/get-latest-release', 'Get the latest release', 'rest/reference/repos#get-the-latest-release', [], [], ''),
 ('/repos/{owner}/{repo}/releases/tags/{tag}', 'get', 'repos/get-release-by-tag', 'Get a release by tag name', 'rest/reference/repos#get-a-release-by-tag-name', [], [], ''),
 ('/repos/{owner}/{repo}/releases/{release_id}', 'get', 'repos/get-release', 'Get a release', 'rest/reference/repos#get-a-release', [], [], ''),
 ('/repos/{owner}/{repo}/releases/{release_id}', 'patch', 'repos/update-release', 'Update a release', 'rest/reference/repos#update-a-release', [], [['tag_name', str], ['target_commitish', str], ['name', str], ['body', str], ['draft', bool], ['prerelease', bool]], ''),
 ('/repos/{owner}/{repo}/releases/{release_id}', 'delete', 'repos/delete-release', 'Delete a release', 'rest/reference/repos#delete-a-release', [], [], ''),
 ('/repos/{owner}/{repo}/releases/{release_id}/assets', 'get', 'repos/list-release-assets', 'List release assets', 'rest/reference/repos#list-release-assets', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/releases/{release_id}/assets', 'post', 'repos/upload-release-asset', 'Upload a release asset', 'rest/reference/repos#upload-a-release-asset', ['name', 'label'], [], ''),
 ('/repos/{owner}/{repo}/stargazers', 'get', 'activity/list-stargazers-for-repo', 'List stargazers', 'rest/reference/activity#list-stargazers', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/stats/code_frequency', 'get', 'repos/get-code-frequency-stats', 'Get the weekly commit activity', 'rest/reference/repos#get-the-weekly-commit-activity', [], [], ''),
 ('/repos/{owner}/{repo}/stats/commit_activity', 'get', 'repos/get-commit-activity-stats', 'Get the last year of commit activity', 'rest/reference/repos#get-the-last-year-of-commit-activity', [], [], ''),
 ('/repos/{owner}/{repo}/stats/contributors', 'get', 'repos/get-contributors-stats', 'Get all contributor commit activity', 'rest/reference/repos#get-all-contributor-commit-activity', [], [], ''),
 ('/repos/{owner}/{repo}/stats/participation', 'get', 'repos/get-participation-stats', 'Get the weekly commit count', 'rest/reference/repos#get-the-weekly-commit-count', [], [], ''),
 ('/repos/{owner}/{repo}/stats/punch_card', 'get', 'repos/get-punch-card-stats', 'Get the hourly commit count for each day', 'rest/reference/repos#get-the-hourly-commit-count-for-each-day', [], [], ''),
 ('/repos/{owner}/{repo}/statuses/{sha}', 'post', 'repos/create-commit-status', 'Create a commit status', 'rest/reference/repos#create-a-commit-status', [], [['state', str], ['target_url', str], ['description', str], ['context', str, 'default']], ''),
 ('/repos/{owner}/{repo}/subscribers', 'get', 'activity/list-watchers-for-repo', 'List watchers', 'rest/reference/activity#list-watchers', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/subscription', 'get', 'activity/get-repo-subscription', 'Get a repository subscription', 'rest/reference/activity#get-a-repository-subscription', [], [], ''),
 ('/repos/{owner}/{repo}/subscription', 'put', 'activity/set-repo-subscription', 'Set a repository subscription', 'rest/reference/activity#set-a-repository-subscription', [], [['subscribed', bool], ['ignored', bool]], ''),
 ('/repos/{owner}/{repo}/subscription', 'delete', 'activity/delete-repo-subscription', 'Delete a repository subscription', 'rest/reference/activity#delete-a-repository-subscription', [], [], ''),
 ('/repos/{owner}/{repo}/tags', 'get', 'repos/list-tags', 'List repository tags', 'v3/repos/#list-repository-tags', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/tarball/{ref}', 'get', 'repos/download-tarball-archive', 'Download a repository archive (tar)', 'rest/reference/repos#download-a-repository-archive', [], [], ''),
 ('/repos/{owner}/{repo}/teams', 'get', 'repos/list-teams', 'List repository teams', 'v3/repos/#list-repository-teams', ['per_page', 'page'], [], ''),
 ('/repos/{owner}/{repo}/topics', 'get', 'repos/get-all-topics', 'Get all repository topics', 'v3/repos/#get-all-repository-topics', [], [], 'mercy'),
 ('/repos/{owner}/{repo}/topics', 'put', 'repos/replace-all-topics', 'Replace all repository topics', 'v3/repos/#replace-all-repository-topics', [], [['names', list]], 'mercy'),
 ('/repos/{owner}/{repo}/traffic/clones', 'get', 'repos/get-clones', 'Get repository clones', 'rest/reference/repos#get-repository-clones', ['per'], [], ''),
 ('/repos/{owner}/{repo}/traffic/popular/paths', 'get', 'repos/get-top-paths', 'Get top referral paths', 'rest/reference/repos#get-top-referral-paths', [], [], ''),
 ('/repos/{owner}/{repo}/traffic/popular/referrers', 'get', 'repos/get-top-referrers', 'Get top referral sources', 'rest/reference/repos#get-top-referral-sources', [], [], ''),
 ('/repos/{owner}/{repo}/traffic/views', 'get', 'repos/get-views', 'Get page views', 'rest/reference/repos#get-page-views', ['per'], [], ''),
 ('/repos/{owner}/{repo}/transfer', 'post', 'repos/transfer', 'Transfer a repository', 'v3/repos/#transfer-a-repository', [], [['new_owner', str], ['team_ids', list]], ''),
 ('/repos/{owner}/{repo}/vulnerability-alerts', 'get', 'repos/check-vulnerability-alerts', 'Check if vulnerability alerts are enabled for a repository', 'v3/repos/#check-if-vulnerability-alerts-are-enabled-for-a-repository', [], [], 'dorian'),
 ('/repos/{owner}/{repo}/vulnerability-alerts', 'put', 'repos/enable-vulnerability-alerts', 'Enable vulnerability alerts', 'v3/repos/#enable-vulnerability-alerts', [], [], 'dorian'),
 ('/repos/{owner}/{repo}/vulnerability-alerts', 'delete', 'repos/disable-vulnerability-alerts', 'Disable vulnerability alerts', 'v3/repos/#disable-vulnerability-alerts', [], [], 'dorian'),
 ('/repos/{owner}/{repo}/zipball/{ref}', 'get', 'repos/download-zipball-archive', 'Download a repository archive (zip)', 'rest/reference/repos#download-a-repository-archive', [], [], ''),
 ('/repos/{template_owner}/{template_repo}/generate', 'post', 'repos/create-using-template', 'Create a repository using a template', 'v3/repos/#create-a-repository-using-a-template', [], [['owner', str], ['name', str], ['description', str], ['include_all_branches', bool, False], ['private', bool, False]], 'baptiste'),
 ('/repositories', 'get', 'repos/list-public', 'List public repositories', 'v3/repos/#list-public-repositories', ['since'], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups', 'get', 'enterprise-admin/list-provisioned-groups-enterprise', 'List provisioned SCIM groups for an enterprise', 'rest/reference/enterprise-admin#list-provisioned-scim groups-for-an-enterprise', ['startIndex', 'count'], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups', 'post', 'enterprise-admin/provision-and-invite-enterprise-group', 'Provision a SCIM enterprise group and invite users', 'rest/reference/enterprise-admin#provision-a-scim-enterprise-group-and-invite-users', [], [['schemas', list], ['displayName', str], ['members', list]], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}', 'get', 'enterprise-admin/get-provisioning-information-for-enterprise-group', 'Get SCIM provisioning information for an enterprise group', 'rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise group', [], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}', 'put', 'enterprise-admin/set-information-for-provisioned-enterprise-group', 'Set SCIM information for a provisioned enterprise group', 'rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-group', [], [['schemas', list], ['displayName', str], ['members', list]], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}', 'patch', 'enterprise-admin/update-attribute-for-enterprise-group', 'Update an attribute for a SCIM enterprise group', 'rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-group', [], [['schemas', list], ['Operations', list]], ''),
 ('/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}', 'delete', 'enterprise-admin/delete-scim-group-from-enterprise', 'Delete a SCIM group from an enterprise', 'rest/reference/enterprise-admin#delete-a-scim-group-from-an-enterprise', [], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Users', 'get', 'enterprise-admin/list-provisioned-identities-enterprise', 'List SCIM provisioned identities for an enterprise', 'rest/reference/enterprise-admin#list-scim-provisioned-identities-for-an-enterprise', ['startIndex', 'count'], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Users', 'post', 'enterprise-admin/provision-and-invite-enterprise-user', 'Provision and invite a SCIM enterprise user', 'rest/reference/enterprise-admin#provision-and-invite-a-scim-enterprise-user', [], [['schemas', list], ['userName', str], ['name', dict], ['emails', list], ['groups', list]], ''),
 ('/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}', 'get', 'enterprise-admin/get-provisioning-information-for-enterprise-user', 'Get SCIM provisioning information for an enterprise user', 'rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise-user', [], [], ''),
 ('/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}',
  'put',
  'enterprise-admin/set-information-for-provisioned-enterprise-user',
  'Set SCIM information for a provisioned enterprise user',
  'rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-user',
  [],
  [['schemas', list], ['userName', str], ['name', dict], ['emails', list], ['groups', list]],
  ''),
 ('/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}', 'patch', 'enterprise-admin/update-attribute-for-enterprise-user', 'Update an attribute for a SCIM enterprise user', 'rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-user', [], [['schemas', list], ['Operations', list]], ''),
 ('/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}', 'delete', 'enterprise-admin/delete-user-from-enterprise', 'Delete a SCIM user from an enterprise', 'rest/reference/enterprise-admin#delete-a-scim-user-from-an-enterprise', [], [], ''),
 ('/scim/v2/organizations/{org}/Users', 'get', 'scim/list-provisioned-identities', 'List SCIM provisioned identities', 'v3/scim/#list-scim-provisioned-identities', ['startIndex', 'count', 'filter'], [], ''),
 ('/scim/v2/organizations/{org}/Users', 'post', 'scim/provision-and-invite-user', 'Provision and invite a SCIM user', 'v3/scim/#provision-and-invite-a-scim-user', [], [['userName', str], ['displayName', str], ['name', dict], ['emails', list], ['schemas', list], ['externalId', str], ['groups', list], ['active', bool]], ''),
 ('/scim/v2/organizations/{org}/Users/{scim_user_id}', 'get', 'scim/get-provisioning-information-for-user', 'Get SCIM provisioning information for a user', 'v3/scim/#get-scim-provisioning-information-for-a-user', [], [], ''),
 ('/scim/v2/organizations/{org}/Users/{scim_user_id}',
  'put',
  'scim/set-information-for-provisioned-user',
  'Update a provisioned organization membership',
  'v3/scim/#set-scim-information-for-a-provisioned-user',
  [],
  [['schemas', list], ['displayName', str], ['externalId', str], ['groups', list], ['active', bool], ['userName', str], ['name', dict], ['emails', list]],
  ''),
 ('/scim/v2/organizations/{org}/Users/{scim_user_id}', 'patch', 'scim/update-attribute-for-user', 'Update an attribute for a SCIM user', 'v3/scim/#update-an-attribute-for-a-scim-user', [], [['schemas', list], ['Operations', list]], ''),
 ('/scim/v2/organizations/{org}/Users/{scim_user_id}', 'delete', 'scim/delete-user-from-org', 'Delete a SCIM user from an organization', 'v3/scim/#delete-a-scim-user-from-an-organization', [], [], ''),
 ('/search/code', 'get', 'search/code', 'Search code', 'v3/search/#search-code', ['q', 'sort', 'order', 'per_page', 'page'], [], ''),
 ('/search/commits', 'get', 'search/commits', 'Search commits', 'v3/search/#search-commits', ['q', 'sort', 'order', 'per_page', 'page'], [], 'cloak'),
 ('/search/issues', 'get', 'search/issues-and-pull-requests', 'Search issues and pull requests', 'v3/search/#search-issues-and-pull-requests', ['q', 'sort', 'order', 'per_page', 'page'], [], ''),
 ('/search/labels', 'get', 'search/labels', 'Search labels', 'v3/search/#search-labels', ['repository_id', 'q', 'sort', 'order'], [], ''),
 ('/search/repositories', 'get', 'search/repos', 'Search repositories', 'v3/search/#search-repositories', ['q', 'sort', 'order', 'per_page', 'page'], [], 'mercy'),
 ('/search/topics', 'get', 'search/topics', 'Search topics', 'v3/search/#search-topics', ['q'], [], 'mercy'),
 ('/search/users', 'get', 'search/users', 'Search users', 'v3/search/#search-users', ['q', 'sort', 'order', 'per_page', 'page'], [], ''),
 ('/teams/{team_id}', 'get', 'teams/get-legacy', 'Get a team (Legacy)', 'v3/teams/#get-a-team-legacy', [], [], ''),
 ('/teams/{team_id}', 'patch', 'teams/update-legacy', 'Update a team (Legacy)', 'v3/teams/#update-a-team-legacy', [], [['name', str], ['description', str], ['privacy', str], ['permission', str, 'pull'], ['parent_team_id', int]], ''),
 ('/teams/{team_id}', 'delete', 'teams/delete-legacy', 'Delete a team (Legacy)', 'v3/teams/#delete-a-team-legacy', [], [], ''),
 ('/teams/{team_id}/discussions', 'get', 'teams/list-discussions-legacy', 'List discussions (Legacy)', 'rest/reference/teams#list-discussions-legacy', ['direction', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions', 'post', 'teams/create-discussion-legacy', 'Create a discussion (Legacy)', 'rest/reference/teams#create-a-discussion-legacy', [], [['title', str], ['body', str], ['private', bool, False]], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}', 'get', 'teams/get-discussion-legacy', 'Get a discussion (Legacy)', 'rest/reference/teams#get-a-discussion-legacy', [], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}', 'patch', 'teams/update-discussion-legacy', 'Update a discussion (Legacy)', 'rest/reference/teams#update-a-discussion-legacy', [], [['title', str], ['body', str]], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}', 'delete', 'teams/delete-discussion-legacy', 'Delete a discussion (Legacy)', 'rest/reference/teams#delete-a-discussion-legacy', [], [], ''),
 ('/teams/{team_id}/discussions/{discussion_number}/comments', 'get', 'teams/list-discussion-comments-legacy', 'List discussion comments (Legacy)', 'rest/reference/teams#list-discussion-comments-legacy', ['direction', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/comments', 'post', 'teams/create-discussion-comment-legacy', 'Create a discussion comment (Legacy)', 'rest/reference/teams#create-a-discussion-comment-legacy', [], [['body', str]], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}', 'get', 'teams/get-discussion-comment-legacy', 'Get a discussion comment (Legacy)', 'rest/reference/teams#get-a-discussion-comment-legacy', [], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}', 'patch', 'teams/update-discussion-comment-legacy', 'Update a discussion comment (Legacy)', 'rest/reference/teams#update-a-discussion-comment-legacy', [], [['body', str]], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}', 'delete', 'teams/delete-discussion-comment-legacy', 'Delete a discussion comment (Legacy)', 'rest/reference/teams#delete-a-discussion-comment-legacy', [], [], ''),
 ('/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions', 'get', 'reactions/list-for-team-discussion-comment-legacy', 'List reactions for a team discussion comment (Legacy)', 'v3/reactions/#list-reactions-for-a-team-discussion-comment-legacy', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions', 'post', 'reactions/create-for-team-discussion-comment-legacy', 'Create reaction for a team discussion comment (Legacy)', 'v3/reactions/#create-reaction-for-a-team-discussion-comment-legacy', [], [['content', str]], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/reactions', 'get', 'reactions/list-for-team-discussion-legacy', 'List reactions for a team discussion (Legacy)', 'v3/reactions/#list-reactions-for-a-team-discussion-legacy', ['content', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/teams/{team_id}/discussions/{discussion_number}/reactions', 'post', 'reactions/create-for-team-discussion-legacy', 'Create reaction for a team discussion (Legacy)', 'v3/reactions/#create-reaction-for-a-team-discussion-legacy', [], [['content', str]], 'squirrel-girl'),
 ('/teams/{team_id}/invitations', 'get', 'teams/list-pending-invitations-legacy', 'List pending team invitations (Legacy)', 'rest/reference/teams#list-pending-team-invitations-legacy', ['per_page', 'page'], [], ''),
 ('/teams/{team_id}/members', 'get', 'teams/list-members-legacy', 'List team members (Legacy)', 'rest/reference/teams#list-team-members-legacy', ['role', 'per_page', 'page'], [], ''),
 ('/teams/{team_id}/members/{username}', 'get', 'teams/get-member-legacy', 'Get team member (Legacy)', 'rest/reference/teams#get-team-member-legacy', [], [], ''),
 ('/teams/{team_id}/members/{username}', 'put', 'teams/add-member-legacy', 'Add team member (Legacy)', 'rest/reference/teams#add-team-member-legacy', [], [], ''),
 ('/teams/{team_id}/members/{username}', 'delete', 'teams/remove-member-legacy', 'Remove team member (Legacy)', 'rest/reference/teams#remove-team-member-legacy', [], [], ''),
 ('/teams/{team_id}/memberships/{username}', 'get', 'teams/get-membership-for-user-legacy', 'Get team membership for a user (Legacy)', 'rest/reference/teams#get-team-membership-for-a-user-legacy', [], [], ''),
 ('/teams/{team_id}/memberships/{username}', 'put', 'teams/add-or-update-membership-for-user-legacy', 'Add or update team membership for a user (Legacy)', 'rest/reference/teams#add-or-update-team-membership-for-a-user-legacy', [], [['role', str, 'member']], ''),
 ('/teams/{team_id}/memberships/{username}', 'delete', 'teams/remove-membership-for-user-legacy', 'Remove team membership for a user (Legacy)', 'rest/reference/teams#remove-team-membership-for-a-user-legacy', [], [], ''),
 ('/teams/{team_id}/projects', 'get', 'teams/list-projects-legacy', 'List team projects (Legacy)', 'v3/teams/#list-team-projects-legacy', ['per_page', 'page'], [], 'inertia'),
 ('/teams/{team_id}/projects/{project_id}', 'get', 'teams/check-permissions-for-project-legacy', 'Check team permissions for a project (Legacy)', 'v3/teams/#check-team-permissions-for-a-project-legacy', [], [], 'inertia'),
 ('/teams/{team_id}/projects/{project_id}', 'put', 'teams/add-or-update-project-permissions-legacy', 'Add or update team project permissions (Legacy)', 'v3/teams/#add-or-update-team-project-permissions-legacy', [], [['permission', str]], 'inertia'),
 ('/teams/{team_id}/projects/{project_id}', 'delete', 'teams/remove-project-legacy', 'Remove a project from a team (Legacy)', 'v3/teams/#remove-a-project-from-a-team-legacy', [], [], ''),
 ('/teams/{team_id}/repos', 'get', 'teams/list-repos-legacy', 'List team repositories (Legacy)', 'v3/teams/#list-team-repositories-legacy', ['per_page', 'page'], [], ''),
 ('/teams/{team_id}/repos/{owner}/{repo}', 'get', 'teams/check-permissions-for-repo-legacy', 'Check team permissions for a repository (Legacy)', 'v3/teams/#check-team-permissions-for-a-repository-legacy', [], [], ''),
 ('/teams/{team_id}/repos/{owner}/{repo}', 'put', 'teams/add-or-update-repo-permissions-legacy', 'Add or update team repository permissions (Legacy)', 'v3/teams/#add-or-update-team-repository-permissions-legacy', [], [['permission', str]], ''),
 ('/teams/{team_id}/repos/{owner}/{repo}', 'delete', 'teams/remove-repo-legacy', 'Remove a repository from a team (Legacy)', 'v3/teams/#remove-a-repository-from-a-team-legacy', [], [], ''),
 ('/teams/{team_id}/team-sync/group-mappings', 'get', 'teams/list-idp-groups-for-legacy', 'List IdP groups for a team (Legacy)', 'rest/reference/teams#list-idp-groups-for-a-team-legacy', [], [], ''),
 ('/teams/{team_id}/team-sync/group-mappings', 'patch', 'teams/create-or-update-idp-group-connections-legacy', 'Create or update IdP group connections (Legacy)', 'rest/reference/teams#create-or-update-idp-group-connections-legacy', [], [['groups', list], ['synced_at', str]], ''),
 ('/teams/{team_id}/teams', 'get', 'teams/list-child-legacy', 'List child teams (Legacy)', 'v3/teams/#list-child-teams-legacy', ['per_page', 'page'], [], ''),
 ('/user', 'get', 'users/get-authenticated', 'Get the authenticated user', 'v3/users/#get-the-authenticated-user', [], [], ''),
 ('/user', 'patch', 'users/update-authenticated', 'Update the authenticated user', 'v3/users/#update-the-authenticated-user', [], [['name', str], ['email', str], ['blog', str], ['twitter_username', str], ['company', str], ['location', str], ['hireable', bool], ['bio', str]], ''),
 ('/user/blocks', 'get', 'users/list-blocked-by-authenticated', 'List users blocked by the authenticated user', 'rest/reference/users#list-users-blocked-by-the-authenticated-user', [], [], ''),
 ('/user/blocks/{username}', 'get', 'users/check-blocked', 'Check if a user is blocked by the authenticated user', 'rest/reference/users#check-if-a-user-is-blocked-by-the-authenticated-user', [], [], ''),
 ('/user/blocks/{username}', 'put', 'users/block', 'Block a user', 'rest/reference/users#block-a-user', [], [], ''),
 ('/user/blocks/{username}', 'delete', 'users/unblock', 'Unblock a user', 'rest/reference/users#unblock-a-user', [], [], ''),
 ('/user/email/visibility', 'patch', 'users/set-primary-email-visibility-for-authenticated', 'Set primary email visibility for the authenticated user', 'rest/reference/users#set-primary-email-visibility-for-the-authenticated-user', [], [['email', str], ['visibility', str]], ''),
 ('/user/emails', 'get', 'users/list-emails-for-authenticated', 'List email addresses for the authenticated user', 'rest/reference/users#list-email-addresses-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/emails', 'post', 'users/add-email-for-authenticated', 'Add an email address for the authenticated user', 'rest/reference/users#add-an-email-address-for-the-authenticated-user', [], [], ''),
 ('/user/emails', 'delete', 'users/delete-email-for-authenticated', 'Delete an email address for the authenticated user', 'rest/reference/users#delete-an-email-address-for-the-authenticated-user', [], [], ''),
 ('/user/followers', 'get', 'users/list-followers-for-authenticated-user', 'List followers of the authenticated user', 'rest/reference/users#list-followers-of-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/following', 'get', 'users/list-followed-by-authenticated', 'List the people the authenticated user follows', 'rest/reference/users#list-the-people-the-authenticated-user-follows', ['per_page', 'page'], [], ''),
 ('/user/following/{username}', 'get', 'users/check-person-is-followed-by-authenticated', 'Check if a person is followed by the authenticated user', 'rest/reference/users#check-if-a-person-is-followed-by-the-authenticated-user', [], [], ''),
 ('/user/following/{username}', 'put', 'users/follow', 'Follow a user', 'rest/reference/users#follow-a-user', [], [], ''),
 ('/user/following/{username}', 'delete', 'users/unfollow', 'Unfollow a user', 'rest/reference/users#unfollow-a-user', [], [], ''),
 ('/user/gpg_keys', 'get', 'users/list-gpg-keys-for-authenticated', 'List GPG keys for the authenticated user', 'rest/reference/users#list-gpg-keys-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/gpg_keys', 'post', 'users/create-gpg-key-for-authenticated', 'Create a GPG key for the authenticated user', 'rest/reference/users#create-a-gpg-key-for-the-authenticated-user', [], [['armored_public_key', str]], ''),
 ('/user/gpg_keys/{gpg_key_id}', 'get', 'users/get-gpg-key-for-authenticated', 'Get a GPG key for the authenticated user', 'rest/reference/users#get-a-gpg-key-for-the-authenticated-user', [], [], ''),
 ('/user/gpg_keys/{gpg_key_id}', 'delete', 'users/delete-gpg-key-for-authenticated', 'Delete a GPG key for the authenticated user', 'rest/reference/users#delete-a-gpg-key-for-the-authenticated-user', [], [], ''),
 ('/user/installations', 'get', 'apps/list-installations-for-authenticated-user', 'List app installations accessible to the user access token', 'rest/reference/apps#list-app-installations-accessible-to-the-user-access-token', ['per_page', 'page'], [], ''),
 ('/user/installations/{installation_id}/repositories', 'get', 'apps/list-installation-repos-for-authenticated-user', 'List repositories accessible to the user access token', 'rest/reference/apps#list-repositories-accessible-to-the-user-access-token', ['per_page', 'page'], [], 'mercy'),
 ('/user/installations/{installation_id}/repositories/{repository_id}', 'put', 'apps/add-repo-to-installation', 'Add a repository to an app installation', 'rest/reference/apps#add-a-repository-to-an-app-installation', [], [], ''),
 ('/user/installations/{installation_id}/repositories/{repository_id}', 'delete', 'apps/remove-repo-from-installation', 'Remove a repository from an app installation', 'rest/reference/apps#remove-a-repository-from-an-app-installation', [], [], ''),
 ('/user/interaction-limits', 'get', 'interactions/get-restrictions-for-your-public-repos', 'Get interaction restrictions for your public repositories', 'rest/reference/interactions#get-interaction-restrictions-for-your-public-repositories', [], [], ''),
 ('/user/interaction-limits', 'put', 'interactions/set-restrictions-for-your-public-repos', 'Set interaction restrictions for your public repositories', 'rest/reference/interactions#set-interaction-restrictions-for-your-public-repositories', [], [['limit', str], ['expiry', str]], ''),
 ('/user/interaction-limits', 'delete', 'interactions/remove-restrictions-for-your-public-repos', 'Remove interaction restrictions from your public repositories', 'rest/reference/interactions#remove-interaction-restrictions-from-your-public-repositories', [], [], ''),
 ('/user/issues', 'get', 'issues/list-for-authenticated-user', 'List user account issues assigned to the authenticated user', 'v3/issues/#list-user-account-issues-assigned-to-the-authenticated-user', ['filter', 'state', 'labels', 'sort', 'direction', 'since', 'per_page', 'page'], [], 'squirrel-girl'),
 ('/user/keys', 'get', 'users/list-public-ssh-keys-for-authenticated', 'List public SSH keys for the authenticated user', 'rest/reference/users#list-public-ssh-keys-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/keys', 'post', 'users/create-public-ssh-key-for-authenticated', 'Create a public SSH key for the authenticated user', 'rest/reference/users#create-a-public-ssh-key-for-the-authenticated-user', [], [['title', str], ['key', str]], ''),
 ('/user/keys/{key_id}', 'get', 'users/get-public-ssh-key-for-authenticated', 'Get a public SSH key for the authenticated user', 'rest/reference/users#get-a-public-ssh-key-for-the-authenticated-user', [], [], ''),
 ('/user/keys/{key_id}', 'delete', 'users/delete-public-ssh-key-for-authenticated', 'Delete a public SSH key for the authenticated user', 'rest/reference/users#delete-a-public-ssh-key-for-the-authenticated-user', [], [], ''),
 ('/user/marketplace_purchases', 'get', 'apps/list-subscriptions-for-authenticated-user', 'List subscriptions for the authenticated user', 'rest/reference/apps#list-subscriptions-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/marketplace_purchases/stubbed', 'get', 'apps/list-subscriptions-for-authenticated-user-stubbed', 'List subscriptions for the authenticated user (stubbed)', 'rest/reference/apps#list-subscriptions-for-the-authenticated-user-stubbed', ['per_page', 'page'], [], ''),
 ('/user/memberships/orgs', 'get', 'orgs/list-memberships-for-authenticated-user', 'List organization memberships for the authenticated user', 'rest/reference/orgs#list-organization-memberships-for-the-authenticated-user', ['state', 'per_page', 'page'], [], ''),
 ('/user/memberships/orgs/{org}', 'get', 'orgs/get-membership-for-authenticated-user', 'Get an organization membership for the authenticated user', 'rest/reference/orgs#get-an-organization-membership-for-the-authenticated-user', [], [], ''),
 ('/user/memberships/orgs/{org}', 'patch', 'orgs/update-membership-for-authenticated-user', 'Update an organization membership for the authenticated user', 'rest/reference/orgs#update-an-organization-membership-for-the-authenticated-user', [], [['state', str]], ''),
 ('/user/migrations', 'get', 'migrations/list-for-authenticated-user', 'List user migrations', 'rest/reference/migrations#list-user-migrations', ['per_page', 'page'], [], 'wyandotte'),
 ('/user/migrations', 'post', 'migrations/start-for-authenticated-user', 'Start a user migration', 'rest/reference/migrations#start-a-user-migration', [], [['lock_repositories', bool], ['exclude_attachments', bool], ['exclude', list], ['repositories', list]], ''),
 ('/user/migrations/{migration_id}', 'get', 'migrations/get-status-for-authenticated-user', 'Get a user migration status', 'rest/reference/migrations#get-a-user-migration-status', ['exclude'], [], 'wyandotte'),
 ('/user/migrations/{migration_id}/archive', 'get', 'migrations/get-archive-for-authenticated-user', 'Download a user migration archive', 'rest/reference/migrations#download-a-user-migration-archive', [], [], 'wyandotte'),
 ('/user/migrations/{migration_id}/archive', 'delete', 'migrations/delete-archive-for-authenticated-user', 'Delete a user migration archive', 'rest/reference/migrations#delete-a-user-migration-archive', [], [], 'wyandotte'),
 ('/user/migrations/{migration_id}/repos/{repo_name}/lock', 'delete', 'migrations/unlock-repo-for-authenticated-user', 'Unlock a user repository', 'rest/reference/migrations#unlock-a-user-repository', [], [], 'wyandotte'),
 ('/user/migrations/{migration_id}/repositories', 'get', 'migrations/list-repos-for-user', 'List repositories for a user migration', 'rest/reference/migrations#list-repositories-for-a-user-migration', ['per_page', 'page'], [], 'wyandotte'),
 ('/user/orgs', 'get', 'orgs/list-for-authenticated-user', 'List organizations for the authenticated user', 'v3/orgs/#list-organizations-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/projects', 'post', 'projects/create-for-authenticated-user', 'Create a user project', 'v3/projects/#create-a-user-project', [], [['name', str], ['body', str]], 'inertia'),
 ('/user/public_emails', 'get', 'users/list-public-emails-for-authenticated', 'List public email addresses for the authenticated user', 'rest/reference/users#list-public-email-addresses-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/repos', 'get', 'repos/list-for-authenticated-user', 'List repositories for the authenticated user', 'v3/repos/#list-repositories-for-the-authenticated-user', ['visibility', 'affiliation', 'type', 'sort', 'direction', 'per_page', 'page', 'since', 'before'], [], ''),
 ('/user/repos',
  'post',
  'repos/create-for-authenticated-user',
  'Create a repository for the authenticated user',
  'v3/repos/#create-a-repository-for-the-authenticated-user',
  [],
  [['name', str],
   ['description', str],
   ['homepage', str],
   ['private', bool, False],
   ['has_issues', bool, True],
   ['has_projects', bool, True],
   ['has_wiki', bool, True],
   ['team_id', int],
   ['auto_init', bool, False],
   ['gitignore_template', str],
   ['license_template', str],
   ['allow_squash_merge', bool, True],
   ['allow_merge_commit', bool, True],
   ['allow_rebase_merge', bool, True],
   ['delete_branch_on_merge', bool, False],
   ['has_downloads', bool, True],
   ['is_template', bool, False]],
  'nebula'),
 ('/user/repository_invitations', 'get', 'repos/list-invitations-for-authenticated-user', 'List repository invitations for the authenticated user', 'rest/reference/repos#list-repository-invitations-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/repository_invitations/{invitation_id}', 'patch', 'repos/accept-invitation', 'Accept a repository invitation', 'rest/reference/repos#accept-a-repository-invitation', [], [], ''),
 ('/user/repository_invitations/{invitation_id}', 'delete', 'repos/decline-invitation', 'Decline a repository invitation', 'rest/reference/repos#decline-a-repository-invitation', [], [], ''),
 ('/user/starred', 'get', 'activity/list-repos-starred-by-authenticated-user', 'List repositories starred by the authenticated user', 'rest/reference/activity#list-repositories-starred-by-the-authenticated-user', ['sort', 'direction', 'per_page', 'page'], [], ''),
 ('/user/starred/{owner}/{repo}', 'get', 'activity/check-repo-is-starred-by-authenticated-user', 'Check if a repository is starred by the authenticated user', 'rest/reference/activity#check-if-a-repository-is-starred-by-the-authenticated-user', [], [], ''),
 ('/user/starred/{owner}/{repo}', 'put', 'activity/star-repo-for-authenticated-user', 'Star a repository for the authenticated user', 'rest/reference/activity#star-a-repository-for-the-authenticated-user', [], [], ''),
 ('/user/starred/{owner}/{repo}', 'delete', 'activity/unstar-repo-for-authenticated-user', 'Unstar a repository for the authenticated user', 'rest/reference/activity#unstar-a-repository-for-the-authenticated-user', [], [], ''),
 ('/user/subscriptions', 'get', 'activity/list-watched-repos-for-authenticated-user', 'List repositories watched by the authenticated user', 'rest/reference/activity#list-repositories-watched-by-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/user/teams', 'get', 'teams/list-for-authenticated-user', 'List teams for the authenticated user', 'v3/teams/#list-teams-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/users', 'get', 'users/list', 'List users', 'v3/users/#list-users', ['since', 'per_page'], [], ''),
 ('/users/{username}', 'get', 'users/get-by-username', 'Get a user', 'v3/users/#get-a-user', [], [], ''),
 ('/users/{username}/events', 'get', 'activity/list-events-for-authenticated-user', 'List events for the authenticated user', 'rest/reference/activity#list-events-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/events/orgs/{org}', 'get', 'activity/list-org-events-for-authenticated-user', 'List organization events for the authenticated user', 'rest/reference/activity#list-organization-events-for-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/events/public', 'get', 'activity/list-public-events-for-user', 'List public events for a user', 'rest/reference/activity#list-public-events-for-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/followers', 'get', 'users/list-followers-for-user', 'List followers of a user', 'rest/reference/users#list-followers-of-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/following', 'get', 'users/list-following-for-user', 'List the people a user follows', 'rest/reference/users#list-the-people-a-user-follows', ['per_page', 'page'], [], ''),
 ('/users/{username}/following/{target_user}', 'get', 'users/check-following-for-user', 'Check if a user follows another user', 'rest/reference/users#check-if-a-user-follows-another-user', [], [], ''),
 ('/users/{username}/gists', 'get', 'gists/list-for-user', 'List gists for a user', 'v3/gists/#list-gists-for-a-user', ['since', 'per_page', 'page'], [], ''),
 ('/users/{username}/gpg_keys', 'get', 'users/list-gpg-keys-for-user', 'List GPG keys for a user', 'rest/reference/users#list-gpg-keys-for-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/hovercard', 'get', 'users/get-context-for-user', 'Get contextual information for a user', 'v3/users/#get-contextual-information-for-a-user', ['subject_type', 'subject_id'], [], ''),
 ('/users/{username}/installation', 'get', 'apps/get-user-installation', 'Get a user installation for the authenticated app', 'v3/apps/#get-a-user-installation-for-the-authenticated-app', [], [], ''),
 ('/users/{username}/keys', 'get', 'users/list-public-keys-for-user', 'List public keys for a user', 'rest/reference/users#list-public-keys-for-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/orgs', 'get', 'orgs/list-for-user', 'List organizations for a user', 'v3/orgs/#list-organizations-for-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/projects', 'get', 'projects/list-for-user', 'List user projects', 'v3/projects/#list-user-projects', ['state', 'per_page', 'page'], [], 'inertia'),
 ('/users/{username}/received_events', 'get', 'activity/list-received-events-for-user', 'List events received by the authenticated user', 'rest/reference/activity#list-events-received-by-the-authenticated-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/received_events/public', 'get', 'activity/list-received-public-events-for-user', 'List public events received by a user', 'rest/reference/activity#list-public-events-received-by-a-user', ['per_page', 'page'], [], ''),
 ('/users/{username}/repos', 'get', 'repos/list-for-user', 'List repositories for a user', 'v3/repos/#list-repositories-for-a-user', ['type', 'sort', 'direction', 'per_page', 'page'], [], 'nebula'),
 ('/users/{username}/settings/billing/actions', 'get', 'billing/get-github-actions-billing-user', 'Get GitHub Actions billing for a user', 'v3/billing/#get-github-actions-billing-for-a-user', [], [], ''),
 ('/users/{username}/settings/billing/packages', 'get', 'billing/get-github-packages-billing-user', 'Get GitHub Packages billing for a user', 'v3/billing/#get-github-packages-billing-for-a-user', [], [], ''),
 ('/users/{username}/settings/billing/shared-storage', 'get', 'billing/get-shared-storage-billing-user', 'Get shared storage billing for a user', 'v3/billing/#get-shared-storage-billing-for-a-user', [], [], ''),
 ('/users/{username}/starred', 'get', 'activity/list-repos-starred-by-user', 'List repositories starred by a user', 'rest/reference/activity#list-repositories-starred-by-a-user', ['sort', 'direction', 'per_page', 'page'], [], ''),
 ('/users/{username}/subscriptions', 'get', 'activity/list-repos-watched-by-user', 'List repositories watched by a user', 'rest/reference/activity#list-repositories-watched-by-a-user', ['per_page', 'page'], [], '')]