"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const grafana_dashboard_1 = require("./imports/grafana-dashboard");
/**
 * A Grafana dashboard.
 * @see https://grafana.com/docs/grafana/latest/http_api/dashboard/
 */
class Dashboard extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.plugins = [];
        const refreshRate = props.refreshRate ?? cdk8s_1.Duration.seconds(5);
        const timeRange = props.timeRange ?? cdk8s_1.Duration.hours(6);
        const dataSources = Object.entries(props.dataSourceVariables ?? {}).map(([variable, name]) => ({ datasourceName: name, inputName: variable }));
        const defaults = {
            title: props.title,
            id: null,
            tags: [],
            style: 'dark',
            timezone: 'browser',
            editable: true,
            hideControls: false,
            graphTooltip: 1,
            panels: [],
            time: {
                from: `now-${timeRange.toSeconds()}s`,
                to: 'now',
            },
            timepicker: {
                time_options: [],
                refresh_intervals: [],
            },
            templating: {
                list: [],
            },
            annotations: {
                list: [],
            },
            refresh: `${refreshRate.toSeconds()}s`,
            schemaVersion: 17,
            version: 0,
            links: [],
        };
        new grafana_dashboard_1.GrafanaDashboard(this, 'Resource', {
            metadata: {
                labels: props.labels,
                namespace: props.namespace,
            },
            spec: {
                customFolderName: props.folder,
                datasources: dataSources,
                plugins: this.plugins,
                json: JSON.stringify({
                    ...defaults,
                    ...props.jsonModel,
                }, null, 2),
            },
        });
        if (props.plugins) {
            this.addPlugins(...props.plugins);
        }
    }
    /**
     * Adds one or more plugins.
     */
    addPlugins(...plugins) {
        for (const plugin of plugins) {
            this.plugins.push(plugin);
        }
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "cdk8s-grafana.Dashboard", version: "0.1.717" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGFzaGJvYXJkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2Rhc2hib2FyZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUFpQztBQUNqQywyQ0FBdUM7QUFDdkMsbUVBQStEO0FBcUUvRDs7O0dBR0c7QUFDSCxNQUFhLFNBQVUsU0FBUSxzQkFBUztJQUV0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXFCO1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUM7UUFFbEIsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsSUFBSSxnQkFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM3RCxNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxJQUFJLGdCQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3ZELE1BQU0sV0FBVyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLG1CQUFtQixJQUFJLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FDckUsQ0FBQyxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsU0FBUyxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQ3RFLENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixFQUFFLEVBQUUsSUFBSTtZQUNSLElBQUksRUFBRSxFQUFFO1lBQ1IsS0FBSyxFQUFFLE1BQU07WUFDYixRQUFRLEVBQUUsU0FBUztZQUNuQixRQUFRLEVBQUUsSUFBSTtZQUNkLFlBQVksRUFBRSxLQUFLO1lBQ25CLFlBQVksRUFBRSxDQUFDO1lBQ2YsTUFBTSxFQUFFLEVBQUU7WUFDVixJQUFJLEVBQUU7Z0JBQ0osSUFBSSxFQUFFLE9BQU8sU0FBUyxDQUFDLFNBQVMsRUFBRSxHQUFHO2dCQUNyQyxFQUFFLEVBQUUsS0FBSzthQUNWO1lBQ0QsVUFBVSxFQUFFO2dCQUNWLFlBQVksRUFBRSxFQUFFO2dCQUNoQixpQkFBaUIsRUFBRSxFQUFFO2FBQ3RCO1lBQ0QsVUFBVSxFQUFFO2dCQUNWLElBQUksRUFBRSxFQUFFO2FBQ1Q7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsSUFBSSxFQUFFLEVBQUU7YUFDVDtZQUNELE9BQU8sRUFBRSxHQUFHLFdBQVcsQ0FBQyxTQUFTLEVBQUUsR0FBRztZQUN0QyxhQUFhLEVBQUUsRUFBRTtZQUNqQixPQUFPLEVBQUUsQ0FBQztZQUNWLEtBQUssRUFBRSxFQUFFO1NBQ0gsQ0FBQztRQUVULElBQUksb0NBQWdCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNyQyxRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO2dCQUNwQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7YUFDM0I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLE1BQU07Z0JBQzlCLFdBQVcsRUFBRSxXQUFXO2dCQUN4QixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87Z0JBQ3JCLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO29CQUNuQixHQUFHLFFBQVE7b0JBQ1gsR0FBRyxLQUFLLENBQUMsU0FBUztpQkFDbkIsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO2FBQ1o7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUNsQixJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3BDLENBQUM7SUFDSCxDQUFDO0lBRUQ7O09BRUc7SUFDSSxVQUFVLENBQUMsR0FBRyxPQUF3QjtRQUMzQyxLQUFLLE1BQU0sTUFBTSxJQUFJLE9BQU8sRUFBRSxDQUFDO1lBQzdCLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzVCLENBQUM7SUFDSCxDQUFDOztBQXZFSCw4QkF3RUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEdXJhdGlvbiB9IGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgR3JhZmFuYURhc2hib2FyZCB9IGZyb20gJy4vaW1wb3J0cy9ncmFmYW5hLWRhc2hib2FyZCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGFzaGJvYXJkUHJvcHMge1xuICAvKipcbiAgICogVGl0bGUgb2YgdGhlIGRhc2hib2FyZC5cbiAgICovXG4gIHJlYWRvbmx5IHRpdGxlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdyb3VwIGRhc2hib2FyZHMgaW50byBmb2xkZXJzLlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgZm9sZGVyXG4gICAqL1xuICByZWFkb25seSBmb2xkZXI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNwZWNpZnkgYSBtYXBwaW5nIGZyb20gZGF0YSBzb3VyY2UgdmFyaWFibGVzIHRvIGRhdGEgc291cmNlIG5hbWVzLlxuICAgKiBUaGlzIGlzIG9ubHkgbmVlZGVkIGlmIHlvdSBhcmUgaW1wb3J0aW5nIGFuIGV4aXN0aW5nIGRhc2hib2FyZCdzIEpTT05cbiAgICogYW5kIGl0IHNwZWNpZmllcyB2YXJpYWJsZXMgd2l0aGluIGFuIFwiX19pbnB1dHNcIiBmaWVsZC5cbiAgICpcbiAgICogQGV4YW1wbGUgeyBEU19QUk9NRVRIRVVTOiBcIm15LXByb21ldGhldXMtZHNcIiB9XG4gICAqIEBkZWZhdWx0IC0gbm8gZGF0YSBzb3VyY2UgdmFyaWFibGVzXG4gICAqL1xuICByZWFkb25seSBkYXRhU291cmNlVmFyaWFibGVzPzogeyBbbmFtZTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIEF1dG8tcmVmcmVzaCBpbnRlcnZhbC5cbiAgICogQGRlZmF1bHQgLSA1IHNlY29uZHNcbiAgICovXG4gIHJlYWRvbmx5IHJlZnJlc2hSYXRlPzogRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRpbWUgcmFuZ2UgZm9yIHRoZSBkYXNoYm9hcmQsIGUuZy4gbGFzdCA2IGhvdXJzLCBsYXN0IDcgZGF5cywgZXRjLlxuICAgKiBAZGVmYXVsdCAtIDYgaG91cnNcbiAgICovXG4gIHJlYWRvbmx5IHRpbWVSYW5nZT86IER1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IHBsdWdpbnMgcmVxdWlyZWQgYnkgdGhlIGRhc2hib2FyZC5cbiAgICovXG4gIHJlYWRvbmx5IHBsdWdpbnM/OiBHcmFmYW5hUGx1Z2luW107XG5cbiAgLyoqXG4gICAqIExhYmVscyB0byBhcHBseSB0byB0aGUga3ViZXJuZXRlcyByZXNvdXJjZS5cbiAgICpcbiAgICogV2hlbiBhZGRpbmcgYSBkYXNoYm9hcmQgdG8gYSBHcmFmYW5hIGluc3RhbmNlIHVzaW5nIGBncmFmYW5hLmFkZERhc2hib2FyZGAsXG4gICAqIGxhYmVscyBwcm92aWRlZCB0byBHcmFmYW5hIHdpbGwgYmUgYXV0b21hdGljYWxseSBhcHBsaWVkLiBPdGhlcndpc2UsXG4gICAqIGxhYmVscyBtdXN0IGJlIGFkZGVkIG1hbnVhbGx5LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGxhYmVsc1xuICAgKi9cbiAgcmVhZG9ubHkgbGFiZWxzPzogeyBbbmFtZTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIE5hbWVzcGFjZSB0byBhcHBseSB0byB0aGUga3ViZXJuZXRlcyByZXNvdXJjZS5cbiAgICpcbiAgICogV2hlbiBhZGRpbmcgYSBkYXNoYm9hcmQgdG8gYSBHcmFmYW5hIGluc3RhbmNlIHVzaW5nIGBncmFmYW5hLmFkZERhc2hib2FyZGAsXG4gICAqIHRoZSBuYW1lc3BhY2Ugd2lsbCBiZSBhdXRvbWF0aWNhbGx5IGluaGVyaXRlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB1bmRlZmluZWQgKHdpbGwgYmUgYXNzaWduZWQgdG8gdGhlICdkZWZhdWx0JyBuYW1lc3BhY2UpXG4gICAqL1xuICByZWFkb25seSBuYW1lc3BhY2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFsbCBvdGhlciBkYXNoYm9hcmQgY3VzdG9taXphdGlvbnMuXG4gICAqIEBzZWUgaHR0cHM6Ly9ncmFmYW5hLmNvbS9kb2NzL2dyYWZhbmEvbGF0ZXN0L2Rhc2hib2FyZHMvanNvbi1tb2RlbC9cbiAgICovXG4gIHJlYWRvbmx5IGpzb25Nb2RlbD86IHsgW2tleTogc3RyaW5nXTogYW55IH07XG59XG5cbi8qKlxuICogQSBHcmFmYW5hIGRhc2hib2FyZC5cbiAqIEBzZWUgaHR0cHM6Ly9ncmFmYW5hLmNvbS9kb2NzL2dyYWZhbmEvbGF0ZXN0L2h0dHBfYXBpL2Rhc2hib2FyZC9cbiAqL1xuZXhwb3J0IGNsYXNzIERhc2hib2FyZCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcGx1Z2luczogR3JhZmFuYVBsdWdpbltdO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGFzaGJvYXJkUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5wbHVnaW5zID0gW107XG5cbiAgICBjb25zdCByZWZyZXNoUmF0ZSA9IHByb3BzLnJlZnJlc2hSYXRlID8/IER1cmF0aW9uLnNlY29uZHMoNSk7XG4gICAgY29uc3QgdGltZVJhbmdlID0gcHJvcHMudGltZVJhbmdlID8/IER1cmF0aW9uLmhvdXJzKDYpO1xuICAgIGNvbnN0IGRhdGFTb3VyY2VzID0gT2JqZWN0LmVudHJpZXMocHJvcHMuZGF0YVNvdXJjZVZhcmlhYmxlcyA/PyB7fSkubWFwKFxuICAgICAgKFt2YXJpYWJsZSwgbmFtZV0pID0+ICh7IGRhdGFzb3VyY2VOYW1lOiBuYW1lLCBpbnB1dE5hbWU6IHZhcmlhYmxlIH0pLFxuICAgICk7XG5cbiAgICBjb25zdCBkZWZhdWx0cyA9IHtcbiAgICAgIHRpdGxlOiBwcm9wcy50aXRsZSxcbiAgICAgIGlkOiBudWxsLFxuICAgICAgdGFnczogW10sXG4gICAgICBzdHlsZTogJ2RhcmsnLFxuICAgICAgdGltZXpvbmU6ICdicm93c2VyJyxcbiAgICAgIGVkaXRhYmxlOiB0cnVlLFxuICAgICAgaGlkZUNvbnRyb2xzOiBmYWxzZSxcbiAgICAgIGdyYXBoVG9vbHRpcDogMSxcbiAgICAgIHBhbmVsczogW10sXG4gICAgICB0aW1lOiB7XG4gICAgICAgIGZyb206IGBub3ctJHt0aW1lUmFuZ2UudG9TZWNvbmRzKCl9c2AsXG4gICAgICAgIHRvOiAnbm93JyxcbiAgICAgIH0sXG4gICAgICB0aW1lcGlja2VyOiB7XG4gICAgICAgIHRpbWVfb3B0aW9uczogW10sXG4gICAgICAgIHJlZnJlc2hfaW50ZXJ2YWxzOiBbXSxcbiAgICAgIH0sXG4gICAgICB0ZW1wbGF0aW5nOiB7XG4gICAgICAgIGxpc3Q6IFtdLFxuICAgICAgfSxcbiAgICAgIGFubm90YXRpb25zOiB7XG4gICAgICAgIGxpc3Q6IFtdLFxuICAgICAgfSxcbiAgICAgIHJlZnJlc2g6IGAke3JlZnJlc2hSYXRlLnRvU2Vjb25kcygpfXNgLFxuICAgICAgc2NoZW1hVmVyc2lvbjogMTcsXG4gICAgICB2ZXJzaW9uOiAwLFxuICAgICAgbGlua3M6IFtdLFxuICAgIH0gYXMgYW55O1xuXG4gICAgbmV3IEdyYWZhbmFEYXNoYm9hcmQodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiBwcm9wcy5sYWJlbHMsXG4gICAgICAgIG5hbWVzcGFjZTogcHJvcHMubmFtZXNwYWNlLFxuICAgICAgfSxcbiAgICAgIHNwZWM6IHtcbiAgICAgICAgY3VzdG9tRm9sZGVyTmFtZTogcHJvcHMuZm9sZGVyLFxuICAgICAgICBkYXRhc291cmNlczogZGF0YVNvdXJjZXMsXG4gICAgICAgIHBsdWdpbnM6IHRoaXMucGx1Z2lucyxcbiAgICAgICAganNvbjogSlNPTi5zdHJpbmdpZnkoe1xuICAgICAgICAgIC4uLmRlZmF1bHRzLFxuICAgICAgICAgIC4uLnByb3BzLmpzb25Nb2RlbCxcbiAgICAgICAgfSwgbnVsbCwgMiksXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgaWYgKHByb3BzLnBsdWdpbnMpIHtcbiAgICAgIHRoaXMuYWRkUGx1Z2lucyguLi5wcm9wcy5wbHVnaW5zKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBvbmUgb3IgbW9yZSBwbHVnaW5zLlxuICAgKi9cbiAgcHVibGljIGFkZFBsdWdpbnMoLi4ucGx1Z2luczogR3JhZmFuYVBsdWdpbltdKSB7XG4gICAgZm9yIChjb25zdCBwbHVnaW4gb2YgcGx1Z2lucykge1xuICAgICAgdGhpcy5wbHVnaW5zLnB1c2gocGx1Z2luKTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBHcmFmYW5hUGx1Z2luIHtcbiAgLyoqXG4gICAqIE5hbWUgb2YgdGhlIHBsdWdpbiwgZS5nLiBcImdyYWZhbmEtcGllY2hhcnQtcGFuZWxcIlxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIG9mIHRoZSBwbHVnaW4sIGUuZy4gXCIxLjMuNlwiXG4gICAqL1xuICByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmc7XG59XG4iXX0=